/* thumbnail.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from thumbnail.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libvirt-gconfig/libvirt-gconfig.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_THUMBNAIL (boxes_thumbnail_get_type ())
#define BOXES_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_THUMBNAIL, BoxesThumbnail))
#define BOXES_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_THUMBNAIL, BoxesThumbnailClass))
#define BOXES_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_THUMBNAIL))
#define BOXES_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_THUMBNAIL))
#define BOXES_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_THUMBNAIL, BoxesThumbnailClass))

typedef struct _BoxesThumbnail BoxesThumbnail;
typedef struct _BoxesThumbnailClass BoxesThumbnailClass;
typedef struct _BoxesThumbnailPrivate BoxesThumbnailPrivate;
enum  {
	BOXES_THUMBNAIL_0_PROPERTY,
	BOXES_THUMBNAIL_EMBLEM_SIZE_PROPERTY,
	BOXES_THUMBNAIL_NUM_PROPERTIES
};
static GParamSpec* boxes_thumbnail_properties[BOXES_THUMBNAIL_NUM_PROPERTIES];

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block57Data Block57Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define BOXES_TYPE_LIBVIRT_MACHINE (boxes_libvirt_machine_get_type ())
#define BOXES_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachine))
#define BOXES_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))
#define BOXES_IS_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_IS_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_LIBVIRT_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))

typedef struct _BoxesLibvirtMachine BoxesLibvirtMachine;
typedef struct _BoxesLibvirtMachineClass BoxesLibvirtMachineClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BoxesThumbnail {
	GtkBox parent_instance;
	BoxesThumbnailPrivate * priv;
};

struct _BoxesThumbnailClass {
	GtkBoxClass parent_class;
};

struct _BoxesThumbnailPrivate {
	GtkStack* stack;
	GtkSpinner* spinner_thumbnail;
	GtkImage* live_thumbnail;
	GtkBox* blank_thumbnail;
	GtkImage* emblem;
};

struct _Block57Data {
	int _ref_count_;
	BoxesThumbnail* self;
	BoxesMachine* machine;
};

static gint BoxesThumbnail_private_offset;
static gpointer boxes_thumbnail_parent_class = NULL;

VALA_EXTERN GType boxes_thumbnail_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesThumbnail, g_object_unref)
VALA_EXTERN GType boxes_collection_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionItem, g_object_unref)
VALA_EXTERN GType boxes_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMachine, g_object_unref)
VALA_EXTERN void boxes_thumbnail_update (BoxesThumbnail* self,
                             BoxesMachine* machine);
static Block57Data* block57_data_ref (Block57Data* _data57_);
static void block57_data_unref (void * _userdata_);
VALA_EXTERN gboolean boxes_machine_get_under_construction (BoxesMachine* self);
VALA_EXTERN GdkPixbuf* boxes_machine_get_pixbuf (BoxesMachine* self);
VALA_EXTERN gboolean boxes_machine_get_is_stopped (BoxesMachine* self);
VALA_EXTERN void boxes_machine_take_screenshot (BoxesMachine* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN GdkPixbuf* boxes_machine_take_screenshot_finish (BoxesMachine* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static void ___lambda61_ (Block57Data* _data57_,
                   GObject* source,
                   GAsyncResult* _result_);
static void ____lambda61__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN GType boxes_libvirt_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtMachine, g_object_unref)
VALA_EXTERN gboolean boxes_vm_configurator_is_live_config (GVirConfigDomain* domain);
VALA_EXTERN GVirConfigDomain* boxes_libvirt_machine_get_domain_config (BoxesLibvirtMachine* self);
static void boxes_thumbnail_set_emblem_icon_name (BoxesThumbnail* self,
                                           const gchar* value);
VALA_EXTERN BoxesThumbnail* boxes_thumbnail_new (void);
VALA_EXTERN BoxesThumbnail* boxes_thumbnail_construct (GType object_type);
VALA_EXTERN void boxes_thumbnail_set_emblem_size (BoxesThumbnail* self,
                                      gint value);
static void boxes_thumbnail_finalize (GObject * obj);
static GType boxes_thumbnail_get_type_once (void);
static void _vala_boxes_thumbnail_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
boxes_thumbnail_get_instance_private (BoxesThumbnail* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesThumbnail_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block57Data*
block57_data_ref (Block57Data* _data57_)
{
	g_atomic_int_inc (&_data57_->_ref_count_);
	return _data57_;
}

static void
block57_data_unref (void * _userdata_)
{
	Block57Data* _data57_;
	_data57_ = (Block57Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data57_->_ref_count_)) {
		BoxesThumbnail* self;
		self = _data57_->self;
		_g_object_unref0 (_data57_->machine);
		_g_object_unref0 (self);
		g_slice_free (Block57Data, _data57_);
	}
}

static void
___lambda61_ (Block57Data* _data57_,
              GObject* source,
              GAsyncResult* _result_)
{
	BoxesThumbnail* self;
	GError* _inner_error0_ = NULL;
	self = _data57_->self;
	g_return_if_fail (_result_ != NULL);
	{
		GdkPixbuf* screenshot = NULL;
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* scaled = NULL;
		GdkPixbuf* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		GdkPixbuf* _tmp7_;
		GtkImage* _tmp8_;
		GdkPixbuf* _tmp9_;
		GtkStack* _tmp10_;
		GtkImage* _tmp11_;
		_tmp0_ = boxes_machine_take_screenshot_finish (_data57_->machine, _result_, &_inner_error0_);
		screenshot = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = screenshot;
		if (_tmp1_ == NULL) {
			_g_object_unref0 (screenshot);
			return;
		}
		_tmp2_ = screenshot;
		g_object_get ((GtkWidget*) self, "width-request", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		g_object_get ((GtkWidget*) self, "height-request", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = gdk_pixbuf_scale_simple (_tmp2_, _tmp4_, _tmp6_, GDK_INTERP_BILINEAR);
		scaled = _tmp7_;
		_tmp8_ = self->priv->live_thumbnail;
		_tmp9_ = scaled;
		gtk_image_set_from_pixbuf (_tmp8_, _tmp9_);
		_tmp10_ = self->priv->stack;
		_tmp11_ = self->priv->live_thumbnail;
		gtk_stack_set_visible_child (_tmp10_, (GtkWidget*) _tmp11_);
		g_debug ("thumbnail.vala:47: Updating thumbnail with image!");
		_g_object_unref0 (scaled);
		_g_object_unref0 (screenshot);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_debug ("thumbnail.vala:49: %s", _tmp13_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda61__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda61_ (self, source_object, res);
	block57_data_unref (self);
}

void
boxes_thumbnail_update (BoxesThumbnail* self,
                        BoxesMachine* machine)
{
	Block57Data* _data57_;
	BoxesMachine* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_ = FALSE;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GtkStack* _tmp10_;
	GtkBox* _tmp11_;
	BoxesLibvirtMachine* libvirt_machine = NULL;
	BoxesLibvirtMachine* _tmp12_;
	BoxesLibvirtMachine* _tmp13_;
	GVirConfigDomain* _tmp14_;
	GVirConfigDomain* _tmp15_;
	GtkImage* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (machine != NULL);
	_data57_ = g_slice_new0 (Block57Data);
	_data57_->_ref_count_ = 1;
	_data57_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (machine);
	_g_object_unref0 (_data57_->machine);
	_data57_->machine = _tmp0_;
	_tmp1_ = boxes_machine_get_under_construction (_data57_->machine);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_;
		GtkSpinner* _tmp4_;
		_tmp3_ = self->priv->stack;
		_tmp4_ = self->priv->spinner_thumbnail;
		gtk_stack_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
		block57_data_unref (_data57_);
		_data57_ = NULL;
		return;
	}
	_tmp6_ = boxes_machine_get_pixbuf (_data57_->machine);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = boxes_machine_get_is_stopped (_data57_->machine);
		_tmp9_ = _tmp8_;
		_tmp5_ = !_tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		boxes_machine_take_screenshot (_data57_->machine, ____lambda61__gasync_ready_callback, block57_data_ref (_data57_));
		block57_data_unref (_data57_);
		_data57_ = NULL;
		return;
	}
	_tmp10_ = self->priv->stack;
	_tmp11_ = self->priv->blank_thumbnail;
	gtk_stack_set_visible_child (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = _g_object_ref0 (BOXES_IS_LIBVIRT_MACHINE (_data57_->machine) ? ((BoxesLibvirtMachine*) _data57_->machine) : NULL);
	libvirt_machine = _tmp12_;
	_tmp13_ = libvirt_machine;
	_tmp14_ = boxes_libvirt_machine_get_domain_config (_tmp13_);
	_tmp15_ = _tmp14_;
	if (boxes_vm_configurator_is_live_config (_tmp15_)) {
		boxes_thumbnail_set_emblem_icon_name (self, "media-optical");
	} else {
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = boxes_machine_get_is_stopped (_data57_->machine);
		_tmp17_ = _tmp16_;
		if (_tmp17_) {
			boxes_thumbnail_set_emblem_icon_name (self, "system-shutdown");
		} else {
			boxes_thumbnail_set_emblem_icon_name (self, "computer");
		}
	}
	_tmp18_ = self->priv->emblem;
	g_object_get (_tmp18_, "icon-name", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	g_debug ("thumbnail.vala:66: Updating thumbnail with '%s' icon!", _tmp21_);
	_g_free0 (_tmp21_);
	_g_object_unref0 (libvirt_machine);
	block57_data_unref (_data57_);
	_data57_ = NULL;
}

BoxesThumbnail*
boxes_thumbnail_construct (GType object_type)
{
	BoxesThumbnail * self = NULL;
	self = (BoxesThumbnail*) g_object_new (object_type, NULL);
	return self;
}

BoxesThumbnail*
boxes_thumbnail_new (void)
{
	return boxes_thumbnail_construct (BOXES_TYPE_THUMBNAIL);
}

static void
boxes_thumbnail_set_emblem_icon_name (BoxesThumbnail* self,
                                      const gchar* value)
{
	GtkImage* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->emblem;
	_tmp1_ = g_strconcat (value, "-symbolic", NULL);
	_tmp2_ = _tmp1_;
	g_object_set (_tmp0_, "icon-name", _tmp2_, NULL);
	_g_free0 (_tmp2_);
}

void
boxes_thumbnail_set_emblem_size (BoxesThumbnail* self,
                                 gint value)
{
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->emblem;
	g_object_set (_tmp0_, "icon-size", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, boxes_thumbnail_properties[BOXES_THUMBNAIL_EMBLEM_SIZE_PROPERTY]);
}

static void
boxes_thumbnail_class_init (BoxesThumbnailClass * klass,
                            gpointer klass_data)
{
	boxes_thumbnail_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesThumbnail_private_offset);
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_thumbnail_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_thumbnail_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_THUMBNAIL_EMBLEM_SIZE_PROPERTY, boxes_thumbnail_properties[BOXES_THUMBNAIL_EMBLEM_SIZE_PROPERTY] = g_param_spec_int ("emblem-size", "emblem-size", "emblem-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Boxes/ui/thumbnail.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, BoxesThumbnail_private_offset + G_STRUCT_OFFSET (BoxesThumbnailPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinner_thumbnail", FALSE, BoxesThumbnail_private_offset + G_STRUCT_OFFSET (BoxesThumbnailPrivate, spinner_thumbnail));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "live_thumbnail", FALSE, BoxesThumbnail_private_offset + G_STRUCT_OFFSET (BoxesThumbnailPrivate, live_thumbnail));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "blank_thumbnail", FALSE, BoxesThumbnail_private_offset + G_STRUCT_OFFSET (BoxesThumbnailPrivate, blank_thumbnail));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "emblem", FALSE, BoxesThumbnail_private_offset + G_STRUCT_OFFSET (BoxesThumbnailPrivate, emblem));
}

static void
boxes_thumbnail_instance_init (BoxesThumbnail * self,
                               gpointer klass)
{
	self->priv = boxes_thumbnail_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
boxes_thumbnail_finalize (GObject * obj)
{
	BoxesThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_THUMBNAIL, BoxesThumbnail);
	G_OBJECT_CLASS (boxes_thumbnail_parent_class)->finalize (obj);
}

static GType
boxes_thumbnail_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesThumbnail), 0, (GInstanceInitFunc) boxes_thumbnail_instance_init, NULL };
	GType boxes_thumbnail_type_id;
	boxes_thumbnail_type_id = g_type_register_static (gtk_box_get_type (), "BoxesThumbnail", &g_define_type_info, 0);
	BoxesThumbnail_private_offset = g_type_add_instance_private (boxes_thumbnail_type_id, sizeof (BoxesThumbnailPrivate));
	return boxes_thumbnail_type_id;
}

GType
boxes_thumbnail_get_type (void)
{
	static volatile gsize boxes_thumbnail_type_id__once = 0;
	if (g_once_init_enter (&boxes_thumbnail_type_id__once)) {
		GType boxes_thumbnail_type_id;
		boxes_thumbnail_type_id = boxes_thumbnail_get_type_once ();
		g_once_init_leave (&boxes_thumbnail_type_id__once, boxes_thumbnail_type_id);
	}
	return boxes_thumbnail_type_id__once;
}

static void
_vala_boxes_thumbnail_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	BoxesThumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_THUMBNAIL, BoxesThumbnail);
	switch (property_id) {
		case BOXES_THUMBNAIL_EMBLEM_SIZE_PROPERTY:
		boxes_thumbnail_set_emblem_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

