/* display-toolbar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from display-toolbar.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <atk/atk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_DISPLAY_TOOLBAR (boxes_display_toolbar_get_type ())
#define BOXES_DISPLAY_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY_TOOLBAR, BoxesDisplayToolbar))
#define BOXES_DISPLAY_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY_TOOLBAR, BoxesDisplayToolbarClass))
#define BOXES_IS_DISPLAY_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY_TOOLBAR))
#define BOXES_IS_DISPLAY_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY_TOOLBAR))
#define BOXES_DISPLAY_TOOLBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY_TOOLBAR, BoxesDisplayToolbarClass))

typedef struct _BoxesDisplayToolbar BoxesDisplayToolbar;
typedef struct _BoxesDisplayToolbarClass BoxesDisplayToolbarClass;
typedef struct _BoxesDisplayToolbarPrivate BoxesDisplayToolbarPrivate;

#define BOXES_TYPE_APP_WINDOW (boxes_app_window_get_type ())
#define BOXES_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindow))
#define BOXES_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))
#define BOXES_IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP_WINDOW))
#define BOXES_IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP_WINDOW))
#define BOXES_APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))

typedef struct _BoxesAppWindow BoxesAppWindow;
typedef struct _BoxesAppWindowClass BoxesAppWindowClass;
enum  {
	BOXES_DISPLAY_TOOLBAR_0_PROPERTY,
	BOXES_DISPLAY_TOOLBAR_OVERLAY_PROPERTY,
	BOXES_DISPLAY_TOOLBAR_HANDLE_DRAG_PROPERTY,
	BOXES_DISPLAY_TOOLBAR_PROGRESS_PROPERTY,
	BOXES_DISPLAY_TOOLBAR_NUM_PROPERTIES
};
static GParamSpec* boxes_display_toolbar_properties[BOXES_DISPLAY_TOOLBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block25Data Block25Data;

#define BOXES_TYPE_ACTIONS_POPOVER (boxes_actions_popover_get_type ())
#define BOXES_ACTIONS_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ACTIONS_POPOVER, BoxesActionsPopover))
#define BOXES_ACTIONS_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ACTIONS_POPOVER, BoxesActionsPopoverClass))
#define BOXES_IS_ACTIONS_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ACTIONS_POPOVER))
#define BOXES_IS_ACTIONS_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ACTIONS_POPOVER))
#define BOXES_ACTIONS_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ACTIONS_POPOVER, BoxesActionsPopoverClass))

typedef struct _BoxesActionsPopover BoxesActionsPopover;
typedef struct _BoxesActionsPopoverClass BoxesActionsPopoverClass;

#define BOXES_TYPE_APP (boxes_app_get_type ())
#define BOXES_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP, BoxesApp))
#define BOXES_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP, BoxesAppClass))
#define BOXES_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP))
#define BOXES_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP))
#define BOXES_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP, BoxesAppClass))

typedef struct _BoxesApp BoxesApp;
typedef struct _BoxesAppClass BoxesAppClass;

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;
typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES,
	BOXES_UI_STATE_TROUBLESHOOT
} BoxesUIState;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;

#define BOXES_TYPE_KEYS_INPUT_POPOVER (boxes_keys_input_popover_get_type ())
#define BOXES_KEYS_INPUT_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_KEYS_INPUT_POPOVER, BoxesKeysInputPopover))
#define BOXES_KEYS_INPUT_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_KEYS_INPUT_POPOVER, BoxesKeysInputPopoverClass))
#define BOXES_IS_KEYS_INPUT_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_KEYS_INPUT_POPOVER))
#define BOXES_IS_KEYS_INPUT_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_KEYS_INPUT_POPOVER))
#define BOXES_KEYS_INPUT_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_KEYS_INPUT_POPOVER, BoxesKeysInputPopoverClass))

typedef struct _BoxesKeysInputPopover BoxesKeysInputPopover;
typedef struct _BoxesKeysInputPopoverClass BoxesKeysInputPopoverClass;
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define __vala_GdkEventMotion_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventMotion_free (var), NULL)))
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;

struct _BoxesDisplayToolbar {
	HdyHeaderBar parent_instance;
	BoxesDisplayToolbarPrivate * priv;
	GtkButton* transfers_button;
};

struct _BoxesDisplayToolbarClass {
	HdyHeaderBarClass parent_class;
};

struct _BoxesDisplayToolbarPrivate {
	gboolean _overlay;
	gboolean _handle_drag;
	GtkImage* fullscreen_image;
	GtkDrawingArea* transfers_drawing_area;
	GtkButton* back;
	GtkButton* fullscreen;
	GtkMenuButton* menu_button;
	GtkMenuButton* keys_menu_button;
	BoxesAppWindow* window;
	gdouble _progress;
	gboolean button_down;
	gint button_down_x;
	gint button_down_y;
	guint button_down_button;
};

struct _Block25Data {
	int _ref_count_;
	BoxesDisplayToolbar* self;
	BoxesAppWindow* window;
};

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _Block26Data {
	int _ref_count_;
	BoxesDisplayToolbar* self;
	GdkEventMotion* event;
};

struct _Block27Data {
	int _ref_count_;
	Block26Data * _data26_;
	GtkWindow* window;
	gint old_width;
	gulong id;
};

static gint BoxesDisplayToolbar_private_offset;
static gpointer boxes_display_toolbar_parent_class = NULL;
VALA_EXTERN BoxesApp* boxes_app_app;

VALA_EXTERN GType boxes_display_toolbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDisplayToolbar, g_object_unref)
VALA_EXTERN GType boxes_app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAppWindow, g_object_unref)
VALA_EXTERN BoxesDisplayToolbar* boxes_display_toolbar_new (gboolean overlay,
                                                gboolean handle_drag);
VALA_EXTERN BoxesDisplayToolbar* boxes_display_toolbar_construct (GType object_type,
                                                      gboolean overlay,
                                                      gboolean handle_drag);
VALA_EXTERN void boxes_display_toolbar_setup_ui (BoxesDisplayToolbar* self,
                                     BoxesAppWindow* window);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
VALA_EXTERN BoxesActionsPopover* boxes_actions_popover_new (BoxesAppWindow* window);
VALA_EXTERN BoxesActionsPopover* boxes_actions_popover_construct (GType object_type,
                                                      BoxesAppWindow* window);
VALA_EXTERN GType boxes_actions_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesActionsPopover, g_object_unref)
VALA_EXTERN GType boxes_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesApp, g_object_unref)
static void __lambda88_ (Block25Data* _data25_);
VALA_EXTERN BoxesAppWindow* boxes_app_get_main_window (BoxesApp* self);
static void ___lambda88__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda89_ (Block25Data* _data25_);
VALA_EXTERN GType boxes_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesUI, g_object_unref)
VALA_EXTERN BoxesUIState boxes_ui_get_ui_state (BoxesUI* self);
VALA_EXTERN GType boxes_collection_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionItem, g_object_unref)
VALA_EXTERN void boxes_actions_popover_update_for_item (BoxesActionsPopover* self,
                                            BoxesCollectionItem* item);
VALA_EXTERN BoxesCollectionItem* boxes_app_window_get_current_item (BoxesAppWindow* self);
static void ___lambda89__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN BoxesKeysInputPopover* boxes_keys_input_popover_new (BoxesAppWindow* window);
VALA_EXTERN BoxesKeysInputPopover* boxes_keys_input_popover_construct (GType object_type,
                                                           BoxesAppWindow* window);
VALA_EXTERN GType boxes_keys_input_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesKeysInputPopover, g_object_unref)
static gboolean boxes_display_toolbar_on_draw (BoxesDisplayToolbar* self,
                                        GtkWidget* da,
                                        cairo_t* ctx);
static gboolean _boxes_display_toolbar_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                         cairo_t* cr,
                                                         gpointer self);
static void __lambda90_ (Block25Data* _data25_);
VALA_EXTERN gboolean boxes_app_window_get_fullscreened (BoxesAppWindow* self);
static void ___lambda90__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean boxes_display_toolbar_real_button_press_event (GtkWidget* base,
                                                        GdkEventButton* event);
VALA_EXTERN gboolean boxes_display_toolbar_get_handle_drag (BoxesDisplayToolbar* self);
static GdkEvent* _vala_GdkEvent_copy (GdkEvent* self);
static void _vala_GdkEvent_free (GdkEvent* self);
static gboolean boxes_display_toolbar_real_button_release_event (GtkWidget* base,
                                                          GdkEventButton* event);
static gboolean boxes_display_toolbar_real_motion_notify_event (GtkWidget* base,
                                                         GdkEventMotion* event);
static GdkEventMotion* _vala_GdkEventMotion_copy (GdkEventMotion* self);
static void _vala_GdkEventMotion_free (GdkEventMotion* self);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
VALA_EXTERN void boxes_app_window_set_fullscreened (BoxesAppWindow* self,
                                        gboolean value);
static void ____lambda91_ (Block27Data* _data27_);
static void _____lambda91__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
static void boxes_display_toolbar_on_back_clicked (BoxesDisplayToolbar* self);
VALA_EXTERN void boxes_ui_set_state (BoxesUI* self,
                         BoxesUIState new_state);
static void _boxes_display_toolbar_on_back_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void boxes_display_toolbar_on_fullscreen_clicked (BoxesDisplayToolbar* self);
static void _boxes_display_toolbar_on_fullscreen_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
VALA_EXTERN gboolean boxes_display_toolbar_get_overlay (BoxesDisplayToolbar* self);
static void boxes_display_toolbar_set_overlay (BoxesDisplayToolbar* self,
                                        gboolean value);
static void boxes_display_toolbar_set_handle_drag (BoxesDisplayToolbar* self,
                                            gboolean value);
VALA_EXTERN gdouble boxes_display_toolbar_get_progress (BoxesDisplayToolbar* self);
VALA_EXTERN void boxes_display_toolbar_set_progress (BoxesDisplayToolbar* self,
                                         gdouble value);
static GObject * boxes_display_toolbar_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void boxes_display_toolbar_finalize (GObject * obj);
static GType boxes_display_toolbar_get_type_once (void);
static void _vala_boxes_display_toolbar_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_boxes_display_toolbar_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
boxes_display_toolbar_get_instance_private (BoxesDisplayToolbar* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesDisplayToolbar_private_offset);
}

BoxesDisplayToolbar*
boxes_display_toolbar_construct (GType object_type,
                                 gboolean overlay,
                                 gboolean handle_drag)
{
	BoxesDisplayToolbar * self = NULL;
	self = (BoxesDisplayToolbar*) g_object_new (object_type, "overlay", overlay, "handle-drag", handle_drag, NULL);
	return self;
}

BoxesDisplayToolbar*
boxes_display_toolbar_new (gboolean overlay,
                           gboolean handle_drag)
{
	return boxes_display_toolbar_construct (BOXES_TYPE_DISPLAY_TOOLBAR, overlay, handle_drag);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		BoxesDisplayToolbar* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->window);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
__lambda88_ (Block25Data* _data25_)
{
	BoxesDisplayToolbar* self;
	GtkButton* _tmp0_;
	BoxesApp* _tmp1_;
	BoxesAppWindow* _tmp2_;
	BoxesAppWindow* _tmp3_;
	self = _data25_->self;
	_tmp0_ = self->priv->back;
	_tmp1_ = boxes_app_app;
	_tmp2_ = boxes_app_get_main_window (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _data25_->window == _tmp3_);
}

static void
___lambda88__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda88_ (self);
}

static void
__lambda89_ (Block25Data* _data25_)
{
	BoxesDisplayToolbar* self;
	BoxesUIState _tmp0_;
	BoxesUIState _tmp1_;
	self = _data25_->self;
	_tmp0_ = boxes_ui_get_ui_state ((BoxesUI*) _data25_->window);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == BOXES_UI_STATE_DISPLAY) {
		BoxesActionsPopover* actions_popover = NULL;
		GtkMenuButton* _tmp2_;
		GtkPopover* _tmp3_;
		GtkPopover* _tmp4_;
		BoxesActionsPopover* _tmp5_;
		BoxesActionsPopover* _tmp6_;
		BoxesCollectionItem* _tmp7_;
		BoxesCollectionItem* _tmp8_;
		_tmp2_ = self->priv->menu_button;
		_tmp3_ = gtk_menu_button_get_popover (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (BOXES_IS_ACTIONS_POPOVER (_tmp4_) ? ((BoxesActionsPopover*) _tmp4_) : NULL);
		actions_popover = _tmp5_;
		_tmp6_ = actions_popover;
		_tmp7_ = boxes_app_window_get_current_item (_data25_->window);
		_tmp8_ = _tmp7_;
		boxes_actions_popover_update_for_item (_tmp6_, _tmp8_);
		_g_object_unref0 (actions_popover);
	}
}

static void
___lambda89__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda89_ (self);
}

static gboolean
_boxes_display_toolbar_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                cairo_t* cr,
                                                gpointer self)
{
	gboolean result;
	result = boxes_display_toolbar_on_draw ((BoxesDisplayToolbar*) self, _sender, cr);
	return result;
}

static void
__lambda90_ (Block25Data* _data25_)
{
	BoxesDisplayToolbar* self;
	AtkObject* a11y = NULL;
	GtkButton* _tmp0_;
	AtkObject* _tmp1_;
	AtkObject* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	self = _data25_->self;
	_tmp0_ = self->priv->fullscreen;
	_tmp1_ = gtk_widget_get_accessible ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	a11y = _tmp2_;
	_tmp3_ = boxes_app_window_get_fullscreened (_data25_->window);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkImage* _tmp5_;
		AtkObject* _tmp6_;
		_tmp5_ = self->priv->fullscreen_image;
		g_object_set (_tmp5_, "icon-name", "view-restore-symbolic", NULL);
		_tmp6_ = a11y;
		g_object_set (_tmp6_, "accessible-name", _ ("Exit fullscreen"), NULL);
	} else {
		GtkImage* _tmp7_;
		AtkObject* _tmp8_;
		_tmp7_ = self->priv->fullscreen_image;
		g_object_set (_tmp7_, "icon-name", "view-fullscreen-symbolic", NULL);
		_tmp8_ = a11y;
		g_object_set (_tmp8_, "accessible-name", _ ("Fullscreen"), NULL);
	}
	_g_object_unref0 (a11y);
}

static void
___lambda90__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda90_ (self);
}

void
boxes_display_toolbar_setup_ui (BoxesDisplayToolbar* self,
                                BoxesAppWindow* window)
{
	Block25Data* _data25_;
	BoxesAppWindow* _tmp0_;
	BoxesAppWindow* _tmp1_;
	GtkMenuButton* _tmp2_;
	BoxesActionsPopover* _tmp3_;
	BoxesActionsPopover* _tmp4_;
	BoxesApp* _tmp5_;
	GtkMenuButton* _tmp6_;
	BoxesKeysInputPopover* _tmp7_;
	BoxesKeysInputPopover* _tmp8_;
	GtkDrawingArea* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data25_->window);
	_data25_->window = _tmp0_;
	_tmp1_ = _g_object_ref0 (_data25_->window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp1_;
	_tmp2_ = self->priv->menu_button;
	_tmp3_ = boxes_actions_popover_new (_data25_->window);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	gtk_menu_button_set_popover (_tmp2_, (GtkPopover*) _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = boxes_app_app;
	g_signal_connect_data ((GObject*) _tmp5_, "notify::main-window", (GCallback) ___lambda88__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	g_signal_connect_data ((GObject*) _data25_->window, "notify::ui-state", (GCallback) ___lambda89__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp6_ = self->priv->keys_menu_button;
	_tmp7_ = boxes_keys_input_popover_new (_data25_->window);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	gtk_menu_button_set_popover (_tmp6_, (GtkPopover*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->transfers_drawing_area;
	g_signal_connect_object ((GtkWidget*) _tmp9_, "draw", (GCallback) _boxes_display_toolbar_on_draw_gtk_widget_draw, self, 0);
	g_signal_connect_data ((GObject*) _data25_->window, "notify::fullscreened", (GCallback) ___lambda90__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, G_CONNECT_AFTER);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static gboolean
boxes_display_toolbar_on_draw (BoxesDisplayToolbar* self,
                               GtkWidget* da,
                               cairo_t* ctx)
{
	gint width = 0;
	GtkDrawingArea* _tmp0_;
	gint height = 0;
	GtkDrawingArea* _tmp1_;
	GtkStyleContext* style_context = NULL;
	GtkButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GdkRGBA foreground = {0};
	GtkButton* _tmp5_;
	GdkRGBA _tmp6_ = {0};
	GdkRGBA background = {0};
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	GdkRGBA _tmp9_;
	GdkRGBA _tmp10_;
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	GdkRGBA _tmp13_;
	GdkRGBA _tmp14_;
	GdkRGBA _tmp15_;
	gdouble radians = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->transfers_drawing_area;
	width = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->transfers_drawing_area;
	height = gtk_widget_get_allocated_height ((GtkWidget*) _tmp1_);
	cairo_set_line_join (ctx, CAIRO_LINE_JOIN_ROUND);
	_tmp2_ = self->transfers_button;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	style_context = _tmp4_;
	_tmp5_ = self->transfers_button;
	gtk_style_context_get_color (style_context, gtk_widget_get_state_flags ((GtkWidget*) _tmp5_), &_tmp6_);
	foreground = _tmp6_;
	_tmp7_ = foreground;
	background = _tmp7_;
	background.alpha = background.alpha * 0.3;
	_tmp8_ = background;
	_tmp9_ = background;
	_tmp10_ = background;
	_tmp11_ = background;
	cairo_set_source_rgba (ctx, _tmp8_.red, _tmp9_.green, _tmp10_.blue, _tmp11_.alpha);
	cairo_arc (ctx, (gdouble) (width / 2), (gdouble) (height / 2), (gdouble) (height / 3), (-G_PI) / 2, (3 * G_PI) / 2);
	cairo_fill (ctx);
	cairo_move_to (ctx, (gdouble) (width / 2), (gdouble) (height / 2));
	_tmp12_ = foreground;
	_tmp13_ = foreground;
	_tmp14_ = foreground;
	_tmp15_ = foreground;
	cairo_set_source_rgba (ctx, _tmp12_.red, _tmp13_.green, _tmp14_.blue, _tmp15_.alpha);
	radians = ((-G_PI) / 2) + ((2 * G_PI) * self->priv->_progress);
	cairo_arc (ctx, (gdouble) (width / 2), (gdouble) (height / 2), (gdouble) (height / 3), (-G_PI) / 2, radians);
	cairo_fill (ctx);
	result = TRUE;
	_g_object_unref0 (style_context);
	return result;
}

static GdkEvent*
_vala_GdkEvent_copy (GdkEvent* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEvent_copy0 (gpointer self)
{
	return self ? _vala_GdkEvent_copy (self) : NULL;
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static gboolean
boxes_display_toolbar_real_button_press_event (GtkWidget* base,
                                               GdkEventButton* event)
{
	BoxesDisplayToolbar * self;
	gboolean res = FALSE;
	gboolean _tmp0_;
	GdkEvent* base_event = NULL;
	GdkEvent* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	self = (BoxesDisplayToolbar*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	res = GTK_WIDGET_CLASS (boxes_display_toolbar_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_header_bar_get_type (), HdyHeaderBar), event);
	_tmp0_ = self->priv->_handle_drag;
	if (!_tmp0_) {
		result = res;
		return result;
	}
	_tmp1_ = __vala_GdkEvent_copy0 ((GdkEvent*) event);
	base_event = _tmp1_;
	if (!res) {
		GdkEvent* _tmp3_;
		_tmp3_ = base_event;
		_tmp2_ = !gdk_event_triggers_context_menu (_tmp3_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		self->priv->button_down = TRUE;
		self->priv->button_down_button = event->button;
		self->priv->button_down_x = (gint) event->x;
		self->priv->button_down_y = (gint) event->y;
	}
	result = res;
	__vala_GdkEvent_free0 (base_event);
	return result;
}

static gboolean
boxes_display_toolbar_real_button_release_event (GtkWidget* base,
                                                 GdkEventButton* event)
{
	BoxesDisplayToolbar * self;
	gboolean result;
	self = (BoxesDisplayToolbar*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->button_down = FALSE;
	result = GTK_WIDGET_CLASS (boxes_display_toolbar_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_header_bar_get_type (), HdyHeaderBar), event);
	return result;
}

static GdkEventMotion*
_vala_GdkEventMotion_copy (GdkEventMotion* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}

static gpointer
__vala_GdkEventMotion_copy0 (gpointer self)
{
	return self ? _vala_GdkEventMotion_copy (self) : NULL;
}

static void
_vala_GdkEventMotion_free (GdkEventMotion* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		BoxesDisplayToolbar* self;
		self = _data26_->self;
		__vala_GdkEventMotion_free0 (_data26_->event);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		BoxesDisplayToolbar* self;
		self = _data27_->_data26_->self;
		_g_object_unref0 (_data27_->window);
		block26_data_unref (_data27_->_data26_);
		_data27_->_data26_ = NULL;
		g_slice_free (Block27Data, _data27_);
	}
}

static void
____lambda91_ (Block27Data* _data27_)
{
	Block26Data* _data26_;
	BoxesDisplayToolbar* self;
	gint root_x = 0;
	gint root_y = 0;
	gint width = 0;
	GtkWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkWindow* _tmp3_;
	GdkWindow* _tmp4_;
	gint _tmp5_ = 0;
	GtkWindow* _tmp6_;
	BoxesApp* _tmp7_;
	_data26_ = _data27_->_data26_;
	self = _data26_->self;
	_tmp0_ = _data27_->window;
	gtk_window_get_position (_tmp0_, &_tmp1_, &_tmp2_);
	root_x = _tmp1_;
	root_y = _tmp2_;
	_tmp3_ = _data27_->window;
	_tmp4_ = gtk_widget_get_window ((GtkWidget*) _tmp3_);
	gdk_window_get_geometry (_tmp4_, NULL, NULL, &_tmp5_, NULL);
	width = _tmp5_;
	_tmp6_ = _data27_->window;
	gtk_window_begin_move_drag (_tmp6_, (gint) self->priv->button_down_button, root_x + ((gint) ((self->priv->button_down_x / ((gdouble) _data27_->old_width)) * width)), root_y + self->priv->button_down_y, _data26_->event->time);
	_tmp7_ = boxes_app_app;
	g_signal_handler_disconnect ((GObject*) _tmp7_, _data27_->id);
}

static void
_____lambda91__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	____lambda91_ (self);
}

static gboolean
boxes_display_toolbar_real_motion_notify_event (GtkWidget* base,
                                                GdkEventMotion* event)
{
	BoxesDisplayToolbar * self;
	Block26Data* _data26_;
	GdkEventMotion* _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self = (BoxesDisplayToolbar*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	_tmp0_ = __vala_GdkEventMotion_copy0 (event);
	__vala_GdkEventMotion_free0 (_data26_->event);
	_data26_->event = _tmp0_;
	_tmp1_ = self->priv->_handle_drag;
	if (!_tmp1_) {
		result = GTK_WIDGET_CLASS (boxes_display_toolbar_parent_class)->motion_notify_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_header_bar_get_type (), HdyHeaderBar), _data26_->event);
		block26_data_unref (_data26_);
		_data26_ = NULL;
		return result;
	}
	if (self->priv->button_down) {
		gdouble dx = 0.0;
		gdouble dy = 0.0;
		dx = _data26_->event->x - self->priv->button_down_x;
		dy = _data26_->event->y - self->priv->button_down_y;
		if (((dx * dx) + (dy * dy)) > ((gdouble) (40 * 40))) {
			Block27Data* _data27_;
			BoxesAppWindow* _tmp2_;
			GtkWidget* _tmp3_;
			GtkWindow* _tmp4_;
			GtkWindow* _tmp5_;
			gint _tmp6_ = 0;
			BoxesApp* _tmp7_;
			gulong _tmp8_;
			_data27_ = g_slice_new0 (Block27Data);
			_data27_->_ref_count_ = 1;
			_data27_->_data26_ = block26_data_ref (_data26_);
			self->priv->button_down = FALSE;
			_tmp2_ = self->priv->window;
			boxes_app_window_set_fullscreened (_tmp2_, FALSE);
			_tmp3_ = gtk_widget_get_toplevel ((GtkWidget*) self);
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL);
			_data27_->window = _tmp4_;
			_tmp5_ = _data27_->window;
			gtk_window_get_size (_tmp5_, &_tmp6_, NULL);
			_data27_->old_width = _tmp6_;
			_data27_->id = (gulong) 0;
			_tmp7_ = boxes_app_app;
			_tmp8_ = g_signal_connect_data ((GObject*) _tmp7_, "notify::fullscreened", (GCallback) _____lambda91__g_object_notify, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
			_data27_->id = _tmp8_;
			block27_data_unref (_data27_);
			_data27_ = NULL;
		}
	}
	if (GTK_WIDGET_CLASS (boxes_display_toolbar_parent_class)->motion_notify_event != NULL) {
		result = GTK_WIDGET_CLASS (boxes_display_toolbar_parent_class)->motion_notify_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_header_bar_get_type (), HdyHeaderBar), _data26_->event);
		block26_data_unref (_data26_);
		_data26_ = NULL;
		return result;
	}
	result = FALSE;
	block26_data_unref (_data26_);
	_data26_ = NULL;
	return result;
}

static void
boxes_display_toolbar_on_back_clicked (BoxesDisplayToolbar* self)
{
	BoxesAppWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	boxes_ui_set_state ((BoxesUI*) _tmp0_, BOXES_UI_STATE_COLLECTION);
}

static void
_boxes_display_toolbar_on_back_clicked_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	boxes_display_toolbar_on_back_clicked ((BoxesDisplayToolbar*) self);
}

static void
boxes_display_toolbar_on_fullscreen_clicked (BoxesDisplayToolbar* self)
{
	BoxesAppWindow* _tmp0_;
	BoxesAppWindow* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->window;
	_tmp2_ = boxes_app_window_get_fullscreened (_tmp1_);
	_tmp3_ = _tmp2_;
	boxes_app_window_set_fullscreened (_tmp0_, !_tmp3_);
}

static void
_boxes_display_toolbar_on_fullscreen_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	boxes_display_toolbar_on_fullscreen_clicked ((BoxesDisplayToolbar*) self);
}

gboolean
boxes_display_toolbar_get_overlay (BoxesDisplayToolbar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overlay;
	return result;
}

static void
boxes_display_toolbar_set_overlay (BoxesDisplayToolbar* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_toolbar_get_overlay (self);
	if (old_value != value) {
		self->priv->_overlay = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_toolbar_properties[BOXES_DISPLAY_TOOLBAR_OVERLAY_PROPERTY]);
	}
}

gboolean
boxes_display_toolbar_get_handle_drag (BoxesDisplayToolbar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_handle_drag;
	return result;
}

static void
boxes_display_toolbar_set_handle_drag (BoxesDisplayToolbar* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_display_toolbar_get_handle_drag (self);
	if (old_value != value) {
		self->priv->_handle_drag = value;
		g_object_notify_by_pspec ((GObject *) self, boxes_display_toolbar_properties[BOXES_DISPLAY_TOOLBAR_HANDLE_DRAG_PROPERTY]);
	}
}

gdouble
boxes_display_toolbar_get_progress (BoxesDisplayToolbar* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_progress;
	return result;
}

void
boxes_display_toolbar_set_progress (BoxesDisplayToolbar* self,
                                    gdouble value)
{
	GtkButton* _tmp0_;
	GtkDrawingArea* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->transfers_button;
	if (!gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		GtkButton* _tmp1_;
		_tmp1_ = self->transfers_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	}
	self->priv->_progress = value;
	_tmp2_ = self->priv->transfers_drawing_area;
	gtk_widget_queue_draw ((GtkWidget*) _tmp2_);
	g_object_notify_by_pspec ((GObject *) self, boxes_display_toolbar_properties[BOXES_DISPLAY_TOOLBAR_PROGRESS_PROPERTY]);
}

static GObject *
boxes_display_toolbar_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesDisplayToolbar * self;
	gboolean _tmp0_;
	gboolean _tmp3_;
	parent_class = G_OBJECT_CLASS (boxes_display_toolbar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DISPLAY_TOOLBAR, BoxesDisplayToolbar);
	gtk_widget_add_events ((GtkWidget*) self, (gint) ((GDK_POINTER_MOTION_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK));
	_tmp0_ = self->priv->_overlay;
	if (_tmp0_) {
		GtkStyleContext* _tmp1_;
		GtkStyleContext* _tmp2_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp1_, GTK_STYLE_CLASS_TOOLBAR);
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_OSD);
	} else {
		hdy_header_bar_set_show_close_button ((HdyHeaderBar*) self, TRUE);
	}
	_tmp3_ = self->priv->_overlay;
	if (!_tmp3_) {
		GtkButton* _tmp4_;
		GtkStyleContext* _tmp5_;
		GtkButton* _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkMenuButton* _tmp8_;
		GtkStyleContext* _tmp9_;
		GtkMenuButton* _tmp10_;
		GtkStyleContext* _tmp11_;
		_tmp4_ = self->priv->back;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		gtk_style_context_add_class (_tmp5_, GTK_STYLE_CLASS_RAISED);
		_tmp6_ = self->priv->fullscreen;
		_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
		gtk_style_context_add_class (_tmp7_, GTK_STYLE_CLASS_RAISED);
		_tmp8_ = self->priv->menu_button;
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
		gtk_style_context_add_class (_tmp9_, GTK_STYLE_CLASS_RAISED);
		_tmp10_ = self->priv->keys_menu_button;
		_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
		gtk_style_context_add_class (_tmp11_, GTK_STYLE_CLASS_RAISED);
	}
	return obj;
}

static void
boxes_display_toolbar_class_init (BoxesDisplayToolbarClass * klass,
                                  gpointer klass_data)
{
	boxes_display_toolbar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesDisplayToolbar_private_offset);
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) boxes_display_toolbar_real_button_press_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget*, GdkEventButton*)) boxes_display_toolbar_real_button_release_event;
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget*, GdkEventMotion*)) boxes_display_toolbar_real_motion_notify_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_display_toolbar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_display_toolbar_set_property;
	G_OBJECT_CLASS (klass)->constructor = boxes_display_toolbar_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_display_toolbar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_TOOLBAR_OVERLAY_PROPERTY, boxes_display_toolbar_properties[BOXES_DISPLAY_TOOLBAR_OVERLAY_PROPERTY] = g_param_spec_boolean ("overlay", "overlay", "overlay", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_TOOLBAR_HANDLE_DRAG_PROPERTY, boxes_display_toolbar_properties[BOXES_DISPLAY_TOOLBAR_HANDLE_DRAG_PROPERTY] = g_param_spec_boolean ("handle-drag", "handle-drag", "handle-drag", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_DISPLAY_TOOLBAR_PROGRESS_PROPERTY, boxes_display_toolbar_properties[BOXES_DISPLAY_TOOLBAR_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Boxes/ui/display-toolbar.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fullscreen_image", FALSE, BoxesDisplayToolbar_private_offset + G_STRUCT_OFFSET (BoxesDisplayToolbarPrivate, fullscreen_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transfers_drawing_area", FALSE, BoxesDisplayToolbar_private_offset + G_STRUCT_OFFSET (BoxesDisplayToolbarPrivate, transfers_drawing_area));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "transfers_button", FALSE, G_STRUCT_OFFSET (BoxesDisplayToolbar, transfers_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back", FALSE, BoxesDisplayToolbar_private_offset + G_STRUCT_OFFSET (BoxesDisplayToolbarPrivate, back));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fullscreen", FALSE, BoxesDisplayToolbar_private_offset + G_STRUCT_OFFSET (BoxesDisplayToolbarPrivate, fullscreen));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, BoxesDisplayToolbar_private_offset + G_STRUCT_OFFSET (BoxesDisplayToolbarPrivate, menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "keys_menu_button", FALSE, BoxesDisplayToolbar_private_offset + G_STRUCT_OFFSET (BoxesDisplayToolbarPrivate, keys_menu_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_back_clicked", G_CALLBACK(_boxes_display_toolbar_on_back_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_fullscreen_clicked", G_CALLBACK(_boxes_display_toolbar_on_fullscreen_clicked_gtk_button_clicked));
}

static void
boxes_display_toolbar_instance_init (BoxesDisplayToolbar * self,
                                     gpointer klass)
{
	self->priv = boxes_display_toolbar_get_instance_private (self);
	self->priv->_progress = (gdouble) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
boxes_display_toolbar_finalize (GObject * obj)
{
	BoxesDisplayToolbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DISPLAY_TOOLBAR, BoxesDisplayToolbar);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (boxes_display_toolbar_parent_class)->finalize (obj);
}

static GType
boxes_display_toolbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesDisplayToolbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_display_toolbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesDisplayToolbar), 0, (GInstanceInitFunc) boxes_display_toolbar_instance_init, NULL };
	GType boxes_display_toolbar_type_id;
	boxes_display_toolbar_type_id = g_type_register_static (hdy_header_bar_get_type (), "BoxesDisplayToolbar", &g_define_type_info, 0);
	BoxesDisplayToolbar_private_offset = g_type_add_instance_private (boxes_display_toolbar_type_id, sizeof (BoxesDisplayToolbarPrivate));
	return boxes_display_toolbar_type_id;
}

GType
boxes_display_toolbar_get_type (void)
{
	static volatile gsize boxes_display_toolbar_type_id__once = 0;
	if (g_once_init_enter (&boxes_display_toolbar_type_id__once)) {
		GType boxes_display_toolbar_type_id;
		boxes_display_toolbar_type_id = boxes_display_toolbar_get_type_once ();
		g_once_init_leave (&boxes_display_toolbar_type_id__once, boxes_display_toolbar_type_id);
	}
	return boxes_display_toolbar_type_id__once;
}

static void
_vala_boxes_display_toolbar_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	BoxesDisplayToolbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_DISPLAY_TOOLBAR, BoxesDisplayToolbar);
	switch (property_id) {
		case BOXES_DISPLAY_TOOLBAR_OVERLAY_PROPERTY:
		g_value_set_boolean (value, boxes_display_toolbar_get_overlay (self));
		break;
		case BOXES_DISPLAY_TOOLBAR_HANDLE_DRAG_PROPERTY:
		g_value_set_boolean (value, boxes_display_toolbar_get_handle_drag (self));
		break;
		case BOXES_DISPLAY_TOOLBAR_PROGRESS_PROPERTY:
		g_value_set_double (value, boxes_display_toolbar_get_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_display_toolbar_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	BoxesDisplayToolbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_DISPLAY_TOOLBAR, BoxesDisplayToolbar);
	switch (property_id) {
		case BOXES_DISPLAY_TOOLBAR_OVERLAY_PROPERTY:
		boxes_display_toolbar_set_overlay (self, g_value_get_boolean (value));
		break;
		case BOXES_DISPLAY_TOOLBAR_HANDLE_DRAG_PROPERTY:
		boxes_display_toolbar_set_handle_drag (self, g_value_get_boolean (value));
		break;
		case BOXES_DISPLAY_TOOLBAR_PROGRESS_PROPERTY:
		boxes_display_toolbar_set_progress (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

