// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_extension_structs
//
// (impl) generated by codegen/vulkan/vulkan-docs/scripts/genvk.py -registry
// codegen/vulkan/vulkan-docs/xml/vk.xml -registryGfxstream
// codegen/vulkan/vulkan-docs/xml/vk_gfxstream.xml cereal -o host/vulkan/cereal
//
// Please do not modify directly;
// re-run gfxstream-protocols/scripts/generate-vulkan-sources.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o
// $CEREAL_OUTPUT_DIR
//

#include <stdio.h>
#include "goldfish_vk_extension_structs.h"
namespace gfxstream {
namespace vk {

#ifdef VK_VERSION_1_0
#endif
#ifdef VK_VERSION_1_1
#endif
#ifdef VK_VERSION_1_2
#endif
#ifdef VK_VERSION_1_3
#endif
#ifdef VK_KHR_surface
#endif
#ifdef VK_KHR_swapchain
#endif
#ifdef VK_KHR_xcb_surface
#endif
#ifdef VK_KHR_android_surface
#endif
#ifdef VK_KHR_win32_surface
#endif
#ifdef VK_KHR_dynamic_rendering
#endif
#ifdef VK_KHR_get_physical_device_properties2
#endif
#ifdef VK_KHR_maintenance1
#endif
#ifdef VK_KHR_external_memory_capabilities
#endif
#ifdef VK_KHR_external_memory
#endif
#ifdef VK_KHR_external_memory_win32
#endif
#ifdef VK_KHR_external_memory_fd
#endif
#ifdef VK_KHR_external_semaphore_capabilities
#endif
#ifdef VK_KHR_external_semaphore
#endif
#ifdef VK_KHR_external_semaphore_win32
#endif
#ifdef VK_KHR_external_semaphore_fd
#endif
#ifdef VK_KHR_shader_float16_int8
#endif
#ifdef VK_KHR_incremental_present
#endif
#ifdef VK_KHR_descriptor_update_template
#endif
#ifdef VK_KHR_imageless_framebuffer
#endif
#ifdef VK_KHR_create_renderpass2
#endif
#ifdef VK_KHR_external_fence_capabilities
#endif
#ifdef VK_KHR_external_fence
#endif
#ifdef VK_KHR_external_fence_fd
#endif
#ifdef VK_KHR_maintenance2
#endif
#ifdef VK_KHR_dedicated_allocation
#endif
#ifdef VK_KHR_storage_buffer_storage_class
#endif
#ifdef VK_KHR_get_memory_requirements2
#endif
#ifdef VK_KHR_image_format_list
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
#endif
#ifdef VK_KHR_bind_memory2
#endif
#ifdef VK_KHR_maintenance3
#endif
#ifdef VK_KHR_shader_subgroup_extended_types
#endif
#ifdef VK_KHR_vulkan_memory_model
#endif
#ifdef VK_KHR_shader_terminate_invocation
#endif
#ifdef VK_KHR_buffer_device_address
#endif
#ifdef VK_KHR_pipeline_executable_properties
#endif
#ifdef VK_KHR_shader_integer_dot_product
#endif
#ifdef VK_KHR_shader_non_semantic_info
#endif
#ifdef VK_KHR_synchronization2
#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
#endif
#ifdef VK_KHR_copy_commands2
#endif
#ifdef VK_KHR_format_feature_flags2
#endif
#ifdef VK_KHR_maintenance4
#endif
#ifdef VK_ANDROID_native_buffer
#endif
#ifdef VK_EXT_transform_feedback
#endif
#ifdef VK_AMD_gpu_shader_half_float
#endif
#ifdef VK_EXT_texture_compression_astc_hdr
#endif
#ifdef VK_EXT_swapchain_colorspace
#endif
#ifdef VK_EXT_queue_family_foreign
#endif
#ifdef VK_EXT_debug_utils
#endif
#ifdef VK_ANDROID_external_memory_android_hardware_buffer
#endif
#ifdef VK_EXT_inline_uniform_block
#endif
#ifdef VK_EXT_shader_stencil_export
#endif
#ifdef VK_EXT_pipeline_creation_feedback
#endif
#ifdef VK_NV_shader_subgroup_partitioned
#endif
#ifdef VK_EXT_metal_surface
#endif
#ifdef VK_EXT_subgroup_size_control
#endif
#ifdef VK_EXT_tooling_info
#endif
#ifdef VK_EXT_provoking_vertex
#endif
#ifdef VK_EXT_line_rasterization
#endif
#ifdef VK_EXT_index_type_uint8
#endif
#ifdef VK_EXT_extended_dynamic_state
#endif
#ifdef VK_EXT_swapchain_maintenance1
#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
#endif
#ifdef VK_EXT_texel_buffer_alignment
#endif
#ifdef VK_EXT_device_memory_report
#endif
#ifdef VK_EXT_custom_border_color
#endif
#ifdef VK_EXT_private_data
#endif
#ifdef VK_EXT_pipeline_creation_cache_control
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
#endif
#ifdef VK_EXT_image_robustness
#endif
#ifdef VK_EXT_image_compression_control
#endif
#ifdef VK_EXT_4444_formats
#endif
#ifdef VK_EXT_primitive_topology_list_restart
#endif
#ifdef VK_EXT_extended_dynamic_state2
#endif
#ifdef VK_GOOGLE_gfxstream
#endif
#ifdef VK_EXT_load_store_op_none
#endif
#ifdef VK_EXT_image_compression_control_swapchain
#endif
uint32_t goldfish_vk_struct_type(const void* structExtension) {
    const uint32_t asStructType = *(reinterpret_cast<const uint32_t*>(structExtension));
    return asStructType;
}

size_t goldfish_vk_extension_struct_size(VkStructureType rootType, const void* structExtension) {
    if (!structExtension) {
        return (size_t)0;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension);
    switch (structType) {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: {
            return sizeof(VkShaderModuleCreateInfo);
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: {
            return sizeof(VkPhysicalDeviceSubgroupProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: {
            return sizeof(VkPhysicalDevice16BitStorageFeatures);
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: {
            return sizeof(VkMemoryDedicatedRequirements);
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: {
            return sizeof(VkMemoryDedicatedAllocateInfo);
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: {
            return sizeof(VkMemoryAllocateFlagsInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: {
            return sizeof(VkDeviceGroupRenderPassBeginInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: {
            return sizeof(VkDeviceGroupCommandBufferBeginInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: {
            return sizeof(VkDeviceGroupSubmitInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: {
            return sizeof(VkDeviceGroupBindSparseInfo);
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: {
            return sizeof(VkBindBufferMemoryDeviceGroupInfo);
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: {
            return sizeof(VkBindImageMemoryDeviceGroupInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: {
            return sizeof(VkDeviceGroupDeviceCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: {
            return sizeof(VkPhysicalDeviceFeatures2);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: {
            return sizeof(VkPhysicalDevicePointClippingProperties);
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: {
            return sizeof(VkRenderPassInputAttachmentAspectCreateInfo);
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: {
            return sizeof(VkImageViewUsageCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: {
            return sizeof(VkPipelineTessellationDomainOriginStateCreateInfo);
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: {
            return sizeof(VkRenderPassMultiviewCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: {
            return sizeof(VkPhysicalDeviceMultiviewFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: {
            return sizeof(VkPhysicalDeviceMultiviewProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: {
            return sizeof(VkPhysicalDeviceVariablePointersFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: {
            return sizeof(VkPhysicalDeviceProtectedMemoryFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: {
            return sizeof(VkPhysicalDeviceProtectedMemoryProperties);
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: {
            return sizeof(VkProtectedSubmitInfo);
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: {
            return sizeof(VkSamplerYcbcrConversionInfo);
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: {
            return sizeof(VkBindImagePlaneMemoryInfo);
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: {
            return sizeof(VkImagePlaneMemoryRequirementsInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: {
            return sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures);
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: {
            return sizeof(VkSamplerYcbcrConversionImageFormatProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: {
            return sizeof(VkPhysicalDeviceExternalImageFormatInfo);
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: {
            return sizeof(VkExternalImageFormatProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: {
            return sizeof(VkPhysicalDeviceIDProperties);
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: {
            return sizeof(VkExternalMemoryImageCreateInfo);
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: {
            return sizeof(VkExternalMemoryBufferCreateInfo);
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: {
            return sizeof(VkExportMemoryAllocateInfo);
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: {
            return sizeof(VkExportFenceCreateInfo);
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: {
            return sizeof(VkExportSemaphoreCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: {
            return sizeof(VkPhysicalDeviceMaintenance3Properties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderDrawParametersFeatures);
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: {
            return sizeof(VkPhysicalDeviceVulkan11Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: {
            return sizeof(VkPhysicalDeviceVulkan11Properties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: {
            return sizeof(VkPhysicalDeviceVulkan12Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: {
            return sizeof(VkPhysicalDeviceVulkan12Properties);
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: {
            return sizeof(VkImageFormatListCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: {
            return sizeof(VkPhysicalDevice8BitStorageFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: {
            return sizeof(VkPhysicalDeviceDriverProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderAtomicInt64Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderFloat16Int8Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: {
            return sizeof(VkPhysicalDeviceFloatControlsProperties);
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: {
            return sizeof(VkDescriptorSetLayoutBindingFlagsCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: {
            return sizeof(VkPhysicalDeviceDescriptorIndexingFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: {
            return sizeof(VkPhysicalDeviceDescriptorIndexingProperties);
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: {
            return sizeof(VkDescriptorSetVariableDescriptorCountAllocateInfo);
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: {
            return sizeof(VkDescriptorSetVariableDescriptorCountLayoutSupport);
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: {
            return sizeof(VkSubpassDescriptionDepthStencilResolve);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: {
            return sizeof(VkPhysicalDeviceDepthStencilResolveProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: {
            return sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures);
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: {
            return sizeof(VkImageStencilUsageCreateInfo);
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: {
            return sizeof(VkSamplerReductionModeCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: {
            return sizeof(VkPhysicalDeviceSamplerFilterMinmaxProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: {
            return sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: {
            return sizeof(VkPhysicalDeviceImagelessFramebufferFeatures);
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: {
            return sizeof(VkFramebufferAttachmentsCreateInfo);
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: {
            return sizeof(VkRenderPassAttachmentBeginInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: {
            return sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: {
            return sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures);
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: {
            return sizeof(VkAttachmentReferenceStencilLayout);
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: {
            return sizeof(VkAttachmentDescriptionStencilLayout);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: {
            return sizeof(VkPhysicalDeviceHostQueryResetFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: {
            return sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: {
            return sizeof(VkPhysicalDeviceTimelineSemaphoreProperties);
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: {
            return sizeof(VkSemaphoreTypeCreateInfo);
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: {
            return sizeof(VkTimelineSemaphoreSubmitInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: {
            return sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures);
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: {
            return sizeof(VkBufferOpaqueCaptureAddressCreateInfo);
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: {
            return sizeof(VkMemoryOpaqueCaptureAddressAllocateInfo);
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: {
            return sizeof(VkPhysicalDeviceVulkan13Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: {
            return sizeof(VkPhysicalDeviceVulkan13Properties);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: {
            return sizeof(VkPipelineCreationFeedbackCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: {
            return sizeof(VkPhysicalDevicePrivateDataFeatures);
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: {
            return sizeof(VkDevicePrivateDataCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: {
            return sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures);
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: {
            return sizeof(VkMemoryBarrier2);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: {
            return sizeof(VkPhysicalDeviceSynchronization2Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: {
            return sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: {
            return sizeof(VkPhysicalDeviceImageRobustnessFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: {
            return sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: {
            return sizeof(VkPhysicalDeviceSubgroupSizeControlProperties);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: {
            return sizeof(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: {
            return sizeof(VkPhysicalDeviceInlineUniformBlockFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: {
            return sizeof(VkPhysicalDeviceInlineUniformBlockProperties);
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: {
            return sizeof(VkWriteDescriptorSetInlineUniformBlock);
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: {
            return sizeof(VkDescriptorPoolInlineUniformBlockCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: {
            return sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: {
            return sizeof(VkPipelineRenderingCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: {
            return sizeof(VkPhysicalDeviceDynamicRenderingFeatures);
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: {
            return sizeof(VkCommandBufferInheritanceRenderingInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: {
            return sizeof(VkPhysicalDeviceShaderIntegerDotProductProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: {
            return sizeof(VkPhysicalDeviceTexelBufferAlignmentProperties);
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: {
            return sizeof(VkFormatProperties3);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: {
            return sizeof(VkPhysicalDeviceMaintenance4Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: {
            return sizeof(VkPhysicalDeviceMaintenance4Properties);
        }
#endif
#ifdef VK_KHR_dynamic_rendering
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: {
            return sizeof(VkRenderingFragmentShadingRateAttachmentInfoKHR);
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: {
            return sizeof(VkRenderingFragmentDensityMapAttachmentInfoEXT);
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: {
            return sizeof(VkAttachmentSampleCountInfoAMD);
        }
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: {
            return sizeof(VkMultiviewPerViewAttributesInfoNVX);
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: {
            return sizeof(VkPresentRegionsKHR);
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: {
            return sizeof(VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR);
        }
#endif
#ifdef VK_KHR_synchronization2
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV: {
            return sizeof(VkQueueFamilyCheckpointProperties2NV);
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID: {
            return sizeof(VkNativeBufferANDROID);
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: {
            return sizeof(VkPhysicalDeviceTransformFeedbackPropertiesEXT);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: {
            return sizeof(VkPipelineRasterizationStateStreamCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT: {
            return sizeof(VkPhysicalDeviceProvokingVertexPropertiesEXT);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: {
            return sizeof(VkPipelineRasterizationProvokingVertexStateCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_line_rasterization
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceLineRasterizationFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT: {
            return sizeof(VkPhysicalDeviceLineRasterizationPropertiesEXT);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: {
            return sizeof(VkPipelineRasterizationLineStateCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_index_type_uint8
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceIndexTypeUint8FeaturesEXT);
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT);
        }
#endif
#ifdef VK_EXT_swapchain_maintenance1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT: {
            return sizeof(VkSwapchainPresentFenceInfoEXT);
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT: {
            return sizeof(VkSwapchainPresentModesCreateInfoEXT);
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT: {
            return sizeof(VkSwapchainPresentModeInfoEXT);
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT: {
            return sizeof(VkSwapchainPresentScalingCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT);
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceDeviceMemoryReportFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: {
            return sizeof(VkDeviceDeviceMemoryReportCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: {
            return sizeof(VkSamplerCustomBorderColorCreateInfoEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: {
            return sizeof(VkPhysicalDeviceCustomBorderColorPropertiesEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT);
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT);
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceImageCompressionControlFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT: {
            return sizeof(VkImageCompressionControlEXT);
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT: {
            return sizeof(VkImageCompressionPropertiesEXT);
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: {
            return sizeof(VkPhysicalDevice4444FormatsFeaturesEXT);
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: {
            return sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT);
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT);
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE: {
            return sizeof(VkImportColorBufferGOOGLE);
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE: {
            return sizeof(VkImportBufferGOOGLE);
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE: {
            return sizeof(VkCreateBlobGOOGLE);
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT);
        }
#endif
        default: {
            return (size_t)0;
        }
    }
}

size_t goldfish_vk_extension_struct_size_with_stream_features(uint32_t streamFeatures,
                                                              VkStructureType rootType,
                                                              const void* structExtension) {
    if (!structExtension) {
        return (size_t)0;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension);
    switch (structType) {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: {
            return sizeof(VkShaderModuleCreateInfo);
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: {
            return sizeof(VkPhysicalDeviceSubgroupProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: {
            return sizeof(VkPhysicalDevice16BitStorageFeatures);
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: {
            return sizeof(VkMemoryDedicatedRequirements);
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: {
            return sizeof(VkMemoryDedicatedAllocateInfo);
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: {
            return sizeof(VkMemoryAllocateFlagsInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: {
            return sizeof(VkDeviceGroupRenderPassBeginInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: {
            return sizeof(VkDeviceGroupCommandBufferBeginInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: {
            return sizeof(VkDeviceGroupSubmitInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: {
            return sizeof(VkDeviceGroupBindSparseInfo);
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: {
            return sizeof(VkBindBufferMemoryDeviceGroupInfo);
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: {
            return sizeof(VkBindImageMemoryDeviceGroupInfo);
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: {
            return sizeof(VkDeviceGroupDeviceCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: {
            return sizeof(VkPhysicalDeviceFeatures2);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: {
            return sizeof(VkPhysicalDevicePointClippingProperties);
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: {
            return sizeof(VkRenderPassInputAttachmentAspectCreateInfo);
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: {
            return sizeof(VkImageViewUsageCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: {
            return sizeof(VkPipelineTessellationDomainOriginStateCreateInfo);
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: {
            return sizeof(VkRenderPassMultiviewCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: {
            return sizeof(VkPhysicalDeviceMultiviewFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: {
            return sizeof(VkPhysicalDeviceMultiviewProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: {
            return sizeof(VkPhysicalDeviceVariablePointersFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: {
            return sizeof(VkPhysicalDeviceProtectedMemoryFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: {
            return sizeof(VkPhysicalDeviceProtectedMemoryProperties);
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: {
            return sizeof(VkProtectedSubmitInfo);
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: {
            return sizeof(VkSamplerYcbcrConversionInfo);
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: {
            return sizeof(VkBindImagePlaneMemoryInfo);
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: {
            return sizeof(VkImagePlaneMemoryRequirementsInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: {
            return sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures);
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: {
            return sizeof(VkSamplerYcbcrConversionImageFormatProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: {
            return sizeof(VkPhysicalDeviceExternalImageFormatInfo);
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: {
            return sizeof(VkExternalImageFormatProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: {
            return sizeof(VkPhysicalDeviceIDProperties);
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: {
            return sizeof(VkExternalMemoryImageCreateInfo);
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: {
            return sizeof(VkExternalMemoryBufferCreateInfo);
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: {
            return sizeof(VkExportMemoryAllocateInfo);
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: {
            return sizeof(VkExportFenceCreateInfo);
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: {
            return sizeof(VkExportSemaphoreCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: {
            return sizeof(VkPhysicalDeviceMaintenance3Properties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderDrawParametersFeatures);
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: {
            return sizeof(VkPhysicalDeviceVulkan11Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: {
            return sizeof(VkPhysicalDeviceVulkan11Properties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: {
            return sizeof(VkPhysicalDeviceVulkan12Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: {
            return sizeof(VkPhysicalDeviceVulkan12Properties);
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: {
            return sizeof(VkImageFormatListCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: {
            return sizeof(VkPhysicalDevice8BitStorageFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: {
            return sizeof(VkPhysicalDeviceDriverProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderAtomicInt64Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: {
            if (streamFeatures & VULKAN_STREAM_FEATURE_SHADER_FLOAT16_INT8_BIT) {
                return sizeof(VkPhysicalDeviceShaderFloat16Int8Features);
            } else {
                return 0;
            }
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: {
            return sizeof(VkPhysicalDeviceFloatControlsProperties);
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: {
            return sizeof(VkDescriptorSetLayoutBindingFlagsCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: {
            return sizeof(VkPhysicalDeviceDescriptorIndexingFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: {
            return sizeof(VkPhysicalDeviceDescriptorIndexingProperties);
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: {
            return sizeof(VkDescriptorSetVariableDescriptorCountAllocateInfo);
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: {
            return sizeof(VkDescriptorSetVariableDescriptorCountLayoutSupport);
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: {
            return sizeof(VkSubpassDescriptionDepthStencilResolve);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: {
            return sizeof(VkPhysicalDeviceDepthStencilResolveProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: {
            return sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures);
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: {
            return sizeof(VkImageStencilUsageCreateInfo);
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: {
            return sizeof(VkSamplerReductionModeCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: {
            return sizeof(VkPhysicalDeviceSamplerFilterMinmaxProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: {
            return sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: {
            return sizeof(VkPhysicalDeviceImagelessFramebufferFeatures);
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: {
            return sizeof(VkFramebufferAttachmentsCreateInfo);
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: {
            return sizeof(VkRenderPassAttachmentBeginInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: {
            return sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: {
            return sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures);
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: {
            return sizeof(VkAttachmentReferenceStencilLayout);
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: {
            return sizeof(VkAttachmentDescriptionStencilLayout);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: {
            return sizeof(VkPhysicalDeviceHostQueryResetFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: {
            return sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: {
            return sizeof(VkPhysicalDeviceTimelineSemaphoreProperties);
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: {
            return sizeof(VkSemaphoreTypeCreateInfo);
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: {
            return sizeof(VkTimelineSemaphoreSubmitInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: {
            return sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures);
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: {
            return sizeof(VkBufferOpaqueCaptureAddressCreateInfo);
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: {
            return sizeof(VkMemoryOpaqueCaptureAddressAllocateInfo);
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: {
            return sizeof(VkPhysicalDeviceVulkan13Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: {
            return sizeof(VkPhysicalDeviceVulkan13Properties);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: {
            return sizeof(VkPipelineCreationFeedbackCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: {
            return sizeof(VkPhysicalDevicePrivateDataFeatures);
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: {
            return sizeof(VkDevicePrivateDataCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: {
            return sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures);
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: {
            return sizeof(VkMemoryBarrier2);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: {
            return sizeof(VkPhysicalDeviceSynchronization2Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: {
            return sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: {
            return sizeof(VkPhysicalDeviceImageRobustnessFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: {
            return sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: {
            return sizeof(VkPhysicalDeviceSubgroupSizeControlProperties);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: {
            return sizeof(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: {
            return sizeof(VkPhysicalDeviceInlineUniformBlockFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: {
            return sizeof(VkPhysicalDeviceInlineUniformBlockProperties);
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: {
            return sizeof(VkWriteDescriptorSetInlineUniformBlock);
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: {
            return sizeof(VkDescriptorPoolInlineUniformBlockCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: {
            return sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: {
            return sizeof(VkPipelineRenderingCreateInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: {
            return sizeof(VkPhysicalDeviceDynamicRenderingFeatures);
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: {
            return sizeof(VkCommandBufferInheritanceRenderingInfo);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: {
            return sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: {
            return sizeof(VkPhysicalDeviceShaderIntegerDotProductProperties);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: {
            return sizeof(VkPhysicalDeviceTexelBufferAlignmentProperties);
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: {
            return sizeof(VkFormatProperties3);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: {
            return sizeof(VkPhysicalDeviceMaintenance4Features);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: {
            return sizeof(VkPhysicalDeviceMaintenance4Properties);
        }
#endif
#ifdef VK_KHR_dynamic_rendering
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: {
            return sizeof(VkRenderingFragmentShadingRateAttachmentInfoKHR);
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: {
            return sizeof(VkRenderingFragmentDensityMapAttachmentInfoEXT);
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: {
            return sizeof(VkAttachmentSampleCountInfoAMD);
        }
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: {
            return sizeof(VkMultiviewPerViewAttributesInfoNVX);
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: {
            return sizeof(VkPresentRegionsKHR);
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: {
            return sizeof(VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR);
        }
#endif
#ifdef VK_KHR_synchronization2
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV: {
            return sizeof(VkQueueFamilyCheckpointProperties2NV);
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID: {
            return sizeof(VkNativeBufferANDROID);
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: {
            return sizeof(VkPhysicalDeviceTransformFeedbackPropertiesEXT);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: {
            return sizeof(VkPipelineRasterizationStateStreamCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT: {
            return sizeof(VkPhysicalDeviceProvokingVertexPropertiesEXT);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: {
            return sizeof(VkPipelineRasterizationProvokingVertexStateCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_line_rasterization
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceLineRasterizationFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT: {
            return sizeof(VkPhysicalDeviceLineRasterizationPropertiesEXT);
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: {
            return sizeof(VkPipelineRasterizationLineStateCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_index_type_uint8
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceIndexTypeUint8FeaturesEXT);
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT);
        }
#endif
#ifdef VK_EXT_swapchain_maintenance1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT: {
            return sizeof(VkSwapchainPresentFenceInfoEXT);
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT: {
            return sizeof(VkSwapchainPresentModesCreateInfoEXT);
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT: {
            return sizeof(VkSwapchainPresentModeInfoEXT);
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT: {
            return sizeof(VkSwapchainPresentScalingCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT);
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceDeviceMemoryReportFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: {
            return sizeof(VkDeviceDeviceMemoryReportCreateInfoEXT);
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: {
            return sizeof(VkSamplerCustomBorderColorCreateInfoEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: {
            return sizeof(VkPhysicalDeviceCustomBorderColorPropertiesEXT);
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT);
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT);
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceImageCompressionControlFeaturesEXT);
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT: {
            return sizeof(VkImageCompressionControlEXT);
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT: {
            return sizeof(VkImageCompressionPropertiesEXT);
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: {
            return sizeof(VkPhysicalDevice4444FormatsFeaturesEXT);
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: {
            return sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT);
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT);
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE: {
            return sizeof(VkImportColorBufferGOOGLE);
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE: {
            return sizeof(VkImportBufferGOOGLE);
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE: {
            return sizeof(VkCreateBlobGOOGLE);
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: {
            return sizeof(VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT);
        }
#endif
        default: {
            fprintf(stderr, "unknown structType %d\n", structType);
            return (size_t)0;
        }
    }
}

}  // namespace vk
}  // namespace gfxstream
