/* WindowStateSaver.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowStateSaver.vala, do not modify */

/*
 * Copyright 2023-2025 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <meta/window.h>
#include <gio/gio.h>
#include <sqlite3.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "gala.h"
#include <mtk/mtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_STATE_SAVER (gala_window_state_saver_get_type ())
#define GALA_WINDOW_STATE_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_STATE_SAVER, GalaWindowStateSaver))
#define GALA_WINDOW_STATE_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_STATE_SAVER, GalaWindowStateSaverClass))
#define GALA_IS_WINDOW_STATE_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_STATE_SAVER))
#define GALA_IS_WINDOW_STATE_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_STATE_SAVER))
#define GALA_WINDOW_STATE_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_STATE_SAVER, GalaWindowStateSaverClass))

typedef struct _GalaWindowStateSaver GalaWindowStateSaver;
typedef struct _GalaWindowStateSaverClass GalaWindowStateSaverClass;
typedef struct _GalaWindowStateSaverPrivate GalaWindowStateSaverPrivate;
enum  {
	GALA_WINDOW_STATE_SAVER_0_PROPERTY,
	GALA_WINDOW_STATE_SAVER_NUM_PROPERTIES
};
static GParamSpec* gala_window_state_saver_properties[GALA_WINDOW_STATE_SAVER_NUM_PROPERTIES];

#define GALA_TYPE_WINDOW_TRACKER (gala_window_tracker_get_type ())
#define GALA_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTracker))
#define GALA_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))
#define GALA_IS_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_TRACKER))
#define GALA_IS_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_TRACKER))
#define GALA_WINDOW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))

typedef struct _GalaWindowTracker GalaWindowTracker;
typedef struct _GalaWindowTrackerClass GalaWindowTrackerClass;

#define GALA_WINDOW_STATE_SAVER_TYPE_LOGIN_MANAGER (gala_window_state_saver_login_manager_get_type ())
#define GALA_WINDOW_STATE_SAVER_LOGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_WINDOW_STATE_SAVER_TYPE_LOGIN_MANAGER, GalaWindowStateSaverLoginManager))
#define GALA_WINDOW_STATE_SAVER_IS_LOGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_WINDOW_STATE_SAVER_TYPE_LOGIN_MANAGER))
#define GALA_WINDOW_STATE_SAVER_LOGIN_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_WINDOW_STATE_SAVER_TYPE_LOGIN_MANAGER, GalaWindowStateSaverLoginManagerIface))

typedef struct _GalaWindowStateSaverLoginManager GalaWindowStateSaverLoginManager;
typedef struct _GalaWindowStateSaverLoginManagerIface GalaWindowStateSaverLoginManagerIface;

#define GALA_WINDOW_STATE_SAVER_TYPE_LOGIN_MANAGER_PROXY (gala_window_state_saver_login_manager_proxy_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GalaWindowStateSaverConnectToLogindData GalaWindowStateSaverConnectToLogindData;

#define GALA_TYPE_SHELL_CLIENTS_MANAGER (gala_shell_clients_manager_get_type ())
#define GALA_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManager))
#define GALA_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))
#define GALA_IS_SHELL_CLIENTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_IS_SHELL_CLIENTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SHELL_CLIENTS_MANAGER))
#define GALA_SHELL_CLIENTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SHELL_CLIENTS_MANAGER, GalaShellClientsManagerClass))

typedef struct _GalaShellClientsManager GalaShellClientsManager;
typedef struct _GalaShellClientsManagerClass GalaShellClientsManagerClass;
enum  {
	GALA_WINDOW_STATE_SAVER_LOGIN_MANAGER_PREPARE_FOR_SLEEP_SIGNAL,
	GALA_WINDOW_STATE_SAVER_LOGIN_MANAGER_NUM_SIGNALS
};
static guint gala_window_state_saver_login_manager_signals[GALA_WINDOW_STATE_SAVER_LOGIN_MANAGER_NUM_SIGNALS] = {0};
typedef GDBusProxy GalaWindowStateSaverLoginManagerProxy;
typedef GDBusProxyClass GalaWindowStateSaverLoginManagerProxyClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaWindowStateSaver {
	GObject parent_instance;
	GalaWindowStateSaverPrivate * priv;
};

struct _GalaWindowStateSaverClass {
	GObjectClass parent_class;
};

struct _GalaWindowStateSaverLoginManagerIface {
	GTypeInterface parent_iface;
};

struct _GalaWindowStateSaverConnectToLogindData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GalaWindowStateSaverLoginManager* _tmp0_;
	GalaWindowStateSaverLoginManager* _tmp1_;
	GalaWindowStateSaverLoginManager* _tmp2_;
	GalaWindowStateSaverLoginManager* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

static gpointer gala_window_state_saver_parent_class = NULL;
static GalaWindowTracker* gala_window_state_saver_window_tracker;
static GalaWindowTracker* gala_window_state_saver_window_tracker = NULL;
static GHashTable* gala_window_state_saver_app_windows;
static GHashTable* gala_window_state_saver_app_windows = NULL;
static GalaWindowStateSaverLoginManager* gala_window_state_saver_login_manager;
static GalaWindowStateSaverLoginManager* gala_window_state_saver_login_manager = NULL;
static sqlite3* gala_window_state_saver_db;
static sqlite3* gala_window_state_saver_db = NULL;

VALA_EXTERN GType gala_window_state_saver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowStateSaver, g_object_unref)
VALA_EXTERN GType gala_window_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowTracker, g_object_unref)
static GType gala_window_state_saver_login_manager_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowStateSaverLoginManager, g_object_unref)
VALA_EXTERN GType gala_window_state_saver_login_manager_proxy_get_type (void) G_GNUC_CONST ;
static guint gala_window_state_saver_login_manager_register_object (void* object,
                                                             GDBusConnection* connection,
                                                             const gchar* path,
                                                             GError** error);
VALA_EXTERN void gala_window_state_saver_init (GalaWindowTracker* window_tracker);
static void _g_free0_ (gpointer var);
static void _g_array_unref0_ (gpointer var);
static void gala_window_state_saver_connect_to_logind (GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void gala_window_state_saver_connect_to_logind_finish (GAsyncResult* _res_);
static void gala_window_state_saver_connect_to_logind_data_free (gpointer _data);
static gboolean gala_window_state_saver_connect_to_logind_co (GalaWindowStateSaverConnectToLogindData* _data_);
static void gala_window_state_saver_connect_to_logind_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void ___lambda140_ (gboolean about_to_suspend);
static void gala_window_state_saver_save_all_windows_state (void);
static void ____lambda140__gala_window_state_saver_login_manager_prepare_for_sleep (GalaWindowStateSaverLoginManager* _sender,
                                                                             gboolean about_to_suspend,
                                                                             gpointer self);
VALA_EXTERN void gala_window_state_saver_on_map (MetaWindow* window);
VALA_EXTERN GalaApp* gala_window_tracker_get_app_for_window (GalaWindowTracker* self,
                                                 MetaWindow* window);
VALA_EXTERN GType gala_shell_clients_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaShellClientsManager, g_object_unref)
VALA_EXTERN GalaShellClientsManager* gala_shell_clients_manager_get_instance (void);
VALA_EXTERN gboolean gala_shell_clients_manager_is_positioned_window (GalaShellClientsManager* self,
                                                          MetaWindow* window);
static void _g_object_unref0_ (gpointer var);
static void _vala_MetaWindow_free_function_content_of (gpointer data);
static gint gala_window_state_saver_find_window_index (MetaWindow* window,
                                                const gchar* app_id);
static void gala_window_state_saver_track_window (MetaWindow* window,
                                           const gchar* app_id);
VALA_EXTERN void gala_window_state_saver_on_shutdown (void);
static void gala_window_state_saver_save_window_state (MetaWindow* window);
static void _gala_window_state_saver_save_window_state_meta_window_unmanaging (MetaWindow* _sender,
                                                                        gpointer self);
VALA_EXTERN GalaWindowStateSaver* gala_window_state_saver_new (void);
VALA_EXTERN GalaWindowStateSaver* gala_window_state_saver_construct (GType object_type);
static GType gala_window_state_saver_login_manager_get_type_once (void);
static void gala_window_state_saver_login_manager_proxy_g_signal (GDBusProxy* proxy,
                                                           const gchar* sender_name,
                                                           const gchar* signal_name,
                                                           GVariant* parameters);
static void _dbus_handle_gala_window_state_saver_login_manager_prepare_for_sleep (GalaWindowStateSaverLoginManager* self,
                                                                           GVariant* parameters);
static void gala_window_state_saver_login_manager_proxy_gala_window_state_saver_login_manager_interface_init (GalaWindowStateSaverLoginManagerIface* iface);
static void gala_window_state_saver_login_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* method_name,
                                                                       GVariant* parameters,
                                                                       GDBusMethodInvocation* invocation,
                                                                       gpointer user_data);
static GVariant* gala_window_state_saver_login_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                             const gchar* sender,
                                                                             const gchar* object_path,
                                                                             const gchar* interface_name,
                                                                             const gchar* property_name,
                                                                             GError** error,
                                                                             gpointer user_data);
static gboolean gala_window_state_saver_login_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                            const gchar* sender,
                                                                            const gchar* object_path,
                                                                            const gchar* interface_name,
                                                                            const gchar* property_name,
                                                                            GVariant* value,
                                                                            GError** error,
                                                                            gpointer user_data);
static void _dbus_gala_window_state_saver_login_manager_prepare_for_sleep (GObject* _sender,
                                                                    gboolean about_to_suspend,
                                                                    gpointer* _data);
static void _gala_window_state_saver_login_manager_unregister_object (gpointer user_data);
static void gala_window_state_saver_finalize (GObject * obj);
static GType gala_window_state_saver_get_type_once (void);

static const GDBusMethodInfo * const _gala_window_state_saver_login_manager_dbus_method_info[] = {NULL};
static const GDBusArgInfo _gala_window_state_saver_login_manager_dbus_arg_info_prepare_for_sleep_about_to_suspend = {-1, "about_to_suspend", "b", NULL};
static const GDBusArgInfo * const _gala_window_state_saver_login_manager_dbus_arg_info_prepare_for_sleep[] = {&_gala_window_state_saver_login_manager_dbus_arg_info_prepare_for_sleep_about_to_suspend, NULL};
static const GDBusSignalInfo _gala_window_state_saver_login_manager_dbus_signal_info_prepare_for_sleep = {-1, "PrepareForSleep", (GDBusArgInfo **) (&_gala_window_state_saver_login_manager_dbus_arg_info_prepare_for_sleep), NULL};
static const GDBusSignalInfo * const _gala_window_state_saver_login_manager_dbus_signal_info[] = {&_gala_window_state_saver_login_manager_dbus_signal_info_prepare_for_sleep, NULL};
static const GDBusPropertyInfo * const _gala_window_state_saver_login_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _gala_window_state_saver_login_manager_dbus_interface_info = {-1, "org.freedesktop.login1.Manager", (GDBusMethodInfo **) (&_gala_window_state_saver_login_manager_dbus_method_info), (GDBusSignalInfo **) (&_gala_window_state_saver_login_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_window_state_saver_login_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_window_state_saver_login_manager_dbus_interface_vtable = {gala_window_state_saver_login_manager_dbus_interface_method_call, gala_window_state_saver_login_manager_dbus_interface_get_property, gala_window_state_saver_login_manager_dbus_interface_set_property};

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_array_unref (var), NULL));
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

void
gala_window_state_saver_init (GalaWindowTracker* window_tracker)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* dir = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* path = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint rc = 0;
	const gchar* _tmp8_;
	sqlite3* _tmp9_ = NULL;
	gint _tmp10_;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp13_;
	sqlite3_stmt* _tmp14_ = NULL;
	gint _tmp15_;
	sqlite3* _tmp20_;
	const gchar* _tmp21_;
	g_return_if_fail (window_tracker != NULL);
	gala_window_state_saver_window_tracker = window_tracker;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_array_unref0_);
	_g_hash_table_unref0 (gala_window_state_saver_app_windows);
	gala_window_state_saver_app_windows = _tmp2_;
	gala_window_state_saver_connect_to_logind (NULL, NULL);
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "io.elementary.gala", NULL);
	dir = _tmp4_;
	_tmp5_ = dir;
	mkdir (_tmp5_, (mode_t) 0775);
	_tmp6_ = dir;
	_tmp7_ = g_build_filename (_tmp6_, "windowstate.db", NULL);
	path = _tmp7_;
	_tmp8_ = path;
	_tmp10_ = sqlite3_open_v2 (_tmp8_, &_tmp9_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
	_sqlite3_close0 (gala_window_state_saver_db);
	gala_window_state_saver_db = _tmp9_;
	rc = _tmp10_;
	if (rc != SQLITE_OK) {
		sqlite3* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = gala_window_state_saver_db;
		_tmp12_ = sqlite3_errmsg (_tmp11_);
		g_critical ("WindowStateSaver.vala:29: Cannot open database: %d, %s", rc, _tmp12_);
		_g_free0 (path);
		_g_free0 (dir);
		return;
	}
	_tmp13_ = gala_window_state_saver_db;
	_tmp15_ = sqlite3_prepare_v2 (_tmp13_, "\n" \
"            CREATE TABLE IF NOT EXISTS apps (\n" \
"                app_id       TEXT,\n" \
"                window_index INTEGER,\n" \
"                last_x       INTEGER,\n" \
"                last_y       INTEGER,\n" \
"                last_width   INTEGER,\n" \
"                last_height  INTEGER,\n" \
"                PRIMARY KEY (app_id, window_index)\n" \
"            );\n" \
"            ", -1, &_tmp14_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp14_;
	rc = _tmp15_;
	if (rc == SQLITE_OK) {
		sqlite3_stmt* _tmp16_;
		_tmp16_ = stmt;
		rc = sqlite3_step (_tmp16_);
		if (rc == SQLITE_DONE) {
			sqlite3* _tmp17_;
			_tmp17_ = gala_window_state_saver_db;
			rc = _sqlite3_exec (_tmp17_, "PRAGMA synchronous=OFF", NULL, NULL, NULL);
			if (rc != SQLITE_OK) {
				sqlite3* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = gala_window_state_saver_db;
				_tmp19_ = sqlite3_errmsg (_tmp18_);
				g_warning ("WindowStateSaver.vala:55: Unable to disable synchronous mode %d, %s", rc, _tmp19_);
			}
			_sqlite3_finalize0 (stmt);
			_g_free0 (path);
			_g_free0 (dir);
			return;
		}
	}
	_tmp20_ = gala_window_state_saver_db;
	_tmp21_ = sqlite3_errmsg (_tmp20_);
	g_critical ("WindowStateSaver.vala:62: Cannot create table 'apps': %d, %s", rc, _tmp21_);
	_sqlite3_finalize0 (stmt);
	_g_free0 (path);
	_g_free0 (dir);
}

static void
gala_window_state_saver_connect_to_logind_data_free (gpointer _data)
{
	GalaWindowStateSaverConnectToLogindData* _data_;
	_data_ = _data;
	g_slice_free (GalaWindowStateSaverConnectToLogindData, _data_);
}

static void
gala_window_state_saver_connect_to_logind (GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GalaWindowStateSaverConnectToLogindData* _data_;
	_data_ = g_slice_new0 (GalaWindowStateSaverConnectToLogindData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gala_window_state_saver_connect_to_logind_data_free);
	gala_window_state_saver_connect_to_logind_co (_data_);
}

static void
gala_window_state_saver_connect_to_logind_finish (GAsyncResult* _res_)
{
	GalaWindowStateSaverConnectToLogindData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
gala_window_state_saver_connect_to_logind_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GalaWindowStateSaverConnectToLogindData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gala_window_state_saver_connect_to_logind_co (_data_);
}

static void
___lambda140_ (gboolean about_to_suspend)
{
	if (about_to_suspend) {
		gala_window_state_saver_save_all_windows_state ();
	}
}

static void
____lambda140__gala_window_state_saver_login_manager_prepare_for_sleep (GalaWindowStateSaverLoginManager* _sender,
                                                                        gboolean about_to_suspend,
                                                                        gpointer self)
{
	___lambda140_ (about_to_suspend);
}

static gboolean
gala_window_state_saver_connect_to_logind_co (GalaWindowStateSaverConnectToLogindData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (GALA_WINDOW_STATE_SAVER_TYPE_LOGIN_MANAGER_PROXY, 0, NULL, gala_window_state_saver_connect_to_logind_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.login1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/login1", "g-interface-name", "org.freedesktop.login1.Manager", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (GalaWindowStateSaverLoginManager*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (GalaWindowStateSaverLoginManager*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (gala_window_state_saver_login_manager);
		gala_window_state_saver_login_manager = _data_->_tmp2_;
		_data_->_tmp3_ = gala_window_state_saver_login_manager;
		g_signal_connect (_data_->_tmp3_, "prepare-for-sleep", (GCallback) ____lambda140__gala_window_state_saver_login_manager_prepare_for_sleep, NULL);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("WindowStateSaver.vala:74: Unable to connect to logind bus: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_MetaWindow_free_function_content_of (gpointer data)
{
	MetaWindow* self;
	self = *((MetaWindow**) data);
	_g_object_unref0_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_window_state_saver_on_map (MetaWindow* window)
{
	gchar* app_id = NULL;
	GalaWindowTracker* _tmp0_;
	GalaApp* _tmp1_;
	GalaApp* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	MetaWindowType _tmp8_;
	MetaWindowType _tmp9_;
	GalaShellClientsManager* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gint window_index = 0;
	const gchar* _tmp17_;
	GHashTable* _tmp18_;
	const gchar* _tmp19_;
	gconstpointer _tmp20_;
	MetaWindow* _tmp21_;
	sqlite3_stmt* stmt = NULL;
	static const char SELECT_QUERY[] = "SELECT last_x, last_y, last_width, last_height FROM apps WHERE app_id " \
"= $app_id AND window_index = $window_index;";
	gint rc = 0;
	sqlite3* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	sqlite3_stmt* _tmp25_ = NULL;
	gint _tmp26_;
	sqlite3_stmt* _tmp27_;
	sqlite3_stmt* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GDestroyNotify _tmp31_;
	sqlite3_stmt* _tmp32_;
	sqlite3_stmt* _tmp33_;
	gint cols = 0;
	sqlite3_stmt* _tmp36_;
	sqlite3_stmt* _tmp37_;
	MtkRectangle frame_rect = {0};
	MtkRectangle _tmp53_ = {0};
	static const char INSERT_QUERY[] = "INSERT INTO apps (app_id, window_index, last_x, last_y, last_width, la" \
"st_height) VALUES ($app_id, $window_index, $last_x, $last_y, $last_wid" \
"th, $last_height);";
	sqlite3* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	sqlite3_stmt* _tmp57_ = NULL;
	gint _tmp58_;
	sqlite3_stmt* _tmp61_;
	sqlite3_stmt* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	GDestroyNotify _tmp65_;
	sqlite3_stmt* _tmp66_;
	sqlite3_stmt* _tmp67_;
	sqlite3_stmt* _tmp68_;
	sqlite3_stmt* _tmp69_;
	MtkRectangle _tmp70_;
	sqlite3_stmt* _tmp71_;
	sqlite3_stmt* _tmp72_;
	MtkRectangle _tmp73_;
	sqlite3_stmt* _tmp74_;
	sqlite3_stmt* _tmp75_;
	MtkRectangle _tmp76_;
	sqlite3_stmt* _tmp77_;
	sqlite3_stmt* _tmp78_;
	MtkRectangle _tmp79_;
	sqlite3_stmt* _tmp80_;
	const gchar* _tmp83_;
	g_return_if_fail (window != NULL);
	_tmp0_ = gala_window_state_saver_window_tracker;
	_tmp1_ = gala_window_tracker_get_app_for_window (_tmp0_, window);
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_app_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	app_id = _tmp6_;
	_tmp7_ = app_id;
	if (g_str_has_prefix (_tmp7_, "window:")) {
		_g_free0 (app_id);
		return;
	}
	_tmp8_ = meta_window_get_window_type (window);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != META_WINDOW_NORMAL) {
		_g_free0 (app_id);
		return;
	}
	_tmp10_ = gala_shell_clients_manager_get_instance ();
	if (gala_shell_clients_manager_is_positioned_window (_tmp10_, window)) {
		_g_free0 (app_id);
		return;
	}
	_tmp11_ = gala_window_state_saver_app_windows;
	_tmp12_ = app_id;
	if (!g_hash_table_contains (_tmp11_, _tmp12_)) {
		GHashTable* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		GArray* _tmp16_;
		_tmp13_ = gala_window_state_saver_app_windows;
		_tmp14_ = app_id;
		_tmp15_ = g_strdup (_tmp14_);
		_tmp16_ = g_array_new (TRUE, TRUE, sizeof (MetaWindow*));
		g_array_set_clear_func (_tmp16_, (GDestroyNotify) _vala_MetaWindow_free_function_content_of);
		g_hash_table_insert (_tmp13_, _tmp15_, _tmp16_);
	}
	_tmp17_ = app_id;
	window_index = gala_window_state_saver_find_window_index (window, _tmp17_);
	_tmp18_ = gala_window_state_saver_app_windows;
	_tmp19_ = app_id;
	_tmp20_ = g_hash_table_lookup (_tmp18_, _tmp19_);
	_tmp21_ = _g_object_ref0 (window);
	g_array_insert_val ((GArray*) _tmp20_, (guint) window_index, _tmp21_);
	_tmp22_ = gala_window_state_saver_db;
	_tmp23_ = strlen (SELECT_QUERY);
	_tmp24_ = _tmp23_;
	_tmp26_ = sqlite3_prepare_v2 (_tmp22_, SELECT_QUERY, _tmp24_, &_tmp25_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp25_;
	rc = _tmp26_;
	_tmp27_ = stmt;
	_tmp28_ = stmt;
	_tmp29_ = app_id;
	_tmp30_ = g_strdup (_tmp29_);
	_tmp31_ = g_free;
	sqlite3_bind_text (_tmp27_, sqlite3_bind_parameter_index (_tmp28_, "$app_id"), _tmp30_, -1, _tmp31_);
	_tmp32_ = stmt;
	_tmp33_ = stmt;
	sqlite3_bind_int (_tmp32_, sqlite3_bind_parameter_index (_tmp33_, "$window_index"), window_index);
	if (rc != SQLITE_OK) {
		sqlite3* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = gala_window_state_saver_db;
		_tmp35_ = sqlite3_errmsg (_tmp34_);
		g_critical ("WindowStateSaver.vala:107: Cannot query app information from database:" \
" %d, %s", rc, _tmp35_);
		_sqlite3_finalize0 (stmt);
		_g_free0 (app_id);
		return;
	}
	_tmp36_ = stmt;
	cols = sqlite3_column_count (_tmp36_);
	_tmp37_ = stmt;
	if (sqlite3_step (_tmp37_) == SQLITE_ROW) {
		gint last_x = 0;
		gint last_y = 0;
		gint last_width = 0;
		gint last_height = 0;
		const gchar* _tmp52_;
		last_x = 0;
		last_y = 0;
		last_width = 0;
		last_height = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp38_ = FALSE;
				_tmp38_ = TRUE;
				while (TRUE) {
					sqlite3_stmt* _tmp40_;
					const gchar* _tmp41_;
					sqlite3_stmt* _tmp43_;
					const gchar* _tmp44_;
					sqlite3_stmt* _tmp46_;
					const gchar* _tmp47_;
					sqlite3_stmt* _tmp49_;
					const gchar* _tmp50_;
					if (!_tmp38_) {
						gint _tmp39_;
						_tmp39_ = i;
						i = _tmp39_ + 1;
					}
					_tmp38_ = FALSE;
					if (!(i < cols)) {
						break;
					}
					_tmp40_ = stmt;
					_tmp41_ = sqlite3_column_name (_tmp40_, i);
					if (g_strcmp0 (_tmp41_, "last_x") == 0) {
						sqlite3_stmt* _tmp42_;
						_tmp42_ = stmt;
						last_x = sqlite3_column_int (_tmp42_, i);
					}
					_tmp43_ = stmt;
					_tmp44_ = sqlite3_column_name (_tmp43_, i);
					if (g_strcmp0 (_tmp44_, "last_y") == 0) {
						sqlite3_stmt* _tmp45_;
						_tmp45_ = stmt;
						last_y = sqlite3_column_int (_tmp45_, i);
					}
					_tmp46_ = stmt;
					_tmp47_ = sqlite3_column_name (_tmp46_, i);
					if (g_strcmp0 (_tmp47_, "last_width") == 0) {
						sqlite3_stmt* _tmp48_;
						_tmp48_ = stmt;
						last_width = sqlite3_column_int (_tmp48_, i);
					}
					_tmp49_ = stmt;
					_tmp50_ = sqlite3_column_name (_tmp49_, i);
					if (g_strcmp0 (_tmp50_, "last_height") == 0) {
						sqlite3_stmt* _tmp51_;
						_tmp51_ = stmt;
						last_height = sqlite3_column_int (_tmp51_, i);
					}
				}
			}
		}
		meta_window_move_resize_frame (window, FALSE, last_x, last_y, last_width, last_height);
		_tmp52_ = app_id;
		gala_window_state_saver_track_window (window, _tmp52_);
		_sqlite3_finalize0 (stmt);
		_g_free0 (app_id);
		return;
	}
	meta_window_get_frame_rect (window, &_tmp53_);
	frame_rect = _tmp53_;
	_tmp54_ = gala_window_state_saver_db;
	_tmp55_ = strlen (INSERT_QUERY);
	_tmp56_ = _tmp55_;
	_tmp58_ = sqlite3_prepare_v2 (_tmp54_, INSERT_QUERY, _tmp56_, &_tmp57_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp57_;
	rc = _tmp58_;
	if (rc != SQLITE_OK) {
		sqlite3* _tmp59_;
		const gchar* _tmp60_;
		_tmp59_ = gala_window_state_saver_db;
		_tmp60_ = sqlite3_errmsg (_tmp59_);
		g_critical ("WindowStateSaver.vala:142: Cannot insert app information into database" \
": %d, %s", rc, _tmp60_);
		_sqlite3_finalize0 (stmt);
		_g_free0 (app_id);
		return;
	}
	_tmp61_ = stmt;
	_tmp62_ = stmt;
	_tmp63_ = app_id;
	_tmp64_ = g_strdup (_tmp63_);
	_tmp65_ = g_free;
	sqlite3_bind_text (_tmp61_, sqlite3_bind_parameter_index (_tmp62_, "$app_id"), _tmp64_, -1, _tmp65_);
	_tmp66_ = stmt;
	_tmp67_ = stmt;
	sqlite3_bind_int (_tmp66_, sqlite3_bind_parameter_index (_tmp67_, "$window_index"), window_index);
	_tmp68_ = stmt;
	_tmp69_ = stmt;
	_tmp70_ = frame_rect;
	sqlite3_bind_int (_tmp68_, sqlite3_bind_parameter_index (_tmp69_, "$last_x"), _tmp70_.x);
	_tmp71_ = stmt;
	_tmp72_ = stmt;
	_tmp73_ = frame_rect;
	sqlite3_bind_int (_tmp71_, sqlite3_bind_parameter_index (_tmp72_, "$last_y"), _tmp73_.y);
	_tmp74_ = stmt;
	_tmp75_ = stmt;
	_tmp76_ = frame_rect;
	sqlite3_bind_int (_tmp74_, sqlite3_bind_parameter_index (_tmp75_, "$last_width"), _tmp76_.width);
	_tmp77_ = stmt;
	_tmp78_ = stmt;
	_tmp79_ = frame_rect;
	sqlite3_bind_int (_tmp77_, sqlite3_bind_parameter_index (_tmp78_, "$last_height"), _tmp79_.height);
	_tmp80_ = stmt;
	rc = sqlite3_step (_tmp80_);
	if (rc != SQLITE_DONE) {
		sqlite3* _tmp81_;
		const gchar* _tmp82_;
		_tmp81_ = gala_window_state_saver_db;
		_tmp82_ = sqlite3_errmsg (_tmp81_);
		g_critical ("WindowStateSaver.vala:155: Cannot insert app information into database" \
": %d, %s", rc, _tmp82_);
		_sqlite3_finalize0 (stmt);
		_g_free0 (app_id);
		return;
	}
	_tmp83_ = app_id;
	gala_window_state_saver_track_window (window, _tmp83_);
	_sqlite3_finalize0 (stmt);
	_g_free0 (app_id);
}

void
gala_window_state_saver_on_shutdown (void)
{
	gala_window_state_saver_save_all_windows_state ();
}

static void
_gala_window_state_saver_save_window_state_meta_window_unmanaging (MetaWindow* _sender,
                                                                   gpointer self)
{
	gala_window_state_saver_save_window_state (_sender);
}

static void
gala_window_state_saver_track_window (MetaWindow* window,
                                      const gchar* app_id)
{
	g_return_if_fail (window != NULL);
	g_return_if_fail (app_id != NULL);
	g_signal_connect (window, "unmanaging", (GCallback) _gala_window_state_saver_save_window_state_meta_window_unmanaging, NULL);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

static void
gala_window_state_saver_save_window_state (MetaWindow* window)
{
	gchar* app_id = NULL;
	GalaWindowTracker* _tmp0_;
	GalaApp* _tmp1_;
	GalaApp* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GHashTable* _tmp7_;
	const gchar* _tmp8_;
	gint window_index = 0;
	const gchar* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gconstpointer _tmp13_;
	gpointer value = NULL;
	GHashTable* _tmp19_;
	const gchar* _tmp20_;
	gconstpointer _tmp21_;
	gpointer _tmp22_;
	MtkRectangle frame_rect = {0};
	MtkRectangle _tmp23_ = {0};
	sqlite3_stmt* stmt = NULL;
	static const char UPDATE_QUERY[] = "UPDATE apps SET last_x = $last_x, last_y = $last_y, last_width = $last" \
"_width, last_height = $last_height WHERE app_id = $app_id AND window_i" \
"ndex = $window_index;";
	gint rc = 0;
	sqlite3* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	sqlite3_stmt* _tmp27_ = NULL;
	gint _tmp28_;
	sqlite3_stmt* _tmp31_;
	sqlite3_stmt* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GDestroyNotify _tmp35_;
	sqlite3_stmt* _tmp36_;
	sqlite3_stmt* _tmp37_;
	sqlite3_stmt* _tmp38_;
	sqlite3_stmt* _tmp39_;
	MtkRectangle _tmp40_;
	sqlite3_stmt* _tmp41_;
	sqlite3_stmt* _tmp42_;
	MtkRectangle _tmp43_;
	sqlite3_stmt* _tmp44_;
	sqlite3_stmt* _tmp45_;
	MtkRectangle _tmp46_;
	sqlite3_stmt* _tmp47_;
	sqlite3_stmt* _tmp48_;
	MtkRectangle _tmp49_;
	sqlite3_stmt* _tmp50_;
	g_return_if_fail (window != NULL);
	_tmp0_ = gala_window_state_saver_window_tracker;
	_tmp1_ = gala_window_tracker_get_app_for_window (_tmp0_, window);
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_app_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	app_id = _tmp6_;
	_tmp7_ = gala_window_state_saver_app_windows;
	_tmp8_ = app_id;
	if (!g_hash_table_contains (_tmp7_, _tmp8_)) {
		const gchar* _tmp9_;
		_tmp9_ = app_id;
		g_critical ("WindowStateSaver.vala:174: Could not save window that is not mapped %s", _tmp9_);
		_g_free0 (app_id);
		return;
	}
	_tmp10_ = app_id;
	window_index = gala_window_state_saver_find_window_index (window, _tmp10_);
	_tmp11_ = gala_window_state_saver_app_windows;
	_tmp12_ = app_id;
	_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
	if (((guint) window_index) < ((GArray*) _tmp13_)->len) {
		GHashTable* _tmp14_;
		const gchar* _tmp15_;
		gconstpointer _tmp16_;
		MetaWindow* _tmp17_;
		MetaWindow* _tmp18_;
		_tmp14_ = gala_window_state_saver_app_windows;
		_tmp15_ = app_id;
		_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
		_tmp17_ = vala_g_array_remove_index ((GArray*) _tmp16_, (guint) window_index);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp18_);
	}
	value = NULL;
	_tmp19_ = gala_window_state_saver_app_windows;
	_tmp20_ = app_id;
	_tmp21_ = g_hash_table_lookup (_tmp19_, _tmp20_);
	_tmp22_ = value;
	g_array_insert_val ((GArray*) _tmp21_, (guint) window_index, _tmp22_);
	meta_window_get_frame_rect (window, &_tmp23_);
	frame_rect = _tmp23_;
	_tmp24_ = gala_window_state_saver_db;
	_tmp25_ = strlen (UPDATE_QUERY);
	_tmp26_ = _tmp25_;
	_tmp28_ = sqlite3_prepare_v2 (_tmp24_, UPDATE_QUERY, _tmp26_, &_tmp27_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp27_;
	rc = _tmp28_;
	if (rc != SQLITE_OK) {
		sqlite3* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = gala_window_state_saver_db;
		_tmp30_ = sqlite3_errmsg (_tmp29_);
		g_critical ("WindowStateSaver.vala:192: Cannot update app position in database: %d," \
" %s", rc, _tmp30_);
		_sqlite3_finalize0 (stmt);
		_g_free0 (app_id);
		return;
	}
	_tmp31_ = stmt;
	_tmp32_ = stmt;
	_tmp33_ = app_id;
	_tmp34_ = g_strdup (_tmp33_);
	_tmp35_ = g_free;
	sqlite3_bind_text (_tmp31_, sqlite3_bind_parameter_index (_tmp32_, "$app_id"), _tmp34_, -1, _tmp35_);
	_tmp36_ = stmt;
	_tmp37_ = stmt;
	sqlite3_bind_int (_tmp36_, sqlite3_bind_parameter_index (_tmp37_, "$window_index"), window_index);
	_tmp38_ = stmt;
	_tmp39_ = stmt;
	_tmp40_ = frame_rect;
	sqlite3_bind_int (_tmp38_, sqlite3_bind_parameter_index (_tmp39_, "$last_x"), _tmp40_.x);
	_tmp41_ = stmt;
	_tmp42_ = stmt;
	_tmp43_ = frame_rect;
	sqlite3_bind_int (_tmp41_, sqlite3_bind_parameter_index (_tmp42_, "$last_y"), _tmp43_.y);
	_tmp44_ = stmt;
	_tmp45_ = stmt;
	_tmp46_ = frame_rect;
	sqlite3_bind_int (_tmp44_, sqlite3_bind_parameter_index (_tmp45_, "$last_width"), _tmp46_.width);
	_tmp47_ = stmt;
	_tmp48_ = stmt;
	_tmp49_ = frame_rect;
	sqlite3_bind_int (_tmp47_, sqlite3_bind_parameter_index (_tmp48_, "$last_height"), _tmp49_.height);
	_tmp50_ = stmt;
	rc = sqlite3_step (_tmp50_);
	if (rc != SQLITE_DONE) {
		sqlite3* _tmp51_;
		const gchar* _tmp52_;
		_tmp51_ = gala_window_state_saver_db;
		_tmp52_ = sqlite3_errmsg (_tmp51_);
		g_critical ("WindowStateSaver.vala:205: Cannot update app position in database: %d," \
" %s", rc, _tmp52_);
		_sqlite3_finalize0 (stmt);
		_g_free0 (app_id);
		return;
	}
	_sqlite3_finalize0 (stmt);
	_g_free0 (app_id);
}

static void
gala_window_state_saver_save_all_windows_state (void)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	_tmp0_ = gala_window_state_saver_app_windows;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* windows_collection = NULL;
		GList* windows_it = NULL;
		windows_collection = _tmp1_;
		for (windows_it = windows_collection; windows_it != NULL; windows_it = windows_it->next) {
			GArray* windows = NULL;
			windows = (GArray*) windows_it->data;
			{
				GArray* _tmp2_;
				_tmp2_ = windows;
				{
					GArray* window_collection = NULL;
					guint window_index = 0U;
					window_collection = _tmp2_;
					for (window_index = 0; window_index < window_collection->len; window_index = window_index + 1) {
						MetaWindow* _tmp3_;
						MetaWindow* window = NULL;
						_tmp3_ = _g_object_ref0 (g_array_index (window_collection, MetaWindow*, window_index));
						window = _tmp3_;
						{
							MetaWindow* _tmp4_;
							_tmp4_ = window;
							gala_window_state_saver_save_window_state (_tmp4_);
							_g_object_unref0 (window);
						}
					}
				}
			}
		}
		(windows_collection == NULL) ? NULL : (windows_collection = (g_list_free (windows_collection), NULL));
	}
}

static gint
gala_window_state_saver_find_window_index (MetaWindow* window,
                                           const gchar* app_id)
{
	GHashTable* _tmp0_;
	GArray* windows_list = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	gint first_null = 0;
	GArray* _tmp13_;
	gint result;
	g_return_val_if_fail (window != NULL, 0);
	g_return_val_if_fail (app_id != NULL, 0);
	_tmp0_ = gala_window_state_saver_app_windows;
	_vala_return_val_if_fail (g_hash_table_contains (_tmp0_, app_id), "app_id in app_windows", 0);
	_tmp1_ = gala_window_state_saver_app_windows;
	_tmp2_ = g_hash_table_lookup (_tmp1_, app_id);
	windows_list = (GArray*) _tmp2_;
	first_null = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GArray* _tmp5_;
				MetaWindow* w = NULL;
				GArray* _tmp6_;
				gpointer* _tmp7_;
				gint _tmp7__length1;
				MetaWindow* _tmp8_;
				MetaWindow* _tmp9_;
				MetaWindow* _tmp10_;
				gboolean _tmp11_ = FALSE;
				MetaWindow* _tmp12_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = windows_list;
				if (!(((guint) i) < _tmp5_->len)) {
					break;
				}
				_tmp6_ = windows_list;
				_tmp7_ = _tmp6_->data;
				_tmp7__length1 = _tmp6_->len;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = _g_object_ref0 (_tmp8_);
				w = _tmp9_;
				_tmp10_ = w;
				if (_tmp10_ == window) {
					result = i;
					_g_object_unref0 (w);
					return result;
				}
				_tmp12_ = w;
				if (_tmp12_ == NULL) {
					_tmp11_ = first_null == -1;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					first_null = i;
				}
				_g_object_unref0 (w);
			}
		}
	}
	if (first_null != -1) {
		result = first_null;
		return result;
	}
	_tmp13_ = windows_list;
	result = (gint) _tmp13_->len;
	return result;
}

GalaWindowStateSaver*
gala_window_state_saver_construct (GType object_type)
{
	GalaWindowStateSaver * self = NULL;
	self = (GalaWindowStateSaver*) g_object_new (object_type, NULL);
	return self;
}

GalaWindowStateSaver*
gala_window_state_saver_new (void)
{
	return gala_window_state_saver_construct (GALA_TYPE_WINDOW_STATE_SAVER);
}

static void
gala_window_state_saver_login_manager_default_init (GalaWindowStateSaverLoginManagerIface * iface,
                                                    gpointer iface_data)
{
	gala_window_state_saver_login_manager_signals[GALA_WINDOW_STATE_SAVER_LOGIN_MANAGER_PREPARE_FOR_SLEEP_SIGNAL] = g_signal_new ("prepare-for-sleep", GALA_WINDOW_STATE_SAVER_TYPE_LOGIN_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

 G_GNUC_NO_INLINE static GType
gala_window_state_saver_login_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowStateSaverLoginManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_state_saver_login_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gala_window_state_saver_login_manager_type_id;
	gala_window_state_saver_login_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "GalaWindowStateSaverLoginManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gala_window_state_saver_login_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (gala_window_state_saver_login_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) gala_window_state_saver_login_manager_proxy_get_type);
	g_type_set_qdata (gala_window_state_saver_login_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Manager");
	g_type_set_qdata (gala_window_state_saver_login_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_gala_window_state_saver_login_manager_dbus_interface_info));
	g_type_set_qdata (gala_window_state_saver_login_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_window_state_saver_login_manager_register_object);
	return gala_window_state_saver_login_manager_type_id;
}

static GType
gala_window_state_saver_login_manager_get_type (void)
{
	static gsize gala_window_state_saver_login_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_window_state_saver_login_manager_type_id__once)) {
		GType gala_window_state_saver_login_manager_type_id;
		gala_window_state_saver_login_manager_type_id = gala_window_state_saver_login_manager_get_type_once ();
		g_once_init_leave (&gala_window_state_saver_login_manager_type_id__once, gala_window_state_saver_login_manager_type_id);
	}
	return gala_window_state_saver_login_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GalaWindowStateSaverLoginManagerProxy, gala_window_state_saver_login_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GALA_WINDOW_STATE_SAVER_TYPE_LOGIN_MANAGER, gala_window_state_saver_login_manager_proxy_gala_window_state_saver_login_manager_interface_init) )
static void
gala_window_state_saver_login_manager_proxy_class_init (GalaWindowStateSaverLoginManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = gala_window_state_saver_login_manager_proxy_g_signal;
}

static void
_dbus_handle_gala_window_state_saver_login_manager_prepare_for_sleep (GalaWindowStateSaverLoginManager* self,
                                                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gboolean about_to_suspend = FALSE;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	about_to_suspend = g_variant_get_boolean (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "prepare-for-sleep", about_to_suspend);
}

static void
gala_window_state_saver_login_manager_proxy_g_signal (GDBusProxy* proxy,
                                                      const gchar* sender_name,
                                                      const gchar* signal_name,
                                                      GVariant* parameters)
{
	if (strcmp (signal_name, "PrepareForSleep") == 0) {
		_dbus_handle_gala_window_state_saver_login_manager_prepare_for_sleep ((GalaWindowStateSaverLoginManager*) proxy, parameters);
	}
}

static void
gala_window_state_saver_login_manager_proxy_init (GalaWindowStateSaverLoginManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_gala_window_state_saver_login_manager_dbus_interface_info));
}

static void
gala_window_state_saver_login_manager_proxy_gala_window_state_saver_login_manager_interface_init (GalaWindowStateSaverLoginManagerIface* iface)
{
}

static void
gala_window_state_saver_login_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* method_name,
                                                                  GVariant* parameters,
                                                                  GDBusMethodInvocation* invocation,
                                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
gala_window_state_saver_login_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                   const gchar* sender,
                                                                   const gchar* object_path,
                                                                   const gchar* interface_name,
                                                                   const gchar* property_name,
                                                                   GError** error,
                                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
gala_window_state_saver_login_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                   const gchar* sender,
                                                                   const gchar* object_path,
                                                                   const gchar* interface_name,
                                                                   const gchar* property_name,
                                                                   GVariant* value,
                                                                   GError** error,
                                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_gala_window_state_saver_login_manager_prepare_for_sleep (GObject* _sender,
                                                               gboolean about_to_suspend,
                                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (about_to_suspend));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.login1.Manager", "PrepareForSleep", _arguments, NULL);
}

static guint
gala_window_state_saver_login_manager_register_object (gpointer object,
                                                       GDBusConnection* connection,
                                                       const gchar* path,
                                                       GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_window_state_saver_login_manager_dbus_interface_info), &_gala_window_state_saver_login_manager_dbus_interface_vtable, data, _gala_window_state_saver_login_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "prepare-for-sleep", (GCallback) _dbus_gala_window_state_saver_login_manager_prepare_for_sleep, data);
	return result;
}

static void
_gala_window_state_saver_login_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_window_state_saver_login_manager_prepare_for_sleep, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
gala_window_state_saver_class_init (GalaWindowStateSaverClass * klass,
                                    gpointer klass_data)
{
	gala_window_state_saver_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gala_window_state_saver_finalize;
}

static void
gala_window_state_saver_instance_init (GalaWindowStateSaver * self,
                                       gpointer klass)
{
}

static void
gala_window_state_saver_finalize (GObject * obj)
{
	GalaWindowStateSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_STATE_SAVER, GalaWindowStateSaver);
	G_OBJECT_CLASS (gala_window_state_saver_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_window_state_saver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowStateSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_state_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowStateSaver), 0, (GInstanceInitFunc) gala_window_state_saver_instance_init, NULL };
	GType gala_window_state_saver_type_id;
	gala_window_state_saver_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaWindowStateSaver", &g_define_type_info, 0);
	return gala_window_state_saver_type_id;
}

GType
gala_window_state_saver_get_type (void)
{
	static gsize gala_window_state_saver_type_id__once = 0;
	if (g_once_init_enter (&gala_window_state_saver_type_id__once)) {
		GType gala_window_state_saver_type_id;
		gala_window_state_saver_type_id = gala_window_state_saver_get_type_once ();
		g_once_init_leave (&gala_window_state_saver_type_id__once, gala_window_state_saver_type_id);
	}
	return gala_window_state_saver_type_id__once;
}

