/* IconGroup.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from IconGroup.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/display.h>
#include <meta/workspace.h>
#include <clutter/clutter.h>
#include <cairo-gobject.h>
#include <cogl/cogl.h>
#include <meta/window.h>
#include <meta/meta-workspace-manager.h>
#include <meta/common.h>

#define GALA_ICON_GROUP_SIZE 64
#define GALA_ICON_GROUP_PLUS_SIZE 6
#define GALA_ICON_GROUP_PLUS_WIDTH 26
#define GALA_ICON_GROUP_BACKDROP_ABSOLUTE_OPACITY 40
#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#define GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY 300
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;
typedef struct _GalaIconGroupPrivate GalaIconGroupPrivate;
enum  {
	GALA_ICON_GROUP_0_PROPERTY,
	GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY,
	GALA_ICON_GROUP_DISPLAY_PROPERTY,
	GALA_ICON_GROUP_WORKSPACE_PROPERTY,
	GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY,
	GALA_ICON_GROUP_NUM_PROPERTIES
};
static GParamSpec* gala_icon_group_properties[GALA_ICON_GROUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WINDOW_ICON_ACTOR (gala_window_icon_actor_get_type ())
#define GALA_WINDOW_ICON_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor))
#define GALA_WINDOW_ICON_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActorClass))
#define GALA_IS_WINDOW_ICON_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_ICON_ACTOR))
#define GALA_IS_WINDOW_ICON_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_ICON_ACTOR))
#define GALA_WINDOW_ICON_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActorClass))

typedef struct _GalaWindowIconActor GalaWindowIconActor;
typedef struct _GalaWindowIconActorClass GalaWindowIconActorClass;
typedef struct _Block58Data Block58Data;

#define GALA_TYPE_ICON_GROUP_CONTAINER (gala_icon_group_container_get_type ())
#define GALA_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer))
#define GALA_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))
#define GALA_IS_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_IS_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_ICON_GROUP_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))

typedef struct _GalaIconGroupContainer GalaIconGroupContainer;
typedef struct _GalaIconGroupContainerClass GalaIconGroupContainerClass;

#define GALA_TYPE_WORKSPACE_INSERT_THUMB (gala_workspace_insert_thumb_get_type ())
#define GALA_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb))
#define GALA_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))
#define GALA_IS_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_IS_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_WORKSPACE_INSERT_THUMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))

typedef struct _GalaWorkspaceInsertThumb GalaWorkspaceInsertThumb;
typedef struct _GalaWorkspaceInsertThumbClass GalaWorkspaceInsertThumbClass;
enum  {
	GALA_ICON_GROUP_SELECTED_SIGNAL,
	GALA_ICON_GROUP_NUM_SIGNALS
};
static guint gala_icon_group_signals[GALA_ICON_GROUP_NUM_SIGNALS] = {0};

struct _GalaIconGroup {
	GalaCanvasActor parent_instance;
	GalaIconGroupPrivate * priv;
};

struct _GalaIconGroupClass {
	GalaCanvasActorClass parent_class;
};

struct _GalaIconGroupPrivate {
	gfloat _backdrop_opacity;
	GalaDragDropAction* drag_action;
	MetaDisplay* _display;
	MetaWorkspace* _workspace;
	gfloat _scale_factor;
	ClutterActor* prev_parent;
	ClutterActor* icon_container;
};

struct _Block58Data {
	int _ref_count_;
	GalaIconGroup* self;
	GalaWindowIconActor* icon;
};

static gint GalaIconGroup_private_offset;
static gpointer gala_icon_group_parent_class = NULL;

VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN void gala_icon_group_redraw (GalaIconGroup* self);
static void _gala_icon_group_redraw_clutter_actor_child_removed (ClutterActor* _sender,
                                                          ClutterActor* child,
                                                          gpointer self);
VALA_EXTERN GalaIconGroup* gala_icon_group_new (MetaDisplay* display,
                                    MetaWorkspace* workspace,
                                    gfloat scale);
VALA_EXTERN GalaIconGroup* gala_icon_group_construct (GType object_type,
                                          MetaDisplay* display,
                                          MetaWorkspace* workspace,
                                          gfloat scale);
static void gala_icon_group_resize (GalaIconGroup* self);
VALA_EXTERN gfloat gala_icon_group_get_scale_factor (GalaIconGroup* self);
static void gala_icon_group_real_paint (ClutterActor* base,
                                 ClutterPaintContext* context);
VALA_EXTERN gfloat gala_icon_group_get_backdrop_opacity (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_clear (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN GType gala_window_icon_actor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowIconActor, g_object_unref)
VALA_EXTERN GalaWindowIconActor* gala_window_icon_actor_new (MetaWindow* window);
VALA_EXTERN GalaWindowIconActor* gala_window_icon_actor_construct (GType object_type,
                                                       MetaWindow* window);
VALA_EXTERN void gala_window_icon_actor_set_temporary (GalaWindowIconActor* self,
                                           gboolean value);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
VALA_EXTERN MetaWindow* gala_window_icon_actor_get_window (GalaWindowIconActor* self);
static void _______lambda67_ (Block58Data* _data58_);
static void ________lambda67__clutter_timeline_completed (ClutterTimeline* _sender,
                                                   gpointer self);
VALA_EXTERN void gala_icon_group_set_hovered_actor (GalaIconGroup* self,
                                        ClutterActor* actor);
static void gala_icon_group_real_draw (GalaCanvasActor* base,
                                cairo_t* cr,
                                gint cr_width,
                                gint cr_height);
VALA_EXTERN void gala_window_icon_actor_place (GalaWindowIconActor* self,
                                   gfloat x,
                                   gfloat y,
                                   gint size,
                                   gfloat scale);
VALA_EXTERN MetaWorkspace* gala_icon_group_get_workspace (GalaIconGroup* self);
static ClutterActor* gala_icon_group_drag_begin (GalaIconGroup* self,
                                          gfloat click_x,
                                          gfloat click_y);
VALA_EXTERN GType gala_icon_group_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroupContainer, g_object_unref)
VALA_EXTERN void gala_icon_group_container_remove_group_in_place (GalaIconGroupContainer* self,
                                                      GalaIconGroup* group);
VALA_EXTERN void gala_icon_group_container_reset_thumbs (GalaIconGroupContainer* self,
                                             gint delay);
VALA_EXTERN MetaDisplay* gala_icon_group_get_display (GalaIconGroup* self);
static void gala_icon_group_drag_end (GalaIconGroup* self,
                               ClutterActor* destination);
VALA_EXTERN GType gala_workspace_insert_thumb_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceInsertThumb, g_object_unref)
VALA_EXTERN gint gala_workspace_insert_thumb_get_workspace_index (GalaWorkspaceInsertThumb* self);
static void gala_icon_group_restore_group (GalaIconGroup* self);
static void gala_icon_group_drag_canceled (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_container_add_group (GalaIconGroupContainer* self,
                                          GalaIconGroup* group);
VALA_EXTERN void gala_icon_group_set_backdrop_opacity (GalaIconGroup* self,
                                           gfloat value);
static void gala_icon_group_set_display (GalaIconGroup* self,
                                  MetaDisplay* value);
static void gala_icon_group_set_workspace (GalaIconGroup* self,
                                    MetaWorkspace* value);
VALA_EXTERN void gala_icon_group_set_scale_factor (GalaIconGroup* self,
                                       gfloat value);
static GObject * gala_icon_group_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _gala_icon_group___lambda75_ (GalaIconGroup* self);
static void __gala_icon_group___lambda75__gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                        guint32 button,
                                                                        ClutterInputDeviceType device_type,
                                                                        gpointer self);
static ClutterActor* _gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                            gfloat x,
                                                                            gfloat y,
                                                                            gpointer self);
static void _gala_icon_group_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                               ClutterActor* actor,
                                                               gpointer self);
static void _gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                         gpointer self);
static void _gala_icon_group_redraw_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self);
static void gala_icon_group_finalize (GObject * obj);
static GType gala_icon_group_get_type_once (void);
static void _vala_gala_icon_group_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gala_icon_group_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
gala_icon_group_get_instance_private (GalaIconGroup* self)
{
	return G_STRUCT_MEMBER_P (self, GalaIconGroup_private_offset);
}

static void
_gala_icon_group_redraw_clutter_actor_child_removed (ClutterActor* _sender,
                                                     ClutterActor* child,
                                                     gpointer self)
{
	gala_icon_group_redraw ((GalaIconGroup*) self);
}

GalaIconGroup*
gala_icon_group_construct (GType object_type,
                           MetaDisplay* display,
                           MetaWorkspace* workspace,
                           gfloat scale)
{
	GalaIconGroup * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (workspace != NULL, NULL);
	self = (GalaIconGroup*) g_object_new (object_type, "display", display, "workspace", workspace, "scale-factor", scale, NULL);
	return self;
}

GalaIconGroup*
gala_icon_group_new (MetaDisplay* display,
                     MetaWorkspace* workspace,
                     gfloat scale)
{
	return gala_icon_group_construct (GALA_TYPE_ICON_GROUP, display, workspace, scale);
}

static void
gala_icon_group_resize (GalaIconGroup* self)
{
	gint size = 0;
	gfloat _tmp0_;
	gfloat _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_icon_group_get_scale_factor (self);
	_tmp1_ = _tmp0_;
	size = gala_utils_scale_to_int (GALA_ICON_GROUP_SIZE, _tmp1_);
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) size);
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) size);
}

/**
     * Override the paint handler to draw our backdrop if necessary
     */
static void
gala_icon_group_real_paint (ClutterActor* base,
                            ClutterPaintContext* context)
{
	GalaIconGroup * self;
	gboolean _tmp0_ = FALSE;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gint width = 0;
	gfloat _tmp6_;
	gfloat _tmp7_;
	gint x = 0;
	gfloat _tmp8_;
	gfloat _tmp9_;
	gint y = 0;
	gint height = 0;
	gfloat _tmp10_;
	gfloat _tmp11_;
	guint8 backdrop_opacity_int = 0U;
	gfloat _tmp12_;
	gfloat _tmp13_;
	CoglVertexP2T2C4 vertices[4] = {0};
	CoglVertexP2T2C4 _tmp14_ = {0};
	CoglVertexP2T2C4 _tmp15_ = {0};
	CoglVertexP2T2C4 _tmp16_ = {0};
	CoglVertexP2T2C4 _tmp17_ = {0};
	CoglPrimitive* primitive = NULL;
	CoglFramebuffer* _tmp18_;
	CoglContext* _tmp19_;
	CoglPrimitive* _tmp20_;
	CoglPipeline* pipeline = NULL;
	CoglFramebuffer* _tmp21_;
	CoglContext* _tmp22_;
	CoglPipeline* _tmp23_;
	CoglPrimitive* _tmp24_;
	CoglFramebuffer* _tmp25_;
	CoglPipeline* _tmp26_;
	self = (GalaIconGroup*) base;
	g_return_if_fail (context != NULL);
	_tmp1_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp2_ = _tmp1_;
	if (((gdouble) _tmp2_) == 0.0) {
		_tmp0_ = TRUE;
	} else {
		GalaDragDropAction* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->drag_action;
		_tmp4_ = gala_drag_drop_action_get_dragging (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		CLUTTER_ACTOR_CLASS (gala_icon_group_parent_class)->paint ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_CANVAS_ACTOR, GalaCanvasActor), context);
		return;
	}
	_tmp6_ = gala_icon_group_get_scale_factor (self);
	_tmp7_ = _tmp6_;
	width = gala_utils_scale_to_int (100, _tmp7_);
	_tmp8_ = gala_icon_group_get_scale_factor (self);
	_tmp9_ = _tmp8_;
	x = (gala_utils_scale_to_int (GALA_ICON_GROUP_SIZE, _tmp9_) - width) / 2;
	y = -10;
	_tmp10_ = gala_icon_group_get_scale_factor (self);
	_tmp11_ = _tmp10_;
	height = gala_utils_scale_to_int (GALA_WORKSPACE_CLONE_BOTTOM_OFFSET, _tmp11_);
	_tmp12_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp13_ = _tmp12_;
	backdrop_opacity_int = (guint8) (GALA_ICON_GROUP_BACKDROP_ABSOLUTE_OPACITY * _tmp13_);
	_tmp14_.x = (gfloat) x;
	_tmp14_.y = (gfloat) (y + height);
	_tmp14_.s = (gfloat) 0;
	_tmp14_.t = (gfloat) 1;
	_tmp14_.r = backdrop_opacity_int;
	_tmp14_.g = backdrop_opacity_int;
	_tmp14_.b = backdrop_opacity_int;
	_tmp14_.a = backdrop_opacity_int;
	vertices[0] = _tmp14_;
	_tmp15_.x = (gfloat) x;
	_tmp15_.y = (gfloat) y;
	_tmp15_.s = (gfloat) 0;
	_tmp15_.t = (gfloat) 0;
	_tmp15_.r = (guint8) 0;
	_tmp15_.g = (guint8) 0;
	_tmp15_.b = (guint8) 0;
	_tmp15_.a = (guint8) 0;
	vertices[1] = _tmp15_;
	_tmp16_.x = (gfloat) (x + width);
	_tmp16_.y = (gfloat) (y + height);
	_tmp16_.s = (gfloat) 1;
	_tmp16_.t = (gfloat) 1;
	_tmp16_.r = backdrop_opacity_int;
	_tmp16_.g = backdrop_opacity_int;
	_tmp16_.b = backdrop_opacity_int;
	_tmp16_.a = backdrop_opacity_int;
	vertices[2] = _tmp16_;
	_tmp17_.x = (gfloat) (x + width);
	_tmp17_.y = (gfloat) y;
	_tmp17_.s = (gfloat) 1;
	_tmp17_.t = (gfloat) 0;
	_tmp17_.r = (guint8) 0;
	_tmp17_.g = (guint8) 0;
	_tmp17_.b = (guint8) 0;
	_tmp17_.a = (guint8) 0;
	vertices[3] = _tmp17_;
	_tmp18_ = clutter_paint_context_get_framebuffer (context);
	_tmp19_ = cogl_framebuffer_get_context (_tmp18_);
	_tmp20_ = cogl_primitive_new_p2t2c4 (_tmp19_, COGL_VERTICES_MODE_TRIANGLE_STRIP, 4, vertices);
	primitive = _tmp20_;
	_tmp21_ = clutter_paint_context_get_framebuffer (context);
	_tmp22_ = cogl_framebuffer_get_context (_tmp21_);
	_tmp23_ = cogl_pipeline_new (_tmp22_);
	pipeline = _tmp23_;
	_tmp24_ = primitive;
	_tmp25_ = clutter_paint_context_get_framebuffer (context);
	_tmp26_ = pipeline;
	cogl_primitive_draw (_tmp24_, _tmp25_, _tmp26_);
	CLUTTER_ACTOR_CLASS (gala_icon_group_parent_class)->paint ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_CANVAS_ACTOR, GalaCanvasActor), context);
	_g_object_unref0 (pipeline);
	_g_object_unref0 (primitive);
}

/**
     * Remove all currently added WindowIconActors
     */
void
gala_icon_group_clear (GalaIconGroup* self)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon_container;
	clutter_actor_destroy_all_children (_tmp0_);
}

/**
     * Creates a WindowIconActor for the given window and adds it to the group
     *
     * @param window    The MetaWindow for which to create the WindowIconActor
     * @param no_redraw If you add multiple windows at once you may want to consider
     *                  settings this to true and when done calling redraw() manually
     * @param temporary Mark the WindowIconActor as temporary. Used for windows dragged over
     *                  the group.
     */
void
gala_icon_group_add_window (GalaIconGroup* self,
                            MetaWindow* window,
                            gboolean no_redraw,
                            gboolean temporary)
{
	GalaWindowIconActor* new_window = NULL;
	GalaWindowIconActor* _tmp0_;
	GalaWindowIconActor* _tmp1_;
	GalaWindowIconActor* _tmp2_;
	ClutterActor* _tmp3_;
	GalaWindowIconActor* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = gala_window_icon_actor_new (window);
	g_object_ref_sink (_tmp0_);
	new_window = _tmp0_;
	_tmp1_ = new_window;
	clutter_actor_set_position ((ClutterActor*) _tmp1_, (gfloat) 32, (gfloat) 32);
	_tmp2_ = new_window;
	gala_window_icon_actor_set_temporary (_tmp2_, temporary);
	_tmp3_ = self->priv->icon_container;
	_tmp4_ = new_window;
	clutter_actor_add_child (_tmp3_, (ClutterActor*) _tmp4_);
	if (!no_redraw) {
		gala_icon_group_redraw (self);
	}
	_g_object_unref0 (new_window);
}

/**
     * Remove the WindowIconActor for a MetaWindow from the group
     *
     * @param animate Whether to fade the icon out before removing it
     */
static Block58Data*
block58_data_ref (Block58Data* _data58_)
{
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}

static void
block58_data_unref (void * _userdata_)
{
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		GalaIconGroup* self;
		self = _data58_->self;
		_g_object_unref0 (self);
		g_slice_free (Block58Data, _data58_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_______lambda67_ (Block58Data* _data58_)
{
	GalaIconGroup* self;
	GalaWindowIconActor* _tmp0_;
	self = _data58_->self;
	_tmp0_ = _data58_->icon;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
}

static void
________lambda67__clutter_timeline_completed (ClutterTimeline* _sender,
                                              gpointer self)
{
	_______lambda67_ (self);
}

void
gala_icon_group_remove_window (GalaIconGroup* self,
                               MetaWindow* window,
                               gboolean animate)
{
	ClutterActor* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->icon_container;
	_tmp1_ = clutter_actor_get_children (_tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				Block58Data* _data58_;
				ClutterActor* _tmp2_;
				GalaWindowIconActor* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp5_;
				_data58_ = g_slice_new0 (Block58Data);
				_data58_->_ref_count_ = 1;
				_data58_->self = g_object_ref (self);
				_tmp2_ = child;
				_data58_->icon = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor);
				_tmp3_ = _data58_->icon;
				_tmp4_ = gala_window_icon_actor_get_window (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ == window) {
					if (animate) {
						GalaWindowIconActor* _tmp6_;
						GalaWindowIconActor* _tmp7_;
						GalaWindowIconActor* _tmp8_;
						GalaWindowIconActor* _tmp9_;
						GalaWindowIconActor* _tmp10_;
						ClutterTransition* transition = NULL;
						GalaWindowIconActor* _tmp11_;
						ClutterTransition* _tmp12_;
						ClutterTransition* _tmp13_;
						ClutterTransition* _tmp14_;
						_tmp6_ = _data58_->icon;
						clutter_actor_save_easing_state ((ClutterActor*) _tmp6_);
						_tmp7_ = _data58_->icon;
						clutter_actor_set_easing_mode ((ClutterActor*) _tmp7_, CLUTTER_LINEAR);
						_tmp8_ = _data58_->icon;
						clutter_actor_set_easing_duration ((ClutterActor*) _tmp8_, gala_utils_get_animation_duration ((guint) 200));
						_tmp9_ = _data58_->icon;
						clutter_actor_set_opacity ((ClutterActor*) _tmp9_, (guint) 0);
						_tmp10_ = _data58_->icon;
						clutter_actor_restore_easing_state ((ClutterActor*) _tmp10_);
						_tmp11_ = _data58_->icon;
						_tmp12_ = clutter_actor_get_transition ((ClutterActor*) _tmp11_, "opacity");
						_tmp13_ = _g_object_ref0 (_tmp12_);
						transition = _tmp13_;
						_tmp14_ = transition;
						if (_tmp14_ != NULL) {
							ClutterTransition* _tmp15_;
							_tmp15_ = transition;
							g_signal_connect_data ((ClutterTimeline*) _tmp15_, "completed", (GCallback) ________lambda67__clutter_timeline_completed, block58_data_ref (_data58_), (GClosureNotify) block58_data_unref, 0);
						} else {
							GalaWindowIconActor* _tmp16_;
							_tmp16_ = _data58_->icon;
							clutter_actor_destroy ((ClutterActor*) _tmp16_);
						}
						_g_object_unref0 (transition);
					} else {
						GalaWindowIconActor* _tmp17_;
						_tmp17_ = _data58_->icon;
						clutter_actor_destroy ((ClutterActor*) _tmp17_);
					}
				}
				block58_data_unref (_data58_);
				_data58_ = NULL;
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

/**
     * Sets a hovered actor for the drag action.
     */
void
gala_icon_group_set_hovered_actor (GalaIconGroup* self,
                                   ClutterActor* actor)
{
	GalaDragDropAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->drag_action;
	gala_drag_drop_action_set_hovered (_tmp0_, actor);
}

/**
     * Trigger a redraw
     */
void
gala_icon_group_redraw (GalaIconGroup* self)
{
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	clutter_content_invalidate (_tmp1_);
}

/**
     * Draw the background or plus sign and do layouting. We won't lose performance here
     * by relayouting in the same function, as it's only ever called when we invalidate it.
     */
static void
gala_icon_group_real_draw (GalaCanvasActor* base,
                           cairo_t* cr,
                           gint cr_width,
                           gint cr_height)
{
	GalaIconGroup * self;
	gint n_windows = 0;
	ClutterActor* _tmp0_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	GalaShadowEffect* shadow_effect = NULL;
	gfloat _tmp13_;
	gfloat _tmp14_;
	GalaShadowEffect* _tmp15_ = NULL;
	GalaDrawingStyleManager* style_manager = NULL;
	GalaDrawingStyleManager* _tmp16_;
	GalaDrawingStyleManager* _tmp17_;
	GalaDrawingStyleManagerColorScheme _tmp18_;
	GalaDrawingStyleManagerColorScheme _tmp19_;
	GalaDragDropAction* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	GalaShadowEffect* _tmp33_;
	MetaWorkspaceManager* manager = NULL;
	MetaWorkspace* _tmp34_;
	MetaDisplay* _tmp35_;
	MetaWorkspaceManager* _tmp36_;
	gint workspace_index = 0;
	gint scaled_size = 0;
	gfloat _tmp43_;
	gfloat _tmp44_;
	gint size = 0;
	guint n_tiled_windows = 0U;
	gint columns = 0;
	gint rows = 0;
	gint spacing = 0;
	gfloat _tmp116_;
	gfloat _tmp117_;
	gint width = 0;
	gfloat _tmp118_;
	gfloat _tmp119_;
	gint height = 0;
	gfloat _tmp120_;
	gfloat _tmp121_;
	gint x_offset = 0;
	gint y_offset = 0;
	gboolean show_ellipsis = FALSE;
	gint n_shown_windows = 0;
	gint x = 0;
	gint y = 0;
	self = (GalaIconGroup*) base;
	g_return_if_fail (cr != NULL);
	clutter_actor_clear_effects ((ClutterActor*) self);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	_tmp0_ = self->priv->icon_container;
	n_windows = clutter_actor_get_n_children (_tmp0_);
	if (n_windows == 1) {
		GalaWindowIconActor* icon = NULL;
		ClutterActor* _tmp1_;
		ClutterActor* _tmp2_;
		GalaWindowIconActor* _tmp3_;
		GalaWindowIconActor* _tmp4_;
		gfloat _tmp5_;
		gfloat _tmp6_;
		_tmp1_ = self->priv->icon_container;
		_tmp2_ = clutter_actor_get_child_at_index (_tmp1_, 0);
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor));
		icon = _tmp3_;
		_tmp4_ = icon;
		_tmp5_ = gala_icon_group_get_scale_factor (self);
		_tmp6_ = _tmp5_;
		gala_window_icon_actor_place (_tmp4_, (gfloat) 0, (gfloat) 0, 64, _tmp6_);
		_g_object_unref0 (icon);
		return;
	}
	_tmp7_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gala_icon_group_get_scale_factor (self);
	_tmp12_ = _tmp11_;
	gala_drawing_utilities_cairo_rounded_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) _tmp8_, (gdouble) _tmp10_, (gdouble) gala_utils_scale_to_int (5, _tmp12_));
	_tmp13_ = gala_icon_group_get_scale_factor (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gala_shadow_effect_new ("", _tmp14_);
	gala_shadow_effect_set_border_radius (_tmp15_, 6);
	g_object_ref_sink (_tmp15_);
	shadow_effect = _tmp15_;
	_tmp16_ = gala_drawing_style_manager_get_instance ();
	style_manager = _tmp16_;
	_tmp17_ = style_manager;
	_tmp18_ = gala_drawing_style_manager_get_prefers_color_scheme (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK) {
		static const gdouble BG_COLOR = 35.0 / 255.0;
		GalaDragDropAction* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = self->priv->drag_action;
		_tmp21_ = gala_drag_drop_action_get_dragging (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			cairo_set_source_rgba (cr, BG_COLOR, BG_COLOR, BG_COLOR, 0.8);
		} else {
			GalaShadowEffect* _tmp23_;
			cairo_set_source_rgba (cr, BG_COLOR, BG_COLOR, BG_COLOR, 0.5);
			_tmp23_ = shadow_effect;
			gala_shadow_effect_set_shadow_opacity (_tmp23_, (guint8) 200);
		}
	} else {
		GalaDragDropAction* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = self->priv->drag_action;
		_tmp25_ = gala_drag_drop_action_get_dragging (_tmp24_);
		_tmp26_ = _tmp25_;
		if (_tmp26_) {
			cairo_set_source_rgba (cr, (gdouble) 255, (gdouble) 255, (gdouble) 255, 0.8);
		} else {
			GalaShadowEffect* _tmp27_;
			cairo_set_source_rgba (cr, (gdouble) 255, (gdouble) 255, (gdouble) 255, 0.3);
			_tmp27_ = shadow_effect;
			gala_shadow_effect_set_shadow_opacity (_tmp27_, (guint8) 100);
		}
	}
	_tmp28_ = self->priv->drag_action;
	_tmp29_ = gala_drag_drop_action_get_dragging (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		GalaShadowEffect* _tmp31_;
		_tmp31_ = shadow_effect;
		gala_shadow_effect_set_css_class (_tmp31_, "workspace-switcher-dnd");
	} else {
		GalaShadowEffect* _tmp32_;
		_tmp32_ = shadow_effect;
		gala_shadow_effect_set_css_class (_tmp32_, "workspace-switcher");
	}
	_tmp33_ = shadow_effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp33_);
	cairo_fill_preserve (cr);
	_tmp34_ = self->priv->_workspace;
	_tmp35_ = meta_workspace_get_display (_tmp34_);
	_tmp36_ = meta_display_get_workspace_manager (_tmp35_);
	manager = _tmp36_;
	workspace_index = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp39_;
				MetaWorkspaceManager* _tmp40_;
				MetaWorkspace* _tmp41_;
				MetaWorkspace* _tmp42_;
				if (!_tmp37_) {
					gint _tmp38_;
					_tmp38_ = i;
					i = _tmp38_ + 1;
				}
				_tmp37_ = FALSE;
				_tmp39_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp39_))) {
					break;
				}
				_tmp40_ = manager;
				_tmp41_ = meta_workspace_manager_get_workspace_by_index (_tmp40_, i);
				_tmp42_ = self->priv->_workspace;
				if (_tmp41_ == _tmp42_) {
					workspace_index = i;
					break;
				}
			}
		}
	}
	_tmp43_ = gala_icon_group_get_scale_factor (self);
	_tmp44_ = _tmp43_;
	scaled_size = gala_utils_scale_to_int (GALA_ICON_GROUP_SIZE, _tmp44_);
	if (n_windows < 1) {
		MetaWorkspaceManager* _tmp45_;
		GalaDrawingBufferSurface* buffer = NULL;
		GalaDrawingBufferSurface* _tmp46_;
		gint offset = 0;
		gfloat _tmp47_;
		gfloat _tmp48_;
		GalaDrawingBufferSurface* _tmp49_;
		cairo_t* _tmp50_;
		cairo_t* _tmp51_;
		gfloat _tmp52_;
		gfloat _tmp53_;
		gfloat _tmp54_;
		gfloat _tmp55_;
		gfloat _tmp56_;
		gfloat _tmp57_;
		gfloat _tmp58_;
		gfloat _tmp59_;
		GalaDrawingBufferSurface* _tmp60_;
		cairo_t* _tmp61_;
		cairo_t* _tmp62_;
		gfloat _tmp63_;
		gfloat _tmp64_;
		gfloat _tmp65_;
		gfloat _tmp66_;
		gfloat _tmp67_;
		gfloat _tmp68_;
		gfloat _tmp69_;
		gfloat _tmp70_;
		GalaDrawingStyleManager* _tmp71_;
		GalaDrawingStyleManagerColorScheme _tmp72_;
		GalaDrawingStyleManagerColorScheme _tmp73_;
		GalaDrawingBufferSurface* _tmp110_;
		cairo_t* _tmp111_;
		cairo_t* _tmp112_;
		GalaDrawingBufferSurface* _tmp113_;
		cairo_surface_t* _tmp114_;
		cairo_surface_t* _tmp115_;
		_tmp45_ = manager;
		if (workspace_index != (meta_workspace_manager_get_n_workspaces (_tmp45_) - 1)) {
			_g_object_unref0 (style_manager);
			_g_object_unref0 (shadow_effect);
			return;
		}
		_tmp46_ = gala_drawing_buffer_surface_new (scaled_size, scaled_size);
		buffer = _tmp46_;
		_tmp47_ = gala_icon_group_get_scale_factor (self);
		_tmp48_ = _tmp47_;
		offset = (scaled_size / 2) - (gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH, _tmp48_) / 2);
		_tmp49_ = buffer;
		_tmp50_ = gala_drawing_buffer_surface_get_context (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = gala_icon_group_get_scale_factor (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = gala_icon_group_get_scale_factor (self);
		_tmp55_ = _tmp54_;
		_tmp56_ = gala_icon_group_get_scale_factor (self);
		_tmp57_ = _tmp56_;
		_tmp58_ = gala_icon_group_get_scale_factor (self);
		_tmp59_ = _tmp58_;
		cairo_rectangle (_tmp51_, (gdouble) ((gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH / 2, _tmp53_) - gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_SIZE / 2, _tmp55_)) + offset), (gdouble) offset, (gdouble) gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_SIZE, _tmp57_), (gdouble) gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH, _tmp59_));
		_tmp60_ = buffer;
		_tmp61_ = gala_drawing_buffer_surface_get_context (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = gala_icon_group_get_scale_factor (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = gala_icon_group_get_scale_factor (self);
		_tmp66_ = _tmp65_;
		_tmp67_ = gala_icon_group_get_scale_factor (self);
		_tmp68_ = _tmp67_;
		_tmp69_ = gala_icon_group_get_scale_factor (self);
		_tmp70_ = _tmp69_;
		cairo_rectangle (_tmp62_, (gdouble) offset, (gdouble) ((gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH / 2, _tmp64_) - gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_SIZE / 2, _tmp66_)) + offset), (gdouble) gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH, _tmp68_), (gdouble) gala_utils_scale_to_int (GALA_ICON_GROUP_PLUS_SIZE, _tmp70_));
		_tmp71_ = style_manager;
		_tmp72_ = gala_drawing_style_manager_get_prefers_color_scheme (_tmp71_);
		_tmp73_ = _tmp72_;
		if (_tmp73_ == GALA_DRAWING_STYLE_MANAGER_COLOR_SCHEME_DARK) {
			GalaDrawingBufferSurface* _tmp74_;
			cairo_t* _tmp75_;
			cairo_t* _tmp76_;
			gfloat _tmp77_;
			gfloat _tmp78_;
			GalaDrawingBufferSurface* _tmp79_;
			cairo_t* _tmp80_;
			cairo_t* _tmp81_;
			GalaDrawingBufferSurface* _tmp82_;
			cairo_t* _tmp83_;
			cairo_t* _tmp84_;
			GalaDrawingBufferSurface* _tmp85_;
			GalaDrawingBufferSurface* _tmp86_;
			cairo_t* _tmp87_;
			cairo_t* _tmp88_;
			GalaDrawingBufferSurface* _tmp89_;
			cairo_t* _tmp90_;
			cairo_t* _tmp91_;
			_tmp74_ = buffer;
			_tmp75_ = gala_drawing_buffer_surface_get_context (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = gala_icon_group_get_scale_factor (self);
			_tmp78_ = _tmp77_;
			cairo_move_to (_tmp76_, (gdouble) 0, (gdouble) (1 * _tmp78_));
			_tmp79_ = buffer;
			_tmp80_ = gala_drawing_buffer_surface_get_context (_tmp79_);
			_tmp81_ = _tmp80_;
			cairo_set_source_rgb (_tmp81_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
			_tmp82_ = buffer;
			_tmp83_ = gala_drawing_buffer_surface_get_context (_tmp82_);
			_tmp84_ = _tmp83_;
			cairo_fill_preserve (_tmp84_);
			_tmp85_ = buffer;
			gala_drawing_buffer_surface_exponential_blur (_tmp85_, 2);
			_tmp86_ = buffer;
			_tmp87_ = gala_drawing_buffer_surface_get_context (_tmp86_);
			_tmp88_ = _tmp87_;
			cairo_move_to (_tmp88_, (gdouble) 0, (gdouble) 0);
			_tmp89_ = buffer;
			_tmp90_ = gala_drawing_buffer_surface_get_context (_tmp89_);
			_tmp91_ = _tmp90_;
			cairo_set_source_rgba (_tmp91_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.95);
		} else {
			GalaDrawingBufferSurface* _tmp92_;
			cairo_t* _tmp93_;
			cairo_t* _tmp94_;
			gfloat _tmp95_;
			gfloat _tmp96_;
			GalaDrawingBufferSurface* _tmp97_;
			cairo_t* _tmp98_;
			cairo_t* _tmp99_;
			GalaDrawingBufferSurface* _tmp100_;
			cairo_t* _tmp101_;
			cairo_t* _tmp102_;
			GalaDrawingBufferSurface* _tmp103_;
			GalaDrawingBufferSurface* _tmp104_;
			cairo_t* _tmp105_;
			cairo_t* _tmp106_;
			GalaDrawingBufferSurface* _tmp107_;
			cairo_t* _tmp108_;
			cairo_t* _tmp109_;
			_tmp92_ = buffer;
			_tmp93_ = gala_drawing_buffer_surface_get_context (_tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = gala_icon_group_get_scale_factor (self);
			_tmp96_ = _tmp95_;
			cairo_move_to (_tmp94_, (gdouble) 0, (gdouble) (1 * _tmp96_));
			_tmp97_ = buffer;
			_tmp98_ = gala_drawing_buffer_surface_get_context (_tmp97_);
			_tmp99_ = _tmp98_;
			cairo_set_source_rgba (_tmp99_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.4);
			_tmp100_ = buffer;
			_tmp101_ = gala_drawing_buffer_surface_get_context (_tmp100_);
			_tmp102_ = _tmp101_;
			cairo_fill_preserve (_tmp102_);
			_tmp103_ = buffer;
			gala_drawing_buffer_surface_exponential_blur (_tmp103_, 1);
			_tmp104_ = buffer;
			_tmp105_ = gala_drawing_buffer_surface_get_context (_tmp104_);
			_tmp106_ = _tmp105_;
			cairo_move_to (_tmp106_, (gdouble) 0, (gdouble) 0);
			_tmp107_ = buffer;
			_tmp108_ = gala_drawing_buffer_surface_get_context (_tmp107_);
			_tmp109_ = _tmp108_;
			cairo_set_source_rgba (_tmp109_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.7);
		}
		_tmp110_ = buffer;
		_tmp111_ = gala_drawing_buffer_surface_get_context (_tmp110_);
		_tmp112_ = _tmp111_;
		cairo_fill (_tmp112_);
		_tmp113_ = buffer;
		_tmp114_ = gala_drawing_buffer_surface_get_surface (_tmp113_);
		_tmp115_ = _tmp114_;
		cairo_set_source_surface (cr, _tmp115_, (gdouble) 0, (gdouble) 0);
		cairo_paint (cr);
		_g_object_unref0 (buffer);
		_g_object_unref0 (style_manager);
		_g_object_unref0 (shadow_effect);
		return;
	}
	if (n_windows < 5) {
		size = 24;
	} else {
		size = 16;
	}
	n_tiled_windows = MIN ((guint) n_windows, (guint) 9);
	columns = (gint) ceil (sqrt ((gdouble) n_tiled_windows));
	rows = (gint) ceil (n_tiled_windows / ((gdouble) columns));
	_tmp116_ = gala_icon_group_get_scale_factor (self);
	_tmp117_ = _tmp116_;
	spacing = gala_utils_scale_to_int (6, _tmp117_);
	_tmp118_ = gala_icon_group_get_scale_factor (self);
	_tmp119_ = _tmp118_;
	width = (columns * gala_utils_scale_to_int (size, _tmp119_)) + ((columns - 1) * spacing);
	_tmp120_ = gala_icon_group_get_scale_factor (self);
	_tmp121_ = _tmp120_;
	height = (rows * gala_utils_scale_to_int (size, _tmp121_)) + ((rows - 1) * spacing);
	x_offset = (scaled_size / 2) - (width / 2);
	y_offset = (scaled_size / 2) - (height / 2);
	show_ellipsis = FALSE;
	n_shown_windows = n_windows;
	if (n_shown_windows > 9) {
		n_shown_windows = 8;
		show_ellipsis = TRUE;
	}
	x = x_offset;
	y = y_offset;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp122_ = FALSE;
			_tmp122_ = TRUE;
			while (TRUE) {
				GalaWindowIconActor* window = NULL;
				ClutterActor* _tmp124_;
				ClutterActor* _tmp125_;
				GalaWindowIconActor* _tmp126_;
				gboolean _tmp127_ = FALSE;
				GalaWindowIconActor* _tmp137_;
				gfloat _tmp138_;
				gfloat _tmp139_;
				gfloat _tmp140_;
				gfloat _tmp141_;
				gfloat _tmp142_;
				gfloat _tmp143_;
				if (!_tmp122_) {
					gint _tmp123_;
					_tmp123_ = i;
					i = _tmp123_ + 1;
				}
				_tmp122_ = FALSE;
				if (!(i < n_windows)) {
					break;
				}
				_tmp124_ = self->priv->icon_container;
				_tmp125_ = clutter_actor_get_child_at_index (_tmp124_, i);
				_tmp126_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor));
				window = _tmp126_;
				if (show_ellipsis) {
					_tmp127_ = i == 8;
				} else {
					_tmp127_ = FALSE;
				}
				if (_tmp127_) {
					gint top_offset = 0;
					gfloat _tmp128_;
					gfloat _tmp129_;
					gint left_offset = 0;
					gfloat _tmp130_;
					gfloat _tmp131_;
					gint radius = 0;
					gfloat _tmp132_;
					gfloat _tmp133_;
					gint dot_spacing = 0;
					gfloat _tmp134_;
					gfloat _tmp135_;
					_tmp128_ = gala_icon_group_get_scale_factor (self);
					_tmp129_ = _tmp128_;
					top_offset = gala_utils_scale_to_int (10, _tmp129_);
					_tmp130_ = gala_icon_group_get_scale_factor (self);
					_tmp131_ = _tmp130_;
					left_offset = gala_utils_scale_to_int (2, _tmp131_);
					_tmp132_ = gala_icon_group_get_scale_factor (self);
					_tmp133_ = _tmp132_;
					radius = gala_utils_scale_to_int (2, _tmp133_);
					_tmp134_ = gala_icon_group_get_scale_factor (self);
					_tmp135_ = _tmp134_;
					dot_spacing = gala_utils_scale_to_int (3, _tmp135_);
					cairo_arc (cr, (gdouble) (left_offset + x), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_arc (cr, (gdouble) (((left_offset + x) + radius) + dot_spacing), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_arc (cr, (gdouble) (((left_offset + x) + (radius * 2)) + (dot_spacing * 2)), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_set_source_rgb (cr, 0.3, 0.3, 0.3);
					cairo_fill (cr);
				}
				if (i >= n_shown_windows) {
					GalaWindowIconActor* _tmp136_;
					_tmp136_ = window;
					g_object_set ((ClutterActor*) _tmp136_, "visible", FALSE, NULL);
					_g_object_unref0 (window);
					continue;
				}
				_tmp137_ = window;
				_tmp138_ = gala_icon_group_get_scale_factor (self);
				_tmp139_ = _tmp138_;
				gala_window_icon_actor_place (_tmp137_, (gfloat) x, (gfloat) y, size, _tmp139_);
				_tmp140_ = gala_icon_group_get_scale_factor (self);
				_tmp141_ = _tmp140_;
				x += gala_utils_scale_to_int (size, _tmp141_) + spacing;
				_tmp142_ = gala_icon_group_get_scale_factor (self);
				_tmp143_ = _tmp142_;
				if ((x + gala_utils_scale_to_int (size, _tmp143_)) >= scaled_size) {
					gfloat _tmp144_;
					gfloat _tmp145_;
					x = x_offset;
					_tmp144_ = gala_icon_group_get_scale_factor (self);
					_tmp145_ = _tmp144_;
					y += gala_utils_scale_to_int (size, _tmp145_) + spacing;
				}
				_g_object_unref0 (window);
			}
		}
	}
	_g_object_unref0 (style_manager);
	_g_object_unref0 (shadow_effect);
}

static ClutterActor*
gala_icon_group_drag_begin (GalaIconGroup* self,
                            gfloat click_x,
                            gfloat click_y)
{
	MetaWorkspaceManager* manager = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ClutterActor* _tmp4_;
	gfloat abs_x = 0.0F;
	gfloat abs_y = 0.0F;
	gfloat prev_parent_x = 0.0F;
	gfloat prev_parent_y = 0.0F;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	gfloat _tmp10_ = 0.0F;
	gfloat _tmp11_ = 0.0F;
	ClutterStage* stage = NULL;
	ClutterStage* _tmp12_;
	ClutterStage* _tmp13_;
	GalaIconGroupContainer* container = NULL;
	ClutterActor* _tmp14_;
	GalaIconGroupContainer* _tmp15_;
	GalaIconGroupContainer* _tmp16_;
	ClutterStage* _tmp20_;
	gfloat _tmp21_ = 0.0F;
	gfloat _tmp22_ = 0.0F;
	MetaDisplay* _tmp23_;
	ClutterActor* _tmp24_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp4_ = self->priv->icon_container;
	if (clutter_actor_get_n_children (_tmp4_) < 1) {
		MetaWorkspace* _tmp5_;
		MetaWorkspaceManager* _tmp6_;
		_tmp5_ = self->priv->_workspace;
		_tmp6_ = manager;
		_tmp3_ = meta_workspace_index (_tmp5_) == (meta_workspace_manager_get_n_workspaces (_tmp6_) - 1);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = NULL;
		return result;
	}
	_tmp7_ = clutter_actor_get_parent ((ClutterActor*) self);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->prev_parent);
	self->priv->prev_parent = _tmp8_;
	_tmp9_ = self->priv->prev_parent;
	clutter_actor_get_transformed_position (_tmp9_, &_tmp10_, &_tmp11_);
	prev_parent_x = _tmp10_;
	prev_parent_y = _tmp11_;
	_tmp12_ = (ClutterStage*) clutter_actor_get_stage ((ClutterActor*) self);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	stage = _tmp13_;
	_tmp14_ = self->priv->prev_parent;
	_tmp15_ = _g_object_ref0 (GALA_IS_ICON_GROUP_CONTAINER (_tmp14_) ? ((GalaIconGroupContainer*) _tmp14_) : NULL);
	container = _tmp15_;
	_tmp16_ = container;
	if (_tmp16_ != NULL) {
		GalaIconGroupContainer* _tmp17_;
		GalaIconGroupContainer* _tmp18_;
		_tmp17_ = container;
		gala_icon_group_container_remove_group_in_place (_tmp17_, self);
		_tmp18_ = container;
		gala_icon_group_container_reset_thumbs (_tmp18_, 0);
	} else {
		ClutterActor* _tmp19_;
		_tmp19_ = self->priv->prev_parent;
		clutter_actor_remove_child (_tmp19_, (ClutterActor*) self);
	}
	_tmp20_ = stage;
	clutter_actor_add_child ((ClutterActor*) _tmp20_, (ClutterActor*) self);
	clutter_actor_get_transformed_position ((ClutterActor*) self, &_tmp21_, &_tmp22_);
	abs_x = _tmp21_;
	abs_y = _tmp22_;
	clutter_actor_set_position ((ClutterActor*) self, abs_x + prev_parent_x, abs_y + prev_parent_y);
	clutter_actor_set_reactive ((ClutterActor*) self, FALSE);
	_tmp23_ = self->priv->_display;
	meta_display_set_cursor (_tmp23_, META_CURSOR_DND_IN_DRAG);
	_tmp24_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp24_;
	_g_object_unref0 (container);
	_g_object_unref0 (stage);
	return result;
}

static void
gala_icon_group_drag_end (GalaIconGroup* self,
                          ClutterActor* destination)
{
	MetaDisplay* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	if (GALA_IS_WORKSPACE_INSERT_THUMB (destination)) {
		ClutterActor* _tmp0_;
		GalaWorkspaceInsertThumb* inserter = NULL;
		MetaWorkspaceManager* manager = NULL;
		MetaWorkspace* _tmp1_;
		MetaDisplay* _tmp2_;
		MetaWorkspaceManager* _tmp3_;
		MetaWorkspaceManager* _tmp4_;
		MetaWorkspace* _tmp5_;
		GalaWorkspaceInsertThumb* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
		clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
		inserter = G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
		_tmp1_ = self->priv->_workspace;
		_tmp2_ = meta_workspace_get_display (_tmp1_);
		_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
		manager = _tmp3_;
		_tmp4_ = manager;
		_tmp5_ = self->priv->_workspace;
		_tmp6_ = inserter;
		_tmp7_ = gala_workspace_insert_thumb_get_workspace_index (_tmp6_);
		_tmp8_ = _tmp7_;
		meta_workspace_manager_reorder_workspace (_tmp4_, _tmp5_, _tmp8_);
		gala_icon_group_restore_group (self);
	} else {
		gala_icon_group_drag_canceled (self);
	}
	_tmp9_ = self->priv->_display;
	meta_display_set_cursor (_tmp9_, META_CURSOR_DEFAULT);
}

static void
gala_icon_group_drag_canceled (GalaIconGroup* self)
{
	ClutterActor* _tmp0_;
	MetaDisplay* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
	gala_icon_group_restore_group (self);
	_tmp1_ = self->priv->_display;
	meta_display_set_cursor (_tmp1_, META_CURSOR_DEFAULT);
}

static void
gala_icon_group_restore_group (GalaIconGroup* self)
{
	GalaIconGroupContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaIconGroupContainer* _tmp1_;
	GalaIconGroupContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prev_parent;
	_tmp1_ = _g_object_ref0 (GALA_IS_ICON_GROUP_CONTAINER (_tmp0_) ? ((GalaIconGroupContainer*) _tmp0_) : NULL);
	container = _tmp1_;
	_tmp2_ = container;
	if (_tmp2_ != NULL) {
		GalaIconGroupContainer* _tmp3_;
		GalaIconGroupContainer* _tmp4_;
		GalaIconGroupContainer* _tmp5_;
		_tmp3_ = container;
		gala_icon_group_container_add_group (_tmp3_, self);
		_tmp4_ = container;
		g_signal_emit_by_name (_tmp4_, "request-reposition", FALSE);
		_tmp5_ = container;
		gala_icon_group_container_reset_thumbs (_tmp5_, GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY);
	}
	_g_object_unref0 (container);
}

gfloat
gala_icon_group_get_backdrop_opacity (GalaIconGroup* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_backdrop_opacity;
	return result;
}

void
gala_icon_group_set_backdrop_opacity (GalaIconGroup* self,
                                      gfloat value)
{
	g_return_if_fail (self != NULL);
	self->priv->_backdrop_opacity = value;
	clutter_actor_queue_redraw ((ClutterActor*) self);
	g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY]);
}

MetaDisplay*
gala_icon_group_get_display (GalaIconGroup* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_icon_group_set_display (GalaIconGroup* self,
                             MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_icon_group_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_DISPLAY_PROPERTY]);
	}
}

MetaWorkspace*
gala_icon_group_get_workspace (GalaIconGroup* self)
{
	MetaWorkspace* result;
	MetaWorkspace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	result = _tmp0_;
	return result;
}

static void
gala_icon_group_set_workspace (GalaIconGroup* self,
                               MetaWorkspace* value)
{
	MetaWorkspace* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_icon_group_get_workspace (self);
	if (old_value != value) {
		MetaWorkspace* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_workspace);
		self->priv->_workspace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_WORKSPACE_PROPERTY]);
	}
}

gfloat
gala_icon_group_get_scale_factor (GalaIconGroup* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale_factor;
	return result;
}

void
gala_icon_group_set_scale_factor (GalaIconGroup* self,
                                  gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_scale_factor) {
		self->priv->_scale_factor = value;
		gala_icon_group_resize (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY]);
}

static void
_gala_icon_group___lambda75_ (GalaIconGroup* self)
{
	g_signal_emit (self, gala_icon_group_signals[GALA_ICON_GROUP_SELECTED_SIGNAL], 0);
}

static void
__gala_icon_group___lambda75__gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                   guint32 button,
                                                                   ClutterInputDeviceType device_type,
                                                                   gpointer self)
{
	_gala_icon_group___lambda75_ ((GalaIconGroup*) self);
}

static ClutterActor*
_gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                              gfloat x,
                                                              gfloat y,
                                                              gpointer self)
{
	ClutterActor* result;
	result = gala_icon_group_drag_begin ((GalaIconGroup*) self, x, y);
	return result;
}

static void
_gala_icon_group_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                          ClutterActor* actor,
                                                          gpointer self)
{
	gala_icon_group_drag_end ((GalaIconGroup*) self, actor);
}

static void
_gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                    gpointer self)
{
	gala_icon_group_drag_canceled ((GalaIconGroup*) self);
}

static void
_gala_icon_group_redraw_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self)
{
	gala_icon_group_redraw ((GalaIconGroup*) self);
}

static GObject *
gala_icon_group_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaIconGroup * self;
	GalaDragDropAction* _tmp0_;
	GalaDragDropAction* _tmp1_;
	GalaDragDropAction* _tmp2_;
	GalaDragDropAction* _tmp3_;
	GalaDragDropAction* _tmp4_;
	GalaDragDropAction* _tmp5_;
	GalaDragDropAction* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterActor* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	parent_class = G_OBJECT_CLASS (gala_icon_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE | GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->drag_action);
	self->priv->drag_action = _tmp0_;
	_tmp1_ = self->priv->drag_action;
	g_signal_connect_object (_tmp1_, "actor-clicked", (GCallback) __gala_icon_group___lambda75__gala_drag_drop_action_actor_clicked, self, 0);
	_tmp2_ = self->priv->drag_action;
	g_signal_connect_object (_tmp2_, "drag-begin", (GCallback) _gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin, self, 0);
	_tmp3_ = self->priv->drag_action;
	g_signal_connect_object (_tmp3_, "drag-end", (GCallback) _gala_icon_group_drag_end_gala_drag_drop_action_drag_end, self, 0);
	_tmp4_ = self->priv->drag_action;
	g_signal_connect_object (_tmp4_, "drag-canceled", (GCallback) _gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled, self, 0);
	_tmp5_ = self->priv->drag_action;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::dragging", (GCallback) _gala_icon_group_redraw_g_object_notify, self, 0);
	_tmp6_ = self->priv->drag_action;
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp6_);
	_tmp7_ = clutter_actor_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->icon_container);
	self->priv->icon_container = _tmp7_;
	_tmp8_ = self->priv->icon_container;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	clutter_actor_set_width (_tmp8_, _tmp10_);
	_tmp11_ = self->priv->icon_container;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	clutter_actor_set_height (_tmp11_, _tmp13_);
	_tmp14_ = self->priv->icon_container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp14_);
	gala_icon_group_resize (self);
	_tmp15_ = self->priv->icon_container;
	g_signal_connect_object (_tmp15_, "child-removed", (GCallback) _gala_icon_group_redraw_clutter_actor_child_removed, self, G_CONNECT_AFTER);
	return obj;
}

static void
gala_icon_group_class_init (GalaIconGroupClass * klass,
                            gpointer klass_data)
{
	gala_icon_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaIconGroup_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_icon_group_real_paint;
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_icon_group_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_icon_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_icon_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_icon_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_icon_group_finalize;
	/**
	     * The opacity of the backdrop/highlight.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY] = g_param_spec_float ("backdrop-opacity", "backdrop-opacity", "backdrop-opacity", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_DISPLAY_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_WORKSPACE_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_WORKSPACE_PROPERTY] = g_param_spec_object ("workspace", "workspace", "workspace", meta_workspace_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("scale-factor", "scale-factor", "scale-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The group has been clicked. The MultitaskingView should consider activating
	     * its workspace.
	     */
	gala_icon_group_signals[GALA_ICON_GROUP_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_ICON_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_icon_group_instance_init (GalaIconGroup * self,
                               gpointer klass)
{
	self->priv = gala_icon_group_get_instance_private (self);
	self->priv->_backdrop_opacity = 0.0f;
	self->priv->_scale_factor = 1.0f;
	self->priv->prev_parent = NULL;
}

static void
gala_icon_group_finalize (GObject * obj)
{
	GalaIconGroup * self;
	ClutterActor* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	_tmp0_ = self->priv->icon_container;
	g_signal_parse_name ("child-removed", clutter_actor_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_icon_group_redraw_clutter_actor_child_removed, self);
	_g_object_unref0 (self->priv->drag_action);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_workspace);
	_g_object_unref0 (self->priv->prev_parent);
	_g_object_unref0 (self->priv->icon_container);
	G_OBJECT_CLASS (gala_icon_group_parent_class)->finalize (obj);
}

/**
 * Container for WindowIconActors which takes care of the scaling and positioning.
 * It also decides whether to draw the container shape, a plus sign or an ellipsis.
 * Lastly it also includes the drawing code for the active highlight.
 */
 G_GNUC_NO_INLINE static GType
gala_icon_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaIconGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_icon_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaIconGroup), 0, (GInstanceInitFunc) gala_icon_group_instance_init, NULL };
	GType gala_icon_group_type_id;
	gala_icon_group_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaIconGroup", &g_define_type_info, 0);
	GalaIconGroup_private_offset = g_type_add_instance_private (gala_icon_group_type_id, sizeof (GalaIconGroupPrivate));
	return gala_icon_group_type_id;
}

GType
gala_icon_group_get_type (void)
{
	static gsize gala_icon_group_type_id__once = 0;
	if (g_once_init_enter (&gala_icon_group_type_id__once)) {
		GType gala_icon_group_type_id;
		gala_icon_group_type_id = gala_icon_group_get_type_once ();
		g_once_init_leave (&gala_icon_group_type_id__once, gala_icon_group_type_id);
	}
	return gala_icon_group_type_id__once;
}

static void
_vala_gala_icon_group_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GalaIconGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	switch (property_id) {
		case GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY:
		g_value_set_float (value, gala_icon_group_get_backdrop_opacity (self));
		break;
		case GALA_ICON_GROUP_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_icon_group_get_display (self));
		break;
		case GALA_ICON_GROUP_WORKSPACE_PROPERTY:
		g_value_set_object (value, gala_icon_group_get_workspace (self));
		break;
		case GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_icon_group_get_scale_factor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_icon_group_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GalaIconGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	switch (property_id) {
		case GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY:
		gala_icon_group_set_backdrop_opacity (self, g_value_get_float (value));
		break;
		case GALA_ICON_GROUP_DISPLAY_PROPERTY:
		gala_icon_group_set_display (self, g_value_get_object (value));
		break;
		case GALA_ICON_GROUP_WORKSPACE_PROPERTY:
		gala_icon_group_set_workspace (self, g_value_get_object (value));
		break;
		case GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY:
		gala_icon_group_set_scale_factor (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

