/* UserActions.c generated by valac 0.56.18, the Vala compiler
 * generated from UserActions.vala, do not modify */

/* UserActions.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "font-manager.h"
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#define FONT_MANAGER_USER_ACTION_LIST_help_text _ ("Actions defined here will be added to the font list context menu.\n" \
"\n" \
"By default the filepath for the selected font will be appended to the " \
"end of the argument list.\n" \
"To control where the filepath is inserted use FILEPATH as a placeholde" \
"r.\n" \
"If FAMILY or STYLE are found in the argument list they will also be re" \
"placed.")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_CACHEABLE (font_manager_cacheable_get_type ())
#define FONT_MANAGER_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheable))
#define FONT_MANAGER_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))
#define FONT_MANAGER_IS_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_IS_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_CACHEABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))

typedef struct _FontManagerCacheable FontManagerCacheable;
typedef struct _FontManagerCacheableClass FontManagerCacheableClass;
typedef struct _FontManagerCacheablePrivate FontManagerCacheablePrivate;

#define FONT_MANAGER_TYPE_USER_ACTION (font_manager_user_action_get_type ())
#define FONT_MANAGER_USER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserAction))
#define FONT_MANAGER_USER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserActionClass))
#define FONT_MANAGER_IS_USER_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_USER_ACTION))
#define FONT_MANAGER_IS_USER_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_USER_ACTION))
#define FONT_MANAGER_USER_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserActionClass))

typedef struct _FontManagerUserAction FontManagerUserAction;
typedef struct _FontManagerUserActionClass FontManagerUserActionClass;
typedef struct _FontManagerUserActionPrivate FontManagerUserActionPrivate;
enum  {
	FONT_MANAGER_USER_ACTION_0_PROPERTY,
	FONT_MANAGER_USER_ACTION_ACTION_ICON_PROPERTY,
	FONT_MANAGER_USER_ACTION_ACTION_NAME_PROPERTY,
	FONT_MANAGER_USER_ACTION_COMMENT_PROPERTY,
	FONT_MANAGER_USER_ACTION_EXECUTABLE_PROPERTY,
	FONT_MANAGER_USER_ACTION_ARGUMENTS_PROPERTY,
	FONT_MANAGER_USER_ACTION_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FONT_MANAGER_TYPE_USER_ACTION_MODEL (font_manager_user_action_model_get_type ())
#define FONT_MANAGER_USER_ACTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_USER_ACTION_MODEL, FontManagerUserActionModel))
#define FONT_MANAGER_USER_ACTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_USER_ACTION_MODEL, FontManagerUserActionModelClass))
#define FONT_MANAGER_IS_USER_ACTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_USER_ACTION_MODEL))
#define FONT_MANAGER_IS_USER_ACTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_USER_ACTION_MODEL))
#define FONT_MANAGER_USER_ACTION_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_USER_ACTION_MODEL, FontManagerUserActionModelClass))

typedef struct _FontManagerUserActionModel FontManagerUserActionModel;
typedef struct _FontManagerUserActionModelClass FontManagerUserActionModelClass;
typedef struct _FontManagerUserActionModelPrivate FontManagerUserActionModelPrivate;
enum  {
	FONT_MANAGER_USER_ACTION_MODEL_0_PROPERTY,
	FONT_MANAGER_USER_ACTION_MODEL_ITEMS_PROPERTY,
	FONT_MANAGER_USER_ACTION_MODEL_SIZE_PROPERTY,
	FONT_MANAGER_USER_ACTION_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_action_model_properties[FONT_MANAGER_USER_ACTION_MODEL_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block28Data Block28Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _Block29Data Block29Data;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define FONT_MANAGER_TYPE_USER_ACTION_ROW (font_manager_user_action_row_get_type ())
#define FONT_MANAGER_USER_ACTION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_USER_ACTION_ROW, FontManagerUserActionRow))
#define FONT_MANAGER_USER_ACTION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_USER_ACTION_ROW, FontManagerUserActionRowClass))
#define FONT_MANAGER_IS_USER_ACTION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_USER_ACTION_ROW))
#define FONT_MANAGER_IS_USER_ACTION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_USER_ACTION_ROW))
#define FONT_MANAGER_USER_ACTION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_USER_ACTION_ROW, FontManagerUserActionRowClass))

typedef struct _FontManagerUserActionRow FontManagerUserActionRow;
typedef struct _FontManagerUserActionRowClass FontManagerUserActionRowClass;
typedef struct _FontManagerUserActionRowPrivate FontManagerUserActionRowPrivate;
enum  {
	FONT_MANAGER_USER_ACTION_ROW_0_PROPERTY,
	FONT_MANAGER_USER_ACTION_ROW_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_action_row_properties[FONT_MANAGER_USER_ACTION_ROW_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_PREFERENCE_LIST (font_manager_preference_list_get_type ())
#define FONT_MANAGER_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList))
#define FONT_MANAGER_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))
#define FONT_MANAGER_IS_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_IS_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_PREFERENCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))

typedef struct _FontManagerPreferenceList FontManagerPreferenceList;
typedef struct _FontManagerPreferenceListClass FontManagerPreferenceListClass;
typedef struct _FontManagerPreferenceListPrivate FontManagerPreferenceListPrivate;

#define FONT_MANAGER_TYPE_BASE_CONTROLS (font_manager_base_controls_get_type ())
#define FONT_MANAGER_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls))
#define FONT_MANAGER_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))
#define FONT_MANAGER_IS_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_IS_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_BASE_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))

typedef struct _FontManagerBaseControls FontManagerBaseControls;
typedef struct _FontManagerBaseControlsClass FontManagerBaseControlsClass;

#define FONT_MANAGER_TYPE_USER_ACTION_LIST (font_manager_user_action_list_get_type ())
#define FONT_MANAGER_USER_ACTION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_USER_ACTION_LIST, FontManagerUserActionList))
#define FONT_MANAGER_USER_ACTION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_USER_ACTION_LIST, FontManagerUserActionListClass))
#define FONT_MANAGER_IS_USER_ACTION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_USER_ACTION_LIST))
#define FONT_MANAGER_IS_USER_ACTION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_USER_ACTION_LIST))
#define FONT_MANAGER_USER_ACTION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_USER_ACTION_LIST, FontManagerUserActionListClass))

typedef struct _FontManagerUserActionList FontManagerUserActionList;
typedef struct _FontManagerUserActionListClass FontManagerUserActionListClass;
typedef struct _FontManagerUserActionListPrivate FontManagerUserActionListPrivate;
enum  {
	FONT_MANAGER_USER_ACTION_LIST_0_PROPERTY,
	FONT_MANAGER_USER_ACTION_LIST_MODEL_PROPERTY,
	FONT_MANAGER_USER_ACTION_LIST_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_action_list_properties[FONT_MANAGER_USER_ACTION_LIST_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerCacheable {
	GObject parent_instance;
	FontManagerCacheablePrivate * priv;
};

struct _FontManagerCacheableClass {
	GObjectClass parent_class;
	gboolean (*deserialize_property) (FontManagerCacheable* self, const gchar* prop_name, GValue* val, GParamSpec* pspec, JsonNode* node);
	JsonNode* (*serialize_property) (FontManagerCacheable* self, const gchar* prop_name, GValue* val, GParamSpec* pspec);
};

struct _FontManagerUserAction {
	FontManagerCacheable parent_instance;
	FontManagerUserActionPrivate * priv;
};

struct _FontManagerUserActionClass {
	FontManagerCacheableClass parent_class;
};

struct _FontManagerUserActionPrivate {
	gchar* _action_icon;
	gchar* _action_name;
	gchar* _comment;
	gchar* _executable;
	gchar* _arguments;
};

struct _FontManagerUserActionModel {
	GObject parent_instance;
	FontManagerUserActionModelPrivate * priv;
};

struct _FontManagerUserActionModelClass {
	GObjectClass parent_class;
};

struct _FontManagerUserActionModelPrivate {
	GPtrArray* _items;
};

struct _Block28Data {
	int _ref_count_;
	FontManagerUserActionModel* self;
	guint position;
};

struct _Block29Data {
	int _ref_count_;
	FontManagerUserActionModel* self;
	JsonArray* array;
};

struct _FontManagerUserActionRow {
	GtkGrid parent_instance;
	FontManagerUserActionRowPrivate * priv;
};

struct _FontManagerUserActionRowClass {
	GtkGridClass parent_class;
};

struct _FontManagerUserActionRowPrivate {
	GtkImage* action_icon;
	GtkEntry* action_name;
	GtkEntry* comment;
	GtkEntry* executable;
	GtkEntry* arguments;
};

struct _FontManagerPreferenceList {
	GtkBox parent_instance;
	FontManagerPreferenceListPrivate * priv;
	GtkListBox* list;
	FontManagerBaseControls* controls;
	GtkSeparator* separator;
};

struct _FontManagerPreferenceListClass {
	GtkBoxClass parent_class;
	void (*on_add_selected) (FontManagerPreferenceList* self);
	void (*on_list_row_selected) (FontManagerPreferenceList* self, GtkListBox* box, GtkListBoxRow* row);
	void (*on_map) (FontManagerPreferenceList* self);
	void (*on_remove_selected) (FontManagerPreferenceList* self);
	void (*on_unmap) (FontManagerPreferenceList* self);
};

struct _FontManagerUserActionList {
	FontManagerPreferenceList parent_instance;
	FontManagerUserActionListPrivate * priv;
};

struct _FontManagerUserActionListClass {
	FontManagerPreferenceListClass parent_class;
};

struct _FontManagerUserActionListPrivate {
	FontManagerUserActionModel* _model;
};

static gint FontManagerUserAction_private_offset;
static gpointer font_manager_user_action_parent_class = NULL;
static gint FontManagerUserActionModel_private_offset;
static gpointer font_manager_user_action_model_parent_class = NULL;
static GListModelInterface * font_manager_user_action_model_g_list_model_parent_iface = NULL;
static gint FontManagerUserActionRow_private_offset;
static gpointer font_manager_user_action_row_parent_class = NULL;
static gint FontManagerUserActionList_private_offset;
static gpointer font_manager_user_action_list_parent_class = NULL;

VALA_EXTERN GType font_manager_cacheable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCacheable, g_object_unref)
VALA_EXTERN GType font_manager_user_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserAction, g_object_unref)
VALA_EXTERN void font_manager_user_action_run (FontManagerUserAction* self,
                                   FontManagerFont* font);
VALA_EXTERN const gchar* font_manager_user_action_get_executable (FontManagerUserAction* self);
VALA_EXTERN const gchar* font_manager_user_action_get_arguments (FontManagerUserAction* self);
VALA_EXTERN FontManagerUserAction* font_manager_user_action_new (void);
VALA_EXTERN FontManagerUserAction* font_manager_user_action_construct (GType object_type);
VALA_EXTERN FontManagerCacheable* font_manager_cacheable_new (void);
VALA_EXTERN FontManagerCacheable* font_manager_cacheable_construct (GType object_type);
VALA_EXTERN const gchar* font_manager_user_action_get_action_icon (FontManagerUserAction* self);
VALA_EXTERN void font_manager_user_action_set_action_icon (FontManagerUserAction* self,
                                               const gchar* value);
VALA_EXTERN const gchar* font_manager_user_action_get_action_name (FontManagerUserAction* self);
VALA_EXTERN void font_manager_user_action_set_action_name (FontManagerUserAction* self,
                                               const gchar* value);
VALA_EXTERN const gchar* font_manager_user_action_get_comment (FontManagerUserAction* self);
VALA_EXTERN void font_manager_user_action_set_comment (FontManagerUserAction* self,
                                           const gchar* value);
VALA_EXTERN void font_manager_user_action_set_executable (FontManagerUserAction* self,
                                              const gchar* value);
VALA_EXTERN void font_manager_user_action_set_arguments (FontManagerUserAction* self,
                                             const gchar* value);
static GObject * font_manager_user_action_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _font_manager_user_action___lambda9_ (FontManagerUserAction* self);
static void __font_manager_user_action___lambda9__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _font_manager_user_action___lambda10_ (FontManagerUserAction* self);
static void __font_manager_user_action___lambda10__g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void font_manager_user_action_finalize (GObject * obj);
static GType font_manager_user_action_get_type_once (void);
static void _vala_font_manager_user_action_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_font_manager_user_action_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
VALA_EXTERN GType font_manager_user_action_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserActionModel, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static GType font_manager_user_action_model_real_get_item_type (GListModel* base);
static guint font_manager_user_action_model_real_get_n_items (GListModel* base);
VALA_EXTERN GPtrArray* font_manager_user_action_model_get_items (FontManagerUserActionModel* self);
static GObject* font_manager_user_action_model_real_get_item (GListModel* base,
                                                       guint position);
VALA_EXTERN FontManagerUserAction* font_manager_user_action_model_get (FontManagerUserActionModel* self,
                                                           guint index);
VALA_EXTERN guint font_manager_user_action_model_get_size (FontManagerUserActionModel* self);
VALA_EXTERN void font_manager_user_action_model_add_item (FontManagerUserActionModel* self,
                                              FontManagerUserAction* item);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void __lambda11_ (Block28Data* _data28_);
static void ___lambda11__font_manager_cacheable_changed (FontManagerCacheable* _sender,
                                                  gpointer self);
VALA_EXTERN void font_manager_user_action_model_remove_item (FontManagerUserActionModel* self,
                                                 guint position);
VALA_EXTERN gchar* font_manager_user_action_model_get_cache_file (void);
VALA_EXTERN void font_manager_user_action_model_load (FontManagerUserActionModel* self);
static void ___lambda12_ (FontManagerUserActionModel* self,
                   JsonArray* arr,
                   guint index,
                   JsonNode* node);
static void ____lambda12__json_array_foreach (JsonArray* array,
                                       guint index_,
                                       JsonNode* element_node,
                                       gpointer self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN void font_manager_user_action_model_clear (FontManagerUserActionModel* self);
static void font_manager_user_action_model_set_items (FontManagerUserActionModel* self,
                                               GPtrArray* value);
VALA_EXTERN void font_manager_user_action_model_reload (FontManagerUserActionModel* self);
VALA_EXTERN void font_manager_user_action_model_save (FontManagerUserActionModel* self);
static void _font_manager_user_action_model_save_g_list_model_items_changed (GListModel* _sender,
                                                                      guint position,
                                                                      guint removed,
                                                                      guint added,
                                                                      gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda13_ (Block29Data* _data29_,
                  FontManagerUserAction* item);
static void ___lambda13__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN FontManagerUserActionModel* font_manager_user_action_model_new (void);
VALA_EXTERN FontManagerUserActionModel* font_manager_user_action_model_construct (GType object_type);
static void font_manager_user_action_model_finalize (GObject * obj);
static GType font_manager_user_action_model_get_type_once (void);
static void _vala_font_manager_user_action_model_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_font_manager_user_action_model_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
VALA_EXTERN GType font_manager_user_action_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserActionRow, g_object_unref)
VALA_EXTERN FontManagerUserActionRow* font_manager_user_action_row_from_item (GObject* item);
VALA_EXTERN FontManagerUserActionRow* font_manager_user_action_row_new (void);
VALA_EXTERN FontManagerUserActionRow* font_manager_user_action_row_construct (GType object_type);
static void font_manager_user_action_row_on_file_selections_ready (FontManagerUserActionRow* self,
                                                            GObject* obj,
                                                            GAsyncResult* res);
static void font_manager_user_action_row_on_executable_icon_press (FontManagerUserActionRow* self,
                                                            GtkEntry* entry,
                                                            GtkEntryIconPosition position);
VALA_EXTERN GtkFileDialog* font_manager_file_selector_get_executable (void);
VALA_EXTERN GtkWindow* font_manager_get_parent_window (GtkWidget* widget);
static void _font_manager_user_action_row_on_file_selections_ready_gasync_ready_callback (GObject* source_object,
                                                                                   GAsyncResult* res,
                                                                                   gpointer self);
static void _font_manager_user_action_row_on_executable_icon_press_gtk_entry_icon_press (GtkEntry* _sender,
                                                                                  GtkEntryIconPosition icon_pos,
                                                                                  gpointer self);
static void font_manager_user_action_row_finalize (GObject * obj);
static GType font_manager_user_action_row_get_type_once (void);
VALA_EXTERN GType font_manager_preference_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreferenceList, g_object_unref)
VALA_EXTERN GType font_manager_base_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseControls, g_object_unref)
VALA_EXTERN GType font_manager_user_action_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserActionList, g_object_unref)
VALA_EXTERN void font_manager_preference_list_on_map (FontManagerPreferenceList* self);
VALA_EXTERN void font_manager_preference_list_on_add_selected (FontManagerPreferenceList* self);
VALA_EXTERN void font_manager_preference_list_on_remove_selected (FontManagerPreferenceList* self);
VALA_EXTERN FontManagerUserActionList* font_manager_user_action_list_new (void);
VALA_EXTERN FontManagerUserActionList* font_manager_user_action_list_construct (GType object_type);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_new (void);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_construct (GType object_type);
static void __lambda153_ (FontManagerUserActionList* self);
VALA_EXTERN FontManagerUserActionModel* font_manager_user_action_list_get_model (FontManagerUserActionList* self);
static GtkWidget* _font_manager_user_action_row_from_item_gtk_list_box_create_widget_func (GObject* item,
                                                                                    gpointer self);
static void ___lambda153__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN void font_manager_user_action_list_set_model (FontManagerUserActionList* self,
                                              FontManagerUserActionModel* value);
VALA_EXTERN GtkImage* font_manager_inline_help_widget (const gchar* message);
static void font_manager_user_action_list_real_on_map (FontManagerPreferenceList* base);
static void font_manager_user_action_list_real_on_add_selected (FontManagerPreferenceList* base);
static void font_manager_user_action_list_real_on_remove_selected (FontManagerPreferenceList* base);
static void font_manager_user_action_list_finalize (GObject * obj);
static GType font_manager_user_action_list_get_type_once (void);
static void _vala_font_manager_user_action_list_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_font_manager_user_action_list_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
font_manager_user_action_get_instance_private (FontManagerUserAction* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserAction_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
font_manager_user_action_run (FontManagerUserAction* self,
                              FontManagerFont* font)
{
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_;
	GString* _tmp8_;
	gchar* args = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->_executable;
	if (font_manager_exists (_tmp1_)) {
		GString* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = builder;
		_tmp3_ = self->priv->_executable;
		g_string_append (_tmp2_, _tmp3_);
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = builder;
		_tmp5_ = self->priv->_executable;
		_tmp6_ = g_find_program_in_path (_tmp5_);
		_tmp7_ = _tmp6_;
		g_string_append (_tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
	}
	_tmp8_ = builder;
	g_string_append (_tmp8_, " ");
	_tmp9_ = self->priv->_arguments;
	_tmp10_ = g_strdup (_tmp9_);
	args = _tmp10_;
	if (font != NULL) {
		gchar* filepath = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		GString* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		g_object_get (font, "filepath", &_tmp11_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = g_shell_quote (_tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		filepath = _tmp15_;
		_tmp16_ = args;
		_tmp17_ = filepath;
		_tmp18_ = string_replace (_tmp16_, "FILEPATH", _tmp17_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp19_);
		_tmp20_ = args;
		g_object_get (font, "family", &_tmp21_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = string_replace (_tmp20_, "FAMILY", _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_tmp26_ = args;
		g_object_get (font, "style", &_tmp27_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		_tmp30_ = string_replace (_tmp26_, "STYLE", _tmp29_);
		_tmp31_ = _tmp30_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_tmp32_ = builder;
		_tmp33_ = args;
		g_string_append (_tmp32_, _tmp33_);
		_tmp34_ = args;
		_tmp35_ = filepath;
		if (!string_contains (_tmp34_, _tmp35_)) {
			GString* _tmp36_;
			GString* _tmp37_;
			const gchar* _tmp38_;
			_tmp36_ = builder;
			g_string_append (_tmp36_, " ");
			_tmp37_ = builder;
			_tmp38_ = filepath;
			g_string_append (_tmp37_, _tmp38_);
		}
		_g_free0 (filepath);
	} else {
		GString* _tmp39_;
		const gchar* _tmp40_;
		_tmp39_ = builder;
		_tmp40_ = args;
		g_string_append (_tmp39_, _tmp40_);
	}
	{
		GString* _tmp41_;
		const gchar* _tmp42_;
		_tmp41_ = builder;
		_tmp42_ = _tmp41_->str;
		g_spawn_command_line_async (_tmp42_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp43_;
		const gchar* _tmp44_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = e;
		_tmp44_ = _tmp43_->message;
		g_critical ("UserActions.vala:81: %s", _tmp44_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (args);
		_g_string_free0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (args);
	_g_string_free0 (builder);
	return;
}

FontManagerUserAction*
font_manager_user_action_construct (GType object_type)
{
	FontManagerUserAction * self = NULL;
	self = (FontManagerUserAction*) font_manager_cacheable_construct (object_type);
	return self;
}

FontManagerUserAction*
font_manager_user_action_new (void)
{
	return font_manager_user_action_construct (FONT_MANAGER_TYPE_USER_ACTION);
}

const gchar*
font_manager_user_action_get_action_icon (FontManagerUserAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action_icon;
	result = _tmp0_;
	return result;
}

void
font_manager_user_action_set_action_icon (FontManagerUserAction* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_action_get_action_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_action_icon);
		self->priv->_action_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_ACTION_ICON_PROPERTY]);
	}
}

const gchar*
font_manager_user_action_get_action_name (FontManagerUserAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_action_name;
	result = _tmp0_;
	return result;
}

void
font_manager_user_action_set_action_name (FontManagerUserAction* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_action_get_action_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_action_name);
		self->priv->_action_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_ACTION_NAME_PROPERTY]);
	}
}

const gchar*
font_manager_user_action_get_comment (FontManagerUserAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	result = _tmp0_;
	return result;
}

void
font_manager_user_action_set_comment (FontManagerUserAction* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_action_get_comment (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_comment);
		self->priv->_comment = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_COMMENT_PROPERTY]);
	}
}

const gchar*
font_manager_user_action_get_executable (FontManagerUserAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_executable;
	result = _tmp0_;
	return result;
}

void
font_manager_user_action_set_executable (FontManagerUserAction* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_action_get_executable (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_executable);
		self->priv->_executable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_EXECUTABLE_PROPERTY]);
	}
}

const gchar*
font_manager_user_action_get_arguments (FontManagerUserAction* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_arguments;
	result = _tmp0_;
	return result;
}

void
font_manager_user_action_set_arguments (FontManagerUserAction* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_action_get_arguments (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_arguments);
		self->priv->_arguments = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_ARGUMENTS_PROPERTY]);
	}
}

static void
_font_manager_user_action___lambda9_ (FontManagerUserAction* self)
{
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* exec = NULL;
	gchar* _tmp6_;
	const gchar*** desktop_files = NULL;
	const gchar* _tmp7_;
	const gchar*** _tmp8_;
	const gchar*** _tmp9_;
	gint desktop_files_length1;
	gint _desktop_files_size_;
	gboolean _tmp10_ = FALSE;
	const gchar*** _tmp11_;
	gint _tmp11__length1;
	_tmp1_ = self->priv->_executable;
	if (string_contains (_tmp1_, "/")) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_executable;
		_tmp3_ = g_path_get_basename (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_executable;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp0_);
	exec = _tmp6_;
	_tmp7_ = exec;
	_tmp9_ = _tmp8_ = g_desktop_app_info_search (_tmp7_);
	desktop_files = _tmp9_;
	desktop_files_length1 = _vala_array_length (_tmp8_);
	_desktop_files_size_ = desktop_files_length1;
	_tmp11_ = desktop_files;
	_tmp11__length1 = desktop_files_length1;
	if (_tmp11_ != NULL) {
		const gchar*** _tmp12_;
		gint _tmp12__length1;
		const gchar** _tmp13_;
		_tmp12_ = desktop_files;
		_tmp12__length1 = desktop_files_length1;
		_tmp13_ = _tmp12_[0];
		_tmp10_ = _tmp13_ != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GDesktopAppInfo* app_info = NULL;
		const gchar*** _tmp14_;
		gint _tmp14__length1;
		const gchar** _tmp15_;
		const gchar* _tmp16_;
		GDesktopAppInfo* _tmp17_;
		GDesktopAppInfo* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar*** _tmp31_;
		gint _tmp31__length1;
		_tmp14_ = desktop_files;
		_tmp14__length1 = desktop_files_length1;
		_tmp15_ = _tmp14_[0];
		_tmp16_ = _tmp15_[0];
		_tmp17_ = g_desktop_app_info_new (_tmp16_);
		app_info = _tmp17_;
		_tmp18_ = app_info;
		_tmp19_ = g_app_info_get_executable ((GAppInfo*) _tmp18_);
		_tmp20_ = exec;
		if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
			GDesktopAppInfo* _tmp21_;
			GIcon* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp28_;
			_tmp21_ = app_info;
			_tmp22_ = g_app_info_get_icon ((GAppInfo*) _tmp21_);
			_tmp23_ = g_icon_to_string (_tmp22_);
			_tmp24_ = _tmp23_;
			font_manager_user_action_set_action_icon (self, _tmp24_);
			_g_free0 (_tmp24_);
			_tmp25_ = self->priv->_action_name;
			if (g_strcmp0 (_tmp25_, "") == 0) {
				GDesktopAppInfo* _tmp26_;
				const gchar* _tmp27_;
				_tmp26_ = app_info;
				_tmp27_ = g_app_info_get_display_name ((GAppInfo*) _tmp26_);
				font_manager_user_action_set_action_name (self, _tmp27_);
			}
			_tmp28_ = self->priv->_comment;
			if (g_strcmp0 (_tmp28_, "") == 0) {
				GDesktopAppInfo* _tmp29_;
				const gchar* _tmp30_;
				_tmp29_ = app_info;
				_tmp30_ = g_app_info_get_description ((GAppInfo*) _tmp29_);
				font_manager_user_action_set_comment (self, _tmp30_);
			}
		} else {
			font_manager_user_action_set_action_icon (self, "system-run-symbolic");
		}
		_g_object_unref0 (app_info);
		app_info = NULL;
		_tmp31_ = desktop_files;
		_tmp31__length1 = desktop_files_length1;
		{
			const gchar*** arr_collection = NULL;
			gint arr_collection_length1 = 0;
			gint _arr_collection_size_ = 0;
			gint arr_it = 0;
			arr_collection = _tmp31_;
			arr_collection_length1 = _tmp31__length1;
			for (arr_it = 0; arr_it < arr_collection_length1; arr_it = arr_it + 1) {
				const gchar** arr = NULL;
				arr = arr_collection[arr_it];
				{
					const gchar** _tmp32_;
					_tmp32_ = arr;
					g_strfreev (_tmp32_);
				}
			}
		}
		_g_object_unref0 (app_info);
	}
	desktop_files = (g_free (desktop_files), NULL);
	desktop_files = NULL;
	desktop_files_length1 = 0;
	_desktop_files_size_ = desktop_files_length1;
	desktop_files = (g_free (desktop_files), NULL);
	_g_free0 (exec);
	_g_free0 (_tmp0_);
}

static void
__font_manager_user_action___lambda9__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_font_manager_user_action___lambda9_ ((FontManagerUserAction*) self);
}

static void
_font_manager_user_action___lambda10_ (FontManagerUserAction* self)
{
	g_signal_emit_by_name ((FontManagerCacheable*) self, "changed");
}

static void
__font_manager_user_action___lambda10__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	_font_manager_user_action___lambda10_ ((FontManagerUserAction*) self);
}

static GObject *
font_manager_user_action_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerUserAction * self;
	parent_class = G_OBJECT_CLASS (font_manager_user_action_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserAction);
	g_signal_connect_object ((GObject*) self, "notify::executable", (GCallback) __font_manager_user_action___lambda9__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify", (GCallback) __font_manager_user_action___lambda10__g_object_notify, self, 0);
	return obj;
}

static void
font_manager_user_action_class_init (FontManagerUserActionClass * klass,
                                     gpointer klass_data)
{
	font_manager_user_action_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserAction_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_user_action_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_user_action_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_user_action_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_action_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_ACTION_ACTION_ICON_PROPERTY, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_ACTION_ICON_PROPERTY] = g_param_spec_string ("action-icon", "action-icon", "action-icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_ACTION_ACTION_NAME_PROPERTY, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_ACTION_NAME_PROPERTY] = g_param_spec_string ("action-name", "action-name", "action-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_ACTION_COMMENT_PROPERTY, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_COMMENT_PROPERTY] = g_param_spec_string ("comment", "comment", "comment", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_ACTION_EXECUTABLE_PROPERTY, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_EXECUTABLE_PROPERTY] = g_param_spec_string ("executable", "executable", "executable", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_ACTION_ARGUMENTS_PROPERTY, font_manager_user_action_properties[FONT_MANAGER_USER_ACTION_ARGUMENTS_PROPERTY] = g_param_spec_string ("arguments", "arguments", "arguments", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_user_action_instance_init (FontManagerUserAction * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self->priv = font_manager_user_action_get_instance_private (self);
	_tmp0_ = g_strdup ("system-run-symbolic");
	self->priv->_action_icon = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_action_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_comment = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_executable = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_arguments = _tmp4_;
}

static void
font_manager_user_action_finalize (GObject * obj)
{
	FontManagerUserAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserAction);
	_g_free0 (self->priv->_action_icon);
	_g_free0 (self->priv->_action_name);
	_g_free0 (self->priv->_comment);
	_g_free0 (self->priv->_executable);
	_g_free0 (self->priv->_arguments);
	G_OBJECT_CLASS (font_manager_user_action_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_action_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserAction), 0, (GInstanceInitFunc) font_manager_user_action_instance_init, NULL };
	GType font_manager_user_action_type_id;
	font_manager_user_action_type_id = g_type_register_static (FONT_MANAGER_TYPE_CACHEABLE, "FontManagerUserAction", &g_define_type_info, 0);
	FontManagerUserAction_private_offset = g_type_add_instance_private (font_manager_user_action_type_id, sizeof (FontManagerUserActionPrivate));
	return font_manager_user_action_type_id;
}

GType
font_manager_user_action_get_type (void)
{
	static volatile gsize font_manager_user_action_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_action_type_id__once)) {
		GType font_manager_user_action_type_id;
		font_manager_user_action_type_id = font_manager_user_action_get_type_once ();
		g_once_init_leave (&font_manager_user_action_type_id__once, font_manager_user_action_type_id);
	}
	return font_manager_user_action_type_id__once;
}

static void
_vala_font_manager_user_action_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	FontManagerUserAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserAction);
	switch (property_id) {
		case FONT_MANAGER_USER_ACTION_ACTION_ICON_PROPERTY:
		g_value_set_string (value, font_manager_user_action_get_action_icon (self));
		break;
		case FONT_MANAGER_USER_ACTION_ACTION_NAME_PROPERTY:
		g_value_set_string (value, font_manager_user_action_get_action_name (self));
		break;
		case FONT_MANAGER_USER_ACTION_COMMENT_PROPERTY:
		g_value_set_string (value, font_manager_user_action_get_comment (self));
		break;
		case FONT_MANAGER_USER_ACTION_EXECUTABLE_PROPERTY:
		g_value_set_string (value, font_manager_user_action_get_executable (self));
		break;
		case FONT_MANAGER_USER_ACTION_ARGUMENTS_PROPERTY:
		g_value_set_string (value, font_manager_user_action_get_arguments (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_user_action_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	FontManagerUserAction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserAction);
	switch (property_id) {
		case FONT_MANAGER_USER_ACTION_ACTION_ICON_PROPERTY:
		font_manager_user_action_set_action_icon (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_USER_ACTION_ACTION_NAME_PROPERTY:
		font_manager_user_action_set_action_name (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_USER_ACTION_COMMENT_PROPERTY:
		font_manager_user_action_set_comment (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_USER_ACTION_EXECUTABLE_PROPERTY:
		font_manager_user_action_set_executable (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_USER_ACTION_ARGUMENTS_PROPERTY:
		font_manager_user_action_set_arguments (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_user_action_model_get_instance_private (FontManagerUserActionModel* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserActionModel_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GType
font_manager_user_action_model_real_get_item_type (GListModel* base)
{
	FontManagerUserActionModel * self;
	GType result;
	self = (FontManagerUserActionModel*) base;
	result = FONT_MANAGER_TYPE_USER_ACTION;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static guint
font_manager_user_action_model_real_get_n_items (GListModel* base)
{
	FontManagerUserActionModel * self;
	gint _tmp0_ = 0;
	GPtrArray* _tmp1_;
	guint result;
	self = (FontManagerUserActionModel*) base;
	_tmp1_ = self->priv->_items;
	if (_tmp1_ != NULL) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_items;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	result = (guint) _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject*
font_manager_user_action_model_real_get_item (GListModel* base,
                                              guint position)
{
	FontManagerUserActionModel * self;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	GObject* _tmp2_;
	GObject* result;
	self = (FontManagerUserActionModel*) base;
	_tmp0_ = self->priv->_items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = _g_object_ref0 ((GObject*) ((FontManagerUserAction*) _tmp1_));
	result = _tmp2_;
	return result;
}

FontManagerUserAction*
font_manager_user_action_model_get (FontManagerUserActionModel* self,
                                    guint index)
{
	guint _tmp0_;
	guint _tmp1_;
	GObject* _tmp2_;
	FontManagerUserAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = font_manager_user_action_model_get_size (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (index < _tmp1_, "index < size", NULL);
	_tmp2_ = g_list_model_get_item ((GListModel*) self, index);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserAction);
	return result;
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		FontManagerUserActionModel* self;
		self = _data28_->self;
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static void
__lambda11_ (Block28Data* _data28_)
{
	FontManagerUserActionModel* self;
	self = _data28_->self;
	g_list_model_items_changed ((GListModel*) self, _data28_->position, (guint) 0, (guint) 0);
}

static void
___lambda11__font_manager_cacheable_changed (FontManagerCacheable* _sender,
                                             gpointer self)
{
	__lambda11_ (self);
}

void
font_manager_user_action_model_add_item (FontManagerUserActionModel* self,
                                         FontManagerUserAction* item)
{
	Block28Data* _data28_;
	GPtrArray* _tmp0_;
	FontManagerUserAction* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = self->priv->_items;
	_tmp1_ = _g_object_ref0 (item);
	g_ptr_array_add (_tmp0_, _tmp1_);
	_tmp2_ = font_manager_user_action_model_get_size (self);
	_tmp3_ = _tmp2_;
	_data28_->position = _tmp3_ - 1;
	g_list_model_items_changed ((GListModel*) self, _data28_->position, (guint) 0, (guint) 1);
	g_signal_connect_data ((FontManagerCacheable*) item, "changed", (GCallback) ___lambda11__font_manager_cacheable_changed, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	block28_data_unref (_data28_);
	_data28_ = NULL;
	return;
}

void
font_manager_user_action_model_remove_item (FontManagerUserActionModel* self,
                                            guint position)
{
	GPtrArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_items;
	g_ptr_array_remove_index (_tmp0_, position);
	g_list_model_items_changed ((GListModel*) self, position, (guint) 1, (guint) 0);
	return;
}

gchar*
font_manager_user_action_model_get_cache_file (void)
{
	gchar* dirpath = NULL;
	gchar* _tmp0_;
	gchar* filepath = NULL;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = font_manager_get_package_config_directory ();
	dirpath = _tmp0_;
	_tmp1_ = g_build_filename (dirpath, "Actions.json", NULL);
	filepath = _tmp1_;
	g_mkdir_with_parents (dirpath, 0755);
	result = filepath;
	_g_free0 (dirpath);
	return result;
}

static void
___lambda12_ (FontManagerUserActionModel* self,
              JsonArray* arr,
              guint index,
              JsonNode* node)
{
	FontManagerUserAction* item = NULL;
	GObject* _tmp0_;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = json_gobject_deserialize (FONT_MANAGER_TYPE_USER_ACTION, node);
	item = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserAction);
	font_manager_user_action_model_add_item (self, item);
	_g_object_unref0 (item);
}

static void
____lambda12__json_array_foreach (JsonArray* array,
                                  guint index_,
                                  JsonNode* element_node,
                                  gpointer self)
{
	___lambda12_ ((FontManagerUserActionModel*) self, array, index_, element_node);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

void
font_manager_user_action_model_load (FontManagerUserActionModel* self)
{
	JsonNode* node = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	JsonNode* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = font_manager_user_action_model_get_cache_file ();
	_tmp1_ = _tmp0_;
	_tmp2_ = font_manager_load_json_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	node = _tmp3_;
	_tmp4_ = node;
	if (_tmp4_ != NULL) {
		JsonNode* _tmp5_;
		JsonArray* _tmp6_;
		_tmp5_ = node;
		_tmp6_ = json_node_get_array (_tmp5_);
		json_array_foreach_element (_tmp6_, ____lambda12__json_array_foreach, self);
	}
	__vala_JsonNode_free0 (node);
	return;
}

void
font_manager_user_action_model_clear (FontManagerUserActionModel* self)
{
	guint n_items = 0U;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	n_items = g_list_model_get_n_items ((GListModel*) self);
	font_manager_user_action_model_set_items (self, NULL);
	g_list_model_items_changed ((GListModel*) self, (guint) 0, n_items, (guint) 0);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	font_manager_user_action_model_set_items (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	return;
}

static void
_font_manager_user_action_model_save_g_list_model_items_changed (GListModel* _sender,
                                                                 guint position,
                                                                 guint removed,
                                                                 guint added,
                                                                 gpointer self)
{
	font_manager_user_action_model_save ((FontManagerUserActionModel*) self);
}

void
font_manager_user_action_model_reload (FontManagerUserActionModel* self)
{
	g_return_if_fail (self != NULL);
	font_manager_user_action_model_clear (self);
	font_manager_user_action_model_load (self);
	g_signal_connect_object ((GListModel*) self, "items-changed", (GCallback) _font_manager_user_action_model_save_g_list_model_items_changed, self, G_CONNECT_AFTER);
	return;
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		FontManagerUserActionModel* self;
		self = _data29_->self;
		_json_array_unref0 (_data29_->array);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
__lambda13_ (Block29Data* _data29_,
             FontManagerUserAction* item)
{
	FontManagerUserActionModel* self;
	JsonNode* item_node = NULL;
	JsonNode* _tmp0_;
	JsonArray* _tmp1_;
	JsonObject* _tmp2_;
	JsonObject* _tmp3_;
	self = _data29_->self;
	g_return_if_fail (item != NULL);
	_tmp0_ = json_gobject_serialize ((GObject*) item);
	item_node = _tmp0_;
	_tmp1_ = _data29_->array;
	_tmp2_ = json_node_get_object (item_node);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	json_array_add_object_element (_tmp1_, _tmp3_);
	__vala_JsonNode_free0 (item_node);
}

static void
___lambda13__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda13_ (self, (FontManagerUserAction*) data);
}

void
font_manager_user_action_model_save (FontManagerUserActionModel* self)
{
	Block29Data* _data29_;
	GPtrArray* _tmp0_;
	JsonNode* node = NULL;
	JsonNode* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	JsonArray* _tmp4_;
	GPtrArray* _tmp5_;
	JsonNode* _tmp6_;
	JsonArray* _tmp7_;
	JsonNode* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = self->priv->_items;
	if (_tmp0_ == NULL) {
		block29_data_unref (_data29_);
		_data29_ = NULL;
		return;
	}
	_tmp1_ = json_node_new (JSON_NODE_ARRAY);
	node = _tmp1_;
	_tmp2_ = font_manager_user_action_model_get_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = json_array_sized_new (_tmp3_);
	_data29_->array = _tmp4_;
	_tmp5_ = self->priv->_items;
	g_ptr_array_foreach (_tmp5_, ___lambda13__gfunc, _data29_);
	_tmp6_ = node;
	_tmp7_ = _data29_->array;
	json_node_set_array (_tmp6_, _tmp7_);
	_tmp8_ = node;
	_tmp9_ = font_manager_user_action_model_get_cache_file ();
	_tmp10_ = _tmp9_;
	font_manager_write_json_file (_tmp8_, _tmp10_, TRUE);
	_g_free0 (_tmp10_);
	__vala_JsonNode_free0 (node);
	block29_data_unref (_data29_);
	_data29_ = NULL;
	return;
}

FontManagerUserActionModel*
font_manager_user_action_model_construct (GType object_type)
{
	FontManagerUserActionModel * self = NULL;
	self = (FontManagerUserActionModel*) g_object_new (object_type, NULL);
	return self;
}

FontManagerUserActionModel*
font_manager_user_action_model_new (void)
{
	return font_manager_user_action_model_construct (FONT_MANAGER_TYPE_USER_ACTION_MODEL);
}

GPtrArray*
font_manager_user_action_model_get_items (FontManagerUserActionModel* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_items;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
font_manager_user_action_model_set_items (FontManagerUserActionModel* self,
                                          GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_action_model_get_items (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_items);
		self->priv->_items = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_action_model_properties[FONT_MANAGER_USER_ACTION_MODEL_ITEMS_PROPERTY]);
	}
}

guint
font_manager_user_action_model_get_size (FontManagerUserActionModel* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_list_model_get_n_items ((GListModel*) self);
	return result;
}

static void
font_manager_user_action_model_class_init (FontManagerUserActionModelClass * klass,
                                           gpointer klass_data)
{
	font_manager_user_action_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserActionModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_user_action_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_user_action_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_action_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_ACTION_MODEL_ITEMS_PROPERTY, font_manager_user_action_model_properties[FONT_MANAGER_USER_ACTION_MODEL_ITEMS_PROPERTY] = g_param_spec_boxed ("items", "items", "items", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_ACTION_MODEL_SIZE_PROPERTY, font_manager_user_action_model_properties[FONT_MANAGER_USER_ACTION_MODEL_SIZE_PROPERTY] = g_param_spec_uint ("size", "size", "size", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_user_action_model_g_list_model_interface_init (GListModelInterface * iface,
                                                            gpointer iface_data)
{
	font_manager_user_action_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) font_manager_user_action_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) font_manager_user_action_model_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) font_manager_user_action_model_real_get_item;
}

static void
font_manager_user_action_model_instance_init (FontManagerUserActionModel * self,
                                              gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = font_manager_user_action_model_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->_items = _tmp0_;
}

static void
font_manager_user_action_model_finalize (GObject * obj)
{
	FontManagerUserActionModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_USER_ACTION_MODEL, FontManagerUserActionModel);
	_g_ptr_array_unref0 (self->priv->_items);
	G_OBJECT_CLASS (font_manager_user_action_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_action_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserActionModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_action_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserActionModel), 0, (GInstanceInitFunc) font_manager_user_action_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) font_manager_user_action_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType font_manager_user_action_model_type_id;
	font_manager_user_action_model_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerUserActionModel", &g_define_type_info, 0);
	g_type_add_interface_static (font_manager_user_action_model_type_id, g_list_model_get_type (), &g_list_model_info);
	FontManagerUserActionModel_private_offset = g_type_add_instance_private (font_manager_user_action_model_type_id, sizeof (FontManagerUserActionModelPrivate));
	return font_manager_user_action_model_type_id;
}

GType
font_manager_user_action_model_get_type (void)
{
	static volatile gsize font_manager_user_action_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_action_model_type_id__once)) {
		GType font_manager_user_action_model_type_id;
		font_manager_user_action_model_type_id = font_manager_user_action_model_get_type_once ();
		g_once_init_leave (&font_manager_user_action_model_type_id__once, font_manager_user_action_model_type_id);
	}
	return font_manager_user_action_model_type_id__once;
}

static void
_vala_font_manager_user_action_model_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerUserActionModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_ACTION_MODEL, FontManagerUserActionModel);
	switch (property_id) {
		case FONT_MANAGER_USER_ACTION_MODEL_ITEMS_PROPERTY:
		g_value_set_boxed (value, font_manager_user_action_model_get_items (self));
		break;
		case FONT_MANAGER_USER_ACTION_MODEL_SIZE_PROPERTY:
		g_value_set_uint (value, font_manager_user_action_model_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_user_action_model_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerUserActionModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_ACTION_MODEL, FontManagerUserActionModel);
	switch (property_id) {
		case FONT_MANAGER_USER_ACTION_MODEL_ITEMS_PROPERTY:
		font_manager_user_action_model_set_items (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_user_action_row_get_instance_private (FontManagerUserActionRow* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserActionRow_private_offset);
}

FontManagerUserActionRow*
font_manager_user_action_row_from_item (GObject* item)
{
	FontManagerUserAction* action = NULL;
	FontManagerUserAction* _tmp0_;
	FontManagerUserActionRow* row = NULL;
	FontManagerUserActionRow* _tmp1_;
	GBindingFlags flags = 0U;
	GtkImage* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkEntry* _tmp6_;
	FontManagerUserActionRow* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, FONT_MANAGER_TYPE_USER_ACTION, FontManagerUserAction));
	action = _tmp0_;
	_tmp1_ = font_manager_user_action_row_new ();
	g_object_ref_sink (_tmp1_);
	row = _tmp1_;
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp2_ = row->priv->action_icon;
	g_object_bind_property_with_closures ((GObject*) action, "action_icon", (GObject*) _tmp2_, "icon-name", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp3_ = row->priv->action_name;
	g_object_bind_property_with_closures ((GObject*) action, "action_name", (GObject*) _tmp3_, "text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = row->priv->comment;
	g_object_bind_property_with_closures ((GObject*) action, "comment", (GObject*) _tmp4_, "text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = row->priv->executable;
	g_object_bind_property_with_closures ((GObject*) action, "executable", (GObject*) _tmp5_, "text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp6_ = row->priv->arguments;
	g_object_bind_property_with_closures ((GObject*) action, "arguments", (GObject*) _tmp6_, "text", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = row;
	_g_object_unref0 (action);
	return result;
}

static void
font_manager_user_action_row_on_file_selections_ready (FontManagerUserActionRow* self,
                                                       GObject* obj,
                                                       GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	g_return_if_fail (obj != NULL);
	{
		GtkFileDialog* dialog = NULL;
		GtkFileDialog* _tmp0_;
		GFile* file = NULL;
		GFile* _tmp1_;
		GtkEntry* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_file_dialog_get_type (), GtkFileDialog));
		dialog = _tmp0_;
		_tmp1_ = gtk_file_dialog_open_finish (dialog, res, &_inner_error0_);
		file = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dialog);
			goto __catch0_g_error;
		}
		_tmp2_ = self->priv->executable;
		_tmp3_ = g_file_get_path (file);
		_tmp4_ = _tmp3_;
		gtk_editable_set_text ((GtkEditable*) _tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (file);
		_g_object_unref0 (dialog);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		if (_tmp5_->code == GTK_DIALOG_ERROR_FAILED) {
			GError* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("UserActions.vala:210: %s", _tmp7_);
		} else {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			_tmp8_ = gtk_widget_get_name ((GtkWidget*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_debug ("UserActions.vala:212: %s.on_file_selections_ready : %s", _tmp9_, _tmp11_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	return;
}

static void
_font_manager_user_action_row_on_file_selections_ready_gasync_ready_callback (GObject* source_object,
                                                                              GAsyncResult* res,
                                                                              gpointer self)
{
	font_manager_user_action_row_on_file_selections_ready ((FontManagerUserActionRow*) self, source_object, res);
	g_object_unref (self);
}

static void
font_manager_user_action_row_on_executable_icon_press (FontManagerUserActionRow* self,
                                                       GtkEntry* entry,
                                                       GtkEntryIconPosition position)
{
	GtkFileDialog* dialog = NULL;
	GtkFileDialog* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = font_manager_file_selector_get_executable ();
	dialog = _tmp0_;
	_tmp1_ = font_manager_get_parent_window ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	gtk_file_dialog_open (dialog, _tmp2_, NULL, _font_manager_user_action_row_on_file_selections_ready_gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (dialog);
	return;
}

static void
_font_manager_user_action_row_on_executable_icon_press_gtk_entry_icon_press (GtkEntry* _sender,
                                                                             GtkEntryIconPosition icon_pos,
                                                                             gpointer self)
{
	font_manager_user_action_row_on_executable_icon_press ((FontManagerUserActionRow*) self, _sender, icon_pos);
}

FontManagerUserActionRow*
font_manager_user_action_row_construct (GType object_type)
{
	FontManagerUserActionRow * self = NULL;
	self = (FontManagerUserActionRow*) g_object_new (object_type, NULL);
	return self;
}

FontManagerUserActionRow*
font_manager_user_action_row_new (void)
{
	return font_manager_user_action_row_construct (FONT_MANAGER_TYPE_USER_ACTION_ROW);
}

static void
font_manager_user_action_row_class_init (FontManagerUserActionRowClass * klass,
                                         gpointer klass_data)
{
	font_manager_user_action_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserActionRow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_action_row_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-user-action-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_icon", FALSE, FontManagerUserActionRow_private_offset + G_STRUCT_OFFSET (FontManagerUserActionRowPrivate, action_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_name", FALSE, FontManagerUserActionRow_private_offset + G_STRUCT_OFFSET (FontManagerUserActionRowPrivate, action_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "comment", FALSE, FontManagerUserActionRow_private_offset + G_STRUCT_OFFSET (FontManagerUserActionRowPrivate, comment));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "executable", FALSE, FontManagerUserActionRow_private_offset + G_STRUCT_OFFSET (FontManagerUserActionRowPrivate, executable));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arguments", FALSE, FontManagerUserActionRow_private_offset + G_STRUCT_OFFSET (FontManagerUserActionRowPrivate, arguments));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_executable_icon_press", G_CALLBACK(_font_manager_user_action_row_on_executable_icon_press_gtk_entry_icon_press));
}

static void
font_manager_user_action_row_instance_init (FontManagerUserActionRow * self,
                                            gpointer klass)
{
	self->priv = font_manager_user_action_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_user_action_row_finalize (GObject * obj)
{
	FontManagerUserActionRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_USER_ACTION_ROW, FontManagerUserActionRow);
	G_OBJECT_CLASS (font_manager_user_action_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_action_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserActionRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_action_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserActionRow), 0, (GInstanceInitFunc) font_manager_user_action_row_instance_init, NULL };
	GType font_manager_user_action_row_type_id;
	font_manager_user_action_row_type_id = g_type_register_static (gtk_grid_get_type (), "FontManagerUserActionRow", &g_define_type_info, 0);
	FontManagerUserActionRow_private_offset = g_type_add_instance_private (font_manager_user_action_row_type_id, sizeof (FontManagerUserActionRowPrivate));
	return font_manager_user_action_row_type_id;
}

GType
font_manager_user_action_row_get_type (void)
{
	static volatile gsize font_manager_user_action_row_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_action_row_type_id__once)) {
		GType font_manager_user_action_row_type_id;
		font_manager_user_action_row_type_id = font_manager_user_action_row_get_type_once ();
		g_once_init_leave (&font_manager_user_action_row_type_id__once, font_manager_user_action_row_type_id);
	}
	return font_manager_user_action_row_type_id__once;
}

static inline gpointer
font_manager_user_action_list_get_instance_private (FontManagerUserActionList* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserActionList_private_offset);
}

static GtkWidget*
_font_manager_user_action_row_from_item_gtk_list_box_create_widget_func (GObject* item,
                                                                         gpointer self)
{
	GtkWidget* result;
	result = font_manager_user_action_row_from_item (item);
	return result;
}

static void
__lambda153_ (FontManagerUserActionList* self)
{
	GtkListBox* _tmp0_;
	FontManagerUserActionModel* _tmp1_;
	_tmp0_ = ((FontManagerPreferenceList*) self)->list;
	_tmp1_ = self->priv->_model;
	gtk_list_box_bind_model (_tmp0_, (GListModel*) _tmp1_, _font_manager_user_action_row_from_item_gtk_list_box_create_widget_func, NULL, NULL);
}

static void
___lambda153__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda153_ ((FontManagerUserActionList*) self);
}

FontManagerUserActionList*
font_manager_user_action_list_construct (GType object_type)
{
	FontManagerUserActionList * self = NULL;
	FontManagerBaseControls* _tmp0_;
	FontManagerUserActionModel* _tmp1_;
	FontManagerUserActionModel* _tmp2_;
	FontManagerUserActionModel* _tmp3_;
	FontManagerPlaceHolder* place_holder = NULL;
	FontManagerPlaceHolder* _tmp4_;
	GtkListBox* _tmp5_;
	FontManagerBaseControls* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	self = (FontManagerUserActionList*) font_manager_preference_list_construct (object_type);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerUserActionList");
	_tmp0_ = ((FontManagerPreferenceList*) self)->controls;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	g_signal_connect_object ((GObject*) self, "notify::model", (GCallback) ___lambda153__g_object_notify, self, 0);
	_tmp1_ = font_manager_user_action_model_new ();
	_tmp2_ = _tmp1_;
	font_manager_user_action_list_set_model (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_model;
	font_manager_user_action_model_load (_tmp3_);
	_tmp4_ = (FontManagerPlaceHolder*) font_manager_place_holder_new (_ ("User Actions"), NULL, _ ("Custom context menu entries"), "open-menu-symbolic");
	g_object_ref_sink (_tmp4_);
	place_holder = _tmp4_;
	_tmp5_ = ((FontManagerPreferenceList*) self)->list;
	gtk_list_box_set_placeholder (_tmp5_, (GtkWidget*) place_holder);
	_tmp6_ = ((FontManagerPreferenceList*) self)->controls;
	_tmp7_ = font_manager_inline_help_widget (FONT_MANAGER_USER_ACTION_LIST_help_text);
	_tmp8_ = _tmp7_;
	gtk_box_append ((GtkBox*) _tmp6_, (GtkWidget*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (place_holder);
	return self;
}

FontManagerUserActionList*
font_manager_user_action_list_new (void)
{
	return font_manager_user_action_list_construct (FONT_MANAGER_TYPE_USER_ACTION_LIST);
}

static void
font_manager_user_action_list_real_on_map (FontManagerPreferenceList* base)
{
	FontManagerUserActionList * self;
	FontManagerUserActionModel* _tmp0_;
	self = (FontManagerUserActionList*) base;
	_tmp0_ = self->priv->_model;
	font_manager_user_action_model_reload (_tmp0_);
	FONT_MANAGER_PREFERENCE_LIST_CLASS (font_manager_user_action_list_parent_class)->on_map (G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList));
	return;
}

static void
font_manager_user_action_list_real_on_add_selected (FontManagerPreferenceList* base)
{
	FontManagerUserActionList * self;
	FontManagerUserActionModel* _tmp0_;
	FontManagerUserAction* _tmp1_;
	FontManagerUserAction* _tmp2_;
	self = (FontManagerUserActionList*) base;
	_tmp0_ = self->priv->_model;
	_tmp1_ = font_manager_user_action_new ();
	_tmp2_ = _tmp1_;
	font_manager_user_action_model_add_item (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	return;
}

static void
font_manager_user_action_list_real_on_remove_selected (FontManagerPreferenceList* base)
{
	FontManagerUserActionList * self;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	guint position = 0U;
	GtkListBox* _tmp2_;
	GtkListBoxRow* _tmp3_;
	FontManagerUserActionModel* _tmp4_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBoxRow* _tmp10_;
	self = (FontManagerUserActionList*) base;
	_tmp0_ = ((FontManagerPreferenceList*) self)->list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = ((FontManagerPreferenceList*) self)->list;
	_tmp3_ = gtk_list_box_get_selected_row (_tmp2_);
	position = (guint) gtk_list_box_row_get_index (_tmp3_);
	_tmp4_ = self->priv->_model;
	font_manager_user_action_model_remove_item (_tmp4_, position);
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		guint _tmp7_;
		if (position > ((guint) 0)) {
			FontManagerUserActionModel* _tmp6_;
			_tmp6_ = self->priv->_model;
			_tmp5_ = position >= g_list_model_get_n_items ((GListModel*) _tmp6_);
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp7_ = position;
		position = _tmp7_ - 1;
	}
	_tmp8_ = ((FontManagerPreferenceList*) self)->list;
	_tmp9_ = ((FontManagerPreferenceList*) self)->list;
	_tmp10_ = gtk_list_box_get_row_at_index (_tmp9_, (gint) position);
	gtk_list_box_select_row (_tmp8_, _tmp10_);
	return;
}

FontManagerUserActionModel*
font_manager_user_action_list_get_model (FontManagerUserActionList* self)
{
	FontManagerUserActionModel* result;
	FontManagerUserActionModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

void
font_manager_user_action_list_set_model (FontManagerUserActionList* self,
                                         FontManagerUserActionModel* value)
{
	FontManagerUserActionModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_action_list_get_model (self);
	if (old_value != value) {
		FontManagerUserActionModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_action_list_properties[FONT_MANAGER_USER_ACTION_LIST_MODEL_PROPERTY]);
	}
}

static void
font_manager_user_action_list_class_init (FontManagerUserActionListClass * klass,
                                          gpointer klass_data)
{
	font_manager_user_action_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserActionList_private_offset);
	((FontManagerPreferenceListClass *) klass)->on_map = (void (*) (FontManagerPreferenceList*)) font_manager_user_action_list_real_on_map;
	((FontManagerPreferenceListClass *) klass)->on_add_selected = (void (*) (FontManagerPreferenceList*)) font_manager_user_action_list_real_on_add_selected;
	((FontManagerPreferenceListClass *) klass)->on_remove_selected = (void (*) (FontManagerPreferenceList*)) font_manager_user_action_list_real_on_remove_selected;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_user_action_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_user_action_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_action_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_ACTION_LIST_MODEL_PROPERTY, font_manager_user_action_list_properties[FONT_MANAGER_USER_ACTION_LIST_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", FONT_MANAGER_TYPE_USER_ACTION_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_user_action_list_instance_init (FontManagerUserActionList * self,
                                             gpointer klass)
{
	self->priv = font_manager_user_action_list_get_instance_private (self);
}

static void
font_manager_user_action_list_finalize (GObject * obj)
{
	FontManagerUserActionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_USER_ACTION_LIST, FontManagerUserActionList);
	_g_object_unref0 (self->priv->_model);
	G_OBJECT_CLASS (font_manager_user_action_list_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_action_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserActionListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_action_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserActionList), 0, (GInstanceInitFunc) font_manager_user_action_list_instance_init, NULL };
	GType font_manager_user_action_list_type_id;
	font_manager_user_action_list_type_id = g_type_register_static (FONT_MANAGER_TYPE_PREFERENCE_LIST, "FontManagerUserActionList", &g_define_type_info, 0);
	FontManagerUserActionList_private_offset = g_type_add_instance_private (font_manager_user_action_list_type_id, sizeof (FontManagerUserActionListPrivate));
	return font_manager_user_action_list_type_id;
}

GType
font_manager_user_action_list_get_type (void)
{
	static volatile gsize font_manager_user_action_list_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_action_list_type_id__once)) {
		GType font_manager_user_action_list_type_id;
		font_manager_user_action_list_type_id = font_manager_user_action_list_get_type_once ();
		g_once_init_leave (&font_manager_user_action_list_type_id__once, font_manager_user_action_list_type_id);
	}
	return font_manager_user_action_list_type_id__once;
}

static void
_vala_font_manager_user_action_list_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	FontManagerUserActionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_ACTION_LIST, FontManagerUserActionList);
	switch (property_id) {
		case FONT_MANAGER_USER_ACTION_LIST_MODEL_PROPERTY:
		g_value_set_object (value, font_manager_user_action_list_get_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_user_action_list_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	FontManagerUserActionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_ACTION_LIST, FontManagerUserActionList);
	switch (property_id) {
		case FONT_MANAGER_USER_ACTION_LIST_MODEL_PROPERTY:
		font_manager_user_action_list_set_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

