/* Substitutions.c generated by valac 0.56.18, the Vala compiler
 * generated from Substitutions.vala, do not modify */

/* Substitutions.vala
 *
 * Copyright (C) 2009-2024 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "font-manager.h"
#include <glib/gi18n-lib.h>

#define FONT_MANAGER_FONTCONFIG_DISCLAIMER _ ("A Fontconfig configuration file will be generated from these settings." \
"\n" \
"\n" \
"Running applications may require a restart to reflect any changes.\n" \
"\n" \
"Note that not all environments/applications will honor these settings.")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FONT_MANAGER_TYPE_SUBSTITUTE (font_manager_substitute_get_type ())
#define FONT_MANAGER_SUBSTITUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_SUBSTITUTE, FontManagerSubstitute))
#define FONT_MANAGER_SUBSTITUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_SUBSTITUTE, FontManagerSubstituteClass))
#define FONT_MANAGER_IS_SUBSTITUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_SUBSTITUTE))
#define FONT_MANAGER_IS_SUBSTITUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_SUBSTITUTE))
#define FONT_MANAGER_SUBSTITUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_SUBSTITUTE, FontManagerSubstituteClass))

typedef struct _FontManagerSubstitute FontManagerSubstitute;
typedef struct _FontManagerSubstituteClass FontManagerSubstituteClass;
typedef struct _FontManagerSubstitutePrivate FontManagerSubstitutePrivate;
enum  {
	FONT_MANAGER_SUBSTITUTE_0_PROPERTY,
	FONT_MANAGER_SUBSTITUTE_FAMILY_PROPERTY,
	FONT_MANAGER_SUBSTITUTE_PRIORITY_PROPERTY,
	FONT_MANAGER_SUBSTITUTE_NUM_PROPERTIES
};
static GParamSpec* font_manager_substitute_properties[FONT_MANAGER_SUBSTITUTE_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_SUBSTITUTE_ROW (font_manager_substitute_row_get_type ())
#define FONT_MANAGER_SUBSTITUTE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRow))
#define FONT_MANAGER_SUBSTITUTE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRowClass))
#define FONT_MANAGER_IS_SUBSTITUTE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_SUBSTITUTE_ROW))
#define FONT_MANAGER_IS_SUBSTITUTE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_SUBSTITUTE_ROW))
#define FONT_MANAGER_SUBSTITUTE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRowClass))

typedef struct _FontManagerSubstituteRow FontManagerSubstituteRow;
typedef struct _FontManagerSubstituteRowClass FontManagerSubstituteRowClass;
typedef struct _FontManagerSubstituteRowPrivate FontManagerSubstituteRowPrivate;
enum  {
	FONT_MANAGER_SUBSTITUTE_ROW_0_PROPERTY,
	FONT_MANAGER_SUBSTITUTE_ROW_FAMILY_PROPERTY,
	FONT_MANAGER_SUBSTITUTE_ROW_NUM_PROPERTIES
};
static GParamSpec* font_manager_substitute_row_properties[FONT_MANAGER_SUBSTITUTE_ROW_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_PREFERENCE_LIST (font_manager_preference_list_get_type ())
#define FONT_MANAGER_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList))
#define FONT_MANAGER_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))
#define FONT_MANAGER_IS_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_IS_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_PREFERENCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))

typedef struct _FontManagerPreferenceList FontManagerPreferenceList;
typedef struct _FontManagerPreferenceListClass FontManagerPreferenceListClass;
typedef struct _FontManagerPreferenceListPrivate FontManagerPreferenceListPrivate;

#define FONT_MANAGER_TYPE_BASE_CONTROLS (font_manager_base_controls_get_type ())
#define FONT_MANAGER_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls))
#define FONT_MANAGER_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))
#define FONT_MANAGER_IS_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_IS_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_BASE_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))

typedef struct _FontManagerBaseControls FontManagerBaseControls;
typedef struct _FontManagerBaseControlsClass FontManagerBaseControlsClass;

#define FONT_MANAGER_TYPE_SUBSTITUTE_LIST (font_manager_substitute_list_get_type ())
#define FONT_MANAGER_SUBSTITUTE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_SUBSTITUTE_LIST, FontManagerSubstituteList))
#define FONT_MANAGER_SUBSTITUTE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_SUBSTITUTE_LIST, FontManagerSubstituteListClass))
#define FONT_MANAGER_IS_SUBSTITUTE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_SUBSTITUTE_LIST))
#define FONT_MANAGER_IS_SUBSTITUTE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_SUBSTITUTE_LIST))
#define FONT_MANAGER_SUBSTITUTE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_SUBSTITUTE_LIST, FontManagerSubstituteListClass))

typedef struct _FontManagerSubstituteList FontManagerSubstituteList;
typedef struct _FontManagerSubstituteListClass FontManagerSubstituteListClass;
typedef struct _FontManagerSubstituteListPrivate FontManagerSubstituteListPrivate;
enum  {
	FONT_MANAGER_SUBSTITUTE_LIST_0_PROPERTY,
	FONT_MANAGER_SUBSTITUTE_LIST_NUM_PROPERTIES
};
static GParamSpec* font_manager_substitute_list_properties[FONT_MANAGER_SUBSTITUTE_LIST_NUM_PROPERTIES];

struct _FontManagerSubstitute {
	GtkGrid parent_instance;
	FontManagerSubstitutePrivate * priv;
};

struct _FontManagerSubstituteClass {
	GtkGridClass parent_class;
};

struct _FontManagerSubstitutePrivate {
	gchar* _family;
	gchar* _priority;
	GtkButton* close;
	GtkDropDown* type;
	GtkEntry* target;
	gchar* priorities[3];
};

struct _FontManagerSubstituteRow {
	GtkBox parent_instance;
	FontManagerSubstituteRowPrivate * priv;
};

struct _FontManagerSubstituteRowClass {
	GtkBoxClass parent_class;
};

struct _FontManagerSubstituteRowPrivate {
	gchar* _family;
	GtkEntry* entry;
	GtkListBox* list;
	GtkButton* add_button;
};

struct _FontManagerPreferenceList {
	GtkBox parent_instance;
	FontManagerPreferenceListPrivate * priv;
	GtkListBox* list;
	FontManagerBaseControls* controls;
	GtkSeparator* separator;
};

struct _FontManagerPreferenceListClass {
	GtkBoxClass parent_class;
	void (*on_add_selected) (FontManagerPreferenceList* self);
	void (*on_list_row_selected) (FontManagerPreferenceList* self, GtkListBox* box, GtkListBoxRow* row);
	void (*on_map) (FontManagerPreferenceList* self);
	void (*on_remove_selected) (FontManagerPreferenceList* self);
	void (*on_unmap) (FontManagerPreferenceList* self);
};

struct _FontManagerSubstituteList {
	FontManagerPreferenceList parent_instance;
	FontManagerSubstituteListPrivate * priv;
};

struct _FontManagerSubstituteListClass {
	FontManagerPreferenceListClass parent_class;
};

VALA_EXTERN GtkListStore* font_manager_family_completion_model;
GtkListStore* font_manager_family_completion_model = NULL;
static gint FontManagerSubstitute_private_offset;
static gpointer font_manager_substitute_parent_class = NULL;
static gint FontManagerSubstituteRow_private_offset;
static gpointer font_manager_substitute_row_parent_class = NULL;
static gpointer font_manager_substitute_list_parent_class = NULL;

VALA_EXTERN GtkListStore* font_manager_get_family_completion_model (void);
VALA_EXTERN gboolean font_manager_load_user_font_resources (void);
VALA_EXTERN GtkEntryCompletion* font_manager_get_family_completion (void);
VALA_EXTERN GtkWidget* font_manager_get_bin_child (GtkWidget* widget);
VALA_EXTERN GType font_manager_substitute_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerSubstitute, g_object_unref)
static void font_manager_substitute_real_constructed (GObject* base);
static gboolean __lambda158_ (FontManagerSubstitute* self,
                       GBinding* b,
                       GValue* s,
                       GValue* t);
static gboolean ___lambda158__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static gboolean __lambda159_ (FontManagerSubstitute* self,
                       GBinding* b,
                       GValue* s,
                       GValue* t);
static gboolean ___lambda159__gbinding_transform_func (GBinding* binding,
                                                GValue* from_value,
                                                GValue* to_value,
                                                gpointer self);
static void __lambda160_ (FontManagerSubstitute* self);
static void ___lambda160__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
VALA_EXTERN FontManagerSubstitute* font_manager_substitute_new (void);
VALA_EXTERN FontManagerSubstitute* font_manager_substitute_construct (GType object_type);
VALA_EXTERN const gchar* font_manager_substitute_get_family (FontManagerSubstitute* self);
VALA_EXTERN void font_manager_substitute_set_family (FontManagerSubstitute* self,
                                         const gchar* value);
VALA_EXTERN const gchar* font_manager_substitute_get_priority (FontManagerSubstitute* self);
VALA_EXTERN void font_manager_substitute_set_priority (FontManagerSubstitute* self,
                                           const gchar* value);
static void font_manager_substitute_finalize (GObject * obj);
static GType font_manager_substitute_get_type_once (void);
static void _vala_font_manager_substitute_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_font_manager_substitute_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
VALA_EXTERN GType font_manager_substitute_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerSubstituteRow, g_object_unref)
static void font_manager_substitute_row_real_constructed (GObject* base);
static void font_manager_substitute_row_on_add_button_clicked (FontManagerSubstituteRow* self);
static void _font_manager_substitute_row_on_add_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void font_manager_substitute_row_on_entry_changed (FontManagerSubstituteRow* self);
VALA_EXTERN void font_manager_set_control_sensitivity (GtkWidget* widget,
                                           gboolean sensitive);
static void _font_manager_substitute_row_on_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                         gpointer self);
VALA_EXTERN FontManagerSubstituteRow* font_manager_substitute_row_new_from_element (FontManagerAliasElement* alias);
VALA_EXTERN FontManagerSubstituteRow* font_manager_substitute_row_construct_from_element (GType object_type,
                                                                              FontManagerAliasElement* alias);
VALA_EXTERN void font_manager_substitute_row_set_family (FontManagerSubstituteRow* self,
                                             const gchar* value);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN FontManagerAliasElement* font_manager_substitute_row_to_element (FontManagerSubstituteRow* self);
VALA_EXTERN FontManagerSubstituteRow* font_manager_substitute_row_new (void);
VALA_EXTERN FontManagerSubstituteRow* font_manager_substitute_row_construct (GType object_type);
VALA_EXTERN const gchar* font_manager_substitute_row_get_family (FontManagerSubstituteRow* self);
static void font_manager_substitute_row_finalize (GObject * obj);
static GType font_manager_substitute_row_get_type_once (void);
static void _vala_font_manager_substitute_row_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_font_manager_substitute_row_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
VALA_EXTERN GType font_manager_preference_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreferenceList, g_object_unref)
VALA_EXTERN GType font_manager_base_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseControls, g_object_unref)
VALA_EXTERN GType font_manager_substitute_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerSubstituteList, g_object_unref)
VALA_EXTERN void font_manager_preference_list_on_add_selected (FontManagerPreferenceList* self);
VALA_EXTERN void font_manager_preference_list_on_map (FontManagerPreferenceList* self);
VALA_EXTERN void font_manager_preference_list_on_unmap (FontManagerPreferenceList* self);
VALA_EXTERN void font_manager_preference_list_on_remove_selected (FontManagerPreferenceList* self);
VALA_EXTERN FontManagerSubstituteList* font_manager_substitute_list_new (void);
VALA_EXTERN FontManagerSubstituteList* font_manager_substitute_list_construct (GType object_type);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_new (void);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_construct (GType object_type);
VALA_EXTERN GtkImage* font_manager_inline_help_widget (const gchar* message);
static void font_manager_substitute_list_clear (FontManagerSubstituteList* self);
VALA_EXTERN gboolean font_manager_substitute_list_load (FontManagerSubstituteList* self);
static gint __lambda161_ (FontManagerSubstituteList* self,
                   GtkListBoxRow* row1,
                   GtkListBoxRow* row2);
static gint ___lambda161__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                           GtkListBoxRow* row2,
                                           gpointer self);
VALA_EXTERN gboolean font_manager_substitute_list_save (FontManagerSubstituteList* self);
static void font_manager_substitute_list_real_on_add_selected (FontManagerPreferenceList* base);
static void font_manager_substitute_list_real_on_map (FontManagerPreferenceList* base);
static void font_manager_substitute_list_real_on_unmap (FontManagerPreferenceList* base);
static void font_manager_substitute_list_real_on_remove_selected (FontManagerPreferenceList* base);
static GType font_manager_substitute_list_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkListStore*
font_manager_get_family_completion_model (void)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp16_;
	GtkListStore* _tmp17_;
	GtkListStore* result;
	_tmp0_ = font_manager_family_completion_model;
	if (_tmp0_ == NULL) {
		GtkListStore* _tmp1_;
		_tmp1_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
		_g_object_unref0 (font_manager_family_completion_model);
		font_manager_family_completion_model = _tmp1_;
		font_manager_update_font_configuration ();
		font_manager_load_user_font_resources ();
		{
			FontManagerStringSet* _family_list = NULL;
			FontManagerStringSet* _tmp2_;
			guint _family_size = 0U;
			FontManagerStringSet* _tmp3_;
			guint _tmp4_;
			guint _tmp5_;
			gint _family_index = 0;
			_tmp2_ = font_manager_list_available_font_families ();
			_family_list = _tmp2_;
			_tmp3_ = _family_list;
			g_object_get (_tmp3_, "size", &_tmp4_, NULL);
			_tmp5_ = _tmp4_;
			_family_size = _tmp5_;
			_family_index = -1;
			while (TRUE) {
				gint _tmp6_;
				guint _tmp7_;
				gchar* family = NULL;
				FontManagerStringSet* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp11_;
				GtkTreeIter _tmp12_ = {0};
				GtkListStore* _tmp13_;
				GtkTreeIter _tmp14_;
				const gchar* _tmp15_;
				_family_index = _family_index + 1;
				_tmp6_ = _family_index;
				_tmp7_ = _family_size;
				if (!(((guint) _tmp6_) < _tmp7_)) {
					break;
				}
				_tmp8_ = _family_list;
				_tmp9_ = font_manager_string_set_get (_tmp8_, (guint) _family_index);
				_tmp10_ = g_strdup (_tmp9_);
				family = _tmp10_;
				_tmp11_ = font_manager_family_completion_model;
				gtk_list_store_append (_tmp11_, &_tmp12_);
				iter = _tmp12_;
				_tmp13_ = font_manager_family_completion_model;
				_tmp14_ = iter;
				_tmp15_ = family;
				gtk_list_store_set (_tmp13_, &_tmp14_, 0, _tmp15_, -1, -1);
				_g_free0 (family);
			}
			_g_object_unref0 (_family_list);
		}
	}
	_tmp16_ = font_manager_family_completion_model;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	result = _tmp17_;
	return result;
}

GtkEntryCompletion*
font_manager_get_family_completion (void)
{
	GtkEntryCompletion* family_completion = NULL;
	GtkEntryCompletion* _tmp0_;
	GtkListStore* _tmp1_;
	GtkListStore* _tmp2_;
	GtkEntryCompletion* result;
	_tmp0_ = gtk_entry_completion_new ();
	family_completion = _tmp0_;
	_tmp1_ = font_manager_get_family_completion_model ();
	_tmp2_ = _tmp1_;
	gtk_entry_completion_set_model (family_completion, (GtkTreeModel*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_entry_completion_set_text_column (family_completion, 0);
	result = family_completion;
	return result;
}

GtkWidget*
font_manager_get_bin_child (GtkWidget* widget)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	if (widget == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = gtk_widget_get_first_child (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static inline gpointer
font_manager_substitute_get_instance_private (FontManagerSubstitute* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerSubstitute_private_offset);
}

static gboolean
__lambda158_ (FontManagerSubstitute* self,
              GBinding* b,
              GValue* s,
              GValue* t)
{
	GValue _tmp0_;
	const gchar* _tmp1_;
	GValue _tmp2_ = {0};
	gboolean result;
	g_return_val_if_fail (b != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = *s;
	_tmp1_ = self->priv->priorities[g_value_get_uint (&_tmp0_)];
	g_value_init (&_tmp2_, G_TYPE_STRING);
	g_value_set_string (&_tmp2_, _tmp1_);
	G_IS_VALUE (t) ? (g_value_unset (t), NULL) : NULL;
	*t = _tmp2_;
	result = TRUE;
	return result;
}

static gboolean
___lambda158__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = __lambda158_ ((FontManagerSubstitute*) self, binding, from_value, to_value);
	return result;
}

static gboolean
__lambda159_ (FontManagerSubstitute* self,
              GBinding* b,
              GValue* s,
              GValue* t)
{
	gboolean result;
	g_return_val_if_fail (b != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				GValue _tmp3_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < ((guint) 3))) {
					break;
				}
				_tmp2_ = self->priv->priorities[i];
				_tmp3_ = *s;
				if (g_strcmp0 (_tmp2_, g_value_get_string (&_tmp3_)) == 0) {
					GValue _tmp4_ = {0};
					g_value_init (&_tmp4_, G_TYPE_UINT);
					g_value_set_uint (&_tmp4_, i);
					G_IS_VALUE (t) ? (g_value_unset (t), NULL) : NULL;
					*t = _tmp4_;
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda159__gbinding_transform_func (GBinding* binding,
                                       GValue* from_value,
                                       GValue* to_value,
                                       gpointer self)
{
	gboolean result;
	result = __lambda159_ ((FontManagerSubstitute*) self, binding, from_value, to_value);
	return result;
}

static void
__lambda160_ (FontManagerSubstitute* self)
{
	GtkListBox* list = NULL;
	GtkWidget* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* parent = NULL;
	GtkWidget* _tmp2_;
	GtkListBoxRow* _tmp3_;
	_tmp0_ = gtk_widget_get_ancestor ((GtkWidget*) self, gtk_list_box_get_type ());
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_list_box_get_type (), GtkListBox));
	list = _tmp1_;
	_tmp2_ = gtk_widget_get_ancestor ((GtkWidget*) self, gtk_list_box_row_get_type ());
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_list_box_row_get_type (), GtkListBoxRow));
	parent = _tmp3_;
	gtk_list_box_remove (list, (GtkWidget*) parent);
	_g_object_unref0 (parent);
	_g_object_unref0 (list);
}

static void
___lambda160__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda160_ ((FontManagerSubstitute*) self);
}

static void
font_manager_substitute_real_constructed (GObject* base)
{
	FontManagerSubstitute * self;
	GtkEntry* _tmp0_;
	GtkEntryCompletion* _tmp1_;
	GtkEntryCompletion* _tmp2_;
	GBindingFlags flags = 0U;
	GtkDropDown* _tmp3_;
	FontManagerSubstitute* _tmp4_;
	GBindingFlags _tmp5_;
	GtkEntry* _tmp6_;
	GtkButton* _tmp7_;
	self = (FontManagerSubstitute*) base;
	_tmp0_ = self->priv->target;
	_tmp1_ = font_manager_get_family_completion ();
	_tmp2_ = _tmp1_;
	gtk_entry_set_completion (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp3_ = self->priv->type;
	_tmp4_ = self;
	_tmp5_ = flags;
	g_object_bind_property_with_closures ((GObject*) _tmp3_, "selected", (GObject*) _tmp4_, "priority", _tmp5_, (GClosure*) ((___lambda158__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda158__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda159__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda159__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp6_ = self->priv->target;
	g_object_bind_property_with_closures ((GObject*) _tmp6_, "text", (GObject*) self, "family", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = self->priv->close;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) ___lambda160__gtk_button_clicked, self, 0);
	G_OBJECT_CLASS (font_manager_substitute_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
	return;
}

FontManagerSubstitute*
font_manager_substitute_construct (GType object_type)
{
	FontManagerSubstitute * self = NULL;
	self = (FontManagerSubstitute*) g_object_new (object_type, NULL);
	return self;
}

FontManagerSubstitute*
font_manager_substitute_new (void)
{
	return font_manager_substitute_construct (FONT_MANAGER_TYPE_SUBSTITUTE);
}

const gchar*
font_manager_substitute_get_family (FontManagerSubstitute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_family;
	result = _tmp0_;
	return result;
}

void
font_manager_substitute_set_family (FontManagerSubstitute* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_substitute_get_family (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_family);
		self->priv->_family = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_substitute_properties[FONT_MANAGER_SUBSTITUTE_FAMILY_PROPERTY]);
	}
}

const gchar*
font_manager_substitute_get_priority (FontManagerSubstitute* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_priority;
	result = _tmp0_;
	return result;
}

void
font_manager_substitute_set_priority (FontManagerSubstitute* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_substitute_get_priority (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_priority);
		self->priv->_priority = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_substitute_properties[FONT_MANAGER_SUBSTITUTE_PRIORITY_PROPERTY]);
	}
}

static void
font_manager_substitute_class_init (FontManagerSubstituteClass * klass,
                                    gpointer klass_data)
{
	font_manager_substitute_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerSubstitute_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) font_manager_substitute_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_substitute_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_substitute_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_substitute_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_SUBSTITUTE_FAMILY_PROPERTY, font_manager_substitute_properties[FONT_MANAGER_SUBSTITUTE_FAMILY_PROPERTY] = g_param_spec_string ("family", "family", "family", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_SUBSTITUTE_PRIORITY_PROPERTY, font_manager_substitute_properties[FONT_MANAGER_SUBSTITUTE_PRIORITY_PROPERTY] = g_param_spec_string ("priority", "priority", "priority", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-substitute.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "close", FALSE, FontManagerSubstitute_private_offset + G_STRUCT_OFFSET (FontManagerSubstitutePrivate, close));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "type", FALSE, FontManagerSubstitute_private_offset + G_STRUCT_OFFSET (FontManagerSubstitutePrivate, type));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "target", FALSE, FontManagerSubstitute_private_offset + G_STRUCT_OFFSET (FontManagerSubstitutePrivate, target));
}

static void
font_manager_substitute_instance_init (FontManagerSubstitute * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_[3] = {0};
	self->priv = font_manager_substitute_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_family = _tmp0_;
	_tmp1_ = g_strdup ("prefer");
	self->priv->_priority = _tmp1_;
	_tmp2_ = g_strdup ("prefer");
	_tmp3_ = g_strdup ("accept");
	_tmp4_ = g_strdup ("default");
	_tmp5_[0] = _tmp2_;
	_tmp5_[1] = _tmp3_;
	_tmp5_[2] = _tmp4_;
	memcpy (self->priv->priorities, _tmp5_, 3 * sizeof (gchar*));
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_substitute_finalize (GObject * obj)
{
	FontManagerSubstitute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_SUBSTITUTE, FontManagerSubstitute);
	_g_free0 (self->priv->_family);
	_g_free0 (self->priv->_priority);
	_vala_array_destroy (self->priv->priorities, 3, (GDestroyNotify) g_free);
	G_OBJECT_CLASS (font_manager_substitute_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_substitute_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerSubstituteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_substitute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerSubstitute), 0, (GInstanceInitFunc) font_manager_substitute_instance_init, NULL };
	GType font_manager_substitute_type_id;
	font_manager_substitute_type_id = g_type_register_static (gtk_grid_get_type (), "FontManagerSubstitute", &g_define_type_info, 0);
	FontManagerSubstitute_private_offset = g_type_add_instance_private (font_manager_substitute_type_id, sizeof (FontManagerSubstitutePrivate));
	return font_manager_substitute_type_id;
}

GType
font_manager_substitute_get_type (void)
{
	static volatile gsize font_manager_substitute_type_id__once = 0;
	if (g_once_init_enter (&font_manager_substitute_type_id__once)) {
		GType font_manager_substitute_type_id;
		font_manager_substitute_type_id = font_manager_substitute_get_type_once ();
		g_once_init_leave (&font_manager_substitute_type_id__once, font_manager_substitute_type_id);
	}
	return font_manager_substitute_type_id__once;
}

static void
_vala_font_manager_substitute_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	FontManagerSubstitute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_SUBSTITUTE, FontManagerSubstitute);
	switch (property_id) {
		case FONT_MANAGER_SUBSTITUTE_FAMILY_PROPERTY:
		g_value_set_string (value, font_manager_substitute_get_family (self));
		break;
		case FONT_MANAGER_SUBSTITUTE_PRIORITY_PROPERTY:
		g_value_set_string (value, font_manager_substitute_get_priority (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_substitute_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	FontManagerSubstitute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_SUBSTITUTE, FontManagerSubstitute);
	switch (property_id) {
		case FONT_MANAGER_SUBSTITUTE_FAMILY_PROPERTY:
		font_manager_substitute_set_family (self, g_value_get_string (value));
		break;
		case FONT_MANAGER_SUBSTITUTE_PRIORITY_PROPERTY:
		font_manager_substitute_set_priority (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_substitute_row_get_instance_private (FontManagerSubstituteRow* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerSubstituteRow_private_offset);
}

static void
font_manager_substitute_row_real_constructed (GObject* base)
{
	FontManagerSubstituteRow * self;
	GtkEntry* _tmp0_;
	GtkEntryCompletion* _tmp1_;
	GtkEntryCompletion* _tmp2_;
	GBindingFlags flags = 0U;
	GtkEntry* _tmp3_;
	self = (FontManagerSubstituteRow*) base;
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerSubstituteRow");
	_tmp0_ = self->priv->entry;
	_tmp1_ = font_manager_get_family_completion ();
	_tmp2_ = _tmp1_;
	gtk_entry_set_completion (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp3_ = self->priv->entry;
	g_object_bind_property_with_closures ((GObject*) _tmp3_, "text", (GObject*) self, "family", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	G_OBJECT_CLASS (font_manager_substitute_row_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox));
	return;
}

static void
font_manager_substitute_row_on_add_button_clicked (FontManagerSubstituteRow* self)
{
	GtkListBox* _tmp0_;
	FontManagerSubstitute* _tmp1_;
	FontManagerSubstitute* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = font_manager_substitute_new ();
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_list_box_insert (_tmp0_, (GtkWidget*) _tmp2_, -1);
	_g_object_unref0 (_tmp2_);
	return;
}

static void
_font_manager_substitute_row_on_add_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	font_manager_substitute_row_on_add_button_clicked ((FontManagerSubstituteRow*) self);
}

static void
font_manager_substitute_row_on_entry_changed (FontManagerSubstituteRow* self)
{
	GtkButton* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->add_button;
	_tmp1_ = self->priv->entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	font_manager_set_control_sensitivity ((GtkWidget*) _tmp0_, _tmp2_ != NULL);
	return;
}

static void
_font_manager_substitute_row_on_entry_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                    gpointer self)
{
	font_manager_substitute_row_on_entry_changed ((FontManagerSubstituteRow*) self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

FontManagerSubstituteRow*
font_manager_substitute_row_construct_from_element (GType object_type,
                                                    FontManagerAliasElement* alias)
{
	FontManagerSubstituteRow * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** priorities = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint priorities_length1;
	gint _priorities_size_;
	g_return_val_if_fail (alias != NULL, NULL);
	self = (FontManagerSubstituteRow*) g_object_new (object_type, NULL);
	g_object_get (alias, "family", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	font_manager_substitute_row_set_family (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_strdup ("default");
	_tmp4_ = g_strdup ("accept");
	_tmp5_ = g_strdup ("prefer");
	_tmp6_ = g_new0 (gchar*, 3 + 1);
	_tmp6_[0] = _tmp3_;
	_tmp6_[1] = _tmp4_;
	_tmp6_[2] = _tmp5_;
	priorities = _tmp6_;
	priorities_length1 = 3;
	_priorities_size_ = priorities_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gchar** _tmp9_;
				gint _tmp9__length1;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				FontManagerStringSet* _tmp12_;
				GList* _tmp13_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = priorities;
				_tmp9__length1 = priorities_length1;
				if (!(i < _tmp9__length1)) {
					break;
				}
				_tmp10_ = priorities;
				_tmp10__length1 = priorities_length1;
				_tmp11_ = _tmp10_[i];
				_tmp12_ = font_manager_alias_element_get (alias, _tmp11_);
				_tmp13_ = font_manager_string_set_list (_tmp12_);
				{
					GList* family_collection = NULL;
					GList* family_it = NULL;
					family_collection = _tmp13_;
					for (family_it = family_collection; family_it != NULL; family_it = family_it->next) {
						gchar* _tmp14_;
						gchar* family = NULL;
						_tmp14_ = g_strdup ((const gchar*) family_it->data);
						family = _tmp14_;
						{
							FontManagerSubstitute* sub = NULL;
							FontManagerSubstitute* _tmp15_;
							FontManagerSubstitute* _tmp16_;
							const gchar* _tmp17_;
							FontManagerSubstitute* _tmp18_;
							gchar** _tmp19_;
							gint _tmp19__length1;
							const gchar* _tmp20_;
							GtkListBox* _tmp21_;
							FontManagerSubstitute* _tmp22_;
							_tmp15_ = font_manager_substitute_new ();
							g_object_ref_sink (_tmp15_);
							sub = _tmp15_;
							_tmp16_ = sub;
							_tmp17_ = family;
							font_manager_substitute_set_family (_tmp16_, _tmp17_);
							_tmp18_ = sub;
							_tmp19_ = priorities;
							_tmp19__length1 = priorities_length1;
							_tmp20_ = _tmp19_[i];
							font_manager_substitute_set_priority (_tmp18_, _tmp20_);
							_tmp21_ = self->priv->list;
							_tmp22_ = sub;
							gtk_list_box_insert (_tmp21_, (GtkWidget*) _tmp22_, -1);
							_g_object_unref0 (sub);
							_g_free0 (family);
						}
					}
					(family_collection == NULL) ? NULL : (family_collection = (_g_list_free__g_free0_ (family_collection), NULL));
				}
			}
		}
	}
	priorities = (_vala_array_free (priorities, priorities_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

FontManagerSubstituteRow*
font_manager_substitute_row_new_from_element (FontManagerAliasElement* alias)
{
	return font_manager_substitute_row_construct_from_element (FONT_MANAGER_TYPE_SUBSTITUTE_ROW, alias);
}

FontManagerAliasElement*
font_manager_substitute_row_to_element (FontManagerSubstituteRow* self)
{
	FontManagerAliasElement* res = NULL;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	FontManagerAliasElement* _tmp2_;
	gint i = 0;
	FontManagerSubstitute* sub = NULL;
	GtkListBox* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkWidget* _tmp5_;
	FontManagerAliasElement* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	_tmp2_ = font_manager_alias_element_new (_tmp1_);
	res = _tmp2_;
	i = 0;
	_tmp3_ = self->priv->list;
	_tmp4_ = gtk_list_box_get_row_at_index (_tmp3_, i);
	_tmp5_ = font_manager_get_bin_child ((GtkWidget*) _tmp4_);
	sub = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FONT_MANAGER_TYPE_SUBSTITUTE, FontManagerSubstitute);
	while (TRUE) {
		FontManagerSubstitute* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		FontManagerSubstitute* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp26_;
		GtkListBox* _tmp27_;
		GtkListBoxRow* _tmp28_;
		GtkWidget* _tmp29_;
		_tmp6_ = sub;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp9_ = sub;
		_tmp10_ = font_manager_substitute_get_priority (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			FontManagerSubstitute* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = sub;
			_tmp13_ = font_manager_substitute_get_family (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			FontManagerSubstitute* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = sub;
			_tmp16_ = font_manager_substitute_get_family (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp7_ = g_strcmp0 (_tmp17_, "") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			FontManagerAliasElement* _tmp18_;
			FontManagerSubstitute* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			FontManagerStringSet* _tmp22_;
			FontManagerSubstitute* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			_tmp18_ = res;
			_tmp19_ = sub;
			_tmp20_ = font_manager_substitute_get_priority (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = font_manager_alias_element_get (_tmp18_, _tmp21_);
			_tmp23_ = sub;
			_tmp24_ = font_manager_substitute_get_family (_tmp23_);
			_tmp25_ = _tmp24_;
			font_manager_string_set_add (_tmp22_, _tmp25_);
		}
		_tmp26_ = i;
		i = _tmp26_ + 1;
		_tmp27_ = self->priv->list;
		_tmp28_ = gtk_list_box_get_row_at_index (_tmp27_, i);
		_tmp29_ = font_manager_get_bin_child ((GtkWidget*) _tmp28_);
		_g_object_unref0 (sub);
		sub = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, FONT_MANAGER_TYPE_SUBSTITUTE, FontManagerSubstitute);
	}
	result = res;
	_g_object_unref0 (sub);
	return result;
}

FontManagerSubstituteRow*
font_manager_substitute_row_construct (GType object_type)
{
	FontManagerSubstituteRow * self = NULL;
	self = (FontManagerSubstituteRow*) g_object_new (object_type, NULL);
	return self;
}

FontManagerSubstituteRow*
font_manager_substitute_row_new (void)
{
	return font_manager_substitute_row_construct (FONT_MANAGER_TYPE_SUBSTITUTE_ROW);
}

const gchar*
font_manager_substitute_row_get_family (FontManagerSubstituteRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_family;
	result = _tmp0_;
	return result;
}

void
font_manager_substitute_row_set_family (FontManagerSubstituteRow* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_substitute_row_get_family (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_family);
		self->priv->_family = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_substitute_row_properties[FONT_MANAGER_SUBSTITUTE_ROW_FAMILY_PROPERTY]);
	}
}

static void
font_manager_substitute_row_class_init (FontManagerSubstituteRowClass * klass,
                                        gpointer klass_data)
{
	font_manager_substitute_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerSubstituteRow_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) font_manager_substitute_row_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_substitute_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_substitute_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_substitute_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_SUBSTITUTE_ROW_FAMILY_PROPERTY, font_manager_substitute_row_properties[FONT_MANAGER_SUBSTITUTE_ROW_FAMILY_PROPERTY] = g_param_spec_string ("family", "family", "family", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-substitute-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry", FALSE, FontManagerSubstituteRow_private_offset + G_STRUCT_OFFSET (FontManagerSubstituteRowPrivate, entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list", FALSE, FontManagerSubstituteRow_private_offset + G_STRUCT_OFFSET (FontManagerSubstituteRowPrivate, list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_button", FALSE, FontManagerSubstituteRow_private_offset + G_STRUCT_OFFSET (FontManagerSubstituteRowPrivate, add_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_add_button_clicked", G_CALLBACK(_font_manager_substitute_row_on_add_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_entry_changed", G_CALLBACK(_font_manager_substitute_row_on_entry_changed_gtk_editable_changed));
}

static void
font_manager_substitute_row_instance_init (FontManagerSubstituteRow * self,
                                           gpointer klass)
{
	self->priv = font_manager_substitute_row_get_instance_private (self);
	self->priv->_family = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_substitute_row_finalize (GObject * obj)
{
	FontManagerSubstituteRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRow);
	_g_free0 (self->priv->_family);
	G_OBJECT_CLASS (font_manager_substitute_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_substitute_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerSubstituteRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_substitute_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerSubstituteRow), 0, (GInstanceInitFunc) font_manager_substitute_row_instance_init, NULL };
	GType font_manager_substitute_row_type_id;
	font_manager_substitute_row_type_id = g_type_register_static (gtk_box_get_type (), "FontManagerSubstituteRow", &g_define_type_info, 0);
	FontManagerSubstituteRow_private_offset = g_type_add_instance_private (font_manager_substitute_row_type_id, sizeof (FontManagerSubstituteRowPrivate));
	return font_manager_substitute_row_type_id;
}

GType
font_manager_substitute_row_get_type (void)
{
	static volatile gsize font_manager_substitute_row_type_id__once = 0;
	if (g_once_init_enter (&font_manager_substitute_row_type_id__once)) {
		GType font_manager_substitute_row_type_id;
		font_manager_substitute_row_type_id = font_manager_substitute_row_get_type_once ();
		g_once_init_leave (&font_manager_substitute_row_type_id__once, font_manager_substitute_row_type_id);
	}
	return font_manager_substitute_row_type_id__once;
}

static void
_vala_font_manager_substitute_row_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerSubstituteRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRow);
	switch (property_id) {
		case FONT_MANAGER_SUBSTITUTE_ROW_FAMILY_PROPERTY:
		g_value_set_string (value, font_manager_substitute_row_get_family (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_substitute_row_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	FontManagerSubstituteRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRow);
	switch (property_id) {
		case FONT_MANAGER_SUBSTITUTE_ROW_FAMILY_PROPERTY:
		font_manager_substitute_row_set_family (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

FontManagerSubstituteList*
font_manager_substitute_list_construct (GType object_type)
{
	FontManagerSubstituteList * self = NULL;
	FontManagerBaseControls* _tmp0_;
	gchar* w1 = NULL;
	gchar* _tmp1_;
	gchar* w2 = NULL;
	gchar* _tmp2_;
	gchar* w3 = NULL;
	gchar* _tmp3_;
	FontManagerPlaceHolder* place_holder = NULL;
	FontManagerPlaceHolder* _tmp4_;
	GtkListBox* _tmp5_;
	GtkImage* help = NULL;
	GtkImage* _tmp6_;
	FontManagerBaseControls* _tmp7_;
	self = (FontManagerSubstituteList*) font_manager_preference_list_construct (object_type);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerSubstituteList");
	_tmp0_ = ((FontManagerPreferenceList*) self)->controls;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = g_strdup (_ ("Font Substitutions"));
	w1 = _tmp1_;
	_tmp2_ = g_strdup (_ ("Easily substitute one font family for another."));
	w2 = _tmp2_;
	_tmp3_ = g_strdup (_ ("To add a new substitute click the add button in the toolbar."));
	w3 = _tmp3_;
	_tmp4_ = (FontManagerPlaceHolder*) font_manager_place_holder_new (w1, w2, w3, "edit-find-replace-symbolic");
	g_object_ref_sink (_tmp4_);
	place_holder = _tmp4_;
	_tmp5_ = ((FontManagerPreferenceList*) self)->list;
	gtk_list_box_set_placeholder (_tmp5_, (GtkWidget*) place_holder);
	_tmp6_ = font_manager_inline_help_widget (FONT_MANAGER_FONTCONFIG_DISCLAIMER);
	help = _tmp6_;
	_tmp7_ = ((FontManagerPreferenceList*) self)->controls;
	gtk_box_append ((GtkBox*) _tmp7_, (GtkWidget*) help);
	_g_object_unref0 (help);
	_g_object_unref0 (place_holder);
	_g_free0 (w3);
	_g_free0 (w2);
	_g_free0 (w1);
	return self;
}

FontManagerSubstituteList*
font_manager_substitute_list_new (void)
{
	return font_manager_substitute_list_construct (FONT_MANAGER_TYPE_SUBSTITUTE_LIST);
}

static void
font_manager_substitute_list_clear (FontManagerSubstituteList* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GtkListBox* _tmp0_;
		GtkListBoxRow* _tmp1_;
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp2_;
		GtkListBoxRow* _tmp3_;
		GtkListBoxRow* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		_tmp0_ = ((FontManagerPreferenceList*) self)->list;
		_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, 0);
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = ((FontManagerPreferenceList*) self)->list;
		_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, 0);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		row = _tmp4_;
		_tmp5_ = ((FontManagerPreferenceList*) self)->list;
		_tmp6_ = row;
		gtk_list_box_remove (_tmp5_, (GtkWidget*) _tmp6_);
		_g_object_unref0 (row);
	}
	return;
}

static gint
__lambda161_ (FontManagerSubstituteList* self,
              GtkListBoxRow* row1,
              GtkListBoxRow* row2)
{
	FontManagerSubstituteRow* a = NULL;
	GtkWidget* _tmp0_;
	FontManagerSubstituteRow* b = NULL;
	GtkWidget* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = font_manager_get_bin_child ((GtkWidget*) row1);
	a = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRow);
	_tmp1_ = font_manager_get_bin_child ((GtkWidget*) row2);
	b = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRow);
	_tmp2_ = font_manager_substitute_row_get_family (a);
	_tmp3_ = _tmp2_;
	_tmp4_ = font_manager_substitute_row_get_family (b);
	_tmp5_ = _tmp4_;
	result = font_manager_natural_sort (_tmp3_, _tmp5_);
	_g_object_unref0 (b);
	_g_object_unref0 (a);
	return result;
}

static gint
___lambda161__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                      GtkListBoxRow* row2,
                                      gpointer self)
{
	gint result;
	result = __lambda161_ ((FontManagerSubstituteList*) self, row1, row2);
	return result;
}

gboolean
font_manager_substitute_list_load (FontManagerSubstituteList* self)
{
	FontManagerAliases* aliases = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	FontManagerAliases* _tmp2_ = NULL;
	gboolean res = FALSE;
	FontManagerAliases* _tmp3_;
	FontManagerAliases* _tmp4_;
	GList* _tmp5_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = font_manager_get_user_fontconfig_directory ();
	_tmp1_ = g_strdup ("39-Aliases.conf");
	_tmp2_ = font_manager_aliases_new ();
	g_object_set (_tmp2_, "config-dir", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	g_object_set (_tmp2_, "target-file", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	aliases = _tmp2_;
	_tmp3_ = aliases;
	res = font_manager_aliases_load (_tmp3_);
	_tmp4_ = aliases;
	_tmp5_ = font_manager_aliases_list (_tmp4_);
	{
		GList* element_collection = NULL;
		GList* element_it = NULL;
		element_collection = _tmp5_;
		for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
			FontManagerAliasElement* _tmp6_;
			FontManagerAliasElement* element = NULL;
			_tmp6_ = _g_object_ref0 ((FontManagerAliasElement*) element_it->data);
			element = _tmp6_;
			{
				FontManagerSubstituteRow* row = NULL;
				FontManagerAliasElement* _tmp7_;
				FontManagerSubstituteRow* _tmp8_;
				GtkListBox* _tmp9_;
				FontManagerSubstituteRow* _tmp10_;
				_tmp7_ = element;
				_tmp8_ = font_manager_substitute_row_new_from_element (_tmp7_);
				g_object_ref_sink (_tmp8_);
				row = _tmp8_;
				_tmp9_ = ((FontManagerPreferenceList*) self)->list;
				_tmp10_ = row;
				gtk_list_box_insert (_tmp9_, (GtkWidget*) _tmp10_, -1);
				_g_object_unref0 (row);
				_g_object_unref0 (element);
			}
		}
		(element_collection == NULL) ? NULL : (element_collection = (g_list_free (element_collection), NULL));
	}
	_tmp11_ = ((FontManagerPreferenceList*) self)->list;
	gtk_list_box_set_sort_func (_tmp11_, ___lambda161__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp12_ = ((FontManagerPreferenceList*) self)->list;
	gtk_list_box_invalidate_sort (_tmp12_);
	result = res;
	_g_object_unref0 (aliases);
	return result;
}

gboolean
font_manager_substitute_list_save (FontManagerSubstituteList* self)
{
	FontManagerAliases* aliases = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	FontManagerAliases* _tmp2_ = NULL;
	gint i = 0;
	FontManagerSubstituteRow* alias_row = NULL;
	GtkListBox* _tmp3_;
	GtkListBoxRow* _tmp4_;
	GtkWidget* _tmp5_;
	gboolean res = FALSE;
	FontManagerAliases* _tmp27_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = font_manager_get_user_fontconfig_directory ();
	_tmp1_ = g_strdup ("39-Aliases.conf");
	_tmp2_ = font_manager_aliases_new ();
	g_object_set (_tmp2_, "config-dir", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	g_object_set (_tmp2_, "target-file", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	aliases = _tmp2_;
	i = 0;
	_tmp3_ = ((FontManagerPreferenceList*) self)->list;
	_tmp4_ = gtk_list_box_get_row_at_index (_tmp3_, i);
	_tmp5_ = font_manager_get_bin_child ((GtkWidget*) _tmp4_);
	alias_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRow);
	while (TRUE) {
		FontManagerSubstituteRow* _tmp6_;
		FontManagerAliasElement* element = NULL;
		FontManagerSubstituteRow* _tmp7_;
		FontManagerAliasElement* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		FontManagerAliasElement* _tmp11_;
		gint _tmp23_;
		GtkListBox* _tmp24_;
		GtkListBoxRow* _tmp25_;
		GtkWidget* _tmp26_;
		_tmp6_ = alias_row;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = alias_row;
		_tmp8_ = font_manager_substitute_row_to_element (_tmp7_);
		element = _tmp8_;
		_tmp11_ = element;
		if (_tmp11_ != NULL) {
			FontManagerAliasElement* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp12_ = element;
			g_object_get (_tmp12_, "family", &_tmp13_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_;
			_tmp10_ = _tmp15_ != NULL;
			_g_free0 (_tmp15_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			FontManagerAliasElement* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = element;
			g_object_get (_tmp16_, "family", &_tmp17_, NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp9_ = g_strcmp0 (_tmp19_, "") != 0;
			_g_free0 (_tmp19_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			FontManagerAliases* _tmp20_;
			FontManagerAliasElement* _tmp21_;
			FontManagerAliasElement* _tmp22_;
			_tmp20_ = aliases;
			_tmp21_ = element;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			font_manager_aliases_add_element (_tmp20_, _tmp22_);
		}
		_tmp23_ = i;
		i = _tmp23_ + 1;
		_tmp24_ = ((FontManagerPreferenceList*) self)->list;
		_tmp25_ = gtk_list_box_get_row_at_index (_tmp24_, i);
		_tmp26_ = font_manager_get_bin_child ((GtkWidget*) _tmp25_);
		_g_object_unref0 (alias_row);
		alias_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, FONT_MANAGER_TYPE_SUBSTITUTE_ROW, FontManagerSubstituteRow);
		_g_object_unref0 (element);
	}
	_tmp27_ = aliases;
	res = font_manager_aliases_save (_tmp27_);
	result = res;
	_g_object_unref0 (alias_row);
	_g_object_unref0 (aliases);
	return result;
}

static void
font_manager_substitute_list_real_on_add_selected (FontManagerPreferenceList* base)
{
	FontManagerSubstituteList * self;
	GtkListBox* _tmp0_;
	FontManagerSubstituteRow* _tmp1_;
	FontManagerSubstituteRow* _tmp2_;
	self = (FontManagerSubstituteList*) base;
	_tmp0_ = ((FontManagerPreferenceList*) self)->list;
	_tmp1_ = font_manager_substitute_row_new ();
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_list_box_insert (_tmp0_, (GtkWidget*) _tmp2_, -1);
	_g_object_unref0 (_tmp2_);
	return;
}

static void
font_manager_substitute_list_real_on_map (FontManagerPreferenceList* base)
{
	FontManagerSubstituteList * self;
	self = (FontManagerSubstituteList*) base;
	font_manager_substitute_list_load (self);
	FONT_MANAGER_PREFERENCE_LIST_CLASS (font_manager_substitute_list_parent_class)->on_map (G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList));
	return;
}

static void
font_manager_substitute_list_real_on_unmap (FontManagerPreferenceList* base)
{
	FontManagerSubstituteList * self;
	self = (FontManagerSubstituteList*) base;
	font_manager_substitute_list_save (self);
	font_manager_substitute_list_clear (self);
	return;
}

static void
font_manager_substitute_list_real_on_remove_selected (FontManagerPreferenceList* base)
{
	FontManagerSubstituteList * self;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBoxRow* _tmp2_;
	self = (FontManagerSubstituteList*) base;
	_tmp0_ = ((FontManagerPreferenceList*) self)->list;
	_tmp1_ = ((FontManagerPreferenceList*) self)->list;
	_tmp2_ = gtk_list_box_get_selected_row (_tmp1_);
	gtk_list_box_remove (_tmp0_, (GtkWidget*) _tmp2_);
	return;
}

static void
font_manager_substitute_list_class_init (FontManagerSubstituteListClass * klass,
                                         gpointer klass_data)
{
	font_manager_substitute_list_parent_class = g_type_class_peek_parent (klass);
	((FontManagerPreferenceListClass *) klass)->on_add_selected = (void (*) (FontManagerPreferenceList*)) font_manager_substitute_list_real_on_add_selected;
	((FontManagerPreferenceListClass *) klass)->on_map = (void (*) (FontManagerPreferenceList*)) font_manager_substitute_list_real_on_map;
	((FontManagerPreferenceListClass *) klass)->on_unmap = (void (*) (FontManagerPreferenceList*)) font_manager_substitute_list_real_on_unmap;
	((FontManagerPreferenceListClass *) klass)->on_remove_selected = (void (*) (FontManagerPreferenceList*)) font_manager_substitute_list_real_on_remove_selected;
}

static void
font_manager_substitute_list_instance_init (FontManagerSubstituteList * self,
                                            gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
font_manager_substitute_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerSubstituteListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_substitute_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerSubstituteList), 0, (GInstanceInitFunc) font_manager_substitute_list_instance_init, NULL };
	GType font_manager_substitute_list_type_id;
	font_manager_substitute_list_type_id = g_type_register_static (FONT_MANAGER_TYPE_PREFERENCE_LIST, "FontManagerSubstituteList", &g_define_type_info, 0);
	return font_manager_substitute_list_type_id;
}

GType
font_manager_substitute_list_get_type (void)
{
	static volatile gsize font_manager_substitute_list_type_id__once = 0;
	if (g_once_init_enter (&font_manager_substitute_list_type_id__once)) {
		GType font_manager_substitute_list_type_id;
		font_manager_substitute_list_type_id = font_manager_substitute_list_get_type_once ();
		g_once_init_leave (&font_manager_substitute_list_type_id__once, font_manager_substitute_list_type_id);
	}
	return font_manager_substitute_list_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

