/* Collection.c generated by valac 0.56.18, the Vala compiler
 * generated from Collection.vala, do not modify */

/* Collection.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include "font-manager.h"
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <sqlite3.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_COLLECTION_STATE (font_manager_collection_state_get_type ())
#define FONT_MANAGER_COLLECTION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_COLLECTION_STATE, FontManagerCollectionState))
#define FONT_MANAGER_COLLECTION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_COLLECTION_STATE, FontManagerCollectionStateClass))
#define FONT_MANAGER_IS_COLLECTION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_COLLECTION_STATE))
#define FONT_MANAGER_IS_COLLECTION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_COLLECTION_STATE))
#define FONT_MANAGER_COLLECTION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_COLLECTION_STATE, FontManagerCollectionStateClass))

typedef struct _FontManagerCollectionState FontManagerCollectionState;
typedef struct _FontManagerCollectionStateClass FontManagerCollectionStateClass;
typedef struct _FontManagerCollectionStatePrivate FontManagerCollectionStatePrivate;
enum  {
	FONT_MANAGER_COLLECTION_STATE_0_PROPERTY,
	FONT_MANAGER_COLLECTION_STATE_NUM_PROPERTIES
};
static GParamSpec* font_manager_collection_state_properties[FONT_MANAGER_COLLECTION_STATE_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_CACHEABLE (font_manager_cacheable_get_type ())
#define FONT_MANAGER_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheable))
#define FONT_MANAGER_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))
#define FONT_MANAGER_IS_CACHEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_IS_CACHEABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_CACHEABLE))
#define FONT_MANAGER_CACHEABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_CACHEABLE, FontManagerCacheableClass))

typedef struct _FontManagerCacheable FontManagerCacheable;
typedef struct _FontManagerCacheableClass FontManagerCacheableClass;

#define FONT_MANAGER_TYPE_FONT_LIST_FILTER (font_manager_font_list_filter_get_type ())
#define FONT_MANAGER_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter))
#define FONT_MANAGER_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))
#define FONT_MANAGER_IS_FONT_LIST_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_IS_FONT_LIST_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_FILTER))
#define FONT_MANAGER_FONT_LIST_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilterClass))

typedef struct _FontManagerFontListFilter FontManagerFontListFilter;
typedef struct _FontManagerFontListFilterClass FontManagerFontListFilterClass;

#define FONT_MANAGER_TYPE_COLLECTION (font_manager_collection_get_type ())
#define FONT_MANAGER_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_COLLECTION, FontManagerCollection))
#define FONT_MANAGER_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_COLLECTION, FontManagerCollectionClass))
#define FONT_MANAGER_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_COLLECTION))
#define FONT_MANAGER_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_COLLECTION))
#define FONT_MANAGER_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_COLLECTION, FontManagerCollectionClass))

typedef struct _FontManagerCollection FontManagerCollection;
typedef struct _FontManagerCollectionClass FontManagerCollectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FontManagerCacheablePrivate FontManagerCacheablePrivate;
typedef struct _FontManagerFontListFilterPrivate FontManagerFontListFilterPrivate;
typedef struct _FontManagerCollectionPrivate FontManagerCollectionPrivate;
enum  {
	FONT_MANAGER_COLLECTION_0_PROPERTY,
	FONT_MANAGER_COLLECTION_AVAILABLE_FAMILIES_PROPERTY,
	FONT_MANAGER_COLLECTION_DISABLED_FAMILIES_PROPERTY,
	FONT_MANAGER_COLLECTION_ACTIVE_PROPERTY,
	FONT_MANAGER_COLLECTION_INCONSISTENT_PROPERTY,
	FONT_MANAGER_COLLECTION_CHILDREN_PROPERTY,
	FONT_MANAGER_COLLECTION_FAMILIES_PROPERTY,
	FONT_MANAGER_COLLECTION_SIZE_PROPERTY,
	FONT_MANAGER_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* font_manager_collection_properties[FONT_MANAGER_COLLECTION_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerCollectionState {
	GObject parent_instance;
	FontManagerCollectionStatePrivate * priv;
	gboolean is_disabled;
	gboolean partially_disabled;
};

struct _FontManagerCollectionStateClass {
	GObjectClass parent_class;
};

struct _FontManagerCacheable {
	GObject parent_instance;
	FontManagerCacheablePrivate * priv;
};

struct _FontManagerCacheableClass {
	GObjectClass parent_class;
	gboolean (*deserialize_property) (FontManagerCacheable* self, const gchar* prop_name, GValue* val, GParamSpec* pspec, JsonNode* node);
	JsonNode* (*serialize_property) (FontManagerCacheable* self, const gchar* prop_name, GValue* val, GParamSpec* pspec);
};

struct _FontManagerFontListFilter {
	FontManagerCacheable parent_instance;
	FontManagerFontListFilterPrivate * priv;
};

struct _FontManagerFontListFilterClass {
	FontManagerCacheableClass parent_class;
	void (*update) (FontManagerFontListFilter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*update_finish) (FontManagerFontListFilter* self, GAsyncResult* _res_);
	gboolean (*matches) (FontManagerFontListFilter* self, GObject* item);
	gchar* (*get_name) (FontManagerFontListFilter* self);
	void (*set_name) (FontManagerFontListFilter* self, const gchar* value);
	gchar* (*get_icon) (FontManagerFontListFilter* self);
	void (*set_icon) (FontManagerFontListFilter* self, const gchar* value);
	gchar* (*get_comment) (FontManagerFontListFilter* self);
	void (*set_comment) (FontManagerFontListFilter* self, const gchar* value);
	gint (*get_index) (FontManagerFontListFilter* self);
	void (*set_index) (FontManagerFontListFilter* self, gint value);
	gint (*get_size) (FontManagerFontListFilter* self);
	gint (*get_depth) (FontManagerFontListFilter* self);
	void (*set_depth) (FontManagerFontListFilter* self, gint value);
};

struct _FontManagerCollection {
	FontManagerFontListFilter parent_instance;
	FontManagerCollectionPrivate * priv;
};

struct _FontManagerCollectionClass {
	FontManagerFontListFilterClass parent_class;
};

struct _FontManagerCollectionPrivate {
	FontManagerStringSet* _available_families;
	FontManagerReject* _disabled_families;
	gboolean _active;
	gboolean _inconsistent;
	GPtrArray* _children;
	FontManagerStringSet* _families;
	guint state_change_timeout;
	gboolean ignore_activation;
};

struct _Block19Data {
	int _ref_count_;
	FontManagerCollection* self;
	gint total;
};

struct _Block20Data {
	int _ref_count_;
	FontManagerCollection* self;
	FontManagerStringSet* full_contents;
};

struct _Block21Data {
	int _ref_count_;
	FontManagerCollection* self;
	FontManagerStringSet* full_contents;
};

struct _Block22Data {
	int _ref_count_;
	FontManagerCollection* self;
	GPtrArray* res;
};

struct _Block23Data {
	int _ref_count_;
	FontManagerCollection* self;
	FontManagerStringSet* res;
};

struct _Block24Data {
	int _ref_count_;
	FontManagerCollection* self;
	JsonObject* obj;
};

static gpointer font_manager_collection_state_parent_class = NULL;
static gint FontManagerCollection_private_offset;
static gpointer font_manager_collection_parent_class = NULL;

VALA_EXTERN GType font_manager_collection_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCollectionState, g_object_unref)
VALA_EXTERN void font_manager_collection_state_update (GTask* task,
                                           GObject* source,
                                           void* data,
                                           GCancellable* cancellable);
VALA_EXTERN GType font_manager_cacheable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCacheable, g_object_unref)
VALA_EXTERN GType font_manager_font_list_filter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListFilter, g_object_unref)
VALA_EXTERN GType font_manager_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerCollection, g_object_unref)
VALA_EXTERN FontManagerCollectionState* font_manager_collection_state_new (void);
VALA_EXTERN FontManagerCollectionState* font_manager_collection_state_construct (GType object_type);
VALA_EXTERN FontManagerReject* font_manager_collection_get_disabled_families (FontManagerCollection* self);
VALA_EXTERN FontManagerStringSet* font_manager_collection_get_families (FontManagerCollection* self);
static void font_manager_collection_state_finalize (GObject * obj);
static GType font_manager_collection_state_get_type_once (void);
VALA_EXTERN gboolean font_manager_font_list_filter_matches (FontManagerFontListFilter* self,
                                                GObject* item);
VALA_EXTERN gboolean font_manager_cacheable_deserialize_property (FontManagerCacheable* self,
                                                      const gchar* prop_name,
                                                      GValue* val,
                                                      GParamSpec* pspec,
                                                      JsonNode* node);
VALA_EXTERN JsonNode* font_manager_cacheable_serialize_property (FontManagerCacheable* self,
                                                     const gchar* prop_name,
                                                     GValue* val,
                                                     GParamSpec* pspec);
VALA_EXTERN gint font_manager_font_list_filter_get_size (FontManagerFontListFilter* self);
VALA_EXTERN FontManagerCollection* font_manager_collection_new (const gchar* name,
                                                    const gchar* comment);
VALA_EXTERN FontManagerCollection* font_manager_collection_construct (GType object_type,
                                                          const gchar* name,
                                                          const gchar* comment);
VALA_EXTERN FontManagerFontListFilter* font_manager_font_list_filter_new (void);
VALA_EXTERN FontManagerFontListFilter* font_manager_font_list_filter_construct (GType object_type);
VALA_EXTERN void font_manager_font_list_filter_set_name (FontManagerFontListFilter* self,
                                             const gchar* value);
VALA_EXTERN void font_manager_font_list_filter_set_comment (FontManagerFontListFilter* self,
                                                const gchar* value);
VALA_EXTERN void font_manager_collection_clear_children (FontManagerCollection* self);
VALA_EXTERN GPtrArray* font_manager_collection_get_children (FontManagerCollection* self);
static void __lambda46_ (FontManagerCollection* self,
                  FontManagerCollection* child);
static void ___lambda46__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN void font_manager_collection_set_children (FontManagerCollection* self,
                                           GPtrArray* value);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void font_manager_collection_remove (FontManagerCollection* self,
                                     FontManagerStringSet* old_families);
VALA_EXTERN void font_manager_collection_add (FontManagerCollection* self,
                                  FontManagerStringSet* new_families);
VALA_EXTERN gboolean font_manager_collection_contains (FontManagerCollection* self,
                                           FontManagerCollection* collection);
VALA_EXTERN gchar* font_manager_font_list_filter_get_name (FontManagerFontListFilter* self);
static void font_manager_collection_on_state_update_complete (FontManagerCollection* self,
                                                       GObject* source,
                                                       GTask* task);
static void _vala_GValue_free (GValue* self);
static GValue* _g_value_dup (GValue* self);
VALA_EXTERN void font_manager_collection_set_active (FontManagerCollection* self,
                                         gboolean value);
VALA_EXTERN gboolean font_manager_collection_get_active (FontManagerCollection* self);
VALA_EXTERN void font_manager_collection_set_inconsistent (FontManagerCollection* self,
                                               gboolean value);
static gboolean font_manager_collection_update_state (FontManagerCollection* self);
static void _font_manager_collection_on_state_update_complete_gasync_ready_callback (GObject* source_object,
                                                                              GTask* task,
                                                                              gpointer self);
static void _font_manager_collection_state_update_gtask_thread_func (GTask* task,
                                                              GObject* source_object,
                                                              void* task_data,
                                                              GCancellable* cancellable);
VALA_EXTERN void font_manager_collection_queue_state_update (FontManagerCollection* self);
static gboolean _font_manager_collection_update_state_gsource_func (gpointer self);
VALA_EXTERN void font_manager_collection_on_state_toggled (GtkCheckButton* check,
                                               FontManagerCollection* self);
static gint font_manager_collection_get_collection_total (FontManagerCollection* self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
VALA_EXTERN FontManagerStringSet* font_manager_collection_get_available_families (FontManagerCollection* self);
static void __lambda47_ (Block19Data* _data19_,
                  FontManagerCollection* child);
static void ___lambda47__gfunc (gconstpointer data,
                         gpointer self);
static void font_manager_collection_add_child_contents (FontManagerCollection* self,
                                                 FontManagerCollection* child,
                                                 FontManagerStringSet* full_contents);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda48_ (Block20Data* _data20_,
                  FontManagerCollection* _child);
static void ___lambda48__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN FontManagerStringSet* font_manager_collection_get_full_contents (FontManagerCollection* self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void __lambda49_ (Block21Data* _data21_,
                  FontManagerCollection* _child);
static void ___lambda49__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN FontManagerStringSet* font_manager_collection_get_filelist (FontManagerCollection* self);
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
static gboolean font_manager_collection_real_matches (FontManagerFontListFilter* base,
                                               GObject* item);
static gboolean font_manager_collection_real_deserialize_property (FontManagerCacheable* base,
                                                            const gchar* prop_name,
                                                            GValue* val,
                                                            GParamSpec* pspec,
                                                            JsonNode* node);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void ___lambda50_ (Block22Data* _data22_,
                   JsonObject* obj,
                   const gchar* name,
                   JsonNode* node);
static void ____lambda50__json_object_foreach (JsonObject* object,
                                        const gchar* member_name,
                                        JsonNode* member_node,
                                        gpointer self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void ____lambda51_ (Block23Data* _data23_,
                    JsonArray* arr,
                    guint index,
                    JsonNode* node);
static void _____lambda51__json_array_foreach (JsonArray* array,
                                        guint index_,
                                        JsonNode* element_node,
                                        gpointer self);
static JsonNode* font_manager_collection_real_serialize_property (FontManagerCacheable* base,
                                                           const gchar* prop_name,
                                                           GValue* val,
                                                           GParamSpec* pspec);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void ___lambda52_ (Block24Data* _data24_,
                   FontManagerCollection* child);
static void ____lambda52__gfunc (gconstpointer data,
                          gpointer self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN void font_manager_collection_set_available_families (FontManagerCollection* self,
                                                     FontManagerStringSet* value);
VALA_EXTERN void font_manager_collection_set_disabled_families (FontManagerCollection* self,
                                                    FontManagerReject* value);
VALA_EXTERN gboolean font_manager_collection_get_inconsistent (FontManagerCollection* self);
VALA_EXTERN void font_manager_collection_set_families (FontManagerCollection* self,
                                           FontManagerStringSet* value);
static GObject * font_manager_collection_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _font_manager_collection___lambda53_ (FontManagerCollection* self);
static void __font_manager_collection___lambda53__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _font_manager_collection___lambda54_ (FontManagerCollection* self);
static void _font_manager_collection_queue_state_update_font_manager_string_set_changed (FontManagerStringSet* _sender,
                                                                                  gpointer self);
static void __font_manager_collection___lambda54__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void font_manager_collection_finalize (GObject * obj);
static GType font_manager_collection_get_type_once (void);
static void _vala_font_manager_collection_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_font_manager_collection_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
font_manager_collection_state_update (GTask* task,
                                      GObject* source,
                                      void* data,
                                      GCancellable* cancellable)
{
	FontManagerCollection* collection = NULL;
	FontManagerCollection* _tmp0_;
	FontManagerCollectionState* _result_ = NULL;
	FontManagerCollectionState* _tmp1_;
	FontManagerStringSet* disabled_families = NULL;
	FontManagerStringSet* _tmp2_;
	FontManagerCollection* _tmp3_;
	FontManagerReject* _tmp4_;
	FontManagerReject* _tmp5_;
	gboolean _tmp15_ = FALSE;
	FontManagerCollectionState* _tmp16_;
	GValue return_val = {0};
	GValue _tmp32_ = {0};
	FontManagerCollectionState* _tmp33_;
	GValue _tmp34_;
	g_return_if_fail (task != NULL);
	g_return_if_fail (source != NULL);
	_vala_assert (FONT_MANAGER_IS_COLLECTION (source), "source is Collection");
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, FONT_MANAGER_TYPE_COLLECTION, FontManagerCollection));
	collection = _tmp0_;
	_tmp1_ = font_manager_collection_state_new ();
	_result_ = _tmp1_;
	_tmp2_ = font_manager_string_set_new ();
	disabled_families = _tmp2_;
	_tmp3_ = collection;
	_tmp4_ = font_manager_collection_get_disabled_families (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		FontManagerStringSet* _tmp6_;
		FontManagerCollection* _tmp7_;
		FontManagerReject* _tmp8_;
		FontManagerReject* _tmp9_;
		FontManagerCollectionState* _tmp10_;
		FontManagerStringSet* _tmp11_;
		FontManagerCollection* _tmp12_;
		FontManagerStringSet* _tmp13_;
		FontManagerStringSet* _tmp14_;
		_tmp6_ = disabled_families;
		_tmp7_ = collection;
		_tmp8_ = font_manager_collection_get_disabled_families (_tmp7_);
		_tmp9_ = _tmp8_;
		font_manager_string_set_add_all (_tmp6_, (FontManagerStringSet*) _tmp9_);
		_tmp10_ = _result_;
		_tmp11_ = disabled_families;
		_tmp12_ = collection;
		_tmp13_ = font_manager_collection_get_families (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_->is_disabled = font_manager_string_set_contains_all (_tmp11_, _tmp14_);
	} else {
		_g_object_unref0 (disabled_families);
		disabled_families = NULL;
	}
	_tmp16_ = _result_;
	if (!_tmp16_->is_disabled) {
		FontManagerStringSet* _tmp17_;
		_tmp17_ = disabled_families;
		_tmp15_ = _tmp17_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		{
			FontManagerStringSet* _family_list = NULL;
			FontManagerCollection* _tmp18_;
			FontManagerStringSet* _tmp19_;
			FontManagerStringSet* _tmp20_;
			guint _family_size = 0U;
			FontManagerStringSet* _tmp21_;
			guint _tmp22_;
			guint _tmp23_;
			gint _family_index = 0;
			_tmp18_ = collection;
			_tmp19_ = font_manager_collection_get_families (_tmp18_);
			_tmp20_ = _tmp19_;
			_family_list = _tmp20_;
			_tmp21_ = _family_list;
			g_object_get (_tmp21_, "size", &_tmp22_, NULL);
			_tmp23_ = _tmp22_;
			_family_size = _tmp23_;
			_family_index = -1;
			while (TRUE) {
				gint _tmp24_;
				guint _tmp25_;
				gchar* family = NULL;
				FontManagerStringSet* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				FontManagerStringSet* _tmp29_;
				const gchar* _tmp30_;
				_family_index = _family_index + 1;
				_tmp24_ = _family_index;
				_tmp25_ = _family_size;
				if (!(((guint) _tmp24_) < _tmp25_)) {
					break;
				}
				_tmp26_ = _family_list;
				_tmp27_ = font_manager_string_set_get (_tmp26_, (guint) _family_index);
				_tmp28_ = g_strdup (_tmp27_);
				family = _tmp28_;
				_tmp29_ = disabled_families;
				_tmp30_ = family;
				if (font_manager_string_set_contains (_tmp29_, _tmp30_)) {
					FontManagerCollectionState* _tmp31_;
					_tmp31_ = _result_;
					_tmp31_->partially_disabled = TRUE;
					_g_free0 (family);
					break;
				}
				_g_free0 (family);
			}
		}
	}
	g_value_init (&_tmp32_, FONT_MANAGER_TYPE_COLLECTION_STATE);
	return_val = _tmp32_;
	_tmp33_ = _result_;
	g_value_set_object (&return_val, (GObject*) _tmp33_);
	_tmp34_ = return_val;
	g_task_return_value (task, &_tmp34_);
	G_IS_VALUE (&return_val) ? (g_value_unset (&return_val), NULL) : NULL;
	_g_object_unref0 (disabled_families);
	_g_object_unref0 (_result_);
	_g_object_unref0 (collection);
	return;
}

FontManagerCollectionState*
font_manager_collection_state_construct (GType object_type)
{
	FontManagerCollectionState * self = NULL;
	self = (FontManagerCollectionState*) g_object_new (object_type, NULL);
	return self;
}

FontManagerCollectionState*
font_manager_collection_state_new (void)
{
	return font_manager_collection_state_construct (FONT_MANAGER_TYPE_COLLECTION_STATE);
}

static void
font_manager_collection_state_class_init (FontManagerCollectionStateClass * klass,
                                          gpointer klass_data)
{
	font_manager_collection_state_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = font_manager_collection_state_finalize;
}

static void
font_manager_collection_state_instance_init (FontManagerCollectionState * self,
                                             gpointer klass)
{
	self->is_disabled = FALSE;
	self->partially_disabled = FALSE;
}

static void
font_manager_collection_state_finalize (GObject * obj)
{
	FontManagerCollectionState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_COLLECTION_STATE, FontManagerCollectionState);
	G_OBJECT_CLASS (font_manager_collection_state_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_collection_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerCollectionStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_collection_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerCollectionState), 0, (GInstanceInitFunc) font_manager_collection_state_instance_init, NULL };
	GType font_manager_collection_state_type_id;
	font_manager_collection_state_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerCollectionState", &g_define_type_info, 0);
	return font_manager_collection_state_type_id;
}

GType
font_manager_collection_state_get_type (void)
{
	static volatile gsize font_manager_collection_state_type_id__once = 0;
	if (g_once_init_enter (&font_manager_collection_state_type_id__once)) {
		GType font_manager_collection_state_type_id;
		font_manager_collection_state_type_id = font_manager_collection_state_get_type_once ();
		g_once_init_leave (&font_manager_collection_state_type_id__once, font_manager_collection_state_type_id);
	}
	return font_manager_collection_state_type_id__once;
}

static inline gpointer
font_manager_collection_get_instance_private (FontManagerCollection* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerCollection_private_offset);
}

FontManagerCollection*
font_manager_collection_construct (GType object_type,
                                   const gchar* name,
                                   const gchar* comment)
{
	FontManagerCollection * self = NULL;
	gchar* default_name = NULL;
	gchar* _tmp0_;
	gchar* default_comment = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp7_ = NULL;
	self = (FontManagerCollection*) font_manager_font_list_filter_construct (object_type);
	_tmp0_ = g_strdup (_ ("New Collection"));
	default_name = _tmp0_;
	_tmp1_ = font_manager_get_local_time ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Created : %s"), _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	default_comment = _tmp4_;
	if (name != NULL) {
		_tmp5_ = name;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = default_name;
		_tmp5_ = _tmp6_;
	}
	font_manager_font_list_filter_set_name ((FontManagerFontListFilter*) self, _tmp5_);
	if (comment != NULL) {
		_tmp7_ = comment;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = default_comment;
		_tmp7_ = _tmp8_;
	}
	font_manager_font_list_filter_set_comment ((FontManagerFontListFilter*) self, _tmp7_);
	_g_free0 (default_comment);
	_g_free0 (default_name);
	return self;
}

FontManagerCollection*
font_manager_collection_new (const gchar* name,
                             const gchar* comment)
{
	return font_manager_collection_construct (FONT_MANAGER_TYPE_COLLECTION, name, comment);
}

static void
__lambda46_ (FontManagerCollection* self,
             FontManagerCollection* child)
{
	g_return_if_fail (child != NULL);
	font_manager_collection_clear_children (child);
}

static void
___lambda46__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda46_ ((FontManagerCollection*) self, (FontManagerCollection*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

void
font_manager_collection_clear_children (FontManagerCollection* self)
{
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_children;
	g_ptr_array_foreach (_tmp0_, ___lambda46__gfunc, self);
	font_manager_collection_set_children (self, NULL);
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp2_ = _tmp1_;
	font_manager_collection_set_children (self, _tmp2_);
	_g_ptr_array_unref0 (_tmp2_);
	return;
}

void
font_manager_collection_remove (FontManagerCollection* self,
                                FontManagerStringSet* old_families)
{
	FontManagerStringSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_families != NULL);
	_tmp0_ = self->priv->_families;
	font_manager_string_set_remove_all (_tmp0_, old_families);
	return;
}

void
font_manager_collection_add (FontManagerCollection* self,
                             FontManagerStringSet* new_families)
{
	FontManagerStringSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_families != NULL);
	_tmp0_ = self->priv->_families;
	font_manager_string_set_add_all (_tmp0_, new_families);
	return;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

gboolean
font_manager_collection_contains (FontManagerCollection* self,
                                  FontManagerCollection* collection)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp13_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_children;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < ((guint) _tmp4_))) {
					break;
				}
				_tmp5_ = self->priv->_children;
				_tmp6_ = g_ptr_array_index (_tmp5_, i);
				_tmp7_ = font_manager_font_list_filter_get_name ((FontManagerFontListFilter*) ((FontManagerCollection*) _tmp6_));
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_;
				_tmp10_ = font_manager_font_list_filter_get_name ((FontManagerFontListFilter*) collection);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strcmp0 (_tmp9_, _tmp12_) == 0;
				_g_free0 (_tmp12_);
				_g_free0 (_tmp9_);
				if (_tmp13_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}

static void
font_manager_collection_on_state_update_complete (FontManagerCollection* self,
                                                  GObject* source,
                                                  GTask* task)
{
	GValue* val = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (task != NULL);
	val = NULL;
	{
		GValue _tmp0_ = {0};
		GValue _tmp1_;
		GValue _tmp2_;
		GValue* _tmp3_;
		FontManagerCollectionState* state = NULL;
		GValue* _tmp4_;
		GObject* _tmp5_;
		FontManagerCollectionState* _tmp6_;
		gboolean _tmp7_ = FALSE;
		FontManagerStringSet* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		g_task_propagate_value (task, &_tmp0_, &_inner_error0_);
		__vala_GValue_free0 (val);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = __g_value_dup0 (&_tmp2_);
		val = _tmp3_;
		G_IS_VALUE (&_tmp1_) ? (g_value_unset (&_tmp1_), NULL) : NULL;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = val;
		_tmp5_ = g_value_get_object (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FONT_MANAGER_TYPE_COLLECTION_STATE, FontManagerCollectionState));
		state = _tmp6_;
		self->priv->ignore_activation = TRUE;
		_tmp8_ = self->priv->_families;
		g_object_get (_tmp8_, "size", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		if (_tmp10_ != ((guint) 0)) {
			FontManagerCollectionState* _tmp11_;
			_tmp11_ = state;
			_tmp7_ = !_tmp11_->is_disabled;
		} else {
			_tmp7_ = FALSE;
		}
		font_manager_collection_set_active (self, _tmp7_);
		_tmp13_ = self->priv->_active;
		if (_tmp13_) {
			FontManagerCollectionState* _tmp14_;
			_tmp14_ = state;
			_tmp12_ = _tmp14_->partially_disabled;
		} else {
			_tmp12_ = FALSE;
		}
		font_manager_collection_set_inconsistent (self, _tmp12_);
		self->priv->ignore_activation = FALSE;
		_g_object_unref0 (state);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("Collection.vala:139: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		__vala_GValue_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	__vala_GValue_free0 (val);
	return;
}

static void
_font_manager_collection_on_state_update_complete_gasync_ready_callback (GObject* source_object,
                                                                         GTask* task,
                                                                         gpointer self)
{
	font_manager_collection_on_state_update_complete ((FontManagerCollection*) self, source_object, task);
	g_object_unref (self);
}

static void
_font_manager_collection_state_update_gtask_thread_func (GTask* task,
                                                         GObject* source_object,
                                                         void* task_data,
                                                         GCancellable* cancellable)
{
	font_manager_collection_state_update (task, source_object, task_data, cancellable);
}

static gboolean
font_manager_collection_update_state (FontManagerCollection* self)
{
	FontManagerReject* _tmp0_;
	GTask* task = NULL;
	GTask* _tmp1_;
	GTask* _tmp2_;
	GPtrArray* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_disabled_families;
	if (_tmp0_ == NULL) {
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp1_ = g_task_new ((GObject*) self, NULL, _font_manager_collection_on_state_update_complete_gasync_ready_callback, g_object_ref (self));
	task = _tmp1_;
	_tmp2_ = task;
	g_task_run_in_thread (_tmp2_, _font_manager_collection_state_update_gtask_thread_func);
	_tmp3_ = self->priv->_children;
	{
		GPtrArray* child_collection = NULL;
		guint child_index = 0U;
		child_collection = _tmp3_;
		for (child_index = 0; child_index < child_collection->len; child_index = child_index + 1) {
			FontManagerCollection* _tmp4_;
			FontManagerCollection* child = NULL;
			_tmp4_ = _g_object_ref0 ((FontManagerCollection*) g_ptr_array_index (child_collection, child_index));
			child = _tmp4_;
			{
				FontManagerCollection* _tmp5_;
				_tmp5_ = child;
				font_manager_collection_update_state (_tmp5_);
				_g_object_unref0 (child);
			}
		}
	}
	self->priv->state_change_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	_g_object_unref0 (task);
	return result;
}

static gboolean
_font_manager_collection_update_state_gsource_func (gpointer self)
{
	gboolean result;
	result = font_manager_collection_update_state ((FontManagerCollection*) self);
	return result;
}

void
font_manager_collection_queue_state_update (FontManagerCollection* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->state_change_timeout != ((guint) 0)) {
		g_source_remove (self->priv->state_change_timeout);
	}
	self->priv->state_change_timeout = g_timeout_add_full (G_PRIORITY_LOW, (guint) 500, _font_manager_collection_update_state_gsource_func, g_object_ref (self), g_object_unref);
	return;
}

void
font_manager_collection_on_state_toggled (GtkCheckButton* check,
                                          FontManagerCollection* self)
{
	gboolean _tmp0_ = FALSE;
	FontManagerReject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (check != NULL);
	_tmp1_ = self->priv->_disabled_families;
	if (_tmp1_ != NULL) {
		_tmp0_ = !self->priv->ignore_activation;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		FontManagerReject* _tmp8_;
		_tmp2_ = gtk_check_button_get_active (check);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			FontManagerReject* _tmp4_;
			FontManagerStringSet* _tmp5_;
			_tmp4_ = self->priv->_disabled_families;
			_tmp5_ = self->priv->_families;
			font_manager_string_set_remove_all ((FontManagerStringSet*) _tmp4_, _tmp5_);
		} else {
			FontManagerReject* _tmp6_;
			FontManagerStringSet* _tmp7_;
			_tmp6_ = self->priv->_disabled_families;
			_tmp7_ = self->priv->_families;
			font_manager_string_set_add_all ((FontManagerStringSet*) _tmp6_, _tmp7_);
		}
		_tmp8_ = self->priv->_disabled_families;
		font_manager_selections_save ((FontManagerSelections*) _tmp8_);
		font_manager_collection_queue_state_update (self);
	}
	return;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		FontManagerCollection* self;
		self = _data19_->self;
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static void
__lambda47_ (Block19Data* _data19_,
             FontManagerCollection* child)
{
	FontManagerCollection* self;
	self = _data19_->self;
	g_return_if_fail (child != NULL);
	_data19_->total += font_manager_collection_get_collection_total (child);
}

static void
___lambda47__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda47_ (self, (FontManagerCollection*) data);
}

static gint
font_manager_collection_get_collection_total (FontManagerCollection* self)
{
	Block19Data* _data19_;
	FontManagerStringSet* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	FontManagerStringSet* _tmp3_;
	GPtrArray* _tmp16_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_tmp0_ = self->priv->_families;
	g_object_get (_tmp0_, "size", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_data19_->total = (gint) _tmp2_;
	_tmp3_ = self->priv->_available_families;
	if (_tmp3_ != NULL) {
		{
			FontManagerStringSet* _family_list = NULL;
			FontManagerStringSet* _tmp4_;
			guint _family_size = 0U;
			FontManagerStringSet* _tmp5_;
			guint _tmp6_;
			guint _tmp7_;
			gint _family_index = 0;
			_tmp4_ = self->priv->_families;
			_family_list = _tmp4_;
			_tmp5_ = _family_list;
			g_object_get (_tmp5_, "size", &_tmp6_, NULL);
			_tmp7_ = _tmp6_;
			_family_size = _tmp7_;
			_family_index = -1;
			while (TRUE) {
				gint _tmp8_;
				guint _tmp9_;
				gchar* family = NULL;
				FontManagerStringSet* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				FontManagerStringSet* _tmp13_;
				const gchar* _tmp14_;
				_family_index = _family_index + 1;
				_tmp8_ = _family_index;
				_tmp9_ = _family_size;
				if (!(((guint) _tmp8_) < _tmp9_)) {
					break;
				}
				_tmp10_ = _family_list;
				_tmp11_ = font_manager_string_set_get (_tmp10_, (guint) _family_index);
				_tmp12_ = g_strdup (_tmp11_);
				family = _tmp12_;
				_tmp13_ = self->priv->_available_families;
				_tmp14_ = family;
				if (!font_manager_string_set_contains (_tmp13_, _tmp14_)) {
					gint _tmp15_;
					_tmp15_ = _data19_->total;
					_data19_->total = _tmp15_ - 1;
				}
				_g_free0 (family);
			}
		}
	}
	_tmp16_ = self->priv->_children;
	g_ptr_array_foreach (_tmp16_, ___lambda47__gfunc, _data19_);
	result = _data19_->total;
	block19_data_unref (_data19_);
	_data19_ = NULL;
	return result;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		FontManagerCollection* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->full_contents);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static void
__lambda48_ (Block20Data* _data20_,
             FontManagerCollection* _child)
{
	FontManagerCollection* self;
	self = _data20_->self;
	g_return_if_fail (_child != NULL);
	font_manager_collection_add_child_contents (self, _child, _data20_->full_contents);
}

static void
___lambda48__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda48_ (self, (FontManagerCollection*) data);
}

static void
font_manager_collection_add_child_contents (FontManagerCollection* self,
                                            FontManagerCollection* child,
                                            FontManagerStringSet* full_contents)
{
	Block20Data* _data20_;
	FontManagerStringSet* _tmp0_;
	FontManagerStringSet* _tmp1_;
	GPtrArray* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	g_return_if_fail (full_contents != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (full_contents);
	_g_object_unref0 (_data20_->full_contents);
	_data20_->full_contents = _tmp0_;
	_tmp1_ = child->priv->_families;
	font_manager_string_set_add_all (_data20_->full_contents, _tmp1_);
	_tmp2_ = child->priv->_children;
	g_ptr_array_foreach (_tmp2_, ___lambda48__gfunc, _data20_);
	block20_data_unref (_data20_);
	_data20_ = NULL;
	return;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		FontManagerCollection* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->full_contents);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static void
__lambda49_ (Block21Data* _data21_,
             FontManagerCollection* _child)
{
	FontManagerCollection* self;
	self = _data21_->self;
	g_return_if_fail (_child != NULL);
	font_manager_collection_add_child_contents (self, _child, _data21_->full_contents);
}

static void
___lambda49__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda49_ (self, (FontManagerCollection*) data);
}

FontManagerStringSet*
font_manager_collection_get_full_contents (FontManagerCollection* self)
{
	Block21Data* _data21_;
	FontManagerStringSet* _tmp0_;
	FontManagerStringSet* _tmp1_;
	GPtrArray* _tmp2_;
	FontManagerStringSet* _tmp3_;
	FontManagerStringSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = font_manager_string_set_new ();
	_data21_->full_contents = _tmp0_;
	_tmp1_ = self->priv->_families;
	font_manager_string_set_add_all (_data21_->full_contents, _tmp1_);
	_tmp2_ = self->priv->_children;
	g_ptr_array_foreach (_tmp2_, ___lambda49__gfunc, _data21_);
	_tmp3_ = _g_object_ref0 (_data21_->full_contents);
	result = _tmp3_;
	block21_data_unref (_data21_);
	_data21_ = NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

FontManagerStringSet*
font_manager_collection_get_filelist (FontManagerCollection* self)
{
	FontManagerStringSet* results = NULL;
	FontManagerStringSet* _tmp0_;
	GError* _inner_error0_ = NULL;
	FontManagerStringSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = font_manager_string_set_new ();
	results = _tmp0_;
	{
		FontManagerDatabase* db = NULL;
		FontManagerDatabase* _tmp1_;
		FontManagerStringSet* contents = NULL;
		FontManagerStringSet* _tmp2_;
		_tmp1_ = font_manager_database_proxy_get_default_db ();
		db = _tmp1_;
		_tmp2_ = font_manager_collection_get_full_contents (self);
		contents = _tmp2_;
		{
			FontManagerStringSet* _family_list = NULL;
			FontManagerStringSet* _tmp3_;
			guint _family_size = 0U;
			FontManagerStringSet* _tmp4_;
			guint _tmp5_;
			guint _tmp6_;
			gint _family_index = 0;
			_tmp3_ = contents;
			_family_list = _tmp3_;
			_tmp4_ = _family_list;
			g_object_get (_tmp4_, "size", &_tmp5_, NULL);
			_tmp6_ = _tmp5_;
			_family_size = _tmp6_;
			_family_index = -1;
			while (TRUE) {
				gint _tmp7_;
				guint _tmp8_;
				gchar* family = NULL;
				FontManagerStringSet* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				FontManagerDatabase* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				FontManagerDatabase* _tmp27_;
				_family_index = _family_index + 1;
				_tmp7_ = _family_index;
				_tmp8_ = _family_size;
				if (!(((guint) _tmp7_) < _tmp8_)) {
					break;
				}
				_tmp9_ = _family_list;
				_tmp10_ = font_manager_string_set_get (_tmp9_, (guint) _family_index);
				_tmp11_ = g_strdup (_tmp10_);
				family = _tmp11_;
				_tmp12_ = family;
				_tmp13_ = string_replace (_tmp12_, "'", "''");
				_g_free0 (family);
				family = _tmp13_;
				_tmp14_ = db;
				_tmp15_ = family;
				_tmp16_ = string_to_string (_tmp15_);
				_tmp17_ = g_strconcat ("SELECT filepath FROM Fonts WHERE family = '", _tmp16_, "'", NULL);
				_tmp18_ = _tmp17_;
				font_manager_database_execute_query (_tmp14_, _tmp18_, &_inner_error0_);
				_g_free0 (_tmp18_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (family);
					_g_object_unref0 (contents);
					_g_object_unref0 (db);
					goto __catch0_g_error;
				}
				{
					FontManagerDatabaseIterator* _row_it = NULL;
					FontManagerDatabase* _tmp19_;
					FontManagerDatabaseIterator* _tmp20_;
					_tmp19_ = db;
					_tmp20_ = font_manager_database_iterator (_tmp19_);
					_row_it = _tmp20_;
					while (TRUE) {
						FontManagerDatabaseIterator* _tmp21_;
						sqlite3_stmt* row = NULL;
						FontManagerDatabaseIterator* _tmp22_;
						sqlite3_stmt* _tmp23_;
						FontManagerStringSet* _tmp24_;
						sqlite3_stmt* _tmp25_;
						const gchar* _tmp26_;
						_tmp21_ = _row_it;
						if (!font_manager_database_iterator_next (_tmp21_)) {
							break;
						}
						_tmp22_ = _row_it;
						_tmp23_ = font_manager_database_iterator_get (_tmp22_);
						row = _tmp23_;
						_tmp24_ = results;
						_tmp25_ = row;
						_tmp26_ = (const gchar*) sqlite3_column_text (_tmp25_, 0);
						font_manager_string_set_add (_tmp24_, _tmp26_);
					}
					_g_object_unref0 (_row_it);
				}
				_tmp27_ = db;
				font_manager_database_end_query (_tmp27_);
				_g_free0 (family);
			}
		}
		_g_object_unref0 (contents);
		_g_object_unref0 (db);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("Collection.vala:212: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (results);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = results;
	return result;
}

static gboolean
font_manager_collection_real_matches (FontManagerFontListFilter* base,
                                      GObject* item)
{
	FontManagerCollection * self;
	gboolean visible = FALSE;
	gchar* family = NULL;
	gchar* _tmp0_ = NULL;
	FontManagerStringSet* _tmp1_;
	FontManagerStringSet* _tmp2_;
	gboolean result;
	self = (FontManagerCollection*) base;
	visible = FALSE;
	g_object_get (item, "family", &_tmp0_, NULL, NULL);
	_g_free0 (family);
	family = _tmp0_;
	_tmp1_ = font_manager_collection_get_full_contents (self);
	_tmp2_ = _tmp1_;
	visible = font_manager_string_set_contains (_tmp2_, family);
	_g_object_unref0 (_tmp2_);
	result = visible;
	_g_free0 (family);
	return result;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		FontManagerCollection* self;
		self = _data22_->self;
		_g_ptr_array_unref0 (_data22_->res);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
___lambda50_ (Block22Data* _data22_,
              JsonObject* obj,
              const gchar* name,
              JsonNode* node)
{
	FontManagerCollection* self;
	GObject* child = NULL;
	GObject* _tmp0_;
	GPtrArray* _tmp1_;
	FontManagerCollection* _tmp2_;
	self = _data22_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = json_gobject_deserialize (FONT_MANAGER_TYPE_COLLECTION, node);
	child = _tmp0_;
	_tmp1_ = _data22_->res;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child, FONT_MANAGER_TYPE_COLLECTION, FontManagerCollection));
	g_ptr_array_add (_tmp1_, _tmp2_);
	_g_object_unref0 (child);
}

static void
____lambda50__json_object_foreach (JsonObject* object,
                                   const gchar* member_name,
                                   JsonNode* member_node,
                                   gpointer self)
{
	___lambda50_ (self, object, member_name, member_node);
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		FontManagerCollection* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->res);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
____lambda51_ (Block23Data* _data23_,
               JsonArray* arr,
               guint index,
               JsonNode* node)
{
	FontManagerCollection* self;
	FontManagerStringSet* _tmp0_;
	const gchar* _tmp1_;
	self = _data23_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _data23_->res;
	_tmp1_ = json_node_get_string (node);
	font_manager_string_set_add (_tmp0_, _tmp1_);
}

static void
_____lambda51__json_array_foreach (JsonArray* array,
                                   guint index_,
                                   JsonNode* element_node,
                                   gpointer self)
{
	____lambda51_ (self, array, index_, element_node);
}

static gboolean
font_manager_collection_real_deserialize_property (FontManagerCacheable* base,
                                                   const gchar* prop_name,
                                                   GValue* val,
                                                   GParamSpec* pspec,
                                                   JsonNode* node)
{
	FontManagerCollection * self;
	GValue _vala_val = {0};
	GValue _tmp0_ = {0};
	gboolean result;
	self = (FontManagerCollection*) base;
	g_return_val_if_fail (prop_name != NULL, FALSE);
	g_return_val_if_fail (pspec != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	g_value_init (&_tmp0_, pspec->value_type);
	G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	_vala_val = _tmp0_;
	if (pspec->value_type == G_TYPE_PTR_ARRAY) {
		Block22Data* _data22_;
		GPtrArray* _tmp1_;
		JsonObject* _tmp2_;
		GPtrArray* _tmp3_;
		_data22_ = g_slice_new0 (Block22Data);
		_data22_->_ref_count_ = 1;
		_data22_->self = g_object_ref (self);
		_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		_data22_->res = _tmp1_;
		_tmp2_ = json_node_get_object (node);
		json_object_foreach_member (_tmp2_, ____lambda50__json_object_foreach, _data22_);
		_tmp3_ = _data22_->res;
		g_value_set_boxed (&_vala_val, _tmp3_);
		result = TRUE;
		block22_data_unref (_data22_);
		_data22_ = NULL;
		if (val) {
			*val = _vala_val;
		} else {
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
		}
		return result;
	} else {
		if (pspec->value_type == font_manager_string_set_get_type ()) {
			Block23Data* _data23_;
			FontManagerStringSet* _tmp4_;
			JsonArray* _tmp5_;
			FontManagerStringSet* _tmp6_;
			_data23_ = g_slice_new0 (Block23Data);
			_data23_->_ref_count_ = 1;
			_data23_->self = g_object_ref (self);
			_tmp4_ = font_manager_string_set_new ();
			_data23_->res = _tmp4_;
			_tmp5_ = json_node_get_array (node);
			json_array_foreach_element (_tmp5_, _____lambda51__json_array_foreach, _data23_);
			_tmp6_ = _data23_->res;
			g_value_set_object (&_vala_val, (GObject*) _tmp6_);
			result = TRUE;
			block23_data_unref (_data23_);
			_data23_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			}
			return result;
		} else {
			if (pspec->value_type == font_manager_reject_get_type ()) {
				FontManagerReject* res = NULL;
				FontManagerReject* _tmp7_;
				FontManagerReject* _tmp8_;
				_tmp7_ = font_manager_reject_new ();
				res = _tmp7_;
				_tmp8_ = res;
				g_value_set_object (&_vala_val, (GObject*) _tmp8_);
				result = TRUE;
				_g_object_unref0 (res);
				if (val) {
					*val = _vala_val;
				} else {
					G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
				}
				return result;
			} else {
				GValue _tmp9_ = {0};
				gboolean _tmp10_;
				_tmp10_ = FONT_MANAGER_CACHEABLE_CLASS (font_manager_collection_parent_class)->deserialize_property ((FontManagerCacheable*) G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter), prop_name, &_tmp9_, pspec, node);
				G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
				_vala_val = _tmp9_;
				result = _tmp10_;
				if (val) {
					*val = _vala_val;
				} else {
					G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
				}
				return result;
			}
		}
	}
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		FontManagerCollection* self;
		self = _data24_->self;
		_json_object_unref0 (_data24_->obj);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
___lambda52_ (Block24Data* _data24_,
              FontManagerCollection* child)
{
	FontManagerCollection* self;
	JsonObject* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	JsonNode* _tmp6_;
	self = _data24_->self;
	g_return_if_fail (child != NULL);
	_tmp0_ = _data24_->obj;
	_tmp1_ = font_manager_font_list_filter_get_name ((FontManagerFontListFilter*) child);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strescape (_tmp3_, "");
	_tmp5_ = _tmp4_;
	_tmp6_ = json_gobject_serialize ((GObject*) child);
	json_object_set_member (_tmp0_, _tmp5_, _tmp6_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}

static void
____lambda52__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda52_ (self, (FontManagerCollection*) data);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static JsonNode*
font_manager_collection_real_serialize_property (FontManagerCacheable* base,
                                                 const gchar* prop_name,
                                                 GValue* val,
                                                 GParamSpec* pspec)
{
	FontManagerCollection * self;
	JsonNode* result;
	self = (FontManagerCollection*) base;
	g_return_val_if_fail (prop_name != NULL, NULL);
	g_return_val_if_fail (val != NULL, NULL);
	g_return_val_if_fail (pspec != NULL, NULL);
	if (pspec->value_type == G_TYPE_PTR_ARRAY) {
		Block24Data* _data24_;
		JsonNode* node = NULL;
		JsonNode* _tmp0_;
		JsonObject* _tmp1_;
		GPtrArray* _tmp2_;
		JsonNode* _tmp3_;
		JsonObject* _tmp4_;
		_data24_ = g_slice_new0 (Block24Data);
		_data24_->_ref_count_ = 1;
		_data24_->self = g_object_ref (self);
		_tmp0_ = json_node_new (JSON_NODE_OBJECT);
		node = _tmp0_;
		_tmp1_ = json_object_new ();
		_data24_->obj = _tmp1_;
		_tmp2_ = self->priv->_children;
		g_ptr_array_foreach (_tmp2_, ____lambda52__gfunc, _data24_);
		_tmp3_ = node;
		_tmp4_ = _data24_->obj;
		json_node_set_object (_tmp3_, _tmp4_);
		result = node;
		block24_data_unref (_data24_);
		_data24_ = NULL;
		return result;
	} else {
		if (pspec->value_type == font_manager_string_set_get_type ()) {
			JsonNode* node = NULL;
			JsonNode* _tmp5_;
			JsonArray* arr = NULL;
			JsonArray* _tmp6_;
			JsonNode* _tmp18_;
			JsonArray* _tmp19_;
			_tmp5_ = json_node_new (JSON_NODE_ARRAY);
			node = _tmp5_;
			_tmp6_ = json_array_new ();
			arr = _tmp6_;
			if (g_strcmp0 (prop_name, "families") == 0) {
				{
					FontManagerStringSet* _family_list = NULL;
					FontManagerStringSet* _tmp7_;
					guint _family_size = 0U;
					FontManagerStringSet* _tmp8_;
					guint _tmp9_;
					guint _tmp10_;
					gint _family_index = 0;
					_tmp7_ = self->priv->_families;
					_family_list = _tmp7_;
					_tmp8_ = _family_list;
					g_object_get (_tmp8_, "size", &_tmp9_, NULL);
					_tmp10_ = _tmp9_;
					_family_size = _tmp10_;
					_family_index = -1;
					while (TRUE) {
						gint _tmp11_;
						guint _tmp12_;
						gchar* family = NULL;
						FontManagerStringSet* _tmp13_;
						const gchar* _tmp14_;
						gchar* _tmp15_;
						JsonArray* _tmp16_;
						const gchar* _tmp17_;
						_family_index = _family_index + 1;
						_tmp11_ = _family_index;
						_tmp12_ = _family_size;
						if (!(((guint) _tmp11_) < _tmp12_)) {
							break;
						}
						_tmp13_ = _family_list;
						_tmp14_ = font_manager_string_set_get (_tmp13_, (guint) _family_index);
						_tmp15_ = g_strdup (_tmp14_);
						family = _tmp15_;
						_tmp16_ = arr;
						_tmp17_ = family;
						json_array_add_string_element (_tmp16_, _tmp17_);
						_g_free0 (family);
					}
				}
			}
			_tmp18_ = node;
			_tmp19_ = arr;
			json_node_set_array (_tmp18_, _tmp19_);
			result = node;
			_json_array_unref0 (arr);
			return result;
		} else {
			if (pspec->value_type == font_manager_reject_get_type ()) {
				JsonNode* node = NULL;
				JsonNode* _tmp20_;
				JsonArray* arr = NULL;
				JsonArray* _tmp21_;
				JsonNode* _tmp22_;
				JsonArray* _tmp23_;
				_tmp20_ = json_node_new (JSON_NODE_ARRAY);
				node = _tmp20_;
				_tmp21_ = json_array_new ();
				arr = _tmp21_;
				_tmp22_ = node;
				_tmp23_ = arr;
				json_node_set_array (_tmp22_, _tmp23_);
				result = node;
				_json_array_unref0 (arr);
				return result;
			} else {
				GValue _tmp24_;
				JsonNode* _tmp25_;
				_tmp24_ = *val;
				_tmp25_ = FONT_MANAGER_CACHEABLE_CLASS (font_manager_collection_parent_class)->serialize_property ((FontManagerCacheable*) G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_FONT_LIST_FILTER, FontManagerFontListFilter), prop_name, &_tmp24_, pspec);
				result = _tmp25_;
				return result;
			}
		}
	}
}

FontManagerStringSet*
font_manager_collection_get_available_families (FontManagerCollection* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_available_families;
	result = _tmp0_;
	return result;
}

void
font_manager_collection_set_available_families (FontManagerCollection* self,
                                                FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_collection_get_available_families (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_available_families);
		self->priv->_available_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_collection_properties[FONT_MANAGER_COLLECTION_AVAILABLE_FAMILIES_PROPERTY]);
	}
}

FontManagerReject*
font_manager_collection_get_disabled_families (FontManagerCollection* self)
{
	FontManagerReject* result;
	FontManagerReject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disabled_families;
	result = _tmp0_;
	return result;
}

void
font_manager_collection_set_disabled_families (FontManagerCollection* self,
                                               FontManagerReject* value)
{
	FontManagerReject* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_collection_get_disabled_families (self);
	if (old_value != value) {
		FontManagerReject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_disabled_families);
		self->priv->_disabled_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_collection_properties[FONT_MANAGER_COLLECTION_DISABLED_FAMILIES_PROPERTY]);
	}
}

gboolean
font_manager_collection_get_active (FontManagerCollection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
font_manager_collection_set_active (FontManagerCollection* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_collection_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_collection_properties[FONT_MANAGER_COLLECTION_ACTIVE_PROPERTY]);
	}
}

gboolean
font_manager_collection_get_inconsistent (FontManagerCollection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_inconsistent;
	return result;
}

void
font_manager_collection_set_inconsistent (FontManagerCollection* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_collection_get_inconsistent (self);
	if (old_value != value) {
		self->priv->_inconsistent = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_collection_properties[FONT_MANAGER_COLLECTION_INCONSISTENT_PROPERTY]);
	}
}

GPtrArray*
font_manager_collection_get_children (FontManagerCollection* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_children;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

void
font_manager_collection_set_children (FontManagerCollection* self,
                                      GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_collection_get_children (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_children);
		self->priv->_children = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_collection_properties[FONT_MANAGER_COLLECTION_CHILDREN_PROPERTY]);
	}
}

FontManagerStringSet*
font_manager_collection_get_families (FontManagerCollection* self)
{
	FontManagerStringSet* result;
	FontManagerStringSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_families;
	result = _tmp0_;
	return result;
}

void
font_manager_collection_set_families (FontManagerCollection* self,
                                      FontManagerStringSet* value)
{
	FontManagerStringSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_collection_get_families (self);
	if (old_value != value) {
		FontManagerStringSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_families);
		self->priv->_families = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_collection_properties[FONT_MANAGER_COLLECTION_FAMILIES_PROPERTY]);
	}
}

static gint
font_manager_collection_real_get_size (FontManagerFontListFilter* base)
{
	gint result;
	FontManagerCollection* self;
	self = (FontManagerCollection*) base;
	result = font_manager_collection_get_collection_total (self);
	return result;
}

static void
_font_manager_collection___lambda53_ (FontManagerCollection* self)
{
	GPtrArray* _tmp0_;
	_tmp0_ = self->priv->_children;
	{
		GPtrArray* child_collection = NULL;
		guint child_index = 0U;
		child_collection = _tmp0_;
		for (child_index = 0; child_index < child_collection->len; child_index = child_index + 1) {
			FontManagerCollection* _tmp1_;
			FontManagerCollection* child = NULL;
			_tmp1_ = _g_object_ref0 ((FontManagerCollection*) g_ptr_array_index (child_collection, child_index));
			child = _tmp1_;
			{
				GBindingFlags flags = 0U;
				FontManagerCollection* _tmp2_;
				flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
				_tmp2_ = child;
				g_object_bind_property_with_closures ((GObject*) self, "available-families", (GObject*) _tmp2_, "available-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				_g_object_unref0 (child);
			}
		}
	}
}

static void
__font_manager_collection___lambda53__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_font_manager_collection___lambda53_ ((FontManagerCollection*) self);
}

static void
_font_manager_collection_queue_state_update_font_manager_string_set_changed (FontManagerStringSet* _sender,
                                                                             gpointer self)
{
	font_manager_collection_queue_state_update ((FontManagerCollection*) self);
}

static void
_font_manager_collection___lambda54_ (FontManagerCollection* self)
{
	GPtrArray* _tmp0_;
	FontManagerReject* _tmp3_;
	_tmp0_ = self->priv->_children;
	{
		GPtrArray* child_collection = NULL;
		guint child_index = 0U;
		child_collection = _tmp0_;
		for (child_index = 0; child_index < child_collection->len; child_index = child_index + 1) {
			FontManagerCollection* _tmp1_;
			FontManagerCollection* child = NULL;
			_tmp1_ = _g_object_ref0 ((FontManagerCollection*) g_ptr_array_index (child_collection, child_index));
			child = _tmp1_;
			{
				GBindingFlags flags = 0U;
				FontManagerCollection* _tmp2_;
				flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
				_tmp2_ = child;
				g_object_bind_property_with_closures ((GObject*) self, "disabled-families", (GObject*) _tmp2_, "disabled-families", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				_g_object_unref0 (child);
			}
		}
	}
	_tmp3_ = self->priv->_disabled_families;
	if (_tmp3_ != NULL) {
		FontManagerReject* _tmp4_;
		font_manager_collection_queue_state_update (self);
		_tmp4_ = self->priv->_disabled_families;
		g_signal_connect_object ((FontManagerStringSet*) _tmp4_, "changed", (GCallback) _font_manager_collection_queue_state_update_font_manager_string_set_changed, self, G_CONNECT_AFTER);
	}
}

static void
__font_manager_collection___lambda54__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_font_manager_collection___lambda54_ ((FontManagerCollection*) self);
}

static GObject *
font_manager_collection_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerCollection * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	FontManagerStringSet* _tmp2_;
	FontManagerStringSet* _tmp3_;
	parent_class = G_OBJECT_CLASS (font_manager_collection_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_COLLECTION, FontManagerCollection);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	font_manager_collection_set_children (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	_tmp2_ = font_manager_string_set_new ();
	_tmp3_ = _tmp2_;
	font_manager_collection_set_families (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_signal_connect_object ((GObject*) self, "notify::available-families", (GCallback) __font_manager_collection___lambda53__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::disabled-families", (GCallback) __font_manager_collection___lambda54__g_object_notify, self, G_CONNECT_AFTER);
	return obj;
}

static void
font_manager_collection_class_init (FontManagerCollectionClass * klass,
                                    gpointer klass_data)
{
	font_manager_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerCollection_private_offset);
	((FontManagerFontListFilterClass *) klass)->matches = (gboolean (*) (FontManagerFontListFilter*, GObject*)) font_manager_collection_real_matches;
	((FontManagerCacheableClass *) klass)->deserialize_property = (gboolean (*) (FontManagerCacheable*, const gchar*, GValue*, GParamSpec*, JsonNode*)) font_manager_collection_real_deserialize_property;
	((FontManagerCacheableClass *) klass)->serialize_property = (JsonNode* (*) (FontManagerCacheable*, const gchar*, GValue*, GParamSpec*)) font_manager_collection_real_serialize_property;
	FONT_MANAGER_FONT_LIST_FILTER_CLASS (klass)->get_size = (gint (*) (FontManagerFontListFilter*)) font_manager_collection_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_collection_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_collection_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_COLLECTION_AVAILABLE_FAMILIES_PROPERTY, font_manager_collection_properties[FONT_MANAGER_COLLECTION_AVAILABLE_FAMILIES_PROPERTY] = g_param_spec_object ("available-families", "available-families", "available-families", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_COLLECTION_DISABLED_FAMILIES_PROPERTY, font_manager_collection_properties[FONT_MANAGER_COLLECTION_DISABLED_FAMILIES_PROPERTY] = g_param_spec_object ("disabled-families", "disabled-families", "disabled-families", font_manager_reject_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_COLLECTION_ACTIVE_PROPERTY, font_manager_collection_properties[FONT_MANAGER_COLLECTION_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_COLLECTION_INCONSISTENT_PROPERTY, font_manager_collection_properties[FONT_MANAGER_COLLECTION_INCONSISTENT_PROPERTY] = g_param_spec_boolean ("inconsistent", "inconsistent", "inconsistent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_COLLECTION_CHILDREN_PROPERTY, font_manager_collection_properties[FONT_MANAGER_COLLECTION_CHILDREN_PROPERTY] = g_param_spec_boxed ("children", "children", "children", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_COLLECTION_FAMILIES_PROPERTY, font_manager_collection_properties[FONT_MANAGER_COLLECTION_FAMILIES_PROPERTY] = g_param_spec_object ("families", "families", "families", font_manager_string_set_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_COLLECTION_SIZE_PROPERTY, font_manager_collection_properties[FONT_MANAGER_COLLECTION_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_collection_instance_init (FontManagerCollection * self,
                                       gpointer klass)
{
	self->priv = font_manager_collection_get_instance_private (self);
	self->priv->_available_families = NULL;
	self->priv->_disabled_families = NULL;
	self->priv->_active = TRUE;
	self->priv->_inconsistent = FALSE;
	self->priv->state_change_timeout = (guint) 0;
	self->priv->ignore_activation = FALSE;
}

static void
font_manager_collection_finalize (GObject * obj)
{
	FontManagerCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_COLLECTION, FontManagerCollection);
	_g_object_unref0 (self->priv->_available_families);
	_g_object_unref0 (self->priv->_disabled_families);
	_g_ptr_array_unref0 (self->priv->_children);
	_g_object_unref0 (self->priv->_families);
	G_OBJECT_CLASS (font_manager_collection_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerCollection), 0, (GInstanceInitFunc) font_manager_collection_instance_init, NULL };
	GType font_manager_collection_type_id;
	font_manager_collection_type_id = g_type_register_static (FONT_MANAGER_TYPE_FONT_LIST_FILTER, "FontManagerCollection", &g_define_type_info, 0);
	FontManagerCollection_private_offset = g_type_add_instance_private (font_manager_collection_type_id, sizeof (FontManagerCollectionPrivate));
	return font_manager_collection_type_id;
}

GType
font_manager_collection_get_type (void)
{
	static volatile gsize font_manager_collection_type_id__once = 0;
	if (g_once_init_enter (&font_manager_collection_type_id__once)) {
		GType font_manager_collection_type_id;
		font_manager_collection_type_id = font_manager_collection_get_type_once ();
		g_once_init_leave (&font_manager_collection_type_id__once, font_manager_collection_type_id);
	}
	return font_manager_collection_type_id__once;
}

static void
_vala_font_manager_collection_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	FontManagerCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_COLLECTION, FontManagerCollection);
	switch (property_id) {
		case FONT_MANAGER_COLLECTION_AVAILABLE_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_collection_get_available_families (self));
		break;
		case FONT_MANAGER_COLLECTION_DISABLED_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_collection_get_disabled_families (self));
		break;
		case FONT_MANAGER_COLLECTION_ACTIVE_PROPERTY:
		g_value_set_boolean (value, font_manager_collection_get_active (self));
		break;
		case FONT_MANAGER_COLLECTION_INCONSISTENT_PROPERTY:
		g_value_set_boolean (value, font_manager_collection_get_inconsistent (self));
		break;
		case FONT_MANAGER_COLLECTION_CHILDREN_PROPERTY:
		g_value_set_boxed (value, font_manager_collection_get_children (self));
		break;
		case FONT_MANAGER_COLLECTION_FAMILIES_PROPERTY:
		g_value_set_object (value, font_manager_collection_get_families (self));
		break;
		case FONT_MANAGER_COLLECTION_SIZE_PROPERTY:
		g_value_set_int (value, font_manager_font_list_filter_get_size ((FontManagerFontListFilter*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_collection_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	FontManagerCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_COLLECTION, FontManagerCollection);
	switch (property_id) {
		case FONT_MANAGER_COLLECTION_AVAILABLE_FAMILIES_PROPERTY:
		font_manager_collection_set_available_families (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_COLLECTION_DISABLED_FAMILIES_PROPERTY:
		font_manager_collection_set_disabled_families (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_COLLECTION_ACTIVE_PROPERTY:
		font_manager_collection_set_active (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_COLLECTION_INCONSISTENT_PROPERTY:
		font_manager_collection_set_inconsistent (self, g_value_get_boolean (value));
		break;
		case FONT_MANAGER_COLLECTION_CHILDREN_PROPERTY:
		font_manager_collection_set_children (self, g_value_get_boxed (value));
		break;
		case FONT_MANAGER_COLLECTION_FAMILIES_PROPERTY:
		font_manager_collection_set_families (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

