/* column.c generated by valac 0.56.18, the Vala compiler
 * generated from column.vala, do not modify */

#include "qlite.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _qlite_table_unref0(var) ((var == NULL) ? NULL : (var = (qlite_table_unref (var), NULL)))
typedef struct _QliteParamSpecColumn QliteParamSpecColumn;

struct _QliteColumnPrivate {
	GType t_type;
	GBoxedCopyFunc t_dup_func;
	GDestroyNotify t_destroy_func;
	gchar* _name;
	gchar* _default;
	gint _sqlite_type;
	gboolean _primary_key;
	gboolean _auto_increment;
	gboolean _unique;
	gboolean _not_null;
	glong _min_version;
	glong _max_version;
	QliteTable* _table;
};

struct _QliteParamSpecColumn {
	GParamSpec parent_instance;
};

static gint QliteColumn_private_offset;
static gpointer qlite_column_parent_class = NULL;
static gpointer qlite_column_integer_parent_class = NULL;
static gpointer qlite_column_long_parent_class = NULL;
static gpointer qlite_column_nullable_real_parent_class = NULL;
static gpointer qlite_column_text_parent_class = NULL;
static gpointer qlite_column_non_null_text_parent_class = NULL;
static gpointer qlite_column_bool_text_parent_class = NULL;
static gpointer qlite_column_bool_int_parent_class = NULL;

VALA_EXTERN void qlite_column_bind (QliteColumn* self,
                        sqlite3_stmt* stmt,
                        gint index,
                        gconstpointer value);
static gpointer qlite_column_real_get (QliteColumn* self,
                                QliteRow* row,
                                const gchar* table_name);
static gboolean qlite_column_real_is_null (QliteColumn* self,
                                    QliteRow* row,
                                    const gchar* table_name);
static void qlite_column_real_bind (QliteColumn* self,
                             sqlite3_stmt* stmt,
                             gint index,
                             gconstpointer value);
VALA_EXTERN QliteTable* qlite_column_get_table (QliteColumn* self);
static QliteColumn* qlite_column_construct (GType object_type,
                                     GType t_type,
                                     GBoxedCopyFunc t_dup_func,
                                     GDestroyNotify t_destroy_func,
                                     const gchar* name,
                                     gint type);
static void qlite_column_set_name (QliteColumn* self,
                            const gchar* value);
static void qlite_column_set_sqlite_type (QliteColumn* self,
                                   gint value);
VALA_EXTERN void qlite_column_set_table (QliteColumn* self,
                             QliteTable* value);
static gint qlite_column_integer_real_get (QliteColumn* base,
                                    QliteRow* row,
                                    const gchar* table_name);
static gboolean qlite_column_integer_real_is_null (QliteColumn* base,
                                            QliteRow* row,
                                            const gchar* table_name);
static void qlite_column_integer_real_bind (QliteColumn* base,
                                     sqlite3_stmt* stmt,
                                     gint index,
                                     gint value);
static GType qlite_column_integer_get_type_once (void);
static glong qlite_column_long_real_get (QliteColumn* base,
                                  QliteRow* row,
                                  const gchar* table_name);
static gboolean qlite_column_long_real_is_null (QliteColumn* base,
                                         QliteRow* row,
                                         const gchar* table_name);
static void qlite_column_long_real_bind (QliteColumn* base,
                                  sqlite3_stmt* stmt,
                                  gint index,
                                  glong value);
static GType qlite_column_long_get_type_once (void);
static gdouble* _double_dup (gdouble* self);
static gdouble* qlite_column_nullable_real_real_get (QliteColumn* base,
                                              QliteRow* row,
                                              const gchar* table_name);
static gboolean qlite_column_nullable_real_real_is_null (QliteColumn* base,
                                                  QliteRow* row,
                                                  const gchar* table_name);
static void qlite_column_nullable_real_real_bind (QliteColumn* base,
                                           sqlite3_stmt* stmt,
                                           gint index,
                                           gdouble* value);
static GType qlite_column_nullable_real_get_type_once (void);
static gchar* qlite_column_text_real_get (QliteColumn* base,
                                   QliteRow* row,
                                   const gchar* table_name);
static gboolean qlite_column_text_real_is_null (QliteColumn* base,
                                         QliteRow* row,
                                         const gchar* table_name);
static void qlite_column_text_real_bind (QliteColumn* base,
                                  sqlite3_stmt* stmt,
                                  gint index,
                                  const gchar* value);
static GType qlite_column_text_get_type_once (void);
static gchar* qlite_column_non_null_text_real_get (QliteColumn* base,
                                            QliteRow* row,
                                            const gchar* table_name);
static gboolean qlite_column_non_null_text_real_is_null (QliteColumn* base,
                                                  QliteRow* row,
                                                  const gchar* table_name);
static void qlite_column_non_null_text_real_bind (QliteColumn* base,
                                           sqlite3_stmt* stmt,
                                           gint index,
                                           const gchar* value);
static GType qlite_column_non_null_text_get_type_once (void);
static gboolean qlite_column_bool_text_real_get (QliteColumn* base,
                                          QliteRow* row,
                                          const gchar* table_name);
static void qlite_column_bool_text_real_bind (QliteColumn* base,
                                       sqlite3_stmt* stmt,
                                       gint index,
                                       gboolean value);
static GType qlite_column_bool_text_get_type_once (void);
static gboolean qlite_column_bool_int_real_get (QliteColumn* base,
                                         QliteRow* row,
                                         const gchar* table_name);
static void qlite_column_bool_int_real_bind (QliteColumn* base,
                                      sqlite3_stmt* stmt,
                                      gint index,
                                      gboolean value);
static GType qlite_column_bool_int_get_type_once (void);
static void qlite_column_finalize (QliteColumn * obj);
static GType qlite_column_get_type_once (void);

static inline gpointer
qlite_column_get_instance_private (QliteColumn* self)
{
	return G_STRUCT_MEMBER_P (self, QliteColumn_private_offset);
}

static gpointer
qlite_column_real_get (QliteColumn* self,
                       QliteRow* row,
                       const gchar* table_name)
{
	g_critical ("Type `%s' does not implement abstract method `qlite_column_get'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gpointer
qlite_column_get (QliteColumn* self,
                  QliteRow* row,
                  const gchar* table_name)
{
	QliteColumnClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = QLITE_COLUMN_GET_CLASS (self);
	if (_klass_->get) {
		return _klass_->get (self, row, table_name);
	}
	return NULL;
}

static gboolean
qlite_column_real_is_null (QliteColumn* self,
                           QliteRow* row,
                           const gchar* table_name)
{
	gboolean result;
	g_return_val_if_fail (row != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
qlite_column_is_null (QliteColumn* self,
                      QliteRow* row,
                      const gchar* table_name)
{
	QliteColumnClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = QLITE_COLUMN_GET_CLASS (self);
	if (_klass_->is_null) {
		return _klass_->is_null (self, row, table_name);
	}
	return FALSE;
}

static void
qlite_column_real_bind (QliteColumn* self,
                        sqlite3_stmt* stmt,
                        gint index,
                        gconstpointer value)
{
	g_critical ("Type `%s' does not implement abstract method `qlite_column_bind'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
qlite_column_bind (QliteColumn* self,
                   sqlite3_stmt* stmt,
                   gint index,
                   gconstpointer value)
{
	QliteColumnClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = QLITE_COLUMN_GET_CLASS (self);
	if (_klass_->bind) {
		_klass_->bind (self, stmt, index, value);
	}
}

gchar*
qlite_column_to_string (QliteColumn* self)
{
	gchar* _tmp0_ = NULL;
	QliteTable* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_table;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		QliteTable* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = self->priv->_table;
		_tmp5_ = qlite_table_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, ".", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->_name;
		_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp10_;
		_g_free0 (_tmp8_);
	}
	result = _tmp0_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
qlite_column_to_column_definition (QliteColumn* self)
{
	gchar* res = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gboolean _tmp11_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp21_;
	const gchar* _tmp24_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	res = _tmp1_;
	_tmp2_ = self->priv->_sqlite_type;
	switch (_tmp2_) {
		case SQLITE_INTEGER:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = res;
			_tmp4_ = g_strconcat (_tmp3_, " INTEGER", NULL);
			_g_free0 (res);
			res = _tmp4_;
			break;
		}
		case SQLITE_FLOAT:
		{
			const gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = res;
			_tmp6_ = g_strconcat (_tmp5_, " REAL", NULL);
			_g_free0 (res);
			res = _tmp6_;
			break;
		}
		case SQLITE3_TEXT:
		{
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = res;
			_tmp8_ = g_strconcat (_tmp7_, " TEXT", NULL);
			_g_free0 (res);
			res = _tmp8_;
			break;
		}
		default:
		{
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = res;
			_tmp10_ = g_strconcat (_tmp9_, " UNKNOWN", NULL);
			_g_free0 (res);
			res = _tmp10_;
			break;
		}
	}
	_tmp11_ = self->priv->_primary_key;
	if (_tmp11_) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = res;
		_tmp13_ = g_strconcat (_tmp12_, " PRIMARY KEY", NULL);
		_g_free0 (res);
		res = _tmp13_;
		_tmp14_ = self->priv->_auto_increment;
		if (_tmp14_) {
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = res;
			_tmp16_ = g_strconcat (_tmp15_, " AUTOINCREMENT", NULL);
			_g_free0 (res);
			res = _tmp16_;
		}
	}
	_tmp17_ = qlite_column_get_not_null (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = res;
		_tmp20_ = g_strconcat (_tmp19_, " NOT NULL", NULL);
		_g_free0 (res);
		res = _tmp20_;
	}
	_tmp21_ = self->priv->_unique;
	if (_tmp21_) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = res;
		_tmp23_ = g_strconcat (_tmp22_, " UNIQUE", NULL);
		_g_free0 (res);
		res = _tmp23_;
	}
	_tmp24_ = self->priv->_default;
	if (_tmp24_ != NULL) {
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp25_ = res;
		_tmp26_ = self->priv->_default;
		_tmp27_ = string_to_string ((const gchar*) _tmp26_);
		_tmp28_ = g_strconcat (" DEFAULT ", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp25_, _tmp29_, NULL);
		_g_free0 (res);
		res = _tmp30_;
		_g_free0 (_tmp29_);
	}
	result = res;
	return result;
}

static QliteColumn*
qlite_column_construct (GType object_type,
                        GType t_type,
                        GBoxedCopyFunc t_dup_func,
                        GDestroyNotify t_destroy_func,
                        const gchar* name,
                        gint type)
{
	QliteColumn* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteColumn*) g_type_create_instance (object_type);
	self->priv->t_type = t_type;
	self->priv->t_dup_func = t_dup_func;
	self->priv->t_destroy_func = t_destroy_func;
	qlite_column_set_name (self, name);
	qlite_column_set_sqlite_type (self, type);
	return self;
}

const gchar*
qlite_column_get_name (QliteColumn* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
qlite_column_set_name (QliteColumn* self,
                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

const gchar*
qlite_column_get_default (QliteColumn* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default;
	result = _tmp0_;
	return result;
}

void
qlite_column_set_default (QliteColumn* self,
                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_default);
	self->priv->_default = _tmp0_;
}

gint
qlite_column_get_sqlite_type (QliteColumn* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sqlite_type;
	return result;
}

static void
qlite_column_set_sqlite_type (QliteColumn* self,
                              gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_sqlite_type = value;
}

gboolean
qlite_column_get_primary_key (QliteColumn* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_primary_key;
	return result;
}

void
qlite_column_set_primary_key (QliteColumn* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_primary_key = value;
}

gboolean
qlite_column_get_auto_increment (QliteColumn* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_auto_increment;
	return result;
}

void
qlite_column_set_auto_increment (QliteColumn* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_auto_increment = value;
}

gboolean
qlite_column_get_unique (QliteColumn* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_unique;
	return result;
}

void
qlite_column_set_unique (QliteColumn* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_unique = value;
}

gboolean
qlite_column_get_not_null (QliteColumn* self)
{
	QliteColumnClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = QLITE_COLUMN_GET_CLASS (self);
	if (_klass_->get_not_null) {
		return _klass_->get_not_null (self);
	}
	return FALSE;
}

static gboolean
qlite_column_real_get_not_null (QliteColumn* base)
{
	gboolean result;
	QliteColumn* self;
	self = base;
	result = self->priv->_not_null;
	return result;
}

void
qlite_column_set_not_null (QliteColumn* self,
                           gboolean value)
{
	QliteColumnClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = QLITE_COLUMN_GET_CLASS (self);
	if (_klass_->set_not_null) {
		_klass_->set_not_null (self, value);
	}
}

static void
qlite_column_real_set_not_null (QliteColumn* base,
                                gboolean value)
{
	QliteColumn* self;
	self = base;
	self->priv->_not_null = value;
}

glong
qlite_column_get_min_version (QliteColumn* self)
{
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = self->priv->_min_version;
	return result;
}

void
qlite_column_set_min_version (QliteColumn* self,
                              glong value)
{
	g_return_if_fail (self != NULL);
	self->priv->_min_version = value;
}

glong
qlite_column_get_max_version (QliteColumn* self)
{
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = self->priv->_max_version;
	return result;
}

void
qlite_column_set_max_version (QliteColumn* self,
                              glong value)
{
	g_return_if_fail (self != NULL);
	self->priv->_max_version = value;
}

QliteTable*
qlite_column_get_table (QliteColumn* self)
{
	QliteTable* result;
	QliteTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_table;
	result = _tmp0_;
	return result;
}

static gpointer
_qlite_table_ref0 (gpointer self)
{
	return self ? qlite_table_ref (self) : NULL;
}

void
qlite_column_set_table (QliteColumn* self,
                        QliteTable* value)
{
	QliteTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _qlite_table_ref0 (value);
	_qlite_table_unref0 (self->priv->_table);
	self->priv->_table = _tmp0_;
}

QliteColumnInteger*
qlite_column_integer_construct (GType object_type,
                                const gchar* name)
{
	QliteColumnInteger* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteColumnInteger*) qlite_column_construct (object_type, G_TYPE_INT, NULL, NULL, name, SQLITE_INTEGER);
	return self;
}

QliteColumnInteger*
qlite_column_integer_new (const gchar* name)
{
	return qlite_column_integer_construct (QLITE_COLUMN_TYPE_INTEGER, name);
}

static gint
qlite_column_integer_real_get (QliteColumn* base,
                               QliteRow* row,
                               const gchar* table_name)
{
	QliteColumnInteger * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint result;
	self = (QliteColumnInteger*) base;
	g_return_val_if_fail (row != NULL, 0);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	result = (gint) qlite_row_get_integer (row, _tmp6_, _tmp0_);
	return result;
}

static gboolean
qlite_column_integer_real_is_null (QliteColumn* base,
                                   QliteRow* row,
                                   const gchar* table_name)
{
	QliteColumnInteger * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	self = (QliteColumnInteger*) base;
	g_return_val_if_fail (row != NULL, FALSE);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	result = !qlite_row_has_integer (row, _tmp6_, _tmp0_);
	return result;
}

static void
qlite_column_integer_real_bind (QliteColumn* base,
                                sqlite3_stmt* stmt,
                                gint index,
                                gint value)
{
	QliteColumnInteger * self;
	self = (QliteColumnInteger*) base;
	g_return_if_fail (stmt != NULL);
	sqlite3_bind_int (stmt, index, value);
}

static void
qlite_column_integer_class_init (QliteColumnIntegerClass * klass,
                                 gpointer klass_data)
{
	qlite_column_integer_parent_class = g_type_class_peek_parent (klass);
	((QliteColumnClass *) klass)->get = (gpointer (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_integer_real_get;
	((QliteColumnClass *) klass)->is_null = (gboolean (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_integer_real_is_null;
	((QliteColumnClass *) klass)->bind = (void (*) (QliteColumn*, sqlite3_stmt*, gint, gconstpointer)) qlite_column_integer_real_bind;
}

static void
qlite_column_integer_instance_init (QliteColumnInteger * self,
                                    gpointer klass)
{
}

static GType
qlite_column_integer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (QliteColumnIntegerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_column_integer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteColumnInteger), 0, (GInstanceInitFunc) qlite_column_integer_instance_init, NULL };
	GType qlite_column_integer_type_id;
	qlite_column_integer_type_id = g_type_register_static (QLITE_TYPE_COLUMN, "QliteColumnInteger", &g_define_type_info, 0);
	return qlite_column_integer_type_id;
}

GType
qlite_column_integer_get_type (void)
{
	static volatile gsize qlite_column_integer_type_id__once = 0;
	if (g_once_init_enter (&qlite_column_integer_type_id__once)) {
		GType qlite_column_integer_type_id;
		qlite_column_integer_type_id = qlite_column_integer_get_type_once ();
		g_once_init_leave (&qlite_column_integer_type_id__once, qlite_column_integer_type_id);
	}
	return qlite_column_integer_type_id__once;
}

QliteColumnLong*
qlite_column_long_construct (GType object_type,
                             const gchar* name)
{
	QliteColumnLong* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteColumnLong*) qlite_column_construct (object_type, G_TYPE_LONG, NULL, NULL, name, SQLITE_INTEGER);
	return self;
}

QliteColumnLong*
qlite_column_long_new (const gchar* name)
{
	return qlite_column_long_construct (QLITE_COLUMN_TYPE_LONG, name);
}

static glong
qlite_column_long_real_get (QliteColumn* base,
                            QliteRow* row,
                            const gchar* table_name)
{
	QliteColumnLong * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	glong result;
	self = (QliteColumnLong*) base;
	g_return_val_if_fail (row != NULL, 0L);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	result = (glong) qlite_row_get_integer (row, _tmp6_, _tmp0_);
	return result;
}

static gboolean
qlite_column_long_real_is_null (QliteColumn* base,
                                QliteRow* row,
                                const gchar* table_name)
{
	QliteColumnLong * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	self = (QliteColumnLong*) base;
	g_return_val_if_fail (row != NULL, FALSE);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	result = !qlite_row_has_integer (row, _tmp6_, _tmp0_);
	return result;
}

static void
qlite_column_long_real_bind (QliteColumn* base,
                             sqlite3_stmt* stmt,
                             gint index,
                             glong value)
{
	QliteColumnLong * self;
	self = (QliteColumnLong*) base;
	g_return_if_fail (stmt != NULL);
	sqlite3_bind_int64 (stmt, index, (gint64) value);
}

static void
qlite_column_long_class_init (QliteColumnLongClass * klass,
                              gpointer klass_data)
{
	qlite_column_long_parent_class = g_type_class_peek_parent (klass);
	((QliteColumnClass *) klass)->get = (gpointer (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_long_real_get;
	((QliteColumnClass *) klass)->is_null = (gboolean (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_long_real_is_null;
	((QliteColumnClass *) klass)->bind = (void (*) (QliteColumn*, sqlite3_stmt*, gint, gconstpointer)) qlite_column_long_real_bind;
}

static void
qlite_column_long_instance_init (QliteColumnLong * self,
                                 gpointer klass)
{
}

static GType
qlite_column_long_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (QliteColumnLongClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_column_long_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteColumnLong), 0, (GInstanceInitFunc) qlite_column_long_instance_init, NULL };
	GType qlite_column_long_type_id;
	qlite_column_long_type_id = g_type_register_static (QLITE_TYPE_COLUMN, "QliteColumnLong", &g_define_type_info, 0);
	return qlite_column_long_type_id;
}

GType
qlite_column_long_get_type (void)
{
	static volatile gsize qlite_column_long_type_id__once = 0;
	if (g_once_init_enter (&qlite_column_long_type_id__once)) {
		GType qlite_column_long_type_id;
		qlite_column_long_type_id = qlite_column_long_get_type_once ();
		g_once_init_leave (&qlite_column_long_type_id__once, qlite_column_long_type_id);
	}
	return qlite_column_long_type_id__once;
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

QliteColumnNullableReal*
qlite_column_nullable_real_construct (GType object_type,
                                      const gchar* name)
{
	QliteColumnNullableReal* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteColumnNullableReal*) qlite_column_construct (object_type, G_TYPE_DOUBLE, (GBoxedCopyFunc) _double_dup, (GDestroyNotify) g_free, name, SQLITE_FLOAT);
	return self;
}

QliteColumnNullableReal*
qlite_column_nullable_real_new (const gchar* name)
{
	return qlite_column_nullable_real_construct (QLITE_COLUMN_TYPE_NULLABLE_REAL, name);
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

static gdouble*
qlite_column_nullable_real_real_get (QliteColumn* base,
                                     QliteRow* row,
                                     const gchar* table_name)
{
	QliteColumnNullableReal * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gdouble _tmp7_;
	gdouble* _tmp8_;
	gdouble* result;
	self = (QliteColumnNullableReal*) base;
	g_return_val_if_fail (row != NULL, NULL);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = qlite_row_get_real (row, _tmp6_, _tmp0_, (gdouble) 0);
	_tmp8_ = __double_dup0 (&_tmp7_);
	result = _tmp8_;
	return result;
}

static gboolean
qlite_column_nullable_real_real_is_null (QliteColumn* base,
                                         QliteRow* row,
                                         const gchar* table_name)
{
	QliteColumnNullableReal * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	self = (QliteColumnNullableReal*) base;
	g_return_val_if_fail (row != NULL, FALSE);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	result = !qlite_row_has_real (row, _tmp6_, _tmp0_);
	return result;
}

static void
qlite_column_nullable_real_real_bind (QliteColumn* base,
                                      sqlite3_stmt* stmt,
                                      gint index,
                                      gdouble* value)
{
	QliteColumnNullableReal * self;
	self = (QliteColumnNullableReal*) base;
	g_return_if_fail (stmt != NULL);
	sqlite3_bind_double (stmt, index, *value);
}

static gboolean
qlite_column_nullable_real_real_get_not_null (QliteColumn* base)
{
	gboolean result;
	QliteColumnNullableReal* self;
	self = (QliteColumnNullableReal*) base;
	result = FALSE;
	return result;
}

static void
qlite_column_nullable_real_real_set_not_null (QliteColumn* base,
                                              gboolean value)
{
	QliteColumnNullableReal* self;
	self = (QliteColumnNullableReal*) base;
}

static void
qlite_column_nullable_real_class_init (QliteColumnNullableRealClass * klass,
                                       gpointer klass_data)
{
	qlite_column_nullable_real_parent_class = g_type_class_peek_parent (klass);
	((QliteColumnClass *) klass)->get = (gpointer (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_nullable_real_real_get;
	((QliteColumnClass *) klass)->is_null = (gboolean (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_nullable_real_real_is_null;
	((QliteColumnClass *) klass)->bind = (void (*) (QliteColumn*, sqlite3_stmt*, gint, gconstpointer)) qlite_column_nullable_real_real_bind;
	QLITE_COLUMN_CLASS (klass)->get_not_null = (gboolean (*) (QliteColumn*)) qlite_column_nullable_real_real_get_not_null;
	QLITE_COLUMN_CLASS (klass)->set_not_null = (void (*) (QliteColumn*, gboolean)) qlite_column_nullable_real_real_set_not_null;
}

static void
qlite_column_nullable_real_instance_init (QliteColumnNullableReal * self,
                                          gpointer klass)
{
}

static GType
qlite_column_nullable_real_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (QliteColumnNullableRealClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_column_nullable_real_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteColumnNullableReal), 0, (GInstanceInitFunc) qlite_column_nullable_real_instance_init, NULL };
	GType qlite_column_nullable_real_type_id;
	qlite_column_nullable_real_type_id = g_type_register_static (QLITE_TYPE_COLUMN, "QliteColumnNullableReal", &g_define_type_info, 0);
	return qlite_column_nullable_real_type_id;
}

GType
qlite_column_nullable_real_get_type (void)
{
	static volatile gsize qlite_column_nullable_real_type_id__once = 0;
	if (g_once_init_enter (&qlite_column_nullable_real_type_id__once)) {
		GType qlite_column_nullable_real_type_id;
		qlite_column_nullable_real_type_id = qlite_column_nullable_real_get_type_once ();
		g_once_init_leave (&qlite_column_nullable_real_type_id__once, qlite_column_nullable_real_type_id);
	}
	return qlite_column_nullable_real_type_id__once;
}

QliteColumnText*
qlite_column_text_construct (GType object_type,
                             const gchar* name)
{
	QliteColumnText* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteColumnText*) qlite_column_construct (object_type, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, name, SQLITE3_TEXT);
	return self;
}

QliteColumnText*
qlite_column_text_new (const gchar* name)
{
	return qlite_column_text_construct (QLITE_COLUMN_TYPE_TEXT, name);
}

static gchar*
qlite_column_text_real_get (QliteColumn* base,
                            QliteRow* row,
                            const gchar* table_name)
{
	QliteColumnText * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = (QliteColumnText*) base;
	g_return_val_if_fail (row != NULL, NULL);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = qlite_row_get_text (row, _tmp6_, _tmp0_);
	result = _tmp7_;
	return result;
}

static gboolean
qlite_column_text_real_is_null (QliteColumn* base,
                                QliteRow* row,
                                const gchar* table_name)
{
	QliteColumnText * self;
	const gchar* _tmp0_ = NULL;
	gpointer _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean result;
	self = (QliteColumnText*) base;
	g_return_val_if_fail (row != NULL, FALSE);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get ((QliteColumn*) self, row, _tmp0_);
	_tmp6_ = (gchar*) _tmp5_;
	_tmp7_ = _tmp6_ == NULL;
	_g_free0 (_tmp6_);
	result = _tmp7_;
	return result;
}

static void
qlite_column_text_real_bind (QliteColumn* base,
                             sqlite3_stmt* stmt,
                             gint index,
                             const gchar* value)
{
	QliteColumnText * self;
	self = (QliteColumnText*) base;
	g_return_if_fail (stmt != NULL);
	if (value != NULL) {
		gchar* _tmp0_;
		GDestroyNotify _tmp1_;
		_tmp0_ = g_strdup ((const gchar*) value);
		_tmp1_ = g_free;
		sqlite3_bind_text (stmt, index, _tmp0_, -1, _tmp1_);
	} else {
		sqlite3_bind_null (stmt, index);
	}
}

static void
qlite_column_text_class_init (QliteColumnTextClass * klass,
                              gpointer klass_data)
{
	qlite_column_text_parent_class = g_type_class_peek_parent (klass);
	((QliteColumnClass *) klass)->get = (gpointer (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_text_real_get;
	((QliteColumnClass *) klass)->is_null = (gboolean (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_text_real_is_null;
	((QliteColumnClass *) klass)->bind = (void (*) (QliteColumn*, sqlite3_stmt*, gint, gconstpointer)) qlite_column_text_real_bind;
}

static void
qlite_column_text_instance_init (QliteColumnText * self,
                                 gpointer klass)
{
}

static GType
qlite_column_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (QliteColumnTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_column_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteColumnText), 0, (GInstanceInitFunc) qlite_column_text_instance_init, NULL };
	GType qlite_column_text_type_id;
	qlite_column_text_type_id = g_type_register_static (QLITE_TYPE_COLUMN, "QliteColumnText", &g_define_type_info, 0);
	return qlite_column_text_type_id;
}

GType
qlite_column_text_get_type (void)
{
	static volatile gsize qlite_column_text_type_id__once = 0;
	if (g_once_init_enter (&qlite_column_text_type_id__once)) {
		GType qlite_column_text_type_id;
		qlite_column_text_type_id = qlite_column_text_get_type_once ();
		g_once_init_leave (&qlite_column_text_type_id__once, qlite_column_text_type_id);
	}
	return qlite_column_text_type_id__once;
}

QliteColumnNonNullText*
qlite_column_non_null_text_construct (GType object_type,
                                      const gchar* name)
{
	QliteColumnNonNullText* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteColumnNonNullText*) qlite_column_construct (object_type, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, name, SQLITE3_TEXT);
	return self;
}

QliteColumnNonNullText*
qlite_column_non_null_text_new (const gchar* name)
{
	return qlite_column_non_null_text_construct (QLITE_COLUMN_TYPE_NON_NULL_TEXT, name);
}

static gchar*
qlite_column_non_null_text_real_get (QliteColumn* base,
                                     QliteRow* row,
                                     const gchar* table_name)
{
	QliteColumnNonNullText * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = (QliteColumnNonNullText*) base;
	g_return_val_if_fail (row != NULL, NULL);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = qlite_row_get_text (row, _tmp6_, _tmp0_);
	result = (gchar*) _tmp7_;
	return result;
}

static gboolean
qlite_column_non_null_text_real_is_null (QliteColumn* base,
                                         QliteRow* row,
                                         const gchar* table_name)
{
	QliteColumnNonNullText * self;
	gboolean result;
	self = (QliteColumnNonNullText*) base;
	g_return_val_if_fail (row != NULL, FALSE);
	result = FALSE;
	return result;
}

static void
qlite_column_non_null_text_real_bind (QliteColumn* base,
                                      sqlite3_stmt* stmt,
                                      gint index,
                                      const gchar* value)
{
	QliteColumnNonNullText * self;
	gchar* _tmp0_;
	GDestroyNotify _tmp1_;
	self = (QliteColumnNonNullText*) base;
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = g_strdup ((const gchar*) value);
	_tmp1_ = g_free;
	sqlite3_bind_text (stmt, index, _tmp0_, -1, _tmp1_);
}

static gboolean
qlite_column_non_null_text_real_get_not_null (QliteColumn* base)
{
	gboolean result;
	QliteColumnNonNullText* self;
	self = (QliteColumnNonNullText*) base;
	result = TRUE;
	return result;
}

static void
qlite_column_non_null_text_real_set_not_null (QliteColumn* base,
                                              gboolean value)
{
	QliteColumnNonNullText* self;
	self = (QliteColumnNonNullText*) base;
}

static void
qlite_column_non_null_text_class_init (QliteColumnNonNullTextClass * klass,
                                       gpointer klass_data)
{
	qlite_column_non_null_text_parent_class = g_type_class_peek_parent (klass);
	((QliteColumnClass *) klass)->get = (gpointer (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_non_null_text_real_get;
	((QliteColumnClass *) klass)->is_null = (gboolean (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_non_null_text_real_is_null;
	((QliteColumnClass *) klass)->bind = (void (*) (QliteColumn*, sqlite3_stmt*, gint, gconstpointer)) qlite_column_non_null_text_real_bind;
	QLITE_COLUMN_CLASS (klass)->get_not_null = (gboolean (*) (QliteColumn*)) qlite_column_non_null_text_real_get_not_null;
	QLITE_COLUMN_CLASS (klass)->set_not_null = (void (*) (QliteColumn*, gboolean)) qlite_column_non_null_text_real_set_not_null;
}

static void
qlite_column_non_null_text_instance_init (QliteColumnNonNullText * self,
                                          gpointer klass)
{
}

static GType
qlite_column_non_null_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (QliteColumnNonNullTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_column_non_null_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteColumnNonNullText), 0, (GInstanceInitFunc) qlite_column_non_null_text_instance_init, NULL };
	GType qlite_column_non_null_text_type_id;
	qlite_column_non_null_text_type_id = g_type_register_static (QLITE_TYPE_COLUMN, "QliteColumnNonNullText", &g_define_type_info, 0);
	return qlite_column_non_null_text_type_id;
}

GType
qlite_column_non_null_text_get_type (void)
{
	static volatile gsize qlite_column_non_null_text_type_id__once = 0;
	if (g_once_init_enter (&qlite_column_non_null_text_type_id__once)) {
		GType qlite_column_non_null_text_type_id;
		qlite_column_non_null_text_type_id = qlite_column_non_null_text_get_type_once ();
		g_once_init_leave (&qlite_column_non_null_text_type_id__once, qlite_column_non_null_text_type_id);
	}
	return qlite_column_non_null_text_type_id__once;
}

QliteColumnBoolText*
qlite_column_bool_text_construct (GType object_type,
                                  const gchar* name)
{
	QliteColumnBoolText* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteColumnBoolText*) qlite_column_construct (object_type, G_TYPE_BOOLEAN, NULL, NULL, name, SQLITE3_TEXT);
	return self;
}

QliteColumnBoolText*
qlite_column_bool_text_new (const gchar* name)
{
	return qlite_column_bool_text_construct (QLITE_COLUMN_TYPE_BOOL_TEXT, name);
}

static gboolean
qlite_column_bool_text_real_get (QliteColumn* base,
                                 QliteRow* row,
                                 const gchar* table_name)
{
	QliteColumnBoolText * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean result;
	self = (QliteColumnBoolText*) base;
	g_return_val_if_fail (row != NULL, FALSE);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = qlite_row_get_text (row, _tmp6_, _tmp0_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp8_, "1") == 0;
	_g_free0 (_tmp8_);
	result = _tmp9_;
	return result;
}

static void
qlite_column_bool_text_real_bind (QliteColumn* base,
                                  sqlite3_stmt* stmt,
                                  gint index,
                                  gboolean value)
{
	QliteColumnBoolText * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GDestroyNotify _tmp2_;
	self = (QliteColumnBoolText*) base;
	g_return_if_fail (stmt != NULL);
	if (value) {
		_tmp0_ = "1";
	} else {
		_tmp0_ = "0";
	}
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_free;
	sqlite3_bind_text (stmt, index, _tmp1_, -1, _tmp2_);
}

static void
qlite_column_bool_text_class_init (QliteColumnBoolTextClass * klass,
                                   gpointer klass_data)
{
	qlite_column_bool_text_parent_class = g_type_class_peek_parent (klass);
	((QliteColumnClass *) klass)->get = (gpointer (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_bool_text_real_get;
	((QliteColumnClass *) klass)->bind = (void (*) (QliteColumn*, sqlite3_stmt*, gint, gconstpointer)) qlite_column_bool_text_real_bind;
}

static void
qlite_column_bool_text_instance_init (QliteColumnBoolText * self,
                                      gpointer klass)
{
}

static GType
qlite_column_bool_text_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (QliteColumnBoolTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_column_bool_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteColumnBoolText), 0, (GInstanceInitFunc) qlite_column_bool_text_instance_init, NULL };
	GType qlite_column_bool_text_type_id;
	qlite_column_bool_text_type_id = g_type_register_static (QLITE_TYPE_COLUMN, "QliteColumnBoolText", &g_define_type_info, 0);
	return qlite_column_bool_text_type_id;
}

GType
qlite_column_bool_text_get_type (void)
{
	static volatile gsize qlite_column_bool_text_type_id__once = 0;
	if (g_once_init_enter (&qlite_column_bool_text_type_id__once)) {
		GType qlite_column_bool_text_type_id;
		qlite_column_bool_text_type_id = qlite_column_bool_text_get_type_once ();
		g_once_init_leave (&qlite_column_bool_text_type_id__once, qlite_column_bool_text_type_id);
	}
	return qlite_column_bool_text_type_id__once;
}

QliteColumnBoolInt*
qlite_column_bool_int_construct (GType object_type,
                                 const gchar* name)
{
	QliteColumnBoolInt* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (QliteColumnBoolInt*) qlite_column_construct (object_type, G_TYPE_BOOLEAN, NULL, NULL, name, SQLITE_INTEGER);
	return self;
}

QliteColumnBoolInt*
qlite_column_bool_int_new (const gchar* name)
{
	return qlite_column_bool_int_construct (QLITE_COLUMN_TYPE_BOOL_INT, name);
}

static gboolean
qlite_column_bool_int_real_get (QliteColumn* base,
                                QliteRow* row,
                                const gchar* table_name)
{
	QliteColumnBoolInt * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean result;
	self = (QliteColumnBoolInt*) base;
	g_return_val_if_fail (row != NULL, FALSE);
	if (g_strcmp0 (table_name, QLITE_COLUMN_DEFAULT_TABLE_NAME) == 0) {
		QliteTable* _tmp1_;
		QliteTable* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp1_ = qlite_column_get_table ((QliteColumn*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = qlite_table_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = table_name;
	}
	_tmp5_ = qlite_column_get_name ((QliteColumn*) self);
	_tmp6_ = _tmp5_;
	result = qlite_row_get_integer (row, _tmp6_, _tmp0_) == ((glong) 1);
	return result;
}

static void
qlite_column_bool_int_real_bind (QliteColumn* base,
                                 sqlite3_stmt* stmt,
                                 gint index,
                                 gboolean value)
{
	QliteColumnBoolInt * self;
	gint _tmp0_ = 0;
	self = (QliteColumnBoolInt*) base;
	g_return_if_fail (stmt != NULL);
	if (value) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	sqlite3_bind_int (stmt, index, _tmp0_);
}

static void
qlite_column_bool_int_class_init (QliteColumnBoolIntClass * klass,
                                  gpointer klass_data)
{
	qlite_column_bool_int_parent_class = g_type_class_peek_parent (klass);
	((QliteColumnClass *) klass)->get = (gpointer (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_bool_int_real_get;
	((QliteColumnClass *) klass)->bind = (void (*) (QliteColumn*, sqlite3_stmt*, gint, gconstpointer)) qlite_column_bool_int_real_bind;
}

static void
qlite_column_bool_int_instance_init (QliteColumnBoolInt * self,
                                     gpointer klass)
{
}

static GType
qlite_column_bool_int_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (QliteColumnBoolIntClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_column_bool_int_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteColumnBoolInt), 0, (GInstanceInitFunc) qlite_column_bool_int_instance_init, NULL };
	GType qlite_column_bool_int_type_id;
	qlite_column_bool_int_type_id = g_type_register_static (QLITE_TYPE_COLUMN, "QliteColumnBoolInt", &g_define_type_info, 0);
	return qlite_column_bool_int_type_id;
}

GType
qlite_column_bool_int_get_type (void)
{
	static volatile gsize qlite_column_bool_int_type_id__once = 0;
	if (g_once_init_enter (&qlite_column_bool_int_type_id__once)) {
		GType qlite_column_bool_int_type_id;
		qlite_column_bool_int_type_id = qlite_column_bool_int_get_type_once ();
		g_once_init_leave (&qlite_column_bool_int_type_id__once, qlite_column_bool_int_type_id);
	}
	return qlite_column_bool_int_type_id__once;
}

static void
qlite_value_column_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
qlite_value_column_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		qlite_column_unref (value->data[0].v_pointer);
	}
}

static void
qlite_value_column_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = qlite_column_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
qlite_value_column_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
qlite_value_column_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		QliteColumn * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = qlite_column_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
qlite_value_column_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	QliteColumn ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = qlite_column_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
qlite_param_spec_column (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	QliteParamSpecColumn* spec;
	g_return_val_if_fail (g_type_is_a (object_type, QLITE_TYPE_COLUMN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
qlite_value_get_column (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_COLUMN), NULL);
	return value->data[0].v_pointer;
}

void
qlite_value_set_column (GValue* value,
                        gpointer v_object)
{
	QliteColumn * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_COLUMN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, QLITE_TYPE_COLUMN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		qlite_column_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		qlite_column_unref (old);
	}
}

void
qlite_value_take_column (GValue* value,
                         gpointer v_object)
{
	QliteColumn * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, QLITE_TYPE_COLUMN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, QLITE_TYPE_COLUMN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		qlite_column_unref (old);
	}
}

static void
qlite_column_class_init (QliteColumnClass * klass,
                         gpointer klass_data)
{
	qlite_column_parent_class = g_type_class_peek_parent (klass);
	((QliteColumnClass *) klass)->finalize = qlite_column_finalize;
	g_type_class_adjust_private_offset (klass, &QliteColumn_private_offset);
	((QliteColumnClass *) klass)->get = (gpointer (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_real_get;
	((QliteColumnClass *) klass)->is_null = (gboolean (*) (QliteColumn*, QliteRow*, const gchar*)) qlite_column_real_is_null;
	((QliteColumnClass *) klass)->bind = (void (*) (QliteColumn*, sqlite3_stmt*, gint, gconstpointer)) qlite_column_real_bind;
	QLITE_COLUMN_CLASS (klass)->get_not_null = (gboolean (*) (QliteColumn*)) qlite_column_real_get_not_null;
	QLITE_COLUMN_CLASS (klass)->set_not_null = (void (*) (QliteColumn*, gboolean)) qlite_column_real_set_not_null;
}

static void
qlite_column_instance_init (QliteColumn * self,
                            gpointer klass)
{
	self->priv = qlite_column_get_instance_private (self);
	self->priv->_min_version = (glong) -1;
	self->priv->_max_version = G_MAXLONG;
	self->ref_count = 1;
}

static void
qlite_column_finalize (QliteColumn * obj)
{
	QliteColumn * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, QLITE_TYPE_COLUMN, QliteColumn);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_default);
	_qlite_table_unref0 (self->priv->_table);
}

static GType
qlite_column_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { qlite_value_column_init, qlite_value_column_free_value, qlite_value_column_copy_value, qlite_value_column_peek_pointer, "p", qlite_value_column_collect_value, "p", qlite_value_column_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (QliteColumnClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) qlite_column_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QliteColumn), 0, (GInstanceInitFunc) qlite_column_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType qlite_column_type_id;
	qlite_column_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QliteColumn", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	QliteColumn_private_offset = g_type_add_instance_private (qlite_column_type_id, sizeof (QliteColumnPrivate));
	return qlite_column_type_id;
}

GType
qlite_column_get_type (void)
{
	static volatile gsize qlite_column_type_id__once = 0;
	if (g_once_init_enter (&qlite_column_type_id__once)) {
		GType qlite_column_type_id;
		qlite_column_type_id = qlite_column_get_type_once ();
		g_once_init_leave (&qlite_column_type_id__once, qlite_column_type_id);
	}
	return qlite_column_type_id__once;
}

gpointer
qlite_column_ref (gpointer instance)
{
	QliteColumn * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
qlite_column_unref (gpointer instance)
{
	QliteColumn * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		QLITE_COLUMN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

