/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef CVC4__OPTIONS__BV_H
#define CVC4__OPTIONS__BV_H

#include "options/options.h"




#define CVC4_OPTIONS__BV__FOR_OPTION_HOLDER \
  bitvectorAig__option_t::type bitvectorAig;\
  bool bitvectorAig__setByUser__; \
  bitblastMode__option_t::type bitblastMode;\
  bool bitblastMode__setByUser__; \
  bitwiseEq__option_t::type bitwiseEq;\
  bool bitwiseEq__setByUser__; \
  boolToBitvector__option_t::type boolToBitvector;\
  bool boolToBitvector__setByUser__; \
  bvAbstraction__option_t::type bvAbstraction;\
  bool bvAbstraction__setByUser__; \
  bitvectorAigSimplifications__option_t::type bitvectorAigSimplifications;\
  bool bitvectorAigSimplifications__setByUser__; \
  bvAlgExtf__option_t::type bvAlgExtf;\
  bool bvAlgExtf__setByUser__; \
  bitvectorAlgebraicBudget__option_t::type bitvectorAlgebraicBudget;\
  bool bitvectorAlgebraicBudget__setByUser__; \
  bitvectorAlgebraicSolver__option_t::type bitvectorAlgebraicSolver;\
  bool bitvectorAlgebraicSolver__setByUser__; \
  bitvectorDivByZeroConst__option_t::type bitvectorDivByZeroConst;\
  bool bitvectorDivByZeroConst__setByUser__; \
  bvEagerExplanations__option_t::type bvEagerExplanations;\
  bool bvEagerExplanations__setByUser__; \
  bitvectorEqualitySlicer__option_t::type bitvectorEqualitySlicer;\
  bool bitvectorEqualitySlicer__setByUser__; \
  bitvectorEqualitySolver__option_t::type bitvectorEqualitySolver;\
  bool bitvectorEqualitySolver__setByUser__; \
  bvExtractArithRewrite__option_t::type bvExtractArithRewrite;\
  bool bvExtractArithRewrite__setByUser__; \
  bvGaussElim__option_t::type bvGaussElim;\
  bool bvGaussElim__setByUser__; \
  bitvectorInequalitySolver__option_t::type bitvectorInequalitySolver;\
  bool bitvectorInequalitySolver__setByUser__; \
  bvIntroducePow2__option_t::type bvIntroducePow2;\
  bool bvIntroducePow2__setByUser__; \
  bvLazyReduceExtf__option_t::type bvLazyReduceExtf;\
  bool bvLazyReduceExtf__setByUser__; \
  bvLazyRewriteExtf__option_t::type bvLazyRewriteExtf;\
  bool bvLazyRewriteExtf__setByUser__; \
  bvNumFunc__option_t::type bvNumFunc;\
  bool bvNumFunc__setByUser__; \
  bvOptimizeSatProof__option_t::type bvOptimizeSatProof;\
  bool bvOptimizeSatProof__setByUser__; \
  bvPrintConstsAsIndexedSymbols__option_t::type bvPrintConstsAsIndexedSymbols;\
  bool bvPrintConstsAsIndexedSymbols__setByUser__; \
  bvProofFormat__option_t::type bvProofFormat;\
  bool bvProofFormat__setByUser__; \
  bitvectorPropagate__option_t::type bitvectorPropagate;\
  bool bitvectorPropagate__setByUser__; \
  bitvectorQuickXplain__option_t::type bitvectorQuickXplain;\
  bool bitvectorQuickXplain__setByUser__; \
  bvSatSolver__option_t::type bvSatSolver;\
  bool bvSatSolver__setByUser__; \
  skolemizeArguments__option_t::type skolemizeArguments;\
  bool skolemizeArguments__setByUser__; \
  bitvectorToBool__option_t::type bitvectorToBool;\
  bool bitvectorToBool__setByUser__;


namespace CVC4 {

namespace options {


enum class BitblastMode
{
  LAZY,
  EAGER
};
std::ostream&
operator<<(std::ostream& os, BitblastMode mode) CVC4_PUBLIC;
BitblastMode
stringToBitblastMode(const std::string& option, const std::string& optarg);
enum class BoolToBVMode
{
  OFF,
  ITE,
  ALL
};
std::ostream&
operator<<(std::ostream& os, BoolToBVMode mode) CVC4_PUBLIC;
BoolToBVMode
stringToBoolToBVMode(const std::string& option, const std::string& optarg);
enum class BvSlicerMode
{
  ON,
  OFF,
  AUTO
};
std::ostream&
operator<<(std::ostream& os, BvSlicerMode mode) CVC4_PUBLIC;
BvSlicerMode
stringToBvSlicerMode(const std::string& option, const std::string& optarg);
enum class BvOptimizeSatProof
{
  NONE,
  PROOF,
  FORMULA
};
std::ostream&
operator<<(std::ostream& os, BvOptimizeSatProof mode) CVC4_PUBLIC;
BvOptimizeSatProof
stringToBvOptimizeSatProof(const std::string& option, const std::string& optarg);
enum class BvProofFormat
{
  ER,
  DRAT,
  LRAT
};
std::ostream&
operator<<(std::ostream& os, BvProofFormat mode) CVC4_PUBLIC;
BvProofFormat
stringToBvProofFormat(const std::string& option, const std::string& optarg);
enum class SatSolverMode
{
  MINISAT,
  CRYPTOMINISAT,
  CADICAL,
  KISSAT
};
std::ostream&
operator<<(std::ostream& os, SatSolverMode mode) CVC4_PUBLIC;
SatSolverMode
stringToSatSolverMode(const std::string& option, const std::string& optarg);

extern struct CVC4_PUBLIC bitvectorAig__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorAig CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitblastMode__option_t
{
  typedef BitblastMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitblastMode CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitwiseEq__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitwiseEq CVC4_PUBLIC;
extern struct CVC4_PUBLIC boolToBitvector__option_t
{
  typedef BoolToBVMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} boolToBitvector CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvAbstraction__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvAbstraction CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorAigSimplifications__option_t
{
  typedef std::string type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorAigSimplifications CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvAlgExtf__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvAlgExtf CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorAlgebraicBudget__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorAlgebraicBudget CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorAlgebraicSolver__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorAlgebraicSolver CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorDivByZeroConst__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorDivByZeroConst CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvEagerExplanations__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvEagerExplanations CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorEqualitySlicer__option_t
{
  typedef BvSlicerMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorEqualitySlicer CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorEqualitySolver__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorEqualitySolver CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvExtractArithRewrite__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvExtractArithRewrite CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvGaussElim__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} bvGaussElim CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorInequalitySolver__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorInequalitySolver CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvIntroducePow2__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} bvIntroducePow2 CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvLazyReduceExtf__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvLazyReduceExtf CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvLazyRewriteExtf__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvLazyRewriteExtf CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvNumFunc__option_t
{
  typedef unsigned type;
  type operator()() const;
  bool wasSetByUser() const;
} bvNumFunc CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvOptimizeSatProof__option_t
{
  typedef BvOptimizeSatProof type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvOptimizeSatProof CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvPrintConstsAsIndexedSymbols__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvPrintConstsAsIndexedSymbols CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvProofFormat__option_t
{
  typedef BvProofFormat type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvProofFormat CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorPropagate__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorPropagate CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorQuickXplain__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} bitvectorQuickXplain CVC4_PUBLIC;
extern struct CVC4_PUBLIC bvSatSolver__option_t
{
  typedef SatSolverMode type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bvSatSolver CVC4_PUBLIC;
extern struct CVC4_PUBLIC skolemizeArguments__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} skolemizeArguments CVC4_PUBLIC;
extern struct CVC4_PUBLIC bitvectorToBool__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} bitvectorToBool CVC4_PUBLIC;

}  // namespace options

template <> void Options::set(
    options::bitvectorAig__option_t,
    const options::bitvectorAig__option_t::type& x);
template <> const options::bitvectorAig__option_t::type& Options::operator[](
    options::bitvectorAig__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorAig__option_t) const;
template <> void Options::assignBool(
    options::bitvectorAig__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bitblastMode__option_t,
    const options::bitblastMode__option_t::type& x);
template <> const options::bitblastMode__option_t::type& Options::operator[](
    options::bitblastMode__option_t) const;
template <> bool Options::wasSetByUser(options::bitblastMode__option_t) const;
template <> void Options::assign(
    options::bitblastMode__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::bitwiseEq__option_t,
    const options::bitwiseEq__option_t::type& x);
template <> const options::bitwiseEq__option_t::type& Options::operator[](
    options::bitwiseEq__option_t) const;
template <> bool Options::wasSetByUser(options::bitwiseEq__option_t) const;
template <> void Options::assignBool(
    options::bitwiseEq__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::boolToBitvector__option_t,
    const options::boolToBitvector__option_t::type& x);
template <> const options::boolToBitvector__option_t::type& Options::operator[](
    options::boolToBitvector__option_t) const;
template <> bool Options::wasSetByUser(options::boolToBitvector__option_t) const;
template <> void Options::assign(
    options::boolToBitvector__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::bvAbstraction__option_t,
    const options::bvAbstraction__option_t::type& x);
template <> const options::bvAbstraction__option_t::type& Options::operator[](
    options::bvAbstraction__option_t) const;
template <> bool Options::wasSetByUser(options::bvAbstraction__option_t) const;
template <> void Options::assignBool(
    options::bvAbstraction__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bitvectorAigSimplifications__option_t,
    const options::bitvectorAigSimplifications__option_t::type& x);
template <> const options::bitvectorAigSimplifications__option_t::type& Options::operator[](
    options::bitvectorAigSimplifications__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorAigSimplifications__option_t) const;
template <> void Options::assign(
    options::bitvectorAigSimplifications__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::bvAlgExtf__option_t,
    const options::bvAlgExtf__option_t::type& x);
template <> const options::bvAlgExtf__option_t::type& Options::operator[](
    options::bvAlgExtf__option_t) const;
template <> bool Options::wasSetByUser(options::bvAlgExtf__option_t) const;
template <> void Options::assignBool(
    options::bvAlgExtf__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bitvectorAlgebraicBudget__option_t,
    const options::bitvectorAlgebraicBudget__option_t::type& x);
template <> const options::bitvectorAlgebraicBudget__option_t::type& Options::operator[](
    options::bitvectorAlgebraicBudget__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorAlgebraicBudget__option_t) const;
template <> void Options::assign(
    options::bitvectorAlgebraicBudget__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::bitvectorAlgebraicSolver__option_t,
    const options::bitvectorAlgebraicSolver__option_t::type& x);
template <> const options::bitvectorAlgebraicSolver__option_t::type& Options::operator[](
    options::bitvectorAlgebraicSolver__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorAlgebraicSolver__option_t) const;
template <> void Options::assignBool(
    options::bitvectorAlgebraicSolver__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bitvectorDivByZeroConst__option_t,
    const options::bitvectorDivByZeroConst__option_t::type& x);
template <> const options::bitvectorDivByZeroConst__option_t::type& Options::operator[](
    options::bitvectorDivByZeroConst__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorDivByZeroConst__option_t) const;
template <> void Options::assignBool(
    options::bitvectorDivByZeroConst__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bvEagerExplanations__option_t,
    const options::bvEagerExplanations__option_t::type& x);
template <> const options::bvEagerExplanations__option_t::type& Options::operator[](
    options::bvEagerExplanations__option_t) const;
template <> bool Options::wasSetByUser(options::bvEagerExplanations__option_t) const;
template <> void Options::assignBool(
    options::bvEagerExplanations__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bitvectorEqualitySlicer__option_t,
    const options::bitvectorEqualitySlicer__option_t::type& x);
template <> const options::bitvectorEqualitySlicer__option_t::type& Options::operator[](
    options::bitvectorEqualitySlicer__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorEqualitySlicer__option_t) const;
template <> void Options::assign(
    options::bitvectorEqualitySlicer__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::bitvectorEqualitySolver__option_t,
    const options::bitvectorEqualitySolver__option_t::type& x);
template <> const options::bitvectorEqualitySolver__option_t::type& Options::operator[](
    options::bitvectorEqualitySolver__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorEqualitySolver__option_t) const;
template <> void Options::assignBool(
    options::bitvectorEqualitySolver__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bvExtractArithRewrite__option_t,
    const options::bvExtractArithRewrite__option_t::type& x);
template <> const options::bvExtractArithRewrite__option_t::type& Options::operator[](
    options::bvExtractArithRewrite__option_t) const;
template <> bool Options::wasSetByUser(options::bvExtractArithRewrite__option_t) const;
template <> void Options::assignBool(
    options::bvExtractArithRewrite__option_t,
    std::string option,
    bool value);
template <> const options::bvGaussElim__option_t::type& Options::operator[](
    options::bvGaussElim__option_t) const;
template <> bool Options::wasSetByUser(options::bvGaussElim__option_t) const;
template <> void Options::assignBool(
    options::bvGaussElim__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bitvectorInequalitySolver__option_t,
    const options::bitvectorInequalitySolver__option_t::type& x);
template <> const options::bitvectorInequalitySolver__option_t::type& Options::operator[](
    options::bitvectorInequalitySolver__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorInequalitySolver__option_t) const;
template <> void Options::assignBool(
    options::bitvectorInequalitySolver__option_t,
    std::string option,
    bool value);
template <> const options::bvIntroducePow2__option_t::type& Options::operator[](
    options::bvIntroducePow2__option_t) const;
template <> bool Options::wasSetByUser(options::bvIntroducePow2__option_t) const;
template <> void Options::assignBool(
    options::bvIntroducePow2__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bvLazyReduceExtf__option_t,
    const options::bvLazyReduceExtf__option_t::type& x);
template <> const options::bvLazyReduceExtf__option_t::type& Options::operator[](
    options::bvLazyReduceExtf__option_t) const;
template <> bool Options::wasSetByUser(options::bvLazyReduceExtf__option_t) const;
template <> void Options::assignBool(
    options::bvLazyReduceExtf__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bvLazyRewriteExtf__option_t,
    const options::bvLazyRewriteExtf__option_t::type& x);
template <> const options::bvLazyRewriteExtf__option_t::type& Options::operator[](
    options::bvLazyRewriteExtf__option_t) const;
template <> bool Options::wasSetByUser(options::bvLazyRewriteExtf__option_t) const;
template <> void Options::assignBool(
    options::bvLazyRewriteExtf__option_t,
    std::string option,
    bool value);
template <> const options::bvNumFunc__option_t::type& Options::operator[](
    options::bvNumFunc__option_t) const;
template <> bool Options::wasSetByUser(options::bvNumFunc__option_t) const;
template <> void Options::assign(
    options::bvNumFunc__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::bvOptimizeSatProof__option_t,
    const options::bvOptimizeSatProof__option_t::type& x);
template <> const options::bvOptimizeSatProof__option_t::type& Options::operator[](
    options::bvOptimizeSatProof__option_t) const;
template <> bool Options::wasSetByUser(options::bvOptimizeSatProof__option_t) const;
template <> void Options::assign(
    options::bvOptimizeSatProof__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::bvPrintConstsAsIndexedSymbols__option_t,
    const options::bvPrintConstsAsIndexedSymbols__option_t::type& x);
template <> const options::bvPrintConstsAsIndexedSymbols__option_t::type& Options::operator[](
    options::bvPrintConstsAsIndexedSymbols__option_t) const;
template <> bool Options::wasSetByUser(options::bvPrintConstsAsIndexedSymbols__option_t) const;
template <> void Options::assignBool(
    options::bvPrintConstsAsIndexedSymbols__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bvProofFormat__option_t,
    const options::bvProofFormat__option_t::type& x);
template <> const options::bvProofFormat__option_t::type& Options::operator[](
    options::bvProofFormat__option_t) const;
template <> bool Options::wasSetByUser(options::bvProofFormat__option_t) const;
template <> void Options::assign(
    options::bvProofFormat__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::bitvectorPropagate__option_t,
    const options::bitvectorPropagate__option_t::type& x);
template <> const options::bitvectorPropagate__option_t::type& Options::operator[](
    options::bitvectorPropagate__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorPropagate__option_t) const;
template <> void Options::assignBool(
    options::bitvectorPropagate__option_t,
    std::string option,
    bool value);
template <> const options::bitvectorQuickXplain__option_t::type& Options::operator[](
    options::bitvectorQuickXplain__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorQuickXplain__option_t) const;
template <> void Options::assignBool(
    options::bitvectorQuickXplain__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bvSatSolver__option_t,
    const options::bvSatSolver__option_t::type& x);
template <> const options::bvSatSolver__option_t::type& Options::operator[](
    options::bvSatSolver__option_t) const;
template <> bool Options::wasSetByUser(options::bvSatSolver__option_t) const;
template <> void Options::assign(
    options::bvSatSolver__option_t,
    std::string option,
    std::string value);
template <> void Options::set(
    options::skolemizeArguments__option_t,
    const options::skolemizeArguments__option_t::type& x);
template <> const options::skolemizeArguments__option_t::type& Options::operator[](
    options::skolemizeArguments__option_t) const;
template <> bool Options::wasSetByUser(options::skolemizeArguments__option_t) const;
template <> void Options::assignBool(
    options::skolemizeArguments__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::bitvectorToBool__option_t,
    const options::bitvectorToBool__option_t::type& x);
template <> const options::bitvectorToBool__option_t::type& Options::operator[](
    options::bitvectorToBool__option_t) const;
template <> bool Options::wasSetByUser(options::bitvectorToBool__option_t) const;
template <> void Options::assignBool(
    options::bitvectorToBool__option_t,
    std::string option,
    bool value);


namespace options {

inline bitvectorAig__option_t::type bitvectorAig__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorAig__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorAig__option_t::set(const bitvectorAig__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitblastMode__option_t::type bitblastMode__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitblastMode__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitblastMode__option_t::set(const bitblastMode__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitwiseEq__option_t::type bitwiseEq__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitwiseEq__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitwiseEq__option_t::set(const bitwiseEq__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline boolToBitvector__option_t::type boolToBitvector__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool boolToBitvector__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void boolToBitvector__option_t::set(const boolToBitvector__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvAbstraction__option_t::type bvAbstraction__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvAbstraction__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvAbstraction__option_t::set(const bvAbstraction__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorAigSimplifications__option_t::type bitvectorAigSimplifications__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorAigSimplifications__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorAigSimplifications__option_t::set(const bitvectorAigSimplifications__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvAlgExtf__option_t::type bvAlgExtf__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvAlgExtf__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvAlgExtf__option_t::set(const bvAlgExtf__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorAlgebraicBudget__option_t::type bitvectorAlgebraicBudget__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorAlgebraicBudget__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorAlgebraicBudget__option_t::set(const bitvectorAlgebraicBudget__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorAlgebraicSolver__option_t::type bitvectorAlgebraicSolver__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorAlgebraicSolver__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorAlgebraicSolver__option_t::set(const bitvectorAlgebraicSolver__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorDivByZeroConst__option_t::type bitvectorDivByZeroConst__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorDivByZeroConst__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorDivByZeroConst__option_t::set(const bitvectorDivByZeroConst__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvEagerExplanations__option_t::type bvEagerExplanations__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvEagerExplanations__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvEagerExplanations__option_t::set(const bvEagerExplanations__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorEqualitySlicer__option_t::type bitvectorEqualitySlicer__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorEqualitySlicer__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorEqualitySlicer__option_t::set(const bitvectorEqualitySlicer__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorEqualitySolver__option_t::type bitvectorEqualitySolver__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorEqualitySolver__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorEqualitySolver__option_t::set(const bitvectorEqualitySolver__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvExtractArithRewrite__option_t::type bvExtractArithRewrite__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvExtractArithRewrite__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvExtractArithRewrite__option_t::set(const bvExtractArithRewrite__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvGaussElim__option_t::type bvGaussElim__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvGaussElim__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline bitvectorInequalitySolver__option_t::type bitvectorInequalitySolver__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorInequalitySolver__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorInequalitySolver__option_t::set(const bitvectorInequalitySolver__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvIntroducePow2__option_t::type bvIntroducePow2__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvIntroducePow2__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline bvLazyReduceExtf__option_t::type bvLazyReduceExtf__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvLazyReduceExtf__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvLazyReduceExtf__option_t::set(const bvLazyReduceExtf__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvLazyRewriteExtf__option_t::type bvLazyRewriteExtf__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvLazyRewriteExtf__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvLazyRewriteExtf__option_t::set(const bvLazyRewriteExtf__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvNumFunc__option_t::type bvNumFunc__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvNumFunc__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline bvOptimizeSatProof__option_t::type bvOptimizeSatProof__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvOptimizeSatProof__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvOptimizeSatProof__option_t::set(const bvOptimizeSatProof__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvPrintConstsAsIndexedSymbols__option_t::type bvPrintConstsAsIndexedSymbols__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvPrintConstsAsIndexedSymbols__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvPrintConstsAsIndexedSymbols__option_t::set(const bvPrintConstsAsIndexedSymbols__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bvProofFormat__option_t::type bvProofFormat__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvProofFormat__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvProofFormat__option_t::set(const bvProofFormat__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorPropagate__option_t::type bitvectorPropagate__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorPropagate__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorPropagate__option_t::set(const bitvectorPropagate__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorQuickXplain__option_t::type bitvectorQuickXplain__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorQuickXplain__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline bvSatSolver__option_t::type bvSatSolver__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bvSatSolver__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bvSatSolver__option_t::set(const bvSatSolver__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline skolemizeArguments__option_t::type skolemizeArguments__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool skolemizeArguments__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void skolemizeArguments__option_t::set(const skolemizeArguments__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline bitvectorToBool__option_t::type bitvectorToBool__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool bitvectorToBool__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void bitvectorToBool__option_t::set(const bitvectorToBool__option_t::type& v)
{
  Options::current()->set(*this, v);
}

}  // namespace options
}  // namespace CVC4

#endif /* CVC4__OPTIONS__BV_H */
