/* ContractMatcher.c generated by valac 0.56.17, the Vala compiler
 * generated from ContractMatcher.vala, do not modify */

/*
 * Copyright (C) 2011-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_CONTRACT (contractor_contract_get_type ())
#define CONTRACTOR_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT, ContractorContract))
#define CONTRACTOR_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT, ContractorContractClass))
#define CONTRACTOR_IS_CONTRACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT))
#define CONTRACTOR_IS_CONTRACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT))
#define CONTRACTOR_CONTRACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT, ContractorContractClass))

typedef struct _ContractorContract ContractorContract;
typedef struct _ContractorContractClass ContractorContractClass;

#define CONTRACTOR_TYPE_CONTRACTOR_ERROR (contractor_contractor_error_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	CONTRACTOR_CONTRACTOR_ERROR_NO_MIMETYPES_GIVEN
} ContractorContractorError;
#define CONTRACTOR_CONTRACTOR_ERROR contractor_contractor_error_quark ()

VALA_EXTERN GType contractor_contract_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContract, g_object_unref)
VALA_EXTERN GQuark contractor_contractor_error_quark (void);
VALA_EXTERN GType contractor_contractor_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GeeCollection* contractor_contract_matcher_get_contracts_for_types (gchar** mime_types,
                                                                    gint mime_types_length1,
                                                                    GeeCollection* contracts_to_filter,
                                                                    GError** error);
VALA_EXTERN gchar** contractor_string_clean_array (gchar** str_array,
                                       gint str_array_length1,
                                       gint* result_length1);
VALA_EXTERN gboolean contractor_contract_supports_mime_type (ContractorContract* self,
                                                 const gchar* mime_type);
VALA_EXTERN GeeCollection* contractor_contract_matcher_get_contracts_for_file_size (gint64 file_size,
                                                                        GeeCollection* contracts_to_filter,
                                                                        GError** error);
VALA_EXTERN gboolean contractor_contract_supports_file_size (ContractorContract* self,
                                                 gint64 file_size);
VALA_EXTERN GeeCollection* contractor_contract_matcher_get_contracts_for_types_and_file_size (gchar** mime_types,
                                                                                  gint mime_types_length1,
                                                                                  gint64 file_size,
                                                                                  GeeCollection* contracts_to_filter,
                                                                                  GError** error);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
     * get contracts which support the passed MIME types
     *
     * @param mime_types the MIME types which have to be supported by the returned contracts
     * @param contracts_to_filter a list of contracts to filter
     *
     * @return a Collection of Contract objects which support the file size
     */
GeeCollection*
contractor_contract_matcher_get_contracts_for_types (gchar** mime_types,
                                                     gint mime_types_length1,
                                                     GeeCollection* contracts_to_filter,
                                                     GError** error)
{
	GeeLinkedList* valid_contracts = NULL;
	GeeLinkedList* _tmp0_;
	gchar** valid_mime_types = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint valid_mime_types_length1;
	gint _valid_mime_types_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GError* _inner_error0_ = NULL;
	GeeCollection* result;
	g_return_val_if_fail (contracts_to_filter != NULL, NULL);
	_tmp0_ = gee_linked_list_new (CONTRACTOR_TYPE_CONTRACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	valid_contracts = _tmp0_;
	_tmp2_ = contractor_string_clean_array (mime_types, (gint) mime_types_length1, &_tmp1_);
	valid_mime_types = _tmp2_;
	valid_mime_types_length1 = _tmp1_;
	_valid_mime_types_size_ = valid_mime_types_length1;
	_tmp3_ = valid_mime_types;
	_tmp3__length1 = valid_mime_types_length1;
	if (_tmp3__length1 == 0) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (CONTRACTOR_CONTRACTOR_ERROR, CONTRACTOR_CONTRACTOR_ERROR_NO_MIMETYPES_GIVEN, "No mimetypes were provided.");
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == CONTRACTOR_CONTRACTOR_ERROR) {
			g_propagate_error (error, _inner_error0_);
			valid_mime_types = (_vala_array_free (valid_mime_types, valid_mime_types_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (valid_contracts);
			return NULL;
		} else {
			valid_mime_types = (_vala_array_free (valid_mime_types, valid_mime_types_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (valid_contracts);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	{
		GeeIterator* _contract_it = NULL;
		GeeIterator* _tmp5_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) contracts_to_filter);
		_contract_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			ContractorContract* contract = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			gboolean all_types_supported = FALSE;
			gchar** _tmp9_;
			gint _tmp9__length1;
			_tmp6_ = _contract_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _contract_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			contract = (ContractorContract*) _tmp8_;
			all_types_supported = TRUE;
			_tmp9_ = valid_mime_types;
			_tmp9__length1 = valid_mime_types_length1;
			{
				gchar** mime_type_collection = NULL;
				gint mime_type_collection_length1 = 0;
				gint _mime_type_collection_size_ = 0;
				gint mime_type_it = 0;
				mime_type_collection = _tmp9_;
				mime_type_collection_length1 = _tmp9__length1;
				for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
					gchar* _tmp10_;
					gchar* mime_type = NULL;
					_tmp10_ = g_strdup (mime_type_collection[mime_type_it]);
					mime_type = _tmp10_;
					{
						ContractorContract* _tmp11_;
						const gchar* _tmp12_;
						_tmp11_ = contract;
						_tmp12_ = mime_type;
						if (!contractor_contract_supports_mime_type (_tmp11_, _tmp12_)) {
							all_types_supported = FALSE;
							_g_free0 (mime_type);
							break;
						}
						_g_free0 (mime_type);
					}
				}
			}
			if (all_types_supported) {
				GeeLinkedList* _tmp13_;
				ContractorContract* _tmp14_;
				_tmp13_ = valid_contracts;
				_tmp14_ = contract;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
			}
			_g_object_unref0 (contract);
		}
		_g_object_unref0 (_contract_it);
	}
	result = (GeeCollection*) valid_contracts;
	valid_mime_types = (_vala_array_free (valid_mime_types, valid_mime_types_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
     * get contracts which support the passed file size
     *
     * @param file_size the file size which has to be supported by the returned contracts
     * @param contracts_to_filter a list of contracts to filter
     *
     * @return a Collection of Contract objects which support the file size
     */
GeeCollection*
contractor_contract_matcher_get_contracts_for_file_size (gint64 file_size,
                                                         GeeCollection* contracts_to_filter,
                                                         GError** error)
{
	GeeLinkedList* valid_contracts = NULL;
	GeeLinkedList* _tmp0_;
	GeeCollection* result;
	g_return_val_if_fail (contracts_to_filter != NULL, NULL);
	_tmp0_ = gee_linked_list_new (CONTRACTOR_TYPE_CONTRACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	valid_contracts = _tmp0_;
	{
		GeeIterator* _contract_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) contracts_to_filter);
		_contract_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			ContractorContract* contract = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			gboolean file_size_supported = FALSE;
			ContractorContract* _tmp5_;
			_tmp2_ = _contract_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _contract_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			contract = (ContractorContract*) _tmp4_;
			file_size_supported = TRUE;
			_tmp5_ = contract;
			if (!contractor_contract_supports_file_size (_tmp5_, file_size)) {
				file_size_supported = FALSE;
			}
			if (file_size_supported) {
				GeeLinkedList* _tmp6_;
				ContractorContract* _tmp7_;
				_tmp6_ = valid_contracts;
				_tmp7_ = contract;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			}
			_g_object_unref0 (contract);
		}
		_g_object_unref0 (_contract_it);
	}
	result = (GeeCollection*) valid_contracts;
	return result;
}

/**
     * get contracts which support the passed MIME types and file size
     *
     * @param mime_types the MIME types which have to be supported by the returned contracts
     * @param file_size the file size which has to be supported by the returned contracts
     * @param contracts_to_filter a list of contracts to filter
     *
     * @return a Collection of Contract objects which support the MIME types and the file size
     */
GeeCollection*
contractor_contract_matcher_get_contracts_for_types_and_file_size (gchar** mime_types,
                                                                   gint mime_types_length1,
                                                                   gint64 file_size,
                                                                   GeeCollection* contracts_to_filter,
                                                                   GError** error)
{
	GeeCollection* contracts_for_types = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* valid_contracts = NULL;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GError* _inner_error0_ = NULL;
	GeeCollection* result;
	g_return_val_if_fail (contracts_to_filter != NULL, NULL);
	_tmp0_ = contractor_contract_matcher_get_contracts_for_types (mime_types, (gint) mime_types_length1, contracts_to_filter, &_inner_error0_);
	contracts_for_types = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONTRACTOR_CONTRACTOR_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = contracts_for_types;
	_tmp2_ = contractor_contract_matcher_get_contracts_for_file_size (file_size, _tmp1_, &_inner_error0_);
	valid_contracts = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == CONTRACTOR_CONTRACTOR_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (contracts_for_types);
			return NULL;
		} else {
			_g_object_unref0 (contracts_for_types);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = valid_contracts;
	_g_object_unref0 (contracts_for_types);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

