/* ContractFile.c generated by valac 0.56.17, the Vala compiler
 * generated from ContractFile.vala, do not modify */

/*
 * Copyright (C) 2013-2017 elementary Developers
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define CONTRACTOR_CONTRACT_FILE_EXTENSION ".contract"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTRACTOR_TYPE_CONTRACT_FILE (contractor_contract_file_get_type ())
#define CONTRACTOR_CONTRACT_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFile))
#define CONTRACTOR_CONTRACT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFileClass))
#define CONTRACTOR_IS_CONTRACT_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTRACTOR_TYPE_CONTRACT_FILE))
#define CONTRACTOR_IS_CONTRACT_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTRACTOR_TYPE_CONTRACT_FILE))
#define CONTRACTOR_CONTRACT_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFileClass))

typedef struct _ContractorContractFile ContractorContractFile;
typedef struct _ContractorContractFileClass ContractorContractFileClass;
typedef struct _ContractorContractFilePrivate ContractorContractFilePrivate;
enum  {
	CONTRACTOR_CONTRACT_FILE_0_PROPERTY,
	CONTRACTOR_CONTRACT_FILE_NUM_PROPERTIES
};
static GParamSpec* contractor_contract_file_properties[CONTRACTOR_CONTRACT_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ContractorContractFile {
	GObject parent_instance;
	ContractorContractFilePrivate * priv;
};

struct _ContractorContractFileClass {
	GObjectClass parent_class;
};

struct _ContractorContractFilePrivate {
	GFile* file;
};

static gint ContractorContractFile_private_offset;
static gpointer contractor_contract_file_parent_class = NULL;

VALA_EXTERN GType contractor_contract_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContractorContractFile, g_object_unref)
VALA_EXTERN ContractorContractFile* contractor_contract_file_new (GFile* file);
VALA_EXTERN ContractorContractFile* contractor_contract_file_construct (GType object_type,
                                                            GFile* file);
VALA_EXTERN gchar* contractor_contract_file_get_id (ContractorContractFile* self);
static gchar* contractor_contract_file_remove_extension (const gchar* file_name);
VALA_EXTERN gchar* contractor_contract_file_get_contents (ContractorContractFile* self,
                                              GError** error);
VALA_EXTERN gboolean contractor_contract_file_is_valid_filename (const gchar* filename);
static void contractor_contract_file_finalize (GObject * obj);
static GType contractor_contract_file_get_type_once (void);

static inline gpointer
contractor_contract_file_get_instance_private (ContractorContractFile* self)
{
	return G_STRUCT_MEMBER_P (self, ContractorContractFile_private_offset);
}

/**
     * the constructor to create ContractFile object which contains the passed
     * File object
     *
     * @param file the file to contain
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ContractorContractFile*
contractor_contract_file_construct (GType object_type,
                                    GFile* file)
{
	ContractorContractFile * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (ContractorContractFile*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

ContractorContractFile*
contractor_contract_file_new (GFile* file)
{
	return contractor_contract_file_construct (CONTRACTOR_TYPE_CONTRACT_FILE, file);
}

/**
     * get the contract ID from the filename, e.g. file-roller-compress
     * (file-roller-compress.contract)
     *
     * @return the contracts ID, e.g. file-roller-compress
     */
gchar*
contractor_contract_file_get_id (ContractorContractFile* self)
{
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contractor_contract_file_remove_extension (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
     * loads and returns the internally stored files content
     *
     * @return the files content as string
     */
gchar*
contractor_contract_file_get_contents (ContractorContractFile* self,
                                       GError** error)
{
	guint8* file_data = NULL;
	gint file_data_length1 = 0;
	gint _file_data_size_ = 0;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	guint8* _tmp2_ = NULL;
	gsize _tmp3_ = 0;
	gboolean _tmp4_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->file;
	_tmp4_ = g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error0_);
	file_data = (g_free (file_data), NULL);
	file_data = _tmp2_;
	file_data_length1 = _tmp3_;
	_file_data_size_ = file_data_length1;
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		file_data = (g_free (file_data), NULL);
		return NULL;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ((const gchar*) file_data);
		result = _tmp5_;
		file_data = (g_free (file_data), NULL);
		return result;
	}
	_tmp6_ = g_strdup ("");
	result = _tmp6_;
	file_data = (g_free (file_data), NULL);
	return result;
}

/**
     * checks if the filename extension is '.contract'
     *
     * @param filename the full filename incl. the filename extension
     *
     * @return true if the filename extension is '.contract'; false otherwise
     */
static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gboolean
contractor_contract_file_is_valid_filename (const gchar* filename)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = strlen (CONTRACTOR_CONTRACT_FILE_EXTENSION);
	_tmp1_ = _tmp0_;
	_tmp2_ = strlen (filename);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_slice (filename, (glong) (-_tmp1_), (glong) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp5_, CONTRACTOR_CONTRACT_FILE_EXTENSION) == 0;
	_g_free0 (_tmp5_);
	result = _tmp6_;
	return result;
}

/**
     * removes the filename extension and returns the result
     *
     * @param file_name the filename incl. the filename extesnion
     *
     * @return the filename without the filename extension
     */
static gchar*
contractor_contract_file_remove_extension (const gchar* file_name)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (file_name != NULL, NULL);
	_tmp0_ = strlen (CONTRACTOR_CONTRACT_FILE_EXTENSION);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_slice (file_name, (glong) 0, (glong) (-_tmp1_));
	result = _tmp2_;
	return result;
}

static void
contractor_contract_file_class_init (ContractorContractFileClass * klass,
                                     gpointer klass_data)
{
	contractor_contract_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContractorContractFile_private_offset);
	G_OBJECT_CLASS (klass)->finalize = contractor_contract_file_finalize;
}

static void
contractor_contract_file_instance_init (ContractorContractFile * self,
                                        gpointer klass)
{
	self->priv = contractor_contract_file_get_instance_private (self);
}

static void
contractor_contract_file_finalize (GObject * obj)
{
	ContractorContractFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTRACTOR_TYPE_CONTRACT_FILE, ContractorContractFile);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (contractor_contract_file_parent_class)->finalize (obj);
}

/**
 * used to access the Contracts File object and read its content
 */
static GType
contractor_contract_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContractorContractFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contractor_contract_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContractorContractFile), 0, (GInstanceInitFunc) contractor_contract_file_instance_init, NULL };
	GType contractor_contract_file_type_id;
	contractor_contract_file_type_id = g_type_register_static (G_TYPE_OBJECT, "ContractorContractFile", &g_define_type_info, 0);
	ContractorContractFile_private_offset = g_type_add_instance_private (contractor_contract_file_type_id, sizeof (ContractorContractFilePrivate));
	return contractor_contract_file_type_id;
}

GType
contractor_contract_file_get_type (void)
{
	static volatile gsize contractor_contract_file_type_id__once = 0;
	if (g_once_init_enter (&contractor_contract_file_type_id__once)) {
		GType contractor_contract_file_type_id;
		contractor_contract_file_type_id = contractor_contract_file_get_type_once ();
		g_once_init_leave (&contractor_contract_file_type_id__once, contractor_contract_file_type_id);
	}
	return contractor_contract_file_type_id__once;
}

