// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum symbol_kind.yaml. DO NOT EDIT.

package ir

import (
	"fmt"
	"iter"
)

// SymbolKind is a kind of symbol, i.e. an IR entity that defines a
// fully-qualified name.
type SymbolKind int8

const (
	SymbolKindInvalid SymbolKind = iota
	SymbolKindPackage
	SymbolKindScalar
	SymbolKindMessage
	SymbolKindEnum
	SymbolKindField
	SymbolKindEnumValue
	SymbolKindExtension
	SymbolKindOneof
	SymbolKindService
	SymbolKindMethod
)

// String implements [fmt.Stringer].
func (v SymbolKind) String() string {
	if int(v) < 0 || int(v) > len(_table_SymbolKind_String) {
		return fmt.Sprintf("SymbolKind(%v)", int(v))
	}
	return _table_SymbolKind_String[v]
}

// GoString implements [fmt.GoStringer].
func (v SymbolKind) GoString() string {
	if int(v) < 0 || int(v) > len(_table_SymbolKind_GoString) {
		return fmt.Sprintf("ir.SymbolKind(%v)", int(v))
	}
	return _table_SymbolKind_GoString[v]
}

var _table_SymbolKind_String = [...]string{
	SymbolKindInvalid:   "SymbolKindInvalid",
	SymbolKindPackage:   "SymbolKindPackage",
	SymbolKindScalar:    "SymbolKindScalar",
	SymbolKindMessage:   "SymbolKindMessage",
	SymbolKindEnum:      "SymbolKindEnum",
	SymbolKindField:     "SymbolKindField",
	SymbolKindEnumValue: "SymbolKindEnumValue",
	SymbolKindExtension: "SymbolKindExtension",
	SymbolKindOneof:     "SymbolKindOneof",
	SymbolKindService:   "SymbolKindService",
	SymbolKindMethod:    "SymbolKindMethod",
}

var _table_SymbolKind_GoString = [...]string{
	SymbolKindInvalid:   "ir.SymbolKindInvalid",
	SymbolKindPackage:   "ir.SymbolKindPackage",
	SymbolKindScalar:    "ir.SymbolKindScalar",
	SymbolKindMessage:   "ir.SymbolKindMessage",
	SymbolKindEnum:      "ir.SymbolKindEnum",
	SymbolKindField:     "ir.SymbolKindField",
	SymbolKindEnumValue: "ir.SymbolKindEnumValue",
	SymbolKindExtension: "ir.SymbolKindExtension",
	SymbolKindOneof:     "ir.SymbolKindOneof",
	SymbolKindService:   "ir.SymbolKindService",
	SymbolKindMethod:    "ir.SymbolKindMethod",
}
var _ iter.Seq[int] // Mark iter as used.
