
#ifndef __RNA_BLENDER_CPP_H__
#define __RNA_BLENDER_CPP_H__

/* Automatically generated classes for the Data API.
 * Do not edit manually, changes will be overwritten. */

#include "RNA_blender.hh"
#include "RNA_types.hh"
#include "RNA_access.hh"
#include "DNA_node_types.h"

#include <stdlib.h> /* for malloc */
#include <string>
#include <string.h> /* for memcpy */

namespace BL {

#define BOOLEAN_PROPERTY(sname, identifier) \
    inline bool sname::identifier(void) { return sname##_##identifier##_get(&ptr) ? true: false; } \
    inline void sname::identifier(bool value) { sname##_##identifier##_set(&ptr, value); }

#define BOOLEAN_ARRAY_PROPERTY(sname, size, identifier) \
    inline Array<bool, size> sname::identifier(void) \
        { Array<bool, size> ar; sname##_##identifier##_get(&ptr, ar.data); return ar; } \
    inline void sname::identifier(bool values[size]) \
        { sname##_##identifier##_set(&ptr, values); } \

#define BOOLEAN_DYNAMIC_ARRAY_PROPERTY(sname, identifier) \
    inline DynamicArray<bool> sname::identifier(void) { \
        int arraylen[3]; \
        int len = sname##_##identifier##_get_length(&ptr, arraylen); \
        DynamicArray<bool> ar(len); \
        sname##_##identifier##_get(&ptr, ar.data); \
        return ar; } \
    inline void sname::identifier(bool values[]) \
        { sname##_##identifier##_set(&ptr, values); } \

#define INT_PROPERTY(sname, identifier) \
    inline int sname::identifier(void) { return sname##_##identifier##_get(&ptr); } \
    inline void sname::identifier(int value) { sname##_##identifier##_set(&ptr, value); }

#define INT_ARRAY_PROPERTY(sname, size, identifier) \
    inline Array<int, size> sname::identifier(void) \
        { Array<int, size> ar; sname##_##identifier##_get(&ptr, ar.data); return ar; } \
    inline void sname::identifier(int values[size]) \
        { sname##_##identifier##_set(&ptr, values); } \

#define INT_DYNAMIC_ARRAY_PROPERTY(sname, identifier) \
    inline DynamicArray<int> sname::identifier(void) { \
        int arraylen[3]; \
        int len = sname##_##identifier##_get_length(&ptr, arraylen); \
        DynamicArray<int> ar(len); \
        sname##_##identifier##_get(&ptr, ar.data); \
        return ar; } \
    inline void sname::identifier(int values[]) \
        { sname##_##identifier##_set(&ptr, values); } \

#define FLOAT_PROPERTY(sname, identifier) \
    inline float sname::identifier(void) { return sname##_##identifier##_get(&ptr); } \
    inline void sname::identifier(float value) { sname##_##identifier##_set(&ptr, value); }

#define FLOAT_ARRAY_PROPERTY(sname, size, identifier) \
    inline Array<float, size> sname::identifier(void) \
        { Array<float, size> ar; sname##_##identifier##_get(&ptr, ar.data); return ar; } \
    inline void sname::identifier(float values[size]) \
        { sname##_##identifier##_set(&ptr, values); } \

#define FLOAT_DYNAMIC_ARRAY_PROPERTY(sname, identifier) \
    inline DynamicArray<float> sname::identifier(void) { \
        int arraylen[3]; \
        int len = sname##_##identifier##_get_length(&ptr, arraylen); \
        DynamicArray<float> ar(len); \
        sname##_##identifier##_get(&ptr, ar.data); \
        return ar; } \
    inline void sname::identifier(float values[]) \
        { sname##_##identifier##_set(&ptr, values); } \

#define ENUM_PROPERTY(type, sname, identifier) \
    inline sname::type sname::identifier(void) { return (type)sname##_##identifier##_get(&ptr); } \
    inline void sname::identifier(sname::type value) { sname##_##identifier##_set(&ptr, value); }

#define STRING_PROPERTY(sname, identifier) \
    inline std::string sname::identifier(void) { \
        int len = sname##_##identifier##_length(&ptr); \
        std::string str; str.resize(len); \
        sname##_##identifier##_get(&ptr, &str[0]); return str; } \
    inline void sname::identifier(const std::string& value) { \
        sname##_##identifier##_set(&ptr, value.c_str()); } \

#define POINTER_PROPERTY(type, sname, identifier) \
    inline type sname::identifier(void) { return type(sname##_##identifier##_get(&ptr)); }

#define COLLECTION_PROPERTY_LENGTH_false(sname, identifier) \
    inline static int sname##_##identifier##_length_wrap(PointerRNA *ptr) \
    { \
        CollectionPropertyIterator iter; \
        int length = 0; \
        sname##_##identifier##_begin(&iter, ptr); \
        while (iter.valid) { \
            sname##_##identifier##_next(&iter); \
            ++length; \
        } \
        sname##_##identifier##_end(&iter); \
        return length; \
    } 
#define COLLECTION_PROPERTY_LENGTH_true(sname, identifier) \
    inline static int sname##_##identifier##_length_wrap(PointerRNA *ptr) \
    { return sname##_##identifier##_length(ptr); } 

#define COLLECTION_PROPERTY_EMPTY_false(sname, identifier) \
    inline static bool sname##_##identifier##_empty_wrap(PointerRNA *ptr) \
    { \
        CollectionPropertyIterator iter; \
        sname##_##identifier##_begin(&iter, ptr); \
        bool empty = !iter.valid; \
        sname##_##identifier##_end(&iter); \
        return empty; \
    } 
#define COLLECTION_PROPERTY_EMPTY_true(sname, identifier) \
    inline static bool sname##_##identifier##_empty_wrap(PointerRNA *ptr) \
    { return sname##_##identifier##_length(ptr) == 0; } 

#define COLLECTION_PROPERTY_LOOKUP_INT_false(sname, identifier) \
    inline static bool sname##_##identifier##_lookup_int_wrap(PointerRNA *ptr, int key, PointerRNA *r_ptr) \
    { \
        CollectionPropertyIterator iter; \
        int i = 0; \
        bool found = false; \
        sname##_##identifier##_begin(&iter, ptr); \
        while (iter.valid) { \
            if (i == key) { \
                *r_ptr = iter.ptr; \
                found = true; \
                break; \
            } \
            sname##_##identifier##_next(&iter); \
            ++i; \
        } \
        sname##_##identifier##_end(&iter); \
        if (!found) { \
            *r_ptr = {}; \
        } \
        return found; \
    } 
#define COLLECTION_PROPERTY_LOOKUP_INT_true(sname, identifier) \
    inline static bool sname##_##identifier##_lookup_int_wrap(PointerRNA *ptr, int key, PointerRNA *r_ptr) \
    { \
        bool found = sname##_##identifier##_lookup_int(ptr, key, r_ptr); \
        if (!found) { \
            *r_ptr = {}; \
        } \
        return found; \
    } 
#define COLLECTION_PROPERTY_LOOKUP_STRING_false(sname, identifier) \
    inline static bool sname##_##identifier##_lookup_string_wrap(PointerRNA *ptr, const char *key, PointerRNA *r_ptr) \
    { \
        CollectionPropertyIterator iter; \
        bool found = false; \
        PropertyRNA *item_name_prop = RNA_struct_name_property(ptr->type); \
        sname##_##identifier##_begin(&iter, ptr); \
        while (iter.valid && !found) { \
            char name_fixed[32]; \
            const char *name; \
            int name_length; \
            name = RNA_property_string_get_alloc(&iter.ptr, item_name_prop, name_fixed, sizeof(name_fixed), &name_length); \
            if (!strncmp(name, key, name_length)) { \
                *r_ptr = iter.ptr; \
                found = true; \
            } \
            if (name_fixed != name) { \
                MEM_freeN( name); \
            } \
            sname##_##identifier##_next(&iter); \
        } \
        sname##_##identifier##_end(&iter); \
        if (!found) { \
            *r_ptr = {}; \
        } \
        return found; \
    } 
#define COLLECTION_PROPERTY_LOOKUP_STRING_true(sname, identifier) \
    inline static bool sname##_##identifier##_lookup_string_wrap(PointerRNA *ptr, const char *key, PointerRNA *r_ptr) \
    { \
        bool found = sname##_##identifier##_lookup_string(ptr, key, r_ptr); \
        if (!found) { \
            *r_ptr = {}; \
        } \
        return found; \
    } 
#define COLLECTION_PROPERTY(collection_funcs, type, sname, identifier, has_length, has_lookup_int, has_lookup_string) \
    typedef CollectionIterator<type, sname##_##identifier##_begin, \
        sname##_##identifier##_next, sname##_##identifier##_end> identifier##_iterator; \
    COLLECTION_PROPERTY_LENGTH_##has_length(sname, identifier) \
    COLLECTION_PROPERTY_EMPTY_##has_length(sname, identifier) \
    COLLECTION_PROPERTY_LOOKUP_INT_##has_lookup_int(sname, identifier) \
    COLLECTION_PROPERTY_LOOKUP_STRING_##has_lookup_string(sname, identifier) \
    CollectionRef<sname, type, sname##_##identifier##_begin, \
        sname##_##identifier##_next, sname##_##identifier##_end, \
        sname##_##identifier##_length_wrap, \
        sname##_##identifier##_empty_wrap, \
        sname##_##identifier##_lookup_int_wrap, sname##_##identifier##_lookup_string_wrap, collection_funcs> identifier;

class Pointer {
public:
    Pointer(const PointerRNA &p) : ptr(p) { }
    operator const PointerRNA&() { return ptr; }
    bool is_a(StructRNA *type) { return RNA_struct_is_a(ptr.type, type) ? true: false; }
    operator void*() { return ptr.data; }
    operator bool() const { return ptr.data != nullptr; }

    bool operator==(const Pointer &other) const { return ptr.data == other.ptr.data; }
    bool operator!=(const Pointer &other) const { return ptr.data != other.ptr.data; }
    bool operator<(const Pointer &other) const { return ptr.data < other.ptr.data; }

    PointerRNA ptr;
};


template<typename T, int Tsize>
class Array {
public:
    T data[Tsize];

    Array() {}
    Array(const Array<T, Tsize>& other) { memcpy(data, other.data, sizeof(T) * Tsize); }
    const Array<T, Tsize>& operator = (const Array<T, Tsize>& other) { memcpy(data, other.data, sizeof(T) * Tsize); return *this; }

    operator T*() { return data; }
    operator const T*() const { return data; }
};

template<typename T>
class DynamicArray {
public:
    T *data;
    int length;

    DynamicArray() : data(nullptr), length(0) {}
    DynamicArray(int new_length) : data(nullptr), length(new_length) { data = (T *)malloc(sizeof(T) * new_length); }
    DynamicArray(const DynamicArray<T>& other) : data(nullptr), length(0) { copy_from(other); }
    const DynamicArray<T>& operator = (const DynamicArray<T>& other) { copy_from(other); return *this; }

    ~DynamicArray() { if (data) free(data); }

    operator T*() { return data; }

protected:
    void copy_from(const DynamicArray<T>& other) {
        if (data) free(data);
        data = (T *)malloc(sizeof(T) * other.length);
        memcpy(data, other.data, sizeof(T) * other.length);
        length = other.length;
    }
};

typedef void (*TBeginFunc)(CollectionPropertyIterator *iter, PointerRNA *ptr);
typedef void (*TNextFunc)(CollectionPropertyIterator *iter);
typedef void (*TEndFunc)(CollectionPropertyIterator *iter);
typedef int (*TLengthFunc)(PointerRNA *ptr);
typedef bool (*TEmptyFunc)(PointerRNA *ptr);
typedef bool (*TLookupIntFunc)(PointerRNA *ptr, int key, PointerRNA *r_ptr);
typedef bool (*TLookupStringFunc)(PointerRNA *ptr, const char *key, PointerRNA *r_ptr);

template<typename T, TBeginFunc Tbegin, TNextFunc Tnext, TEndFunc Tend>
class CollectionIterator {
public:
    CollectionIterator() : iter(), t(iter.ptr), init(false) { iter.valid = false; }
    CollectionIterator(const PointerRNA &ptr) : CollectionIterator() { this->begin(ptr); }
    ~CollectionIterator(void) { if (init) Tend(&iter); };

    CollectionIterator(const CollectionIterator &other) = delete;
    CollectionIterator(CollectionIterator &&other) = delete;
    CollectionIterator &operator=(const CollectionIterator &other) = delete;
    CollectionIterator &operator=(CollectionIterator &&other) = delete;

    operator bool(void) const
    { return iter.valid != 0; }
    const CollectionIterator<T, Tbegin, Tnext, Tend>& operator++() { Tnext(&iter); t = T(iter.ptr); return *this; }

    T& operator*(void) { return t; }
    T* operator->(void) { return &t; }
    bool operator == (const CollectionIterator<T, Tbegin, Tnext, Tend>& other) { return iter.valid == other.iter.valid; }
    bool operator!=(const CollectionIterator<T, Tbegin, Tnext, Tend>& other) { return iter.valid != other.iter.valid; }

    void begin(const Pointer &ptr)
    { if (init) Tend(&iter); Tbegin(&iter, (PointerRNA *)&ptr.ptr); t = T(iter.ptr); init = true; }

private:
    CollectionPropertyIterator iter;
    T t;
    bool init;
};

template<typename Tp, typename T, TBeginFunc Tbegin, TNextFunc Tnext, TEndFunc Tend,
         TLengthFunc Tlength, TEmptyFunc Tempty, TLookupIntFunc Tlookup_int,
         TLookupStringFunc Tlookup_string, typename Tcollection_funcs>
class CollectionRef : public Tcollection_funcs {
public:
    CollectionRef(const PointerRNA &p) : Tcollection_funcs(p), ptr(p) {}

    void begin(CollectionIterator<T, Tbegin, Tnext, Tend>& iter)
    { iter.begin(ptr); }
    CollectionIterator<T, Tbegin, Tnext, Tend> begin()
    { return CollectionIterator<T, Tbegin, Tnext, Tend>(ptr); }
    CollectionIterator<T, Tbegin, Tnext, Tend> end()
    { return CollectionIterator<T, Tbegin, Tnext, Tend>(); } /* test */ 
    int length()
    { return Tlength(&ptr); }
    bool empty()
    { return Tempty(&ptr); }
    T operator[](int key)
    { PointerRNA r_ptr; Tlookup_int(&ptr, key, &r_ptr); return T(r_ptr); }
    T operator[](const std::string &key)
    { PointerRNA r_ptr; Tlookup_string(&ptr, key.c_str(), &r_ptr); return T(r_ptr); }

private:
    PointerRNA ptr;
};

class DefaultCollectionFunctions {
public:
    DefaultCollectionFunctions(const PointerRNA & /*p*/) {}
};


/**************** Declarations ****************/

class Struct;
class Property;
class BoolProperty;
class IntProperty;
class FloatProperty;
class StringProperty;
class EnumProperty;
class EnumPropertyItem;
class PointerProperty;
class CollectionProperty;
class Function;
class BlenderRNA;
class PrimitiveString;
class PrimitiveInt;
class PrimitiveFloat;
class PrimitiveBoolean;
class UnknownType;
class AnyType;
class ID;
class IDOverrideLibrary;
class IDOverrideLibraryProperties;
class IDOverrideLibraryProperty;
class IDOverrideLibraryPropertyOperations;
class IDOverrideLibraryPropertyOperation;
class ImagePreview;
class PropertyGroupItem;
class PropertyGroup;
class IDMaterials;
class Library;
class LibraryWeakReference;
class IDPropertyWrapPtr;
class Texture;
class CloudsTexture;
class WoodTexture;
class MarbleTexture;
class MagicTexture;
class BlendTexture;
class StucciTexture;
class NoiseTexture;
class ImageTexture;
class MusgraveTexture;
class VoronoiTexture;
class DistortedNoiseTexture;
class TextureSlot;
class TexMapping;
class ColorMapping;
class Action;
class ActionSlots;
class ActionLayers;
class ActionPoseMarkers;
class ActionFCurves;
class ActionGroups;
class ActionGroup;
class DopeSheet;
class ActionSlot;
class ActionLayer;
class ActionStrips;
class ActionStrip;
class ActionKeyframeStrip;
class ActionChannelbags;
class ActionChannelbag;
class ActionChannelbagFCurves;
class ActionChannelbagGroups;
class AnimData;
class NlaTracks;
class AnimDataDrivers;
class KeyingSet;
class KeyingSetPaths;
class KeyingSetPath;
class KeyingSetInfo;
class AnimViz;
class AnimVizMotionPaths;
class MotionPath;
class MotionPathVert;
class BoneColor;
class BoneCollection;
class Armature;
class ArmatureBones;
class ArmatureEditBones;
class BoneCollections;
class Bone;
class BoneCollectionMemberships;
class EditBone;
class Attribute;
class FloatAttribute;
class FloatAttributeValue;
class FloatVectorAttribute;
class FloatVectorAttributeValue;
class FloatColorAttribute;
class FloatColorAttributeValue;
class ByteColorAttribute;
class ByteColorAttributeValue;
class IntAttribute;
class IntAttributeValue;
class Short2Attribute;
class Short2AttributeValue;
class Int2Attribute;
class Int2AttributeValue;
class QuaternionAttribute;
class QuaternionAttributeValue;
class Float4x4Attribute;
class Float4x4AttributeValue;
class StringAttribute;
class StringAttributeValue;
class BoolAttribute;
class BoolAttributeValue;
class Float2Attribute;
class Float2AttributeValue;
class ByteIntAttribute;
class ByteIntAttributeValue;
class AttributeGroupMesh;
class AttributeGroupPointCloud;
class AttributeGroupCurves;
class AttributeGroupGreasePencil;
class AttributeGroupGreasePencilDrawing;
class AssetTag;
class AssetMetaData;
class AssetTags;
class AssetLibraryReference;
class AssetHandle;
class AssetRepresentation;
class AssetCatalogPath;
class AssetWeakReference;
class BoidRule;
class BoidRuleGoal;
class BoidRuleAvoid;
class BoidRuleAvoidCollision;
class BoidRuleFollowLeader;
class BoidRuleAverageSpeed;
class BoidRuleFight;
class BoidState;
class BoidSettings;
class Brush;
class BrushCapabilities;
class BrushCapabilitiesSculpt;
class BrushCapabilitiesImagePaint;
class BrushCapabilitiesVertexPaint;
class BrushCapabilitiesWeightPaint;
class BrushGpencilSettings;
class BrushCurvesSculptSettings;
class BrushTextureSlot;
class OperatorStrokeElement;
class CacheFile;
class CacheFileLayers;
class CacheObjectPaths;
class CacheObjectPath;
class CacheFileLayer;
class Camera;
class CameraBackgroundImage;
class CameraBackgroundImages;
class CameraStereoData;
class CameraDOFSettings;
class ClothSolverResult;
class ClothSettings;
class ClothCollisionSettings;
class Collection;
class CollectionObjects;
class CollectionChildren;
class CollectionLightLinking;
class CollectionObject;
class CollectionChild;
class CollectionExport;
class CurveMapPoint;
class CurveMap;
class CurveMapPoints;
class CurveMapping;
class ColorRampElement;
class ColorRamp;
class ColorRampElements;
class Histogram;
class Scopes;
class ColorManagedDisplaySettings;
class ColorManagedViewSettings;
class ColorManagedInputColorspaceSettings;
class ColorManagedSequencerColorspaceSettings;
class Constraint;
class ConstraintTarget;
class ConstraintTargetBone;
class ChildOfConstraint;
class ArmatureConstraint;
class ArmatureConstraintTargets;
class StretchToConstraint;
class FollowPathConstraint;
class LockedTrackConstraint;
class ActionConstraint;
class CopyScaleConstraint;
class MaintainVolumeConstraint;
class CopyLocationConstraint;
class CopyRotationConstraint;
class CopyTransformsConstraint;
class FloorConstraint;
class TrackToConstraint;
class KinematicConstraint;
class ClampToConstraint;
class LimitDistanceConstraint;
class LimitScaleConstraint;
class LimitRotationConstraint;
class LimitLocationConstraint;
class TransformConstraint;
class ShrinkwrapConstraint;
class DampedTrackConstraint;
class SplineIKConstraint;
class PivotConstraint;
class FollowTrackConstraint;
class CameraSolverConstraint;
class ObjectSolverConstraint;
class TransformCacheConstraint;
class Context;
class Curve;
class CurveSplines;
class SurfaceCurve;
class TextCurve;
class TextBox;
class TextCharacterFormat;
class SplinePoint;
class BezierSplinePoint;
class Spline;
class SplinePoints;
class SplineBezierPoints;
class DynamicPaintCanvasSettings;
class DynamicPaintSurfaces;
class DynamicPaintBrushSettings;
class DynamicPaintSurface;
class FCurve;
class FCurveKeyframePoints;
class FCurveModifiers;
class Keyframe;
class FCurveSample;
class DriverTarget;
class DriverVariable;
class Driver;
class ChannelDriverVariables;
class FModifier;
class FModifierGenerator;
class FModifierFunctionGenerator;
class FModifierEnvelope;
class FModifierEnvelopeControlPoints;
class FModifierEnvelopeControlPoint;
class FModifierCycles;
class FModifierLimits;
class FModifierNoise;
class FModifierStepped;
class GreasePencil;
class GreasePencilLayers;
class GPencilLayer;
class GPencilFrames;
class GPencilFrame;
class GPencilStroke;
class GPencilStrokePoint;
class GreasePencilv3;
class GreasePencilv3Layers;
class GreasePencilv3LayerGroup;
class GreasePencilTreeNode;
class GreasePencilLayer;
class GreasePencilFrames;
class GreasePencilLayerMasks;
class GreasePencilLayerMask;
class GreasePencilLayerGroup;
class GreasePencilFrame;
class GreasePencilDrawing;
class CurvePoint;
class CurveSlice;
class Curves;
class FloatVectorValueReadOnly;
class RenderSlot;
class UDIMTile;
class Image;
class RenderSlots;
class UDIMTiles;
class ImageUser;
class ImagePackedFile;
class Key;
class ShapeKey;
class ShapeKeyPoint;
class ShapeKeyCurvePoint;
class ShapeKeyBezierPoint;
class Light;
class PointLight;
class AreaLight;
class SpotLight;
class SunLight;
class Lattice;
class LatticePoint;
class ViewLayer;
class AOVs;
class Lightgroups;
class LayerObjects;
class FreestyleLineSet;
class FreestyleModuleSettings;
class FreestyleSettings;
class FreestyleModules;
class Linesets;
class LayerCollection;
class ObjectBase;
class LineStyleModifier;
class LineStyleColorModifier;
class LineStyleColorModifier_AlongStroke;
class LineStyleColorModifier_DistanceFromCamera;
class LineStyleColorModifier_DistanceFromObject;
class LineStyleColorModifier_Material;
class LineStyleColorModifier_Tangent;
class LineStyleColorModifier_Noise;
class LineStyleColorModifier_CreaseAngle;
class LineStyleColorModifier_Curvature_3D;
class LineStyleAlphaModifier;
class LineStyleAlphaModifier_AlongStroke;
class LineStyleAlphaModifier_DistanceFromCamera;
class LineStyleAlphaModifier_DistanceFromObject;
class LineStyleAlphaModifier_Material;
class LineStyleAlphaModifier_Tangent;
class LineStyleAlphaModifier_Noise;
class LineStyleAlphaModifier_CreaseAngle;
class LineStyleAlphaModifier_Curvature_3D;
class LineStyleThicknessModifier;
class LineStyleThicknessModifier_Tangent;
class LineStyleThicknessModifier_AlongStroke;
class LineStyleThicknessModifier_DistanceFromCamera;
class LineStyleThicknessModifier_DistanceFromObject;
class LineStyleThicknessModifier_Material;
class LineStyleThicknessModifier_Calligraphy;
class LineStyleThicknessModifier_Noise;
class LineStyleThicknessModifier_Curvature_3D;
class LineStyleThicknessModifier_CreaseAngle;
class LineStyleGeometryModifier;
class LineStyleGeometryModifier_Sampling;
class LineStyleGeometryModifier_BezierCurve;
class LineStyleGeometryModifier_SinusDisplacement;
class LineStyleGeometryModifier_SpatialNoise;
class LineStyleGeometryModifier_PerlinNoise1D;
class LineStyleGeometryModifier_PerlinNoise2D;
class LineStyleGeometryModifier_BackboneStretcher;
class LineStyleGeometryModifier_TipRemover;
class LineStyleGeometryModifier_Polygonalization;
class LineStyleGeometryModifier_GuidingLines;
class LineStyleGeometryModifier_Blueprint;
class LineStyleGeometryModifier_2DOffset;
class LineStyleGeometryModifier_2DTransform;
class LineStyleGeometryModifier_Simplification;
class FreestyleLineStyle;
class LineStyleTextureSlots;
class LineStyleColorModifiers;
class LineStyleAlphaModifiers;
class LineStyleThicknessModifiers;
class LineStyleGeometryModifiers;
class LineStyleTextureSlot;
class BlendImportContextLibrary;
class BlendImportContextItem;
class BlendImportContextLibraries;
class BlendImportContext;
class BlendImportContextItems;
class BlendData;
class BlendDataCameras;
class BlendDataScenes;
class BlendDataObjects;
class BlendDataMaterials;
class BlendDataNodeTrees;
class BlendDataMeshes;
class BlendDataLights;
class BlendDataLibraries;
class BlendDataScreens;
class BlendDataWindowManagers;
class BlendDataImages;
class BlendDataLattices;
class BlendDataCurves;
class BlendDataMetaBalls;
class BlendDataFonts;
class BlendDataTextures;
class BlendDataBrushes;
class BlendDataWorlds;
class BlendDataCollections;
class BlendDataTexts;
class BlendDataSpeakers;
class BlendDataSounds;
class BlendDataArmatures;
class BlendDataActions;
class BlendDataParticles;
class BlendDataPalettes;
class BlendDataGreasePencils;
class BlendDataGreasePencilsV3;
class BlendDataMovieClips;
class BlendDataMasks;
class BlendDataLineStyles;
class BlendDataCacheFiles;
class BlendDataPaintCurves;
class BlendDataWorkSpaces;
class BlendDataProbes;
class BlendDataHairCurves;
class BlendDataPointClouds;
class BlendDataVolumes;
class FluidDomainSettings;
class FluidFlowSettings;
class FluidEffectorSettings;
class Material;
class TexPaintSlot;
class MaterialGPencilStyle;
class MaterialLineArt;
class Mesh;
class MeshVertices;
class MeshEdges;
class MeshLoops;
class MeshPolygons;
class MeshNormalValue;
class MeshLoopTriangles;
class ReadOnlyInteger;
class UVLoopLayers;
class LoopColors;
class MeshSkinVertexLayer;
class MeshSkinVertex;
class MeshVertex;
class VertexGroupElement;
class MeshEdge;
class MeshLoopTriangle;
class MeshLoop;
class MeshPolygon;
class MeshUVLoopLayer;
class MeshUVLoop;
class MeshLoopColorLayer;
class MeshLoopColor;
class MetaElement;
class MetaBall;
class MetaBallElements;
class Modifier;
class SubsurfModifier;
class LatticeModifier;
class CurveModifier;
class BuildModifier;
class MirrorModifier;
class DecimateModifier;
class WaveModifier;
class ArmatureModifier;
class HookModifier;
class SoftBodyModifier;
class BooleanModifier;
class ArrayModifier;
class EdgeSplitModifier;
class DisplaceModifier;
class UVProjectModifier;
class UVProjector;
class SmoothModifier;
class CorrectiveSmoothModifier;
class CastModifier;
class MeshDeformModifier;
class ParticleSystemModifier;
class ParticleInstanceModifier;
class ExplodeModifier;
class ClothModifier;
class CollisionModifier;
class BevelModifier;
class ShrinkwrapModifier;
class MaskModifier;
class SimpleDeformModifier;
class WarpModifier;
class MultiresModifier;
class SurfaceModifier;
class FluidModifier;
class SolidifyModifier;
class ScrewModifier;
class UVWarpModifier;
class VertexWeightEditModifier;
class VertexWeightMixModifier;
class VertexWeightProximityModifier;
class DynamicPaintModifier;
class OceanModifier;
class RemeshModifier;
class SkinModifier;
class LaplacianSmoothModifier;
class TriangulateModifier;
class MeshCacheModifier;
class LaplacianDeformModifier;
class WeldModifier;
class WireframeModifier;
class DataTransferModifier;
class NormalEditModifier;
class MeshSequenceCacheModifier;
class SurfaceDeformModifier;
class WeightedNormalModifier;
class NodesModifierDataBlock;
class NodesModifierBakeDataBlocks;
class NodesModifierBake;
class NodesModifierBakes;
class NodesModifierPanel;
class NodesModifierPanels;
class NodesModifierWarning;
class NodesModifier;
class MeshToVolumeModifier;
class VolumeDisplaceModifier;
class VolumeToMeshModifier;
class GreasePencilOpacityModifier;
class GreasePencilSubdivModifier;
class GreasePencilColorModifier;
class GreasePencilTintModifier;
class GreasePencilSmoothModifier;
class GreasePencilOffsetModifier;
class GreasePencilNoiseModifier;
class GreasePencilMirrorModifier;
class GreasePencilThickModifierData;
class GreasePencilLatticeModifier;
class GreasePencilDashModifierSegment;
class GreasePencilDashModifierData;
class GreasePencilMultiplyModifier;
class GreasePencilLengthModifier;
class GreasePencilWeightAngleModifier;
class GreasePencilArrayModifier;
class GreasePencilWeightProximityModifier;
class GreasePencilHookModifier;
class GreasePencilLineartModifier;
class GreasePencilArmatureModifier;
class GreasePencilTimeModifierSegment;
class GreasePencilTimeModifier;
class GreasePencilSimplifyModifier;
class GreasePencilEnvelopeModifier;
class GreasePencilOutlineModifier;
class GreasePencilShrinkwrapModifier;
class GreasePencilBuildModifier;
class GreasePencilTextureModifier;
class ShaderFx;
class ShaderFxBlur;
class ShaderFxColorize;
class ShaderFxWave;
class ShaderFxPixel;
class ShaderFxRim;
class ShaderFxShadow;
class ShaderFxGlow;
class ShaderFxSwirl;
class ShaderFxFlip;
class NlaTrack;
class NlaStrips;
class NlaStrip;
class NlaStripFCurves;
class Node;
class NodeInputs;
class NodeOutputs;
class NodeLink;
class NodeInternalSocketTemplate;
class NodeInternal;
class ShaderNode;
class CompositorNode;
class CryptomatteEntry;
class TextureNode;
class GeometryNode;
class FunctionNode;
class NodeTree;
class Nodes;
class NodeLinks;
class CompositorNodeTree;
class ShaderNodeTree;
class TextureNodeTree;
class GeometryNodeTree;
class NodeFrame;
class NodeGroup;
class NodeGroupInput;
class NodeGroupOutput;
class NodeReroute;
class ShaderNodeAddShader;
class ShaderNodeAmbientOcclusion;
class ShaderNodeAttribute;
class ShaderNodeBackground;
class ShaderNodeBevel;
class ShaderNodeBlackbody;
class ShaderNodeBrightContrast;
class ShaderNodeBsdfAnisotropic;
class ShaderNodeBsdfDiffuse;
class ShaderNodeBsdfGlass;
class ShaderNodeBsdfHair;
class ShaderNodeBsdfHairPrincipled;
class ShaderNodeBsdfMetallic;
class ShaderNodeBsdfPrincipled;
class ShaderNodeBsdfRayPortal;
class ShaderNodeBsdfRefraction;
class ShaderNodeBsdfSheen;
class ShaderNodeBsdfToon;
class ShaderNodeBsdfTranslucent;
class ShaderNodeBsdfTransparent;
class ShaderNodeBump;
class ShaderNodeCameraData;
class ShaderNodeClamp;
class ShaderNodeCombineColor;
class ShaderNodeCombineHSV;
class ShaderNodeCombineRGB;
class ShaderNodeCombineXYZ;
class ShaderNodeDisplacement;
class ShaderNodeEeveeSpecular;
class ShaderNodeEmission;
class ShaderNodeFloatCurve;
class ShaderNodeFresnel;
class ShaderNodeGamma;
class ShaderNodeHairInfo;
class ShaderNodeHoldout;
class ShaderNodeHueSaturation;
class ShaderNodeInvert;
class ShaderNodeLayerWeight;
class ShaderNodeLightFalloff;
class ShaderNodeLightPath;
class ShaderNodeMapping;
class ShaderNodeMapRange;
class ShaderNodeMath;
class ShaderNodeMix;
class ShaderNodeMixRGB;
class ShaderNodeMixShader;
class ShaderNodeNewGeometry;
class ShaderNodeNormal;
class ShaderNodeNormalMap;
class ShaderNodeObjectInfo;
class ShaderNodeOutputAOV;
class ShaderNodeOutputLight;
class ShaderNodeOutputLineStyle;
class ShaderNodeOutputMaterial;
class ShaderNodeOutputWorld;
class ShaderNodeParticleInfo;
class ShaderNodePointInfo;
class ShaderNodeRGB;
class ShaderNodeRGBCurve;
class ShaderNodeRGBToBW;
class ShaderNodeScript;
class ShaderNodeSeparateColor;
class ShaderNodeSeparateHSV;
class ShaderNodeSeparateRGB;
class ShaderNodeSeparateXYZ;
class ShaderNodeShaderToRGB;
class ShaderNodeSqueeze;
class ShaderNodeSubsurfaceScattering;
class ShaderNodeTangent;
class ShaderNodeTexBrick;
class ShaderNodeTexChecker;
class ShaderNodeTexCoord;
class ShaderNodeTexEnvironment;
class ShaderNodeTexGabor;
class ShaderNodeTexGradient;
class ShaderNodeTexIES;
class ShaderNodeTexImage;
class ShaderNodeTexMagic;
class ShaderNodeTexNoise;
class ShaderNodeTexPointDensity;
class ShaderNodeTexSky;
class ShaderNodeTexVoronoi;
class ShaderNodeTexWave;
class ShaderNodeTexWhiteNoise;
class ShaderNodeUVAlongStroke;
class ShaderNodeUVMap;
class ShaderNodeValToRGB;
class ShaderNodeValue;
class ShaderNodeVectorCurve;
class ShaderNodeVectorDisplacement;
class ShaderNodeVectorMath;
class ShaderNodeVectorRotate;
class ShaderNodeVectorTransform;
class ShaderNodeVertexColor;
class ShaderNodeVolumeAbsorption;
class ShaderNodeVolumeInfo;
class ShaderNodeVolumePrincipled;
class ShaderNodeVolumeScatter;
class ShaderNodeVolumeCoefficients;
class ShaderNodeWavelength;
class ShaderNodeWireframe;
class CompositorNodeAlphaOver;
class CompositorNodeAntiAliasing;
class CompositorNodeBilateralblur;
class CompositorNodeBlur;
class CompositorNodeBokehBlur;
class CompositorNodeBokehImage;
class CompositorNodeBoxMask;
class CompositorNodeBrightContrast;
class CompositorNodeChannelMatte;
class CompositorNodeChromaMatte;
class CompositorNodeColorBalance;
class CompositorNodeColorCorrection;
class CompositorNodeColorMatte;
class CompositorNodeColorSpill;
class CompositorNodeCombHSVA;
class CompositorNodeCombineColor;
class CompositorNodeCombineXYZ;
class CompositorNodeCombRGBA;
class CompositorNodeCombYCCA;
class CompositorNodeCombYUVA;
class CompositorNodeComposite;
class CompositorNodeConvertColorSpace;
class CompositorNodeCornerPin;
class CompositorNodeCrop;
class CompositorNodeCryptomatte;
class CompositorNodeCryptomatteV2;
class CompositorNodeCurveRGB;
class CompositorNodeCurveVec;
class CompositorNodeDBlur;
class CompositorNodeDefocus;
class CompositorNodeDenoise;
class CompositorNodeDespeckle;
class CompositorNodeDiffMatte;
class CompositorNodeDilateErode;
class CompositorNodeDisplace;
class CompositorNodeDistanceMatte;
class CompositorNodeDoubleEdgeMask;
class CompositorNodeEllipseMask;
class CompositorNodeExposure;
class CompositorNodeFilter;
class CompositorNodeFlip;
class CompositorNodeGamma;
class CompositorNodeGlare;
class CompositorNodeHueCorrect;
class CompositorNodeHueSat;
class CompositorNodeIDMask;
class CompositorNodeImage;
class CompositorNodeImageCoordinates;
class CompositorNodeImageInfo;
class CompositorNodeInpaint;
class CompositorNodeInvert;
class CompositorNodeKeying;
class CompositorNodeKeyingScreen;
class CompositorNodeKuwahara;
class CompositorNodeLensdist;
class CompositorNodeLevels;
class CompositorNodeLumaMatte;
class CompositorNodeMapRange;
class CompositorNodeMapUV;
class CompositorNodeMapValue;
class CompositorNodeMask;
class CompositorNodeMath;
class CompositorNodeMixRGB;
class CompositorNodeMovieClip;
class CompositorNodeMovieDistortion;
class CompositorNodeNormal;
class CompositorNodeNormalize;
class CompositorNodeOutputFile;
class NodeOutputFileSlotFile;
class NodeOutputFileSlotLayer;
class CompositorNodeOutputFileFileSlots;
class CompositorNodeOutputFileLayerSlots;
class CompositorNodePixelate;
class CompositorNodePlaneTrackDeform;
class CompositorNodePosterize;
class CompositorNodePremulKey;
class CompositorNodeRelativeToPixel;
class CompositorNodeRGB;
class CompositorNodeRGBToBW;
class CompositorNodeRLayers;
class CompositorNodeRotate;
class CompositorNodeScale;
class CompositorNodeSceneTime;
class CompositorNodeSeparateColor;
class CompositorNodeSeparateXYZ;
class CompositorNodeSepHSVA;
class CompositorNodeSepRGBA;
class CompositorNodeSepYCCA;
class CompositorNodeSepYUVA;
class CompositorNodeSetAlpha;
class CompositorNodeSplit;
class CompositorNodeStabilize;
class CompositorNodeSunBeams;
class CompositorNodeSwitch;
class CompositorNodeSwitchView;
class CompositorNodeTexture;
class CompositorNodeTime;
class CompositorNodeTonemap;
class CompositorNodeTrackPos;
class CompositorNodeTransform;
class CompositorNodeTranslate;
class CompositorNodeValToRGB;
class CompositorNodeValue;
class CompositorNodeVecBlur;
class CompositorNodeViewer;
class CompositorNodeZcombine;
class TextureNodeAt;
class TextureNodeBricks;
class TextureNodeChecker;
class TextureNodeCombineColor;
class TextureNodeCompose;
class TextureNodeCoordinates;
class TextureNodeCurveRGB;
class TextureNodeCurveTime;
class TextureNodeDecompose;
class TextureNodeDistance;
class TextureNodeHueSaturation;
class TextureNodeImage;
class TextureNodeInvert;
class TextureNodeMath;
class TextureNodeMixRGB;
class TextureNodeOutput;
class TextureNodeRGBToBW;
class TextureNodeRotate;
class TextureNodeScale;
class TextureNodeSeparateColor;
class TextureNodeTexBlend;
class TextureNodeTexClouds;
class TextureNodeTexDistNoise;
class TextureNodeTexMagic;
class TextureNodeTexMarble;
class TextureNodeTexMusgrave;
class TextureNodeTexNoise;
class TextureNodeTexStucci;
class TextureNodeTexture;
class TextureNodeTexVoronoi;
class TextureNodeTexWood;
class TextureNodeTranslate;
class TextureNodeValToNor;
class TextureNodeValToRGB;
class TextureNodeViewer;
class FunctionNodeAlignEulerToVector;
class FunctionNodeAlignRotationToVector;
class FunctionNodeAxesToRotation;
class FunctionNodeAxisAngleToRotation;
class FunctionNodeBitMath;
class FunctionNodeBooleanMath;
class FunctionNodeCombineColor;
class FunctionNodeCombineMatrix;
class FunctionNodeCombineTransform;
class FunctionNodeCompare;
class FunctionNodeEulerToRotation;
class FunctionNodeFindInString;
class FunctionNodeFloatToInt;
class FunctionNodeFormatString;
class NodeFunctionFormatStringItem;
class NodeFunctionFormatStringItems;
class FunctionNodeHashValue;
class FunctionNodeInputBool;
class FunctionNodeInputColor;
class FunctionNodeInputInt;
class FunctionNodeInputRotation;
class FunctionNodeInputSpecialCharacters;
class FunctionNodeInputString;
class FunctionNodeInputVector;
class FunctionNodeIntegerMath;
class FunctionNodeInvertMatrix;
class FunctionNodeInvertRotation;
class FunctionNodeMatchString;
class FunctionNodeMatrixDeterminant;
class FunctionNodeMatrixMultiply;
class FunctionNodeProjectPoint;
class FunctionNodeQuaternionToRotation;
class FunctionNodeRandomValue;
class FunctionNodeReplaceString;
class FunctionNodeRotateEuler;
class FunctionNodeRotateRotation;
class FunctionNodeRotateVector;
class FunctionNodeRotationToAxisAngle;
class FunctionNodeRotationToEuler;
class FunctionNodeRotationToQuaternion;
class FunctionNodeSeparateColor;
class FunctionNodeSeparateMatrix;
class FunctionNodeSeparateTransform;
class FunctionNodeSliceString;
class FunctionNodeStringLength;
class FunctionNodeTransformDirection;
class FunctionNodeTransformPoint;
class FunctionNodeTransposeMatrix;
class FunctionNodeValueToString;
class GeometryNodeAccumulateField;
class GeometryNodeAttributeDomainSize;
class GeometryNodeAttributeStatistic;
class GeometryNodeBake;
class NodeGeometryBakeItem;
class NodeGeometryBakeItems;
class GeometryNodeBlurAttribute;
class GeometryNodeBoundBox;
class GeometryNodeCameraInfo;
class GeometryNodeCaptureAttribute;
class NodeGeometryCaptureAttributeItem;
class NodeGeometryCaptureAttributeItems;
class GeometryNodeClosureInput;
class GeometryNodeClosureOutput;
class NodeGeometryClosureInputItem;
class NodeGeometryClosureInputItems;
class NodeGeometryClosureOutputItem;
class NodeGeometryClosureOutputItems;
class GeometryNodeCollectionInfo;
class GeometryNodeCombineBundle;
class NodeGeometryCombineBundleItem;
class NodeGeometryCombineBundleItems;
class GeometryNodeConvexHull;
class GeometryNodeCornersOfEdge;
class GeometryNodeCornersOfFace;
class GeometryNodeCornersOfVertex;
class GeometryNodeCurveArc;
class GeometryNodeCurveEndpointSelection;
class GeometryNodeCurveHandleTypeSelection;
class GeometryNodeCurveLength;
class GeometryNodeCurveOfPoint;
class GeometryNodeCurvePrimitiveBezierSegment;
class GeometryNodeCurvePrimitiveCircle;
class GeometryNodeCurvePrimitiveLine;
class GeometryNodeCurvePrimitiveQuadrilateral;
class GeometryNodeCurveQuadraticBezier;
class GeometryNodeCurveSetHandles;
class GeometryNodeCurveSpiral;
class GeometryNodeCurveSplineType;
class GeometryNodeCurveStar;
class GeometryNodeCurvesToGreasePencil;
class GeometryNodeCurveToMesh;
class GeometryNodeCurveToPoints;
class GeometryNodeDeformCurvesOnSurface;
class GeometryNodeDeleteGeometry;
class GeometryNodeDistributePointsInGrid;
class GeometryNodeDistributePointsInVolume;
class GeometryNodeDistributePointsOnFaces;
class GeometryNodeDualMesh;
class GeometryNodeDuplicateElements;
class GeometryNodeEdgePathsToCurves;
class GeometryNodeEdgePathsToSelection;
class GeometryNodeEdgesOfCorner;
class GeometryNodeEdgesOfVertex;
class GeometryNodeEdgesToFaceGroups;
class GeometryNodeEvaluateClosure;
class NodeGeometryEvaluateClosureInputItem;
class NodeGeometryEvaluateClosureInputItems;
class NodeGeometryEvaluateClosureOutputItem;
class NodeGeometryEvaluateClosureOutputItems;
class GeometryNodeExtrudeMesh;
class GeometryNodeFaceOfCorner;
class GeometryNodeFieldAtIndex;
class GeometryNodeFieldAverage;
class GeometryNodeFieldMinAndMax;
class GeometryNodeFieldOnDomain;
class GeometryNodeFieldVariance;
class GeometryNodeFillCurve;
class GeometryNodeFilletCurve;
class GeometryNodeFlipFaces;
class GeometryNodeForeachGeometryElementInput;
class GeometryNodeForeachGeometryElementOutput;
class ForeachGeometryElementInputItem;
class NodeGeometryForeachGeometryElementInputItems;
class ForeachGeometryElementMainItem;
class NodeGeometryForeachGeometryElementMainItems;
class NodeGeometryForeachGeometryElementGenerationItems;
class ForeachGeometryElementGenerationItem;
class GeometryNodeGeometryToInstance;
class GeometryNodeGetNamedGrid;
class GeometryNodeGizmoDial;
class GeometryNodeGizmoLinear;
class GeometryNodeGizmoTransform;
class GeometryNodeGreasePencilToCurves;
class GeometryNodeGridInfo;
class GeometryNodeGridToMesh;
class GeometryNodeImageInfo;
class GeometryNodeImageTexture;
class GeometryNodeImportCSV;
class GeometryNodeImportOBJ;
class GeometryNodeImportPLY;
class GeometryNodeImportSTL;
class GeometryNodeImportText;
class GeometryNodeImportVDB;
class GeometryNodeIndexOfNearest;
class GeometryNodeIndexSwitch;
class IndexSwitchItem;
class NodeIndexSwitchItems;
class GeometryNodeInputActiveCamera;
class GeometryNodeInputCollection;
class GeometryNodeInputCurveHandlePositions;
class GeometryNodeInputCurveTilt;
class GeometryNodeInputEdgeSmooth;
class GeometryNodeInputID;
class GeometryNodeInputImage;
class GeometryNodeInputIndex;
class GeometryNodeInputInstanceBounds;
class GeometryNodeInputInstanceRotation;
class GeometryNodeInputInstanceScale;
class GeometryNodeInputMaterial;
class GeometryNodeInputMaterialIndex;
class GeometryNodeInputMeshEdgeAngle;
class GeometryNodeInputMeshEdgeNeighbors;
class GeometryNodeInputMeshEdgeVertices;
class GeometryNodeInputMeshFaceArea;
class GeometryNodeInputMeshFaceIsPlanar;
class GeometryNodeInputMeshFaceNeighbors;
class GeometryNodeInputMeshIsland;
class GeometryNodeInputMeshVertexNeighbors;
class GeometryNodeInputNamedAttribute;
class GeometryNodeInputNamedLayerSelection;
class GeometryNodeInputNormal;
class GeometryNodeInputObject;
class GeometryNodeInputPosition;
class GeometryNodeInputRadius;
class GeometryNodeInputSceneTime;
class GeometryNodeInputShadeSmooth;
class GeometryNodeInputShortestEdgePaths;
class GeometryNodeInputSplineCyclic;
class GeometryNodeInputSplineResolution;
class GeometryNodeInputTangent;
class GeometryNodeInstanceOnPoints;
class GeometryNodeInstancesToPoints;
class GeometryNodeInstanceTransform;
class GeometryNodeInterpolateCurves;
class GeometryNodeIsViewport;
class GeometryNodeJoinGeometry;
class GeometryNodeMaterialSelection;
class GeometryNodeMenuSwitch;
class NodeEnumItem;
class NodeMenuSwitchItems;
class GeometryNodeMergeByDistance;
class GeometryNodeMergeLayers;
class GeometryNodeMeshBoolean;
class GeometryNodeMeshCircle;
class GeometryNodeMeshCone;
class GeometryNodeMeshCube;
class GeometryNodeMeshCylinder;
class GeometryNodeMeshFaceSetBoundaries;
class GeometryNodeMeshGrid;
class GeometryNodeMeshIcoSphere;
class GeometryNodeMeshLine;
class GeometryNodeMeshToCurve;
class GeometryNodeMeshToDensityGrid;
class GeometryNodeMeshToPoints;
class GeometryNodeMeshToSDFGrid;
class GeometryNodeMeshToVolume;
class GeometryNodeMeshUVSphere;
class GeometryNodeObjectInfo;
class GeometryNodeOffsetCornerInFace;
class GeometryNodeOffsetPointInCurve;
class GeometryNodePoints;
class GeometryNodePointsOfCurve;
class GeometryNodePointsToCurves;
class GeometryNodePointsToSDFGrid;
class GeometryNodePointsToVertices;
class GeometryNodePointsToVolume;
class GeometryNodeProximity;
class GeometryNodeRaycast;
class GeometryNodeRealizeInstances;
class GeometryNodeRemoveAttribute;
class GeometryNodeRepeatInput;
class GeometryNodeRepeatOutput;
class RepeatItem;
class NodeGeometryRepeatOutputItems;
class GeometryNodeReplaceMaterial;
class GeometryNodeResampleCurve;
class GeometryNodeReverseCurve;
class GeometryNodeRotateInstances;
class GeometryNodeSampleCurve;
class GeometryNodeSampleGrid;
class GeometryNodeSampleGridIndex;
class GeometryNodeSampleIndex;
class GeometryNodeSampleNearest;
class GeometryNodeSampleNearestSurface;
class GeometryNodeSampleUVSurface;
class GeometryNodeScaleElements;
class GeometryNodeScaleInstances;
class GeometryNodeSDFGridBoolean;
class GeometryNodeSelfObject;
class GeometryNodeSeparateBundle;
class NodeGeometrySeparateBundleItem;
class NodeGeometrySeparateBundleItems;
class GeometryNodeSeparateComponents;
class GeometryNodeSeparateGeometry;
class GeometryNodeSetCurveHandlePositions;
class GeometryNodeSetCurveNormal;
class GeometryNodeSetCurveRadius;
class GeometryNodeSetCurveTilt;
class GeometryNodeSetGeometryName;
class GeometryNodeSetGreasePencilColor;
class GeometryNodeSetGreasePencilDepth;
class GeometryNodeSetGreasePencilSoftness;
class GeometryNodeSetID;
class GeometryNodeSetInstanceTransform;
class GeometryNodeSetMaterial;
class GeometryNodeSetMaterialIndex;
class GeometryNodeSetMeshNormal;
class GeometryNodeSetPointRadius;
class GeometryNodeSetPosition;
class GeometryNodeSetShadeSmooth;
class GeometryNodeSetSplineCyclic;
class GeometryNodeSetSplineResolution;
class GeometryNodeSimulationInput;
class GeometryNodeSimulationOutput;
class SimulationStateItem;
class NodeGeometrySimulationOutputItems;
class GeometryNodeSortElements;
class GeometryNodeSplineLength;
class GeometryNodeSplineParameter;
class GeometryNodeSplitEdges;
class GeometryNodeSplitToInstances;
class GeometryNodeStoreNamedAttribute;
class GeometryNodeStoreNamedGrid;
class GeometryNodeStringJoin;
class GeometryNodeStringToCurves;
class GeometryNodeSubdivideCurve;
class GeometryNodeSubdivideMesh;
class GeometryNodeSubdivisionSurface;
class GeometryNodeSwitch;
class GeometryNodeTool3DCursor;
class GeometryNodeToolActiveElement;
class GeometryNodeToolFaceSet;
class GeometryNodeToolMousePosition;
class GeometryNodeToolSelection;
class GeometryNodeToolSetFaceSet;
class GeometryNodeToolSetSelection;
class GeometryNodeTransform;
class GeometryNodeTranslateInstances;
class GeometryNodeTriangulate;
class GeometryNodeTrimCurve;
class GeometryNodeUVPackIslands;
class GeometryNodeUVUnwrap;
class GeometryNodeVertexOfCorner;
class GeometryNodeViewer;
class GeometryNodeViewportTransform;
class GeometryNodeVolumeCube;
class GeometryNodeVolumeToMesh;
class GeometryNodeWarning;
class ShaderNodeGroup;
class CompositorNodeGroup;
class TextureNodeGroup;
class GeometryNodeGroup;
class ShaderNodeCustomGroup;
class CompositorNodeCustomGroup;
class NodeCustomGroup;
class GeometryNodeCustomGroup;
class NodeInstanceHash;
class NodeSocket;
class NodeSocketStandard;
class NodeSocketFloat;
class NodeSocketFloatUnsigned;
class NodeSocketFloatPercentage;
class NodeSocketFloatFactor;
class NodeSocketFloatAngle;
class NodeSocketFloatTime;
class NodeSocketFloatTimeAbsolute;
class NodeSocketFloatDistance;
class NodeSocketFloatWavelength;
class NodeSocketFloatColorTemperature;
class NodeSocketFloatFrequency;
class NodeSocketInt;
class NodeSocketIntUnsigned;
class NodeSocketIntPercentage;
class NodeSocketIntFactor;
class NodeSocketBool;
class NodeSocketRotation;
class NodeSocketMatrix;
class NodeSocketVector;
class NodeSocketVectorFactor;
class NodeSocketVectorPercentage;
class NodeSocketVectorTranslation;
class NodeSocketVectorDirection;
class NodeSocketVectorVelocity;
class NodeSocketVectorAcceleration;
class NodeSocketVectorEuler;
class NodeSocketVectorXYZ;
class NodeSocketVector2D;
class NodeSocketVectorFactor2D;
class NodeSocketVectorPercentage2D;
class NodeSocketVectorTranslation2D;
class NodeSocketVectorDirection2D;
class NodeSocketVectorVelocity2D;
class NodeSocketVectorAcceleration2D;
class NodeSocketVectorEuler2D;
class NodeSocketVectorXYZ2D;
class NodeSocketVector4D;
class NodeSocketVectorFactor4D;
class NodeSocketVectorPercentage4D;
class NodeSocketVectorTranslation4D;
class NodeSocketVectorDirection4D;
class NodeSocketVectorVelocity4D;
class NodeSocketVectorAcceleration4D;
class NodeSocketVectorEuler4D;
class NodeSocketVectorXYZ4D;
class NodeSocketColor;
class NodeSocketString;
class NodeSocketStringFilePath;
class NodeSocketShader;
class NodeSocketObject;
class NodeSocketImage;
class NodeSocketGeometry;
class NodeSocketCollection;
class NodeSocketTexture;
class NodeSocketMaterial;
class NodeSocketMenu;
class NodeSocketBundle;
class NodeSocketClosure;
class NodeSocketVirtual;
class NodeTreeInterfaceItem;
class NodeTreeInterfaceSocket;
class NodeTreeInterfacePanel;
class NodeTreeInterface;
class NodeTreeInterfaceSocketFloat;
class NodeTreeInterfaceSocketFloatUnsigned;
class NodeTreeInterfaceSocketFloatPercentage;
class NodeTreeInterfaceSocketFloatFactor;
class NodeTreeInterfaceSocketFloatAngle;
class NodeTreeInterfaceSocketFloatTime;
class NodeTreeInterfaceSocketFloatTimeAbsolute;
class NodeTreeInterfaceSocketFloatDistance;
class NodeTreeInterfaceSocketFloatWavelength;
class NodeTreeInterfaceSocketFloatColorTemperature;
class NodeTreeInterfaceSocketFloatFrequency;
class NodeTreeInterfaceSocketInt;
class NodeTreeInterfaceSocketIntUnsigned;
class NodeTreeInterfaceSocketIntPercentage;
class NodeTreeInterfaceSocketIntFactor;
class NodeTreeInterfaceSocketBool;
class NodeTreeInterfaceSocketRotation;
class NodeTreeInterfaceSocketMatrix;
class NodeTreeInterfaceSocketVector;
class NodeTreeInterfaceSocketVectorFactor;
class NodeTreeInterfaceSocketVectorPercentage;
class NodeTreeInterfaceSocketVectorTranslation;
class NodeTreeInterfaceSocketVectorDirection;
class NodeTreeInterfaceSocketVectorVelocity;
class NodeTreeInterfaceSocketVectorAcceleration;
class NodeTreeInterfaceSocketVectorEuler;
class NodeTreeInterfaceSocketVectorXYZ;
class NodeTreeInterfaceSocketVector2D;
class NodeTreeInterfaceSocketVectorFactor2D;
class NodeTreeInterfaceSocketVectorPercentage2D;
class NodeTreeInterfaceSocketVectorTranslation2D;
class NodeTreeInterfaceSocketVectorDirection2D;
class NodeTreeInterfaceSocketVectorVelocity2D;
class NodeTreeInterfaceSocketVectorAcceleration2D;
class NodeTreeInterfaceSocketVectorEuler2D;
class NodeTreeInterfaceSocketVectorXYZ2D;
class NodeTreeInterfaceSocketVector4D;
class NodeTreeInterfaceSocketVectorFactor4D;
class NodeTreeInterfaceSocketVectorPercentage4D;
class NodeTreeInterfaceSocketVectorTranslation4D;
class NodeTreeInterfaceSocketVectorDirection4D;
class NodeTreeInterfaceSocketVectorVelocity4D;
class NodeTreeInterfaceSocketVectorAcceleration4D;
class NodeTreeInterfaceSocketVectorEuler4D;
class NodeTreeInterfaceSocketVectorXYZ4D;
class NodeTreeInterfaceSocketColor;
class NodeTreeInterfaceSocketString;
class NodeTreeInterfaceSocketStringFilePath;
class NodeTreeInterfaceSocketShader;
class NodeTreeInterfaceSocketObject;
class NodeTreeInterfaceSocketImage;
class NodeTreeInterfaceSocketGeometry;
class NodeTreeInterfaceSocketCollection;
class NodeTreeInterfaceSocketTexture;
class NodeTreeInterfaceSocketMaterial;
class NodeTreeInterfaceSocketMenu;
class NodeTreeInterfaceSocketBundle;
class NodeTreeInterfaceSocketClosure;
class Object;
class ObjectModifiers;
class ObjectShaderFx;
class ObjectConstraints;
class VertexGroups;
class ParticleSystems;
class VertexGroup;
class MaterialSlot;
class ObjectDisplay;
class ObjectLineArt;
class ObjectLightLinking;
class PointCache;
class PointCaches;
class PointCacheItem;
class CollisionSettings;
class EffectorWeights;
class FieldSettings;
class SoftBodySettings;
class DepsgraphObjectInstance;
class DepsgraphUpdate;
class Depsgraph;
class PackedFile;
class PaletteColor;
class Palette;
class PaletteColors;
class ParticleTarget;
class SPHFluidSettings;
class ParticleHairKey;
class ParticleKey;
class ChildParticle;
class Particle;
class ParticleDupliWeight;
class ParticleSystem;
class ParticleSettingsTextureSlot;
class ParticleSettings;
class ParticleSettingsTextureSlots;
class Point;
class PointCloud;
class Pose;
class PoseBone;
class PoseBoneConstraints;
class IKParam;
class Itasc;
class CurveProfilePoint;
class CurveProfile;
class CurveProfilePoints;
class LightProbe;
class LightProbePlane;
class LightProbeSphere;
class LightProbeVolume;
class RenderEngine;
class HydraRenderEngine;
class RenderResult;
class RenderView;
class RenderLayer;
class RenderPasses;
class RenderPass;
class RigidBodyWorld;
class RigidBodyObject;
class RigidBodyConstraint;
class Scene;
class SceneObjects;
class KeyingSets;
class KeyingSetsAll;
class TimelineMarkers;
class ViewLayers;
class ToolSettings;
class GPencilInterpolateSettings;
class UnifiedPaintSettings;
class CurvePaintSettings;
class SequencerToolSettings;
class MeshStatVis;
class UnitSettings;
class Stereo3dFormat;
class ImageFormatSettings;
class TransformOrientation;
class TransformOrientationSlot;
class View3DCursor;
class SelectedUvElement;
class DisplaySafeAreas;
class SceneDisplay;
class RaytraceEEVEE;
class SceneEEVEE;
class SceneHydra;
class AOV;
class Lightgroup;
class ViewLayerEEVEE;
class SceneGpencil;
class FFmpegSettings;
class RenderSettings;
class RenderViews;
class BakeSettings;
class SceneRenderView;
class Screen;
class Area;
class AreaSpaces;
class Region;
class View2D;
class PaintCurve;
class Paint;
class Sculpt;
class UvSculpt;
class GpPaint;
class GpVertexPaint;
class GpSculptPaint;
class GpWeightPaint;
class VertexPaint;
class PaintModeSettings;
class ImagePaint;
class ParticleEdit;
class ParticleBrush;
class GPencilSculptGuide;
class GPencilSculptSettings;
class CurvesSculpt;
class StripColorBalanceData;
class StripElement;
class RetimingKey;
class StripProxy;
class StripColorBalance;
class StripCrop;
class StripTransform;
class Strip;
class StripModifiers;
class SequenceEditor;
class StripsTopLevel;
class SequenceTimelineChannel;
class ImageStrip;
class StripElements;
class MetaStrip;
class StripsMeta;
class SceneStrip;
class MovieStrip;
class MovieClipStrip;
class MaskStrip;
class SoundStrip;
class EffectStrip;
class AddStrip;
class AdjustmentStrip;
class AlphaOverStrip;
class AlphaUnderStrip;
class ColorStrip;
class CrossStrip;
class GammaCrossStrip;
class GlowStrip;
class MulticamStrip;
class MultiplyStrip;
class SpeedControlStrip;
class SubtractStrip;
class TransformStrip;
class WipeStrip;
class GaussianBlurStrip;
class TextStrip;
class ColorMixStrip;
class StripModifier;
class ColorBalanceModifier;
class CurvesModifier;
class HueCorrectModifier;
class BrightContrastModifier;
class WhiteBalanceModifier;
class SequencerTonemapModifierData;
class SoundEqualizerModifier;
class EQCurveMappingData;
class RetimingKeys;
class Space;
class ViewerPathElem;
class IDViewerPathElem;
class ModifierViewerPathElem;
class GroupNodeViewerPathElem;
class SimulationZoneViewerPathElem;
class RepeatZoneViewerPathElem;
class ForeachGeometryElementZoneViewerPathElem;
class EvaluateClosureNodeViewerPathElem;
class ViewerNodeViewerPathElem;
class ViewerPath;
class SpaceImageEditor;
class SpaceUVEditor;
class SpaceImageOverlay;
class SpaceSequenceEditor;
class SequencerPreviewOverlay;
class SequencerTimelineOverlay;
class SequencerCacheOverlay;
class SpaceTextEditor;
class FileSelectEntry;
class FileSelectParams;
class FileAssetSelectParams;
class FileSelectIDFilter;
class FileAssetSelectIDFilter;
class FileBrowserFSMenuEntry;
class SpaceFileBrowser;
class SpaceOutliner;
class SpaceView3D;
class View3DShading;
class View3DOverlay;
class RegionView3D;
class SpaceProperties;
class SpaceDopeSheetEditor;
class SpaceGraphEditor;
class SpaceNLA;
class SpaceConsole;
class ConsoleLine;
class SpaceInfo;
class SpacePreferences;
class NodeTreePath;
class SpaceNodeEditor;
class SpaceNodeEditorPath;
class SpaceNodeOverlay;
class SpaceClipEditor;
class SpreadsheetTableID;
class SpreadsheetTableIDGeometry;
class SpreadsheetColumn;
class SpreadsheetColumnID;
class SpreadsheetTable;
class SpreadsheetTables;
class SpaceSpreadsheet;
class SpreadsheetRowFilter;
class Speaker;
class TextLine;
class Text;
class TimelineMarker;
class Sound;
class UILayout;
class Panel;
class UIList;
class Header;
class Menu;
class AssetShelf;
class FileHandler;
class LayoutPanelState;
class USDHook;
class ThemeFontStyle;
class ThemeStyle;
class ThemeWidgetColors;
class ThemeWidgetStateColors;
class ThemePanelColors;
class ThemeGradientColors;
class ThemeUserInterface;
class ThemeSpaceGeneric;
class ThemeSpaceGradient;
class ThemeSpaceListGeneric;
class ThemeAssetShelf;
class ThemeView3D;
class ThemeGraphEditor;
class ThemeFileBrowser;
class ThemeNLAEditor;
class ThemeDopeSheet;
class ThemeImageEditor;
class ThemeSequenceEditor;
class ThemeProperties;
class ThemeTextEditor;
class ThemeNodeEditor;
class ThemeOutliner;
class ThemeInfo;
class ThemePreferences;
class ThemeConsole;
class ThemeClipEditor;
class ThemeTopBar;
class ThemeStatusBar;
class ThemeSpreadsheet;
class ThemeBoneColorSet;
class ThemeCollectionColor;
class ThemeStripColor;
class Theme;
class UserSolidLight;
class WalkNavigation;
class Preferences;
class Addons;
class PathCompareCollection;
class PreferencesView;
class PreferencesEdit;
class PreferencesInput;
class PreferencesKeymap;
class PreferencesFilePaths;
class ScriptDirectory;
class ScriptDirectoryCollection;
class UserAssetLibrary;
class AssetLibraryCollection;
class PreferencesExtensions;
class UserExtensionRepo;
class UserExtensionRepoCollection;
class PreferencesSystem;
class Addon;
class AddonPreferences;
class StudioLights;
class StudioLight;
class PathCompare;
class PreferencesApps;
class PreferencesExperimental;
class VectorFont;
class VolumeGrid;
class VolumeDisplay;
class VolumeRender;
class Volume;
class VolumeGrids;
class Operator;
class OperatorProperties;
class OperatorOptions;
class OperatorMousePath;
class OperatorFileListElement;
class Macro;
class OperatorMacro;
class NDOFMotionEventData;
class Event;
class Timer;
class UIPopupMenu;
class UIPopover;
class UIPieMenu;
class Window;
class Stereo3dDisplay;
class WindowManager;
class KeyConfigurations;
class KeyConfigPreferences;
class KeyConfig;
class KeyMaps;
class KeyMap;
class KeyMapItems;
class KeyMapItem;
class GizmoGroup;
class Gizmo;
class GizmoProperties;
class Gizmos;
class GizmoGroupProperties;
class wmOwnerID;
class WorkSpaceTool;
class WorkSpace;
class wmOwnerIDs;
class wmTools;
class World;
class WorldLighting;
class WorldMistSettings;
class MovieClip;
class MovieClipProxy;
class MovieClipUser;
class MovieClipScopes;
class MovieTrackingSettings;
class MovieTrackingCamera;
class MovieTrackingMarker;
class MovieTrackingTrack;
class MovieTrackingMarkers;
class MovieTrackingPlaneMarker;
class MovieTrackingPlaneTrack;
class MovieTrackingPlaneMarkers;
class MovieTrackingTracks;
class MovieTrackingPlaneTracks;
class MovieTrackingObjectTracks;
class MovieTrackingObjectPlaneTracks;
class MovieTrackingStabilization;
class MovieTrackingReconstructedCameras;
class MovieReconstructedCamera;
class MovieTrackingReconstruction;
class MovieTrackingObject;
class MovieTrackingDopesheet;
class MovieTracking;
class MovieTrackingObjects;
class MaskParent;
class MaskSplinePointUW;
class MaskSplinePoint;
class MaskSpline;
class MaskSplines;
class MaskSplinePoints;
class MaskLayer;
class Mask;
class MaskLayers;
class XrActionMap;
class XrActionMapItems;
class XrUserPath;
class XrActionMapItem;
class XrUserPaths;
class XrActionMapBindings;
class XrComponentPath;
class XrActionMapBinding;
class XrComponentPaths;
class XrSessionSettings;
class XrSessionState;
class XrActionMaps;
class XrEventData;

/**************** Struct Definition ****************/

class Struct : public Pointer {
public:
	Struct(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		properties(ptr_arg),
		functions(ptr_arg),
		property_tags(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline std::string identifier(void);
	inline void identifier(const std::string& value);
	inline std::string description(void);
	inline void description(const std::string& value);
	inline std::string translation_context(void);
	inline void translation_context(const std::string& value);
	inline Struct base(void);
	inline Struct nested(void);
	inline StringProperty name_property(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Property, Struct, properties, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Function, Struct, functions, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, EnumPropertyItem, Struct, property_tags, false, false, false)

};

/**************** Property Definition ****************/

class Property : public Pointer {
public:
	Property(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline std::string identifier(void);
	inline void identifier(const std::string& value);
	inline std::string description(void);
	inline void description(const std::string& value);
	inline std::string translation_context(void);
	inline void translation_context(const std::string& value);
	enum type_enum {
		type_BOOLEAN = 0,
		type_INT = 1,
		type_FLOAT = 2,
		type_STRING = 3,
		type_ENUM = 4,
		type_POINTER = 5,
		type_COLLECTION = 6,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum subtype_enum {
		subtype_NONE = 0,
		subtype_FILE_PATH = 1,
		subtype_DIR_PATH = 2,
		subtype_FILE_NAME = 3,
		subtype_BYTE_STRING = 4,
		subtype_PASSWORD = 6,
		subtype_PIXEL = 12,
		subtype_UNSIGNED = 13,
		subtype_PERCENTAGE = 14,
		subtype_FACTOR = 15,
		subtype_ANGLE = 327696,
		subtype_TIME = 393233,
		subtype_TIME_ABSOLUTE = 458769,
		subtype_DISTANCE = 65554,
		subtype_DISTANCE_CAMERA = 655379,
		subtype_POWER = 720938,
		subtype_TEMPERATURE = 786475,
		subtype_WAVELENGTH = 852012,
		subtype_COLOR_TEMPERATURE = 917549,
		subtype_FREQUENCY = 983086,
		subtype_COLOR = 20,
		subtype_TRANSLATION = 65557,
		subtype_DIRECTION = 22,
		subtype_VELOCITY = 524311,
		subtype_ACCELERATION = 589848,
		subtype_MATRIX = 25,
		subtype_EULER = 327706,
		subtype_QUATERNION = 27,
		subtype_AXISANGLE = 28,
		subtype_XYZ = 29,
		subtype_XYZ_LENGTH = 65565,
		subtype_COLOR_GAMMA = 30,
		subtype_COORDINATES = 31,
		subtype_LAYER = 40,
		subtype_LAYER_MEMBER = 41,
	};
	inline subtype_enum subtype(void);
	inline void subtype(subtype_enum value);
	inline Struct srna(void);
	enum unit_enum {
		unit_NONE = 0,
		unit_LENGTH = 65536,
		unit_AREA = 131072,
		unit_VOLUME = 196608,
		unit_ROTATION = 327680,
		unit_TIME = 393216,
		unit_TIME_ABSOLUTE = 458752,
		unit_VELOCITY = 524288,
		unit_ACCELERATION = 589824,
		unit_MASS = 262144,
		unit_CAMERA = 655360,
		unit_POWER = 720896,
		unit_TEMPERATURE = 786432,
		unit_WAVELENGTH = 851968,
		unit_COLOR_TEMPERATURE = 917504,
		unit_FREQUENCY = 983040,
	};
	inline unit_enum unit(void);
	inline void unit(unit_enum value);
	enum icon_enum {
		icon_NONE = 0,
		icon_CHAR_NOTDEF = 1,
		icon_CHAR_REPLACEMENT = 2,
		icon_NOT_FOUND = 3,
		icon_BLANK1 = 4,
		icon_AUTOMERGE_OFF = 5,
		icon_AUTOMERGE_ON = 6,
		icon_CHECKBOX_DEHLT = 7,
		icon_CHECKBOX_HLT = 8,
		icon_CLIPUV_DEHLT = 9,
		icon_CLIPUV_HLT = 10,
		icon_DECORATE_UNLOCKED = 11,
		icon_DECORATE_LOCKED = 12,
		icon_FAKE_USER_OFF = 13,
		icon_FAKE_USER_ON = 14,
		icon_HIDE_ON = 15,
		icon_HIDE_OFF = 16,
		icon_INDIRECT_ONLY_OFF = 17,
		icon_INDIRECT_ONLY_ON = 18,
		icon_ONIONSKIN_OFF = 19,
		icon_ONIONSKIN_ON = 20,
		icon_UNPINNED = 21,
		icon_PINNED = 22,
		icon_RADIOBUT_OFF = 23,
		icon_RADIOBUT_ON = 24,
		icon_RECORD_OFF = 25,
		icon_RECORD_ON = 26,
		icon_RESTRICT_RENDER_ON = 27,
		icon_RESTRICT_RENDER_OFF = 28,
		icon_RESTRICT_SELECT_ON = 29,
		icon_RESTRICT_SELECT_OFF = 30,
		icon_RESTRICT_VIEW_ON = 31,
		icon_RESTRICT_VIEW_OFF = 32,
		icon_RIGHTARROW = 33,
		icon_DOWNARROW_HLT = 34,
		icon_SELECT_INTERSECT = 35,
		icon_SELECT_DIFFERENCE = 36,
		icon_SNAP_OFF = 37,
		icon_SNAP_ON = 38,
		icon_UNLOCKED = 39,
		icon_LOCKED = 40,
		icon_VIS_SEL_11 = 41,
		icon_VIS_SEL_10 = 42,
		icon_VIS_SEL_01 = 43,
		icon_VIS_SEL_00 = 44,
		icon_CANCEL = 45,
		icon_ERROR = 46,
		icon_QUESTION = 47,
		icon_ADD = 48,
		icon_ARROW_LEFTRIGHT = 49,
		icon_AUTO = 50,
		icon_BLENDER = 51,
		icon_BORDERMOVE = 52,
		icon_BRUSHES_ALL = 53,
		icon_CHECKMARK = 54,
		icon_COLLAPSEMENU = 55,
		icon_COLLECTION_NEW = 56,
		icon_COLOR = 57,
		icon_COPY_ID = 58,
		icon_DISCLOSURE_TRI_DOWN = 59,
		icon_DISCLOSURE_TRI_RIGHT = 60,
		icon_DOT = 61,
		icon_DRIVER_DISTANCE = 62,
		icon_DRIVER_ROTATIONAL_DIFFERENCE = 63,
		icon_DRIVER_TRANSFORM = 64,
		icon_DUPLICATE = 65,
		icon_EYEDROPPER = 66,
		icon_FCURVE_SNAPSHOT = 67,
		icon_FILE_NEW = 68,
		icon_FILE_TICK = 69,
		icon_FREEZE = 70,
		icon_FULLSCREEN_ENTER = 71,
		icon_FULLSCREEN_EXIT = 72,
		icon_GHOST_DISABLED = 73,
		icon_GHOST_ENABLED = 74,
		icon_GRIP = 75,
		icon_GRIP_V = 76,
		icon_HAND = 77,
		icon_HELP = 78,
		icon_LINKED = 79,
		icon_MENU_PANEL = 80,
		icon_NODE_SEL = 81,
		icon_NODE = 82,
		icon_OBJECT_HIDDEN = 83,
		icon_OPTIONS = 84,
		icon_PANEL_CLOSE = 85,
		icon_PLUGIN = 86,
		icon_PLUS = 87,
		icon_PRESET_NEW = 88,
		icon_QUIT = 89,
		icon_RECOVER_LAST = 90,
		icon_REMOVE = 91,
		icon_RIGHTARROW_THIN = 92,
		icon_SCREEN_BACK = 93,
		icon_STATUSBAR = 94,
		icon_STYLUS_PRESSURE = 95,
		icon_THREE_DOTS = 96,
		icon_TOPBAR = 97,
		icon_TRASH = 98,
		icon_TRIA_DOWN = 99,
		icon_TRIA_LEFT = 100,
		icon_TRIA_RIGHT = 101,
		icon_TRIA_UP = 102,
		icon_UNLINKED = 103,
		icon_URL = 104,
		icon_VIEWZOOM = 105,
		icon_WINDOW = 106,
		icon_WORKSPACE = 107,
		icon_X = 108,
		icon_ZOOM_ALL = 109,
		icon_ZOOM_IN = 110,
		icon_ZOOM_OUT = 111,
		icon_ZOOM_PREVIOUS = 112,
		icon_ZOOM_SELECTED = 113,
		icon_MODIFIER = 114,
		icon_PARTICLES = 115,
		icon_PHYSICS = 116,
		icon_SHADERFX = 117,
		icon_SPEAKER = 118,
		icon_OUTPUT = 119,
		icon_SCENE = 120,
		icon_TOOL_SETTINGS = 121,
		icon_LIGHT = 122,
		icon_MATERIAL = 123,
		icon_TEXTURE = 124,
		icon_WORLD = 125,
		icon_ANIM = 126,
		icon_SCRIPT = 127,
		icon_GEOMETRY_NODES = 128,
		icon_TEXT = 129,
		icon_ACTION = 130,
		icon_ASSET_MANAGER = 131,
		icon_CONSOLE = 132,
		icon_FILEBROWSER = 133,
		icon_GEOMETRY_SET = 134,
		icon_GRAPH = 135,
		icon_IMAGE = 136,
		icon_INFO = 137,
		icon_NLA = 138,
		icon_NODE_COMPOSITING = 139,
		icon_NODE_MATERIAL = 140,
		icon_NODE_TEXTURE = 141,
		icon_NODETREE = 142,
		icon_OUTLINER = 143,
		icon_PREFERENCES = 144,
		icon_PROPERTIES = 145,
		icon_SEQUENCE = 146,
		icon_SOUND = 147,
		icon_SPREADSHEET = 148,
		icon_TIME = 149,
		icon_TRACKER = 150,
		icon_UV = 151,
		icon_VIEW3D = 152,
		icon_EDITMODE_HLT = 153,
		icon_OBJECT_DATAMODE = 154,
		icon_PARTICLEMODE = 155,
		icon_POSE_HLT = 156,
		icon_SCULPTMODE_HLT = 157,
		icon_TPAINT_HLT = 158,
		icon_UV_DATA = 159,
		icon_VPAINT_HLT = 160,
		icon_WPAINT_HLT = 161,
		icon_TRACKER_DATA = 162,
		icon_TRACKING_BACKWARDS_SINGLE = 163,
		icon_TRACKING_BACKWARDS = 164,
		icon_TRACKING_CLEAR_BACKWARDS = 165,
		icon_TRACKING_CLEAR_FORWARDS = 166,
		icon_TRACKING_FORWARDS_SINGLE = 167,
		icon_TRACKING_FORWARDS = 168,
		icon_TRACKING_REFINE_BACKWARDS = 169,
		icon_TRACKING_REFINE_FORWARDS = 170,
		icon_TRACKING = 171,
		icon_GROUP = 172,
		icon_CONSTRAINT_BONE = 173,
		icon_CONSTRAINT = 174,
		icon_ARMATURE_DATA = 175,
		icon_BONE_DATA = 176,
		icon_CAMERA_DATA = 177,
		icon_CURVE_DATA = 178,
		icon_EMPTY_DATA = 179,
		icon_FONT_DATA = 180,
		icon_LATTICE_DATA = 181,
		icon_LIGHT_DATA = 182,
		icon_MESH_DATA = 183,
		icon_META_DATA = 184,
		icon_PARTICLE_DATA = 185,
		icon_SHAPEKEY_DATA = 186,
		icon_SURFACE_DATA = 187,
		icon_OBJECT_DATA = 188,
		icon_RENDER_RESULT = 189,
		icon_RENDERLAYERS = 190,
		icon_SCENE_DATA = 191,
		icon_BRUSH_DATA = 192,
		icon_IMAGE_DATA = 193,
		icon_LINE_DATA = 194,
		icon_MATERIAL_DATA = 195,
		icon_TEXTURE_DATA = 196,
		icon_WORLD_DATA = 197,
		icon_ANIM_DATA = 198,
		icon_BOIDS = 199,
		icon_CAMERA_STEREO = 200,
		icon_COMMUNITY = 201,
		icon_FACE_MAPS = 202,
		icon_FCURVE = 203,
		icon_FILE = 204,
		icon_GREASEPENCIL = 205,
		icon_GREASEPENCIL_LAYER_GROUP = 206,
		icon_GROUP_BONE = 207,
		icon_GROUP_UVS = 208,
		icon_GROUP_VCOL = 209,
		icon_GROUP_VERTEX = 210,
		icon_LIBRARY_DATA_BROKEN = 211,
		icon_LIBRARY_DATA_DIRECT = 212,
		icon_LIBRARY_DATA_OVERRIDE = 213,
		icon_ORPHAN_DATA = 214,
		icon_PACKAGE = 215,
		icon_PRESET = 216,
		icon_RENDER_ANIMATION = 217,
		icon_RENDER_STILL = 218,
		icon_RNA_ADD = 219,
		icon_RNA = 220,
		icon_STRANDS = 221,
		icon_UGLYPACKAGE = 222,
		icon_MOUSE_LMB = 223,
		icon_MOUSE_MMB = 224,
		icon_MOUSE_RMB = 225,
		icon_MOUSE_MMB_SCROLL = 226,
		icon_MOUSE_LMB_2X = 227,
		icon_MOUSE_MOVE = 228,
		icon_MOUSE_LMB_DRAG = 229,
		icon_MOUSE_MMB_DRAG = 230,
		icon_MOUSE_RMB_DRAG = 231,
		icon_DECORATE_ANIMATE = 232,
		icon_DECORATE_DRIVER = 233,
		icon_DECORATE_KEYFRAME = 234,
		icon_DECORATE_LIBRARY_OVERRIDE = 235,
		icon_DECORATE_LINKED = 236,
		icon_DECORATE_OVERRIDE = 237,
		icon_DECORATE = 238,
		icon_OUTLINER_COLLECTION = 239,
		icon_CURVES_DATA = 240,
		icon_OUTLINER_DATA_ARMATURE = 241,
		icon_OUTLINER_DATA_CAMERA = 242,
		icon_OUTLINER_DATA_CURVE = 243,
		icon_OUTLINER_DATA_CURVES = 244,
		icon_OUTLINER_DATA_EMPTY = 245,
		icon_OUTLINER_DATA_FONT = 246,
		icon_OUTLINER_DATA_GP_LAYER = 247,
		icon_OUTLINER_DATA_GREASEPENCIL = 248,
		icon_OUTLINER_DATA_LATTICE = 249,
		icon_OUTLINER_DATA_LIGHT = 250,
		icon_OUTLINER_DATA_LIGHTPROBE = 251,
		icon_OUTLINER_DATA_MESH = 252,
		icon_OUTLINER_DATA_META = 253,
		icon_OUTLINER_DATA_POINTCLOUD = 254,
		icon_OUTLINER_DATA_SPEAKER = 255,
		icon_OUTLINER_DATA_SURFACE = 256,
		icon_OUTLINER_DATA_VOLUME = 257,
		icon_POINTCLOUD_DATA = 258,
		icon_POINTCLOUD_POINT = 259,
		icon_VOLUME_DATA = 260,
		icon_OUTLINER_OB_ARMATURE = 261,
		icon_OUTLINER_OB_CAMERA = 262,
		icon_OUTLINER_OB_CURVE = 263,
		icon_OUTLINER_OB_CURVES = 264,
		icon_OUTLINER_OB_EMPTY = 265,
		icon_OUTLINER_OB_FONT = 266,
		icon_OUTLINER_OB_FORCE_FIELD = 267,
		icon_OUTLINER_OB_GREASEPENCIL = 268,
		icon_OUTLINER_OB_GROUP_INSTANCE = 269,
		icon_OUTLINER_OB_IMAGE = 270,
		icon_OUTLINER_OB_LATTICE = 271,
		icon_OUTLINER_OB_LIGHT = 272,
		icon_OUTLINER_OB_LIGHTPROBE = 273,
		icon_OUTLINER_OB_MESH = 274,
		icon_OUTLINER_OB_META = 275,
		icon_OUTLINER_OB_POINTCLOUD = 276,
		icon_OUTLINER_OB_SPEAKER = 277,
		icon_OUTLINER_OB_SURFACE = 278,
		icon_OUTLINER_OB_VOLUME = 279,
		icon_GP_MULTIFRAME_EDITING = 280,
		icon_GP_ONLY_SELECTED = 281,
		icon_GP_SELECT_BETWEEN_STROKES = 282,
		icon_GP_SELECT_POINTS = 283,
		icon_GP_SELECT_STROKES = 284,
		icon_HOLDOUT_OFF = 285,
		icon_HOLDOUT_ON = 286,
		icon_MODIFIER_OFF = 287,
		icon_MODIFIER_ON = 288,
		icon_RESTRICT_COLOR_OFF = 289,
		icon_RESTRICT_COLOR_ON = 290,
		icon_RESTRICT_INSTANCED_OFF = 291,
		icon_RESTRICT_INSTANCED_ON = 292,
		icon_LIGHT_AREA = 293,
		icon_LIGHT_HEMI = 294,
		icon_LIGHT_POINT = 295,
		icon_LIGHT_SPOT = 296,
		icon_LIGHT_SUN = 297,
		icon_LIGHTPROBE_PLANE = 298,
		icon_LIGHTPROBE_SPHERE = 299,
		icon_LIGHTPROBE_VOLUME = 300,
		icon_COLOR_BLUE = 301,
		icon_COLOR_GREEN = 302,
		icon_COLOR_RED = 303,
		icon_CONE = 304,
		icon_CUBE = 305,
		icon_CURVE_BEZCIRCLE = 306,
		icon_CURVE_BEZCURVE = 307,
		icon_CURVE_NCIRCLE = 308,
		icon_CURVE_NCURVE = 309,
		icon_CURVE_PATH = 310,
		icon_CURVES = 311,
		icon_EMPTY_ARROWS = 312,
		icon_EMPTY_AXIS = 313,
		icon_EMPTY_SINGLE_ARROW = 314,
		icon_MESH_CAPSULE = 315,
		icon_MESH_CIRCLE = 316,
		icon_MESH_CONE = 317,
		icon_MESH_CUBE = 318,
		icon_MESH_CYLINDER = 319,
		icon_MESH_GRID = 320,
		icon_MESH_ICOSPHERE = 321,
		icon_MESH_MONKEY = 322,
		icon_MESH_PLANE = 323,
		icon_MESH_TORUS = 324,
		icon_MESH_UVSPHERE = 325,
		icon_META_BALL = 326,
		icon_META_CAPSULE = 327,
		icon_META_CUBE = 328,
		icon_META_ELLIPSOID = 329,
		icon_META_PLANE = 330,
		icon_MONKEY = 331,
		icon_SPHERE = 332,
		icon_STROKE = 333,
		icon_SURFACE_NCIRCLE = 334,
		icon_SURFACE_NCURVE = 335,
		icon_SURFACE_NCYLINDER = 336,
		icon_SURFACE_NSPHERE = 337,
		icon_SURFACE_NSURFACE = 338,
		icon_SURFACE_NTORUS = 339,
		icon_TRIA_DOWN_BAR = 340,
		icon_TRIA_LEFT_BAR = 341,
		icon_TRIA_RIGHT_BAR = 342,
		icon_TRIA_UP_BAR = 343,
		icon_AREA_DOCK = 344,
		icon_AREA_JOIN_DOWN = 345,
		icon_AREA_JOIN_LEFT = 346,
		icon_AREA_JOIN_UP = 347,
		icon_AREA_JOIN = 348,
		icon_AREA_SWAP = 349,
		icon_FORCE_BOID = 350,
		icon_FORCE_CHARGE = 351,
		icon_FORCE_CURVE = 352,
		icon_FORCE_DRAG = 353,
		icon_FORCE_FLUIDFLOW = 354,
		icon_FORCE_FORCE = 355,
		icon_FORCE_HARMONIC = 356,
		icon_FORCE_LENNARDJONES = 357,
		icon_FORCE_MAGNETIC = 358,
		icon_FORCE_TEXTURE = 359,
		icon_FORCE_TURBULENCE = 360,
		icon_FORCE_VORTEX = 361,
		icon_FORCE_WIND = 362,
		icon_IMAGE_BACKGROUND = 363,
		icon_IMAGE_PLANE = 364,
		icon_IMAGE_REFERENCE = 365,
		icon_RIGID_BODY_CONSTRAINT = 366,
		icon_RIGID_BODY = 367,
		icon_SPLIT_HORIZONTAL = 368,
		icon_SPLIT_VERTICAL = 369,
		icon_ANCHOR_BOTTOM = 370,
		icon_ANCHOR_CENTER = 371,
		icon_ANCHOR_LEFT = 372,
		icon_ANCHOR_RIGHT = 373,
		icon_ANCHOR_TOP = 374,
		icon_NODE_CORNER = 375,
		icon_NODE_INSERT_OFF = 376,
		icon_NODE_INSERT_ON = 377,
		icon_NODE_SIDE = 378,
		icon_NODE_TOP = 379,
		icon_SELECT_EXTEND = 380,
		icon_SELECT_SET = 381,
		icon_SELECT_SUBTRACT = 382,
		icon_ALIGN_BOTTOM = 383,
		icon_ALIGN_CENTER = 384,
		icon_ALIGN_FLUSH = 385,
		icon_ALIGN_JUSTIFY = 386,
		icon_ALIGN_LEFT = 387,
		icon_ALIGN_MIDDLE = 388,
		icon_ALIGN_RIGHT = 389,
		icon_ALIGN_TOP = 390,
		icon_BOLD = 391,
		icon_ITALIC = 392,
		icon_LINENUMBERS_OFF = 393,
		icon_LINENUMBERS_ON = 394,
		icon_SCRIPTPLUGINS = 395,
		icon_SMALL_CAPS = 396,
		icon_SYNTAX_OFF = 397,
		icon_SYNTAX_ON = 398,
		icon_UNDERLINE = 399,
		icon_WORDWRAP_OFF = 400,
		icon_WORDWRAP_ON = 401,
		icon_CON_ACTION = 402,
		icon_CON_ARMATURE = 403,
		icon_CON_CAMERASOLVER = 404,
		icon_CON_CHILDOF = 405,
		icon_CON_CLAMPTO = 406,
		icon_CON_DISTLIMIT = 407,
		icon_CON_FLOOR = 408,
		icon_CON_FOLLOWPATH = 409,
		icon_CON_FOLLOWTRACK = 410,
		icon_CON_KINEMATIC = 411,
		icon_CON_LOCKTRACK = 412,
		icon_CON_LOCLIKE = 413,
		icon_CON_LOCLIMIT = 414,
		icon_CON_OBJECTSOLVER = 415,
		icon_CON_PIVOT = 416,
		icon_CON_ROTLIKE = 417,
		icon_CON_ROTLIMIT = 418,
		icon_CON_SAMEVOL = 419,
		icon_CON_SHRINKWRAP = 420,
		icon_CON_SIZELIKE = 421,
		icon_CON_SIZELIMIT = 422,
		icon_CON_SPLINEIK = 423,
		icon_CON_STRETCHTO = 424,
		icon_CON_TRACKTO = 425,
		icon_CON_TRANSFORM_CACHE = 426,
		icon_CON_TRANSFORM = 427,
		icon_CON_TRANSLIKE = 428,
		icon_HOOK = 429,
		icon_MOD_ARMATURE = 430,
		icon_MOD_ARRAY = 431,
		icon_MOD_BEVEL = 432,
		icon_MOD_BOOLEAN = 433,
		icon_MOD_BUILD = 434,
		icon_MOD_CAST = 435,
		icon_MOD_CLOTH = 436,
		icon_MOD_CURVE = 437,
		icon_MOD_DASH = 438,
		icon_MOD_DATA_TRANSFER = 439,
		icon_MOD_DECIM = 440,
		icon_MOD_DISPLACE = 441,
		icon_MOD_DYNAMICPAINT = 442,
		icon_MOD_EDGESPLIT = 443,
		icon_MOD_ENVELOPE = 444,
		icon_MOD_EXPLODE = 445,
		icon_MOD_FLUID = 446,
		icon_MOD_FLUIDSIM = 447,
		icon_MOD_HUE_SATURATION = 448,
		icon_MOD_INSTANCE = 449,
		icon_MOD_LATTICE = 450,
		icon_MOD_LENGTH = 451,
		icon_MOD_LINEART = 452,
		icon_MOD_MASK = 453,
		icon_MOD_MESHDEFORM = 454,
		icon_MOD_MIRROR = 455,
		icon_MOD_MULTIRES = 456,
		icon_MOD_NOISE = 457,
		icon_MOD_NORMALEDIT = 458,
		icon_MOD_OCEAN = 459,
		icon_MOD_OFFSET = 460,
		icon_MOD_OPACITY = 461,
		icon_MOD_OUTLINE = 462,
		icon_MOD_PARTICLE_INSTANCE = 463,
		icon_MOD_PARTICLES = 464,
		icon_MOD_PHYSICS = 465,
		icon_MOD_REMESH = 466,
		icon_MOD_SCREW = 467,
		icon_MOD_SHRINKWRAP = 468,
		icon_MOD_SIMPLEDEFORM = 469,
		icon_MOD_SIMPLIFY = 470,
		icon_MOD_SKIN = 471,
		icon_MOD_SMOOTH = 472,
		icon_MOD_SOFT = 473,
		icon_MOD_SOLIDIFY = 474,
		icon_MOD_SUBSURF = 475,
		icon_MOD_THICKNESS = 476,
		icon_MOD_TIME = 477,
		icon_MOD_TINT = 478,
		icon_MOD_TRIANGULATE = 479,
		icon_MOD_UVPROJECT = 480,
		icon_MOD_VERTEX_WEIGHT = 481,
		icon_MOD_WARP = 482,
		icon_MOD_WAVE = 483,
		icon_MOD_WIREFRAME = 484,
		icon_MODIFIER_DATA = 485,
		icon_ACTION_SLOT = 486,
		icon_ACTION_TWEAK = 487,
		icon_DRIVER = 488,
		icon_FF = 489,
		icon_FRAME_NEXT = 490,
		icon_FRAME_PREV = 491,
		icon_HANDLE_ALIGNED = 492,
		icon_HANDLE_AUTO = 493,
		icon_HANDLE_AUTOCLAMPED = 494,
		icon_HANDLE_FREE = 495,
		icon_HANDLE_VECTOR = 496,
		icon_IPO_BACK = 497,
		icon_IPO_BEZIER = 498,
		icon_IPO_BOUNCE = 499,
		icon_IPO_CIRC = 500,
		icon_IPO_CONSTANT = 501,
		icon_IPO_CUBIC = 502,
		icon_IPO_EASE_IN_OUT = 503,
		icon_IPO_EASE_IN = 504,
		icon_IPO_EASE_OUT = 505,
		icon_IPO_ELASTIC = 506,
		icon_IPO_EXPO = 507,
		icon_IPO_LINEAR = 508,
		icon_IPO_QUAD = 509,
		icon_IPO_QUART = 510,
		icon_IPO_QUINT = 511,
		icon_IPO_SINE = 512,
		icon_KEY_DEHLT = 513,
		icon_KEY_HLT = 514,
		icon_KEYFRAME_HLT = 515,
		icon_KEYFRAME = 516,
		icon_KEYINGSET = 517,
		icon_MARKER_HLT = 518,
		icon_MARKER = 519,
		icon_MUTE_IPO_OFF = 520,
		icon_MUTE_IPO_ON = 521,
		icon_NEXT_KEYFRAME = 522,
		icon_NLA_PUSHDOWN = 523,
		icon_NORMALIZE_FCURVES = 524,
		icon_ORIENTATION_PARENT = 525,
		icon_PAUSE = 526,
		icon_PLAY_REVERSE = 527,
		icon_PLAY_SOUND = 528,
		icon_PLAY = 529,
		icon_PMARKER_ACT = 530,
		icon_PMARKER_SEL = 531,
		icon_PMARKER = 532,
		icon_PREV_KEYFRAME = 533,
		icon_PREVIEW_RANGE = 534,
		icon_REC = 535,
		icon_REW = 536,
		icon_SOLO_OFF = 537,
		icon_SOLO_ON = 538,
		icon_CENTER_ONLY = 539,
		icon_CURSOR = 540,
		icon_EDGESEL = 541,
		icon_FACE_CORNER = 542,
		icon_FACESEL = 543,
		icon_INVERSESQUARECURVE = 544,
		icon_LINCURVE = 545,
		icon_NOCURVE = 546,
		icon_PARTICLE_PATH = 547,
		icon_PARTICLE_POINT = 548,
		icon_PARTICLE_TIP = 549,
		icon_PIVOT_ACTIVE = 550,
		icon_PIVOT_BOUNDBOX = 551,
		icon_PIVOT_CURSOR = 552,
		icon_PIVOT_INDIVIDUAL = 553,
		icon_PIVOT_MEDIAN = 554,
		icon_PROP_CON = 555,
		icon_PROP_OFF = 556,
		icon_PROP_ON = 557,
		icon_PROP_PROJECTED = 558,
		icon_RNDCURVE = 559,
		icon_ROOTCURVE = 560,
		icon_SHARPCURVE = 561,
		icon_SMOOTHCURVE = 562,
		icon_SPHERECURVE = 563,
		icon_VERTEXSEL = 564,
		icon_SNAP_EDGE = 565,
		icon_SNAP_FACE_CENTER = 566,
		icon_SNAP_FACE_NEAREST = 567,
		icon_SNAP_FACE = 568,
		icon_SNAP_GRID = 569,
		icon_SNAP_INCREMENT = 570,
		icon_SNAP_MIDPOINT = 571,
		icon_SNAP_NORMAL = 572,
		icon_SNAP_PEEL_OBJECT = 573,
		icon_SNAP_PERPENDICULAR = 574,
		icon_SNAP_VERTEX = 575,
		icon_SNAP_VOLUME = 576,
		icon_STICKY_UVS_DISABLE = 577,
		icon_STICKY_UVS_LOC = 578,
		icon_STICKY_UVS_VERT = 579,
		icon_ORIENTATION_GIMBAL = 580,
		icon_ORIENTATION_GLOBAL = 581,
		icon_ORIENTATION_LOCAL = 582,
		icon_ORIENTATION_NORMAL = 583,
		icon_ORIENTATION_VIEW = 584,
		icon_COPYDOWN = 585,
		icon_FIXED_SIZE = 586,
		icon_GIZMO = 587,
		icon_GP_CAPS_FLAT = 588,
		icon_GP_CAPS_ROUND = 589,
		icon_NORMALS_FACE = 590,
		icon_NORMALS_VERTEX_FACE = 591,
		icon_NORMALS_VERTEX = 592,
		icon_OBJECT_ORIGIN = 593,
		icon_ORIENTATION_CURSOR = 594,
		icon_PASTEDOWN = 595,
		icon_PASTEFLIPDOWN = 596,
		icon_PASTEFLIPUP = 597,
		icon_TRANSFORM_ORIGINS = 598,
		icon_UV_EDGESEL = 599,
		icon_UV_FACESEL = 600,
		icon_UV_ISLANDSEL = 601,
		icon_UV_SYNC_SELECT = 602,
		icon_UV_VERTEXSEL = 603,
		icon_AXIS_FRONT = 604,
		icon_AXIS_SIDE = 605,
		icon_AXIS_TOP = 606,
		icon_GRID = 607,
		icon_LAYER_ACTIVE = 608,
		icon_LAYER_USED = 609,
		icon_LOCKVIEW_OFF = 610,
		icon_LOCKVIEW_ON = 611,
		icon_OVERLAY = 612,
		icon_SHADING_BBOX = 613,
		icon_SHADING_RENDERED = 614,
		icon_SHADING_SOLID = 615,
		icon_SHADING_TEXTURE = 616,
		icon_SHADING_WIRE = 617,
		icon_XRAY = 618,
		icon_VIEW_CAMERA_UNSELECTED = 619,
		icon_VIEW_CAMERA = 620,
		icon_VIEW_LOCKED = 621,
		icon_VIEW_ORTHO = 622,
		icon_VIEW_PAN = 623,
		icon_VIEW_PERSPECTIVE = 624,
		icon_VIEW_UNLOCKED = 625,
		icon_VIEW_ZOOM = 626,
		icon_FILE_ALIAS = 627,
		icon_FILE_FOLDER = 628,
		icon_FOLDER_REDIRECT = 629,
		icon_APPEND_BLEND = 630,
		icon_BACK = 631,
		icon_BOOKMARKS = 632,
		icon_CURRENT_FILE = 633,
		icon_DESKTOP = 634,
		icon_DISC = 635,
		icon_DISK_DRIVE = 636,
		icon_DOCUMENTS = 637,
		icon_EXPORT = 638,
		icon_EXTERNAL_DRIVE = 639,
		icon_FILE_3D = 640,
		icon_FILE_ARCHIVE = 641,
		icon_FILE_BACKUP = 642,
		icon_FILE_BLANK = 643,
		icon_FILE_BLEND = 644,
		icon_FILE_CACHE = 645,
		icon_FILE_FONT = 646,
		icon_FILE_HIDDEN = 647,
		icon_FILE_IMAGE = 648,
		icon_FILE_MOVIE = 649,
		icon_FILE_PARENT = 650,
		icon_FILE_REFRESH = 651,
		icon_FILE_SCRIPT = 652,
		icon_FILE_SOUND = 653,
		icon_FILE_TEXT = 654,
		icon_FILE_VOLUME = 655,
		icon_FILTER = 656,
		icon_FONTPREVIEW = 657,
		icon_FORWARD = 658,
		icon_HOME = 659,
		icon_IMGDISPLAY = 660,
		icon_IMPORT = 661,
		icon_LINK_BLEND = 662,
		icon_LONGDISPLAY = 663,
		icon_LOOP_BACK = 664,
		icon_LOOP_FORWARDS = 665,
		icon_NETWORK_DRIVE = 666,
		icon_NEWFOLDER = 667,
		icon_PREVIEW_LOADING = 668,
		icon_SETTINGS = 669,
		icon_SHORTDISPLAY = 670,
		icon_SORT_ASC = 671,
		icon_SORT_DESC = 672,
		icon_SORTALPHA = 673,
		icon_SORTBYEXT = 674,
		icon_SORTSIZE = 675,
		icon_SORTTIME = 676,
		icon_SYSTEM = 677,
		icon_TAG = 678,
		icon_TEMP = 679,
		icon_ALIASED = 680,
		icon_ANTIALIASED = 681,
		icon_MAT_SPHERE_SKY = 682,
		icon_MATCLOTH = 683,
		icon_MATCUBE = 684,
		icon_MATFLUID = 685,
		icon_MATPLANE = 686,
		icon_MATSHADERBALL = 687,
		icon_MATSPHERE = 688,
		icon_SEQ_CHROMA_SCOPE = 689,
		icon_SEQ_HISTOGRAM = 690,
		icon_SEQ_LUMA_WAVEFORM = 691,
		icon_SEQ_PREVIEW = 692,
		icon_SEQ_SEQUENCER = 693,
		icon_SEQ_SPLITVIEW = 694,
		icon_SEQ_STRIP_DUPLICATE = 695,
		icon_SEQ_STRIP_META = 696,
		icon_IMAGE_ALPHA = 697,
		icon_IMAGE_RGB_ALPHA = 698,
		icon_IMAGE_RGB = 699,
		icon_IMAGE_ZDEPTH = 700,
		icon_BLENDER_LOGO_LARGE = 701,
		icon_CANCEL_LARGE = 702,
		icon_DISC_LARGE = 703,
		icon_DISK_DRIVE_LARGE = 704,
		icon_EXTERNAL_DRIVE_LARGE = 705,
		icon_FILE_FOLDER_LARGE = 706,
		icon_FILE_LARGE = 707,
		icon_FILE_PARENT_LARGE = 708,
		icon_INFO_LARGE = 709,
		icon_NETWORK_DRIVE_LARGE = 710,
		icon_QUESTION_LARGE = 711,
		icon_WARNING_LARGE = 712,
		icon_KEY_BACKSPACE_FILLED = 713,
		icon_KEY_BACKSPACE = 714,
		icon_KEY_COMMAND_FILLED = 715,
		icon_KEY_COMMAND = 716,
		icon_KEY_CONTROL_FILLED = 717,
		icon_KEY_CONTROL = 718,
		icon_KEY_EMPTY1_FILLED = 719,
		icon_KEY_EMPTY1 = 720,
		icon_KEY_EMPTY2_FILLED = 721,
		icon_KEY_EMPTY2 = 722,
		icon_KEY_EMPTY3_FILLED = 723,
		icon_KEY_EMPTY3 = 724,
		icon_KEY_MENU_FILLED = 725,
		icon_KEY_MENU = 726,
		icon_KEY_OPTION_FILLED = 727,
		icon_KEY_OPTION = 728,
		icon_KEY_RETURN_FILLED = 729,
		icon_KEY_RETURN = 730,
		icon_KEY_RING_FILLED = 731,
		icon_KEY_RING = 732,
		icon_KEY_SHIFT_FILLED = 733,
		icon_KEY_SHIFT = 734,
		icon_KEY_TAB_FILLED = 735,
		icon_KEY_TAB = 736,
		icon_KEY_WINDOWS_FILLED = 737,
		icon_KEY_WINDOWS = 738,
		icon_GESTURE_PAN = 739,
		icon_GESTURE_ROTATE = 740,
		icon_GESTURE_ZOOM = 741,
		icon_FUND = 742,
		icon_HEART = 743,
		icon_INTERNET_OFFLINE = 744,
		icon_INTERNET = 745,
		icon_USER = 746,
		icon_EXPERIMENTAL = 747,
		icon_MEMORY = 748,
		icon_RGB_RED = 750,
		icon_RGB_GREEN = 751,
		icon_RGB_BLUE = 752,
		icon_KEYTYPE_KEYFRAME_VEC = 753,
		icon_KEYTYPE_BREAKDOWN_VEC = 754,
		icon_KEYTYPE_EXTREME_VEC = 755,
		icon_KEYTYPE_JITTER_VEC = 756,
		icon_KEYTYPE_MOVING_HOLD_VEC = 757,
		icon_KEYTYPE_GENERATED_VEC = 758,
		icon_HANDLETYPE_FREE_VEC = 759,
		icon_HANDLETYPE_ALIGNED_VEC = 760,
		icon_HANDLETYPE_VECTOR_VEC = 761,
		icon_HANDLETYPE_AUTO_VEC = 762,
		icon_HANDLETYPE_AUTO_CLAMP_VEC = 763,
		icon_COLORSET_01_VEC = 764,
		icon_COLORSET_02_VEC = 765,
		icon_COLORSET_03_VEC = 766,
		icon_COLORSET_04_VEC = 767,
		icon_COLORSET_05_VEC = 768,
		icon_COLORSET_06_VEC = 769,
		icon_COLORSET_07_VEC = 770,
		icon_COLORSET_08_VEC = 771,
		icon_COLORSET_09_VEC = 772,
		icon_COLORSET_10_VEC = 773,
		icon_COLORSET_11_VEC = 774,
		icon_COLORSET_12_VEC = 775,
		icon_COLORSET_13_VEC = 776,
		icon_COLORSET_14_VEC = 777,
		icon_COLORSET_15_VEC = 778,
		icon_COLORSET_16_VEC = 779,
		icon_COLORSET_17_VEC = 780,
		icon_COLORSET_18_VEC = 781,
		icon_COLORSET_19_VEC = 782,
		icon_COLORSET_20_VEC = 783,
		icon_COLLECTION_COLOR_01 = 784,
		icon_COLLECTION_COLOR_02 = 785,
		icon_COLLECTION_COLOR_03 = 786,
		icon_COLLECTION_COLOR_04 = 787,
		icon_COLLECTION_COLOR_05 = 788,
		icon_COLLECTION_COLOR_06 = 789,
		icon_COLLECTION_COLOR_07 = 790,
		icon_COLLECTION_COLOR_08 = 791,
		icon_STRIP_COLOR_01 = 792,
		icon_STRIP_COLOR_02 = 793,
		icon_STRIP_COLOR_03 = 794,
		icon_STRIP_COLOR_04 = 795,
		icon_STRIP_COLOR_05 = 796,
		icon_STRIP_COLOR_06 = 797,
		icon_STRIP_COLOR_07 = 798,
		icon_STRIP_COLOR_08 = 799,
		icon_STRIP_COLOR_09 = 800,
		icon_LIBRARY_DATA_INDIRECT = 801,
		icon_LIBRARY_DATA_OVERRIDE_NONEDITABLE = 802,
		icon_LAYERGROUP_COLOR_01 = 803,
		icon_LAYERGROUP_COLOR_02 = 804,
		icon_LAYERGROUP_COLOR_03 = 805,
		icon_LAYERGROUP_COLOR_04 = 806,
		icon_LAYERGROUP_COLOR_05 = 807,
		icon_LAYERGROUP_COLOR_06 = 808,
		icon_LAYERGROUP_COLOR_07 = 809,
		icon_LAYERGROUP_COLOR_08 = 810,
		icon_EVENT_A = 811,
		icon_EVENT_B = 812,
		icon_EVENT_C = 813,
		icon_EVENT_D = 814,
		icon_EVENT_E = 815,
		icon_EVENT_F = 816,
		icon_EVENT_G = 817,
		icon_EVENT_H = 818,
		icon_EVENT_I = 819,
		icon_EVENT_J = 820,
		icon_EVENT_K = 821,
		icon_EVENT_L = 822,
		icon_EVENT_M = 823,
		icon_EVENT_N = 824,
		icon_EVENT_O = 825,
		icon_EVENT_P = 826,
		icon_EVENT_Q = 827,
		icon_EVENT_R = 828,
		icon_EVENT_S = 829,
		icon_EVENT_T = 830,
		icon_EVENT_U = 831,
		icon_EVENT_V = 832,
		icon_EVENT_W = 833,
		icon_EVENT_X = 834,
		icon_EVENT_Y = 835,
		icon_EVENT_Z = 836,
		icon_EVENT_SHIFT = 837,
		icon_EVENT_CTRL = 838,
		icon_EVENT_ALT = 839,
		icon_EVENT_OS = 840,
		icon_EVENT_HYPER = 841,
		icon_EVENT_F1 = 842,
		icon_EVENT_F2 = 843,
		icon_EVENT_F3 = 844,
		icon_EVENT_F4 = 845,
		icon_EVENT_F5 = 846,
		icon_EVENT_F6 = 847,
		icon_EVENT_F7 = 848,
		icon_EVENT_F8 = 849,
		icon_EVENT_F9 = 850,
		icon_EVENT_F10 = 851,
		icon_EVENT_F11 = 852,
		icon_EVENT_F12 = 853,
		icon_EVENT_F13 = 854,
		icon_EVENT_F14 = 855,
		icon_EVENT_F15 = 856,
		icon_EVENT_F16 = 857,
		icon_EVENT_F17 = 858,
		icon_EVENT_F18 = 859,
		icon_EVENT_F19 = 860,
		icon_EVENT_F20 = 861,
		icon_EVENT_F21 = 862,
		icon_EVENT_F22 = 863,
		icon_EVENT_F23 = 864,
		icon_EVENT_F24 = 865,
		icon_EVENT_ESC = 866,
		icon_EVENT_TAB = 867,
		icon_EVENT_PAGEUP = 868,
		icon_EVENT_PAGEDOWN = 869,
		icon_EVENT_RETURN = 870,
		icon_EVENT_SPACEKEY = 871,
		icon_EVENT_ZEROKEY = 872,
		icon_EVENT_ONEKEY = 873,
		icon_EVENT_TWOKEY = 874,
		icon_EVENT_THREEKEY = 875,
		icon_EVENT_FOURKEY = 876,
		icon_EVENT_FIVEKEY = 877,
		icon_EVENT_SIXKEY = 878,
		icon_EVENT_SEVENKEY = 879,
		icon_EVENT_EIGHTKEY = 880,
		icon_EVENT_NINEKEY = 881,
		icon_EVENT_PAD0 = 882,
		icon_EVENT_PAD1 = 883,
		icon_EVENT_PAD2 = 884,
		icon_EVENT_PAD3 = 885,
		icon_EVENT_PAD4 = 886,
		icon_EVENT_PAD5 = 887,
		icon_EVENT_PAD6 = 888,
		icon_EVENT_PAD7 = 889,
		icon_EVENT_PAD8 = 890,
		icon_EVENT_PAD9 = 891,
		icon_EVENT_PADASTER = 892,
		icon_EVENT_PADSLASH = 893,
		icon_EVENT_PADMINUS = 894,
		icon_EVENT_PADENTER = 895,
		icon_EVENT_PADPLUS = 896,
		icon_EVENT_PADPERIOD = 897,
		icon_EVENT_MOUSE_4 = 898,
		icon_EVENT_MOUSE_5 = 899,
		icon_EVENT_MOUSE_6 = 900,
		icon_EVENT_MOUSE_7 = 901,
		icon_EVENT_TABLET_STYLUS = 902,
		icon_EVENT_TABLET_ERASER = 903,
		icon_EVENT_LEFT_ARROW = 904,
		icon_EVENT_DOWN_ARROW = 905,
		icon_EVENT_RIGHT_ARROW = 906,
		icon_EVENT_UP_ARROW = 907,
		icon_EVENT_PAUSE = 908,
		icon_EVENT_INSERT = 909,
		icon_EVENT_HOME = 910,
		icon_EVENT_END = 911,
		icon_EVENT_UNKNOWN = 912,
		icon_EVENT_GRLESS = 913,
		icon_EVENT_MEDIAPLAY = 914,
		icon_EVENT_MEDIASTOP = 915,
		icon_EVENT_MEDIAFIRST = 916,
		icon_EVENT_MEDIALAST = 917,
		icon_EVENT_APP = 918,
		icon_EVENT_CAPSLOCK = 919,
		icon_EVENT_BACKSPACE = 920,
		icon_EVENT_DEL = 921,
		icon_EVENT_SEMICOLON = 922,
		icon_EVENT_PERIOD = 923,
		icon_EVENT_COMMA = 924,
		icon_EVENT_QUOTE = 925,
		icon_EVENT_ACCENTGRAVE = 926,
		icon_EVENT_MINUS = 927,
		icon_EVENT_PLUS = 928,
		icon_EVENT_SLASH = 929,
		icon_EVENT_BACKSLASH = 930,
		icon_EVENT_EQUAL = 931,
		icon_EVENT_LEFTBRACKET = 932,
		icon_EVENT_RIGHTBRACKET = 933,
		icon_EVENT_PAD_PAN = 934,
		icon_EVENT_PAD_ROTATE = 935,
		icon_EVENT_PAD_ZOOM = 936,
		icon_EVENT_NDOF_BUTTON_V1 = 937,
		icon_EVENT_NDOF_BUTTON_V2 = 938,
		icon_EVENT_NDOF_BUTTON_V3 = 939,
		icon_EVENT_NDOF_BUTTON_SAVE_V1 = 940,
		icon_EVENT_NDOF_BUTTON_SAVE_V2 = 941,
		icon_EVENT_NDOF_BUTTON_SAVE_V3 = 942,
		icon_EVENT_NDOF_BUTTON_1 = 943,
		icon_EVENT_NDOF_BUTTON_2 = 944,
		icon_EVENT_NDOF_BUTTON_3 = 945,
		icon_EVENT_NDOF_BUTTON_4 = 946,
		icon_EVENT_NDOF_BUTTON_5 = 947,
		icon_EVENT_NDOF_BUTTON_6 = 948,
		icon_EVENT_NDOF_BUTTON_7 = 949,
		icon_EVENT_NDOF_BUTTON_8 = 950,
		icon_EVENT_NDOF_BUTTON_9 = 951,
		icon_EVENT_NDOF_BUTTON_10 = 952,
		icon_EVENT_NDOF_BUTTON_11 = 953,
		icon_EVENT_NDOF_BUTTON_12 = 954,
		icon_EVENT_NDOF_BUTTON_MENU = 955,
		icon_EVENT_NDOF_BUTTON_FIT = 956,
		icon_EVENT_NDOF_BUTTON_TOP = 957,
		icon_EVENT_NDOF_BUTTON_BOTTOM = 958,
		icon_EVENT_NDOF_BUTTON_LEFT = 959,
		icon_EVENT_NDOF_BUTTON_RIGHT = 960,
		icon_EVENT_NDOF_BUTTON_FRONT = 961,
		icon_EVENT_NDOF_BUTTON_BACK = 962,
		icon_EVENT_NDOF_BUTTON_ISO1 = 963,
		icon_EVENT_NDOF_BUTTON_ISO2 = 964,
		icon_EVENT_NDOF_BUTTON_ROLL_CW = 965,
		icon_EVENT_NDOF_BUTTON_ROLL_CCW = 966,
		icon_EVENT_NDOF_BUTTON_SPIN_CW = 967,
		icon_EVENT_NDOF_BUTTON_SPIN_CCW = 968,
		icon_EVENT_NDOF_BUTTON_TILT_CW = 969,
		icon_EVENT_NDOF_BUTTON_TILT_CCW = 970,
		icon_EVENT_NDOF_BUTTON_ROTATE = 971,
		icon_EVENT_NDOF_BUTTON_PANZOOM = 972,
		icon_EVENT_NDOF_BUTTON_DOMINANT = 973,
		icon_EVENT_NDOF_BUTTON_PLUS = 974,
		icon_EVENT_NDOF_BUTTON_MINUS = 975,
		icon_NODE_SOCKET_FLOAT = 976,
		icon_NODE_SOCKET_VECTOR = 977,
		icon_NODE_SOCKET_RGBA = 978,
		icon_NODE_SOCKET_SHADER = 979,
		icon_NODE_SOCKET_BOOLEAN = 980,
		icon_NODE_SOCKET_INT = 981,
		icon_NODE_SOCKET_STRING = 982,
		icon_NODE_SOCKET_OBJECT = 983,
		icon_NODE_SOCKET_IMAGE = 984,
		icon_NODE_SOCKET_GEOMETRY = 985,
		icon_NODE_SOCKET_COLLECTION = 986,
		icon_NODE_SOCKET_TEXTURE = 987,
		icon_NODE_SOCKET_MATERIAL = 988,
		icon_NODE_SOCKET_ROTATION = 989,
		icon_NODE_SOCKET_MENU = 990,
		icon_NODE_SOCKET_MATRIX = 991,
		icon_NODE_SOCKET_BUNDLE = 992,
		icon_NODE_SOCKET_CLOSURE = 993,
	};
	inline icon_enum icon(void);
	inline void icon(icon_enum value);
	inline bool is_readonly(void);
	inline void is_readonly(bool value);
	inline bool is_animatable(void);
	inline void is_animatable(bool value);
	inline bool is_overridable(void);
	inline void is_overridable(bool value);
	inline bool is_required(void);
	inline void is_required(bool value);
	inline bool is_argument_optional(void);
	inline void is_argument_optional(bool value);
	inline bool is_never_none(void);
	inline void is_never_none(bool value);
	inline bool is_hidden(void);
	inline void is_hidden(bool value);
	inline bool is_skip_save(void);
	inline void is_skip_save(bool value);
	inline bool is_skip_preset(void);
	inline void is_skip_preset(bool value);
	inline bool is_output(void);
	inline void is_output(bool value);
	inline bool is_registered(void);
	inline void is_registered(bool value);
	inline bool is_registered_optional(void);
	inline void is_registered_optional(bool value);
	inline bool is_runtime(void);
	inline void is_runtime(bool value);
	inline bool is_enum_flag(void);
	inline void is_enum_flag(bool value);
	inline bool is_library_editable(void);
	inline void is_library_editable(bool value);
	inline bool is_path_output(void);
	inline void is_path_output(bool value);
	inline bool is_path_supports_blend_relative(void);
	inline void is_path_supports_blend_relative(bool value);
	inline bool is_path_supports_templates(void);
	inline void is_path_supports_templates(bool value);
	enum tags_enum {
	};
	inline tags_enum tags(void);
	inline void tags(tags_enum value);

};

/**************** Boolean Definition ****************/

class BoolProperty : public Property {
public:
	BoolProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline bool default_value(void);
	inline void default_value(bool value);
	inline Array<bool, 3> default_array(void);
	inline void default_array(bool values[3]);
	inline int array_length(void);
	inline void array_length(int value);
	inline Array<int, 3> array_dimensions(void);
	inline void array_dimensions(int values[3]);
	inline bool is_array(void);
	inline void is_array(bool value);

};

/**************** Int Definition ****************/

class IntProperty : public Property {
public:
	IntProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline int default_value(void);
	inline void default_value(int value);
	inline Array<int, 3> default_array(void);
	inline void default_array(int values[3]);
	inline int array_length(void);
	inline void array_length(int value);
	inline Array<int, 3> array_dimensions(void);
	inline void array_dimensions(int values[3]);
	inline bool is_array(void);
	inline void is_array(bool value);
	inline int hard_min(void);
	inline void hard_min(int value);
	inline int hard_max(void);
	inline void hard_max(int value);
	inline int soft_min(void);
	inline void soft_min(int value);
	inline int soft_max(void);
	inline void soft_max(int value);
	inline int step(void);
	inline void step(int value);

};

/**************** Float Definition ****************/

class FloatProperty : public Property {
public:
	FloatProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline float default_value(void);
	inline void default_value(float value);
	inline Array<float, 3> default_array(void);
	inline void default_array(float values[3]);
	inline int array_length(void);
	inline void array_length(int value);
	inline Array<int, 3> array_dimensions(void);
	inline void array_dimensions(int values[3]);
	inline bool is_array(void);
	inline void is_array(bool value);
	inline float hard_min(void);
	inline void hard_min(float value);
	inline float hard_max(void);
	inline void hard_max(float value);
	inline float soft_min(void);
	inline void soft_min(float value);
	inline float soft_max(void);
	inline void soft_max(float value);
	inline float step(void);
	inline void step(float value);
	inline int precision(void);
	inline void precision(int value);

};

/**************** String Definition ****************/

class StringProperty : public Property {
public:
	StringProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline std::string default_value(void);
	inline void default_value(const std::string& value);
	inline int length_max(void);
	inline void length_max(int value);

};

/**************** Enum Definition ****************/

class EnumProperty : public Property {
public:
	EnumProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg),
		enum_items(ptr_arg),
		enum_items_static(ptr_arg),
		enum_items_static_ui(ptr_arg)
		{}

	enum default_value_enum {
		default_value_DEFAULT = 0,
	};
	inline default_value_enum default_value(void);
	inline void default_value(default_value_enum value);
	enum default_flag_enum {
		default_flag_DEFAULT = 0,
	};
	inline default_flag_enum default_flag(void);
	inline void default_flag(default_flag_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, EnumPropertyItem, EnumProperty, enum_items, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, EnumPropertyItem, EnumProperty, enum_items_static, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, EnumPropertyItem, EnumProperty, enum_items_static_ui, false, false, false)

};

/**************** Enum Item Definition ****************/

class EnumPropertyItem : public Pointer {
public:
	EnumPropertyItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline std::string description(void);
	inline void description(const std::string& value);
	inline std::string identifier(void);
	inline void identifier(const std::string& value);
	inline int value(void);
	inline void value(int value);
	enum icon_enum {
		icon_NONE = 0,
		icon_CHAR_NOTDEF = 1,
		icon_CHAR_REPLACEMENT = 2,
		icon_NOT_FOUND = 3,
		icon_BLANK1 = 4,
		icon_AUTOMERGE_OFF = 5,
		icon_AUTOMERGE_ON = 6,
		icon_CHECKBOX_DEHLT = 7,
		icon_CHECKBOX_HLT = 8,
		icon_CLIPUV_DEHLT = 9,
		icon_CLIPUV_HLT = 10,
		icon_DECORATE_UNLOCKED = 11,
		icon_DECORATE_LOCKED = 12,
		icon_FAKE_USER_OFF = 13,
		icon_FAKE_USER_ON = 14,
		icon_HIDE_ON = 15,
		icon_HIDE_OFF = 16,
		icon_INDIRECT_ONLY_OFF = 17,
		icon_INDIRECT_ONLY_ON = 18,
		icon_ONIONSKIN_OFF = 19,
		icon_ONIONSKIN_ON = 20,
		icon_UNPINNED = 21,
		icon_PINNED = 22,
		icon_RADIOBUT_OFF = 23,
		icon_RADIOBUT_ON = 24,
		icon_RECORD_OFF = 25,
		icon_RECORD_ON = 26,
		icon_RESTRICT_RENDER_ON = 27,
		icon_RESTRICT_RENDER_OFF = 28,
		icon_RESTRICT_SELECT_ON = 29,
		icon_RESTRICT_SELECT_OFF = 30,
		icon_RESTRICT_VIEW_ON = 31,
		icon_RESTRICT_VIEW_OFF = 32,
		icon_RIGHTARROW = 33,
		icon_DOWNARROW_HLT = 34,
		icon_SELECT_INTERSECT = 35,
		icon_SELECT_DIFFERENCE = 36,
		icon_SNAP_OFF = 37,
		icon_SNAP_ON = 38,
		icon_UNLOCKED = 39,
		icon_LOCKED = 40,
		icon_VIS_SEL_11 = 41,
		icon_VIS_SEL_10 = 42,
		icon_VIS_SEL_01 = 43,
		icon_VIS_SEL_00 = 44,
		icon_CANCEL = 45,
		icon_ERROR = 46,
		icon_QUESTION = 47,
		icon_ADD = 48,
		icon_ARROW_LEFTRIGHT = 49,
		icon_AUTO = 50,
		icon_BLENDER = 51,
		icon_BORDERMOVE = 52,
		icon_BRUSHES_ALL = 53,
		icon_CHECKMARK = 54,
		icon_COLLAPSEMENU = 55,
		icon_COLLECTION_NEW = 56,
		icon_COLOR = 57,
		icon_COPY_ID = 58,
		icon_DISCLOSURE_TRI_DOWN = 59,
		icon_DISCLOSURE_TRI_RIGHT = 60,
		icon_DOT = 61,
		icon_DRIVER_DISTANCE = 62,
		icon_DRIVER_ROTATIONAL_DIFFERENCE = 63,
		icon_DRIVER_TRANSFORM = 64,
		icon_DUPLICATE = 65,
		icon_EYEDROPPER = 66,
		icon_FCURVE_SNAPSHOT = 67,
		icon_FILE_NEW = 68,
		icon_FILE_TICK = 69,
		icon_FREEZE = 70,
		icon_FULLSCREEN_ENTER = 71,
		icon_FULLSCREEN_EXIT = 72,
		icon_GHOST_DISABLED = 73,
		icon_GHOST_ENABLED = 74,
		icon_GRIP = 75,
		icon_GRIP_V = 76,
		icon_HAND = 77,
		icon_HELP = 78,
		icon_LINKED = 79,
		icon_MENU_PANEL = 80,
		icon_NODE_SEL = 81,
		icon_NODE = 82,
		icon_OBJECT_HIDDEN = 83,
		icon_OPTIONS = 84,
		icon_PANEL_CLOSE = 85,
		icon_PLUGIN = 86,
		icon_PLUS = 87,
		icon_PRESET_NEW = 88,
		icon_QUIT = 89,
		icon_RECOVER_LAST = 90,
		icon_REMOVE = 91,
		icon_RIGHTARROW_THIN = 92,
		icon_SCREEN_BACK = 93,
		icon_STATUSBAR = 94,
		icon_STYLUS_PRESSURE = 95,
		icon_THREE_DOTS = 96,
		icon_TOPBAR = 97,
		icon_TRASH = 98,
		icon_TRIA_DOWN = 99,
		icon_TRIA_LEFT = 100,
		icon_TRIA_RIGHT = 101,
		icon_TRIA_UP = 102,
		icon_UNLINKED = 103,
		icon_URL = 104,
		icon_VIEWZOOM = 105,
		icon_WINDOW = 106,
		icon_WORKSPACE = 107,
		icon_X = 108,
		icon_ZOOM_ALL = 109,
		icon_ZOOM_IN = 110,
		icon_ZOOM_OUT = 111,
		icon_ZOOM_PREVIOUS = 112,
		icon_ZOOM_SELECTED = 113,
		icon_MODIFIER = 114,
		icon_PARTICLES = 115,
		icon_PHYSICS = 116,
		icon_SHADERFX = 117,
		icon_SPEAKER = 118,
		icon_OUTPUT = 119,
		icon_SCENE = 120,
		icon_TOOL_SETTINGS = 121,
		icon_LIGHT = 122,
		icon_MATERIAL = 123,
		icon_TEXTURE = 124,
		icon_WORLD = 125,
		icon_ANIM = 126,
		icon_SCRIPT = 127,
		icon_GEOMETRY_NODES = 128,
		icon_TEXT = 129,
		icon_ACTION = 130,
		icon_ASSET_MANAGER = 131,
		icon_CONSOLE = 132,
		icon_FILEBROWSER = 133,
		icon_GEOMETRY_SET = 134,
		icon_GRAPH = 135,
		icon_IMAGE = 136,
		icon_INFO = 137,
		icon_NLA = 138,
		icon_NODE_COMPOSITING = 139,
		icon_NODE_MATERIAL = 140,
		icon_NODE_TEXTURE = 141,
		icon_NODETREE = 142,
		icon_OUTLINER = 143,
		icon_PREFERENCES = 144,
		icon_PROPERTIES = 145,
		icon_SEQUENCE = 146,
		icon_SOUND = 147,
		icon_SPREADSHEET = 148,
		icon_TIME = 149,
		icon_TRACKER = 150,
		icon_UV = 151,
		icon_VIEW3D = 152,
		icon_EDITMODE_HLT = 153,
		icon_OBJECT_DATAMODE = 154,
		icon_PARTICLEMODE = 155,
		icon_POSE_HLT = 156,
		icon_SCULPTMODE_HLT = 157,
		icon_TPAINT_HLT = 158,
		icon_UV_DATA = 159,
		icon_VPAINT_HLT = 160,
		icon_WPAINT_HLT = 161,
		icon_TRACKER_DATA = 162,
		icon_TRACKING_BACKWARDS_SINGLE = 163,
		icon_TRACKING_BACKWARDS = 164,
		icon_TRACKING_CLEAR_BACKWARDS = 165,
		icon_TRACKING_CLEAR_FORWARDS = 166,
		icon_TRACKING_FORWARDS_SINGLE = 167,
		icon_TRACKING_FORWARDS = 168,
		icon_TRACKING_REFINE_BACKWARDS = 169,
		icon_TRACKING_REFINE_FORWARDS = 170,
		icon_TRACKING = 171,
		icon_GROUP = 172,
		icon_CONSTRAINT_BONE = 173,
		icon_CONSTRAINT = 174,
		icon_ARMATURE_DATA = 175,
		icon_BONE_DATA = 176,
		icon_CAMERA_DATA = 177,
		icon_CURVE_DATA = 178,
		icon_EMPTY_DATA = 179,
		icon_FONT_DATA = 180,
		icon_LATTICE_DATA = 181,
		icon_LIGHT_DATA = 182,
		icon_MESH_DATA = 183,
		icon_META_DATA = 184,
		icon_PARTICLE_DATA = 185,
		icon_SHAPEKEY_DATA = 186,
		icon_SURFACE_DATA = 187,
		icon_OBJECT_DATA = 188,
		icon_RENDER_RESULT = 189,
		icon_RENDERLAYERS = 190,
		icon_SCENE_DATA = 191,
		icon_BRUSH_DATA = 192,
		icon_IMAGE_DATA = 193,
		icon_LINE_DATA = 194,
		icon_MATERIAL_DATA = 195,
		icon_TEXTURE_DATA = 196,
		icon_WORLD_DATA = 197,
		icon_ANIM_DATA = 198,
		icon_BOIDS = 199,
		icon_CAMERA_STEREO = 200,
		icon_COMMUNITY = 201,
		icon_FACE_MAPS = 202,
		icon_FCURVE = 203,
		icon_FILE = 204,
		icon_GREASEPENCIL = 205,
		icon_GREASEPENCIL_LAYER_GROUP = 206,
		icon_GROUP_BONE = 207,
		icon_GROUP_UVS = 208,
		icon_GROUP_VCOL = 209,
		icon_GROUP_VERTEX = 210,
		icon_LIBRARY_DATA_BROKEN = 211,
		icon_LIBRARY_DATA_DIRECT = 212,
		icon_LIBRARY_DATA_OVERRIDE = 213,
		icon_ORPHAN_DATA = 214,
		icon_PACKAGE = 215,
		icon_PRESET = 216,
		icon_RENDER_ANIMATION = 217,
		icon_RENDER_STILL = 218,
		icon_RNA_ADD = 219,
		icon_RNA = 220,
		icon_STRANDS = 221,
		icon_UGLYPACKAGE = 222,
		icon_MOUSE_LMB = 223,
		icon_MOUSE_MMB = 224,
		icon_MOUSE_RMB = 225,
		icon_MOUSE_MMB_SCROLL = 226,
		icon_MOUSE_LMB_2X = 227,
		icon_MOUSE_MOVE = 228,
		icon_MOUSE_LMB_DRAG = 229,
		icon_MOUSE_MMB_DRAG = 230,
		icon_MOUSE_RMB_DRAG = 231,
		icon_DECORATE_ANIMATE = 232,
		icon_DECORATE_DRIVER = 233,
		icon_DECORATE_KEYFRAME = 234,
		icon_DECORATE_LIBRARY_OVERRIDE = 235,
		icon_DECORATE_LINKED = 236,
		icon_DECORATE_OVERRIDE = 237,
		icon_DECORATE = 238,
		icon_OUTLINER_COLLECTION = 239,
		icon_CURVES_DATA = 240,
		icon_OUTLINER_DATA_ARMATURE = 241,
		icon_OUTLINER_DATA_CAMERA = 242,
		icon_OUTLINER_DATA_CURVE = 243,
		icon_OUTLINER_DATA_CURVES = 244,
		icon_OUTLINER_DATA_EMPTY = 245,
		icon_OUTLINER_DATA_FONT = 246,
		icon_OUTLINER_DATA_GP_LAYER = 247,
		icon_OUTLINER_DATA_GREASEPENCIL = 248,
		icon_OUTLINER_DATA_LATTICE = 249,
		icon_OUTLINER_DATA_LIGHT = 250,
		icon_OUTLINER_DATA_LIGHTPROBE = 251,
		icon_OUTLINER_DATA_MESH = 252,
		icon_OUTLINER_DATA_META = 253,
		icon_OUTLINER_DATA_POINTCLOUD = 254,
		icon_OUTLINER_DATA_SPEAKER = 255,
		icon_OUTLINER_DATA_SURFACE = 256,
		icon_OUTLINER_DATA_VOLUME = 257,
		icon_POINTCLOUD_DATA = 258,
		icon_POINTCLOUD_POINT = 259,
		icon_VOLUME_DATA = 260,
		icon_OUTLINER_OB_ARMATURE = 261,
		icon_OUTLINER_OB_CAMERA = 262,
		icon_OUTLINER_OB_CURVE = 263,
		icon_OUTLINER_OB_CURVES = 264,
		icon_OUTLINER_OB_EMPTY = 265,
		icon_OUTLINER_OB_FONT = 266,
		icon_OUTLINER_OB_FORCE_FIELD = 267,
		icon_OUTLINER_OB_GREASEPENCIL = 268,
		icon_OUTLINER_OB_GROUP_INSTANCE = 269,
		icon_OUTLINER_OB_IMAGE = 270,
		icon_OUTLINER_OB_LATTICE = 271,
		icon_OUTLINER_OB_LIGHT = 272,
		icon_OUTLINER_OB_LIGHTPROBE = 273,
		icon_OUTLINER_OB_MESH = 274,
		icon_OUTLINER_OB_META = 275,
		icon_OUTLINER_OB_POINTCLOUD = 276,
		icon_OUTLINER_OB_SPEAKER = 277,
		icon_OUTLINER_OB_SURFACE = 278,
		icon_OUTLINER_OB_VOLUME = 279,
		icon_GP_MULTIFRAME_EDITING = 280,
		icon_GP_ONLY_SELECTED = 281,
		icon_GP_SELECT_BETWEEN_STROKES = 282,
		icon_GP_SELECT_POINTS = 283,
		icon_GP_SELECT_STROKES = 284,
		icon_HOLDOUT_OFF = 285,
		icon_HOLDOUT_ON = 286,
		icon_MODIFIER_OFF = 287,
		icon_MODIFIER_ON = 288,
		icon_RESTRICT_COLOR_OFF = 289,
		icon_RESTRICT_COLOR_ON = 290,
		icon_RESTRICT_INSTANCED_OFF = 291,
		icon_RESTRICT_INSTANCED_ON = 292,
		icon_LIGHT_AREA = 293,
		icon_LIGHT_HEMI = 294,
		icon_LIGHT_POINT = 295,
		icon_LIGHT_SPOT = 296,
		icon_LIGHT_SUN = 297,
		icon_LIGHTPROBE_PLANE = 298,
		icon_LIGHTPROBE_SPHERE = 299,
		icon_LIGHTPROBE_VOLUME = 300,
		icon_COLOR_BLUE = 301,
		icon_COLOR_GREEN = 302,
		icon_COLOR_RED = 303,
		icon_CONE = 304,
		icon_CUBE = 305,
		icon_CURVE_BEZCIRCLE = 306,
		icon_CURVE_BEZCURVE = 307,
		icon_CURVE_NCIRCLE = 308,
		icon_CURVE_NCURVE = 309,
		icon_CURVE_PATH = 310,
		icon_CURVES = 311,
		icon_EMPTY_ARROWS = 312,
		icon_EMPTY_AXIS = 313,
		icon_EMPTY_SINGLE_ARROW = 314,
		icon_MESH_CAPSULE = 315,
		icon_MESH_CIRCLE = 316,
		icon_MESH_CONE = 317,
		icon_MESH_CUBE = 318,
		icon_MESH_CYLINDER = 319,
		icon_MESH_GRID = 320,
		icon_MESH_ICOSPHERE = 321,
		icon_MESH_MONKEY = 322,
		icon_MESH_PLANE = 323,
		icon_MESH_TORUS = 324,
		icon_MESH_UVSPHERE = 325,
		icon_META_BALL = 326,
		icon_META_CAPSULE = 327,
		icon_META_CUBE = 328,
		icon_META_ELLIPSOID = 329,
		icon_META_PLANE = 330,
		icon_MONKEY = 331,
		icon_SPHERE = 332,
		icon_STROKE = 333,
		icon_SURFACE_NCIRCLE = 334,
		icon_SURFACE_NCURVE = 335,
		icon_SURFACE_NCYLINDER = 336,
		icon_SURFACE_NSPHERE = 337,
		icon_SURFACE_NSURFACE = 338,
		icon_SURFACE_NTORUS = 339,
		icon_TRIA_DOWN_BAR = 340,
		icon_TRIA_LEFT_BAR = 341,
		icon_TRIA_RIGHT_BAR = 342,
		icon_TRIA_UP_BAR = 343,
		icon_AREA_DOCK = 344,
		icon_AREA_JOIN_DOWN = 345,
		icon_AREA_JOIN_LEFT = 346,
		icon_AREA_JOIN_UP = 347,
		icon_AREA_JOIN = 348,
		icon_AREA_SWAP = 349,
		icon_FORCE_BOID = 350,
		icon_FORCE_CHARGE = 351,
		icon_FORCE_CURVE = 352,
		icon_FORCE_DRAG = 353,
		icon_FORCE_FLUIDFLOW = 354,
		icon_FORCE_FORCE = 355,
		icon_FORCE_HARMONIC = 356,
		icon_FORCE_LENNARDJONES = 357,
		icon_FORCE_MAGNETIC = 358,
		icon_FORCE_TEXTURE = 359,
		icon_FORCE_TURBULENCE = 360,
		icon_FORCE_VORTEX = 361,
		icon_FORCE_WIND = 362,
		icon_IMAGE_BACKGROUND = 363,
		icon_IMAGE_PLANE = 364,
		icon_IMAGE_REFERENCE = 365,
		icon_RIGID_BODY_CONSTRAINT = 366,
		icon_RIGID_BODY = 367,
		icon_SPLIT_HORIZONTAL = 368,
		icon_SPLIT_VERTICAL = 369,
		icon_ANCHOR_BOTTOM = 370,
		icon_ANCHOR_CENTER = 371,
		icon_ANCHOR_LEFT = 372,
		icon_ANCHOR_RIGHT = 373,
		icon_ANCHOR_TOP = 374,
		icon_NODE_CORNER = 375,
		icon_NODE_INSERT_OFF = 376,
		icon_NODE_INSERT_ON = 377,
		icon_NODE_SIDE = 378,
		icon_NODE_TOP = 379,
		icon_SELECT_EXTEND = 380,
		icon_SELECT_SET = 381,
		icon_SELECT_SUBTRACT = 382,
		icon_ALIGN_BOTTOM = 383,
		icon_ALIGN_CENTER = 384,
		icon_ALIGN_FLUSH = 385,
		icon_ALIGN_JUSTIFY = 386,
		icon_ALIGN_LEFT = 387,
		icon_ALIGN_MIDDLE = 388,
		icon_ALIGN_RIGHT = 389,
		icon_ALIGN_TOP = 390,
		icon_BOLD = 391,
		icon_ITALIC = 392,
		icon_LINENUMBERS_OFF = 393,
		icon_LINENUMBERS_ON = 394,
		icon_SCRIPTPLUGINS = 395,
		icon_SMALL_CAPS = 396,
		icon_SYNTAX_OFF = 397,
		icon_SYNTAX_ON = 398,
		icon_UNDERLINE = 399,
		icon_WORDWRAP_OFF = 400,
		icon_WORDWRAP_ON = 401,
		icon_CON_ACTION = 402,
		icon_CON_ARMATURE = 403,
		icon_CON_CAMERASOLVER = 404,
		icon_CON_CHILDOF = 405,
		icon_CON_CLAMPTO = 406,
		icon_CON_DISTLIMIT = 407,
		icon_CON_FLOOR = 408,
		icon_CON_FOLLOWPATH = 409,
		icon_CON_FOLLOWTRACK = 410,
		icon_CON_KINEMATIC = 411,
		icon_CON_LOCKTRACK = 412,
		icon_CON_LOCLIKE = 413,
		icon_CON_LOCLIMIT = 414,
		icon_CON_OBJECTSOLVER = 415,
		icon_CON_PIVOT = 416,
		icon_CON_ROTLIKE = 417,
		icon_CON_ROTLIMIT = 418,
		icon_CON_SAMEVOL = 419,
		icon_CON_SHRINKWRAP = 420,
		icon_CON_SIZELIKE = 421,
		icon_CON_SIZELIMIT = 422,
		icon_CON_SPLINEIK = 423,
		icon_CON_STRETCHTO = 424,
		icon_CON_TRACKTO = 425,
		icon_CON_TRANSFORM_CACHE = 426,
		icon_CON_TRANSFORM = 427,
		icon_CON_TRANSLIKE = 428,
		icon_HOOK = 429,
		icon_MOD_ARMATURE = 430,
		icon_MOD_ARRAY = 431,
		icon_MOD_BEVEL = 432,
		icon_MOD_BOOLEAN = 433,
		icon_MOD_BUILD = 434,
		icon_MOD_CAST = 435,
		icon_MOD_CLOTH = 436,
		icon_MOD_CURVE = 437,
		icon_MOD_DASH = 438,
		icon_MOD_DATA_TRANSFER = 439,
		icon_MOD_DECIM = 440,
		icon_MOD_DISPLACE = 441,
		icon_MOD_DYNAMICPAINT = 442,
		icon_MOD_EDGESPLIT = 443,
		icon_MOD_ENVELOPE = 444,
		icon_MOD_EXPLODE = 445,
		icon_MOD_FLUID = 446,
		icon_MOD_FLUIDSIM = 447,
		icon_MOD_HUE_SATURATION = 448,
		icon_MOD_INSTANCE = 449,
		icon_MOD_LATTICE = 450,
		icon_MOD_LENGTH = 451,
		icon_MOD_LINEART = 452,
		icon_MOD_MASK = 453,
		icon_MOD_MESHDEFORM = 454,
		icon_MOD_MIRROR = 455,
		icon_MOD_MULTIRES = 456,
		icon_MOD_NOISE = 457,
		icon_MOD_NORMALEDIT = 458,
		icon_MOD_OCEAN = 459,
		icon_MOD_OFFSET = 460,
		icon_MOD_OPACITY = 461,
		icon_MOD_OUTLINE = 462,
		icon_MOD_PARTICLE_INSTANCE = 463,
		icon_MOD_PARTICLES = 464,
		icon_MOD_PHYSICS = 465,
		icon_MOD_REMESH = 466,
		icon_MOD_SCREW = 467,
		icon_MOD_SHRINKWRAP = 468,
		icon_MOD_SIMPLEDEFORM = 469,
		icon_MOD_SIMPLIFY = 470,
		icon_MOD_SKIN = 471,
		icon_MOD_SMOOTH = 472,
		icon_MOD_SOFT = 473,
		icon_MOD_SOLIDIFY = 474,
		icon_MOD_SUBSURF = 475,
		icon_MOD_THICKNESS = 476,
		icon_MOD_TIME = 477,
		icon_MOD_TINT = 478,
		icon_MOD_TRIANGULATE = 479,
		icon_MOD_UVPROJECT = 480,
		icon_MOD_VERTEX_WEIGHT = 481,
		icon_MOD_WARP = 482,
		icon_MOD_WAVE = 483,
		icon_MOD_WIREFRAME = 484,
		icon_MODIFIER_DATA = 485,
		icon_ACTION_SLOT = 486,
		icon_ACTION_TWEAK = 487,
		icon_DRIVER = 488,
		icon_FF = 489,
		icon_FRAME_NEXT = 490,
		icon_FRAME_PREV = 491,
		icon_HANDLE_ALIGNED = 492,
		icon_HANDLE_AUTO = 493,
		icon_HANDLE_AUTOCLAMPED = 494,
		icon_HANDLE_FREE = 495,
		icon_HANDLE_VECTOR = 496,
		icon_IPO_BACK = 497,
		icon_IPO_BEZIER = 498,
		icon_IPO_BOUNCE = 499,
		icon_IPO_CIRC = 500,
		icon_IPO_CONSTANT = 501,
		icon_IPO_CUBIC = 502,
		icon_IPO_EASE_IN_OUT = 503,
		icon_IPO_EASE_IN = 504,
		icon_IPO_EASE_OUT = 505,
		icon_IPO_ELASTIC = 506,
		icon_IPO_EXPO = 507,
		icon_IPO_LINEAR = 508,
		icon_IPO_QUAD = 509,
		icon_IPO_QUART = 510,
		icon_IPO_QUINT = 511,
		icon_IPO_SINE = 512,
		icon_KEY_DEHLT = 513,
		icon_KEY_HLT = 514,
		icon_KEYFRAME_HLT = 515,
		icon_KEYFRAME = 516,
		icon_KEYINGSET = 517,
		icon_MARKER_HLT = 518,
		icon_MARKER = 519,
		icon_MUTE_IPO_OFF = 520,
		icon_MUTE_IPO_ON = 521,
		icon_NEXT_KEYFRAME = 522,
		icon_NLA_PUSHDOWN = 523,
		icon_NORMALIZE_FCURVES = 524,
		icon_ORIENTATION_PARENT = 525,
		icon_PAUSE = 526,
		icon_PLAY_REVERSE = 527,
		icon_PLAY_SOUND = 528,
		icon_PLAY = 529,
		icon_PMARKER_ACT = 530,
		icon_PMARKER_SEL = 531,
		icon_PMARKER = 532,
		icon_PREV_KEYFRAME = 533,
		icon_PREVIEW_RANGE = 534,
		icon_REC = 535,
		icon_REW = 536,
		icon_SOLO_OFF = 537,
		icon_SOLO_ON = 538,
		icon_CENTER_ONLY = 539,
		icon_CURSOR = 540,
		icon_EDGESEL = 541,
		icon_FACE_CORNER = 542,
		icon_FACESEL = 543,
		icon_INVERSESQUARECURVE = 544,
		icon_LINCURVE = 545,
		icon_NOCURVE = 546,
		icon_PARTICLE_PATH = 547,
		icon_PARTICLE_POINT = 548,
		icon_PARTICLE_TIP = 549,
		icon_PIVOT_ACTIVE = 550,
		icon_PIVOT_BOUNDBOX = 551,
		icon_PIVOT_CURSOR = 552,
		icon_PIVOT_INDIVIDUAL = 553,
		icon_PIVOT_MEDIAN = 554,
		icon_PROP_CON = 555,
		icon_PROP_OFF = 556,
		icon_PROP_ON = 557,
		icon_PROP_PROJECTED = 558,
		icon_RNDCURVE = 559,
		icon_ROOTCURVE = 560,
		icon_SHARPCURVE = 561,
		icon_SMOOTHCURVE = 562,
		icon_SPHERECURVE = 563,
		icon_VERTEXSEL = 564,
		icon_SNAP_EDGE = 565,
		icon_SNAP_FACE_CENTER = 566,
		icon_SNAP_FACE_NEAREST = 567,
		icon_SNAP_FACE = 568,
		icon_SNAP_GRID = 569,
		icon_SNAP_INCREMENT = 570,
		icon_SNAP_MIDPOINT = 571,
		icon_SNAP_NORMAL = 572,
		icon_SNAP_PEEL_OBJECT = 573,
		icon_SNAP_PERPENDICULAR = 574,
		icon_SNAP_VERTEX = 575,
		icon_SNAP_VOLUME = 576,
		icon_STICKY_UVS_DISABLE = 577,
		icon_STICKY_UVS_LOC = 578,
		icon_STICKY_UVS_VERT = 579,
		icon_ORIENTATION_GIMBAL = 580,
		icon_ORIENTATION_GLOBAL = 581,
		icon_ORIENTATION_LOCAL = 582,
		icon_ORIENTATION_NORMAL = 583,
		icon_ORIENTATION_VIEW = 584,
		icon_COPYDOWN = 585,
		icon_FIXED_SIZE = 586,
		icon_GIZMO = 587,
		icon_GP_CAPS_FLAT = 588,
		icon_GP_CAPS_ROUND = 589,
		icon_NORMALS_FACE = 590,
		icon_NORMALS_VERTEX_FACE = 591,
		icon_NORMALS_VERTEX = 592,
		icon_OBJECT_ORIGIN = 593,
		icon_ORIENTATION_CURSOR = 594,
		icon_PASTEDOWN = 595,
		icon_PASTEFLIPDOWN = 596,
		icon_PASTEFLIPUP = 597,
		icon_TRANSFORM_ORIGINS = 598,
		icon_UV_EDGESEL = 599,
		icon_UV_FACESEL = 600,
		icon_UV_ISLANDSEL = 601,
		icon_UV_SYNC_SELECT = 602,
		icon_UV_VERTEXSEL = 603,
		icon_AXIS_FRONT = 604,
		icon_AXIS_SIDE = 605,
		icon_AXIS_TOP = 606,
		icon_GRID = 607,
		icon_LAYER_ACTIVE = 608,
		icon_LAYER_USED = 609,
		icon_LOCKVIEW_OFF = 610,
		icon_LOCKVIEW_ON = 611,
		icon_OVERLAY = 612,
		icon_SHADING_BBOX = 613,
		icon_SHADING_RENDERED = 614,
		icon_SHADING_SOLID = 615,
		icon_SHADING_TEXTURE = 616,
		icon_SHADING_WIRE = 617,
		icon_XRAY = 618,
		icon_VIEW_CAMERA_UNSELECTED = 619,
		icon_VIEW_CAMERA = 620,
		icon_VIEW_LOCKED = 621,
		icon_VIEW_ORTHO = 622,
		icon_VIEW_PAN = 623,
		icon_VIEW_PERSPECTIVE = 624,
		icon_VIEW_UNLOCKED = 625,
		icon_VIEW_ZOOM = 626,
		icon_FILE_ALIAS = 627,
		icon_FILE_FOLDER = 628,
		icon_FOLDER_REDIRECT = 629,
		icon_APPEND_BLEND = 630,
		icon_BACK = 631,
		icon_BOOKMARKS = 632,
		icon_CURRENT_FILE = 633,
		icon_DESKTOP = 634,
		icon_DISC = 635,
		icon_DISK_DRIVE = 636,
		icon_DOCUMENTS = 637,
		icon_EXPORT = 638,
		icon_EXTERNAL_DRIVE = 639,
		icon_FILE_3D = 640,
		icon_FILE_ARCHIVE = 641,
		icon_FILE_BACKUP = 642,
		icon_FILE_BLANK = 643,
		icon_FILE_BLEND = 644,
		icon_FILE_CACHE = 645,
		icon_FILE_FONT = 646,
		icon_FILE_HIDDEN = 647,
		icon_FILE_IMAGE = 648,
		icon_FILE_MOVIE = 649,
		icon_FILE_PARENT = 650,
		icon_FILE_REFRESH = 651,
		icon_FILE_SCRIPT = 652,
		icon_FILE_SOUND = 653,
		icon_FILE_TEXT = 654,
		icon_FILE_VOLUME = 655,
		icon_FILTER = 656,
		icon_FONTPREVIEW = 657,
		icon_FORWARD = 658,
		icon_HOME = 659,
		icon_IMGDISPLAY = 660,
		icon_IMPORT = 661,
		icon_LINK_BLEND = 662,
		icon_LONGDISPLAY = 663,
		icon_LOOP_BACK = 664,
		icon_LOOP_FORWARDS = 665,
		icon_NETWORK_DRIVE = 666,
		icon_NEWFOLDER = 667,
		icon_PREVIEW_LOADING = 668,
		icon_SETTINGS = 669,
		icon_SHORTDISPLAY = 670,
		icon_SORT_ASC = 671,
		icon_SORT_DESC = 672,
		icon_SORTALPHA = 673,
		icon_SORTBYEXT = 674,
		icon_SORTSIZE = 675,
		icon_SORTTIME = 676,
		icon_SYSTEM = 677,
		icon_TAG = 678,
		icon_TEMP = 679,
		icon_ALIASED = 680,
		icon_ANTIALIASED = 681,
		icon_MAT_SPHERE_SKY = 682,
		icon_MATCLOTH = 683,
		icon_MATCUBE = 684,
		icon_MATFLUID = 685,
		icon_MATPLANE = 686,
		icon_MATSHADERBALL = 687,
		icon_MATSPHERE = 688,
		icon_SEQ_CHROMA_SCOPE = 689,
		icon_SEQ_HISTOGRAM = 690,
		icon_SEQ_LUMA_WAVEFORM = 691,
		icon_SEQ_PREVIEW = 692,
		icon_SEQ_SEQUENCER = 693,
		icon_SEQ_SPLITVIEW = 694,
		icon_SEQ_STRIP_DUPLICATE = 695,
		icon_SEQ_STRIP_META = 696,
		icon_IMAGE_ALPHA = 697,
		icon_IMAGE_RGB_ALPHA = 698,
		icon_IMAGE_RGB = 699,
		icon_IMAGE_ZDEPTH = 700,
		icon_BLENDER_LOGO_LARGE = 701,
		icon_CANCEL_LARGE = 702,
		icon_DISC_LARGE = 703,
		icon_DISK_DRIVE_LARGE = 704,
		icon_EXTERNAL_DRIVE_LARGE = 705,
		icon_FILE_FOLDER_LARGE = 706,
		icon_FILE_LARGE = 707,
		icon_FILE_PARENT_LARGE = 708,
		icon_INFO_LARGE = 709,
		icon_NETWORK_DRIVE_LARGE = 710,
		icon_QUESTION_LARGE = 711,
		icon_WARNING_LARGE = 712,
		icon_KEY_BACKSPACE_FILLED = 713,
		icon_KEY_BACKSPACE = 714,
		icon_KEY_COMMAND_FILLED = 715,
		icon_KEY_COMMAND = 716,
		icon_KEY_CONTROL_FILLED = 717,
		icon_KEY_CONTROL = 718,
		icon_KEY_EMPTY1_FILLED = 719,
		icon_KEY_EMPTY1 = 720,
		icon_KEY_EMPTY2_FILLED = 721,
		icon_KEY_EMPTY2 = 722,
		icon_KEY_EMPTY3_FILLED = 723,
		icon_KEY_EMPTY3 = 724,
		icon_KEY_MENU_FILLED = 725,
		icon_KEY_MENU = 726,
		icon_KEY_OPTION_FILLED = 727,
		icon_KEY_OPTION = 728,
		icon_KEY_RETURN_FILLED = 729,
		icon_KEY_RETURN = 730,
		icon_KEY_RING_FILLED = 731,
		icon_KEY_RING = 732,
		icon_KEY_SHIFT_FILLED = 733,
		icon_KEY_SHIFT = 734,
		icon_KEY_TAB_FILLED = 735,
		icon_KEY_TAB = 736,
		icon_KEY_WINDOWS_FILLED = 737,
		icon_KEY_WINDOWS = 738,
		icon_GESTURE_PAN = 739,
		icon_GESTURE_ROTATE = 740,
		icon_GESTURE_ZOOM = 741,
		icon_FUND = 742,
		icon_HEART = 743,
		icon_INTERNET_OFFLINE = 744,
		icon_INTERNET = 745,
		icon_USER = 746,
		icon_EXPERIMENTAL = 747,
		icon_MEMORY = 748,
		icon_RGB_RED = 750,
		icon_RGB_GREEN = 751,
		icon_RGB_BLUE = 752,
		icon_KEYTYPE_KEYFRAME_VEC = 753,
		icon_KEYTYPE_BREAKDOWN_VEC = 754,
		icon_KEYTYPE_EXTREME_VEC = 755,
		icon_KEYTYPE_JITTER_VEC = 756,
		icon_KEYTYPE_MOVING_HOLD_VEC = 757,
		icon_KEYTYPE_GENERATED_VEC = 758,
		icon_HANDLETYPE_FREE_VEC = 759,
		icon_HANDLETYPE_ALIGNED_VEC = 760,
		icon_HANDLETYPE_VECTOR_VEC = 761,
		icon_HANDLETYPE_AUTO_VEC = 762,
		icon_HANDLETYPE_AUTO_CLAMP_VEC = 763,
		icon_COLORSET_01_VEC = 764,
		icon_COLORSET_02_VEC = 765,
		icon_COLORSET_03_VEC = 766,
		icon_COLORSET_04_VEC = 767,
		icon_COLORSET_05_VEC = 768,
		icon_COLORSET_06_VEC = 769,
		icon_COLORSET_07_VEC = 770,
		icon_COLORSET_08_VEC = 771,
		icon_COLORSET_09_VEC = 772,
		icon_COLORSET_10_VEC = 773,
		icon_COLORSET_11_VEC = 774,
		icon_COLORSET_12_VEC = 775,
		icon_COLORSET_13_VEC = 776,
		icon_COLORSET_14_VEC = 777,
		icon_COLORSET_15_VEC = 778,
		icon_COLORSET_16_VEC = 779,
		icon_COLORSET_17_VEC = 780,
		icon_COLORSET_18_VEC = 781,
		icon_COLORSET_19_VEC = 782,
		icon_COLORSET_20_VEC = 783,
		icon_COLLECTION_COLOR_01 = 784,
		icon_COLLECTION_COLOR_02 = 785,
		icon_COLLECTION_COLOR_03 = 786,
		icon_COLLECTION_COLOR_04 = 787,
		icon_COLLECTION_COLOR_05 = 788,
		icon_COLLECTION_COLOR_06 = 789,
		icon_COLLECTION_COLOR_07 = 790,
		icon_COLLECTION_COLOR_08 = 791,
		icon_STRIP_COLOR_01 = 792,
		icon_STRIP_COLOR_02 = 793,
		icon_STRIP_COLOR_03 = 794,
		icon_STRIP_COLOR_04 = 795,
		icon_STRIP_COLOR_05 = 796,
		icon_STRIP_COLOR_06 = 797,
		icon_STRIP_COLOR_07 = 798,
		icon_STRIP_COLOR_08 = 799,
		icon_STRIP_COLOR_09 = 800,
		icon_LIBRARY_DATA_INDIRECT = 801,
		icon_LIBRARY_DATA_OVERRIDE_NONEDITABLE = 802,
		icon_LAYERGROUP_COLOR_01 = 803,
		icon_LAYERGROUP_COLOR_02 = 804,
		icon_LAYERGROUP_COLOR_03 = 805,
		icon_LAYERGROUP_COLOR_04 = 806,
		icon_LAYERGROUP_COLOR_05 = 807,
		icon_LAYERGROUP_COLOR_06 = 808,
		icon_LAYERGROUP_COLOR_07 = 809,
		icon_LAYERGROUP_COLOR_08 = 810,
		icon_EVENT_A = 811,
		icon_EVENT_B = 812,
		icon_EVENT_C = 813,
		icon_EVENT_D = 814,
		icon_EVENT_E = 815,
		icon_EVENT_F = 816,
		icon_EVENT_G = 817,
		icon_EVENT_H = 818,
		icon_EVENT_I = 819,
		icon_EVENT_J = 820,
		icon_EVENT_K = 821,
		icon_EVENT_L = 822,
		icon_EVENT_M = 823,
		icon_EVENT_N = 824,
		icon_EVENT_O = 825,
		icon_EVENT_P = 826,
		icon_EVENT_Q = 827,
		icon_EVENT_R = 828,
		icon_EVENT_S = 829,
		icon_EVENT_T = 830,
		icon_EVENT_U = 831,
		icon_EVENT_V = 832,
		icon_EVENT_W = 833,
		icon_EVENT_X = 834,
		icon_EVENT_Y = 835,
		icon_EVENT_Z = 836,
		icon_EVENT_SHIFT = 837,
		icon_EVENT_CTRL = 838,
		icon_EVENT_ALT = 839,
		icon_EVENT_OS = 840,
		icon_EVENT_HYPER = 841,
		icon_EVENT_F1 = 842,
		icon_EVENT_F2 = 843,
		icon_EVENT_F3 = 844,
		icon_EVENT_F4 = 845,
		icon_EVENT_F5 = 846,
		icon_EVENT_F6 = 847,
		icon_EVENT_F7 = 848,
		icon_EVENT_F8 = 849,
		icon_EVENT_F9 = 850,
		icon_EVENT_F10 = 851,
		icon_EVENT_F11 = 852,
		icon_EVENT_F12 = 853,
		icon_EVENT_F13 = 854,
		icon_EVENT_F14 = 855,
		icon_EVENT_F15 = 856,
		icon_EVENT_F16 = 857,
		icon_EVENT_F17 = 858,
		icon_EVENT_F18 = 859,
		icon_EVENT_F19 = 860,
		icon_EVENT_F20 = 861,
		icon_EVENT_F21 = 862,
		icon_EVENT_F22 = 863,
		icon_EVENT_F23 = 864,
		icon_EVENT_F24 = 865,
		icon_EVENT_ESC = 866,
		icon_EVENT_TAB = 867,
		icon_EVENT_PAGEUP = 868,
		icon_EVENT_PAGEDOWN = 869,
		icon_EVENT_RETURN = 870,
		icon_EVENT_SPACEKEY = 871,
		icon_EVENT_ZEROKEY = 872,
		icon_EVENT_ONEKEY = 873,
		icon_EVENT_TWOKEY = 874,
		icon_EVENT_THREEKEY = 875,
		icon_EVENT_FOURKEY = 876,
		icon_EVENT_FIVEKEY = 877,
		icon_EVENT_SIXKEY = 878,
		icon_EVENT_SEVENKEY = 879,
		icon_EVENT_EIGHTKEY = 880,
		icon_EVENT_NINEKEY = 881,
		icon_EVENT_PAD0 = 882,
		icon_EVENT_PAD1 = 883,
		icon_EVENT_PAD2 = 884,
		icon_EVENT_PAD3 = 885,
		icon_EVENT_PAD4 = 886,
		icon_EVENT_PAD5 = 887,
		icon_EVENT_PAD6 = 888,
		icon_EVENT_PAD7 = 889,
		icon_EVENT_PAD8 = 890,
		icon_EVENT_PAD9 = 891,
		icon_EVENT_PADASTER = 892,
		icon_EVENT_PADSLASH = 893,
		icon_EVENT_PADMINUS = 894,
		icon_EVENT_PADENTER = 895,
		icon_EVENT_PADPLUS = 896,
		icon_EVENT_PADPERIOD = 897,
		icon_EVENT_MOUSE_4 = 898,
		icon_EVENT_MOUSE_5 = 899,
		icon_EVENT_MOUSE_6 = 900,
		icon_EVENT_MOUSE_7 = 901,
		icon_EVENT_TABLET_STYLUS = 902,
		icon_EVENT_TABLET_ERASER = 903,
		icon_EVENT_LEFT_ARROW = 904,
		icon_EVENT_DOWN_ARROW = 905,
		icon_EVENT_RIGHT_ARROW = 906,
		icon_EVENT_UP_ARROW = 907,
		icon_EVENT_PAUSE = 908,
		icon_EVENT_INSERT = 909,
		icon_EVENT_HOME = 910,
		icon_EVENT_END = 911,
		icon_EVENT_UNKNOWN = 912,
		icon_EVENT_GRLESS = 913,
		icon_EVENT_MEDIAPLAY = 914,
		icon_EVENT_MEDIASTOP = 915,
		icon_EVENT_MEDIAFIRST = 916,
		icon_EVENT_MEDIALAST = 917,
		icon_EVENT_APP = 918,
		icon_EVENT_CAPSLOCK = 919,
		icon_EVENT_BACKSPACE = 920,
		icon_EVENT_DEL = 921,
		icon_EVENT_SEMICOLON = 922,
		icon_EVENT_PERIOD = 923,
		icon_EVENT_COMMA = 924,
		icon_EVENT_QUOTE = 925,
		icon_EVENT_ACCENTGRAVE = 926,
		icon_EVENT_MINUS = 927,
		icon_EVENT_PLUS = 928,
		icon_EVENT_SLASH = 929,
		icon_EVENT_BACKSLASH = 930,
		icon_EVENT_EQUAL = 931,
		icon_EVENT_LEFTBRACKET = 932,
		icon_EVENT_RIGHTBRACKET = 933,
		icon_EVENT_PAD_PAN = 934,
		icon_EVENT_PAD_ROTATE = 935,
		icon_EVENT_PAD_ZOOM = 936,
		icon_EVENT_NDOF_BUTTON_V1 = 937,
		icon_EVENT_NDOF_BUTTON_V2 = 938,
		icon_EVENT_NDOF_BUTTON_V3 = 939,
		icon_EVENT_NDOF_BUTTON_SAVE_V1 = 940,
		icon_EVENT_NDOF_BUTTON_SAVE_V2 = 941,
		icon_EVENT_NDOF_BUTTON_SAVE_V3 = 942,
		icon_EVENT_NDOF_BUTTON_1 = 943,
		icon_EVENT_NDOF_BUTTON_2 = 944,
		icon_EVENT_NDOF_BUTTON_3 = 945,
		icon_EVENT_NDOF_BUTTON_4 = 946,
		icon_EVENT_NDOF_BUTTON_5 = 947,
		icon_EVENT_NDOF_BUTTON_6 = 948,
		icon_EVENT_NDOF_BUTTON_7 = 949,
		icon_EVENT_NDOF_BUTTON_8 = 950,
		icon_EVENT_NDOF_BUTTON_9 = 951,
		icon_EVENT_NDOF_BUTTON_10 = 952,
		icon_EVENT_NDOF_BUTTON_11 = 953,
		icon_EVENT_NDOF_BUTTON_12 = 954,
		icon_EVENT_NDOF_BUTTON_MENU = 955,
		icon_EVENT_NDOF_BUTTON_FIT = 956,
		icon_EVENT_NDOF_BUTTON_TOP = 957,
		icon_EVENT_NDOF_BUTTON_BOTTOM = 958,
		icon_EVENT_NDOF_BUTTON_LEFT = 959,
		icon_EVENT_NDOF_BUTTON_RIGHT = 960,
		icon_EVENT_NDOF_BUTTON_FRONT = 961,
		icon_EVENT_NDOF_BUTTON_BACK = 962,
		icon_EVENT_NDOF_BUTTON_ISO1 = 963,
		icon_EVENT_NDOF_BUTTON_ISO2 = 964,
		icon_EVENT_NDOF_BUTTON_ROLL_CW = 965,
		icon_EVENT_NDOF_BUTTON_ROLL_CCW = 966,
		icon_EVENT_NDOF_BUTTON_SPIN_CW = 967,
		icon_EVENT_NDOF_BUTTON_SPIN_CCW = 968,
		icon_EVENT_NDOF_BUTTON_TILT_CW = 969,
		icon_EVENT_NDOF_BUTTON_TILT_CCW = 970,
		icon_EVENT_NDOF_BUTTON_ROTATE = 971,
		icon_EVENT_NDOF_BUTTON_PANZOOM = 972,
		icon_EVENT_NDOF_BUTTON_DOMINANT = 973,
		icon_EVENT_NDOF_BUTTON_PLUS = 974,
		icon_EVENT_NDOF_BUTTON_MINUS = 975,
		icon_NODE_SOCKET_FLOAT = 976,
		icon_NODE_SOCKET_VECTOR = 977,
		icon_NODE_SOCKET_RGBA = 978,
		icon_NODE_SOCKET_SHADER = 979,
		icon_NODE_SOCKET_BOOLEAN = 980,
		icon_NODE_SOCKET_INT = 981,
		icon_NODE_SOCKET_STRING = 982,
		icon_NODE_SOCKET_OBJECT = 983,
		icon_NODE_SOCKET_IMAGE = 984,
		icon_NODE_SOCKET_GEOMETRY = 985,
		icon_NODE_SOCKET_COLLECTION = 986,
		icon_NODE_SOCKET_TEXTURE = 987,
		icon_NODE_SOCKET_MATERIAL = 988,
		icon_NODE_SOCKET_ROTATION = 989,
		icon_NODE_SOCKET_MENU = 990,
		icon_NODE_SOCKET_MATRIX = 991,
		icon_NODE_SOCKET_BUNDLE = 992,
		icon_NODE_SOCKET_CLOSURE = 993,
	};
	inline icon_enum icon(void);
	inline void icon(icon_enum value);

};

/**************** Pointer Definition ****************/

class PointerProperty : public Property {
public:
	PointerProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline Struct fixed_type(void);

};

/**************** Collection Definition ****************/

class CollectionProperty : public Property {
public:
	CollectionProperty(const PointerRNA &ptr_arg) :
		Property(ptr_arg)
		{}

	inline Struct fixed_type(void);

};

/**************** Function Definition ****************/

class Function : public Pointer {
public:
	Function(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		parameters(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string identifier(void);
	inline void identifier(const std::string& value);
	inline std::string description(void);
	inline void description(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Property, Function, parameters, false, false, false)
	inline bool is_registered(void);
	inline void is_registered(bool value);
	inline bool is_registered_optional(void);
	inline void is_registered_optional(bool value);
	inline bool use_self(void);
	inline void use_self(bool value);
	inline bool use_self_type(void);
	inline void use_self_type(bool value);

};

/**************** Blender RNA ****************/

class BlenderRNA : public Pointer {
public:
	BlenderRNA(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		structs(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Struct, BlenderRNA, structs, true, true, true)

};

/**************** String Value ****************/

class PrimitiveString : public Pointer {
public:
	PrimitiveString(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string value(void);
	inline void value(const std::string& value);

};

/**************** Primitive Int ****************/

class PrimitiveInt : public Pointer {
public:
	PrimitiveInt(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int value(void);
	inline void value(int value);

};

/**************** Primitive Float ****************/

class PrimitiveFloat : public Pointer {
public:
	PrimitiveFloat(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float value(void);
	inline void value(float value);

};

/**************** Primitive Boolean ****************/

class PrimitiveBoolean : public Pointer {
public:
	PrimitiveBoolean(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool value(void);
	inline void value(bool value);

};

/**************** Unknown Type ****************/

class UnknownType : public Pointer {
public:
	UnknownType(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Any Type ****************/

class AnyType : public Pointer {
public:
	AnyType(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** ID ****************/

class ID : public Pointer {
public:
	ID(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline std::string name_full(void);
	inline void name_full(const std::string& value);
	enum id_type_enum {
		id_type_ACTION = 17217,
		id_type_ARMATURE = 21057,
		id_type_BRUSH = 21058,
		id_type_CACHEFILE = 17987,
		id_type_CAMERA = 16707,
		id_type_COLLECTION = 21063,
		id_type_CURVE = 21827,
		id_type_CURVES = 22083,
		id_type_FONT = 18006,
		id_type_GREASEPENCIL = 17479,
		id_type_GREASEPENCIL_V3 = 20551,
		id_type_IMAGE = 19785,
		id_type_KEY = 17739,
		id_type_LATTICE = 21580,
		id_type_LIBRARY = 18764,
		id_type_LIGHT = 16716,
		id_type_LIGHT_PROBE = 20556,
		id_type_LINESTYLE = 21324,
		id_type_MASK = 21325,
		id_type_MATERIAL = 16717,
		id_type_MESH = 17741,
		id_type_META = 16973,
		id_type_MOVIECLIP = 17229,
		id_type_NODETREE = 21582,
		id_type_OBJECT = 16975,
		id_type_PAINTCURVE = 17232,
		id_type_PALETTE = 19536,
		id_type_PARTICLE = 16720,
		id_type_POINTCLOUD = 21584,
		id_type_SCENE = 17235,
		id_type_SCREEN = 21075,
		id_type_SOUND = 20307,
		id_type_SPEAKER = 19283,
		id_type_TEXT = 22612,
		id_type_TEXTURE = 17748,
		id_type_VOLUME = 20310,
		id_type_WINDOWMANAGER = 19799,
		id_type_WORKSPACE = 21335,
		id_type_WORLD = 20311,
	};
	inline id_type_enum id_type(void);
	inline void id_type(id_type_enum value);
	inline int session_uid(void);
	inline void session_uid(int value);
	inline bool is_evaluated(void);
	inline void is_evaluated(bool value);
	inline ID original(void);
	inline int users(void);
	inline void users(int value);
	inline bool use_fake_user(void);
	inline void use_fake_user(bool value);
	inline bool use_extra_user(void);
	inline void use_extra_user(bool value);
	inline bool is_embedded_data(void);
	inline void is_embedded_data(bool value);
	inline bool is_missing(void);
	inline void is_missing(bool value);
	inline bool is_runtime_data(void);
	inline void is_runtime_data(bool value);
	inline bool is_editable(void);
	inline void is_editable(bool value);
	inline bool tag(void);
	inline void tag(bool value);
	inline bool is_library_indirect(void);
	inline void is_library_indirect(bool value);
	inline Library library(void);
	inline LibraryWeakReference library_weak_reference(void);
	inline AssetMetaData asset_data(void);
	inline IDOverrideLibrary override_library(void);
	inline ImagePreview preview(void);

	inline int rename(void *main, const char * name, int mode);
	inline ID evaluated_get(Depsgraph& depsgraph);
	inline ID copy(void *main);
	inline void asset_mark();
	inline void asset_clear();
	inline void asset_generate_preview(Context C);
	inline ID override_create(void *main, bool remap_local_usages);
	inline ID override_hierarchy_create(void *main, Scene& scene, ViewLayer& view_layer, ID& reference, bool do_fully_editable);
	inline void user_clear();
	inline void user_remap(void *main, ID& new_id);
	inline ID make_local(void *main, bool clear_proxy, bool clear_liboverride, bool clear_asset_data);
	inline int user_of_id(ID& id);
	inline AnimData animation_data_create(void *main);
	inline void animation_data_clear(void *main);
	inline void update_tag(void *main, int refresh);
	inline ImagePreview preview_ensure();
};

/**************** Override Properties ****************/

class IDOverrideLibraryProperties : public Pointer {
public:
	IDOverrideLibraryProperties(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline IDOverrideLibraryProperty add(const char * rna_path);
	inline void remove(IDOverrideLibraryProperty& property);
};

/**************** Override Operations ****************/

class IDOverrideLibraryPropertyOperations : public Pointer {
public:
	IDOverrideLibraryPropertyOperations(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline IDOverrideLibraryPropertyOperation add(int operation, bool use_id, const char * subitem_reference_name, const char * subitem_local_name, ID& subitem_reference_id, ID& subitem_local_id, int subitem_reference_index, int subitem_local_index);
	inline void remove(IDOverrideLibraryPropertyOperation& operation);
};

/**************** ID Materials ****************/

class IDMaterials : public Pointer {
public:
	IDMaterials(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void append(void *main, Material& material);
	inline Material pop(void *main, int index);
	inline void clear(void *main);
};

/**************** Action Slots ****************/

class ActionSlots : public Pointer {
public:
	ActionSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ActionSlot active(void);

	inline ActionSlot create(void *main, Context C, int id_type, const char * name);
	inline void remove(Context C, ActionSlot& action_slot);
};

/**************** Action Layers ****************/

class ActionLayers : public Pointer {
public:
	ActionLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ActionLayer create(Context C, const char * name);
	inline void remove(Context C, ActionLayer& anim_layer);
};

/**************** Action Pose Markers ****************/

class ActionPoseMarkers : public Pointer {
public:
	ActionPoseMarkers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline TimelineMarker active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline TimelineMarker create(const char * name);
	inline void remove(TimelineMarker& marker);
};

/**************** Action F-Curves ****************/

class ActionFCurves : public Pointer {
public:
	ActionFCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FCurve create(void *main, const char * data_path, int index, const char * action_group);
	inline FCurve find(const char * data_path, int index);
	inline void remove(FCurve& fcurve);
	inline void clear();
};

/**************** Action Groups ****************/

class ActionGroups : public Pointer {
public:
	ActionGroups(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ActionGroup create(const char * name);
	inline void remove(ActionGroup& action_group);
};

/**************** Action Strips ****************/

class ActionStrips : public Pointer {
public:
	ActionStrips(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ActionStrip create(Context C, int type);
	inline void remove(Context C, ActionStrip& anim_strip);
};

/**************** Animation Channels for Slots ****************/

class ActionChannelbags : public Pointer {
public:
	ActionChannelbags(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ActionChannelbag create(Context C, ActionSlot& slot);
	inline void remove(Context C, ActionChannelbag& channelbag);
};

/**************** F-Curves ****************/

class ActionChannelbagFCurves : public Pointer {
public:
	ActionChannelbagFCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FCurve create(void *main, const char * data_path, int index);
	inline FCurve find(const char * data_path, int index);
	inline void remove(Context C, FCurve& fcurve);
	inline void clear(Context C);
};

/**************** F-Curve Groups ****************/

class ActionChannelbagGroups : public Pointer {
public:
	ActionChannelbagGroups(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ActionGroup create(const char * name);
	inline void remove(ActionGroup& action_group);
};

/**************** NLA Tracks ****************/

class NlaTracks : public Pointer {
public:
	NlaTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline NlaTrack active(void);

	inline NlaTrack create(void *main, Context C, NlaTrack& prev);
	inline void remove(void *main, Context C, NlaTrack& track);
};

/**************** Drivers ****************/

class AnimDataDrivers : public Pointer {
public:
	AnimDataDrivers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FCurve create(void *main, const char * data_path, int index);
	inline void remove(void *main, FCurve& driver);
	inline FCurve from_existing(Context C, FCurve& src_driver);
	inline FCurve find(const char * data_path, int index);
};

/**************** Keying set paths ****************/

class KeyingSetPaths : public Pointer {
public:
	KeyingSetPaths(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline KeyingSetPath active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline KeyingSetPath add(ID& target_id, const char * data_path, int index, int group_method, const char * group_name);
	inline void remove(KeyingSetPath& path);
	inline void clear();
};

/**************** Armature Bones ****************/

class ArmatureBones : public Pointer {
public:
	ArmatureBones(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Bone active(void);

};

/**************** Armature EditBones ****************/

class ArmatureEditBones : public Pointer {
public:
	ArmatureEditBones(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline EditBone active(void);

	inline EditBone create(const char * name);
	inline void remove(EditBone& bone);
};

/**************** Armature Bone Collections ****************/

class BoneCollections : public Pointer {
public:
	BoneCollections(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline BoneCollection active(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline std::string active_name(void);
	inline void active_name(const std::string& value);
	inline bool is_solo_active(void);
	inline void is_solo_active(bool value);

	inline BoneCollection create(const char * name, BoneCollection& parent);
	inline void remove(BoneCollection& bone_collection);
	inline void move(int from_index, int to_index);
};

/**************** Bone Collection Memberships ****************/

class BoneCollectionMemberships : public Pointer {
public:
	BoneCollectionMemberships(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void clear();
};

/**************** Attribute Group ****************/

class AttributeGroupMesh : public Pointer {
public:
	AttributeGroupMesh(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Attribute active(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline Attribute active_color(void);
	inline int active_color_index(void);
	inline void active_color_index(int value);
	inline int render_color_index(void);
	inline void render_color_index(int value);
	inline std::string default_color_name(void);
	inline void default_color_name(const std::string& value);
	inline std::string active_color_name(void);
	inline void active_color_name(const std::string& value);

	inline Attribute create(const char * name, int type, int domain);
	inline void remove(Attribute& attribute);
	inline int domain_size(int domain);
};

/**************** Attribute Group ****************/

class AttributeGroupPointCloud : public Pointer {
public:
	AttributeGroupPointCloud(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Attribute active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline Attribute create(const char * name, int type, int domain);
	inline void remove(Attribute& attribute);
	inline int domain_size(int domain);
};

/**************** Attribute Group ****************/

class AttributeGroupCurves : public Pointer {
public:
	AttributeGroupCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Attribute active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline Attribute create(const char * name, int type, int domain);
	inline void remove(Attribute& attribute);
	inline int domain_size(int domain);
};

/**************** Attribute Group ****************/

class AttributeGroupGreasePencil : public Pointer {
public:
	AttributeGroupGreasePencil(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Attribute active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline Attribute create(const char * name, int type, int domain);
	inline void remove(Attribute& attribute);
	inline int domain_size(int domain);
};

/**************** Attribute Group ****************/

class AttributeGroupGreasePencilDrawing : public Pointer {
public:
	AttributeGroupGreasePencilDrawing(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Attribute active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline Attribute create(const char * name, int type, int domain);
	inline void remove(Attribute& attribute);
	inline int domain_size(int domain);
};

/**************** Asset Tags ****************/

class AssetTags : public Pointer {
public:
	AssetTags(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline AssetTag create(const char * name, bool skip_if_exists);
	inline void remove(AssetTag& tag);
};

/**************** Cache Layers ****************/

class CacheFileLayers : public Pointer {
public:
	CacheFileLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline CacheFileLayer active(void);

	inline CacheFileLayer create(Context C, const char * filepath);
	inline void remove(Context C, CacheFileLayer& layer);
};

/**************** Object Paths ****************/

class CacheObjectPaths : public Pointer {
public:
	CacheObjectPaths(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Background Images ****************/

class CameraBackgroundImages : public Pointer {
public:
	CameraBackgroundImages(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline CameraBackgroundImage create();
	inline void remove(CameraBackgroundImage& image);
	inline void clear();
};

/**************** Collection Objects ****************/

class CollectionObjects : public Pointer {
public:
	CollectionObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void link(void *main, Object& object);
	inline void unlink(void *main, Object& object);
};

/**************** Collection Children ****************/

class CollectionChildren : public Pointer {
public:
	CollectionChildren(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void link(void *main, Collection& child);
	inline void unlink(void *main, Collection& child);
};

/**************** Curve Map Point ****************/

class CurveMapPoints : public Pointer {
public:
	CurveMapPoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline CurveMapPoint create(float position, float value);
	inline void remove(CurveMapPoint& point);
};

/**************** Color Ramp Elements ****************/

class ColorRampElements : public Pointer {
public:
	ColorRampElements(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ColorRampElement create(float position);
	inline void remove(ColorRampElement& element);
};

/**************** Armature Deform Constraint Targets ****************/

class ArmatureConstraintTargets : public Pointer {
public:
	ArmatureConstraintTargets(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ConstraintTargetBone create(void *main);
	inline void remove(void *main, ConstraintTargetBone& target);
	inline void clear(void *main);
};

/**************** Curve Splines ****************/

class CurveSplines : public Pointer {
public:
	CurveSplines(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Spline active(void);

	inline Spline create(int type);
	inline void remove(Spline& spline);
	inline void clear();
};

/**************** Spline Points ****************/

class SplinePoints : public Pointer {
public:
	SplinePoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Spline Bézier Points ****************/

class SplineBezierPoints : public Pointer {
public:
	SplineBezierPoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Canvas Surfaces ****************/

class DynamicPaintSurfaces : public Pointer {
public:
	DynamicPaintSurfaces(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline DynamicPaintSurface active(void);

};

/**************** Keyframe Points ****************/

class FCurveKeyframePoints : public Pointer {
public:
	FCurveKeyframePoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Keyframe insert(void *main, float frame, float value, int options, int keyframe_type);
	inline void add(void *main, int count);
	inline void remove(void *main, Keyframe& keyframe, bool fast);
	inline void clear(void *main);
	inline void sort(void *main);
	inline void deduplicate(void *main);
	inline void handles_recalc(void *main);
};

/**************** F-Curve Modifiers ****************/

class FCurveModifiers : public Pointer {
public:
	FCurveModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline FModifier active(void);

	inline FModifier create(int type);
	inline void remove(FModifier& modifier);
};

/**************** ChannelDriver Variables ****************/

class ChannelDriverVariables : public Pointer {
public:
	ChannelDriverVariables(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline DriverVariable create();
	inline void remove(DriverVariable& variable);
};

/**************** Control Points ****************/

class FModifierEnvelopeControlPoints : public Pointer {
public:
	FModifierEnvelopeControlPoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FModifierEnvelopeControlPoint add(void *main, float frame);
	inline void remove(void *main, FModifierEnvelopeControlPoint& point);
};

/**************** Annotation Layers ****************/

class GreasePencilLayers : public Pointer {
public:
	GreasePencilLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);
	enum active_note_enum {
		active_note_DEFAULT = 0,
	};
	inline active_note_enum active_note(void);
	inline void active_note(active_note_enum value);

	inline GPencilLayer create(const char * name, bool set_active);
	inline void remove(GPencilLayer& layer);
};

/**************** Annotation Frames ****************/

class GPencilFrames : public Pointer {
public:
	GPencilFrames(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline GPencilFrame create(int frame_number, bool active);
	inline void remove(GPencilFrame& frame);
	inline GPencilFrame copy(GPencilFrame& source);
};

/**************** Grease Pencil Layers ****************/

class GreasePencilv3Layers : public Pointer {
public:
	GreasePencilv3Layers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline GreasePencilLayer active(void);

	inline GreasePencilLayer create(const char * name, bool set_active, GreasePencilLayerGroup& layer_group);
	inline void remove(GreasePencilLayer& layer);
	inline void move(GreasePencilLayer& layer, int type);
	inline void move_top(GreasePencilLayer& layer);
	inline void move_bottom(GreasePencilLayer& layer);
	inline void move_to_layer_group(GreasePencilLayer& layer, GreasePencilLayerGroup& layer_group);
};

/**************** Grease Pencil Group ****************/

class GreasePencilv3LayerGroup : public Pointer {
public:
	GreasePencilv3LayerGroup(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline GreasePencilLayerGroup active(void);

	inline GreasePencilLayerGroup create(const char * name, GreasePencilLayerGroup& parent_group);
	inline void remove(GreasePencilLayerGroup& layer_group, bool keep_children);
	inline void move(GreasePencilLayerGroup& layer_group, int type);
	inline void move_top(GreasePencilLayerGroup& layer_group);
	inline void move_bottom(GreasePencilLayerGroup& layer_group);
	inline void move_to_layer_group(GreasePencilLayerGroup& layer_group, GreasePencilLayerGroup& parent_group);
};

/**************** Grease Pencil Frames ****************/

class GreasePencilFrames : public Pointer {
public:
	GreasePencilFrames(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline GreasePencilFrame create(int frame_number);
	inline void remove(int frame_number);
	inline GreasePencilFrame copy(int from_frame_number, int to_frame_number, bool instance_drawing);
	inline GreasePencilFrame move(int from_frame_number, int to_frame_number);
};

/**************** Grease Pencil Mask Layers ****************/

class GreasePencilLayerMasks : public Pointer {
public:
	GreasePencilLayerMasks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_mask_index(void);
	inline void active_mask_index(int value);

};

/**************** Render Layers ****************/

class RenderSlots : public Pointer {
public:
	RenderSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline RenderSlot active(void);

	inline RenderSlot create(const char * name);
};

/**************** UDIM Tiles ****************/

class UDIMTiles : public Pointer {
public:
	UDIMTiles(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline UDIMTile active(void);

	inline UDIMTile create(int tile_number, const char * label);
	inline UDIMTile get(int tile_number);
	inline void remove(UDIMTile& tile);
};

/**************** List of AOVs ****************/

class AOVs : public Pointer {
public:
	AOVs(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline AOV add();
	inline void remove(AOV& aov);
};

/**************** List of Lightgroups ****************/

class Lightgroups : public Pointer {
public:
	Lightgroups(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Lightgroup add(const char * name);
	inline void remove(Lightgroup& lightgroup);
};

/**************** Layer Objects ****************/

class LayerObjects : public Pointer {
public:
	LayerObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		selected(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object active(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Object, LayerObjects, selected, false, true, true)

};

/**************** Style Modules ****************/

class FreestyleModules : public Pointer {
public:
	FreestyleModules(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FreestyleModuleSettings create();
	inline void remove(FreestyleModuleSettings& module);
};

/**************** Line Sets ****************/

class Linesets : public Pointer {
public:
	Linesets(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline FreestyleLineSet active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline FreestyleLineSet create(void *main, const char * name);
	inline void remove(FreestyleLineSet& lineset);
};

/**************** Texture Slots ****************/

class LineStyleTextureSlots : public Pointer {
public:
	LineStyleTextureSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleTextureSlot add(Context C);
	inline LineStyleTextureSlot create(Context C, int index);
	inline void clear(Context C, int index);
};

/**************** Color Modifiers ****************/

class LineStyleColorModifiers : public Pointer {
public:
	LineStyleColorModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleColorModifier create(const char * name, int type);
	inline void remove(LineStyleColorModifier& modifier);
};

/**************** Alpha Modifiers ****************/

class LineStyleAlphaModifiers : public Pointer {
public:
	LineStyleAlphaModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleAlphaModifier create(const char * name, int type);
	inline void remove(LineStyleAlphaModifier& modifier);
};

/**************** Thickness Modifiers ****************/

class LineStyleThicknessModifiers : public Pointer {
public:
	LineStyleThicknessModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleThicknessModifier create(const char * name, int type);
	inline void remove(LineStyleThicknessModifier& modifier);
};

/**************** Geometry Modifiers ****************/

class LineStyleGeometryModifiers : public Pointer {
public:
	LineStyleGeometryModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LineStyleGeometryModifier create(const char * name, int type);
	inline void remove(LineStyleGeometryModifier& modifier);
};

/**************** Blendfile Import Context Libraries ****************/

class BlendImportContextLibraries : public Pointer {
public:
	BlendImportContextLibraries(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Blendfile Import Context Items ****************/

class BlendImportContextItems : public Pointer {
public:
	BlendImportContextItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Main Cameras ****************/

class BlendDataCameras : public Pointer {
public:
	BlendDataCameras(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Camera create(const char * name);
	inline void remove(Camera& camera, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Scenes ****************/

class BlendDataScenes : public Pointer {
public:
	BlendDataScenes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Scene create(const char * name);
	inline void remove(Context C, Scene& scene, bool do_unlink);
	inline void tag(bool value);
};

/**************** Main Objects ****************/

class BlendDataObjects : public Pointer {
public:
	BlendDataObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Object create(const char * name, ID& object_data);
	inline void remove(Object& object, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Materials ****************/

class BlendDataMaterials : public Pointer {
public:
	BlendDataMaterials(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Material create(const char * name);
	inline void create_gpencil_data(Material& material);
	inline void remove_gpencil_data(Material& material);
	inline void remove(Material& material, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Node Trees ****************/

class BlendDataNodeTrees : public Pointer {
public:
	BlendDataNodeTrees(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeTree create(const char * name, int type);
	inline void remove(NodeTree& tree, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Meshes ****************/

class BlendDataMeshes : public Pointer {
public:
	BlendDataMeshes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Mesh create(const char * name);
	inline Mesh new_from_object(Object& object, bool preserve_all_data_layers, Depsgraph& depsgraph);
	inline void remove(Mesh& mesh, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Lights ****************/

class BlendDataLights : public Pointer {
public:
	BlendDataLights(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Light create(const char * name, int type);
	inline void remove(Light& light, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Libraries ****************/

class BlendDataLibraries : public Pointer {
public:
	BlendDataLibraries(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
	inline void remove(Library& library, bool do_unlink, bool do_id_user, bool do_ui_user);
};

/**************** Main Screens ****************/

class BlendDataScreens : public Pointer {
public:
	BlendDataScreens(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
};

/**************** Main Window Managers ****************/

class BlendDataWindowManagers : public Pointer {
public:
	BlendDataWindowManagers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
};

/**************** Main Images ****************/

class BlendDataImages : public Pointer {
public:
	BlendDataImages(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Image create(const char * name, int width, int height, bool alpha, bool float_buffer, bool stereo3d, bool is_data, bool tiled);
	inline Image load(const char * filepath, bool check_existing);
	inline void remove(Image& image, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Lattices ****************/

class BlendDataLattices : public Pointer {
public:
	BlendDataLattices(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Lattice create(const char * name);
	inline void remove(Lattice& lattice, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Curves ****************/

class BlendDataCurves : public Pointer {
public:
	BlendDataCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Curve create(const char * name, int type);
	inline void remove(Curve& curve, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Metaballs ****************/

class BlendDataMetaBalls : public Pointer {
public:
	BlendDataMetaBalls(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MetaBall create(const char * name);
	inline void remove(MetaBall& metaball, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Fonts ****************/

class BlendDataFonts : public Pointer {
public:
	BlendDataFonts(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline VectorFont load(const char * filepath, bool check_existing);
	inline void remove(VectorFont& vfont, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Textures ****************/

class BlendDataTextures : public Pointer {
public:
	BlendDataTextures(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Texture create(const char * name, int type);
	inline void remove(Texture& texture, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Brushes ****************/

class BlendDataBrushes : public Pointer {
public:
	BlendDataBrushes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Brush create(const char * name, int mode);
	inline void remove(Brush& brush, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
	inline void create_gpencil_data(Brush& brush);
};

/**************** Main Worlds ****************/

class BlendDataWorlds : public Pointer {
public:
	BlendDataWorlds(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline World create(const char * name);
	inline void remove(World& world, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Collections ****************/

class BlendDataCollections : public Pointer {
public:
	BlendDataCollections(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Collection create(const char * name);
	inline void remove(Collection& collection, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Texts ****************/

class BlendDataTexts : public Pointer {
public:
	BlendDataTexts(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Text create(const char * name);
	inline void remove(Text& text, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline Text load(const char * filepath, bool internal);
	inline void tag(bool value);
};

/**************** Main Speakers ****************/

class BlendDataSpeakers : public Pointer {
public:
	BlendDataSpeakers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Speaker create(const char * name);
	inline void remove(Speaker& speaker, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Sounds ****************/

class BlendDataSounds : public Pointer {
public:
	BlendDataSounds(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Sound load(const char * filepath, bool check_existing);
	inline void remove(Sound& sound, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Armatures ****************/

class BlendDataArmatures : public Pointer {
public:
	BlendDataArmatures(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Armature create(const char * name);
	inline void remove(Armature& armature, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Actions ****************/

class BlendDataActions : public Pointer {
public:
	BlendDataActions(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Action create(const char * name);
	inline void remove(Action& action, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Particle Settings ****************/

class BlendDataParticles : public Pointer {
public:
	BlendDataParticles(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ParticleSettings create(const char * name);
	inline void remove(ParticleSettings& particle, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Palettes ****************/

class BlendDataPalettes : public Pointer {
public:
	BlendDataPalettes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Palette create(const char * name);
	inline void remove(Palette& palette, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Annotations ****************/

class BlendDataGreasePencils : public Pointer {
public:
	BlendDataGreasePencils(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
	inline GreasePencil create(const char * name);
	inline void remove(GreasePencil& grease_pencil, bool do_unlink, bool do_id_user, bool do_ui_user);
};

/**************** Main Grease Pencils ****************/

class BlendDataGreasePencilsV3 : public Pointer {
public:
	BlendDataGreasePencilsV3(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
	inline GreasePencilv3 create(const char * name);
	inline void remove(GreasePencilv3& grease_pencil, bool do_unlink, bool do_id_user, bool do_ui_user);
};

/**************** Main Movie Clips ****************/

class BlendDataMovieClips : public Pointer {
public:
	BlendDataMovieClips(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
	inline void remove(MovieClip& clip, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline MovieClip load(const char * filepath, bool check_existing);
};

/**************** Main Masks ****************/

class BlendDataMasks : public Pointer {
public:
	BlendDataMasks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
	inline Mask create(const char * name);
	inline void remove(Mask& mask, bool do_unlink, bool do_id_user, bool do_ui_user);
};

/**************** Main Line Styles ****************/

class BlendDataLineStyles : public Pointer {
public:
	BlendDataLineStyles(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
	inline FreestyleLineStyle create(const char * name);
	inline void remove(FreestyleLineStyle& linestyle, bool do_unlink, bool do_id_user, bool do_ui_user);
};

/**************** Main Cache Files ****************/

class BlendDataCacheFiles : public Pointer {
public:
	BlendDataCacheFiles(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
};

/**************** Main Paint Curves ****************/

class BlendDataPaintCurves : public Pointer {
public:
	BlendDataPaintCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
};

/**************** Main Workspaces ****************/

class BlendDataWorkSpaces : public Pointer {
public:
	BlendDataWorkSpaces(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void tag(bool value);
};

/**************** Main Light Probes ****************/

class BlendDataProbes : public Pointer {
public:
	BlendDataProbes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline LightProbe create(const char * name, int type);
	inline void remove(LightProbe& lightprobe, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Hair Curves ****************/

class BlendDataHairCurves : public Pointer {
public:
	BlendDataHairCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Curves create(const char * name);
	inline void remove(Curves& curves, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Point Clouds ****************/

class BlendDataPointClouds : public Pointer {
public:
	BlendDataPointClouds(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline PointCloud create(const char * name);
	inline void remove(PointCloud& pointcloud, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Main Volumes ****************/

class BlendDataVolumes : public Pointer {
public:
	BlendDataVolumes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Volume create(const char * name);
	inline void remove(Volume& volume, bool do_unlink, bool do_id_user, bool do_ui_user);
	inline void tag(bool value);
};

/**************** Mesh Vertices ****************/

class MeshVertices : public Pointer {
public:
	MeshVertices(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Mesh Edges ****************/

class MeshEdges : public Pointer {
public:
	MeshEdges(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Mesh Loops ****************/

class MeshLoops : public Pointer {
public:
	MeshLoops(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
};

/**************** Mesh Polygons ****************/

class MeshPolygons : public Pointer {
public:
	MeshPolygons(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active(void);
	inline void active(int value);

	inline void add(int count);
};

/**************** Mesh Loop Triangles ****************/

class MeshLoopTriangles : public Pointer {
public:
	MeshLoopTriangles(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** UV Map Layers ****************/

class UVLoopLayers : public Pointer {
public:
	UVLoopLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MeshUVLoopLayer active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline MeshUVLoopLayer create(const char * name, bool do_init);
	inline void remove(MeshUVLoopLayer& layer);
};

/**************** Loop Colors ****************/

class LoopColors : public Pointer {
public:
	LoopColors(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MeshLoopColorLayer active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline MeshLoopColorLayer create(const char * name, bool do_init);
	inline void remove(MeshLoopColorLayer& layer);
};

/**************** Metaball Elements ****************/

class MetaBallElements : public Pointer {
public:
	MetaBallElements(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MetaElement active(void);

	inline MetaElement create(int type);
	inline void remove(MetaElement& element);
	inline void clear();
};

/**************** Data-Blocks ****************/

class NodesModifierBakeDataBlocks : public Pointer {
public:
	NodesModifierBakeDataBlocks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** Bakes ****************/

class NodesModifierBakes : public Pointer {
public:
	NodesModifierBakes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Panels ****************/

class NodesModifierPanels : public Pointer {
public:
	NodesModifierPanels(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** NLA Strips ****************/

class NlaStrips : public Pointer {
public:
	NlaStrips(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NlaStrip create(void *main, Context C, const char * name, int start, Action& action);
	inline void remove(void *main, Context C, NlaStrip& strip);
};

/**************** NLA-Strip F-Curves ****************/

class NlaStripFCurves : public Pointer {
public:
	NlaStripFCurves(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline FCurve find(const char * data_path, int index);
};

/**************** Node Inputs ****************/

class NodeInputs : public Pointer {
public:
	NodeInputs(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocket create(void *main, const char * type, const char * name, const char * identifier, bool use_multi_input);
	inline void remove(void *main, NodeSocket& socket);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Node Outputs ****************/

class NodeOutputs : public Pointer {
public:
	NodeOutputs(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocket create(void *main, const char * type, const char * name, const char * identifier, bool use_multi_input);
	inline void remove(void *main, NodeSocket& socket);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Nodes ****************/

class Nodes : public Pointer {
public:
	Nodes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Node active(void);

	inline Node create(Context C, const char * type);
	inline void remove(void *main, Node& node);
	inline void clear(void *main);
};

/**************** Node Links ****************/

class NodeLinks : public Pointer {
public:
	NodeLinks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeLink create(void *main, NodeSocket& input, NodeSocket& output, bool verify_limits, bool handle_dynamic_sockets);
	inline void remove(void *main, NodeLink& link);
	inline void clear(void *main);
};

/**************** File Output Slots ****************/

class CompositorNodeOutputFileFileSlots : public Pointer {
public:
	CompositorNodeOutputFileFileSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocket create(Context C, const char * name);
	inline void remove(void *main, NodeSocket& socket);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** File Output Slots ****************/

class CompositorNodeOutputFileLayerSlots : public Pointer {
public:
	CompositorNodeOutputFileLayerSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeSocket create(Context C, const char * name);
	inline void remove(void *main, NodeSocket& socket);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Items ****************/

class NodeFunctionFormatStringItems : public Pointer {
public:
	NodeFunctionFormatStringItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeFunctionFormatStringItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeFunctionFormatStringItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Items ****************/

class NodeGeometryBakeItems : public Pointer {
public:
	NodeGeometryBakeItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeGeometryBakeItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeGeometryBakeItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Items ****************/

class NodeGeometryCaptureAttributeItems : public Pointer {
public:
	NodeGeometryCaptureAttributeItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeGeometryCaptureAttributeItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeGeometryCaptureAttributeItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Closure Input Items ****************/

class NodeGeometryClosureInputItems : public Pointer {
public:
	NodeGeometryClosureInputItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeGeometryClosureInputItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeGeometryClosureInputItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Closure Output Items ****************/

class NodeGeometryClosureOutputItems : public Pointer {
public:
	NodeGeometryClosureOutputItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeGeometryClosureOutputItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeGeometryClosureOutputItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Items ****************/

class NodeGeometryCombineBundleItems : public Pointer {
public:
	NodeGeometryCombineBundleItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeGeometryCombineBundleItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeGeometryCombineBundleItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Input Items ****************/

class NodeGeometryEvaluateClosureInputItems : public Pointer {
public:
	NodeGeometryEvaluateClosureInputItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeGeometryEvaluateClosureInputItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeGeometryEvaluateClosureInputItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Output Items ****************/

class NodeGeometryEvaluateClosureOutputItems : public Pointer {
public:
	NodeGeometryEvaluateClosureOutputItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeGeometryEvaluateClosureOutputItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeGeometryEvaluateClosureOutputItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Input Items ****************/

class NodeGeometryForeachGeometryElementInputItems : public Pointer {
public:
	NodeGeometryForeachGeometryElementInputItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ForeachGeometryElementInputItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, ForeachGeometryElementInputItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Main Items ****************/

class NodeGeometryForeachGeometryElementMainItems : public Pointer {
public:
	NodeGeometryForeachGeometryElementMainItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ForeachGeometryElementMainItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, ForeachGeometryElementMainItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Generation Items ****************/

class NodeGeometryForeachGeometryElementGenerationItems : public Pointer {
public:
	NodeGeometryForeachGeometryElementGenerationItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ForeachGeometryElementGenerationItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, ForeachGeometryElementGenerationItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Items ****************/

class NodeIndexSwitchItems : public Pointer {
public:
	NodeIndexSwitchItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline IndexSwitchItem create(void *main);
	inline void remove(void *main, IndexSwitchItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Enum Definition Items ****************/

class NodeMenuSwitchItems : public Pointer {
public:
	NodeMenuSwitchItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeEnumItem create(void *main, const char * name);
	inline void remove(void *main, NodeEnumItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Items ****************/

class NodeGeometryRepeatOutputItems : public Pointer {
public:
	NodeGeometryRepeatOutputItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline RepeatItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, RepeatItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Items ****************/

class NodeGeometrySeparateBundleItems : public Pointer {
public:
	NodeGeometrySeparateBundleItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline NodeGeometrySeparateBundleItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, NodeGeometrySeparateBundleItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Items ****************/

class NodeGeometrySimulationOutputItems : public Pointer {
public:
	NodeGeometrySimulationOutputItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline SimulationStateItem create(void *main, int socket_type, const char * name);
	inline void remove(void *main, SimulationStateItem& item);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Object Modifiers ****************/

class ObjectModifiers : public Pointer {
public:
	ObjectModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Modifier active(void);

	inline Modifier create(Context C, const char * name, int type);
	inline void remove(Context C, Modifier& modifier);
	inline void clear(Context C);
	inline void move(int from_index, int to_index);
};

/**************** Object Shader Effects ****************/

class ObjectShaderFx : public Pointer {
public:
	ObjectShaderFx(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ShaderFx create(Context C, const char * name, int type);
	inline void remove(Context C, ShaderFx& shader_fx);
	inline void clear(Context C);
};

/**************** Object Constraints ****************/

class ObjectConstraints : public Pointer {
public:
	ObjectConstraints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Constraint active(void);

	inline Constraint create(void *main, int type);
	inline void remove(void *main, Constraint& constraint);
	inline void clear(void *main);
	inline void move(void *main, int from_index, int to_index);
	inline Constraint copy(void *main, Constraint& constraint);
};

/**************** Vertex Groups ****************/

class VertexGroups : public Pointer {
public:
	VertexGroups(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline VertexGroup active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline VertexGroup create(void *main, const char * name);
	inline void remove(void *main, VertexGroup& group);
	inline void clear(void *main);
};

/**************** Particle Systems ****************/

class ParticleSystems : public Pointer {
public:
	ParticleSystems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ParticleSystem active(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** Point Caches ****************/

class PointCaches : public Pointer {
public:
	PointCaches(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** Palette Splines ****************/

class PaletteColors : public Pointer {
public:
	PaletteColors(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline PaletteColor active(void);

	inline PaletteColor create();
	inline void remove(PaletteColor& color);
	inline void clear();
};

/**************** Texture Slots ****************/

class ParticleSettingsTextureSlots : public Pointer {
public:
	ParticleSettingsTextureSlots(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ParticleSettingsTextureSlot add(Context C);
	inline ParticleSettingsTextureSlot create(Context C, int index);
	inline void clear(Context C, int index);
};

/**************** PoseBone Constraints ****************/

class PoseBoneConstraints : public Pointer {
public:
	PoseBoneConstraints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Constraint active(void);

	inline Constraint create(void *main, int type);
	inline void remove(void *main, Constraint& constraint);
	inline void move(void *main, int from_index, int to_index);
	inline Constraint copy(void *main, Constraint& constraint);
};

/**************** Profile Point ****************/

class CurveProfilePoints : public Pointer {
public:
	CurveProfilePoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline CurveProfilePoint add(float x, float y);
	inline void remove(CurveProfilePoint& point);
};

/**************** Render Passes ****************/

class RenderPasses : public Pointer {
public:
	RenderPasses(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline RenderPass find_by_type(int pass_type, const char * view);
	inline RenderPass find_by_name(const char * name, const char * view);
};

/**************** Scene Objects ****************/

class SceneObjects : public Pointer {
public:
	SceneObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Keying Sets ****************/

class KeyingSets : public Pointer {
public:
	KeyingSets(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline KeyingSet active(void);
	inline int active_index(void);
	inline void active_index(int value);

	inline KeyingSet create(const char * idname, const char * name);
};

/**************** Keying Sets All ****************/

class KeyingSetsAll : public Pointer {
public:
	KeyingSetsAll(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline KeyingSet active(void);
	inline int active_index(void);
	inline void active_index(int value);

};

/**************** Timeline Markers ****************/

class TimelineMarkers : public Pointer {
public:
	TimelineMarkers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline TimelineMarker create(const char * name, int frame);
	inline void remove(TimelineMarker& marker);
	inline void clear();
};

/**************** Render Layers ****************/

class ViewLayers : public Pointer {
public:
	ViewLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ViewLayer create(void *main, const char * name);
	inline void remove(void *main, ViewLayer& layer);
	inline void move(void *main, int from_index, int to_index);
};

/**************** Render Views ****************/

class RenderViews : public Pointer {
public:
	RenderViews(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline SceneRenderView active(void);

	inline SceneRenderView create(const char * name);
	inline void remove(void *main, SceneRenderView& view);
};

/**************** Area Spaces ****************/

class AreaSpaces : public Pointer {
public:
	AreaSpaces(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Space active(void);

};

/**************** Strip Modifiers ****************/

class StripModifiers : public Pointer {
public:
	StripModifiers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline StripModifier create(Context C, const char * name, int type);
	inline void remove(Context C, StripModifier& modifier);
	inline void clear(Context C);
};

/**************** Strips ****************/

class StripsTopLevel : public Pointer {
public:
	StripsTopLevel(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Strip new_clip(void *main, const char * name, MovieClip& clip, int channel, int frame_start);
	inline Strip new_mask(void *main, const char * name, Mask& mask, int channel, int frame_start);
	inline Strip new_scene(void *main, const char * name, Scene& scene, int channel, int frame_start);
	inline Strip new_image(void *main, const char * name, const char * filepath, int channel, int frame_start, int fit_method);
	inline Strip new_movie(void *main, const char * name, const char * filepath, int channel, int frame_start, int fit_method);
	inline Strip new_sound(void *main, const char * name, const char * filepath, int channel, int frame_start);
	inline Strip new_meta(const char * name, int channel, int frame_start);
	inline Strip new_effect(const char * name, int type, int channel, int frame_start, int frame_end, Strip& input1, Strip& input2);
	inline void remove(void *main, Strip& sequence);
};

/**************** StripElements ****************/

class StripElements : public Pointer {
public:
	StripElements(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline StripElement append(const char * filename);
	inline void pop(int index);
};

/**************** Strips ****************/

class StripsMeta : public Pointer {
public:
	StripsMeta(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Strip new_clip(void *main, const char * name, MovieClip& clip, int channel, int frame_start);
	inline Strip new_mask(void *main, const char * name, Mask& mask, int channel, int frame_start);
	inline Strip new_scene(void *main, const char * name, Scene& scene, int channel, int frame_start);
	inline Strip new_image(void *main, const char * name, const char * filepath, int channel, int frame_start, int fit_method);
	inline Strip new_movie(void *main, const char * name, const char * filepath, int channel, int frame_start, int fit_method);
	inline Strip new_sound(void *main, const char * name, const char * filepath, int channel, int frame_start);
	inline Strip new_meta(const char * name, int channel, int frame_start);
	inline Strip new_effect(const char * name, int type, int channel, int frame_start, int frame_end, Strip& input1, Strip& input2);
	inline void remove(void *main, Strip& sequence);
};

/**************** RetimingKeys ****************/

class RetimingKeys : public Pointer {
public:
	RetimingKeys(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline RetimingKey add(int timeline_frame);
	inline void reset();
};

/**************** Path ****************/

class SpaceNodeEditorPath : public Pointer {
public:
	SpaceNodeEditorPath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string to_string(void);
	inline void to_string(const std::string& value);

	inline void clear(Context C);
	inline void start(Context C, NodeTree& node_tree);
	inline void append(Context C, NodeTree& node_tree, Node& node);
	inline void pop(Context C);
};

/**************** Spreadsheet Tables ****************/

class SpreadsheetTables : public Pointer {
public:
	SpreadsheetTables(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline SpreadsheetTable active(void);

};

/**************** User Add-ons ****************/

class Addons : public Pointer {
public:
	Addons(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Addon create();
	inline void remove(Addon& addon);
};

/**************** Paths Compare ****************/

class PathCompareCollection : public Pointer {
public:
	PathCompareCollection(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline PathCompare create();
	inline void remove(PathCompare& pathcmp);
};

/**************** Python Scripts Directories ****************/

class ScriptDirectoryCollection : public Pointer {
public:
	ScriptDirectoryCollection(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline ScriptDirectory create();
	inline void remove(ScriptDirectory& script_directory);
};

/**************** User Asset Libraries ****************/

class AssetLibraryCollection : public Pointer {
public:
	AssetLibraryCollection(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline UserAssetLibrary create(Context C, const char * name, const char * directory);
	inline void remove(Context C, UserAssetLibrary& library);
};

/**************** User Extension Repositories ****************/

class UserExtensionRepoCollection : public Pointer {
public:
	UserExtensionRepoCollection(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline UserExtensionRepo create(const char * name, const char * module, const char * custom_directory, const char * remote_url, int source);
	inline void remove(UserExtensionRepo& repo);
};

/**************** Studio Lights ****************/

class StudioLights : public Pointer {
public:
	StudioLights(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline StudioLight load(const char * path, int type);
	inline StudioLight create(const char * path);
	inline void remove(StudioLight& studio_light);
	inline void refresh();
};

/**************** Volume Grids ****************/

class VolumeGrids : public Pointer {
public:
	VolumeGrids(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int active_index(void);
	inline void active_index(int value);
	inline std::string error_message(void);
	inline void error_message(const std::string& value);
	inline bool is_loaded(void);
	inline void is_loaded(bool value);
	inline int frame(void);
	inline void frame(int value);
	inline std::string frame_filepath(void);
	inline void frame_filepath(const std::string& value);

	inline bool load(void *main);
	inline void unload();
	inline bool save(void *main, const char * filepath);
};

/**************** KeyConfigs ****************/

class KeyConfigurations : public Pointer {
public:
	KeyConfigurations(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline KeyConfig active(void);
	inline KeyConfig default_value(void);
	inline KeyConfig addon(void);
	inline KeyConfig user(void);

	inline KeyConfig create(const char * name);
	inline void remove(KeyConfig& keyconfig);
	inline KeyMapItem find_item_from_operator(Context C, const char * idname, int context, OperatorProperties& properties, int include, int exclude, KeyMap *keymap);
	inline void update(bool keep_properties);
};

/**************** Key Maps ****************/

class KeyMaps : public Pointer {
public:
	KeyMaps(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline KeyMap create(const char * name, int space_type, int region_type, bool modal, bool tool);
	inline void remove(KeyMap& keymap);
	inline void clear();
	inline KeyMap find(const char * name, int space_type, int region_type);
	inline KeyMap find_match(KeyMap& keymap);
	inline KeyMap find_modal(const char * name);
};

/**************** KeyMap Items ****************/

class KeyMapItems : public Pointer {
public:
	KeyMapItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline KeyMapItem create(const char * idname, int type, int value, bool any, int shift, int ctrl, int alt, int oskey, int hyper, int key_modifier, int direction, bool repeat, bool head);
	inline KeyMapItem new_modal(const char * propvalue, int type, int value, bool any, int shift, int ctrl, int alt, int oskey, int hyper, int key_modifier, int direction, bool repeat);
	inline KeyMapItem new_from_item(KeyMapItem& item, bool head);
	inline void remove(KeyMapItem& item);
	inline KeyMapItem from_id(int id);
	inline KeyMapItem find_from_operator(const char * idname, OperatorProperties& properties, int include, int exclude);
	inline KeyMapItem find_match(KeyMap& keymap, KeyMapItem& item);
	inline KeyMapItem match_event(Context C, Event& event);
};

/**************** Gizmos ****************/

class Gizmos : public Pointer {
public:
	Gizmos(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline Gizmo create(const char * type);
	inline void remove(Context C, Gizmo& gizmo);
	inline void clear(Context C);
};

/**************** WorkSpace UI Tags ****************/

class wmOwnerIDs : public Pointer {
public:
	wmOwnerIDs(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline wmOwnerID create(const char * name);
	inline void remove(wmOwnerID& owner_id);
	inline void clear();
};

/**************** WorkSpace UI Tags ****************/

class wmTools : public Pointer {
public:
	wmTools(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline WorkSpaceTool from_space_view3d_mode(int mode, bool create);
	inline WorkSpaceTool from_space_image_mode(int mode, bool create);
	inline WorkSpaceTool from_space_node(bool create);
	inline WorkSpaceTool from_space_sequencer(int mode, bool create);
};

/**************** Movie Tracking Markers ****************/

class MovieTrackingMarkers : public Pointer {
public:
	MovieTrackingMarkers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MovieTrackingMarker find_frame(int frame, bool exact);
	inline MovieTrackingMarker insert_frame(int frame, float co[2]);
	inline void delete_frame(int frame);
};

/**************** Movie Tracking Plane Markers ****************/

class MovieTrackingPlaneMarkers : public Pointer {
public:
	MovieTrackingPlaneMarkers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MovieTrackingPlaneMarker find_frame(int frame, bool exact);
	inline MovieTrackingPlaneMarker insert_frame(int frame);
	inline void delete_frame(int frame);
};

/**************** Movie Tracks ****************/

class MovieTrackingTracks : public Pointer {
public:
	MovieTrackingTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingTrack active(void);

	inline MovieTrackingTrack create(const char * name, int frame);
};

/**************** Movie Plane Tracks ****************/

class MovieTrackingPlaneTracks : public Pointer {
public:
	MovieTrackingPlaneTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingPlaneTrack active(void);

};

/**************** Movie Tracks ****************/

class MovieTrackingObjectTracks : public Pointer {
public:
	MovieTrackingObjectTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingTrack active(void);

	inline MovieTrackingTrack create(const char * name, int frame);
};

/**************** Plane Tracks ****************/

class MovieTrackingObjectPlaneTracks : public Pointer {
public:
	MovieTrackingObjectPlaneTracks(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingTrack active(void);

};

/**************** Reconstructed Cameras ****************/

class MovieTrackingReconstructedCameras : public Pointer {
public:
	MovieTrackingReconstructedCameras(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline MovieReconstructedCamera find_frame(int frame);
	inline void matrix_from_frame(int frame, float matrix[16]);
};

/**************** Movie Objects ****************/

class MovieTrackingObjects : public Pointer {
public:
	MovieTrackingObjects(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MovieTrackingObject active(void);

	inline MovieTrackingObject create(const char * name);
	inline void remove(MovieTrackingObject& object);
};

/**************** Mask Splines ****************/

class MaskSplines : public Pointer {
public:
	MaskSplines(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MaskSpline active(void);
	inline MaskSplinePoint active_point(void);

	inline MaskSpline create();
	inline void remove(MaskSpline& spline);
};

/**************** Mask Spline Points ****************/

class MaskSplinePoints : public Pointer {
public:
	MaskSplinePoints(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline void add(int count);
	inline void remove(MaskSplinePoint& point);
};

/**************** Mask Layers ****************/

class MaskLayers : public Pointer {
public:
	MaskLayers(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline MaskLayer active(void);

	inline MaskLayer create(const char * name);
	inline void remove(MaskLayer& layer);
	inline void clear();
};

/**************** XR Action Map Items ****************/

class XrActionMapItems : public Pointer {
public:
	XrActionMapItems(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline XrActionMapItem create(const char * name, bool replace_existing);
	inline XrActionMapItem new_from_item(XrActionMapItem& item);
	inline void remove(XrActionMapItem& item);
	inline XrActionMapItem find(const char * name);
};

/**************** XR User Paths ****************/

class XrUserPaths : public Pointer {
public:
	XrUserPaths(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline XrUserPath create(const char * path);
	inline void remove(XrUserPath& user_path);
	inline XrUserPath find(const char * path);
};

/**************** XR Action Map Bindings ****************/

class XrActionMapBindings : public Pointer {
public:
	XrActionMapBindings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline XrActionMapBinding create(const char * name, bool replace_existing);
	inline XrActionMapBinding new_from_binding(XrActionMapBinding& binding);
	inline void remove(XrActionMapBinding& binding);
	inline XrActionMapBinding find(const char * name);
};

/**************** XR Component Paths ****************/

class XrComponentPaths : public Pointer {
public:
	XrComponentPaths(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline XrComponentPath create(const char * path);
	inline void remove(XrComponentPath& component_path);
	inline XrComponentPath find(const char * path);
};

/**************** XR Action Maps ****************/

class XrActionMaps : public Pointer {
public:
	XrActionMaps(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

	inline XrActionMap create(XrSessionState& xr_session_state, const char * name, bool replace_existing);
	inline XrActionMap new_from_actionmap(XrSessionState& xr_session_state, XrActionMap& actionmap);
	inline void remove(XrSessionState& xr_session_state, XrActionMap& actionmap);
	inline XrActionMap find(XrSessionState& xr_session_state, const char * name);
};

/**************** ID Library Override ****************/

class IDOverrideLibrary : public Pointer {
public:
	IDOverrideLibrary(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		properties(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ID reference(void);
	inline ID hierarchy_root(void);
	inline bool is_in_hierarchy(void);
	inline void is_in_hierarchy(bool value);
	inline bool is_system_override(void);
	inline void is_system_override(bool value);
	COLLECTION_PROPERTY(IDOverrideLibraryProperties, IDOverrideLibraryProperty, IDOverrideLibrary, properties, false, true, false)

	inline void operations_update(void *main);
	inline void reset(void *main, bool do_hierarchy, bool set_system_override);
	inline void destroy(void *main, bool do_hierarchy);
	inline bool resync(void *main, Scene& scene, ViewLayer& view_layer, Collection& residual_storage, bool do_hierarchy_enforce, bool do_whole_hierarchy);
};

/**************** ID Library Override Property ****************/

class IDOverrideLibraryProperty : public Pointer {
public:
	IDOverrideLibraryProperty(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		operations(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string rna_path(void);
	inline void rna_path(const std::string& value);
	COLLECTION_PROPERTY(IDOverrideLibraryPropertyOperations, IDOverrideLibraryPropertyOperation, IDOverrideLibraryProperty, operations, false, true, false)

};

/**************** ID Library Override Property Operation ****************/

class IDOverrideLibraryPropertyOperation : public Pointer {
public:
	IDOverrideLibraryPropertyOperation(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum operation_enum {
		operation_NOOP = 0,
		operation_REPLACE = 1,
		operation_DIFF_ADD = 101,
		operation_DIFF_SUB = 102,
		operation_FACT_MULTIPLY = 103,
		operation_INSERT_AFTER = 201,
		operation_INSERT_BEFORE = 202,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	enum flag_enum {
		flag_MANDATORY = 1,
		flag_LOCKED = 2,
		flag_IDPOINTER_MATCH_REFERENCE = 256,
		flag_IDPOINTER_ITEM_USE_ID = 512,
	};
	inline flag_enum flag(void);
	inline void flag(flag_enum value);
	inline std::string subitem_reference_name(void);
	inline void subitem_reference_name(const std::string& value);
	inline std::string subitem_local_name(void);
	inline void subitem_local_name(const std::string& value);
	inline ID subitem_reference_id(void);
	inline ID subitem_local_id(void);
	inline int subitem_reference_index(void);
	inline void subitem_reference_index(int value);
	inline int subitem_local_index(void);
	inline void subitem_local_index(int value);

};

/**************** Image Preview ****************/

class ImagePreview : public Pointer {
public:
	ImagePreview(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_image_custom(void);
	inline void is_image_custom(bool value);
	inline Array<int, 2> image_size(void);
	inline void image_size(int values[2]);
	inline DynamicArray<int> image_pixels(void);
	inline void image_pixels(int values[]);
	inline DynamicArray<float> image_pixels_float(void);
	inline void image_pixels_float(float values[]);
	inline bool is_icon_custom(void);
	inline void is_icon_custom(bool value);
	inline Array<int, 2> icon_size(void);
	inline void icon_size(int values[2]);
	inline DynamicArray<int> icon_pixels(void);
	inline void icon_pixels(int values[]);
	inline DynamicArray<float> icon_pixels_float(void);
	inline void icon_pixels_float(float values[]);
	inline int icon_id(void);
	inline void icon_id(int value);

	inline void reload();
};

/**************** ID Property ****************/

class PropertyGroupItem : public Pointer {
public:
	PropertyGroupItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** ID Property Group ****************/

class PropertyGroup : public Pointer {
public:
	PropertyGroup(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Library ****************/

class Library : public ID {
public:
	Library(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline Library parent(void);
	inline PackedFile packed_file(void);
	inline Array<int, 3> version(void);
	inline void version(int values[3]);
	inline bool needs_liboverride_resync(void);
	inline void needs_liboverride_resync(bool value);
	inline bool is_editable(void);
	inline void is_editable(bool value);

	inline void reload(Context C);
};

/**************** LibraryWeakReference ****************/

class LibraryWeakReference : public Pointer {
public:
	LibraryWeakReference(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline std::string id_name(void);
	inline void id_name(const std::string& value);

};

/**************** IDPropertyWrapPtr ****************/

class IDPropertyWrapPtr : public Pointer {
public:
	IDPropertyWrapPtr(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Texture ****************/

class Texture : public ID {
public:
	Texture(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	enum type_enum {
		type_NONE = 0,
		type_BLEND = 5,
		type_CLOUDS = 1,
		type_DISTORTED_NOISE = 13,
		type_IMAGE = 8,
		type_MAGIC = 4,
		type_MARBLE = 3,
		type_MUSGRAVE = 11,
		type_NOISE = 7,
		type_STUCCI = 6,
		type_VORONOI = 12,
		type_WOOD = 2,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use_clamp(void);
	inline void use_clamp(bool value);
	inline bool use_color_ramp(void);
	inline void use_color_ramp(bool value);
	inline ColorRamp color_ramp(void);
	inline float intensity(void);
	inline void intensity(float value);
	inline float contrast(void);
	inline void contrast(float value);
	inline float saturation(void);
	inline void saturation(float value);
	inline float factor_red(void);
	inline void factor_red(float value);
	inline float factor_green(void);
	inline void factor_green(float value);
	inline float factor_blue(void);
	inline void factor_blue(float value);
	inline bool use_preview_alpha(void);
	inline void use_preview_alpha(bool value);
	inline bool use_nodes(void);
	inline void use_nodes(bool value);
	inline NodeTree node_tree(void);
	inline AnimData animation_data(void);

	inline void evaluate(float value[3], float result[4]);
};

/**************** Clouds Texture ****************/

class CloudsTexture : public Texture {
public:
	CloudsTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline int noise_depth(void);
	inline void noise_depth(int value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	enum noise_type_enum {
		noise_type_SOFT_NOISE = 0,
		noise_type_HARD_NOISE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	enum cloud_type_enum {
		cloud_type_GRAYSCALE = 0,
		cloud_type_COLOR = 1,
	};
	inline cloud_type_enum cloud_type(void);
	inline void cloud_type(cloud_type_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Wood Texture ****************/

class WoodTexture : public Texture {
public:
	WoodTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline float turbulence(void);
	inline void turbulence(float value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	enum noise_type_enum {
		noise_type_SOFT_NOISE = 0,
		noise_type_HARD_NOISE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	enum wood_type_enum {
		wood_type_BANDS = 0,
		wood_type_RINGS = 1,
		wood_type_BANDNOISE = 2,
		wood_type_RINGNOISE = 3,
	};
	inline wood_type_enum wood_type(void);
	inline void wood_type(wood_type_enum value);
	enum noise_basis_2_enum {
		noise_basis_2_SIN = 0,
		noise_basis_2_SAW = 1,
		noise_basis_2_TRI = 2,
	};
	inline noise_basis_2_enum noise_basis_2(void);
	inline void noise_basis_2(noise_basis_2_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Marble Texture ****************/

class MarbleTexture : public Texture {
public:
	MarbleTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline float turbulence(void);
	inline void turbulence(float value);
	inline int noise_depth(void);
	inline void noise_depth(int value);
	enum noise_type_enum {
		noise_type_SOFT_NOISE = 0,
		noise_type_HARD_NOISE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	enum marble_type_enum {
		marble_type_SOFT = 0,
		marble_type_SHARP = 1,
		marble_type_SHARPER = 2,
	};
	inline marble_type_enum marble_type(void);
	inline void marble_type(marble_type_enum value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	enum noise_basis_2_enum {
		noise_basis_2_SIN = 0,
		noise_basis_2_SAW = 1,
		noise_basis_2_TRI = 2,
	};
	inline noise_basis_2_enum noise_basis_2(void);
	inline void noise_basis_2(noise_basis_2_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Magic Texture ****************/

class MagicTexture : public Texture {
public:
	MagicTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float turbulence(void);
	inline void turbulence(float value);
	inline int noise_depth(void);
	inline void noise_depth(int value);

};

/**************** Blend Texture ****************/

class BlendTexture : public Texture {
public:
	BlendTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	enum progression_enum {
		progression_LINEAR = 0,
		progression_QUADRATIC = 1,
		progression_EASING = 2,
		progression_DIAGONAL = 3,
		progression_SPHERICAL = 4,
		progression_QUADRATIC_SPHERE = 5,
		progression_RADIAL = 6,
	};
	inline progression_enum progression(void);
	inline void progression(progression_enum value);
	enum use_flip_axis_enum {
		use_flip_axis_HORIZONTAL = 0,
		use_flip_axis_VERTICAL = 2,
	};
	inline use_flip_axis_enum use_flip_axis(void);
	inline void use_flip_axis(use_flip_axis_enum value);

};

/**************** Stucci Texture ****************/

class StucciTexture : public Texture {
public:
	StucciTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float turbulence(void);
	inline void turbulence(float value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	enum noise_type_enum {
		noise_type_SOFT_NOISE = 0,
		noise_type_HARD_NOISE = 1,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	enum stucci_type_enum {
		stucci_type_PLASTIC = 0,
		stucci_type_WALL_IN = 1,
		stucci_type_WALL_OUT = 2,
	};
	inline stucci_type_enum stucci_type(void);
	inline void stucci_type(stucci_type_enum value);

};

/**************** Noise Texture ****************/

class NoiseTexture : public Texture {
public:
	NoiseTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}


};

/**************** Image Texture ****************/

class ImageTexture : public Texture {
public:
	ImageTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline bool use_interpolation(void);
	inline void use_interpolation(bool value);
	inline bool use_flip_axis(void);
	inline void use_flip_axis(bool value);
	inline bool use_alpha(void);
	inline void use_alpha(bool value);
	inline bool use_calculate_alpha(void);
	inline void use_calculate_alpha(bool value);
	inline bool invert_alpha(void);
	inline void invert_alpha(bool value);
	inline bool use_mipmap(void);
	inline void use_mipmap(bool value);
	inline bool use_mipmap_gauss(void);
	inline void use_mipmap_gauss(bool value);
	enum filter_type_enum {
		filter_type_BOX = 0,
		filter_type_EWA = 1,
		filter_type_FELINE = 2,
		filter_type_AREA = 3,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);
	inline int filter_lightprobes(void);
	inline void filter_lightprobes(int value);
	inline int filter_eccentricity(void);
	inline void filter_eccentricity(int value);
	inline bool use_filter_size_min(void);
	inline void use_filter_size_min(bool value);
	inline float filter_size(void);
	inline void filter_size(float value);
	enum extension_enum {
		extension_EXTEND = 1,
		extension_CLIP = 2,
		extension_CLIP_CUBE = 4,
		extension_REPEAT = 3,
		extension_CHECKER = 5,
	};
	inline extension_enum extension(void);
	inline void extension(extension_enum value);
	inline int repeat_x(void);
	inline void repeat_x(int value);
	inline int repeat_y(void);
	inline void repeat_y(int value);
	inline bool use_mirror_x(void);
	inline void use_mirror_x(bool value);
	inline bool use_mirror_y(void);
	inline void use_mirror_y(bool value);
	inline bool use_checker_odd(void);
	inline void use_checker_odd(bool value);
	inline bool use_checker_even(void);
	inline void use_checker_even(bool value);
	inline float checker_distance(void);
	inline void checker_distance(float value);
	inline float crop_min_x(void);
	inline void crop_min_x(float value);
	inline float crop_min_y(void);
	inline void crop_min_y(float value);
	inline float crop_max_x(void);
	inline void crop_max_x(float value);
	inline float crop_max_y(void);
	inline void crop_max_y(float value);
	inline Image image(void);
	inline ImageUser image_user(void);
	inline bool use_normal_map(void);
	inline void use_normal_map(bool value);

};

/**************** Musgrave ****************/

class MusgraveTexture : public Texture {
public:
	MusgraveTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	enum musgrave_type_enum {
		musgrave_type_MULTIFRACTAL = 0,
		musgrave_type_RIDGED_MULTIFRACTAL = 1,
		musgrave_type_HYBRID_MULTIFRACTAL = 2,
		musgrave_type_FBM = 3,
		musgrave_type_HETERO_TERRAIN = 4,
	};
	inline musgrave_type_enum musgrave_type(void);
	inline void musgrave_type(musgrave_type_enum value);
	inline float dimension_max(void);
	inline void dimension_max(float value);
	inline float lacunarity(void);
	inline void lacunarity(float value);
	inline float octaves(void);
	inline void octaves(float value);
	inline float offset(void);
	inline void offset(float value);
	inline float gain(void);
	inline void gain(float value);
	inline float noise_intensity(void);
	inline void noise_intensity(float value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Voronoi ****************/

class VoronoiTexture : public Texture {
public:
	VoronoiTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float weight_1(void);
	inline void weight_1(float value);
	inline float weight_2(void);
	inline void weight_2(float value);
	inline float weight_3(void);
	inline void weight_3(float value);
	inline float weight_4(void);
	inline void weight_4(float value);
	inline float minkovsky_exponent(void);
	inline void minkovsky_exponent(float value);
	enum distance_metric_enum {
		distance_metric_DISTANCE = 0,
		distance_metric_DISTANCE_SQUARED = 1,
		distance_metric_MANHATTAN = 2,
		distance_metric_CHEBYCHEV = 3,
		distance_metric_MINKOVSKY_HALF = 4,
		distance_metric_MINKOVSKY_FOUR = 5,
		distance_metric_MINKOVSKY = 6,
	};
	inline distance_metric_enum distance_metric(void);
	inline void distance_metric(distance_metric_enum value);
	enum color_mode_enum {
		color_mode_INTENSITY = 0,
		color_mode_POSITION = 1,
		color_mode_POSITION_OUTLINE = 2,
		color_mode_POSITION_OUTLINE_INTENSITY = 3,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);
	inline float noise_intensity(void);
	inline void noise_intensity(float value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Distorted Noise ****************/

class DistortedNoiseTexture : public Texture {
public:
	DistortedNoiseTexture(const PointerRNA &ptr_arg) :
		Texture(ptr_arg)
		{}

	inline float distortion(void);
	inline void distortion(float value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	enum noise_basis_enum {
		noise_basis_BLENDER_ORIGINAL = 0,
		noise_basis_ORIGINAL_PERLIN = 1,
		noise_basis_IMPROVED_PERLIN = 2,
		noise_basis_VORONOI_F1 = 3,
		noise_basis_VORONOI_F2 = 4,
		noise_basis_VORONOI_F3 = 5,
		noise_basis_VORONOI_F4 = 6,
		noise_basis_VORONOI_F2_F1 = 7,
		noise_basis_VORONOI_CRACKLE = 8,
		noise_basis_CELL_NOISE = 14,
	};
	inline noise_basis_enum noise_basis(void);
	inline void noise_basis(noise_basis_enum value);
	enum noise_distortion_enum {
		noise_distortion_BLENDER_ORIGINAL = 0,
		noise_distortion_ORIGINAL_PERLIN = 1,
		noise_distortion_IMPROVED_PERLIN = 2,
		noise_distortion_VORONOI_F1 = 3,
		noise_distortion_VORONOI_F2 = 4,
		noise_distortion_VORONOI_F3 = 5,
		noise_distortion_VORONOI_F4 = 6,
		noise_distortion_VORONOI_F2_F1 = 7,
		noise_distortion_VORONOI_CRACKLE = 8,
		noise_distortion_CELL_NOISE = 14,
	};
	inline noise_distortion_enum noise_distortion(void);
	inline void noise_distortion(noise_distortion_enum value);
	inline float nabla(void);
	inline void nabla(float value);

};

/**************** Texture Slot ****************/

class TextureSlot : public Pointer {
public:
	TextureSlot(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Texture texture(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline Array<float, 3> offset(void);
	inline void offset(float values[3]);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_DARKEN = 5,
		blend_type_MULTIPLY = 1,
		blend_type_LIGHTEN = 7,
		blend_type_SCREEN = 8,
		blend_type_ADD = 2,
		blend_type_OVERLAY = 9,
		blend_type_SOFT_LIGHT = 15,
		blend_type_LINEAR_LIGHT = 16,
		blend_type_DIFFERENCE = 6,
		blend_type_SUBTRACT = 3,
		blend_type_DIVIDE = 4,
		blend_type_HUE = 10,
		blend_type_SATURATION = 11,
		blend_type_COLOR = 13,
		blend_type_VALUE = 12,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline float default_value(void);
	inline void default_value(float value);
	enum output_node_enum {
		output_node_DEFAULT = 0,
	};
	inline output_node_enum output_node(void);
	inline void output_node(output_node_enum value);

};

/**************** Texture Mapping ****************/

class TexMapping : public Pointer {
public:
	TexMapping(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum vector_type_enum {
		vector_type_POINT = 0,
		vector_type_TEXTURE = 1,
		vector_type_VECTOR = 2,
		vector_type_NORMAL = 3,
	};
	inline vector_type_enum vector_type(void);
	inline void vector_type(vector_type_enum value);
	inline Array<float, 3> translation(void);
	inline void translation(float values[3]);
	inline Array<float, 3> rotation(void);
	inline void rotation(float values[3]);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline Array<float, 3> min(void);
	inline void min(float values[3]);
	inline Array<float, 3> max(void);
	inline void max(float values[3]);
	inline bool use_min(void);
	inline void use_min(bool value);
	inline bool use_max(void);
	inline void use_max(bool value);
	enum mapping_x_enum {
		mapping_x_NONE = 0,
		mapping_x_X = 1,
		mapping_x_Y = 2,
		mapping_x_Z = 3,
	};
	inline mapping_x_enum mapping_x(void);
	inline void mapping_x(mapping_x_enum value);
	enum mapping_y_enum {
		mapping_y_NONE = 0,
		mapping_y_X = 1,
		mapping_y_Y = 2,
		mapping_y_Z = 3,
	};
	inline mapping_y_enum mapping_y(void);
	inline void mapping_y(mapping_y_enum value);
	enum mapping_z_enum {
		mapping_z_NONE = 0,
		mapping_z_X = 1,
		mapping_z_Y = 2,
		mapping_z_Z = 3,
	};
	inline mapping_z_enum mapping_z(void);
	inline void mapping_z(mapping_z_enum value);
	enum mapping_enum {
		mapping_FLAT = 0,
		mapping_CUBE = 1,
		mapping_TUBE = 2,
		mapping_SPHERE = 3,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);

};

/**************** Color Mapping ****************/

class ColorMapping : public Pointer {
public:
	ColorMapping(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_color_ramp(void);
	inline void use_color_ramp(bool value);
	inline ColorRamp color_ramp(void);
	inline float brightness(void);
	inline void brightness(float value);
	inline float contrast(void);
	inline void contrast(float value);
	inline float saturation(void);
	inline void saturation(float value);
	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_DARKEN = 5,
		blend_type_MULTIPLY = 1,
		blend_type_LIGHTEN = 7,
		blend_type_SCREEN = 8,
		blend_type_ADD = 2,
		blend_type_OVERLAY = 9,
		blend_type_SOFT_LIGHT = 15,
		blend_type_LINEAR_LIGHT = 16,
		blend_type_DIFFERENCE = 6,
		blend_type_SUBTRACT = 3,
		blend_type_DIVIDE = 4,
		blend_type_HUE = 10,
		blend_type_SATURATION = 11,
		blend_type_COLOR = 13,
		blend_type_VALUE = 12,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline Array<float, 3> blend_color(void);
	inline void blend_color(float values[3]);
	inline float blend_factor(void);
	inline void blend_factor(float value);

};

/**************** Action ****************/

class Action : public ID {
public:
	Action(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		slots(ptr_arg),
		layers(ptr_arg),
		pose_markers(ptr_arg),
		fcurves(ptr_arg),
		groups(ptr_arg)
		{}

	inline bool is_empty(void);
	inline void is_empty(bool value);
	inline bool is_action_legacy(void);
	inline void is_action_legacy(bool value);
	inline bool is_action_layered(void);
	inline void is_action_layered(bool value);
	COLLECTION_PROPERTY(ActionSlots, ActionSlot, Action, slots, true, false, false)
	COLLECTION_PROPERTY(ActionLayers, ActionLayer, Action, layers, true, false, false)
	COLLECTION_PROPERTY(ActionPoseMarkers, TimelineMarker, Action, pose_markers, false, true, true)
	inline bool use_frame_range(void);
	inline void use_frame_range(bool value);
	inline bool use_cyclic(void);
	inline void use_cyclic(bool value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);
	inline Array<float, 2> frame_range(void);
	inline void frame_range(float values[2]);
	inline Array<float, 2> curve_frame_range(void);
	inline void curve_frame_range(float values[2]);
	COLLECTION_PROPERTY(ActionFCurves, FCurve, Action, fcurves, true, false, false)
	COLLECTION_PROPERTY(ActionGroups, ActionGroup, Action, groups, true, false, true)
	enum id_root_enum {
		id_root_UNSPECIFIED = 0,
	};
	inline id_root_enum id_root(void);
	inline void id_root(id_root_enum value);

	inline void deselect_keys();
	inline FCurve fcurve_ensure_for_datablock(void *main, ID& datablock, const char * data_path, int index);
	inline void flip_with_pose(Object& object);
};

/**************** Action Group ****************/

class ActionGroup : public Pointer {
public:
	ActionGroup(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		channels(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FCurve, ActionGroup, channels, false, false, false)
	inline bool select(void);
	inline void select(bool value);
	inline bool lock(void);
	inline void lock(bool value);
	inline bool mute(void);
	inline void mute(bool value);
	inline bool show_expanded(void);
	inline void show_expanded(bool value);
	inline bool show_expanded_graph(void);
	inline void show_expanded_graph(bool value);
	inline bool use_pin(void);
	inline void use_pin(bool value);
	enum color_set_enum {
		color_set_DEFAULT = 0,
		color_set_THEME01 = 1,
		color_set_THEME02 = 2,
		color_set_THEME03 = 3,
		color_set_THEME04 = 4,
		color_set_THEME05 = 5,
		color_set_THEME06 = 6,
		color_set_THEME07 = 7,
		color_set_THEME08 = 8,
		color_set_THEME09 = 9,
		color_set_THEME10 = 10,
		color_set_THEME11 = 11,
		color_set_THEME12 = 12,
		color_set_THEME13 = 13,
		color_set_THEME14 = 14,
		color_set_THEME15 = 15,
		color_set_THEME16 = 16,
		color_set_THEME17 = 17,
		color_set_THEME18 = 18,
		color_set_THEME19 = 19,
		color_set_THEME20 = 20,
		color_set_CUSTOM = -1,
	};
	inline color_set_enum color_set(void);
	inline void color_set(color_set_enum value);
	inline bool is_custom_color_set(void);
	inline void is_custom_color_set(bool value);
	inline ThemeBoneColorSet colors(void);

};

/**************** Dope Sheet ****************/

class DopeSheet : public Pointer {
public:
	DopeSheet(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ID source(void);
	inline bool show_datablock_filters(void);
	inline void show_datablock_filters(bool value);
	inline bool show_only_selected(void);
	inline void show_only_selected(bool value);
	inline bool show_only_slot_of_active_object(void);
	inline void show_only_slot_of_active_object(bool value);
	inline bool show_hidden(void);
	inline void show_hidden(bool value);
	inline bool use_datablock_sort(void);
	inline void use_datablock_sort(bool value);
	inline bool use_filter_invert(void);
	inline void use_filter_invert(bool value);
	inline bool show_only_errors(void);
	inline void show_only_errors(bool value);
	inline Collection filter_collection(void);
	inline std::string filter_fcurve_name(void);
	inline void filter_fcurve_name(const std::string& value);
	inline std::string filter_text(void);
	inline void filter_text(const std::string& value);
	inline bool use_multi_word_filter(void);
	inline void use_multi_word_filter(bool value);
	inline bool show_missing_nla(void);
	inline void show_missing_nla(bool value);
	inline bool show_summary(void);
	inline void show_summary(bool value);
	inline bool show_expanded_summary(void);
	inline void show_expanded_summary(bool value);
	inline bool show_transforms(void);
	inline void show_transforms(bool value);
	inline bool show_shapekeys(void);
	inline void show_shapekeys(bool value);
	inline bool show_modifiers(void);
	inline void show_modifiers(bool value);
	inline bool show_meshes(void);
	inline void show_meshes(bool value);
	inline bool show_lattices(void);
	inline void show_lattices(bool value);
	inline bool show_cameras(void);
	inline void show_cameras(bool value);
	inline bool show_materials(void);
	inline void show_materials(bool value);
	inline bool show_lights(void);
	inline void show_lights(bool value);
	inline bool show_linestyles(void);
	inline void show_linestyles(bool value);
	inline bool show_textures(void);
	inline void show_textures(bool value);
	inline bool show_curves(void);
	inline void show_curves(bool value);
	inline bool show_worlds(void);
	inline void show_worlds(bool value);
	inline bool show_scenes(void);
	inline void show_scenes(bool value);
	inline bool show_particles(void);
	inline void show_particles(bool value);
	inline bool show_metaballs(void);
	inline void show_metaballs(bool value);
	inline bool show_armatures(void);
	inline void show_armatures(bool value);
	inline bool show_nodes(void);
	inline void show_nodes(bool value);
	inline bool show_speakers(void);
	inline void show_speakers(bool value);
	inline bool show_cache_files(void);
	inline void show_cache_files(bool value);
	inline bool show_hair_curves(void);
	inline void show_hair_curves(bool value);
	inline bool show_pointclouds(void);
	inline void show_pointclouds(bool value);
	inline bool show_volumes(void);
	inline void show_volumes(bool value);
	inline bool show_lightprobes(void);
	inline void show_lightprobes(bool value);
	inline bool show_gpencil(void);
	inline void show_gpencil(bool value);
	inline bool show_movieclips(void);
	inline void show_movieclips(bool value);
	inline bool show_driver_fallback_as_error(void);
	inline void show_driver_fallback_as_error(bool value);

};

/**************** Action slot ****************/

class ActionSlot : public Pointer {
public:
	ActionSlot(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string identifier(void);
	inline void identifier(const std::string& value);
	enum target_id_type_enum {
		target_id_type_UNSPECIFIED = 0,
	};
	inline target_id_type_enum target_id_type(void);
	inline void target_id_type(target_id_type_enum value);
	inline int target_id_type_icon(void);
	inline void target_id_type_icon(int value);
	inline std::string name_display(void);
	inline void name_display(const std::string& value);
	inline int handle(void);
	inline void handle(int value);
	inline bool active(void);
	inline void active(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool show_expanded(void);
	inline void show_expanded(bool value);

	inline CollectionVector users(void *main);
	inline ActionSlot duplicate();
};

/**************** Action Layer ****************/

class ActionLayer : public Pointer {
public:
	ActionLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		strips(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	COLLECTION_PROPERTY(ActionStrips, ActionStrip, ActionLayer, strips, true, false, false)

};

/**************** Action Strip ****************/

class ActionStrip : public Pointer {
public:
	ActionStrip(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_KEYFRAME = 0,
	};
	inline type_enum type(void);
	inline void type(type_enum value);

};

/**************** Keyframe Animation Strip ****************/

class ActionKeyframeStrip : public ActionStrip {
public:
	ActionKeyframeStrip(const PointerRNA &ptr_arg) :
		ActionStrip(ptr_arg),
		channelbags(ptr_arg)
		{}

	COLLECTION_PROPERTY(ActionChannelbags, ActionChannelbag, ActionKeyframeStrip, channelbags, true, false, false)

	inline ActionChannelbag channelbag(ActionSlot& slot, bool ensure);
	inline bool key_insert(void *main, ActionSlot& slot, const char * data_path, int array_index, float value, float time);
};

/**************** Animation Channel Bag ****************/

class ActionChannelbag : public Pointer {
public:
	ActionChannelbag(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		fcurves(ptr_arg),
		groups(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int slot_handle(void);
	inline void slot_handle(int value);
	inline ActionSlot slot(void);
	COLLECTION_PROPERTY(ActionChannelbagFCurves, FCurve, ActionChannelbag, fcurves, true, false, false)
	COLLECTION_PROPERTY(ActionChannelbagGroups, ActionGroup, ActionChannelbag, groups, true, false, false)

};

/**************** Animation Data ****************/

class AnimData : public Pointer {
public:
	AnimData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		nla_tracks(ptr_arg),
		drivers(ptr_arg),
		action_suitable_slots(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(NlaTracks, NlaTrack, AnimData, nla_tracks, false, true, true)
	inline Action action(void);
	enum action_extrapolation_enum {
		action_extrapolation_NOTHING = 2,
		action_extrapolation_HOLD = 0,
		action_extrapolation_HOLD_FORWARD = 1,
	};
	inline action_extrapolation_enum action_extrapolation(void);
	inline void action_extrapolation(action_extrapolation_enum value);
	enum action_blend_type_enum {
		action_blend_type_REPLACE = 0,
		action_blend_type_COMBINE = 4,
		action_blend_type_ADD = 1,
		action_blend_type_SUBTRACT = 2,
		action_blend_type_MULTIPLY = 3,
	};
	inline action_blend_type_enum action_blend_type(void);
	inline void action_blend_type(action_blend_type_enum value);
	inline float action_influence(void);
	inline void action_influence(float value);
	inline Action action_tweak_storage(void);
	inline int action_slot_handle_tweak_storage(void);
	inline void action_slot_handle_tweak_storage(int value);
	COLLECTION_PROPERTY(AnimDataDrivers, FCurve, AnimData, drivers, false, true, false)
	inline bool use_nla(void);
	inline void use_nla(bool value);
	inline bool use_tweak_mode(void);
	inline void use_tweak_mode(bool value);
	inline bool use_pin(void);
	inline void use_pin(bool value);
	inline int action_slot_handle(void);
	inline void action_slot_handle(int value);
	inline std::string last_slot_identifier(void);
	inline void last_slot_identifier(const std::string& value);
	inline ActionSlot action_slot(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ActionSlot, AnimData, action_suitable_slots, false, false, false)

	inline float nla_tweak_strip_time_to_scene(float frame, bool invert);
	inline void fix_paths_rename_all(void *main, const char * prefix, const char * old_name, const char * new_name);
};

/**************** Keying Set ****************/

class KeyingSet : public Pointer {
public:
	KeyingSet(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		paths(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string bl_idname(void);
	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);
	inline void bl_label(const std::string& value);
	inline std::string bl_description(void);
	inline void bl_description(const std::string& value);
	inline KeyingSetInfo type_info(void);
	COLLECTION_PROPERTY(KeyingSetPaths, KeyingSetPath, KeyingSet, paths, false, true, true)
	inline bool is_path_absolute(void);
	inline void is_path_absolute(bool value);
	inline bool use_insertkey_override_needed(void);
	inline void use_insertkey_override_needed(bool value);
	inline bool use_insertkey_override_visual(void);
	inline void use_insertkey_override_visual(bool value);
	inline bool use_insertkey_needed(void);
	inline void use_insertkey_needed(bool value);
	inline bool use_insertkey_visual(void);
	inline void use_insertkey_visual(bool value);

	inline void refresh(Context C);
};

/**************** Keying Set Path ****************/

class KeyingSetPath : public Pointer {
public:
	KeyingSetPath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ID id(void);
	enum id_type_enum {
		id_type_ACTION = 17217,
		id_type_ARMATURE = 21057,
		id_type_BRUSH = 21058,
		id_type_CACHEFILE = 17987,
		id_type_CAMERA = 16707,
		id_type_COLLECTION = 21063,
		id_type_CURVE = 21827,
		id_type_CURVES = 22083,
		id_type_FONT = 18006,
		id_type_GREASEPENCIL = 17479,
		id_type_GREASEPENCIL_V3 = 20551,
		id_type_IMAGE = 19785,
		id_type_KEY = 17739,
		id_type_LATTICE = 21580,
		id_type_LIBRARY = 18764,
		id_type_LIGHT = 16716,
		id_type_LIGHT_PROBE = 20556,
		id_type_LINESTYLE = 21324,
		id_type_MASK = 21325,
		id_type_MATERIAL = 16717,
		id_type_MESH = 17741,
		id_type_META = 16973,
		id_type_MOVIECLIP = 17229,
		id_type_NODETREE = 21582,
		id_type_OBJECT = 16975,
		id_type_PAINTCURVE = 17232,
		id_type_PALETTE = 19536,
		id_type_PARTICLE = 16720,
		id_type_POINTCLOUD = 21584,
		id_type_SCENE = 17235,
		id_type_SCREEN = 21075,
		id_type_SOUND = 20307,
		id_type_SPEAKER = 19283,
		id_type_TEXT = 22612,
		id_type_TEXTURE = 17748,
		id_type_VOLUME = 20310,
		id_type_WINDOWMANAGER = 19799,
		id_type_WORKSPACE = 21335,
		id_type_WORLD = 20311,
	};
	inline id_type_enum id_type(void);
	inline void id_type(id_type_enum value);
	inline std::string group(void);
	inline void group(const std::string& value);
	enum group_method_enum {
		group_method_NAMED = 0,
		group_method_NONE = 1,
		group_method_KEYINGSET = 2,
	};
	inline group_method_enum group_method(void);
	inline void group_method(group_method_enum value);
	inline std::string data_path(void);
	inline void data_path(const std::string& value);
	inline int array_index(void);
	inline void array_index(int value);
	inline bool use_entire_array(void);
	inline void use_entire_array(bool value);
	inline bool use_insertkey_override_needed(void);
	inline void use_insertkey_override_needed(bool value);
	inline bool use_insertkey_override_visual(void);
	inline void use_insertkey_override_visual(bool value);
	inline bool use_insertkey_needed(void);
	inline void use_insertkey_needed(bool value);
	inline bool use_insertkey_visual(void);
	inline void use_insertkey_visual(bool value);

};

/**************** Keying Set Info ****************/

class KeyingSetInfo : public Pointer {
public:
	KeyingSetInfo(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string bl_idname(void);
	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);
	inline void bl_label(const std::string& value);
	inline std::string bl_description(void);
	inline void bl_description(const std::string& value);
	enum bl_options_enum {
		bl_options_INSERTKEY_NEEDED = 1,
		bl_options_INSERTKEY_VISUAL = 2,
		bl_options_INSERTKEY_XYZ_TO_RGB = 0,
	};
	inline bl_options_enum bl_options(void);
	inline void bl_options(bl_options_enum value);

};

/**************** Animation Visualization ****************/

class AnimViz : public Pointer {
public:
	AnimViz(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline AnimVizMotionPaths motion_path(void);

};

/**************** Motion Path Settings ****************/

class AnimVizMotionPaths : public Pointer {
public:
	AnimVizMotionPaths(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_CURRENT_FRAME = 1,
		type_RANGE = 0,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum range_enum {
		range_KEYS_ALL = 2,
		range_KEYS_SELECTED = 1,
		range_SCENE = 0,
		range_MANUAL = 3,
	};
	inline range_enum range(void);
	inline void range(range_enum value);
	enum bake_location_enum {
		bake_location_HEADS = 2,
		bake_location_TAILS = 0,
	};
	inline bake_location_enum bake_location(void);
	inline void bake_location(bake_location_enum value);
	inline bool show_frame_numbers(void);
	inline void show_frame_numbers(bool value);
	inline bool show_keyframe_highlight(void);
	inline void show_keyframe_highlight(bool value);
	inline bool show_keyframe_numbers(void);
	inline void show_keyframe_numbers(bool value);
	inline bool show_keyframe_action_all(void);
	inline void show_keyframe_action_all(bool value);
	inline int frame_step(void);
	inline void frame_step(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int frame_before(void);
	inline void frame_before(int value);
	inline int frame_after(void);
	inline void frame_after(int value);
	inline bool has_motion_paths(void);
	inline void has_motion_paths(bool value);
	inline bool use_camera_space_bake(void);
	inline void use_camera_space_bake(bool value);

};

/**************** Motion Path ****************/

class MotionPath : public Pointer {
public:
	MotionPath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MotionPathVert, MotionPath, points, true, true, false)
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int length(void);
	inline void length(int value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline Array<float, 3> color_post(void);
	inline void color_post(float values[3]);
	inline int line_thickness(void);
	inline void line_thickness(int value);
	inline bool use_bone_head(void);
	inline void use_bone_head(bool value);
	inline bool is_modified(void);
	inline void is_modified(bool value);
	inline bool use_custom_color(void);
	inline void use_custom_color(bool value);
	inline bool lines(void);
	inline void lines(bool value);

};

/**************** Motion Path Cache Point ****************/

class MotionPathVert : public Pointer {
public:
	MotionPathVert(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline bool select(void);
	inline void select(bool value);

};

/**************** BoneColor ****************/

class BoneColor : public Pointer {
public:
	BoneColor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum palette_enum {
		palette_DEFAULT = 0,
		palette_THEME01 = 1,
		palette_THEME02 = 2,
		palette_THEME03 = 3,
		palette_THEME04 = 4,
		palette_THEME05 = 5,
		palette_THEME06 = 6,
		palette_THEME07 = 7,
		palette_THEME08 = 8,
		palette_THEME09 = 9,
		palette_THEME10 = 10,
		palette_THEME11 = 11,
		palette_THEME12 = 12,
		palette_THEME13 = 13,
		palette_THEME14 = 14,
		palette_THEME15 = 15,
		palette_THEME16 = 16,
		palette_THEME17 = 17,
		palette_THEME18 = 18,
		palette_THEME19 = 19,
		palette_THEME20 = 20,
		palette_CUSTOM = -1,
	};
	inline palette_enum palette(void);
	inline void palette(palette_enum value);
	inline bool is_custom(void);
	inline void is_custom(bool value);
	inline ThemeBoneColorSet custom(void);

};

/**************** BoneCollection ****************/

class BoneCollection : public Pointer {
public:
	BoneCollection(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		bones(ptr_arg),
		children(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline bool is_expanded(void);
	inline void is_expanded(bool value);
	inline bool is_visible(void);
	inline void is_visible(bool value);
	inline bool is_visible_ancestors(void);
	inline void is_visible_ancestors(bool value);
	inline bool is_visible_effectively(void);
	inline void is_visible_effectively(bool value);
	inline bool is_solo(void);
	inline void is_solo(bool value);
	inline bool is_local_override(void);
	inline void is_local_override(bool value);
	inline bool is_editable(void);
	inline void is_editable(bool value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Bone, BoneCollection, bones, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoneCollection, BoneCollection, children, true, false, false)
	inline BoneCollection parent(void);
	inline int index(void);
	inline void index(int value);
	inline int child_number(void);
	inline void child_number(int value);

	inline bool assign(Context C, AnyType& bone);
	inline bool unassign(Context C, AnyType& bone);
};

/**************** Armature ****************/

class Armature : public ID {
public:
	Armature(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		bones(ptr_arg),
		edit_bones(ptr_arg),
		collections(ptr_arg),
		collections_all(ptr_arg)
		{}

	inline AnimData animation_data(void);
	COLLECTION_PROPERTY(ArmatureBones, Bone, Armature, bones, false, false, true)
	COLLECTION_PROPERTY(ArmatureEditBones, EditBone, Armature, edit_bones, false, true, true)
	COLLECTION_PROPERTY(BoneCollections, BoneCollection, Armature, collections, true, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoneCollection, Armature, collections_all, true, false, false)
	enum pose_position_enum {
		pose_position_POSE = 0,
		pose_position_REST = 1,
	};
	inline pose_position_enum pose_position(void);
	inline void pose_position(pose_position_enum value);
	enum display_type_enum {
		display_type_OCTAHEDRAL = 0,
		display_type_STICK = 1,
		display_type_BBONE = 2,
		display_type_ENVELOPE = 3,
		display_type_WIRE = 4,
	};
	inline display_type_enum display_type(void);
	inline void display_type(display_type_enum value);
	inline bool show_axes(void);
	inline void show_axes(bool value);
	inline float axes_position(void);
	inline void axes_position(float value);
	enum relation_line_position_enum {
		relation_line_position_TAIL = 0,
		relation_line_position_HEAD = 1,
	};
	inline relation_line_position_enum relation_line_position(void);
	inline void relation_line_position(relation_line_position_enum value);
	inline bool show_names(void);
	inline void show_names(bool value);
	inline bool use_mirror_x(void);
	inline void use_mirror_x(bool value);
	inline bool show_bone_custom_shapes(void);
	inline void show_bone_custom_shapes(bool value);
	inline bool show_bone_colors(void);
	inline void show_bone_colors(bool value);
	inline bool is_editmode(void);
	inline void is_editmode(bool value);

	inline void transform(float matrix[16]);
};

/**************** Bone ****************/

class Bone : public Pointer {
public:
	Bone(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		children(ptr_arg),
		collections(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Bone parent(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Bone, Bone, children, false, true, true)
	COLLECTION_PROPERTY(BoneCollectionMemberships, BoneCollection, Bone, collections, false, false, false)
	inline std::string name(void);
	inline void name(const std::string& value);
	inline BoneColor color(void);
	enum display_type_enum {
		display_type_ARMATURE_DEFINED = -1,
		display_type_OCTAHEDRAL = 0,
		display_type_STICK = 1,
		display_type_BBONE = 2,
		display_type_ENVELOPE = 3,
		display_type_WIRE = 4,
	};
	inline display_type_enum display_type(void);
	inline void display_type(display_type_enum value);
	inline bool use_connect(void);
	inline void use_connect(bool value);
	inline bool use_inherit_rotation(void);
	inline void use_inherit_rotation(bool value);
	inline bool use_envelope_multiply(void);
	inline void use_envelope_multiply(bool value);
	inline bool use_deform(void);
	inline void use_deform(bool value);
	enum inherit_scale_enum {
		inherit_scale_FULL = 0,
		inherit_scale_FIX_SHEAR = 1,
		inherit_scale_ALIGNED = 5,
		inherit_scale_AVERAGE = 2,
		inherit_scale_NONE = 3,
		inherit_scale_NONE_LEGACY = 4,
	};
	inline inherit_scale_enum inherit_scale(void);
	inline void inherit_scale(inherit_scale_enum value);
	inline bool use_local_location(void);
	inline void use_local_location(bool value);
	inline bool use_relative_parent(void);
	inline void use_relative_parent(bool value);
	inline bool show_wire(void);
	inline void show_wire(bool value);
	inline bool use_cyclic_offset(void);
	inline void use_cyclic_offset(bool value);
	inline bool hide_select(void);
	inline void hide_select(bool value);
	inline float envelope_distance(void);
	inline void envelope_distance(float value);
	inline float envelope_weight(void);
	inline void envelope_weight(float value);
	inline float head_radius(void);
	inline void head_radius(float value);
	inline float tail_radius(void);
	inline void tail_radius(float value);
	inline int bbone_segments(void);
	inline void bbone_segments(int value);
	enum bbone_mapping_mode_enum {
		bbone_mapping_mode_STRAIGHT = 0,
		bbone_mapping_mode_CURVED = 1,
	};
	inline bbone_mapping_mode_enum bbone_mapping_mode(void);
	inline void bbone_mapping_mode(bbone_mapping_mode_enum value);
	inline float bbone_x(void);
	inline void bbone_x(float value);
	inline float bbone_z(void);
	inline void bbone_z(float value);
	enum bbone_handle_type_start_enum {
		bbone_handle_type_start_AUTO = 0,
		bbone_handle_type_start_ABSOLUTE = 1,
		bbone_handle_type_start_RELATIVE = 2,
		bbone_handle_type_start_TANGENT = 3,
	};
	inline bbone_handle_type_start_enum bbone_handle_type_start(void);
	inline void bbone_handle_type_start(bbone_handle_type_start_enum value);
	inline Bone bbone_custom_handle_start(void);
	inline Array<bool, 3> bbone_handle_use_scale_start(void);
	inline void bbone_handle_use_scale_start(bool values[3]);
	inline bool bbone_handle_use_ease_start(void);
	inline void bbone_handle_use_ease_start(bool value);
	enum bbone_handle_type_end_enum {
		bbone_handle_type_end_AUTO = 0,
		bbone_handle_type_end_ABSOLUTE = 1,
		bbone_handle_type_end_RELATIVE = 2,
		bbone_handle_type_end_TANGENT = 3,
	};
	inline bbone_handle_type_end_enum bbone_handle_type_end(void);
	inline void bbone_handle_type_end(bbone_handle_type_end_enum value);
	inline Bone bbone_custom_handle_end(void);
	inline Array<bool, 3> bbone_handle_use_scale_end(void);
	inline void bbone_handle_use_scale_end(bool values[3]);
	inline bool bbone_handle_use_ease_end(void);
	inline void bbone_handle_use_ease_end(bool value);
	inline float bbone_rollin(void);
	inline void bbone_rollin(float value);
	inline float bbone_rollout(void);
	inline void bbone_rollout(float value);
	inline bool use_endroll_as_inroll(void);
	inline void use_endroll_as_inroll(bool value);
	inline float bbone_curveinx(void);
	inline void bbone_curveinx(float value);
	inline float bbone_curveinz(void);
	inline void bbone_curveinz(float value);
	inline float bbone_curveoutx(void);
	inline void bbone_curveoutx(float value);
	inline float bbone_curveoutz(void);
	inline void bbone_curveoutz(float value);
	inline float bbone_easein(void);
	inline void bbone_easein(float value);
	inline float bbone_easeout(void);
	inline void bbone_easeout(float value);
	inline bool use_scale_easing(void);
	inline void use_scale_easing(bool value);
	inline Array<float, 3> bbone_scalein(void);
	inline void bbone_scalein(float values[3]);
	inline Array<float, 3> bbone_scaleout(void);
	inline void bbone_scaleout(float values[3]);
	inline bool hide(void);
	inline void hide(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool select_head(void);
	inline void select_head(bool value);
	inline bool select_tail(void);
	inline void select_tail(bool value);
	inline Array<float, 9> matrix(void);
	inline void matrix(float values[9]);
	inline Array<float, 16> matrix_local(void);
	inline void matrix_local(float values[16]);
	inline Array<float, 3> tail(void);
	inline void tail(float values[3]);
	inline Array<float, 3> tail_local(void);
	inline void tail_local(float values[3]);
	inline Array<float, 3> head(void);
	inline void head(float values[3]);
	inline Array<float, 3> head_local(void);
	inline void head_local(float values[3]);
	inline float length(void);
	inline void length(float value);

	inline float evaluate_envelope(float point[3]);
	inline void convert_local_to_pose(float matrix_return[16], float matrix[16], float matrix_local[16], float parent_matrix[16], float parent_matrix_local[16], bool invert);
	inline void MatrixFromAxisRoll(float axis[3], float roll, float result_matrix[9]);
	inline void AxisRollFromMatrix(float matrix[9], float axis[3], float result_axis[3], float *result_roll);
};

/**************** Edit Bone ****************/

class EditBone : public Pointer {
public:
	EditBone(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		collections(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoneCollection, EditBone, collections, false, false, false)
	inline EditBone parent(void);
	inline float roll(void);
	inline void roll(float value);
	inline Array<float, 3> head(void);
	inline void head(float values[3]);
	inline Array<float, 3> tail(void);
	inline void tail(float values[3]);
	inline float length(void);
	inline void length(float value);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline BoneColor color(void);
	enum display_type_enum {
		display_type_ARMATURE_DEFINED = -1,
		display_type_OCTAHEDRAL = 0,
		display_type_STICK = 1,
		display_type_BBONE = 2,
		display_type_ENVELOPE = 3,
		display_type_WIRE = 4,
	};
	inline display_type_enum display_type(void);
	inline void display_type(display_type_enum value);
	inline bool use_connect(void);
	inline void use_connect(bool value);
	inline bool use_inherit_rotation(void);
	inline void use_inherit_rotation(bool value);
	inline bool use_envelope_multiply(void);
	inline void use_envelope_multiply(bool value);
	inline bool use_deform(void);
	inline void use_deform(bool value);
	enum inherit_scale_enum {
		inherit_scale_FULL = 0,
		inherit_scale_FIX_SHEAR = 1,
		inherit_scale_ALIGNED = 5,
		inherit_scale_AVERAGE = 2,
		inherit_scale_NONE = 3,
		inherit_scale_NONE_LEGACY = 4,
	};
	inline inherit_scale_enum inherit_scale(void);
	inline void inherit_scale(inherit_scale_enum value);
	inline bool use_local_location(void);
	inline void use_local_location(bool value);
	inline bool use_relative_parent(void);
	inline void use_relative_parent(bool value);
	inline bool show_wire(void);
	inline void show_wire(bool value);
	inline bool use_cyclic_offset(void);
	inline void use_cyclic_offset(bool value);
	inline bool hide_select(void);
	inline void hide_select(bool value);
	inline float envelope_distance(void);
	inline void envelope_distance(float value);
	inline float envelope_weight(void);
	inline void envelope_weight(float value);
	inline float head_radius(void);
	inline void head_radius(float value);
	inline float tail_radius(void);
	inline void tail_radius(float value);
	inline int bbone_segments(void);
	inline void bbone_segments(int value);
	enum bbone_mapping_mode_enum {
		bbone_mapping_mode_STRAIGHT = 0,
		bbone_mapping_mode_CURVED = 1,
	};
	inline bbone_mapping_mode_enum bbone_mapping_mode(void);
	inline void bbone_mapping_mode(bbone_mapping_mode_enum value);
	inline float bbone_x(void);
	inline void bbone_x(float value);
	inline float bbone_z(void);
	inline void bbone_z(float value);
	enum bbone_handle_type_start_enum {
		bbone_handle_type_start_AUTO = 0,
		bbone_handle_type_start_ABSOLUTE = 1,
		bbone_handle_type_start_RELATIVE = 2,
		bbone_handle_type_start_TANGENT = 3,
	};
	inline bbone_handle_type_start_enum bbone_handle_type_start(void);
	inline void bbone_handle_type_start(bbone_handle_type_start_enum value);
	inline EditBone bbone_custom_handle_start(void);
	inline Array<bool, 3> bbone_handle_use_scale_start(void);
	inline void bbone_handle_use_scale_start(bool values[3]);
	inline bool bbone_handle_use_ease_start(void);
	inline void bbone_handle_use_ease_start(bool value);
	enum bbone_handle_type_end_enum {
		bbone_handle_type_end_AUTO = 0,
		bbone_handle_type_end_ABSOLUTE = 1,
		bbone_handle_type_end_RELATIVE = 2,
		bbone_handle_type_end_TANGENT = 3,
	};
	inline bbone_handle_type_end_enum bbone_handle_type_end(void);
	inline void bbone_handle_type_end(bbone_handle_type_end_enum value);
	inline EditBone bbone_custom_handle_end(void);
	inline Array<bool, 3> bbone_handle_use_scale_end(void);
	inline void bbone_handle_use_scale_end(bool values[3]);
	inline bool bbone_handle_use_ease_end(void);
	inline void bbone_handle_use_ease_end(bool value);
	inline float bbone_rollin(void);
	inline void bbone_rollin(float value);
	inline float bbone_rollout(void);
	inline void bbone_rollout(float value);
	inline bool use_endroll_as_inroll(void);
	inline void use_endroll_as_inroll(bool value);
	inline float bbone_curveinx(void);
	inline void bbone_curveinx(float value);
	inline float bbone_curveinz(void);
	inline void bbone_curveinz(float value);
	inline float bbone_curveoutx(void);
	inline void bbone_curveoutx(float value);
	inline float bbone_curveoutz(void);
	inline void bbone_curveoutz(float value);
	inline float bbone_easein(void);
	inline void bbone_easein(float value);
	inline float bbone_easeout(void);
	inline void bbone_easeout(float value);
	inline bool use_scale_easing(void);
	inline void use_scale_easing(bool value);
	inline Array<float, 3> bbone_scalein(void);
	inline void bbone_scalein(float values[3]);
	inline Array<float, 3> bbone_scaleout(void);
	inline void bbone_scaleout(float values[3]);
	inline bool hide(void);
	inline void hide(bool value);
	inline bool lock(void);
	inline void lock(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool select_head(void);
	inline void select_head(bool value);
	inline bool select_tail(void);
	inline void select_tail(bool value);
	inline Array<float, 16> matrix(void);
	inline void matrix(float values[16]);

	inline void align_roll(float vector[3]);
};

/**************** Attribute ****************/

class Attribute : public Pointer {
public:
	Attribute(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum data_type_enum {
		data_type_FLOAT = 10,
		data_type_INT = 11,
		data_type_FLOAT_VECTOR = 48,
		data_type_FLOAT_COLOR = 47,
		data_type_BYTE_COLOR = 17,
		data_type_STRING = 12,
		data_type_BOOLEAN = 50,
		data_type_FLOAT2 = 49,
		data_type_INT8 = 45,
		data_type_INT16_2D = 22,
		data_type_INT32_2D = 46,
		data_type_QUATERNION = 52,
		data_type_FLOAT4X4 = 20,
	};
	inline data_type_enum data_type(void);
	inline void data_type(data_type_enum value);
	enum domain_enum {
		domain_POINT = 0,
		domain_EDGE = 1,
		domain_FACE = 2,
		domain_CORNER = 3,
		domain_CURVE = 4,
		domain_INSTANCE = 5,
		domain_LAYER = 6,
	};
	inline domain_enum domain(void);
	inline void domain(domain_enum value);
	inline bool is_internal(void);
	inline void is_internal(bool value);
	inline bool is_required(void);
	inline void is_required(bool value);

};

/**************** Float Attribute ****************/

class FloatAttribute : public Attribute {
public:
	FloatAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, FloatAttributeValue, FloatAttribute, data, true, true, false)

};

/**************** Float Attribute Value ****************/

class FloatAttributeValue : public Pointer {
public:
	FloatAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float value(void);
	inline void value(float value);

};

/**************** Float Vector Attribute ****************/

class FloatVectorAttribute : public Attribute {
public:
	FloatVectorAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, FloatVectorAttributeValue, FloatVectorAttribute, data, true, true, false)

};

/**************** Float Vector Attribute Value ****************/

class FloatVectorAttributeValue : public Pointer {
public:
	FloatVectorAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> vector(void);
	inline void vector(float values[3]);

};

/**************** Float Color Attribute ****************/

class FloatColorAttribute : public Attribute {
public:
	FloatColorAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, FloatColorAttributeValue, FloatColorAttribute, data, true, true, false)

};

/**************** Float Color Attribute Value ****************/

class FloatColorAttributeValue : public Pointer {
public:
	FloatColorAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);
	inline Array<float, 4> color_srgb(void);
	inline void color_srgb(float values[4]);

};

/**************** Byte Color Attribute ****************/

class ByteColorAttribute : public Attribute {
public:
	ByteColorAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, ByteColorAttributeValue, ByteColorAttribute, data, true, true, false)

};

/**************** Byte Color Attribute Value ****************/

class ByteColorAttributeValue : public Pointer {
public:
	ByteColorAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);
	inline Array<float, 4> color_srgb(void);
	inline void color_srgb(float values[4]);

};

/**************** Integer Attribute ****************/

class IntAttribute : public Attribute {
public:
	IntAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, IntAttributeValue, IntAttribute, data, true, true, false)

};

/**************** Integer Attribute Value ****************/

class IntAttributeValue : public Pointer {
public:
	IntAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int value(void);
	inline void value(int value);

};

/**************** 2D 16-Bit Integer Vector Attribute ****************/

class Short2Attribute : public Attribute {
public:
	Short2Attribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, Short2AttributeValue, Short2Attribute, data, true, true, false)

};

/**************** 2D 16-Bit Integer Vector Attribute Value ****************/

class Short2AttributeValue : public Pointer {
public:
	Short2AttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<int, 2> value(void);
	inline void value(int values[2]);

};

/**************** 2D Integer Vector Attribute ****************/

class Int2Attribute : public Attribute {
public:
	Int2Attribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, Int2AttributeValue, Int2Attribute, data, true, true, false)

};

/**************** 2D Integer Vector Attribute Value ****************/

class Int2AttributeValue : public Pointer {
public:
	Int2AttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<int, 2> value(void);
	inline void value(int values[2]);

};

/**************** Quaternion Attribute ****************/

class QuaternionAttribute : public Attribute {
public:
	QuaternionAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, QuaternionAttributeValue, QuaternionAttribute, data, true, true, false)

};

/**************** Quaternion Attribute Value ****************/

class QuaternionAttributeValue : public Pointer {
public:
	QuaternionAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 4> value(void);
	inline void value(float values[4]);

};

/**************** 4x4 Matrix Attribute ****************/

class Float4x4Attribute : public Attribute {
public:
	Float4x4Attribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, Float4x4AttributeValue, Float4x4Attribute, data, true, true, false)

};

/**************** Matrix Attribute Value ****************/

class Float4x4AttributeValue : public Pointer {
public:
	Float4x4AttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 16> value(void);
	inline void value(float values[16]);

};

/**************** String Attribute ****************/

class StringAttribute : public Attribute {
public:
	StringAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, StringAttributeValue, StringAttribute, data, true, true, false)

};

/**************** String Attribute Value ****************/

class StringAttributeValue : public Pointer {
public:
	StringAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string value(void);
	inline void value(const std::string& value);

};

/**************** Bool Attribute ****************/

class BoolAttribute : public Attribute {
public:
	BoolAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoolAttributeValue, BoolAttribute, data, true, true, false)

};

/**************** Bool Attribute Value ****************/

class BoolAttributeValue : public Pointer {
public:
	BoolAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool value(void);
	inline void value(bool value);

};

/**************** Float2 Attribute ****************/

class Float2Attribute : public Attribute {
public:
	Float2Attribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, Float2AttributeValue, Float2Attribute, data, true, true, false)

};

/**************** Float2 Attribute Value ****************/

class Float2AttributeValue : public Pointer {
public:
	Float2AttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 2> vector(void);
	inline void vector(float values[2]);

};

/**************** 8-bit Integer Attribute ****************/

class ByteIntAttribute : public Attribute {
public:
	ByteIntAttribute(const PointerRNA &ptr_arg) :
		Attribute(ptr_arg),
		data(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, ByteIntAttributeValue, ByteIntAttribute, data, true, true, false)

};

/**************** 8-bit Integer Attribute Value ****************/

class ByteIntAttributeValue : public Pointer {
public:
	ByteIntAttributeValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int value(void);
	inline void value(int value);

};

/**************** Asset Tag ****************/

class AssetTag : public Pointer {
public:
	AssetTag(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);

};

/**************** Asset Data ****************/

class AssetMetaData : public Pointer {
public:
	AssetMetaData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		tags(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string author(void);
	inline void author(const std::string& value);
	inline std::string description(void);
	inline void description(const std::string& value);
	inline std::string copyright(void);
	inline void copyright(const std::string& value);
	inline std::string license(void);
	inline void license(const std::string& value);
	COLLECTION_PROPERTY(AssetTags, AssetTag, AssetMetaData, tags, false, true, true)
	inline int active_tag(void);
	inline void active_tag(int value);
	inline std::string catalog_id(void);
	inline void catalog_id(const std::string& value);
	inline std::string catalog_simple_name(void);
	inline void catalog_simple_name(const std::string& value);

};

/**************** Asset Library Reference ****************/

class AssetLibraryReference : public Pointer {
public:
	AssetLibraryReference(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Asset Handle ****************/

class AssetHandle : public PropertyGroup {
public:
	AssetHandle(const PointerRNA &ptr_arg) :
		PropertyGroup(ptr_arg)
		{}

	inline FileSelectEntry file_data(void);

};

/**************** Asset Representation ****************/

class AssetRepresentation : public Pointer {
public:
	AssetRepresentation(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline AssetMetaData metadata(void);
	enum id_type_enum {
		id_type_ACTION = 17217,
		id_type_ARMATURE = 21057,
		id_type_BRUSH = 21058,
		id_type_CACHEFILE = 17987,
		id_type_CAMERA = 16707,
		id_type_COLLECTION = 21063,
		id_type_CURVE = 21827,
		id_type_CURVES = 22083,
		id_type_FONT = 18006,
		id_type_GREASEPENCIL = 17479,
		id_type_GREASEPENCIL_V3 = 20551,
		id_type_IMAGE = 19785,
		id_type_KEY = 17739,
		id_type_LATTICE = 21580,
		id_type_LIBRARY = 18764,
		id_type_LIGHT = 16716,
		id_type_LIGHT_PROBE = 20556,
		id_type_LINESTYLE = 21324,
		id_type_MASK = 21325,
		id_type_MATERIAL = 16717,
		id_type_MESH = 17741,
		id_type_META = 16973,
		id_type_MOVIECLIP = 17229,
		id_type_NODETREE = 21582,
		id_type_OBJECT = 16975,
		id_type_PAINTCURVE = 17232,
		id_type_PALETTE = 19536,
		id_type_PARTICLE = 16720,
		id_type_POINTCLOUD = 21584,
		id_type_SCENE = 17235,
		id_type_SCREEN = 21075,
		id_type_SOUND = 20307,
		id_type_SPEAKER = 19283,
		id_type_TEXT = 22612,
		id_type_TEXTURE = 17748,
		id_type_VOLUME = 20310,
		id_type_WINDOWMANAGER = 19799,
		id_type_WORKSPACE = 21335,
		id_type_WORLD = 20311,
	};
	inline id_type_enum id_type(void);
	inline void id_type(id_type_enum value);
	inline ID local_id(void);
	inline std::string full_library_path(void);
	inline void full_library_path(const std::string& value);
	inline std::string full_path(void);
	inline void full_path(const std::string& value);

};

/**************** Catalog Path ****************/

class AssetCatalogPath : public Pointer {
public:
	AssetCatalogPath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Asset Weak Reference ****************/

class AssetWeakReference : public Pointer {
public:
	AssetWeakReference(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum asset_library_type_enum {
		asset_library_type_ALL = 2,
		asset_library_type_LOCAL = 1,
		asset_library_type_ESSENTIALS = 3,
		asset_library_type_CUSTOM = 100,
	};
	inline asset_library_type_enum asset_library_type(void);
	inline void asset_library_type(asset_library_type_enum value);
	inline std::string asset_library_identifier(void);
	inline void asset_library_identifier(const std::string& value);
	inline std::string relative_asset_identifier(void);
	inline void relative_asset_identifier(const std::string& value);

};

/**************** Boid Rule ****************/

class BoidRule : public Pointer {
public:
	BoidRule(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum type_enum {
		type_GOAL = 1,
		type_AVOID = 2,
		type_AVOID_COLLISION = 3,
		type_SEPARATE = 4,
		type_FLOCK = 5,
		type_FOLLOW_LEADER = 6,
		type_AVERAGE_SPEED = 7,
		type_FIGHT = 8,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use_in_air(void);
	inline void use_in_air(bool value);
	inline bool use_on_land(void);
	inline void use_on_land(bool value);

};

/**************** Goal ****************/

class BoidRuleGoal : public BoidRule {
public:
	BoidRuleGoal(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline Object object(void);
	inline bool use_predict(void);
	inline void use_predict(bool value);

};

/**************** Avoid ****************/

class BoidRuleAvoid : public BoidRule {
public:
	BoidRuleAvoid(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline Object object(void);
	inline bool use_predict(void);
	inline void use_predict(bool value);
	inline float fear_factor(void);
	inline void fear_factor(float value);

};

/**************** Avoid Collision ****************/

class BoidRuleAvoidCollision : public BoidRule {
public:
	BoidRuleAvoidCollision(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline bool use_avoid(void);
	inline void use_avoid(bool value);
	inline bool use_avoid_collision(void);
	inline void use_avoid_collision(bool value);
	inline float look_ahead(void);
	inline void look_ahead(float value);

};

/**************** Follow Leader ****************/

class BoidRuleFollowLeader : public BoidRule {
public:
	BoidRuleFollowLeader(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline Object object(void);
	inline float distance(void);
	inline void distance(float value);
	inline int queue_count(void);
	inline void queue_count(int value);
	inline bool use_line(void);
	inline void use_line(bool value);

};

/**************** Average Speed ****************/

class BoidRuleAverageSpeed : public BoidRule {
public:
	BoidRuleAverageSpeed(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline float wander(void);
	inline void wander(float value);
	inline float level(void);
	inline void level(float value);
	inline float speed(void);
	inline void speed(float value);

};

/**************** Fight ****************/

class BoidRuleFight : public BoidRule {
public:
	BoidRuleFight(const PointerRNA &ptr_arg) :
		BoidRule(ptr_arg)
		{}

	inline float distance(void);
	inline void distance(float value);
	inline float flee_distance(void);
	inline void flee_distance(float value);

};

/**************** Boid State ****************/

class BoidState : public Pointer {
public:
	BoidState(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		rules(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum ruleset_type_enum {
		ruleset_type_FUZZY = 0,
		ruleset_type_RANDOM = 1,
		ruleset_type_AVERAGE = 2,
	};
	inline ruleset_type_enum ruleset_type(void);
	inline void ruleset_type(ruleset_type_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoidRule, BoidState, rules, false, true, true)
	inline BoidRule active_boid_rule(void);
	inline int active_boid_rule_index(void);
	inline void active_boid_rule_index(int value);
	inline float rule_fuzzy(void);
	inline void rule_fuzzy(float value);
	inline float volume(void);
	inline void volume(float value);
	inline float falloff(void);
	inline void falloff(float value);

};

/**************** Boid Settings ****************/

class BoidSettings : public Pointer {
public:
	BoidSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		states(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float land_smooth(void);
	inline void land_smooth(float value);
	inline float bank(void);
	inline void bank(float value);
	inline float pitch(void);
	inline void pitch(float value);
	inline float height(void);
	inline void height(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoidState, BoidSettings, states, false, true, true)
	inline BoidRule active_boid_state(void);
	inline int active_boid_state_index(void);
	inline void active_boid_state_index(int value);
	inline float health(void);
	inline void health(float value);
	inline float strength(void);
	inline void strength(float value);
	inline float aggression(void);
	inline void aggression(float value);
	inline float accuracy(void);
	inline void accuracy(float value);
	inline float range(void);
	inline void range(float value);
	inline float air_speed_min(void);
	inline void air_speed_min(float value);
	inline float air_speed_max(void);
	inline void air_speed_max(float value);
	inline float air_acc_max(void);
	inline void air_acc_max(float value);
	inline float air_ave_max(void);
	inline void air_ave_max(float value);
	inline float air_personal_space(void);
	inline void air_personal_space(float value);
	inline float land_jump_speed(void);
	inline void land_jump_speed(float value);
	inline float land_speed_max(void);
	inline void land_speed_max(float value);
	inline float land_acc_max(void);
	inline void land_acc_max(float value);
	inline float land_ave_max(void);
	inline void land_ave_max(float value);
	inline float land_personal_space(void);
	inline void land_personal_space(float value);
	inline float land_stick_force(void);
	inline void land_stick_force(float value);
	inline bool use_flight(void);
	inline void use_flight(bool value);
	inline bool use_land(void);
	inline void use_land(bool value);
	inline bool use_climb(void);
	inline void use_climb(bool value);

};

/**************** Brush ****************/

class Brush : public ID {
public:
	Brush(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	inline bool has_unsaved_changes(void);
	inline void has_unsaved_changes(bool value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 5,
		blend_MUL = 3,
		blend_COLORBURN = 10,
		blend_LINEARBURN = 11,
		blend_LIGHTEN = 4,
		blend_SCREEN = 13,
		blend_COLORDODGE = 12,
		blend_ADD = 1,
		blend_OVERLAY = 8,
		blend_SOFTLIGHT = 14,
		blend_HARDLIGHT = 9,
		blend_VIVIDLIGHT = 16,
		blend_LINEARLIGHT = 17,
		blend_PINLIGHT = 15,
		blend_DIFFERENCE = 18,
		blend_EXCLUSION = 19,
		blend_SUB = 2,
		blend_HUE = 20,
		blend_SATURATION = 21,
		blend_COLOR = 23,
		blend_LUMINOSITY = 22,
		blend_ERASE_ALPHA = 6,
		blend_ADD_ALPHA = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	enum sculpt_tool_enum {
		sculpt_tool_DRAW = 1,
		sculpt_tool_DRAW_SHARP = 20,
		sculpt_tool_CLAY = 8,
		sculpt_tool_CLAY_STRIPS = 18,
		sculpt_tool_CLAY_THUMB = 25,
		sculpt_tool_LAYER = 6,
		sculpt_tool_INFLATE = 4,
		sculpt_tool_BLOB = 17,
		sculpt_tool_CREASE = 16,
		sculpt_tool_SMOOTH = 2,
		sculpt_tool_PLANE = 33,
		sculpt_tool_MULTIPLANE_SCRAPE = 23,
		sculpt_tool_PINCH = 3,
		sculpt_tool_GRAB = 5,
		sculpt_tool_ELASTIC_DEFORM = 21,
		sculpt_tool_SNAKE_HOOK = 13,
		sculpt_tool_THUMB = 12,
		sculpt_tool_POSE = 22,
		sculpt_tool_NUDGE = 11,
		sculpt_tool_ROTATE = 14,
		sculpt_tool_TOPOLOGY = 24,
		sculpt_tool_BOUNDARY = 30,
		sculpt_tool_CLOTH = 26,
		sculpt_tool_SIMPLIFY = 15,
		sculpt_tool_MASK = 19,
		sculpt_tool_DRAW_FACE_SETS = 27,
		sculpt_tool_DISPLACEMENT_ERASER = 31,
		sculpt_tool_DISPLACEMENT_SMEAR = 32,
		sculpt_tool_PAINT = 28,
		sculpt_tool_SMEAR = 29,
	};
	inline sculpt_tool_enum sculpt_tool(void);
	inline void sculpt_tool(sculpt_tool_enum value);
	enum vertex_tool_enum {
		vertex_tool_DRAW = 0,
		vertex_tool_BLUR = 1,
		vertex_tool_AVERAGE = 2,
		vertex_tool_SMEAR = 3,
	};
	inline vertex_tool_enum vertex_tool(void);
	inline void vertex_tool(vertex_tool_enum value);
	enum weight_tool_enum {
		weight_tool_DRAW = 0,
		weight_tool_BLUR = 1,
		weight_tool_AVERAGE = 2,
		weight_tool_SMEAR = 3,
	};
	inline weight_tool_enum weight_tool(void);
	inline void weight_tool(weight_tool_enum value);
	enum image_tool_enum {
		image_tool_DRAW = 0,
		image_tool_SOFTEN = 1,
		image_tool_SMEAR = 2,
		image_tool_CLONE = 3,
		image_tool_FILL = 4,
		image_tool_MASK = 5,
	};
	inline image_tool_enum image_tool(void);
	inline void image_tool(image_tool_enum value);
	enum gpencil_tool_enum {
		gpencil_tool_DRAW = 0,
		gpencil_tool_FILL = 1,
		gpencil_tool_ERASE = 2,
		gpencil_tool_TINT = 3,
	};
	inline gpencil_tool_enum gpencil_tool(void);
	inline void gpencil_tool(gpencil_tool_enum value);
	enum gpencil_vertex_tool_enum {
		gpencil_vertex_tool_DRAW = 0,
		gpencil_vertex_tool_BLUR = 1,
		gpencil_vertex_tool_AVERAGE = 2,
		gpencil_vertex_tool_SMEAR = 4,
		gpencil_vertex_tool_REPLACE = 5,
	};
	inline gpencil_vertex_tool_enum gpencil_vertex_tool(void);
	inline void gpencil_vertex_tool(gpencil_vertex_tool_enum value);
	enum gpencil_sculpt_tool_enum {
		gpencil_sculpt_tool_SMOOTH = 0,
		gpencil_sculpt_tool_THICKNESS = 1,
		gpencil_sculpt_tool_STRENGTH = 2,
		gpencil_sculpt_tool_RANDOMIZE = 7,
		gpencil_sculpt_tool_GRAB = 3,
		gpencil_sculpt_tool_PUSH = 4,
		gpencil_sculpt_tool_TWIST = 5,
		gpencil_sculpt_tool_PINCH = 6,
		gpencil_sculpt_tool_CLONE = 8,
	};
	inline gpencil_sculpt_tool_enum gpencil_sculpt_tool(void);
	inline void gpencil_sculpt_tool(gpencil_sculpt_tool_enum value);
	enum gpencil_weight_tool_enum {
		gpencil_weight_tool_WEIGHT = 0,
		gpencil_weight_tool_BLUR = 1,
		gpencil_weight_tool_AVERAGE = 2,
		gpencil_weight_tool_SMEAR = 3,
	};
	inline gpencil_weight_tool_enum gpencil_weight_tool(void);
	inline void gpencil_weight_tool(gpencil_weight_tool_enum value);
	enum curves_sculpt_tool_enum {
		curves_sculpt_tool_SELECTION_PAINT = 5,
		curves_sculpt_tool_ADD = 3,
		curves_sculpt_tool_DELETE = 1,
		curves_sculpt_tool_DENSITY = 9,
		curves_sculpt_tool_COMB = 0,
		curves_sculpt_tool_SNAKE_HOOK = 2,
		curves_sculpt_tool_GROW_SHRINK = 4,
		curves_sculpt_tool_PINCH = 6,
		curves_sculpt_tool_PUFF = 8,
		curves_sculpt_tool_SMOOTH = 7,
		curves_sculpt_tool_SLIDE = 10,
	};
	inline curves_sculpt_tool_enum curves_sculpt_tool(void);
	inline void curves_sculpt_tool(curves_sculpt_tool_enum value);
	enum direction_enum {
		direction_ADD = 0,
		direction_SUBTRACT = 512,
	};
	inline direction_enum direction(void);
	inline void direction(direction_enum value);
	enum stroke_method_enum {
		stroke_method_DOTS = 0,
		stroke_method_DRAG_DOT = 8388608,
		stroke_method_SPACE = 1024,
		stroke_method_AIRBRUSH = 1,
		stroke_method_ANCHORED = 256,
		stroke_method_LINE = 536870912,
		stroke_method_CURVE = -2147483648,
	};
	inline stroke_method_enum stroke_method(void);
	inline void stroke_method(stroke_method_enum value);
	enum sculpt_plane_enum {
		sculpt_plane_AREA = 0,
		sculpt_plane_VIEW = 1,
		sculpt_plane_X = 2,
		sculpt_plane_Y = 3,
		sculpt_plane_Z = 4,
	};
	inline sculpt_plane_enum sculpt_plane(void);
	inline void sculpt_plane(sculpt_plane_enum value);
	enum mask_tool_enum {
		mask_tool_DRAW = 0,
		mask_tool_SMOOTH = 1,
	};
	inline mask_tool_enum mask_tool(void);
	inline void mask_tool(mask_tool_enum value);
	enum curve_preset_enum {
		curve_preset_CUSTOM = 0,
		curve_preset_SMOOTH = 1,
		curve_preset_SMOOTHER = 9,
		curve_preset_SPHERE = 2,
		curve_preset_ROOT = 3,
		curve_preset_SHARP = 4,
		curve_preset_LIN = 5,
		curve_preset_POW4 = 6,
		curve_preset_INVSQUARE = 7,
		curve_preset_CONSTANT = 8,
	};
	inline curve_preset_enum curve_preset(void);
	inline void curve_preset(curve_preset_enum value);
	enum deform_target_enum {
		deform_target_GEOMETRY = 0,
		deform_target_CLOTH_SIM = 1,
	};
	inline deform_target_enum deform_target(void);
	inline void deform_target(deform_target_enum value);
	enum elastic_deform_type_enum {
		elastic_deform_type_GRAB = 0,
		elastic_deform_type_GRAB_BISCALE = 1,
		elastic_deform_type_GRAB_TRISCALE = 2,
		elastic_deform_type_SCALE = 3,
		elastic_deform_type_TWIST = 4,
	};
	inline elastic_deform_type_enum elastic_deform_type(void);
	inline void elastic_deform_type(elastic_deform_type_enum value);
	enum snake_hook_deform_type_enum {
		snake_hook_deform_type_FALLOFF = 0,
		snake_hook_deform_type_ELASTIC = 1,
	};
	inline snake_hook_deform_type_enum snake_hook_deform_type(void);
	inline void snake_hook_deform_type(snake_hook_deform_type_enum value);
	enum plane_inversion_mode_enum {
		plane_inversion_mode_INVERT_DISPLACEMENT = 0,
		plane_inversion_mode_SWAP_DEPTH_AND_HEIGHT = 1,
	};
	inline plane_inversion_mode_enum plane_inversion_mode(void);
	inline void plane_inversion_mode(plane_inversion_mode_enum value);
	enum cloth_deform_type_enum {
		cloth_deform_type_DRAG = 0,
		cloth_deform_type_PUSH = 1,
		cloth_deform_type_PINCH_POINT = 3,
		cloth_deform_type_PINCH_PERPENDICULAR = 4,
		cloth_deform_type_INFLATE = 5,
		cloth_deform_type_GRAB = 2,
		cloth_deform_type_EXPAND = 6,
		cloth_deform_type_SNAKE_HOOK = 7,
	};
	inline cloth_deform_type_enum cloth_deform_type(void);
	inline void cloth_deform_type(cloth_deform_type_enum value);
	enum cloth_force_falloff_type_enum {
		cloth_force_falloff_type_RADIAL = 0,
		cloth_force_falloff_type_PLANE = 1,
	};
	inline cloth_force_falloff_type_enum cloth_force_falloff_type(void);
	inline void cloth_force_falloff_type(cloth_force_falloff_type_enum value);
	enum cloth_simulation_area_type_enum {
		cloth_simulation_area_type_LOCAL = 0,
		cloth_simulation_area_type_GLOBAL = 1,
		cloth_simulation_area_type_DYNAMIC = 2,
	};
	inline cloth_simulation_area_type_enum cloth_simulation_area_type(void);
	inline void cloth_simulation_area_type(cloth_simulation_area_type_enum value);
	enum boundary_falloff_type_enum {
		boundary_falloff_type_CONSTANT = 0,
		boundary_falloff_type_RADIUS = 1,
		boundary_falloff_type_LOOP = 2,
		boundary_falloff_type_LOOP_INVERT = 3,
	};
	inline boundary_falloff_type_enum boundary_falloff_type(void);
	inline void boundary_falloff_type(boundary_falloff_type_enum value);
	enum smooth_deform_type_enum {
		smooth_deform_type_LAPLACIAN = 0,
		smooth_deform_type_SURFACE = 1,
	};
	inline smooth_deform_type_enum smooth_deform_type(void);
	inline void smooth_deform_type(smooth_deform_type_enum value);
	enum smear_deform_type_enum {
		smear_deform_type_DRAG = 0,
		smear_deform_type_PINCH = 1,
		smear_deform_type_EXPAND = 2,
	};
	inline smear_deform_type_enum smear_deform_type(void);
	inline void smear_deform_type(smear_deform_type_enum value);
	enum slide_deform_type_enum {
		slide_deform_type_DRAG = 0,
		slide_deform_type_PINCH = 1,
		slide_deform_type_EXPAND = 2,
	};
	inline slide_deform_type_enum slide_deform_type(void);
	inline void slide_deform_type(slide_deform_type_enum value);
	enum boundary_deform_type_enum {
		boundary_deform_type_BEND = 0,
		boundary_deform_type_EXPAND = 1,
		boundary_deform_type_INFLATE = 2,
		boundary_deform_type_GRAB = 3,
		boundary_deform_type_TWIST = 4,
		boundary_deform_type_SMOOTH = 5,
	};
	inline boundary_deform_type_enum boundary_deform_type(void);
	inline void boundary_deform_type(boundary_deform_type_enum value);
	enum pose_deform_type_enum {
		pose_deform_type_ROTATE_TWIST = 0,
		pose_deform_type_SCALE_TRANSLATE = 1,
		pose_deform_type_SQUASH_STRETCH = 2,
	};
	inline pose_deform_type_enum pose_deform_type(void);
	inline void pose_deform_type(pose_deform_type_enum value);
	enum pose_origin_type_enum {
		pose_origin_type_TOPOLOGY = 0,
		pose_origin_type_FACE_SETS = 1,
		pose_origin_type_FACE_SETS_FK = 2,
	};
	inline pose_origin_type_enum pose_origin_type(void);
	inline void pose_origin_type(pose_origin_type_enum value);
	enum jitter_unit_enum {
		jitter_unit_VIEW = 1073741824,
		jitter_unit_BRUSH = 0,
	};
	inline jitter_unit_enum jitter_unit(void);
	inline void jitter_unit(jitter_unit_enum value);
	enum falloff_shape_enum {
		falloff_shape_SPHERE = 0,
		falloff_shape_PROJECTED = 1,
	};
	inline falloff_shape_enum falloff_shape(void);
	inline void falloff_shape(falloff_shape_enum value);
	inline int size(void);
	inline void size(int value);
	inline float unprojected_radius(void);
	inline void unprojected_radius(float value);
	inline int input_samples(void);
	inline void input_samples(int value);
	inline float jitter(void);
	inline void jitter(float value);
	inline int jitter_absolute(void);
	inline void jitter_absolute(int value);
	inline int spacing(void);
	inline void spacing(int value);
	inline int grad_spacing(void);
	inline void grad_spacing(int value);
	inline bool use_color_jitter(void);
	inline void use_color_jitter(bool value);
	inline float hue_jitter(void);
	inline void hue_jitter(float value);
	inline float saturation_jitter(void);
	inline void saturation_jitter(float value);
	inline float value_jitter(void);
	inline void value_jitter(float value);
	inline bool use_stroke_random_hue(void);
	inline void use_stroke_random_hue(bool value);
	inline bool use_stroke_random_sat(void);
	inline void use_stroke_random_sat(bool value);
	inline bool use_stroke_random_val(void);
	inline void use_stroke_random_val(bool value);
	inline bool use_random_press_hue(void);
	inline void use_random_press_hue(bool value);
	inline bool use_random_press_sat(void);
	inline void use_random_press_sat(bool value);
	inline bool use_random_press_val(void);
	inline void use_random_press_val(bool value);
	inline CurveMapping curve_random_hue(void);
	inline CurveMapping curve_random_saturation(void);
	inline CurveMapping curve_random_value(void);
	inline int smooth_stroke_radius(void);
	inline void smooth_stroke_radius(int value);
	inline float smooth_stroke_factor(void);
	inline void smooth_stroke_factor(float value);
	inline float rate(void);
	inline void rate(float value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline Array<float, 3> secondary_color(void);
	inline void secondary_color(float values[3]);
	inline float weight(void);
	inline void weight(float value);
	inline float strength(void);
	inline void strength(float value);
	inline float flow(void);
	inline void flow(float value);
	inline float wet_mix(void);
	inline void wet_mix(float value);
	inline float wet_persistence(void);
	inline void wet_persistence(float value);
	inline float density(void);
	inline void density(float value);
	inline float tip_scale_x(void);
	inline void tip_scale_x(float value);
	inline bool use_hardness_pressure(void);
	inline void use_hardness_pressure(bool value);
	inline bool invert_hardness_pressure(void);
	inline void invert_hardness_pressure(bool value);
	inline bool use_flow_pressure(void);
	inline void use_flow_pressure(bool value);
	inline bool invert_flow_pressure(void);
	inline void invert_flow_pressure(bool value);
	inline bool use_wet_mix_pressure(void);
	inline void use_wet_mix_pressure(bool value);
	inline bool invert_wet_mix_pressure(void);
	inline void invert_wet_mix_pressure(bool value);
	inline bool use_wet_persistence_pressure(void);
	inline void use_wet_persistence_pressure(bool value);
	inline bool invert_wet_persistence_pressure(void);
	inline void invert_wet_persistence_pressure(bool value);
	inline bool use_density_pressure(void);
	inline void use_density_pressure(bool value);
	inline bool invert_density_pressure(void);
	inline void invert_density_pressure(bool value);
	inline float dash_ratio(void);
	inline void dash_ratio(float value);
	inline int dash_samples(void);
	inline void dash_samples(int value);
	inline float plane_offset(void);
	inline void plane_offset(float value);
	inline float plane_trim(void);
	inline void plane_trim(float value);
	inline float height(void);
	inline void height(float value);
	inline float plane_depth(void);
	inline void plane_depth(float value);
	inline float plane_height(void);
	inline void plane_height(float value);
	inline float stabilize_normal(void);
	inline void stabilize_normal(float value);
	inline float stabilize_plane(void);
	inline void stabilize_plane(float value);
	inline float texture_sample_bias(void);
	inline void texture_sample_bias(float value);
	inline bool use_color_as_displacement(void);
	inline void use_color_as_displacement(bool value);
	inline float normal_weight(void);
	inline void normal_weight(float value);
	inline float elastic_deform_volume_preservation(void);
	inline void elastic_deform_volume_preservation(float value);
	inline float rake_factor(void);
	inline void rake_factor(float value);
	inline float crease_pinch_factor(void);
	inline void crease_pinch_factor(float value);
	inline float pose_offset(void);
	inline void pose_offset(float value);
	inline float disconnected_distance_max(void);
	inline void disconnected_distance_max(float value);
	inline float boundary_offset(void);
	inline void boundary_offset(float value);
	inline float surface_smooth_shape_preservation(void);
	inline void surface_smooth_shape_preservation(float value);
	inline float surface_smooth_current_vertex(void);
	inline void surface_smooth_current_vertex(float value);
	inline int surface_smooth_iterations(void);
	inline void surface_smooth_iterations(int value);
	inline float multiplane_scrape_angle(void);
	inline void multiplane_scrape_angle(float value);
	inline int pose_smooth_iterations(void);
	inline void pose_smooth_iterations(int value);
	inline int pose_ik_segments(void);
	inline void pose_ik_segments(int value);
	inline float tip_roundness(void);
	inline void tip_roundness(float value);
	inline float cloth_mass(void);
	inline void cloth_mass(float value);
	inline float cloth_damping(void);
	inline void cloth_damping(float value);
	inline float cloth_sim_limit(void);
	inline void cloth_sim_limit(float value);
	inline float cloth_sim_falloff(void);
	inline void cloth_sim_falloff(float value);
	inline float cloth_constraint_softbody_strength(void);
	inline void cloth_constraint_softbody_strength(float value);
	inline float hardness(void);
	inline void hardness(float value);
	inline int automasking_boundary_edges_propagation_steps(void);
	inline void automasking_boundary_edges_propagation_steps(int value);
	inline float auto_smooth_factor(void);
	inline void auto_smooth_factor(float value);
	inline float topology_rake_factor(void);
	inline void topology_rake_factor(float value);
	inline float tilt_strength_factor(void);
	inline void tilt_strength_factor(float value);
	inline float normal_radius_factor(void);
	inline void normal_radius_factor(float value);
	inline float area_radius_factor(void);
	inline void area_radius_factor(float value);
	inline float wet_paint_radius_factor(void);
	inline void wet_paint_radius_factor(float value);
	inline Array<float, 2> stencil_pos(void);
	inline void stencil_pos(float values[2]);
	inline Array<float, 2> stencil_dimension(void);
	inline void stencil_dimension(float values[2]);
	inline Array<float, 2> mask_stencil_pos(void);
	inline void mask_stencil_pos(float values[2]);
	inline Array<float, 2> mask_stencil_dimension(void);
	inline void mask_stencil_dimension(float values[2]);
	inline float sharp_threshold(void);
	inline void sharp_threshold(float value);
	inline float fill_threshold(void);
	inline void fill_threshold(float value);
	inline int blur_kernel_radius(void);
	inline void blur_kernel_radius(int value);
	enum blur_mode_enum {
		blur_mode_BOX = 1,
		blur_mode_GAUSSIAN = 0,
	};
	inline blur_mode_enum blur_mode(void);
	inline void blur_mode(blur_mode_enum value);
	inline float falloff_angle(void);
	inline void falloff_angle(float value);
	inline bool use_airbrush(void);
	inline void use_airbrush(bool value);
	inline bool use_original_normal(void);
	inline void use_original_normal(bool value);
	inline bool use_original_plane(void);
	inline void use_original_plane(bool value);
	inline bool use_automasking_topology(void);
	inline void use_automasking_topology(bool value);
	inline bool use_automasking_face_sets(void);
	inline void use_automasking_face_sets(bool value);
	inline bool use_automasking_boundary_edges(void);
	inline void use_automasking_boundary_edges(bool value);
	inline bool use_automasking_boundary_face_sets(void);
	inline void use_automasking_boundary_face_sets(bool value);
	inline bool use_automasking_cavity(void);
	inline void use_automasking_cavity(bool value);
	inline bool use_automasking_cavity_inverted(void);
	inline void use_automasking_cavity_inverted(bool value);
	inline bool use_automasking_custom_cavity_curve(void);
	inline void use_automasking_custom_cavity_curve(bool value);
	inline float automasking_cavity_factor(void);
	inline void automasking_cavity_factor(float value);
	inline int automasking_cavity_blur_steps(void);
	inline void automasking_cavity_blur_steps(int value);
	inline CurveMapping automasking_cavity_curve(void);
	inline bool use_automasking_start_normal(void);
	inline void use_automasking_start_normal(bool value);
	inline float automasking_start_normal_limit(void);
	inline void automasking_start_normal_limit(float value);
	inline float automasking_start_normal_falloff(void);
	inline void automasking_start_normal_falloff(float value);
	inline bool use_automasking_view_normal(void);
	inline void use_automasking_view_normal(bool value);
	inline bool use_automasking_view_occlusion(void);
	inline void use_automasking_view_occlusion(bool value);
	inline float automasking_view_normal_limit(void);
	inline void automasking_view_normal_limit(float value);
	inline float automasking_view_normal_falloff(void);
	inline void automasking_view_normal_falloff(float value);
	enum use_scene_spacing_enum {
		use_scene_spacing_VIEW = 0,
		use_scene_spacing_SCENE = 131072,
	};
	inline use_scene_spacing_enum use_scene_spacing(void);
	inline void use_scene_spacing(use_scene_spacing_enum value);
	inline bool use_grab_active_vertex(void);
	inline void use_grab_active_vertex(bool value);
	inline bool use_grab_silhouette(void);
	inline void use_grab_silhouette(bool value);
	inline bool use_paint_antialiasing(void);
	inline void use_paint_antialiasing(bool value);
	inline bool use_multiplane_scrape_dynamic(void);
	inline void use_multiplane_scrape_dynamic(bool value);
	inline bool show_multiplane_scrape_planes_preview(void);
	inline void show_multiplane_scrape_planes_preview(bool value);
	inline bool use_pose_ik_anchored(void);
	inline void use_pose_ik_anchored(bool value);
	inline bool use_pose_lock_rotation(void);
	inline void use_pose_lock_rotation(bool value);
	inline bool use_connected_only(void);
	inline void use_connected_only(bool value);
	inline bool use_cloth_pin_simulation_boundary(void);
	inline void use_cloth_pin_simulation_boundary(bool value);
	inline bool use_cloth_collision(void);
	inline void use_cloth_collision(bool value);
	inline bool invert_to_scrape_fill(void);
	inline void invert_to_scrape_fill(bool value);
	inline bool use_pressure_strength(void);
	inline void use_pressure_strength(bool value);
	inline bool use_offset_pressure(void);
	inline void use_offset_pressure(bool value);
	inline bool use_pressure_area_radius(void);
	inline void use_pressure_area_radius(bool value);
	inline bool use_pressure_size(void);
	inline void use_pressure_size(bool value);
	inline bool use_pressure_jitter(void);
	inline void use_pressure_jitter(bool value);
	inline bool use_pressure_spacing(void);
	inline void use_pressure_spacing(bool value);
	enum use_pressure_masking_enum {
		use_pressure_masking_NONE = 0,
		use_pressure_masking_RAMP = 2,
		use_pressure_masking_CUTOFF = 4,
	};
	inline use_pressure_masking_enum use_pressure_masking(void);
	inline void use_pressure_masking(use_pressure_masking_enum value);
	inline bool use_inverse_smooth_pressure(void);
	inline void use_inverse_smooth_pressure(bool value);
	inline bool use_plane_trim(void);
	inline void use_plane_trim(bool value);
	inline bool use_frontface(void);
	inline void use_frontface(bool value);
	inline bool use_frontface_falloff(void);
	inline void use_frontface_falloff(bool value);
	inline bool use_anchor(void);
	inline void use_anchor(bool value);
	inline bool use_space(void);
	inline void use_space(bool value);
	inline bool use_line(void);
	inline void use_line(bool value);
	inline bool use_curve(void);
	inline void use_curve(bool value);
	inline bool use_smooth_stroke(void);
	inline void use_smooth_stroke(bool value);
	inline bool use_persistent(void);
	inline void use_persistent(bool value);
	inline bool use_accumulate(void);
	inline void use_accumulate(bool value);
	inline bool use_space_attenuation(void);
	inline void use_space_attenuation(bool value);
	inline bool use_adaptive_space(void);
	inline void use_adaptive_space(bool value);
	enum use_locked_size_enum {
		use_locked_size_VIEW = 0,
		use_locked_size_SCENE = 1048576,
	};
	inline use_locked_size_enum use_locked_size(void);
	inline void use_locked_size(use_locked_size_enum value);
	enum color_type_enum {
		color_type_COLOR = 0,
		color_type_GRADIENT = 2097152,
	};
	inline color_type_enum color_type(void);
	inline void color_type(color_type_enum value);
	inline bool use_edge_to_edge(void);
	inline void use_edge_to_edge(bool value);
	inline bool use_restore_mesh(void);
	inline void use_restore_mesh(bool value);
	inline bool use_alpha(void);
	inline void use_alpha(bool value);
	inline CurveMapping curve(void);
	inline PaintCurve paint_curve(void);
	inline ColorRamp gradient(void);
	enum gradient_stroke_mode_enum {
		gradient_stroke_mode_PRESSURE = 0,
		gradient_stroke_mode_SPACING_REPEAT = 1,
		gradient_stroke_mode_SPACING_CLAMP = 2,
	};
	inline gradient_stroke_mode_enum gradient_stroke_mode(void);
	inline void gradient_stroke_mode(gradient_stroke_mode_enum value);
	enum gradient_fill_mode_enum {
		gradient_fill_mode_LINEAR = 0,
		gradient_fill_mode_RADIAL = 1,
	};
	inline gradient_fill_mode_enum gradient_fill_mode(void);
	inline void gradient_fill_mode(gradient_fill_mode_enum value);
	inline bool use_primary_overlay(void);
	inline void use_primary_overlay(bool value);
	inline bool use_secondary_overlay(void);
	inline void use_secondary_overlay(bool value);
	inline bool use_cursor_overlay(void);
	inline void use_cursor_overlay(bool value);
	inline bool use_cursor_overlay_override(void);
	inline void use_cursor_overlay_override(bool value);
	inline bool use_primary_overlay_override(void);
	inline void use_primary_overlay_override(bool value);
	inline bool use_secondary_overlay_override(void);
	inline void use_secondary_overlay_override(bool value);
	inline bool use_paint_sculpt(void);
	inline void use_paint_sculpt(bool value);
	inline bool use_paint_uv_sculpt(void);
	inline void use_paint_uv_sculpt(bool value);
	inline bool use_paint_vertex(void);
	inline void use_paint_vertex(bool value);
	inline bool use_paint_weight(void);
	inline void use_paint_weight(bool value);
	inline bool use_paint_image(void);
	inline void use_paint_image(bool value);
	inline bool use_paint_grease_pencil(void);
	inline void use_paint_grease_pencil(bool value);
	inline bool use_vertex_grease_pencil(void);
	inline void use_vertex_grease_pencil(bool value);
	inline bool use_paint_sculpt_curves(void);
	inline void use_paint_sculpt_curves(bool value);
	inline BrushTextureSlot texture_slot(void);
	inline Texture texture(void);
	inline BrushTextureSlot mask_texture_slot(void);
	inline Texture mask_texture(void);
	inline int texture_overlay_alpha(void);
	inline void texture_overlay_alpha(int value);
	inline int mask_overlay_alpha(void);
	inline void mask_overlay_alpha(int value);
	inline int cursor_overlay_alpha(void);
	inline void cursor_overlay_alpha(int value);
	inline Array<float, 4> cursor_color_add(void);
	inline void cursor_color_add(float values[4]);
	inline Array<float, 4> cursor_color_subtract(void);
	inline void cursor_color_subtract(float values[4]);
	inline bool use_custom_icon(void);
	inline void use_custom_icon(bool value);
	inline std::string icon_filepath(void);
	inline void icon_filepath(const std::string& value);
	inline BrushCapabilities brush_capabilities(void);
	inline BrushCapabilitiesSculpt sculpt_capabilities(void);
	inline BrushCapabilitiesImagePaint image_paint_capabilities(void);
	inline BrushCapabilitiesVertexPaint vertex_paint_capabilities(void);
	inline BrushCapabilitiesWeightPaint weight_paint_capabilities(void);
	inline BrushGpencilSettings gpencil_settings(void);
	inline BrushCurvesSculptSettings curves_sculpt_settings(void);

};

/**************** Brush Capabilities ****************/

class BrushCapabilities : public Pointer {
public:
	BrushCapabilities(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool has_overlay(void);
	inline void has_overlay(bool value);
	inline bool has_random_texture_angle(void);
	inline void has_random_texture_angle(bool value);
	inline bool has_spacing(void);
	inline void has_spacing(bool value);
	inline bool has_smooth_stroke(void);
	inline void has_smooth_stroke(bool value);

};

/**************** Sculpt Capabilities ****************/

class BrushCapabilitiesSculpt : public Pointer {
public:
	BrushCapabilitiesSculpt(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool has_accumulate(void);
	inline void has_accumulate(bool value);
	inline bool has_auto_smooth(void);
	inline void has_auto_smooth(bool value);
	inline bool has_topology_rake(void);
	inline void has_topology_rake(bool value);
	inline bool has_height(void);
	inline void has_height(bool value);
	inline bool has_plane_depth(void);
	inline void has_plane_depth(bool value);
	inline bool has_plane_height(void);
	inline void has_plane_height(bool value);
	inline bool has_jitter(void);
	inline void has_jitter(bool value);
	inline bool has_normal_weight(void);
	inline void has_normal_weight(bool value);
	inline bool has_rake_factor(void);
	inline void has_rake_factor(bool value);
	inline bool has_persistence(void);
	inline void has_persistence(bool value);
	inline bool has_pinch_factor(void);
	inline void has_pinch_factor(bool value);
	inline bool has_plane_offset(void);
	inline void has_plane_offset(bool value);
	inline bool has_random_texture_angle(void);
	inline void has_random_texture_angle(bool value);
	inline bool has_sculpt_plane(void);
	inline void has_sculpt_plane(bool value);
	inline bool has_color(void);
	inline void has_color(bool value);
	inline bool has_secondary_color(void);
	inline void has_secondary_color(bool value);
	inline bool has_smooth_stroke(void);
	inline void has_smooth_stroke(bool value);
	inline bool has_space_attenuation(void);
	inline void has_space_attenuation(bool value);
	inline bool has_strength_pressure(void);
	inline void has_strength_pressure(bool value);
	inline bool has_direction(void);
	inline void has_direction(bool value);
	inline bool has_gravity(void);
	inline void has_gravity(bool value);
	inline bool has_tilt(void);
	inline void has_tilt(bool value);
	inline bool has_dyntopo(void);
	inline void has_dyntopo(bool value);

};

/**************** Image Paint Capabilities ****************/

class BrushCapabilitiesImagePaint : public Pointer {
public:
	BrushCapabilitiesImagePaint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool has_accumulate(void);
	inline void has_accumulate(bool value);
	inline bool has_space_attenuation(void);
	inline void has_space_attenuation(bool value);
	inline bool has_radius(void);
	inline void has_radius(bool value);
	inline bool has_color(void);
	inline void has_color(bool value);

};

/**************** Vertex Paint Capabilities ****************/

class BrushCapabilitiesVertexPaint : public Pointer {
public:
	BrushCapabilitiesVertexPaint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool has_color(void);
	inline void has_color(bool value);

};

/**************** Weight Paint Capabilities ****************/

class BrushCapabilitiesWeightPaint : public Pointer {
public:
	BrushCapabilitiesWeightPaint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool has_weight(void);
	inline void has_weight(bool value);

};

/**************** Grease Pencil Brush Settings ****************/

class BrushGpencilSettings : public Pointer {
public:
	BrushGpencilSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float pen_strength(void);
	inline void pen_strength(float value);
	inline float pen_jitter(void);
	inline void pen_jitter(float value);
	inline float random_pressure(void);
	inline void random_pressure(float value);
	inline float random_strength(void);
	inline void random_strength(float value);
	inline float angle(void);
	inline void angle(float value);
	inline float angle_factor(void);
	inline void angle_factor(float value);
	inline float pen_smooth_factor(void);
	inline void pen_smooth_factor(float value);
	inline int pen_smooth_steps(void);
	inline void pen_smooth_steps(int value);
	inline int pen_subdivision_steps(void);
	inline void pen_subdivision_steps(int value);
	inline float simplify_factor(void);
	inline void simplify_factor(float value);
	inline float simplify_pixel_threshold(void);
	inline void simplify_pixel_threshold(float value);
	inline CurveMapping curve_sensitivity(void);
	inline CurveMapping curve_strength(void);
	inline CurveMapping curve_jitter(void);
	inline CurveMapping curve_random_pressure(void);
	inline CurveMapping curve_random_strength(void);
	inline CurveMapping curve_random_uv(void);
	inline CurveMapping curve_random_hue(void);
	inline CurveMapping curve_random_saturation(void);
	inline CurveMapping curve_random_value(void);
	inline float fill_threshold(void);
	inline void fill_threshold(float value);
	inline float fill_factor(void);
	inline void fill_factor(float value);
	inline int fill_simplify_level(void);
	inline void fill_simplify_level(int value);
	inline float uv_random(void);
	inline void uv_random(float value);
	inline float hardness(void);
	inline void hardness(float value);
	inline Array<float, 2> aspect(void);
	inline void aspect(float values[2]);
	inline int input_samples(void);
	inline void input_samples(int value);
	inline float active_smooth_factor(void);
	inline void active_smooth_factor(float value);
	inline float eraser_strength_factor(void);
	inline void eraser_strength_factor(float value);
	inline float eraser_thickness_factor(void);
	inline void eraser_thickness_factor(float value);
	enum vertex_mode_enum {
		vertex_mode_STROKE = 0,
		vertex_mode_FILL = 1,
		vertex_mode_BOTH = 2,
	};
	inline vertex_mode_enum vertex_mode(void);
	inline void vertex_mode(vertex_mode_enum value);
	inline float vertex_color_factor(void);
	inline void vertex_color_factor(float value);
	inline float random_hue_factor(void);
	inline void random_hue_factor(float value);
	inline float random_saturation_factor(void);
	inline void random_saturation_factor(float value);
	inline float random_value_factor(void);
	inline void random_value_factor(float value);
	inline float extend_stroke_factor(void);
	inline void extend_stroke_factor(float value);
	enum fill_extend_mode_enum {
		fill_extend_mode_EXTEND = 0,
		fill_extend_mode_RADIUS = 1,
	};
	inline fill_extend_mode_enum fill_extend_mode(void);
	inline void fill_extend_mode(fill_extend_mode_enum value);
	inline int dilate(void);
	inline void dilate(int value);
	inline float outline_thickness_factor(void);
	inline void outline_thickness_factor(float value);
	inline bool use_pressure(void);
	inline void use_pressure(bool value);
	inline bool use_strength_pressure(void);
	inline void use_strength_pressure(bool value);
	inline bool use_jitter_pressure(void);
	inline void use_jitter_pressure(bool value);
	inline bool use_stroke_random_hue(void);
	inline void use_stroke_random_hue(bool value);
	inline bool use_stroke_random_sat(void);
	inline void use_stroke_random_sat(bool value);
	inline bool use_stroke_random_val(void);
	inline void use_stroke_random_val(bool value);
	inline bool use_stroke_random_radius(void);
	inline void use_stroke_random_radius(bool value);
	inline bool use_stroke_random_strength(void);
	inline void use_stroke_random_strength(bool value);
	inline bool use_stroke_random_uv(void);
	inline void use_stroke_random_uv(bool value);
	inline bool use_random_press_hue(void);
	inline void use_random_press_hue(bool value);
	inline bool use_random_press_sat(void);
	inline void use_random_press_sat(bool value);
	inline bool use_random_press_val(void);
	inline void use_random_press_val(bool value);
	inline bool use_random_press_radius(void);
	inline void use_random_press_radius(bool value);
	inline bool use_random_press_strength(void);
	inline void use_random_press_strength(bool value);
	inline bool use_random_press_uv(void);
	inline void use_random_press_uv(bool value);
	inline bool use_settings_stabilizer(void);
	inline void use_settings_stabilizer(bool value);
	enum eraser_mode_enum {
		eraser_mode_SOFT = 0,
		eraser_mode_HARD = 1,
		eraser_mode_STROKE = 2,
	};
	inline eraser_mode_enum eraser_mode(void);
	inline void eraser_mode(eraser_mode_enum value);
	enum caps_type_enum {
		caps_type_ROUND = 0,
		caps_type_FLAT = 1,
	};
	inline caps_type_enum caps_type(void);
	inline void caps_type(caps_type_enum value);
	enum fill_draw_mode_enum {
		fill_draw_mode_BOTH = 0,
		fill_draw_mode_STROKE = 1,
		fill_draw_mode_CONTROL = 2,
	};
	inline fill_draw_mode_enum fill_draw_mode(void);
	inline void fill_draw_mode(fill_draw_mode_enum value);
	enum fill_layer_mode_enum {
		fill_layer_mode_VISIBLE = 0,
		fill_layer_mode_ACTIVE = 1,
		fill_layer_mode_ABOVE = 4,
		fill_layer_mode_BELOW = 5,
		fill_layer_mode_ALL_ABOVE = 2,
		fill_layer_mode_ALL_BELOW = 3,
	};
	inline fill_layer_mode_enum fill_layer_mode(void);
	inline void fill_layer_mode(fill_layer_mode_enum value);
	enum fill_direction_enum {
		fill_direction_NORMAL = 0,
		fill_direction_INVERT = 512,
	};
	inline fill_direction_enum fill_direction(void);
	inline void fill_direction(fill_direction_enum value);
	inline bool pin_draw_mode(void);
	inline void pin_draw_mode(bool value);
	enum brush_draw_mode_enum {
		brush_draw_mode_ACTIVE = 0,
		brush_draw_mode_MATERIAL = 1,
		brush_draw_mode_VERTEXCOLOR = 2,
	};
	inline brush_draw_mode_enum brush_draw_mode(void);
	inline void brush_draw_mode(brush_draw_mode_enum value);
	inline bool use_trim(void);
	inline void use_trim(bool value);
	inline bool use_settings_outline(void);
	inline void use_settings_outline(bool value);
	inline bool use_edit_position(void);
	inline void use_edit_position(bool value);
	inline bool use_edit_strength(void);
	inline void use_edit_strength(bool value);
	inline bool use_edit_thickness(void);
	inline void use_edit_thickness(bool value);
	inline bool use_edit_uv(void);
	inline void use_edit_uv(bool value);
	inline Material material(void);
	inline Material material_alt(void);
	inline bool show_fill_boundary(void);
	inline void show_fill_boundary(bool value);
	inline bool show_fill_extend(void);
	inline void show_fill_extend(bool value);
	inline bool use_collide_strokes(void);
	inline void use_collide_strokes(bool value);
	inline bool show_fill(void);
	inline void show_fill(bool value);
	inline bool use_auto_remove_fill_guides(void);
	inline void use_auto_remove_fill_guides(bool value);
	inline bool use_fill_limit(void);
	inline void use_fill_limit(bool value);
	inline bool use_settings_postprocess(void);
	inline void use_settings_postprocess(bool value);
	inline bool use_settings_random(void);
	inline void use_settings_random(bool value);
	inline bool use_material_pin(void);
	inline void use_material_pin(bool value);
	inline bool show_lasso(void);
	inline void show_lasso(bool value);
	inline bool use_occlude_eraser(void);
	inline void use_occlude_eraser(bool value);
	inline bool use_keep_caps_eraser(void);
	inline void use_keep_caps_eraser(bool value);
	inline bool use_active_layer_only(void);
	inline void use_active_layer_only(bool value);

};

/**************** Curves Sculpt Brush Settings ****************/

class BrushCurvesSculptSettings : public Pointer {
public:
	BrushCurvesSculptSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int add_amount(void);
	inline void add_amount(int value);
	inline int points_per_curve(void);
	inline void points_per_curve(int value);
	inline bool use_uniform_scale(void);
	inline void use_uniform_scale(bool value);
	inline float minimum_length(void);
	inline void minimum_length(float value);
	inline bool use_length_interpolate(void);
	inline void use_length_interpolate(bool value);
	inline bool use_radius_interpolate(void);
	inline void use_radius_interpolate(bool value);
	inline bool use_point_count_interpolate(void);
	inline void use_point_count_interpolate(bool value);
	inline bool use_shape_interpolate(void);
	inline void use_shape_interpolate(bool value);
	inline float curve_length(void);
	inline void curve_length(float value);
	inline float minimum_distance(void);
	inline void minimum_distance(float value);
	inline float curve_radius(void);
	inline void curve_radius(float value);
	inline int density_add_attempts(void);
	inline void density_add_attempts(int value);
	enum density_mode_enum {
		density_mode_AUTO = 0,
		density_mode_ADD = 1,
		density_mode_REMOVE = 2,
	};
	inline density_mode_enum density_mode(void);
	inline void density_mode(density_mode_enum value);
	inline CurveMapping curve_parameter_falloff(void);

};

/**************** Brush Texture Slot ****************/

class BrushTextureSlot : public TextureSlot {
public:
	BrushTextureSlot(const PointerRNA &ptr_arg) :
		TextureSlot(ptr_arg)
		{}

	inline float angle(void);
	inline void angle(float value);
	enum map_mode_enum {
		map_mode_VIEW_PLANE = 0,
		map_mode_AREA_PLANE = 3,
		map_mode_TILED = 1,
		map_mode_3D = 2,
		map_mode_RANDOM = 4,
		map_mode_STENCIL = 5,
	};
	inline map_mode_enum map_mode(void);
	inline void map_mode(map_mode_enum value);
	enum mask_map_mode_enum {
		mask_map_mode_VIEW_PLANE = 0,
		mask_map_mode_TILED = 1,
		mask_map_mode_RANDOM = 4,
		mask_map_mode_STENCIL = 5,
	};
	inline mask_map_mode_enum mask_map_mode(void);
	inline void mask_map_mode(mask_map_mode_enum value);
	inline bool use_rake(void);
	inline void use_rake(bool value);
	inline bool use_random(void);
	inline void use_random(bool value);
	inline float random_angle(void);
	inline void random_angle(float value);
	inline bool has_texture_angle_source(void);
	inline void has_texture_angle_source(bool value);
	inline bool has_random_texture_angle(void);
	inline void has_random_texture_angle(bool value);
	inline bool has_texture_angle(void);
	inline void has_texture_angle(bool value);

};

/**************** Operator Stroke Element ****************/

class OperatorStrokeElement : public PropertyGroup {
public:
	OperatorStrokeElement(const PointerRNA &ptr_arg) :
		PropertyGroup(ptr_arg)
		{}


};

/**************** CacheFile ****************/

class CacheFile : public ID {
public:
	CacheFile(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		object_paths(ptr_arg),
		layers(ptr_arg)
		{}

	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline bool is_sequence(void);
	inline void is_sequence(bool value);
	inline bool use_render_procedural(void);
	inline void use_render_procedural(bool value);
	inline bool override_frame(void);
	inline void override_frame(bool value);
	inline float frame(void);
	inline void frame(float value);
	inline float frame_offset(void);
	inline void frame_offset(float value);
	inline bool use_prefetch(void);
	inline void use_prefetch(bool value);
	inline int prefetch_cache_size(void);
	inline void prefetch_cache_size(int value);
	enum forward_axis_enum {
		forward_axis_POS_X = 0,
		forward_axis_POS_Y = 1,
		forward_axis_POS_Z = 2,
		forward_axis_NEG_X = 3,
		forward_axis_NEG_Y = 4,
		forward_axis_NEG_Z = 5,
	};
	inline forward_axis_enum forward_axis(void);
	inline void forward_axis(forward_axis_enum value);
	enum up_axis_enum {
		up_axis_POS_X = 0,
		up_axis_POS_Y = 1,
		up_axis_POS_Z = 2,
		up_axis_NEG_X = 3,
		up_axis_NEG_Y = 4,
		up_axis_NEG_Z = 5,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	inline float scale(void);
	inline void scale(float value);
	COLLECTION_PROPERTY(CacheObjectPaths, CacheObjectPath, CacheFile, object_paths, false, true, true)
	inline std::string velocity_name(void);
	inline void velocity_name(const std::string& value);
	enum velocity_unit_enum {
		velocity_unit_SECOND = 1,
		velocity_unit_FRAME = 0,
	};
	inline velocity_unit_enum velocity_unit(void);
	inline void velocity_unit(velocity_unit_enum value);
	COLLECTION_PROPERTY(CacheFileLayers, CacheFileLayer, CacheFile, layers, false, true, false)
	inline int active_index(void);
	inline void active_index(int value);
	inline AnimData animation_data(void);

};

/**************** Object Path ****************/

class CacheObjectPath : public Pointer {
public:
	CacheObjectPath(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string path(void);
	inline void path(const std::string& value);

};

/**************** Cache Layer ****************/

class CacheFileLayer : public Pointer {
public:
	CacheFileLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline bool hide_layer(void);
	inline void hide_layer(bool value);

};

/**************** Camera ****************/

class Camera : public ID {
public:
	Camera(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		background_images(ptr_arg)
		{}

	enum type_enum {
		type_PERSP = 0,
		type_ORTHO = 1,
		type_PANO = 2,
		type_CUSTOM = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum sensor_fit_enum {
		sensor_fit_AUTO = 0,
		sensor_fit_HORIZONTAL = 1,
		sensor_fit_VERTICAL = 2,
	};
	inline sensor_fit_enum sensor_fit(void);
	inline void sensor_fit(sensor_fit_enum value);
	inline float passepartout_alpha(void);
	inline void passepartout_alpha(float value);
	inline float angle_x(void);
	inline void angle_x(float value);
	inline float angle_y(void);
	inline void angle_y(float value);
	inline float angle(void);
	inline void angle(float value);
	inline float clip_start(void);
	inline void clip_start(float value);
	inline float clip_end(void);
	inline void clip_end(float value);
	inline float lens(void);
	inline void lens(float value);
	inline float sensor_width(void);
	inline void sensor_width(float value);
	inline float sensor_height(void);
	inline void sensor_height(float value);
	inline float ortho_scale(void);
	inline void ortho_scale(float value);
	inline float display_size(void);
	inline void display_size(float value);
	inline float shift_x(void);
	inline void shift_x(float value);
	inline float shift_y(void);
	inline void shift_y(float value);
	inline CameraStereoData stereo(void);
	inline bool show_limits(void);
	inline void show_limits(bool value);
	inline bool show_mist(void);
	inline void show_mist(bool value);
	inline bool show_passepartout(void);
	inline void show_passepartout(bool value);
	inline bool show_safe_areas(void);
	inline void show_safe_areas(bool value);
	inline bool show_safe_center(void);
	inline void show_safe_center(bool value);
	inline bool show_name(void);
	inline void show_name(bool value);
	inline bool show_sensor(void);
	inline void show_sensor(bool value);
	inline bool show_background_images(void);
	inline void show_background_images(bool value);
	enum lens_unit_enum {
		lens_unit_MILLIMETERS = 0,
		lens_unit_FOV = 32,
	};
	inline lens_unit_enum lens_unit(void);
	inline void lens_unit(lens_unit_enum value);
	inline bool show_composition_center(void);
	inline void show_composition_center(bool value);
	inline bool show_composition_center_diagonal(void);
	inline void show_composition_center_diagonal(bool value);
	inline bool show_composition_thirds(void);
	inline void show_composition_thirds(bool value);
	inline bool show_composition_golden(void);
	inline void show_composition_golden(bool value);
	inline bool show_composition_golden_tria_a(void);
	inline void show_composition_golden_tria_a(bool value);
	inline bool show_composition_golden_tria_b(void);
	inline void show_composition_golden_tria_b(bool value);
	inline bool show_composition_harmony_tri_a(void);
	inline void show_composition_harmony_tri_a(bool value);
	inline bool show_composition_harmony_tri_b(void);
	inline void show_composition_harmony_tri_b(bool value);
	enum panorama_type_enum {
		panorama_type_EQUIRECTANGULAR = 0,
		panorama_type_EQUIANGULAR_CUBEMAP_FACE = 5,
		panorama_type_MIRRORBALL = 3,
		panorama_type_FISHEYE_EQUIDISTANT = 1,
		panorama_type_FISHEYE_EQUISOLID = 2,
		panorama_type_FISHEYE_LENS_POLYNOMIAL = 4,
		panorama_type_CENTRAL_CYLINDRICAL = 6,
	};
	inline panorama_type_enum panorama_type(void);
	inline void panorama_type(panorama_type_enum value);
	inline float fisheye_fov(void);
	inline void fisheye_fov(float value);
	inline float fisheye_lens(void);
	inline void fisheye_lens(float value);
	inline float latitude_min(void);
	inline void latitude_min(float value);
	inline float latitude_max(void);
	inline void latitude_max(float value);
	inline float longitude_min(void);
	inline void longitude_min(float value);
	inline float longitude_max(void);
	inline void longitude_max(float value);
	inline float fisheye_polynomial_k0(void);
	inline void fisheye_polynomial_k0(float value);
	inline float fisheye_polynomial_k1(void);
	inline void fisheye_polynomial_k1(float value);
	inline float fisheye_polynomial_k2(void);
	inline void fisheye_polynomial_k2(float value);
	inline float fisheye_polynomial_k3(void);
	inline void fisheye_polynomial_k3(float value);
	inline float fisheye_polynomial_k4(void);
	inline void fisheye_polynomial_k4(float value);
	inline float central_cylindrical_range_u_min(void);
	inline void central_cylindrical_range_u_min(float value);
	inline float central_cylindrical_range_u_max(void);
	inline void central_cylindrical_range_u_max(float value);
	inline float central_cylindrical_range_v_min(void);
	inline void central_cylindrical_range_v_min(float value);
	inline float central_cylindrical_range_v_max(void);
	inline void central_cylindrical_range_v_max(float value);
	inline float central_cylindrical_radius(void);
	inline void central_cylindrical_radius(float value);
	inline std::string custom_filepath(void);
	inline void custom_filepath(const std::string& value);
	inline Text custom_shader(void);
	enum custom_mode_enum {
		custom_mode_INTERNAL = 0,
		custom_mode_EXTERNAL = 1,
	};
	inline custom_mode_enum custom_mode(void);
	inline void custom_mode(custom_mode_enum value);
	inline std::string custom_bytecode(void);
	inline void custom_bytecode(const std::string& value);
	inline std::string custom_bytecode_hash(void);
	inline void custom_bytecode_hash(const std::string& value);
	inline CameraDOFSettings dof(void);
	COLLECTION_PROPERTY(CameraBackgroundImages, CameraBackgroundImage, Camera, background_images, false, true, false)
	inline AnimData animation_data(void);

	inline void view_frame(Scene& scene, float result_1[3], float result_2[3], float result_3[3], float result_4[3]);
};

/**************** Background Image ****************/

class CameraBackgroundImage : public Pointer {
public:
	CameraBackgroundImage(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_override_data(void);
	inline void is_override_data(bool value);
	enum source_enum {
		source_IMAGE = 0,
		source_MOVIE_CLIP = 1,
	};
	inline source_enum source(void);
	inline void source(source_enum value);
	inline Image image(void);
	inline MovieClip clip(void);
	inline ImageUser image_user(void);
	inline MovieClipUser clip_user(void);
	inline Array<float, 2> offset(void);
	inline void offset(float values[2]);
	inline float scale(void);
	inline void scale(float value);
	inline float rotation(void);
	inline void rotation(float value);
	inline bool use_flip_x(void);
	inline void use_flip_x(bool value);
	inline bool use_flip_y(void);
	inline void use_flip_y(bool value);
	inline float alpha(void);
	inline void alpha(float value);
	inline bool show_expanded(void);
	inline void show_expanded(bool value);
	inline bool use_camera_clip(void);
	inline void use_camera_clip(bool value);
	inline bool show_background_image(void);
	inline void show_background_image(bool value);
	inline bool show_on_foreground(void);
	inline void show_on_foreground(bool value);
	enum display_depth_enum {
		display_depth_BACK = 0,
		display_depth_FRONT = 16,
	};
	inline display_depth_enum display_depth(void);
	inline void display_depth(display_depth_enum value);
	enum frame_method_enum {
		frame_method_STRETCH = 0,
		frame_method_FIT = 32,
		frame_method_CROP = 96,
	};
	inline frame_method_enum frame_method(void);
	inline void frame_method(frame_method_enum value);

};

/**************** Stereo ****************/

class CameraStereoData : public Pointer {
public:
	CameraStereoData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum convergence_mode_enum {
		convergence_mode_OFFAXIS = 0,
		convergence_mode_PARALLEL = 1,
		convergence_mode_TOE = 2,
	};
	inline convergence_mode_enum convergence_mode(void);
	inline void convergence_mode(convergence_mode_enum value);
	enum pivot_enum {
		pivot_LEFT = 0,
		pivot_RIGHT = 1,
		pivot_CENTER = 2,
	};
	inline pivot_enum pivot(void);
	inline void pivot(pivot_enum value);
	inline float interocular_distance(void);
	inline void interocular_distance(float value);
	inline float convergence_distance(void);
	inline void convergence_distance(float value);
	inline bool use_spherical_stereo(void);
	inline void use_spherical_stereo(bool value);
	inline bool use_pole_merge(void);
	inline void use_pole_merge(bool value);
	inline float pole_merge_angle_from(void);
	inline void pole_merge_angle_from(float value);
	inline float pole_merge_angle_to(void);
	inline void pole_merge_angle_to(float value);

};

/**************** Depth of Field ****************/

class CameraDOFSettings : public Pointer {
public:
	CameraDOFSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_dof(void);
	inline void use_dof(bool value);
	inline Object focus_object(void);
	inline std::string focus_subtarget(void);
	inline void focus_subtarget(const std::string& value);
	inline float focus_distance(void);
	inline void focus_distance(float value);
	inline float aperture_fstop(void);
	inline void aperture_fstop(float value);
	inline int aperture_blades(void);
	inline void aperture_blades(int value);
	inline float aperture_rotation(void);
	inline void aperture_rotation(float value);
	inline float aperture_ratio(void);
	inline void aperture_ratio(float value);

};

/**************** Solver Result ****************/

class ClothSolverResult : public Pointer {
public:
	ClothSolverResult(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum status_enum {
		status_SUCCESS = 1,
		status_NUMERICAL_ISSUE = 2,
		status_NO_CONVERGENCE = 4,
		status_INVALID_INPUT = 8,
	};
	inline status_enum status(void);
	inline void status(status_enum value);
	inline float max_error(void);
	inline void max_error(float value);
	inline float min_error(void);
	inline void min_error(float value);
	inline float avg_error(void);
	inline void avg_error(float value);
	inline int max_iterations(void);
	inline void max_iterations(int value);
	inline int min_iterations(void);
	inline void min_iterations(int value);
	inline float avg_iterations(void);
	inline void avg_iterations(float value);

};

/**************** Cloth Settings ****************/

class ClothSettings : public Pointer {
public:
	ClothSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float goal_min(void);
	inline void goal_min(float value);
	inline float goal_max(void);
	inline void goal_max(float value);
	inline float goal_default(void);
	inline void goal_default(float value);
	inline float goal_spring(void);
	inline void goal_spring(float value);
	inline float goal_friction(void);
	inline void goal_friction(float value);
	inline float internal_friction(void);
	inline void internal_friction(float value);
	inline float collider_friction(void);
	inline void collider_friction(float value);
	inline float density_target(void);
	inline void density_target(float value);
	inline float density_strength(void);
	inline void density_strength(float value);
	inline float mass(void);
	inline void mass(float value);
	inline std::string vertex_group_mass(void);
	inline void vertex_group_mass(const std::string& value);
	inline Array<float, 3> gravity(void);
	inline void gravity(float values[3]);
	inline float air_damping(void);
	inline void air_damping(float value);
	inline float pin_stiffness(void);
	inline void pin_stiffness(float value);
	inline int quality(void);
	inline void quality(int value);
	inline float time_scale(void);
	inline void time_scale(float value);
	inline std::string vertex_group_shrink(void);
	inline void vertex_group_shrink(const std::string& value);
	inline float shrink_min(void);
	inline void shrink_min(float value);
	inline float shrink_max(void);
	inline void shrink_max(float value);
	inline float voxel_cell_size(void);
	inline void voxel_cell_size(float value);
	inline float tension_damping(void);
	inline void tension_damping(float value);
	inline float compression_damping(void);
	inline void compression_damping(float value);
	inline float shear_damping(void);
	inline void shear_damping(float value);
	inline float tension_stiffness(void);
	inline void tension_stiffness(float value);
	inline float tension_stiffness_max(void);
	inline void tension_stiffness_max(float value);
	inline float compression_stiffness(void);
	inline void compression_stiffness(float value);
	inline float compression_stiffness_max(void);
	inline void compression_stiffness_max(float value);
	inline float shear_stiffness(void);
	inline void shear_stiffness(float value);
	inline float shear_stiffness_max(void);
	inline void shear_stiffness_max(float value);
	inline float sewing_force_max(void);
	inline void sewing_force_max(float value);
	inline std::string vertex_group_structural_stiffness(void);
	inline void vertex_group_structural_stiffness(const std::string& value);
	inline std::string vertex_group_shear_stiffness(void);
	inline void vertex_group_shear_stiffness(const std::string& value);
	inline float bending_stiffness(void);
	inline void bending_stiffness(float value);
	inline float bending_stiffness_max(void);
	inline void bending_stiffness_max(float value);
	inline float bending_damping(void);
	inline void bending_damping(float value);
	inline bool use_sewing_springs(void);
	inline void use_sewing_springs(bool value);
	inline std::string vertex_group_bending(void);
	inline void vertex_group_bending(const std::string& value);
	inline EffectorWeights effector_weights(void);
	inline ShapeKey rest_shape_key(void);
	inline bool use_dynamic_mesh(void);
	inline void use_dynamic_mesh(bool value);
	enum bending_model_enum {
		bending_model_ANGULAR = 1,
		bending_model_LINEAR = 0,
	};
	inline bending_model_enum bending_model(void);
	inline void bending_model(bending_model_enum value);
	inline bool use_internal_springs(void);
	inline void use_internal_springs(bool value);
	inline bool internal_spring_normal_check(void);
	inline void internal_spring_normal_check(bool value);
	inline float internal_spring_max_length(void);
	inline void internal_spring_max_length(float value);
	inline float internal_spring_max_diversion(void);
	inline void internal_spring_max_diversion(float value);
	inline float internal_tension_stiffness(void);
	inline void internal_tension_stiffness(float value);
	inline float internal_tension_stiffness_max(void);
	inline void internal_tension_stiffness_max(float value);
	inline float internal_compression_stiffness(void);
	inline void internal_compression_stiffness(float value);
	inline float internal_compression_stiffness_max(void);
	inline void internal_compression_stiffness_max(float value);
	inline std::string vertex_group_intern(void);
	inline void vertex_group_intern(const std::string& value);
	inline bool use_pressure(void);
	inline void use_pressure(bool value);
	inline bool use_pressure_volume(void);
	inline void use_pressure_volume(bool value);
	inline float uniform_pressure_force(void);
	inline void uniform_pressure_force(float value);
	inline float target_volume(void);
	inline void target_volume(float value);
	inline float pressure_factor(void);
	inline void pressure_factor(float value);
	inline float fluid_density(void);
	inline void fluid_density(float value);
	inline std::string vertex_group_pressure(void);
	inline void vertex_group_pressure(const std::string& value);

};

/**************** Cloth Collision Settings ****************/

class ClothCollisionSettings : public Pointer {
public:
	ClothCollisionSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_collision(void);
	inline void use_collision(bool value);
	inline float distance_min(void);
	inline void distance_min(float value);
	inline float friction(void);
	inline void friction(float value);
	inline float damping(void);
	inline void damping(float value);
	inline int collision_quality(void);
	inline void collision_quality(int value);
	inline float impulse_clamp(void);
	inline void impulse_clamp(float value);
	inline bool use_self_collision(void);
	inline void use_self_collision(bool value);
	inline float self_distance_min(void);
	inline void self_distance_min(float value);
	inline float self_friction(void);
	inline void self_friction(float value);
	inline Collection collection(void);
	inline std::string vertex_group_self_collisions(void);
	inline void vertex_group_self_collisions(const std::string& value);
	inline std::string vertex_group_object_collisions(void);
	inline void vertex_group_object_collisions(const std::string& value);
	inline float self_impulse_clamp(void);
	inline void self_impulse_clamp(float value);

};

/**************** Collection ****************/

class Collection : public ID {
public:
	Collection(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		objects(ptr_arg),
		all_objects(ptr_arg),
		children(ptr_arg),
		collection_objects(ptr_arg),
		collection_children(ptr_arg),
		exporters(ptr_arg)
		{}

	inline Array<float, 3> instance_offset(void);
	inline void instance_offset(float values[3]);
	COLLECTION_PROPERTY(CollectionObjects, Object, Collection, objects, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Object, Collection, all_objects, false, false, false)
	COLLECTION_PROPERTY(CollectionChildren, Collection, Collection, children, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, CollectionObject, Collection, collection_objects, false, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, CollectionChild, Collection, collection_children, false, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, CollectionExport, Collection, exporters, false, true, true)
	inline int active_exporter_index(void);
	inline void active_exporter_index(int value);
	inline bool hide_select(void);
	inline void hide_select(bool value);
	inline bool hide_viewport(void);
	inline void hide_viewport(bool value);
	inline bool hide_render(void);
	inline void hide_render(bool value);
	enum lineart_usage_enum {
		lineart_usage_INCLUDE = 0,
		lineart_usage_OCCLUSION_ONLY = 1,
		lineart_usage_EXCLUDE = 2,
		lineart_usage_INTERSECTION_ONLY = 4,
		lineart_usage_NO_INTERSECTION = 8,
		lineart_usage_FORCE_INTERSECTION = 16,
	};
	inline lineart_usage_enum lineart_usage(void);
	inline void lineart_usage(lineart_usage_enum value);
	inline bool lineart_use_intersection_mask(void);
	inline void lineart_use_intersection_mask(bool value);
	inline Array<bool, 8> lineart_intersection_mask(void);
	inline void lineart_intersection_mask(bool values[8]);
	inline int lineart_intersection_priority(void);
	inline void lineart_intersection_priority(int value);
	inline bool use_lineart_intersection_priority(void);
	inline void use_lineart_intersection_priority(bool value);
	enum color_tag_enum {
		color_tag_NONE = -1,
		color_tag_COLOR_01 = 0,
		color_tag_COLOR_02 = 1,
		color_tag_COLOR_03 = 2,
		color_tag_COLOR_04 = 3,
		color_tag_COLOR_05 = 4,
		color_tag_COLOR_06 = 5,
		color_tag_COLOR_07 = 6,
		color_tag_COLOR_08 = 7,
	};
	inline color_tag_enum color_tag(void);
	inline void color_tag(color_tag_enum value);

};

/**************** Collection Light Linking ****************/

class CollectionLightLinking : public Pointer {
public:
	CollectionLightLinking(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum link_state_enum {
		link_state_INCLUDE = 0,
		link_state_EXCLUDE = 1,
	};
	inline link_state_enum link_state(void);
	inline void link_state(link_state_enum value);

};

/**************** Collection Object ****************/

class CollectionObject : public Pointer {
public:
	CollectionObject(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline CollectionLightLinking light_linking(void);

};

/**************** Collection Child ****************/

class CollectionChild : public Pointer {
public:
	CollectionChild(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline CollectionLightLinking light_linking(void);

};

/**************** Name ****************/

class CollectionExport : public Pointer {
public:
	CollectionExport(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline bool is_open(void);
	inline void is_open(bool value);
	inline PropertyGroup export_properties(void);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);

};

/**************** CurveMapPoint ****************/

class CurveMapPoint : public Pointer {
public:
	CurveMapPoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 2> location(void);
	inline void location(float values[2]);
	enum handle_type_enum {
		handle_type_AUTO = 0,
		handle_type_AUTO_CLAMPED = 4,
		handle_type_VECTOR = 2,
	};
	inline handle_type_enum handle_type(void);
	inline void handle_type(handle_type_enum value);
	inline bool select(void);
	inline void select(bool value);

};

/**************** CurveMap ****************/

class CurveMap : public Pointer {
public:
	CurveMap(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(CurveMapPoints, CurveMapPoint, CurveMap, points, true, true, false)

};

/**************** CurveMapping ****************/

class CurveMapping : public Pointer {
public:
	CurveMapping(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		curves(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum tone_enum {
		tone_STANDARD = 0,
		tone_FILMLIKE = 2,
	};
	inline tone_enum tone(void);
	inline void tone(tone_enum value);
	inline bool use_clip(void);
	inline void use_clip(bool value);
	inline float clip_min_x(void);
	inline void clip_min_x(float value);
	inline float clip_min_y(void);
	inline void clip_min_y(float value);
	inline float clip_max_x(void);
	inline void clip_max_x(float value);
	inline float clip_max_y(void);
	inline void clip_max_y(float value);
	enum extend_enum {
		extend_HORIZONTAL = 0,
		extend_EXTRAPOLATED = 16,
	};
	inline extend_enum extend(void);
	inline void extend(extend_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, CurveMap, CurveMapping, curves, true, false, false)
	inline Array<float, 3> black_level(void);
	inline void black_level(float values[3]);
	inline Array<float, 3> white_level(void);
	inline void white_level(float values[3]);

	inline void update();
	inline void reset_view();
	inline void initialize();
	inline float evaluate(CurveMap& curve, float position);
};

/**************** Color Ramp Element ****************/

class ColorRampElement : public Pointer {
public:
	ColorRampElement(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);
	inline float alpha(void);
	inline void alpha(float value);
	inline float position(void);
	inline void position(float value);

};

/**************** Color Ramp ****************/

class ColorRamp : public Pointer {
public:
	ColorRamp(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		elements(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(ColorRampElements, ColorRampElement, ColorRamp, elements, true, true, false)
	enum interpolation_enum {
		interpolation_EASE = 1,
		interpolation_CARDINAL = 3,
		interpolation_LINEAR = 0,
		interpolation_B_SPLINE = 2,
		interpolation_CONSTANT = 4,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	enum hue_interpolation_enum {
		hue_interpolation_NEAR = 0,
		hue_interpolation_FAR = 1,
		hue_interpolation_CW = 2,
		hue_interpolation_CCW = 3,
	};
	inline hue_interpolation_enum hue_interpolation(void);
	inline void hue_interpolation(hue_interpolation_enum value);
	enum color_mode_enum {
		color_mode_RGB = 0,
		color_mode_HSV = 1,
		color_mode_HSL = 2,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);

	inline void evaluate(float position, float color[4]);
};

/**************** Histogram ****************/

class Histogram : public Pointer {
public:
	Histogram(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum mode_enum {
		mode_LUMA = 0,
		mode_RGB = 1,
		mode_R = 2,
		mode_G = 3,
		mode_B = 4,
		mode_A = 5,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool show_line(void);
	inline void show_line(bool value);

};

/**************** Scopes ****************/

class Scopes : public Pointer {
public:
	Scopes(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_full_resolution(void);
	inline void use_full_resolution(bool value);
	inline float accuracy(void);
	inline void accuracy(float value);
	inline Histogram histogram(void);
	enum waveform_mode_enum {
		waveform_mode_LUMA = 0,
		waveform_mode_PARADE = 1,
		waveform_mode_YCBCR601 = 2,
		waveform_mode_YCBCR709 = 3,
		waveform_mode_YCBCRJPG = 4,
		waveform_mode_RGB = 5,
	};
	inline waveform_mode_enum waveform_mode(void);
	inline void waveform_mode(waveform_mode_enum value);
	inline float waveform_alpha(void);
	inline void waveform_alpha(float value);
	enum vectorscope_mode_enum {
		vectorscope_mode_LUMA = 1,
		vectorscope_mode_RGB = 0,
	};
	inline vectorscope_mode_enum vectorscope_mode(void);
	inline void vectorscope_mode(vectorscope_mode_enum value);
	inline float vectorscope_alpha(void);
	inline void vectorscope_alpha(float value);

};

/**************** ColorManagedDisplaySettings ****************/

class ColorManagedDisplaySettings : public Pointer {
public:
	ColorManagedDisplaySettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum display_device_enum {
		display_device_NONE = 0,
	};
	inline display_device_enum display_device(void);
	inline void display_device(display_device_enum value);

};

/**************** ColorManagedViewSettings ****************/

class ColorManagedViewSettings : public Pointer {
public:
	ColorManagedViewSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum look_enum {
		look_NONE = 0,
	};
	inline look_enum look(void);
	inline void look(look_enum value);
	enum view_transform_enum {
		view_transform_NONE = 0,
	};
	inline view_transform_enum view_transform(void);
	inline void view_transform(view_transform_enum value);
	inline float exposure(void);
	inline void exposure(float value);
	inline float gamma(void);
	inline void gamma(float value);
	inline CurveMapping curve_mapping(void);
	inline bool use_curve_mapping(void);
	inline void use_curve_mapping(bool value);
	inline bool use_white_balance(void);
	inline void use_white_balance(bool value);
	inline float white_balance_temperature(void);
	inline void white_balance_temperature(float value);
	inline float white_balance_tint(void);
	inline void white_balance_tint(float value);
	inline Array<float, 3> white_balance_whitepoint(void);
	inline void white_balance_whitepoint(float values[3]);
	inline bool use_hdr_view(void);
	inline void use_hdr_view(bool value);

};

/**************** ColorManagedInputColorspaceSettings ****************/

class ColorManagedInputColorspaceSettings : public Pointer {
public:
	ColorManagedInputColorspaceSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum name_enum {
		name_NONE = 0,
	};
	inline name_enum name(void);
	inline void name(name_enum value);
	inline bool is_data(void);
	inline void is_data(bool value);

};

/**************** ColorManagedSequencerColorspaceSettings ****************/

class ColorManagedSequencerColorspaceSettings : public Pointer {
public:
	ColorManagedSequencerColorspaceSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum name_enum {
		name_NONE = 0,
	};
	inline name_enum name(void);
	inline void name(name_enum value);

};

/**************** Constraint ****************/

class Constraint : public Pointer {
public:
	Constraint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum type_enum {
		type_CAMERA_SOLVER = 27,
		type_FOLLOW_TRACK = 26,
		type_OBJECT_SOLVER = 28,
		type_COPY_LOCATION = 9,
		type_COPY_ROTATION = 8,
		type_COPY_SCALE = 10,
		type_COPY_TRANSFORMS = 23,
		type_LIMIT_DISTANCE = 14,
		type_LIMIT_LOCATION = 6,
		type_LIMIT_ROTATION = 5,
		type_LIMIT_SCALE = 7,
		type_MAINTAIN_VOLUME = 24,
		type_TRANSFORM = 19,
		type_TRANSFORM_CACHE = 29,
		type_CLAMP_TO = 18,
		type_DAMPED_TRACK = 21,
		type_IK = 3,
		type_LOCKED_TRACK = 13,
		type_SPLINE_IK = 22,
		type_STRETCH_TO = 15,
		type_TRACK_TO = 2,
		type_ACTION = 12,
		type_ARMATURE = 30,
		type_CHILD_OF = 1,
		type_FLOOR = 16,
		type_FOLLOW_PATH = 4,
		type_PIVOT = 25,
		type_SHRINKWRAP = 20,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool is_override_data(void);
	inline void is_override_data(bool value);
	enum owner_space_enum {
		owner_space_WORLD = 0,
		owner_space_CUSTOM = 5,
		owner_space_POSE = 2,
		owner_space_LOCAL_WITH_PARENT = 3,
		owner_space_LOCAL = 1,
	};
	inline owner_space_enum owner_space(void);
	inline void owner_space(owner_space_enum value);
	enum target_space_enum {
		target_space_WORLD = 0,
		target_space_CUSTOM = 5,
		target_space_POSE = 2,
		target_space_LOCAL_WITH_PARENT = 3,
		target_space_LOCAL = 1,
		target_space_LOCAL_OWNER_ORIENT = 6,
	};
	inline target_space_enum target_space(void);
	inline void target_space(target_space_enum value);
	inline Object space_object(void);
	inline std::string space_subtarget(void);
	inline void space_subtarget(const std::string& value);
	inline bool mute(void);
	inline void mute(bool value);
	inline bool enabled(void);
	inline void enabled(bool value);
	inline bool show_expanded(void);
	inline void show_expanded(bool value);
	inline bool is_valid(void);
	inline void is_valid(bool value);
	inline bool active(void);
	inline void active(bool value);
	inline float influence(void);
	inline void influence(float value);
	inline float error_location(void);
	inline void error_location(float value);
	inline float error_rotation(void);
	inline void error_rotation(float value);

};

/**************** Constraint Target ****************/

class ConstraintTarget : public Pointer {
public:
	ConstraintTarget(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);

};

/**************** Constraint Target Bone ****************/

class ConstraintTargetBone : public Pointer {
public:
	ConstraintTargetBone(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline float weight(void);
	inline void weight(float value);

};

/**************** Child Of Constraint ****************/

class ChildOfConstraint : public Constraint {
public:
	ChildOfConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline bool use_location_x(void);
	inline void use_location_x(bool value);
	inline bool use_location_y(void);
	inline void use_location_y(bool value);
	inline bool use_location_z(void);
	inline void use_location_z(bool value);
	inline bool use_rotation_x(void);
	inline void use_rotation_x(bool value);
	inline bool use_rotation_y(void);
	inline void use_rotation_y(bool value);
	inline bool use_rotation_z(void);
	inline void use_rotation_z(bool value);
	inline bool use_scale_x(void);
	inline void use_scale_x(bool value);
	inline bool use_scale_y(void);
	inline void use_scale_y(bool value);
	inline bool use_scale_z(void);
	inline void use_scale_z(bool value);
	inline bool set_inverse_pending(void);
	inline void set_inverse_pending(bool value);
	inline Array<float, 16> inverse_matrix(void);
	inline void inverse_matrix(float values[16]);

};

/**************** Armature Constraint ****************/

class ArmatureConstraint : public Constraint {
public:
	ArmatureConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg),
		targets(ptr_arg)
		{}

	COLLECTION_PROPERTY(ArmatureConstraintTargets, ConstraintTargetBone, ArmatureConstraint, targets, false, true, false)
	inline bool use_deform_preserve_volume(void);
	inline void use_deform_preserve_volume(bool value);
	inline bool use_bone_envelopes(void);
	inline void use_bone_envelopes(bool value);
	inline bool use_current_location(void);
	inline void use_current_location(bool value);

};

/**************** Stretch To Constraint ****************/

class StretchToConstraint : public Constraint {
public:
	StretchToConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline bool use_bbone_shape(void);
	inline void use_bbone_shape(bool value);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	enum volume_enum {
		volume_VOLUME_XZX = 0,
		volume_VOLUME_X = 1,
		volume_VOLUME_Z = 2,
		volume_NO_VOLUME = 3,
	};
	inline volume_enum volume(void);
	inline void volume(volume_enum value);
	enum keep_axis_enum {
		keep_axis_PLANE_X = 0,
		keep_axis_PLANE_Z = 2,
		keep_axis_SWING_Y = 1,
	};
	inline keep_axis_enum keep_axis(void);
	inline void keep_axis(keep_axis_enum value);
	inline float rest_length(void);
	inline void rest_length(float value);
	inline float bulge(void);
	inline void bulge(float value);
	inline bool use_bulge_min(void);
	inline void use_bulge_min(bool value);
	inline bool use_bulge_max(void);
	inline void use_bulge_max(bool value);
	inline float bulge_min(void);
	inline void bulge_min(float value);
	inline float bulge_max(void);
	inline void bulge_max(float value);
	inline float bulge_smooth(void);
	inline void bulge_smooth(float value);

};

/**************** Follow Path Constraint ****************/

class FollowPathConstraint : public Constraint {
public:
	FollowPathConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline float offset(void);
	inline void offset(float value);
	inline float offset_factor(void);
	inline void offset_factor(float value);
	enum forward_axis_enum {
		forward_axis_FORWARD_X = 0,
		forward_axis_FORWARD_Y = 1,
		forward_axis_FORWARD_Z = 2,
		forward_axis_TRACK_NEGATIVE_X = 3,
		forward_axis_TRACK_NEGATIVE_Y = 4,
		forward_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline forward_axis_enum forward_axis(void);
	inline void forward_axis(forward_axis_enum value);
	enum up_axis_enum {
		up_axis_UP_X = 0,
		up_axis_UP_Y = 1,
		up_axis_UP_Z = 2,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	inline bool use_curve_follow(void);
	inline void use_curve_follow(bool value);
	inline bool use_fixed_location(void);
	inline void use_fixed_location(bool value);
	inline bool use_curve_radius(void);
	inline void use_curve_radius(bool value);

};

/**************** Locked Track Constraint ****************/

class LockedTrackConstraint : public Constraint {
public:
	LockedTrackConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline bool use_bbone_shape(void);
	inline void use_bbone_shape(bool value);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	enum track_axis_enum {
		track_axis_TRACK_X = 0,
		track_axis_TRACK_Y = 1,
		track_axis_TRACK_Z = 2,
		track_axis_TRACK_NEGATIVE_X = 3,
		track_axis_TRACK_NEGATIVE_Y = 4,
		track_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);
	enum lock_axis_enum {
		lock_axis_LOCK_X = 0,
		lock_axis_LOCK_Y = 1,
		lock_axis_LOCK_Z = 2,
	};
	inline lock_axis_enum lock_axis(void);
	inline void lock_axis(lock_axis_enum value);

};

/**************** Action Constraint ****************/

class ActionConstraint : public Constraint {
public:
	ActionConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg),
		action_suitable_slots(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	enum mix_mode_enum {
		mix_mode_REPLACE = 6,
		mix_mode_BEFORE_FULL = 3,
		mix_mode_BEFORE = 2,
		mix_mode_BEFORE_SPLIT = 5,
		mix_mode_AFTER_FULL = 0,
		mix_mode_AFTER = 1,
		mix_mode_AFTER_SPLIT = 4,
	};
	inline mix_mode_enum mix_mode(void);
	inline void mix_mode(mix_mode_enum value);
	enum transform_channel_enum {
		transform_channel_LOCATION_X = 20,
		transform_channel_LOCATION_Y = 21,
		transform_channel_LOCATION_Z = 22,
		transform_channel_ROTATION_X = 0,
		transform_channel_ROTATION_Y = 1,
		transform_channel_ROTATION_Z = 2,
		transform_channel_SCALE_X = 10,
		transform_channel_SCALE_Y = 11,
		transform_channel_SCALE_Z = 12,
	};
	inline transform_channel_enum transform_channel(void);
	inline void transform_channel(transform_channel_enum value);
	inline Action action(void);
	inline int action_slot_handle(void);
	inline void action_slot_handle(int value);
	inline std::string last_slot_identifier(void);
	inline void last_slot_identifier(const std::string& value);
	inline ActionSlot action_slot(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ActionSlot, ActionConstraint, action_suitable_slots, false, false, false)
	inline bool use_bone_object_action(void);
	inline void use_bone_object_action(bool value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline float max(void);
	inline void max(float value);
	inline float min(void);
	inline void min(float value);
	inline float eval_time(void);
	inline void eval_time(float value);
	inline bool use_eval_time(void);
	inline void use_eval_time(bool value);

};

/**************** Copy Scale Constraint ****************/

class CopyScaleConstraint : public Constraint {
public:
	CopyScaleConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline bool use_x(void);
	inline void use_x(bool value);
	inline bool use_y(void);
	inline void use_y(bool value);
	inline bool use_z(void);
	inline void use_z(bool value);
	inline float power(void);
	inline void power(float value);
	inline bool use_make_uniform(void);
	inline void use_make_uniform(bool value);
	inline bool use_offset(void);
	inline void use_offset(bool value);
	inline bool use_add(void);
	inline void use_add(bool value);

};

/**************** Maintain Volume Constraint ****************/

class MaintainVolumeConstraint : public Constraint {
public:
	MaintainVolumeConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	enum free_axis_enum {
		free_axis_SAMEVOL_X = 0,
		free_axis_SAMEVOL_Y = 1,
		free_axis_SAMEVOL_Z = 2,
	};
	inline free_axis_enum free_axis(void);
	inline void free_axis(free_axis_enum value);
	enum mode_enum {
		mode_STRICT = 0,
		mode_UNIFORM = 1,
		mode_SINGLE_AXIS = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline float volume(void);
	inline void volume(float value);

};

/**************** Copy Location Constraint ****************/

class CopyLocationConstraint : public Constraint {
public:
	CopyLocationConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline bool use_bbone_shape(void);
	inline void use_bbone_shape(bool value);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline bool use_x(void);
	inline void use_x(bool value);
	inline bool use_y(void);
	inline void use_y(bool value);
	inline bool use_z(void);
	inline void use_z(bool value);
	inline bool invert_x(void);
	inline void invert_x(bool value);
	inline bool invert_y(void);
	inline void invert_y(bool value);
	inline bool invert_z(void);
	inline void invert_z(bool value);
	inline bool use_offset(void);
	inline void use_offset(bool value);

};

/**************** Copy Rotation Constraint ****************/

class CopyRotationConstraint : public Constraint {
public:
	CopyRotationConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline bool use_x(void);
	inline void use_x(bool value);
	inline bool use_y(void);
	inline void use_y(bool value);
	inline bool use_z(void);
	inline void use_z(bool value);
	inline bool invert_x(void);
	inline void invert_x(bool value);
	inline bool invert_y(void);
	inline void invert_y(bool value);
	inline bool invert_z(void);
	inline void invert_z(bool value);
	enum euler_order_enum {
		euler_order_AUTO = 0,
		euler_order_XYZ = 1,
		euler_order_XZY = 2,
		euler_order_YXZ = 3,
		euler_order_YZX = 4,
		euler_order_ZXY = 5,
		euler_order_ZYX = 6,
	};
	inline euler_order_enum euler_order(void);
	inline void euler_order(euler_order_enum value);
	enum mix_mode_enum {
		mix_mode_REPLACE = 0,
		mix_mode_ADD = 2,
		mix_mode_BEFORE = 3,
		mix_mode_AFTER = 4,
		mix_mode_OFFSET = 1,
	};
	inline mix_mode_enum mix_mode(void);
	inline void mix_mode(mix_mode_enum value);
	inline bool use_offset(void);
	inline void use_offset(bool value);

};

/**************** Copy Transforms Constraint ****************/

class CopyTransformsConstraint : public Constraint {
public:
	CopyTransformsConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline bool use_bbone_shape(void);
	inline void use_bbone_shape(bool value);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline bool remove_target_shear(void);
	inline void remove_target_shear(bool value);
	enum mix_mode_enum {
		mix_mode_REPLACE = 0,
		mix_mode_BEFORE_FULL = 5,
		mix_mode_BEFORE = 1,
		mix_mode_BEFORE_SPLIT = 3,
		mix_mode_AFTER_FULL = 6,
		mix_mode_AFTER = 2,
		mix_mode_AFTER_SPLIT = 4,
	};
	inline mix_mode_enum mix_mode(void);
	inline void mix_mode(mix_mode_enum value);

};

/**************** Floor Constraint ****************/

class FloorConstraint : public Constraint {
public:
	FloorConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	enum floor_location_enum {
		floor_location_FLOOR_X = 0,
		floor_location_FLOOR_Y = 1,
		floor_location_FLOOR_Z = 2,
		floor_location_FLOOR_NEGATIVE_X = 3,
		floor_location_FLOOR_NEGATIVE_Y = 4,
		floor_location_FLOOR_NEGATIVE_Z = 5,
	};
	inline floor_location_enum floor_location(void);
	inline void floor_location(floor_location_enum value);
	inline bool use_rotation(void);
	inline void use_rotation(bool value);
	inline float offset(void);
	inline void offset(float value);

};

/**************** Track To Constraint ****************/

class TrackToConstraint : public Constraint {
public:
	TrackToConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline bool use_bbone_shape(void);
	inline void use_bbone_shape(bool value);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	enum track_axis_enum {
		track_axis_TRACK_X = 0,
		track_axis_TRACK_Y = 1,
		track_axis_TRACK_Z = 2,
		track_axis_TRACK_NEGATIVE_X = 3,
		track_axis_TRACK_NEGATIVE_Y = 4,
		track_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);
	enum up_axis_enum {
		up_axis_UP_X = 0,
		up_axis_UP_Y = 1,
		up_axis_UP_Z = 2,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	inline bool use_target_z(void);
	inline void use_target_z(bool value);

};

/**************** Kinematic Constraint ****************/

class KinematicConstraint : public Constraint {
public:
	KinematicConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline int iterations(void);
	inline void iterations(int value);
	inline Object pole_target(void);
	inline std::string pole_subtarget(void);
	inline void pole_subtarget(const std::string& value);
	inline float pole_angle(void);
	inline void pole_angle(float value);
	inline float weight(void);
	inline void weight(float value);
	inline float orient_weight(void);
	inline void orient_weight(float value);
	inline int chain_count(void);
	inline void chain_count(int value);
	inline bool use_tail(void);
	inline void use_tail(bool value);
	enum reference_axis_enum {
		reference_axis_BONE = 0,
		reference_axis_TARGET = 16384,
	};
	inline reference_axis_enum reference_axis(void);
	inline void reference_axis(reference_axis_enum value);
	inline bool use_location(void);
	inline void use_location(bool value);
	inline bool lock_location_x(void);
	inline void lock_location_x(bool value);
	inline bool lock_location_y(void);
	inline void lock_location_y(bool value);
	inline bool lock_location_z(void);
	inline void lock_location_z(bool value);
	inline bool use_rotation(void);
	inline void use_rotation(bool value);
	inline bool lock_rotation_x(void);
	inline void lock_rotation_x(bool value);
	inline bool lock_rotation_y(void);
	inline void lock_rotation_y(bool value);
	inline bool lock_rotation_z(void);
	inline void lock_rotation_z(bool value);
	inline bool use_stretch(void);
	inline void use_stretch(bool value);
	enum ik_type_enum {
		ik_type_COPY_POSE = 0,
		ik_type_DISTANCE = 1,
	};
	inline ik_type_enum ik_type(void);
	inline void ik_type(ik_type_enum value);
	enum limit_mode_enum {
		limit_mode_LIMITDIST_INSIDE = 0,
		limit_mode_LIMITDIST_OUTSIDE = 1,
		limit_mode_LIMITDIST_ONSURFACE = 2,
	};
	inline limit_mode_enum limit_mode(void);
	inline void limit_mode(limit_mode_enum value);
	inline float distance(void);
	inline void distance(float value);

};

/**************** Clamp To Constraint ****************/

class ClampToConstraint : public Constraint {
public:
	ClampToConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	enum main_axis_enum {
		main_axis_CLAMPTO_AUTO = 0,
		main_axis_CLAMPTO_X = 1,
		main_axis_CLAMPTO_Y = 2,
		main_axis_CLAMPTO_Z = 3,
	};
	inline main_axis_enum main_axis(void);
	inline void main_axis(main_axis_enum value);
	inline bool use_cyclic(void);
	inline void use_cyclic(bool value);

};

/**************** Limit Distance Constraint ****************/

class LimitDistanceConstraint : public Constraint {
public:
	LimitDistanceConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline bool use_bbone_shape(void);
	inline void use_bbone_shape(bool value);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline float distance(void);
	inline void distance(float value);
	enum limit_mode_enum {
		limit_mode_LIMITDIST_INSIDE = 0,
		limit_mode_LIMITDIST_OUTSIDE = 1,
		limit_mode_LIMITDIST_ONSURFACE = 2,
	};
	inline limit_mode_enum limit_mode(void);
	inline void limit_mode(limit_mode_enum value);
	inline bool use_transform_limit(void);
	inline void use_transform_limit(bool value);

};

/**************** Limit Size Constraint ****************/

class LimitScaleConstraint : public Constraint {
public:
	LimitScaleConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline bool use_min_x(void);
	inline void use_min_x(bool value);
	inline bool use_min_y(void);
	inline void use_min_y(bool value);
	inline bool use_min_z(void);
	inline void use_min_z(bool value);
	inline bool use_max_x(void);
	inline void use_max_x(bool value);
	inline bool use_max_y(void);
	inline void use_max_y(bool value);
	inline bool use_max_z(void);
	inline void use_max_z(bool value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float min_z(void);
	inline void min_z(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float max_y(void);
	inline void max_y(float value);
	inline float max_z(void);
	inline void max_z(float value);
	inline bool use_transform_limit(void);
	inline void use_transform_limit(bool value);

};

/**************** Limit Rotation Constraint ****************/

class LimitRotationConstraint : public Constraint {
public:
	LimitRotationConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline bool use_limit_x(void);
	inline void use_limit_x(bool value);
	inline bool use_limit_y(void);
	inline void use_limit_y(bool value);
	inline bool use_limit_z(void);
	inline void use_limit_z(bool value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float min_z(void);
	inline void min_z(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float max_y(void);
	inline void max_y(float value);
	inline float max_z(void);
	inline void max_z(float value);
	enum euler_order_enum {
		euler_order_AUTO = 0,
		euler_order_XYZ = 1,
		euler_order_XZY = 2,
		euler_order_YXZ = 3,
		euler_order_YZX = 4,
		euler_order_ZXY = 5,
		euler_order_ZYX = 6,
	};
	inline euler_order_enum euler_order(void);
	inline void euler_order(euler_order_enum value);
	inline bool use_transform_limit(void);
	inline void use_transform_limit(bool value);
	inline bool use_legacy_behavior(void);
	inline void use_legacy_behavior(bool value);

};

/**************** Limit Location Constraint ****************/

class LimitLocationConstraint : public Constraint {
public:
	LimitLocationConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline bool use_min_x(void);
	inline void use_min_x(bool value);
	inline bool use_min_y(void);
	inline void use_min_y(bool value);
	inline bool use_min_z(void);
	inline void use_min_z(bool value);
	inline bool use_max_x(void);
	inline void use_max_x(bool value);
	inline bool use_max_y(void);
	inline void use_max_y(bool value);
	inline bool use_max_z(void);
	inline void use_max_z(bool value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float min_z(void);
	inline void min_z(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float max_y(void);
	inline void max_y(float value);
	inline float max_z(void);
	inline void max_z(float value);
	inline bool use_transform_limit(void);
	inline void use_transform_limit(bool value);

};

/**************** Transformation Constraint ****************/

class TransformConstraint : public Constraint {
public:
	TransformConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	enum map_from_enum {
		map_from_LOCATION = 0,
		map_from_ROTATION = 1,
		map_from_SCALE = 2,
	};
	inline map_from_enum map_from(void);
	inline void map_from(map_from_enum value);
	enum map_to_enum {
		map_to_LOCATION = 0,
		map_to_ROTATION = 1,
		map_to_SCALE = 2,
	};
	inline map_to_enum map_to(void);
	inline void map_to(map_to_enum value);
	enum map_to_x_from_enum {
		map_to_x_from_X = 0,
		map_to_x_from_Y = 1,
		map_to_x_from_Z = 2,
	};
	inline map_to_x_from_enum map_to_x_from(void);
	inline void map_to_x_from(map_to_x_from_enum value);
	enum map_to_y_from_enum {
		map_to_y_from_X = 0,
		map_to_y_from_Y = 1,
		map_to_y_from_Z = 2,
	};
	inline map_to_y_from_enum map_to_y_from(void);
	inline void map_to_y_from(map_to_y_from_enum value);
	enum map_to_z_from_enum {
		map_to_z_from_X = 0,
		map_to_z_from_Y = 1,
		map_to_z_from_Z = 2,
	};
	inline map_to_z_from_enum map_to_z_from(void);
	inline void map_to_z_from(map_to_z_from_enum value);
	inline bool use_motion_extrapolate(void);
	inline void use_motion_extrapolate(bool value);
	enum from_rotation_mode_enum {
		from_rotation_mode_AUTO = 0,
		from_rotation_mode_XYZ = 1,
		from_rotation_mode_XZY = 2,
		from_rotation_mode_YXZ = 3,
		from_rotation_mode_YZX = 4,
		from_rotation_mode_ZXY = 5,
		from_rotation_mode_ZYX = 6,
		from_rotation_mode_QUATERNION = 7,
		from_rotation_mode_SWING_TWIST_X = 8,
		from_rotation_mode_SWING_TWIST_Y = 9,
		from_rotation_mode_SWING_TWIST_Z = 10,
	};
	inline from_rotation_mode_enum from_rotation_mode(void);
	inline void from_rotation_mode(from_rotation_mode_enum value);
	enum to_euler_order_enum {
		to_euler_order_AUTO = 0,
		to_euler_order_XYZ = 1,
		to_euler_order_XZY = 2,
		to_euler_order_YXZ = 3,
		to_euler_order_YZX = 4,
		to_euler_order_ZXY = 5,
		to_euler_order_ZYX = 6,
	};
	inline to_euler_order_enum to_euler_order(void);
	inline void to_euler_order(to_euler_order_enum value);
	inline float from_min_x(void);
	inline void from_min_x(float value);
	inline float from_min_y(void);
	inline void from_min_y(float value);
	inline float from_min_z(void);
	inline void from_min_z(float value);
	inline float from_max_x(void);
	inline void from_max_x(float value);
	inline float from_max_y(void);
	inline void from_max_y(float value);
	inline float from_max_z(void);
	inline void from_max_z(float value);
	inline float to_min_x(void);
	inline void to_min_x(float value);
	inline float to_min_y(void);
	inline void to_min_y(float value);
	inline float to_min_z(void);
	inline void to_min_z(float value);
	inline float to_max_x(void);
	inline void to_max_x(float value);
	inline float to_max_y(void);
	inline void to_max_y(float value);
	inline float to_max_z(void);
	inline void to_max_z(float value);
	enum mix_mode_enum {
		mix_mode_REPLACE = 1,
		mix_mode_ADD = 0,
	};
	inline mix_mode_enum mix_mode(void);
	inline void mix_mode(mix_mode_enum value);
	inline float from_min_x_rot(void);
	inline void from_min_x_rot(float value);
	inline float from_min_y_rot(void);
	inline void from_min_y_rot(float value);
	inline float from_min_z_rot(void);
	inline void from_min_z_rot(float value);
	inline float from_max_x_rot(void);
	inline void from_max_x_rot(float value);
	inline float from_max_y_rot(void);
	inline void from_max_y_rot(float value);
	inline float from_max_z_rot(void);
	inline void from_max_z_rot(float value);
	inline float to_min_x_rot(void);
	inline void to_min_x_rot(float value);
	inline float to_min_y_rot(void);
	inline void to_min_y_rot(float value);
	inline float to_min_z_rot(void);
	inline void to_min_z_rot(float value);
	inline float to_max_x_rot(void);
	inline void to_max_x_rot(float value);
	inline float to_max_y_rot(void);
	inline void to_max_y_rot(float value);
	inline float to_max_z_rot(void);
	inline void to_max_z_rot(float value);
	enum mix_mode_rot_enum {
		mix_mode_rot_REPLACE = 1,
		mix_mode_rot_ADD = 0,
		mix_mode_rot_BEFORE = 2,
		mix_mode_rot_AFTER = 3,
	};
	inline mix_mode_rot_enum mix_mode_rot(void);
	inline void mix_mode_rot(mix_mode_rot_enum value);
	inline float from_min_x_scale(void);
	inline void from_min_x_scale(float value);
	inline float from_min_y_scale(void);
	inline void from_min_y_scale(float value);
	inline float from_min_z_scale(void);
	inline void from_min_z_scale(float value);
	inline float from_max_x_scale(void);
	inline void from_max_x_scale(float value);
	inline float from_max_y_scale(void);
	inline void from_max_y_scale(float value);
	inline float from_max_z_scale(void);
	inline void from_max_z_scale(float value);
	inline float to_min_x_scale(void);
	inline void to_min_x_scale(float value);
	inline float to_min_y_scale(void);
	inline void to_min_y_scale(float value);
	inline float to_min_z_scale(void);
	inline void to_min_z_scale(float value);
	inline float to_max_x_scale(void);
	inline void to_max_x_scale(float value);
	inline float to_max_y_scale(void);
	inline void to_max_y_scale(float value);
	inline float to_max_z_scale(void);
	inline void to_max_z_scale(float value);
	enum mix_mode_scale_enum {
		mix_mode_scale_REPLACE = 0,
		mix_mode_scale_MULTIPLY = 1,
	};
	inline mix_mode_scale_enum mix_mode_scale(void);
	inline void mix_mode_scale(mix_mode_scale_enum value);

};

/**************** Shrinkwrap Constraint ****************/

class ShrinkwrapConstraint : public Constraint {
public:
	ShrinkwrapConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	enum shrinkwrap_type_enum {
		shrinkwrap_type_NEAREST_SURFACE = 0,
		shrinkwrap_type_PROJECT = 1,
		shrinkwrap_type_NEAREST_VERTEX = 2,
		shrinkwrap_type_TARGET_PROJECT = 3,
	};
	inline shrinkwrap_type_enum shrinkwrap_type(void);
	inline void shrinkwrap_type(shrinkwrap_type_enum value);
	enum wrap_mode_enum {
		wrap_mode_ON_SURFACE = 0,
		wrap_mode_INSIDE = 1,
		wrap_mode_OUTSIDE = 2,
		wrap_mode_OUTSIDE_SURFACE = 3,
		wrap_mode_ABOVE_SURFACE = 4,
	};
	inline wrap_mode_enum wrap_mode(void);
	inline void wrap_mode(wrap_mode_enum value);
	inline float distance(void);
	inline void distance(float value);
	enum project_axis_enum {
		project_axis_POS_X = 0,
		project_axis_POS_Y = 1,
		project_axis_POS_Z = 2,
		project_axis_NEG_X = 3,
		project_axis_NEG_Y = 4,
		project_axis_NEG_Z = 5,
	};
	inline project_axis_enum project_axis(void);
	inline void project_axis(project_axis_enum value);
	enum project_axis_space_enum {
		project_axis_space_WORLD = 0,
		project_axis_space_CUSTOM = 5,
		project_axis_space_POSE = 2,
		project_axis_space_LOCAL_WITH_PARENT = 3,
		project_axis_space_LOCAL = 1,
	};
	inline project_axis_space_enum project_axis_space(void);
	inline void project_axis_space(project_axis_space_enum value);
	inline float project_limit(void);
	inline void project_limit(float value);
	inline bool use_project_opposite(void);
	inline void use_project_opposite(bool value);
	enum cull_face_enum {
		cull_face_OFF = 0,
		cull_face_FRONT = 8,
		cull_face_BACK = 16,
	};
	inline cull_face_enum cull_face(void);
	inline void cull_face(cull_face_enum value);
	inline bool use_invert_cull(void);
	inline void use_invert_cull(bool value);
	inline bool use_track_normal(void);
	inline void use_track_normal(bool value);
	enum track_axis_enum {
		track_axis_TRACK_X = 0,
		track_axis_TRACK_Y = 1,
		track_axis_TRACK_Z = 2,
		track_axis_TRACK_NEGATIVE_X = 3,
		track_axis_TRACK_NEGATIVE_Y = 4,
		track_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);

};

/**************** Damped Track Constraint ****************/

class DampedTrackConstraint : public Constraint {
public:
	DampedTrackConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline bool use_bbone_shape(void);
	inline void use_bbone_shape(bool value);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	enum track_axis_enum {
		track_axis_TRACK_X = 0,
		track_axis_TRACK_Y = 1,
		track_axis_TRACK_Z = 2,
		track_axis_TRACK_NEGATIVE_X = 3,
		track_axis_TRACK_NEGATIVE_Y = 4,
		track_axis_TRACK_NEGATIVE_Z = 5,
	};
	inline track_axis_enum track_axis(void);
	inline void track_axis(track_axis_enum value);

};

/**************** Spline IK Constraint ****************/

class SplineIKConstraint : public Constraint {
public:
	SplineIKConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline Object target(void);
	inline int chain_count(void);
	inline void chain_count(int value);
	inline Array<float, 32> joint_bindings(void);
	inline void joint_bindings(float values[32]);
	inline bool use_chain_offset(void);
	inline void use_chain_offset(bool value);
	inline bool use_even_divisions(void);
	inline void use_even_divisions(bool value);
	inline bool use_curve_radius(void);
	inline void use_curve_radius(bool value);
	enum xz_scale_mode_enum {
		xz_scale_mode_NONE = 0,
		xz_scale_mode_BONE_ORIGINAL = 1,
		xz_scale_mode_INVERSE_PRESERVE = 2,
		xz_scale_mode_VOLUME_PRESERVE = 3,
	};
	inline xz_scale_mode_enum xz_scale_mode(void);
	inline void xz_scale_mode(xz_scale_mode_enum value);
	enum y_scale_mode_enum {
		y_scale_mode_NONE = 0,
		y_scale_mode_FIT_CURVE = 1,
		y_scale_mode_BONE_ORIGINAL = 2,
	};
	inline y_scale_mode_enum y_scale_mode(void);
	inline void y_scale_mode(y_scale_mode_enum value);
	inline bool use_original_scale(void);
	inline void use_original_scale(bool value);
	inline float bulge(void);
	inline void bulge(float value);
	inline bool use_bulge_min(void);
	inline void use_bulge_min(bool value);
	inline bool use_bulge_max(void);
	inline void use_bulge_max(bool value);
	inline float bulge_min(void);
	inline void bulge_min(float value);
	inline float bulge_max(void);
	inline void bulge_max(float value);
	inline float bulge_smooth(void);
	inline void bulge_smooth(float value);

};

/**************** Pivot Constraint ****************/

class PivotConstraint : public Constraint {
public:
	PivotConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline float head_tail(void);
	inline void head_tail(float value);
	inline bool use_bbone_shape(void);
	inline void use_bbone_shape(bool value);
	inline Object target(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline bool use_relative_location(void);
	inline void use_relative_location(bool value);
	inline Array<float, 3> offset(void);
	inline void offset(float values[3]);
	enum rotation_range_enum {
		rotation_range_ALWAYS_ACTIVE = -1,
		rotation_range_NX = 0,
		rotation_range_NY = 1,
		rotation_range_NZ = 2,
		rotation_range_X = 3,
		rotation_range_Y = 4,
		rotation_range_Z = 5,
	};
	inline rotation_range_enum rotation_range(void);
	inline void rotation_range(rotation_range_enum value);

};

/**************** Follow Track Constraint ****************/

class FollowTrackConstraint : public Constraint {
public:
	FollowTrackConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline std::string track(void);
	inline void track(const std::string& value);
	inline bool use_active_clip(void);
	inline void use_active_clip(bool value);
	inline bool use_3d_position(void);
	inline void use_3d_position(bool value);
	inline std::string object(void);
	inline void object(const std::string& value);
	inline Object camera(void);
	inline Object depth_object(void);
	enum frame_method_enum {
		frame_method_STRETCH = 0,
		frame_method_FIT = 1,
		frame_method_CROP = 2,
	};
	inline frame_method_enum frame_method(void);
	inline void frame_method(frame_method_enum value);
	inline bool use_undistorted_position(void);
	inline void use_undistorted_position(bool value);

};

/**************** Camera Solver Constraint ****************/

class CameraSolverConstraint : public Constraint {
public:
	CameraSolverConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline bool use_active_clip(void);
	inline void use_active_clip(bool value);

};

/**************** Object Solver Constraint ****************/

class ObjectSolverConstraint : public Constraint {
public:
	ObjectSolverConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline bool use_active_clip(void);
	inline void use_active_clip(bool value);
	inline bool set_inverse_pending(void);
	inline void set_inverse_pending(bool value);
	inline std::string object(void);
	inline void object(const std::string& value);
	inline Object camera(void);

};

/**************** Transform Cache Constraint ****************/

class TransformCacheConstraint : public Constraint {
public:
	TransformCacheConstraint(const PointerRNA &ptr_arg) :
		Constraint(ptr_arg)
		{}

	inline CacheFile cache_file(void);
	inline std::string object_path(void);
	inline void object_path(const std::string& value);

};

/**************** Context ****************/

class Context : public Pointer {
public:
	Context(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline WindowManager window_manager(void);
	inline Window window(void);
	inline WorkSpace workspace(void);
	inline Screen screen(void);
	inline Area area(void);
	inline Space space_data(void);
	inline Region region(void);
	inline Region region_popup(void);
	inline RegionView3D region_data(void);
	inline GizmoGroup gizmo_group(void);
	inline AssetRepresentation asset(void);
	inline BlendData blend_data(void);
	inline Scene scene(void);
	inline ViewLayer view_layer(void);
	inline std::string engine(void);
	inline void engine(const std::string& value);
	inline Collection collection(void);
	inline LayerCollection layer_collection(void);
	inline ToolSettings tool_settings(void);
	inline Preferences preferences(void);
	enum mode_enum {
		mode_EDIT_MESH = 0,
		mode_EDIT_CURVE = 1,
		mode_EDIT_CURVES = 7,
		mode_EDIT_SURFACE = 2,
		mode_EDIT_TEXT = 3,
		mode_EDIT_ARMATURE = 4,
		mode_EDIT_METABALL = 5,
		mode_EDIT_LATTICE = 6,
		mode_EDIT_GREASE_PENCIL = 8,
		mode_EDIT_POINTCLOUD = 9,
		mode_POSE = 10,
		mode_SCULPT = 11,
		mode_PAINT_WEIGHT = 12,
		mode_PAINT_VERTEX = 13,
		mode_PAINT_TEXTURE = 14,
		mode_PARTICLE = 15,
		mode_OBJECT = 16,
		mode_PAINT_GPENCIL = 17,
		mode_EDIT_GPENCIL = 18,
		mode_SCULPT_GPENCIL = 19,
		mode_WEIGHT_GPENCIL = 20,
		mode_VERTEX_GPENCIL = 21,
		mode_SCULPT_CURVES = 22,
		mode_PAINT_GREASE_PENCIL = 23,
		mode_SCULPT_GREASE_PENCIL = 24,
		mode_WEIGHT_GREASE_PENCIL = 25,
		mode_VERTEX_GREASE_PENCIL = 26,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline Depsgraph evaluated_depsgraph_get();
};

/**************** Curve ****************/

class Curve : public ID {
public:
	Curve(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		splines(ptr_arg),
		materials(ptr_arg)
		{}

	inline Key shape_keys(void);
	COLLECTION_PROPERTY(CurveSplines, Spline, Curve, splines, false, false, false)
	inline int path_duration(void);
	inline void path_duration(int value);
	inline bool use_path(void);
	inline void use_path(bool value);
	inline bool use_path_follow(void);
	inline void use_path_follow(bool value);
	inline bool use_path_clamp(void);
	inline void use_path_clamp(bool value);
	inline bool use_stretch(void);
	inline void use_stretch(bool value);
	inline bool use_deform_bounds(void);
	inline void use_deform_bounds(bool value);
	inline bool use_radius(void);
	inline void use_radius(bool value);
	enum bevel_mode_enum {
		bevel_mode_ROUND = 0,
		bevel_mode_OBJECT = 1,
		bevel_mode_PROFILE = 2,
	};
	inline bevel_mode_enum bevel_mode(void);
	inline void bevel_mode(bevel_mode_enum value);
	inline CurveProfile bevel_profile(void);
	inline int bevel_resolution(void);
	inline void bevel_resolution(int value);
	inline float offset(void);
	inline void offset(float value);
	inline float extrude(void);
	inline void extrude(float value);
	inline float bevel_depth(void);
	inline void bevel_depth(float value);
	inline int resolution_u(void);
	inline void resolution_u(int value);
	inline int resolution_v(void);
	inline void resolution_v(int value);
	inline int render_resolution_u(void);
	inline void render_resolution_u(int value);
	inline int render_resolution_v(void);
	inline void render_resolution_v(int value);
	inline float eval_time(void);
	inline void eval_time(float value);
	inline Object bevel_object(void);
	inline Object taper_object(void);
	enum dimensions_enum {
		dimensions_2D = 0,
		dimensions_3D = 1,
	};
	inline dimensions_enum dimensions(void);
	inline void dimensions(dimensions_enum value);
	enum fill_mode_enum {
		fill_mode_FULL = 0,
		fill_mode_BACK = 4,
		fill_mode_FRONT = 2,
		fill_mode_HALF = 6,
	};
	inline fill_mode_enum fill_mode(void);
	inline void fill_mode(fill_mode_enum value);
	enum twist_mode_enum {
		twist_mode_Z_UP = 0,
		twist_mode_MINIMUM = 3,
		twist_mode_TANGENT = 4,
	};
	inline twist_mode_enum twist_mode(void);
	inline void twist_mode(twist_mode_enum value);
	enum taper_radius_mode_enum {
		taper_radius_mode_OVERRIDE = 0,
		taper_radius_mode_MULTIPLY = 1,
		taper_radius_mode_ADD = 2,
	};
	inline taper_radius_mode_enum taper_radius_mode(void);
	inline void taper_radius_mode(taper_radius_mode_enum value);
	enum bevel_factor_mapping_start_enum {
		bevel_factor_mapping_start_RESOLUTION = 0,
		bevel_factor_mapping_start_SEGMENTS = 1,
		bevel_factor_mapping_start_SPLINE = 2,
	};
	inline bevel_factor_mapping_start_enum bevel_factor_mapping_start(void);
	inline void bevel_factor_mapping_start(bevel_factor_mapping_start_enum value);
	enum bevel_factor_mapping_end_enum {
		bevel_factor_mapping_end_RESOLUTION = 0,
		bevel_factor_mapping_end_SEGMENTS = 1,
		bevel_factor_mapping_end_SPLINE = 2,
	};
	inline bevel_factor_mapping_end_enum bevel_factor_mapping_end(void);
	inline void bevel_factor_mapping_end(bevel_factor_mapping_end_enum value);
	inline float twist_smooth(void);
	inline void twist_smooth(float value);
	inline bool use_fill_caps(void);
	inline void use_fill_caps(bool value);
	inline bool use_map_taper(void);
	inline void use_map_taper(bool value);
	inline bool use_auto_texspace(void);
	inline void use_auto_texspace(bool value);
	inline Array<float, 3> texspace_location(void);
	inline void texspace_location(float values[3]);
	inline Array<float, 3> texspace_size(void);
	inline void texspace_size(float values[3]);
	COLLECTION_PROPERTY(IDMaterials, Material, Curve, materials, true, true, true)
	inline float bevel_factor_start(void);
	inline void bevel_factor_start(float value);
	inline float bevel_factor_end(void);
	inline void bevel_factor_end(float value);
	inline bool is_editmode(void);
	inline void is_editmode(bool value);
	inline AnimData animation_data(void);

	inline void transform(float matrix[16], bool shape_keys);
	inline bool validate_material_indices();
	inline void update_gpu_tag();
};

/**************** Surface Curve ****************/

class SurfaceCurve : public Curve {
public:
	SurfaceCurve(const PointerRNA &ptr_arg) :
		Curve(ptr_arg)
		{}


};

/**************** Text Curve ****************/

class TextCurve : public Curve {
public:
	TextCurve(const PointerRNA &ptr_arg) :
		Curve(ptr_arg),
		text_boxes(ptr_arg),
		body_format(ptr_arg)
		{}

	enum align_x_enum {
		align_x_LEFT = 0,
		align_x_CENTER = 1,
		align_x_RIGHT = 2,
		align_x_JUSTIFY = 3,
		align_x_FLUSH = 4,
	};
	inline align_x_enum align_x(void);
	inline void align_x(align_x_enum value);
	enum align_y_enum {
		align_y_TOP = 1,
		align_y_TOP_BASELINE = 0,
		align_y_CENTER = 2,
		align_y_BOTTOM_BASELINE = 3,
		align_y_BOTTOM = 4,
	};
	inline align_y_enum align_y(void);
	inline void align_y(align_y_enum value);
	enum overflow_enum {
		overflow_NONE = 0,
		overflow_SCALE = 1,
		overflow_TRUNCATE = 2,
	};
	inline overflow_enum overflow(void);
	inline void overflow(overflow_enum value);
	inline float size(void);
	inline void size(float value);
	inline float small_caps_scale(void);
	inline void small_caps_scale(float value);
	inline float space_line(void);
	inline void space_line(float value);
	inline float space_word(void);
	inline void space_word(float value);
	inline float space_character(void);
	inline void space_character(float value);
	inline float shear(void);
	inline void shear(float value);
	inline float offset_x(void);
	inline void offset_x(float value);
	inline float offset_y(void);
	inline void offset_y(float value);
	inline float underline_position(void);
	inline void underline_position(float value);
	inline float underline_height(void);
	inline void underline_height(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, TextBox, TextCurve, text_boxes, true, true, false)
	inline int active_textbox(void);
	inline void active_textbox(int value);
	inline std::string family(void);
	inline void family(const std::string& value);
	inline std::string body(void);
	inline void body(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, TextCharacterFormat, TextCurve, body_format, true, true, false)
	inline Object follow_curve(void);
	inline VectorFont font(void);
	inline VectorFont font_bold(void);
	inline VectorFont font_italic(void);
	inline VectorFont font_bold_italic(void);
	inline TextCharacterFormat edit_format(void);
	inline bool use_fast_edit(void);
	inline void use_fast_edit(bool value);
	inline bool is_select_bold(void);
	inline void is_select_bold(bool value);
	inline bool is_select_italic(void);
	inline void is_select_italic(bool value);
	inline bool is_select_underline(void);
	inline void is_select_underline(bool value);
	inline bool is_select_smallcaps(void);
	inline void is_select_smallcaps(bool value);
	inline bool has_selection(void);
	inline void has_selection(bool value);

};

/**************** Text Box ****************/

class TextBox : public Pointer {
public:
	TextBox(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float x(void);
	inline void x(float value);
	inline float y(void);
	inline void y(float value);
	inline float width(void);
	inline void width(float value);
	inline float height(void);
	inline void height(float value);

};

/**************** Text Character Format ****************/

class TextCharacterFormat : public Pointer {
public:
	TextCharacterFormat(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_bold(void);
	inline void use_bold(bool value);
	inline bool use_italic(void);
	inline void use_italic(bool value);
	inline bool use_underline(void);
	inline void use_underline(bool value);
	inline bool use_small_caps(void);
	inline void use_small_caps(bool value);
	inline int material_index(void);
	inline void material_index(int value);
	inline float kerning(void);
	inline void kerning(float value);

};

/**************** SplinePoint ****************/

class SplinePoint : public Pointer {
public:
	SplinePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select(void);
	inline void select(bool value);
	inline bool hide(void);
	inline void hide(bool value);
	inline Array<float, 4> co(void);
	inline void co(float values[4]);
	inline float weight(void);
	inline void weight(float value);
	inline float tilt(void);
	inline void tilt(float value);
	inline float weight_softbody(void);
	inline void weight_softbody(float value);
	inline float radius(void);
	inline void radius(float value);

};

/**************** Bézier Curve Point ****************/

class BezierSplinePoint : public Pointer {
public:
	BezierSplinePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select_left_handle(void);
	inline void select_left_handle(bool value);
	inline bool select_right_handle(void);
	inline void select_right_handle(bool value);
	inline bool select_control_point(void);
	inline void select_control_point(bool value);
	inline bool hide(void);
	inline void hide(bool value);
	enum handle_left_type_enum {
		handle_left_type_FREE = 0,
		handle_left_type_VECTOR = 2,
		handle_left_type_ALIGNED = 3,
		handle_left_type_AUTO = 1,
	};
	inline handle_left_type_enum handle_left_type(void);
	inline void handle_left_type(handle_left_type_enum value);
	enum handle_right_type_enum {
		handle_right_type_FREE = 0,
		handle_right_type_VECTOR = 2,
		handle_right_type_ALIGNED = 3,
		handle_right_type_AUTO = 1,
	};
	inline handle_right_type_enum handle_right_type(void);
	inline void handle_right_type(handle_right_type_enum value);
	inline Array<float, 3> handle_left(void);
	inline void handle_left(float values[3]);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> handle_right(void);
	inline void handle_right(float values[3]);
	inline float tilt(void);
	inline void tilt(float value);
	inline float weight_softbody(void);
	inline void weight_softbody(float value);
	inline float radius(void);
	inline void radius(float value);

};

/**************** Spline ****************/

class Spline : public Pointer {
public:
	Spline(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg),
		bezier_points(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(SplinePoints, SplinePoint, Spline, points, true, true, false)
	COLLECTION_PROPERTY(SplineBezierPoints, BezierSplinePoint, Spline, bezier_points, true, true, false)
	enum tilt_interpolation_enum {
		tilt_interpolation_LINEAR = 0,
		tilt_interpolation_CARDINAL = 1,
		tilt_interpolation_BSPLINE = 2,
		tilt_interpolation_EASE = 3,
	};
	inline tilt_interpolation_enum tilt_interpolation(void);
	inline void tilt_interpolation(tilt_interpolation_enum value);
	enum radius_interpolation_enum {
		radius_interpolation_LINEAR = 0,
		radius_interpolation_CARDINAL = 1,
		radius_interpolation_BSPLINE = 2,
		radius_interpolation_EASE = 3,
	};
	inline radius_interpolation_enum radius_interpolation(void);
	inline void radius_interpolation(radius_interpolation_enum value);
	enum type_enum {
		type_POLY = 0,
		type_BEZIER = 1,
		type_NURBS = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline int point_count_u(void);
	inline void point_count_u(int value);
	inline int point_count_v(void);
	inline void point_count_v(int value);
	inline int order_u(void);
	inline void order_u(int value);
	inline int order_v(void);
	inline void order_v(int value);
	inline int resolution_u(void);
	inline void resolution_u(int value);
	inline int resolution_v(void);
	inline void resolution_v(int value);
	inline bool use_cyclic_u(void);
	inline void use_cyclic_u(bool value);
	inline bool use_cyclic_v(void);
	inline void use_cyclic_v(bool value);
	inline bool use_endpoint_u(void);
	inline void use_endpoint_u(bool value);
	inline bool use_endpoint_v(void);
	inline void use_endpoint_v(bool value);
	inline bool use_bezier_u(void);
	inline void use_bezier_u(bool value);
	inline bool use_bezier_v(void);
	inline void use_bezier_v(bool value);
	inline bool use_smooth(void);
	inline void use_smooth(bool value);
	inline bool hide(void);
	inline void hide(bool value);
	inline int material_index(void);
	inline void material_index(int value);
	inline int character_index(void);
	inline void character_index(int value);

	inline float calc_length(int resolution);
	inline void valid_message(int direction, int *result_len, const char * *result);
};

/**************** Canvas Settings ****************/

class DynamicPaintCanvasSettings : public Pointer {
public:
	DynamicPaintCanvasSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		canvas_surfaces(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DynamicPaintSurfaces, DynamicPaintSurface, DynamicPaintCanvasSettings, canvas_surfaces, false, false, false)

};

/**************** Brush Settings ****************/

class DynamicPaintBrushSettings : public Pointer {
public:
	DynamicPaintBrushSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> paint_color(void);
	inline void paint_color(float values[3]);
	inline float paint_alpha(void);
	inline void paint_alpha(float value);
	inline bool use_absolute_alpha(void);
	inline void use_absolute_alpha(bool value);
	inline float paint_wetness(void);
	inline void paint_wetness(float value);
	inline bool use_paint_erase(void);
	inline void use_paint_erase(bool value);
	enum wave_type_enum {
		wave_type_CHANGE = 3,
		wave_type_DEPTH = 0,
		wave_type_FORCE = 1,
		wave_type_REFLECT = 2,
	};
	inline wave_type_enum wave_type(void);
	inline void wave_type(wave_type_enum value);
	inline float wave_factor(void);
	inline void wave_factor(float value);
	inline float wave_clamp(void);
	inline void wave_clamp(float value);
	inline bool use_smudge(void);
	inline void use_smudge(bool value);
	inline float smudge_strength(void);
	inline void smudge_strength(float value);
	inline float velocity_max(void);
	inline void velocity_max(float value);
	inline bool use_velocity_alpha(void);
	inline void use_velocity_alpha(bool value);
	inline bool use_velocity_depth(void);
	inline void use_velocity_depth(bool value);
	inline bool use_velocity_color(void);
	inline void use_velocity_color(bool value);
	enum paint_source_enum {
		paint_source_PARTICLE_SYSTEM = 3,
		paint_source_POINT = 4,
		paint_source_DISTANCE = 1,
		paint_source_VOLUME_DISTANCE = 2,
		paint_source_VOLUME = 0,
	};
	inline paint_source_enum paint_source(void);
	inline void paint_source(paint_source_enum value);
	inline float paint_distance(void);
	inline void paint_distance(float value);
	inline bool use_proximity_ramp_alpha(void);
	inline void use_proximity_ramp_alpha(bool value);
	enum proximity_falloff_enum {
		proximity_falloff_SMOOTH = 1,
		proximity_falloff_CONSTANT = 0,
		proximity_falloff_RAMP = 2,
	};
	inline proximity_falloff_enum proximity_falloff(void);
	inline void proximity_falloff(proximity_falloff_enum value);
	inline bool use_proximity_project(void);
	inline void use_proximity_project(bool value);
	enum ray_direction_enum {
		ray_direction_CANVAS = 0,
		ray_direction_BRUSH = 1,
		ray_direction_Z_AXIS = 2,
	};
	inline ray_direction_enum ray_direction(void);
	inline void ray_direction(ray_direction_enum value);
	inline bool invert_proximity(void);
	inline void invert_proximity(bool value);
	inline bool use_negative_volume(void);
	inline void use_negative_volume(bool value);
	inline ParticleSystem particle_system(void);
	inline bool use_particle_radius(void);
	inline void use_particle_radius(bool value);
	inline float solid_radius(void);
	inline void solid_radius(float value);
	inline float smooth_radius(void);
	inline void smooth_radius(float value);
	inline ColorRamp paint_ramp(void);
	inline ColorRamp velocity_ramp(void);

};

/**************** Paint Surface ****************/

class DynamicPaintSurface : public Pointer {
public:
	DynamicPaintSurface(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum surface_format_enum {
		surface_format_VERTEX = 1,
		surface_format_IMAGE = 2,
	};
	inline surface_format_enum surface_format(void);
	inline void surface_format(surface_format_enum value);
	enum surface_type_enum {
		surface_type_PAINT = 0,
	};
	inline surface_type_enum surface_type(void);
	inline void surface_type(surface_type_enum value);
	inline bool is_active(void);
	inline void is_active(bool value);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline Collection brush_collection(void);
	inline bool use_dissolve(void);
	inline void use_dissolve(bool value);
	inline int dissolve_speed(void);
	inline void dissolve_speed(int value);
	inline bool use_drying(void);
	inline void use_drying(bool value);
	inline int dry_speed(void);
	inline void dry_speed(int value);
	inline int image_resolution(void);
	inline void image_resolution(int value);
	inline std::string uv_layer(void);
	inline void uv_layer(const std::string& value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline int frame_substeps(void);
	inline void frame_substeps(int value);
	inline bool use_antialiasing(void);
	inline void use_antialiasing(bool value);
	inline float brush_influence_scale(void);
	inline void brush_influence_scale(float value);
	inline float brush_radius_scale(void);
	inline void brush_radius_scale(float value);
	enum init_color_type_enum {
		init_color_type_NONE = 0,
		init_color_type_COLOR = 1,
		init_color_type_TEXTURE = 2,
		init_color_type_VERTEX_COLOR = 3,
	};
	inline init_color_type_enum init_color_type(void);
	inline void init_color_type(init_color_type_enum value);
	inline Array<float, 4> init_color(void);
	inline void init_color(float values[4]);
	inline Texture init_texture(void);
	inline std::string init_layername(void);
	inline void init_layername(const std::string& value);
	enum effect_ui_enum {
		effect_ui_SPREAD = 1,
		effect_ui_DRIP = 2,
		effect_ui_SHRINK = 3,
	};
	inline effect_ui_enum effect_ui(void);
	inline void effect_ui(effect_ui_enum value);
	inline bool use_dry_log(void);
	inline void use_dry_log(bool value);
	inline bool use_dissolve_log(void);
	inline void use_dissolve_log(bool value);
	inline bool use_spread(void);
	inline void use_spread(bool value);
	inline float spread_speed(void);
	inline void spread_speed(float value);
	inline float color_dry_threshold(void);
	inline void color_dry_threshold(float value);
	inline float color_spread_speed(void);
	inline void color_spread_speed(float value);
	inline bool use_drip(void);
	inline void use_drip(bool value);
	inline bool use_shrink(void);
	inline void use_shrink(bool value);
	inline float shrink_speed(void);
	inline void shrink_speed(float value);
	inline EffectorWeights effector_weights(void);
	inline float drip_velocity(void);
	inline void drip_velocity(float value);
	inline float drip_acceleration(void);
	inline void drip_acceleration(float value);
	inline bool use_premultiply(void);
	inline void use_premultiply(bool value);
	inline std::string image_output_path(void);
	inline void image_output_path(const std::string& value);
	inline std::string output_name_a(void);
	inline void output_name_a(const std::string& value);
	inline bool use_output_a(void);
	inline void use_output_a(bool value);
	inline std::string output_name_b(void);
	inline void output_name_b(const std::string& value);
	inline bool use_output_b(void);
	inline void use_output_b(bool value);
	inline float depth_clamp(void);
	inline void depth_clamp(float value);
	inline float displace_factor(void);
	inline void displace_factor(float value);
	enum image_fileformat_enum {
		image_fileformat_PNG = 0,
		image_fileformat_OPENEXR = 1,
	};
	inline image_fileformat_enum image_fileformat(void);
	inline void image_fileformat(image_fileformat_enum value);
	enum displace_type_enum {
		displace_type_DISPLACE = 0,
		displace_type_DEPTH = 1,
	};
	inline displace_type_enum displace_type(void);
	inline void displace_type(displace_type_enum value);
	inline bool use_incremental_displace(void);
	inline void use_incremental_displace(bool value);
	inline float wave_damping(void);
	inline void wave_damping(float value);
	inline float wave_speed(void);
	inline void wave_speed(float value);
	inline float wave_timescale(void);
	inline void wave_timescale(float value);
	inline float wave_spring(void);
	inline void wave_spring(float value);
	inline float wave_smoothness(void);
	inline void wave_smoothness(float value);
	inline bool use_wave_open_border(void);
	inline void use_wave_open_border(bool value);
	inline PointCache point_cache(void);
	inline bool is_cache_user(void);
	inline void is_cache_user(bool value);

	inline bool output_exists(Object& object, int index);
};

/**************** F-Curve ****************/

class FCurve : public Pointer {
public:
	FCurve(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		sampled_points(ptr_arg),
		keyframe_points(ptr_arg),
		modifiers(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum extrapolation_enum {
		extrapolation_CONSTANT = 0,
		extrapolation_LINEAR = 1,
	};
	inline extrapolation_enum extrapolation(void);
	inline void extrapolation(extrapolation_enum value);
	inline Driver driver(void);
	inline ActionGroup group(void);
	inline std::string data_path(void);
	inline void data_path(const std::string& value);
	inline int array_index(void);
	inline void array_index(int value);
	enum color_mode_enum {
		color_mode_AUTO_RAINBOW = 0,
		color_mode_AUTO_RGB = 1,
		color_mode_AUTO_YRGB = 3,
		color_mode_CUSTOM = 2,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline bool select(void);
	inline void select(bool value);
	inline bool lock(void);
	inline void lock(bool value);
	inline bool mute(void);
	inline void mute(bool value);
	inline bool hide(void);
	inline void hide(bool value);
	enum auto_smoothing_enum {
		auto_smoothing_NONE = 0,
		auto_smoothing_CONT_ACCEL = 1,
	};
	inline auto_smoothing_enum auto_smoothing(void);
	inline void auto_smoothing(auto_smoothing_enum value);
	inline bool is_valid(void);
	inline void is_valid(bool value);
	inline bool is_empty(void);
	inline void is_empty(bool value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FCurveSample, FCurve, sampled_points, true, true, false)
	COLLECTION_PROPERTY(FCurveKeyframePoints, Keyframe, FCurve, keyframe_points, true, true, false)
	COLLECTION_PROPERTY(FCurveModifiers, FModifier, FCurve, modifiers, false, true, true)

	inline float evaluate(float frame);
	inline void update(void *main);
	inline void range(float range[2]);
	inline void update_autoflags(Context C, AnyType& data);
	inline void convert_to_samples(int start, int end);
	inline void convert_to_keyframes(int start, int end);
	inline void bake(int start, int end, float step, int remove);
};

/**************** Keyframe ****************/

class Keyframe : public Pointer {
public:
	Keyframe(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select_left_handle(void);
	inline void select_left_handle(bool value);
	inline bool select_right_handle(void);
	inline void select_right_handle(bool value);
	inline bool select_control_point(void);
	inline void select_control_point(bool value);
	enum handle_left_type_enum {
		handle_left_type_FREE = 0,
		handle_left_type_ALIGNED = 3,
		handle_left_type_VECTOR = 2,
		handle_left_type_AUTO = 1,
		handle_left_type_AUTO_CLAMPED = 4,
	};
	inline handle_left_type_enum handle_left_type(void);
	inline void handle_left_type(handle_left_type_enum value);
	enum handle_right_type_enum {
		handle_right_type_FREE = 0,
		handle_right_type_ALIGNED = 3,
		handle_right_type_VECTOR = 2,
		handle_right_type_AUTO = 1,
		handle_right_type_AUTO_CLAMPED = 4,
	};
	inline handle_right_type_enum handle_right_type(void);
	inline void handle_right_type(handle_right_type_enum value);
	enum interpolation_enum {
		interpolation_CONSTANT = 0,
		interpolation_LINEAR = 1,
		interpolation_BEZIER = 2,
		interpolation_SINE = 12,
		interpolation_QUAD = 9,
		interpolation_CUBIC = 6,
		interpolation_QUART = 10,
		interpolation_QUINT = 11,
		interpolation_EXPO = 8,
		interpolation_CIRC = 5,
		interpolation_BACK = 3,
		interpolation_BOUNCE = 4,
		interpolation_ELASTIC = 7,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	enum type_enum {
		type_KEYFRAME = 0,
		type_BREAKDOWN = 2,
		type_MOVING_HOLD = 4,
		type_EXTREME = 1,
		type_JITTER = 3,
		type_GENERATED = 5,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum easing_enum {
		easing_AUTO = 0,
		easing_EASE_IN = 1,
		easing_EASE_OUT = 2,
		easing_EASE_IN_OUT = 3,
	};
	inline easing_enum easing(void);
	inline void easing(easing_enum value);
	inline float back(void);
	inline void back(float value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float period(void);
	inline void period(float value);
	inline Array<float, 2> handle_left(void);
	inline void handle_left(float values[2]);
	inline Array<float, 2> co(void);
	inline void co(float values[2]);
	inline Array<float, 2> co_ui(void);
	inline void co_ui(float values[2]);
	inline Array<float, 2> handle_right(void);
	inline void handle_right(float values[2]);

};

/**************** F-Curve Sample ****************/

class FCurveSample : public Pointer {
public:
	FCurveSample(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select(void);
	inline void select(bool value);
	inline Array<float, 2> co(void);
	inline void co(float values[2]);

};

/**************** Driver Target ****************/

class DriverTarget : public Pointer {
public:
	DriverTarget(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline ID id(void);
	enum id_type_enum {
		id_type_ACTION = 17217,
		id_type_ARMATURE = 21057,
		id_type_BRUSH = 21058,
		id_type_CACHEFILE = 17987,
		id_type_CAMERA = 16707,
		id_type_COLLECTION = 21063,
		id_type_CURVE = 21827,
		id_type_CURVES = 22083,
		id_type_FONT = 18006,
		id_type_GREASEPENCIL = 17479,
		id_type_GREASEPENCIL_V3 = 20551,
		id_type_IMAGE = 19785,
		id_type_KEY = 17739,
		id_type_LATTICE = 21580,
		id_type_LIBRARY = 18764,
		id_type_LIGHT = 16716,
		id_type_LIGHT_PROBE = 20556,
		id_type_LINESTYLE = 21324,
		id_type_MASK = 21325,
		id_type_MATERIAL = 16717,
		id_type_MESH = 17741,
		id_type_META = 16973,
		id_type_MOVIECLIP = 17229,
		id_type_NODETREE = 21582,
		id_type_OBJECT = 16975,
		id_type_PAINTCURVE = 17232,
		id_type_PALETTE = 19536,
		id_type_PARTICLE = 16720,
		id_type_POINTCLOUD = 21584,
		id_type_SCENE = 17235,
		id_type_SCREEN = 21075,
		id_type_SOUND = 20307,
		id_type_SPEAKER = 19283,
		id_type_TEXT = 22612,
		id_type_TEXTURE = 17748,
		id_type_VOLUME = 20310,
		id_type_WINDOWMANAGER = 19799,
		id_type_WORKSPACE = 21335,
		id_type_WORLD = 20311,
	};
	inline id_type_enum id_type(void);
	inline void id_type(id_type_enum value);
	inline std::string data_path(void);
	inline void data_path(const std::string& value);
	inline std::string bone_target(void);
	inline void bone_target(const std::string& value);
	enum transform_type_enum {
		transform_type_LOC_X = 0,
		transform_type_LOC_Y = 1,
		transform_type_LOC_Z = 2,
		transform_type_ROT_X = 3,
		transform_type_ROT_Y = 4,
		transform_type_ROT_Z = 5,
		transform_type_ROT_W = 10,
		transform_type_SCALE_X = 6,
		transform_type_SCALE_Y = 7,
		transform_type_SCALE_Z = 8,
		transform_type_SCALE_AVG = 9,
	};
	inline transform_type_enum transform_type(void);
	inline void transform_type(transform_type_enum value);
	enum rotation_mode_enum {
		rotation_mode_AUTO = 0,
		rotation_mode_XYZ = 1,
		rotation_mode_XZY = 2,
		rotation_mode_YXZ = 3,
		rotation_mode_YZX = 4,
		rotation_mode_ZXY = 5,
		rotation_mode_ZYX = 6,
		rotation_mode_QUATERNION = 7,
		rotation_mode_SWING_TWIST_X = 8,
		rotation_mode_SWING_TWIST_Y = 9,
		rotation_mode_SWING_TWIST_Z = 10,
	};
	inline rotation_mode_enum rotation_mode(void);
	inline void rotation_mode(rotation_mode_enum value);
	enum transform_space_enum {
		transform_space_WORLD_SPACE = 0,
		transform_space_TRANSFORM_SPACE = 4,
		transform_space_LOCAL_SPACE = 12,
	};
	inline transform_space_enum transform_space(void);
	inline void transform_space(transform_space_enum value);
	enum context_property_enum {
		context_property_ACTIVE_SCENE = 0,
		context_property_ACTIVE_VIEW_LAYER = 1,
	};
	inline context_property_enum context_property(void);
	inline void context_property(context_property_enum value);
	inline bool use_fallback_value(void);
	inline void use_fallback_value(bool value);
	inline float fallback_value(void);
	inline void fallback_value(float value);
	inline bool is_fallback_used(void);
	inline void is_fallback_used(bool value);

};

/**************** Driver Variable ****************/

class DriverVariable : public Pointer {
public:
	DriverVariable(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		targets(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum type_enum {
		type_SINGLE_PROP = 0,
		type_TRANSFORMS = 3,
		type_ROTATION_DIFF = 1,
		type_LOC_DIFF = 2,
		type_CONTEXT_PROP = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, DriverTarget, DriverVariable, targets, true, true, false)
	inline bool is_name_valid(void);
	inline void is_name_valid(bool value);

};

/**************** Driver ****************/

class Driver : public Pointer {
public:
	Driver(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		variables(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_AVERAGE = 0,
		type_SUM = 2,
		type_SCRIPTED = 1,
		type_MIN = 3,
		type_MAX = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline std::string expression(void);
	inline void expression(const std::string& value);
	COLLECTION_PROPERTY(ChannelDriverVariables, DriverVariable, Driver, variables, false, true, true)
	inline bool use_self(void);
	inline void use_self(bool value);
	inline bool is_valid(void);
	inline void is_valid(bool value);
	inline bool is_simple_expression(void);
	inline void is_simple_expression(bool value);

};

/**************** F-Modifier ****************/

class FModifier : public Pointer {
public:
	FModifier(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum type_enum {
		type_NULL = 0,
		type_GENERATOR = 1,
		type_FNGENERATOR = 2,
		type_ENVELOPE = 3,
		type_CYCLES = 4,
		type_NOISE = 5,
		type_LIMITS = 8,
		type_STEPPED = 9,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_expanded(void);
	inline void show_expanded(bool value);
	inline bool mute(void);
	inline void mute(bool value);
	inline bool is_valid(void);
	inline void is_valid(bool value);
	inline bool active(void);
	inline void active(bool value);
	inline bool use_restricted_range(void);
	inline void use_restricted_range(bool value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);
	inline float blend_in(void);
	inline void blend_in(float value);
	inline float blend_out(void);
	inline void blend_out(float value);
	inline bool use_influence(void);
	inline void use_influence(bool value);
	inline float influence(void);
	inline void influence(float value);

};

/**************** Generator F-Modifier ****************/

class FModifierGenerator : public FModifier {
public:
	FModifierGenerator(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	inline bool use_additive(void);
	inline void use_additive(bool value);
	enum mode_enum {
		mode_POLYNOMIAL = 0,
		mode_POLYNOMIAL_FACTORISED = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline int poly_order(void);
	inline void poly_order(int value);
	inline Array<float, 32> coefficients(void);
	inline void coefficients(float values[32]);

};

/**************** Built-In Function F-Modifier ****************/

class FModifierFunctionGenerator : public FModifier {
public:
	FModifierFunctionGenerator(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	inline float amplitude(void);
	inline void amplitude(float value);
	inline float phase_multiplier(void);
	inline void phase_multiplier(float value);
	inline float phase_offset(void);
	inline void phase_offset(float value);
	inline float value_offset(void);
	inline void value_offset(float value);
	inline bool use_additive(void);
	inline void use_additive(bool value);
	enum function_type_enum {
		function_type_SIN = 0,
		function_type_COS = 1,
		function_type_TAN = 2,
		function_type_SQRT = 3,
		function_type_LN = 4,
		function_type_SINC = 5,
	};
	inline function_type_enum function_type(void);
	inline void function_type(function_type_enum value);

};

/**************** Envelope F-Modifier ****************/

class FModifierEnvelope : public FModifier {
public:
	FModifierEnvelope(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg),
		control_points(ptr_arg)
		{}

	COLLECTION_PROPERTY(FModifierEnvelopeControlPoints, FModifierEnvelopeControlPoint, FModifierEnvelope, control_points, true, true, false)
	inline float reference_value(void);
	inline void reference_value(float value);
	inline float default_min(void);
	inline void default_min(float value);
	inline float default_max(void);
	inline void default_max(float value);

};

/**************** Envelope Control Point ****************/

class FModifierEnvelopeControlPoint : public Pointer {
public:
	FModifierEnvelopeControlPoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float min(void);
	inline void min(float value);
	inline float max(void);
	inline void max(float value);
	inline float frame(void);
	inline void frame(float value);

};

/**************** Cycles F-Modifier ****************/

class FModifierCycles : public FModifier {
public:
	FModifierCycles(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	enum mode_before_enum {
		mode_before_NONE = 0,
		mode_before_REPEAT = 1,
		mode_before_REPEAT_OFFSET = 2,
		mode_before_MIRROR = 3,
	};
	inline mode_before_enum mode_before(void);
	inline void mode_before(mode_before_enum value);
	inline int cycles_before(void);
	inline void cycles_before(int value);
	enum mode_after_enum {
		mode_after_NONE = 0,
		mode_after_REPEAT = 1,
		mode_after_REPEAT_OFFSET = 2,
		mode_after_MIRROR = 3,
	};
	inline mode_after_enum mode_after(void);
	inline void mode_after(mode_after_enum value);
	inline int cycles_after(void);
	inline void cycles_after(int value);

};

/**************** Limit F-Modifier ****************/

class FModifierLimits : public FModifier {
public:
	FModifierLimits(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	inline bool use_min_x(void);
	inline void use_min_x(bool value);
	inline bool use_min_y(void);
	inline void use_min_y(bool value);
	inline bool use_max_x(void);
	inline void use_max_x(bool value);
	inline bool use_max_y(void);
	inline void use_max_y(bool value);
	inline float min_x(void);
	inline void min_x(float value);
	inline float min_y(void);
	inline void min_y(float value);
	inline float max_x(void);
	inline void max_x(float value);
	inline float max_y(void);
	inline void max_y(float value);

};

/**************** Noise F-Modifier ****************/

class FModifierNoise : public FModifier {
public:
	FModifierNoise(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	enum blend_type_enum {
		blend_type_REPLACE = 0,
		blend_type_ADD = 1,
		blend_type_SUBTRACT = 2,
		blend_type_MULTIPLY = 3,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline float scale(void);
	inline void scale(float value);
	inline float strength(void);
	inline void strength(float value);
	inline float phase(void);
	inline void phase(float value);
	inline float offset(void);
	inline void offset(float value);
	inline float lacunarity(void);
	inline void lacunarity(float value);
	inline float roughness(void);
	inline void roughness(float value);
	inline int depth(void);
	inline void depth(int value);
	inline bool use_legacy_noise(void);
	inline void use_legacy_noise(bool value);

};

/**************** Stepped Interpolation F-Modifier ****************/

class FModifierStepped : public FModifier {
public:
	FModifierStepped(const PointerRNA &ptr_arg) :
		FModifier(ptr_arg)
		{}

	inline float frame_step(void);
	inline void frame_step(float value);
	inline float frame_offset(void);
	inline void frame_offset(float value);
	inline bool use_frame_start(void);
	inline void use_frame_start(bool value);
	inline bool use_frame_end(void);
	inline void use_frame_end(bool value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);

};

/**************** Annotation ****************/

class GreasePencil : public ID {
public:
	GreasePencil(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		layers(ptr_arg)
		{}

	COLLECTION_PROPERTY(GreasePencilLayers, GPencilLayer, GreasePencil, layers, false, true, true)
	inline AnimData animation_data(void);

};

/**************** Annotation Layer ****************/

class GPencilLayer : public Pointer {
public:
	GPencilLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		frames(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string info(void);
	inline void info(const std::string& value);
	COLLECTION_PROPERTY(GPencilFrames, GPencilFrame, GPencilLayer, frames, false, true, false)
	inline GPencilFrame active_frame(void);
	inline float annotation_opacity(void);
	inline void annotation_opacity(float value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline int thickness(void);
	inline void thickness(int value);
	inline bool use_annotation_onion_skinning(void);
	inline void use_annotation_onion_skinning(bool value);
	inline int annotation_onion_before_range(void);
	inline void annotation_onion_before_range(int value);
	inline int annotation_onion_after_range(void);
	inline void annotation_onion_after_range(int value);
	inline Array<float, 3> annotation_onion_before_color(void);
	inline void annotation_onion_before_color(float values[3]);
	inline Array<float, 3> annotation_onion_after_color(void);
	inline void annotation_onion_after_color(float values[3]);
	inline bool annotation_onion_use_custom_color(void);
	inline void annotation_onion_use_custom_color(bool value);
	inline bool annotation_hide(void);
	inline void annotation_hide(bool value);
	inline bool lock(void);
	inline void lock(bool value);
	inline bool lock_frame(void);
	inline void lock_frame(bool value);
	inline bool is_ruler(void);
	inline void is_ruler(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool show_in_front(void);
	inline void show_in_front(bool value);

};

/**************** Annotation Frame ****************/

class GPencilFrame : public Pointer {
public:
	GPencilFrame(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		strokes(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, GPencilStroke, GPencilFrame, strokes, false, true, false)
	inline int frame_number(void);
	inline void frame_number(int value);
	inline bool select(void);
	inline void select(bool value);

};

/**************** Annotation Stroke ****************/

class GPencilStroke : public Pointer {
public:
	GPencilStroke(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, GPencilStrokePoint, GPencilStroke, points, true, true, false)

};

/**************** Annotation Stroke Point ****************/

class GPencilStrokePoint : public Pointer {
public:
	GPencilStrokePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);

};

/**************** Grease Pencil ****************/

class GreasePencilv3 : public ID {
public:
	GreasePencilv3(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		attributes(ptr_arg),
		color_attributes(ptr_arg),
		materials(ptr_arg),
		layers(ptr_arg),
		layer_groups(ptr_arg)
		{}

	COLLECTION_PROPERTY(AttributeGroupGreasePencil, Attribute, GreasePencilv3, attributes, true, false, true)
	COLLECTION_PROPERTY(AttributeGroupGreasePencil, Attribute, GreasePencilv3, color_attributes, true, false, false)
	inline AnimData animation_data(void);
	COLLECTION_PROPERTY(IDMaterials, Material, GreasePencilv3, materials, true, true, true)
	COLLECTION_PROPERTY(GreasePencilv3Layers, GreasePencilLayer, GreasePencilv3, layers, true, false, false)
	COLLECTION_PROPERTY(GreasePencilv3LayerGroup, GreasePencilLayerGroup, GreasePencilv3, layer_groups, true, false, false)
	inline bool use_autolock_layers(void);
	inline void use_autolock_layers(bool value);
	enum stroke_depth_order_enum {
		stroke_depth_order_2D = 0,
		stroke_depth_order_3D = 4,
	};
	inline stroke_depth_order_enum stroke_depth_order(void);
	inline void stroke_depth_order(stroke_depth_order_enum value);
	inline int ghost_before_range(void);
	inline void ghost_before_range(int value);
	inline int ghost_after_range(void);
	inline void ghost_after_range(int value);
	inline bool use_ghost_custom_colors(void);
	inline void use_ghost_custom_colors(bool value);
	inline Array<float, 3> before_color(void);
	inline void before_color(float values[3]);
	inline Array<float, 3> after_color(void);
	inline void after_color(float values[3]);
	enum onion_mode_enum {
		onion_mode_ABSOLUTE = 0,
		onion_mode_RELATIVE = 1,
		onion_mode_SELECTED = 2,
	};
	inline onion_mode_enum onion_mode(void);
	inline void onion_mode(onion_mode_enum value);
	enum onion_keyframe_type_enum {
		onion_keyframe_type_ALL = 31,
		onion_keyframe_type_KEYFRAME = 1,
		onion_keyframe_type_BREAKDOWN = 4,
		onion_keyframe_type_MOVING_HOLD = 16,
		onion_keyframe_type_EXTREME = 2,
		onion_keyframe_type_JITTER = 8,
		onion_keyframe_type_GENERATED = 5,
	};
	inline onion_keyframe_type_enum onion_keyframe_type(void);
	inline void onion_keyframe_type(onion_keyframe_type_enum value);
	inline bool use_onion_fade(void);
	inline void use_onion_fade(bool value);
	inline bool use_onion_loop(void);
	inline void use_onion_loop(bool value);
	inline float onion_factor(void);
	inline void onion_factor(float value);

};

/**************** Tree Node ****************/

class GreasePencilTreeNode : public Pointer {
public:
	GreasePencilTreeNode(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline bool hide(void);
	inline void hide(bool value);
	inline bool lock(void);
	inline void lock(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool use_onion_skinning(void);
	inline void use_onion_skinning(bool value);
	inline bool use_masks(void);
	inline void use_masks(bool value);
	inline Array<float, 3> channel_color(void);
	inline void channel_color(float values[3]);
	inline GreasePencilTreeNode next_node(void);
	inline GreasePencilTreeNode prev_node(void);
	inline GreasePencilLayerGroup parent_group(void);

};

/**************** Grease Pencil Layer ****************/

class GreasePencilLayer : public GreasePencilTreeNode {
public:
	GreasePencilLayer(const PointerRNA &ptr_arg) :
		GreasePencilTreeNode(ptr_arg),
		frames(ptr_arg),
		mask_layers(ptr_arg)
		{}

	COLLECTION_PROPERTY(GreasePencilFrames, GreasePencilFrame, GreasePencilLayer, frames, true, true, false)
	COLLECTION_PROPERTY(GreasePencilLayerMasks, GreasePencilLayerMask, GreasePencilLayer, mask_layers, false, true, true)
	inline bool lock_frame(void);
	inline void lock_frame(bool value);
	inline float opacity(void);
	inline void opacity(float value);
	inline Array<float, 3> tint_color(void);
	inline void tint_color(float values[3]);
	inline float tint_factor(void);
	inline void tint_factor(float value);
	inline float radius_offset(void);
	inline void radius_offset(float value);
	inline bool use_lights(void);
	inline void use_lights(bool value);
	inline int pass_index(void);
	inline void pass_index(int value);
	inline Object parent(void);
	inline std::string parent_bone(void);
	inline void parent_bone(const std::string& value);
	inline Array<float, 3> translation(void);
	inline void translation(float values[3]);
	inline Array<float, 3> rotation(void);
	inline void rotation(float values[3]);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline std::string viewlayer_render(void);
	inline void viewlayer_render(const std::string& value);
	inline bool use_viewlayer_masks(void);
	inline void use_viewlayer_masks(bool value);
	enum blend_mode_enum {
		blend_mode_REGULAR = 0,
		blend_mode_HARDLIGHT = 1,
		blend_mode_ADD = 2,
		blend_mode_SUBTRACT = 3,
		blend_mode_MULTIPLY = 4,
		blend_mode_DIVIDE = 5,
	};
	inline blend_mode_enum blend_mode(void);
	inline void blend_mode(blend_mode_enum value);
	inline bool ignore_locked_materials(void);
	inline void ignore_locked_materials(bool value);
	inline Array<float, 16> matrix_local(void);
	inline void matrix_local(float values[16]);
	inline Array<float, 16> matrix_parent_inverse(void);
	inline void matrix_parent_inverse(float values[16]);

	inline GreasePencilFrame get_frame_at(int frame_number);
	inline GreasePencilFrame current_frame(Context C);
};

/**************** Grease Pencil Masking Layers ****************/

class GreasePencilLayerMask : public Pointer {
public:
	GreasePencilLayerMask(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline bool hide(void);
	inline void hide(bool value);
	inline bool invert(void);
	inline void invert(bool value);

};

/**************** Grease Pencil Layer Group ****************/

class GreasePencilLayerGroup : public GreasePencilTreeNode {
public:
	GreasePencilLayerGroup(const PointerRNA &ptr_arg) :
		GreasePencilTreeNode(ptr_arg)
		{}

	inline bool is_expanded(void);
	inline void is_expanded(bool value);
	enum color_tag_enum {
		color_tag_NONE = -1,
		color_tag_COLOR1 = 0,
		color_tag_COLOR2 = 1,
		color_tag_COLOR3 = 2,
		color_tag_COLOR4 = 3,
		color_tag_COLOR5 = 4,
		color_tag_COLOR6 = 5,
		color_tag_COLOR7 = 6,
		color_tag_COLOR8 = 7,
	};
	inline color_tag_enum color_tag(void);
	inline void color_tag(color_tag_enum value);

};

/**************** Grease Pencil Frame ****************/

class GreasePencilFrame : public Pointer {
public:
	GreasePencilFrame(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline GreasePencilDrawing drawing(void);
	inline int frame_number(void);
	inline void frame_number(int value);
	inline bool select(void);
	inline void select(bool value);
	enum keyframe_type_enum {
		keyframe_type_KEYFRAME = 0,
		keyframe_type_BREAKDOWN = 2,
		keyframe_type_MOVING_HOLD = 4,
		keyframe_type_EXTREME = 1,
		keyframe_type_JITTER = 3,
		keyframe_type_GENERATED = 5,
	};
	inline keyframe_type_enum keyframe_type(void);
	inline void keyframe_type(keyframe_type_enum value);

};

/**************** Grease Pencil Drawing ****************/

class GreasePencilDrawing : public Pointer {
public:
	GreasePencilDrawing(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		curve_offsets(ptr_arg),
		attributes(ptr_arg),
		color_attributes(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_DRAWING = 0,
		type_REFERENCE = 1,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline int user_count(void);
	inline void user_count(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, IntAttributeValue, GreasePencilDrawing, curve_offsets, true, true, false)
	COLLECTION_PROPERTY(AttributeGroupGreasePencilDrawing, Attribute, GreasePencilDrawing, attributes, true, false, true)
	COLLECTION_PROPERTY(AttributeGroupGreasePencilDrawing, Attribute, GreasePencilDrawing, color_attributes, true, false, false)

	inline void add_strokes(int sizes_len, int *sizes);
	inline void remove_strokes(int indices_len, int *indices);
	inline void resize_strokes(int sizes_len, int *sizes, int indices_len, int *indices);
	inline void reorder_strokes(int new_indices_len, int *new_indices);
	inline void set_types(int type, int indices_len, int *indices);
	inline void tag_positions_changed();
	inline void vertex_group_assign(const char * vgroup_name, int indices_ptr_len, int *indices_ptr, float weight);
	inline void vertex_group_remove(const char * vgroup_name, int indices_ptr_len, int *indices_ptr);
	inline void set_vertex_weights(const char * vertex_group_name, int indices_len, int *indices, int weights_len, float *weights, int assign_mode);
};

/**************** Curve Point ****************/

class CurvePoint : public Pointer {
public:
	CurvePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> position(void);
	inline void position(float values[3]);
	inline float radius(void);
	inline void radius(float value);
	inline int index(void);
	inline void index(int value);

};

/**************** Curve Slice ****************/

class CurveSlice : public Pointer {
public:
	CurveSlice(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		points(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, CurvePoint, CurveSlice, points, true, false, false)
	inline int first_point_index(void);
	inline void first_point_index(int value);
	inline int points_length(void);
	inline void points_length(int value);
	inline int index(void);
	inline void index(int value);

};

/**************** Hair Curves ****************/

class Curves : public ID {
public:
	Curves(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		curves(ptr_arg),
		points(ptr_arg),
		position_data(ptr_arg),
		curve_offset_data(ptr_arg),
		normals(ptr_arg),
		materials(ptr_arg),
		attributes(ptr_arg),
		color_attributes(ptr_arg)
		{}

	COLLECTION_PROPERTY(DefaultCollectionFunctions, CurveSlice, Curves, curves, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, CurvePoint, Curves, points, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FloatVectorAttributeValue, Curves, position_data, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, IntAttributeValue, Curves, curve_offset_data, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FloatVectorValueReadOnly, Curves, normals, true, false, false)
	COLLECTION_PROPERTY(IDMaterials, Material, Curves, materials, true, true, true)
	inline Object surface(void);
	inline std::string surface_uv_map(void);
	inline void surface_uv_map(const std::string& value);
	inline bool use_mirror_x(void);
	inline void use_mirror_x(bool value);
	inline bool use_mirror_y(void);
	inline void use_mirror_y(bool value);
	inline bool use_mirror_z(void);
	inline void use_mirror_z(bool value);
	enum selection_domain_enum {
		selection_domain_POINT = 0,
		selection_domain_CURVE = 4,
	};
	inline selection_domain_enum selection_domain(void);
	inline void selection_domain(selection_domain_enum value);
	inline bool use_sculpt_collision(void);
	inline void use_sculpt_collision(bool value);
	inline float surface_collision_distance(void);
	inline void surface_collision_distance(float value);
	COLLECTION_PROPERTY(AttributeGroupCurves, Attribute, Curves, attributes, true, false, true)
	COLLECTION_PROPERTY(AttributeGroupCurves, Attribute, Curves, color_attributes, true, false, false)
	inline AnimData animation_data(void);

	inline void add_curves(int sizes_len, int *sizes);
	inline void remove_curves(int indices_len, int *indices);
	inline void resize_curves(int sizes_len, int *sizes, int indices_len, int *indices);
	inline void reorder_curves(int new_indices_len, int *new_indices);
	inline void set_types(int type, int indices_len, int *indices);
	inline const char * unit_test_compare(Curves& curves, float threshold);
};

/**************** Read-Only Vector ****************/

class FloatVectorValueReadOnly : public Pointer {
public:
	FloatVectorValueReadOnly(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> vector(void);
	inline void vector(float values[3]);

};

/**************** Render Slot ****************/

class RenderSlot : public Pointer {
public:
	RenderSlot(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);

	inline void clear(ImageUser& iuser);
};

/**************** UDIM Tile ****************/

class UDIMTile : public Pointer {
public:
	UDIMTile(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string label(void);
	inline void label(const std::string& value);
	inline int number(void);
	inline void number(int value);
	inline Array<int, 2> size(void);
	inline void size(int values[2]);
	inline int channels(void);
	inline void channels(int value);
	enum generated_type_enum {
		generated_type_BLANK = 0,
		generated_type_UV_GRID = 1,
		generated_type_COLOR_GRID = 2,
	};
	inline generated_type_enum generated_type(void);
	inline void generated_type(generated_type_enum value);
	inline int generated_width(void);
	inline void generated_width(int value);
	inline int generated_height(void);
	inline void generated_height(int value);
	inline bool use_generated_float(void);
	inline void use_generated_float(bool value);
	inline bool is_generated_tile(void);
	inline void is_generated_tile(bool value);
	inline Array<float, 4> generated_color(void);
	inline void generated_color(float values[4]);

};

/**************** Image ****************/

class Image : public ID {
public:
	Image(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		packed_files(ptr_arg),
		render_slots(ptr_arg),
		tiles(ptr_arg)
		{}

	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline std::string filepath_raw(void);
	inline void filepath_raw(const std::string& value);
	enum file_format_enum {
		file_format_BMP = 20,
		file_format_IRIS = 1,
		file_format_PNG = 17,
		file_format_JPEG = 4,
		file_format_JPEG2000 = 30,
		file_format_TARGA = 0,
		file_format_TARGA_RAW = 14,
		file_format_CINEON = 26,
		file_format_DPX = 27,
		file_format_OPEN_EXR_MULTILAYER = 28,
		file_format_OPEN_EXR = 23,
		file_format_HDR = 21,
		file_format_TIFF = 22,
		file_format_WEBP = 35,
		file_format_FFMPEG = 24,
	};
	inline file_format_enum file_format(void);
	inline void file_format(file_format_enum value);
	enum source_enum {
		source_FILE = 1,
		source_SEQUENCE = 2,
		source_MOVIE = 3,
		source_GENERATED = 4,
		source_VIEWER = 5,
		source_TILED = 6,
	};
	inline source_enum source(void);
	inline void source(source_enum value);
	enum type_enum {
		type_IMAGE = 0,
		type_MULTILAYER = 1,
		type_UV_TEST = 2,
		type_RENDER_RESULT = 4,
		type_COMPOSITING = 5,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline PackedFile packed_file(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ImagePackedFile, Image, packed_files, false, true, true)
	inline bool use_view_as_render(void);
	inline void use_view_as_render(bool value);
	inline bool use_deinterlace(void);
	inline void use_deinterlace(bool value);
	inline bool use_multiview(void);
	inline void use_multiview(bool value);
	inline bool is_stereo_3d(void);
	inline void is_stereo_3d(bool value);
	inline bool is_multiview(void);
	inline void is_multiview(bool value);
	inline bool is_dirty(void);
	inline void is_dirty(bool value);
	enum generated_type_enum {
		generated_type_BLANK = 0,
		generated_type_UV_GRID = 1,
		generated_type_COLOR_GRID = 2,
	};
	inline generated_type_enum generated_type(void);
	inline void generated_type(generated_type_enum value);
	inline int generated_width(void);
	inline void generated_width(int value);
	inline int generated_height(void);
	inline void generated_height(int value);
	inline bool use_generated_float(void);
	inline void use_generated_float(bool value);
	inline Array<float, 4> generated_color(void);
	inline void generated_color(float values[4]);
	inline Array<float, 2> display_aspect(void);
	inline void display_aspect(float values[2]);
	inline int bindcode(void);
	inline void bindcode(int value);
	COLLECTION_PROPERTY(RenderSlots, RenderSlot, Image, render_slots, false, true, false)
	COLLECTION_PROPERTY(UDIMTiles, UDIMTile, Image, tiles, false, true, false)
	inline bool has_data(void);
	inline void has_data(bool value);
	inline int depth(void);
	inline void depth(int value);
	inline Array<int, 2> size(void);
	inline void size(int values[2]);
	inline Array<float, 2> resolution(void);
	inline void resolution(float values[2]);
	inline int frame_duration(void);
	inline void frame_duration(int value);
	inline DynamicArray<float> pixels(void);
	inline void pixels(float values[]);
	inline int channels(void);
	inline void channels(int value);
	inline bool is_float(void);
	inline void is_float(bool value);
	inline ColorManagedInputColorspaceSettings colorspace_settings(void);
	enum alpha_mode_enum {
		alpha_mode_STRAIGHT = 0,
		alpha_mode_PREMUL = 1,
		alpha_mode_CHANNEL_PACKED = 2,
		alpha_mode_NONE = 3,
	};
	inline alpha_mode_enum alpha_mode(void);
	inline void alpha_mode(alpha_mode_enum value);
	inline bool use_half_precision(void);
	inline void use_half_precision(bool value);
	inline int seam_margin(void);
	inline void seam_margin(int value);
	enum views_format_enum {
		views_format_INDIVIDUAL = 0,
		views_format_STEREO_3D = 1,
	};
	inline views_format_enum views_format(void);
	inline void views_format(views_format_enum value);
	inline Stereo3dFormat stereo_3d_format(void);

	inline void save_render(Context C, const char * filepath, Scene& scene, int quality);
	inline void save(void *main, Context C, const char * filepath, int quality, bool save_copy);
	inline void pack(void *main, Context C, const char * data, int data_len);
	inline void unpack(void *main, int method);
	inline void reload(void *main);
	inline void update();
	inline void scale(int width, int height, int frame, int tile_index);
	inline int gl_touch(int frame, int layer_index, int pass_index);
	inline int gl_load(int frame, int layer_index, int pass_index);
	inline void gl_free();
	inline void filepath_from_user(ImageUser& image_user, char * filepath);
	inline void buffers_free();
};

/**************** Image User ****************/

class ImageUser : public Pointer {
public:
	ImageUser(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_auto_refresh(void);
	inline void use_auto_refresh(bool value);
	inline int frame_current(void);
	inline void frame_current(int value);
	inline bool use_cyclic(void);
	inline void use_cyclic(bool value);
	inline int frame_duration(void);
	inline void frame_duration(int value);
	inline int frame_offset(void);
	inline void frame_offset(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int multilayer_layer(void);
	inline void multilayer_layer(int value);
	inline int multilayer_pass(void);
	inline void multilayer_pass(int value);
	inline int multilayer_view(void);
	inline void multilayer_view(int value);
	inline int tile(void);
	inline void tile(int value);

};

/**************** ImagePackedFile ****************/

class ImagePackedFile : public Pointer {
public:
	ImagePackedFile(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline PackedFile packed_file(void);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline int view(void);
	inline void view(int value);
	inline int tile_number(void);
	inline void tile_number(int value);

	inline void save(void *main);
};

/**************** Key ****************/

class Key : public ID {
public:
	Key(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		key_blocks(ptr_arg)
		{}

	inline ShapeKey reference_key(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ShapeKey, Key, key_blocks, false, true, true)
	inline AnimData animation_data(void);
	inline ID user(void);
	inline bool use_relative(void);
	inline void use_relative(bool value);
	inline float eval_time(void);
	inline void eval_time(float value);

};

/**************** Shape Key ****************/

class ShapeKey : public Pointer {
public:
	ShapeKey(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg),
		points(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline float frame(void);
	inline void frame(float value);
	inline float value(void);
	inline void value(float value);
	enum interpolation_enum {
		interpolation_KEY_LINEAR = 0,
		interpolation_KEY_CARDINAL = 1,
		interpolation_KEY_CATMULL_ROM = 3,
		interpolation_KEY_BSPLINE = 2,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline ShapeKey relative_key(void);
	inline bool mute(void);
	inline void mute(bool value);
	inline bool lock_shape(void);
	inline void lock_shape(bool value);
	inline float slider_min(void);
	inline void slider_min(float value);
	inline float slider_max(void);
	inline void slider_max(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, UnknownType, ShapeKey, data, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ShapeKeyPoint, ShapeKey, points, true, true, false)

	inline void normals_vertex_get(int *normals_len, float **normals);
	inline void normals_polygon_get(int *normals_len, float **normals);
	inline void normals_split_get(int *normals_len, float **normals);
};

/**************** Shape Key Point ****************/

class ShapeKeyPoint : public Pointer {
public:
	ShapeKeyPoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);

};

/**************** Shape Key Curve Point ****************/

class ShapeKeyCurvePoint : public Pointer {
public:
	ShapeKeyCurvePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline float tilt(void);
	inline void tilt(float value);
	inline float radius(void);
	inline void radius(float value);

};

/**************** Shape Key Bézier Point ****************/

class ShapeKeyBezierPoint : public Pointer {
public:
	ShapeKeyBezierPoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> handle_left(void);
	inline void handle_left(float values[3]);
	inline Array<float, 3> handle_right(void);
	inline void handle_right(float values[3]);
	inline float tilt(void);
	inline void tilt(float value);
	inline float radius(void);
	inline void radius(float value);

};

/**************** Light ****************/

class Light : public ID {
public:
	Light(const PointerRNA &ptr_arg) :
		ID(ptr_arg)
		{}

	enum type_enum {
		type_POINT = 0,
		type_SUN = 1,
		type_SPOT = 2,
		type_AREA = 4,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use_temperature(void);
	inline void use_temperature(bool value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline float temperature(void);
	inline void temperature(float value);
	inline Array<float, 3> temperature_color(void);
	inline void temperature_color(float values[3]);
	inline float specular_factor(void);
	inline void specular_factor(float value);
	inline float diffuse_factor(void);
	inline void diffuse_factor(float value);
	inline float transmission_factor(void);
	inline void transmission_factor(float value);
	inline float volume_factor(void);
	inline void volume_factor(float value);
	inline bool use_custom_distance(void);
	inline void use_custom_distance(bool value);
	inline float cutoff_distance(void);
	inline void cutoff_distance(float value);
	inline bool use_shadow(void);
	inline void use_shadow(bool value);
	inline float exposure(void);
	inline void exposure(float value);
	inline bool normalize(void);
	inline void normalize(bool value);
	inline NodeTree node_tree(void);
	inline bool use_nodes(void);
	inline void use_nodes(bool value);
	inline AnimData animation_data(void);

	inline float area(float matrix_world[16]);
};

/**************** Point Light ****************/

class PointLight : public Light {
public:
	PointLight(const PointerRNA &ptr_arg) :
		Light(ptr_arg)
		{}

	inline bool use_soft_falloff(void);
	inline void use_soft_falloff(bool value);
	inline float energy(void);
	inline void energy(float value);
	inline float shadow_buffer_clip_start(void);
	inline void shadow_buffer_clip_start(float value);
	inline float shadow_soft_size(void);
	inline void shadow_soft_size(float value);
	inline float shadow_filter_radius(void);
	inline void shadow_filter_radius(float value);
	inline float shadow_maximum_resolution(void);
	inline void shadow_maximum_resolution(float value);
	inline bool use_shadow_jitter(void);
	inline void use_shadow_jitter(bool value);
	inline float shadow_jitter_overblur(void);
	inline void shadow_jitter_overblur(float value);
	inline bool use_absolute_resolution(void);
	inline void use_absolute_resolution(bool value);

};

/**************** Area Light ****************/

class AreaLight : public Light {
public:
	AreaLight(const PointerRNA &ptr_arg) :
		Light(ptr_arg)
		{}

	inline float energy(void);
	inline void energy(float value);
	inline float shadow_buffer_clip_start(void);
	inline void shadow_buffer_clip_start(float value);
	inline float shadow_soft_size(void);
	inline void shadow_soft_size(float value);
	inline float shadow_filter_radius(void);
	inline void shadow_filter_radius(float value);
	inline float shadow_maximum_resolution(void);
	inline void shadow_maximum_resolution(float value);
	inline bool use_shadow_jitter(void);
	inline void use_shadow_jitter(bool value);
	inline float shadow_jitter_overblur(void);
	inline void shadow_jitter_overblur(float value);
	inline bool use_absolute_resolution(void);
	inline void use_absolute_resolution(bool value);
	enum shape_enum {
		shape_SQUARE = 0,
		shape_RECTANGLE = 1,
		shape_DISK = 4,
		shape_ELLIPSE = 5,
	};
	inline shape_enum shape(void);
	inline void shape(shape_enum value);
	inline float size(void);
	inline void size(float value);
	inline float size_y(void);
	inline void size_y(float value);
	inline float spread(void);
	inline void spread(float value);

};

/**************** Spot Light ****************/

class SpotLight : public Light {
public:
	SpotLight(const PointerRNA &ptr_arg) :
		Light(ptr_arg)
		{}

	inline float energy(void);
	inline void energy(float value);
	inline float shadow_buffer_clip_start(void);
	inline void shadow_buffer_clip_start(float value);
	inline float shadow_soft_size(void);
	inline void shadow_soft_size(float value);
	inline float shadow_filter_radius(void);
	inline void shadow_filter_radius(float value);
	inline float shadow_maximum_resolution(void);
	inline void shadow_maximum_resolution(float value);
	inline bool use_shadow_jitter(void);
	inline void use_shadow_jitter(bool value);
	inline float shadow_jitter_overblur(void);
	inline void shadow_jitter_overblur(float value);
	inline bool use_absolute_resolution(void);
	inline void use_absolute_resolution(bool value);
	inline bool use_square(void);
	inline void use_square(bool value);
	inline float spot_blend(void);
	inline void spot_blend(float value);
	inline float spot_size(void);
	inline void spot_size(float value);
	inline bool show_cone(void);
	inline void show_cone(bool value);
	inline bool use_soft_falloff(void);
	inline void use_soft_falloff(bool value);

};

/**************** Sun Light ****************/

class SunLight : public Light {
public:
	SunLight(const PointerRNA &ptr_arg) :
		Light(ptr_arg)
		{}

	inline float angle(void);
	inline void angle(float value);
	inline float energy(void);
	inline void energy(float value);
	inline float shadow_buffer_clip_start(void);
	inline void shadow_buffer_clip_start(float value);
	inline float shadow_soft_size(void);
	inline void shadow_soft_size(float value);
	inline float shadow_filter_radius(void);
	inline void shadow_filter_radius(float value);
	inline float shadow_maximum_resolution(void);
	inline void shadow_maximum_resolution(float value);
	inline bool use_shadow_jitter(void);
	inline void use_shadow_jitter(bool value);
	inline float shadow_jitter_overblur(void);
	inline void shadow_jitter_overblur(float value);
	inline float shadow_cascade_max_distance(void);
	inline void shadow_cascade_max_distance(float value);
	inline int shadow_cascade_count(void);
	inline void shadow_cascade_count(int value);
	inline float shadow_cascade_exponent(void);
	inline void shadow_cascade_exponent(float value);
	inline float shadow_cascade_fade(void);
	inline void shadow_cascade_fade(float value);

};

/**************** Lattice ****************/

class Lattice : public ID {
public:
	Lattice(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		points(ptr_arg)
		{}

	inline int points_u(void);
	inline void points_u(int value);
	inline int points_v(void);
	inline void points_v(int value);
	inline int points_w(void);
	inline void points_w(int value);
	enum interpolation_type_u_enum {
		interpolation_type_u_KEY_LINEAR = 0,
		interpolation_type_u_KEY_CARDINAL = 1,
		interpolation_type_u_KEY_CATMULL_ROM = 3,
		interpolation_type_u_KEY_BSPLINE = 2,
	};
	inline interpolation_type_u_enum interpolation_type_u(void);
	inline void interpolation_type_u(interpolation_type_u_enum value);
	enum interpolation_type_v_enum {
		interpolation_type_v_KEY_LINEAR = 0,
		interpolation_type_v_KEY_CARDINAL = 1,
		interpolation_type_v_KEY_CATMULL_ROM = 3,
		interpolation_type_v_KEY_BSPLINE = 2,
	};
	inline interpolation_type_v_enum interpolation_type_v(void);
	inline void interpolation_type_v(interpolation_type_v_enum value);
	enum interpolation_type_w_enum {
		interpolation_type_w_KEY_LINEAR = 0,
		interpolation_type_w_KEY_CARDINAL = 1,
		interpolation_type_w_KEY_CATMULL_ROM = 3,
		interpolation_type_w_KEY_BSPLINE = 2,
	};
	inline interpolation_type_w_enum interpolation_type_w(void);
	inline void interpolation_type_w(interpolation_type_w_enum value);
	inline bool use_outside(void);
	inline void use_outside(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline Key shape_keys(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, LatticePoint, Lattice, points, false, false, false)
	inline bool is_editmode(void);
	inline void is_editmode(bool value);
	inline AnimData animation_data(void);

	inline void transform(float matrix[16], bool shape_keys);
	inline void update_gpu_tag();
};

/**************** LatticePoint ****************/

class LatticePoint : public Pointer {
public:
	LatticePoint(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		groups(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool select(void);
	inline void select(bool value);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> co_deform(void);
	inline void co_deform(float values[3]);
	inline float weight_softbody(void);
	inline void weight_softbody(float value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, VertexGroupElement, LatticePoint, groups, false, false, false)

};

/**************** View Layer ****************/

class ViewLayer : public Pointer {
public:
	ViewLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		aovs(ptr_arg),
		lightgroups(ptr_arg),
		objects(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline Material material_override(void);
	inline World world_override(void);
	inline int samples(void);
	inline void samples(int value);
	inline float pass_alpha_threshold(void);
	inline void pass_alpha_threshold(float value);
	inline ViewLayerEEVEE eevee(void);
	COLLECTION_PROPERTY(AOVs, AOV, ViewLayer, aovs, false, true, true)
	inline AOV active_aov(void);
	inline int active_aov_index(void);
	inline void active_aov_index(int value);
	COLLECTION_PROPERTY(Lightgroups, Lightgroup, ViewLayer, lightgroups, false, true, true)
	inline Lightgroup active_lightgroup(void);
	inline int active_lightgroup_index(void);
	inline void active_lightgroup_index(int value);
	inline bool use_pass_cryptomatte_object(void);
	inline void use_pass_cryptomatte_object(bool value);
	inline bool use_pass_cryptomatte_material(void);
	inline void use_pass_cryptomatte_material(bool value);
	inline bool use_pass_cryptomatte_asset(void);
	inline void use_pass_cryptomatte_asset(bool value);
	inline int pass_cryptomatte_depth(void);
	inline void pass_cryptomatte_depth(int value);
	inline bool use_pass_cryptomatte_accurate(void);
	inline void use_pass_cryptomatte_accurate(bool value);
	inline bool use_solid(void);
	inline void use_solid(bool value);
	inline bool use_sky(void);
	inline void use_sky(bool value);
	inline bool use_ao(void);
	inline void use_ao(bool value);
	inline bool use_strand(void);
	inline void use_strand(bool value);
	inline bool use_volumes(void);
	inline void use_volumes(bool value);
	inline bool use_motion_blur(void);
	inline void use_motion_blur(bool value);
	inline bool use_grease_pencil(void);
	inline void use_grease_pencil(bool value);
	inline bool use_pass_combined(void);
	inline void use_pass_combined(bool value);
	inline bool use_pass_z(void);
	inline void use_pass_z(bool value);
	inline bool use_pass_vector(void);
	inline void use_pass_vector(bool value);
	inline bool use_pass_position(void);
	inline void use_pass_position(bool value);
	inline bool use_pass_normal(void);
	inline void use_pass_normal(bool value);
	inline bool use_pass_uv(void);
	inline void use_pass_uv(bool value);
	inline bool use_pass_mist(void);
	inline void use_pass_mist(bool value);
	inline bool use_pass_object_index(void);
	inline void use_pass_object_index(bool value);
	inline bool use_pass_material_index(void);
	inline void use_pass_material_index(bool value);
	inline bool use_pass_shadow(void);
	inline void use_pass_shadow(bool value);
	inline bool use_pass_ambient_occlusion(void);
	inline void use_pass_ambient_occlusion(bool value);
	inline bool use_pass_emit(void);
	inline void use_pass_emit(bool value);
	inline bool use_pass_environment(void);
	inline void use_pass_environment(bool value);
	inline bool use_pass_diffuse_direct(void);
	inline void use_pass_diffuse_direct(bool value);
	inline bool use_pass_diffuse_indirect(void);
	inline void use_pass_diffuse_indirect(bool value);
	inline bool use_pass_diffuse_color(void);
	inline void use_pass_diffuse_color(bool value);
	inline bool use_pass_glossy_direct(void);
	inline void use_pass_glossy_direct(bool value);
	inline bool use_pass_glossy_indirect(void);
	inline void use_pass_glossy_indirect(bool value);
	inline bool use_pass_glossy_color(void);
	inline void use_pass_glossy_color(bool value);
	inline bool use_pass_transmission_direct(void);
	inline void use_pass_transmission_direct(bool value);
	inline bool use_pass_transmission_indirect(void);
	inline void use_pass_transmission_indirect(bool value);
	inline bool use_pass_transmission_color(void);
	inline void use_pass_transmission_color(bool value);
	inline bool use_pass_subsurface_direct(void);
	inline void use_pass_subsurface_direct(bool value);
	inline bool use_pass_subsurface_indirect(void);
	inline void use_pass_subsurface_indirect(bool value);
	inline bool use_pass_subsurface_color(void);
	inline void use_pass_subsurface_color(bool value);
	inline LayerCollection layer_collection(void);
	inline LayerCollection active_layer_collection(void);
	COLLECTION_PROPERTY(LayerObjects, Object, ViewLayer, objects, false, true, true)
	inline bool use(void);
	inline void use(bool value);
	inline bool has_export_collections(void);
	inline void has_export_collections(bool value);
	inline bool use_freestyle(void);
	inline void use_freestyle(bool value);
	inline FreestyleSettings freestyle_settings(void);
	inline bool use_pass_grease_pencil(void);
	inline void use_pass_grease_pencil(bool value);
	inline Depsgraph depsgraph(void);

	inline void update_render_passes();
	inline void update(void *main);
};

/**************** Freestyle Line Set ****************/

class FreestyleLineSet : public Pointer {
public:
	FreestyleLineSet(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline FreestyleLineStyle linestyle(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline bool show_render(void);
	inline void show_render(bool value);
	inline bool select_by_visibility(void);
	inline void select_by_visibility(bool value);
	inline bool select_by_edge_types(void);
	inline void select_by_edge_types(bool value);
	inline bool select_by_collection(void);
	inline void select_by_collection(bool value);
	inline bool select_by_image_border(void);
	inline void select_by_image_border(bool value);
	inline bool select_by_face_marks(void);
	inline void select_by_face_marks(bool value);
	enum edge_type_negation_enum {
		edge_type_negation_INCLUSIVE = 0,
		edge_type_negation_EXCLUSIVE = 4,
	};
	inline edge_type_negation_enum edge_type_negation(void);
	inline void edge_type_negation(edge_type_negation_enum value);
	enum edge_type_combination_enum {
		edge_type_combination_OR = 0,
		edge_type_combination_AND = 8,
	};
	inline edge_type_combination_enum edge_type_combination(void);
	inline void edge_type_combination(edge_type_combination_enum value);
	inline Collection collection(void);
	enum collection_negation_enum {
		collection_negation_INCLUSIVE = 0,
		collection_negation_EXCLUSIVE = 16,
	};
	inline collection_negation_enum collection_negation(void);
	inline void collection_negation(collection_negation_enum value);
	enum face_mark_negation_enum {
		face_mark_negation_INCLUSIVE = 0,
		face_mark_negation_EXCLUSIVE = 32,
	};
	inline face_mark_negation_enum face_mark_negation(void);
	inline void face_mark_negation(face_mark_negation_enum value);
	enum face_mark_condition_enum {
		face_mark_condition_ONE = 0,
		face_mark_condition_BOTH = 64,
	};
	inline face_mark_condition_enum face_mark_condition(void);
	inline void face_mark_condition(face_mark_condition_enum value);
	inline bool select_silhouette(void);
	inline void select_silhouette(bool value);
	inline bool select_border(void);
	inline void select_border(bool value);
	inline bool select_crease(void);
	inline void select_crease(bool value);
	inline bool select_ridge_valley(void);
	inline void select_ridge_valley(bool value);
	inline bool select_suggestive_contour(void);
	inline void select_suggestive_contour(bool value);
	inline bool select_material_boundary(void);
	inline void select_material_boundary(bool value);
	inline bool select_contour(void);
	inline void select_contour(bool value);
	inline bool select_external_contour(void);
	inline void select_external_contour(bool value);
	inline bool select_edge_mark(void);
	inline void select_edge_mark(bool value);
	inline bool exclude_silhouette(void);
	inline void exclude_silhouette(bool value);
	inline bool exclude_border(void);
	inline void exclude_border(bool value);
	inline bool exclude_crease(void);
	inline void exclude_crease(bool value);
	inline bool exclude_ridge_valley(void);
	inline void exclude_ridge_valley(bool value);
	inline bool exclude_suggestive_contour(void);
	inline void exclude_suggestive_contour(bool value);
	inline bool exclude_material_boundary(void);
	inline void exclude_material_boundary(bool value);
	inline bool exclude_contour(void);
	inline void exclude_contour(bool value);
	inline bool exclude_external_contour(void);
	inline void exclude_external_contour(bool value);
	inline bool exclude_edge_mark(void);
	inline void exclude_edge_mark(bool value);
	enum visibility_enum {
		visibility_VISIBLE = 1,
		visibility_HIDDEN = 2,
		visibility_RANGE = 3,
	};
	inline visibility_enum visibility(void);
	inline void visibility(visibility_enum value);
	inline int qi_start(void);
	inline void qi_start(int value);
	inline int qi_end(void);
	inline void qi_end(int value);

};

/**************** Freestyle Module ****************/

class FreestyleModuleSettings : public Pointer {
public:
	FreestyleModuleSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Text script(void);
	inline bool use(void);
	inline void use(bool value);

};

/**************** Freestyle Settings ****************/

class FreestyleSettings : public Pointer {
public:
	FreestyleSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		modules(ptr_arg),
		linesets(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(FreestyleModules, FreestyleModuleSettings, FreestyleSettings, modules, false, true, false)
	enum mode_enum {
		mode_SCRIPT = 1,
		mode_EDITOR = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool use_culling(void);
	inline void use_culling(bool value);
	inline bool use_suggestive_contours(void);
	inline void use_suggestive_contours(bool value);
	inline bool use_ridges_and_valleys(void);
	inline void use_ridges_and_valleys(bool value);
	inline bool use_material_boundaries(void);
	inline void use_material_boundaries(bool value);
	inline bool use_smoothness(void);
	inline void use_smoothness(bool value);
	inline bool use_view_map_cache(void);
	inline void use_view_map_cache(bool value);
	inline bool as_render_pass(void);
	inline void as_render_pass(bool value);
	inline float sphere_radius(void);
	inline void sphere_radius(float value);
	inline float kr_derivative_epsilon(void);
	inline void kr_derivative_epsilon(float value);
	inline float crease_angle(void);
	inline void crease_angle(float value);
	COLLECTION_PROPERTY(Linesets, FreestyleLineSet, FreestyleSettings, linesets, false, true, true)

};

/**************** Layer Collection ****************/

class LayerCollection : public Pointer {
public:
	LayerCollection(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		children(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Collection collection(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, LayerCollection, LayerCollection, children, false, true, true)
	inline bool exclude(void);
	inline void exclude(bool value);
	inline bool holdout(void);
	inline void holdout(bool value);
	inline bool indirect_only(void);
	inline void indirect_only(bool value);
	inline bool hide_viewport(void);
	inline void hide_viewport(bool value);
	inline bool is_visible(void);
	inline void is_visible(bool value);

	inline bool visible_get(Context C);
	inline bool has_objects();
	inline bool has_selected_objects(void *main, ViewLayer& view_layer);
};

/**************** Object Base ****************/

class ObjectBase : public Pointer {
public:
	ObjectBase(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object object(void);
	inline bool select(void);
	inline void select(bool value);
	inline bool hide_viewport(void);
	inline void hide_viewport(bool value);

};

/**************** Line Style Modifier ****************/

class LineStyleModifier : public Pointer {
public:
	LineStyleModifier(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);

};

/**************** Line Style Color Modifier ****************/

class LineStyleColorModifier : public LineStyleModifier {
public:
	LineStyleColorModifier(const PointerRNA &ptr_arg) :
		LineStyleModifier(ptr_arg)
		{}

	inline std::string name(void);
	inline void name(const std::string& value);

};

/**************** Along Stroke ****************/

class LineStyleColorModifier_AlongStroke : public LineStyleColorModifier {
public:
	LineStyleColorModifier_AlongStroke(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 7,
		blend_MULTIPLY = 2,
		blend_BURN = 11,
		blend_LIGHTEN = 8,
		blend_SCREEN = 4,
		blend_DODGE = 10,
		blend_ADD = 1,
		blend_OVERLAY = 9,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
		blend_DIFFERENCE = 6,
		blend_EXCLUSION = 18,
		blend_SUBTRACT = 3,
		blend_DIVIDE = 5,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_COLOR = 15,
		blend_VALUE = 14,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline ColorRamp color_ramp(void);

};

/**************** Distance from Camera ****************/

class LineStyleColorModifier_DistanceFromCamera : public LineStyleColorModifier {
public:
	LineStyleColorModifier_DistanceFromCamera(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 7,
		blend_MULTIPLY = 2,
		blend_BURN = 11,
		blend_LIGHTEN = 8,
		blend_SCREEN = 4,
		blend_DODGE = 10,
		blend_ADD = 1,
		blend_OVERLAY = 9,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
		blend_DIFFERENCE = 6,
		blend_EXCLUSION = 18,
		blend_SUBTRACT = 3,
		blend_DIVIDE = 5,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_COLOR = 15,
		blend_VALUE = 14,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline ColorRamp color_ramp(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);

};

/**************** Distance from Object ****************/

class LineStyleColorModifier_DistanceFromObject : public LineStyleColorModifier {
public:
	LineStyleColorModifier_DistanceFromObject(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 7,
		blend_MULTIPLY = 2,
		blend_BURN = 11,
		blend_LIGHTEN = 8,
		blend_SCREEN = 4,
		blend_DODGE = 10,
		blend_ADD = 1,
		blend_OVERLAY = 9,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
		blend_DIFFERENCE = 6,
		blend_EXCLUSION = 18,
		blend_SUBTRACT = 3,
		blend_DIVIDE = 5,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_COLOR = 15,
		blend_VALUE = 14,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline ColorRamp color_ramp(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);
	inline Object target(void);

};

/**************** Material ****************/

class LineStyleColorModifier_Material : public LineStyleColorModifier {
public:
	LineStyleColorModifier_Material(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 7,
		blend_MULTIPLY = 2,
		blend_BURN = 11,
		blend_LIGHTEN = 8,
		blend_SCREEN = 4,
		blend_DODGE = 10,
		blend_ADD = 1,
		blend_OVERLAY = 9,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
		blend_DIFFERENCE = 6,
		blend_EXCLUSION = 18,
		blend_SUBTRACT = 3,
		blend_DIVIDE = 5,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_COLOR = 15,
		blend_VALUE = 14,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum material_attribute_enum {
		material_attribute_LINE = 11,
		material_attribute_LINE_R = 12,
		material_attribute_LINE_G = 13,
		material_attribute_LINE_B = 14,
		material_attribute_LINE_A = 15,
		material_attribute_DIFF = 1,
		material_attribute_DIFF_R = 2,
		material_attribute_DIFF_G = 3,
		material_attribute_DIFF_B = 4,
		material_attribute_SPEC = 5,
		material_attribute_SPEC_R = 6,
		material_attribute_SPEC_G = 7,
		material_attribute_SPEC_B = 8,
		material_attribute_SPEC_HARD = 9,
		material_attribute_ALPHA = 10,
	};
	inline material_attribute_enum material_attribute(void);
	inline void material_attribute(material_attribute_enum value);
	inline ColorRamp color_ramp(void);
	inline bool use_ramp(void);
	inline void use_ramp(bool value);

};

/**************** Tangent ****************/

class LineStyleColorModifier_Tangent : public LineStyleColorModifier {
public:
	LineStyleColorModifier_Tangent(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 7,
		blend_MULTIPLY = 2,
		blend_BURN = 11,
		blend_LIGHTEN = 8,
		blend_SCREEN = 4,
		blend_DODGE = 10,
		blend_ADD = 1,
		blend_OVERLAY = 9,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
		blend_DIFFERENCE = 6,
		blend_EXCLUSION = 18,
		blend_SUBTRACT = 3,
		blend_DIVIDE = 5,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_COLOR = 15,
		blend_VALUE = 14,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline ColorRamp color_ramp(void);

};

/**************** Noise ****************/

class LineStyleColorModifier_Noise : public LineStyleColorModifier {
public:
	LineStyleColorModifier_Noise(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 7,
		blend_MULTIPLY = 2,
		blend_BURN = 11,
		blend_LIGHTEN = 8,
		blend_SCREEN = 4,
		blend_DODGE = 10,
		blend_ADD = 1,
		blend_OVERLAY = 9,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
		blend_DIFFERENCE = 6,
		blend_EXCLUSION = 18,
		blend_SUBTRACT = 3,
		blend_DIVIDE = 5,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_COLOR = 15,
		blend_VALUE = 14,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline ColorRamp color_ramp(void);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float period(void);
	inline void period(float value);
	inline int seed(void);
	inline void seed(int value);

};

/**************** Crease Angle ****************/

class LineStyleColorModifier_CreaseAngle : public LineStyleColorModifier {
public:
	LineStyleColorModifier_CreaseAngle(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 7,
		blend_MULTIPLY = 2,
		blend_BURN = 11,
		blend_LIGHTEN = 8,
		blend_SCREEN = 4,
		blend_DODGE = 10,
		blend_ADD = 1,
		blend_OVERLAY = 9,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
		blend_DIFFERENCE = 6,
		blend_EXCLUSION = 18,
		blend_SUBTRACT = 3,
		blend_DIVIDE = 5,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_COLOR = 15,
		blend_VALUE = 14,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline ColorRamp color_ramp(void);
	inline float angle_min(void);
	inline void angle_min(float value);
	inline float angle_max(void);
	inline void angle_max(float value);

};

/**************** Curvature 3D ****************/

class LineStyleColorModifier_Curvature_3D : public LineStyleColorModifier {
public:
	LineStyleColorModifier_Curvature_3D(const PointerRNA &ptr_arg) :
		LineStyleColorModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_DARKEN = 7,
		blend_MULTIPLY = 2,
		blend_BURN = 11,
		blend_LIGHTEN = 8,
		blend_SCREEN = 4,
		blend_DODGE = 10,
		blend_ADD = 1,
		blend_OVERLAY = 9,
		blend_SOFT_LIGHT = 16,
		blend_LINEAR_LIGHT = 17,
		blend_DIFFERENCE = 6,
		blend_EXCLUSION = 18,
		blend_SUBTRACT = 3,
		blend_DIVIDE = 5,
		blend_HUE = 12,
		blend_SATURATION = 13,
		blend_COLOR = 15,
		blend_VALUE = 14,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline ColorRamp color_ramp(void);
	inline float curvature_min(void);
	inline void curvature_min(float value);
	inline float curvature_max(void);
	inline void curvature_max(float value);

};

/**************** Line Style Alpha Modifier ****************/

class LineStyleAlphaModifier : public LineStyleModifier {
public:
	LineStyleAlphaModifier(const PointerRNA &ptr_arg) :
		LineStyleModifier(ptr_arg)
		{}

	inline std::string name(void);
	inline void name(const std::string& value);

};

/**************** Along Stroke ****************/

class LineStyleAlphaModifier_AlongStroke : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_AlongStroke(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);

};

/**************** Distance from Camera ****************/

class LineStyleAlphaModifier_DistanceFromCamera : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_DistanceFromCamera(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);

};

/**************** Distance from Object ****************/

class LineStyleAlphaModifier_DistanceFromObject : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_DistanceFromObject(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);
	inline Object target(void);

};

/**************** Material ****************/

class LineStyleAlphaModifier_Material : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_Material(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum material_attribute_enum {
		material_attribute_LINE = 11,
		material_attribute_LINE_R = 12,
		material_attribute_LINE_G = 13,
		material_attribute_LINE_B = 14,
		material_attribute_LINE_A = 15,
		material_attribute_DIFF = 1,
		material_attribute_DIFF_R = 2,
		material_attribute_DIFF_G = 3,
		material_attribute_DIFF_B = 4,
		material_attribute_SPEC = 5,
		material_attribute_SPEC_R = 6,
		material_attribute_SPEC_G = 7,
		material_attribute_SPEC_B = 8,
		material_attribute_SPEC_HARD = 9,
		material_attribute_ALPHA = 10,
	};
	inline material_attribute_enum material_attribute(void);
	inline void material_attribute(material_attribute_enum value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);

};

/**************** Tangent ****************/

class LineStyleAlphaModifier_Tangent : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_Tangent(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);

};

/**************** Noise ****************/

class LineStyleAlphaModifier_Noise : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_Noise(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float period(void);
	inline void period(float value);
	inline int seed(void);
	inline void seed(int value);

};

/**************** Crease Angle ****************/

class LineStyleAlphaModifier_CreaseAngle : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_CreaseAngle(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float angle_min(void);
	inline void angle_min(float value);
	inline float angle_max(void);
	inline void angle_max(float value);

};

/**************** Curvature 3D ****************/

class LineStyleAlphaModifier_Curvature_3D : public LineStyleAlphaModifier {
public:
	LineStyleAlphaModifier_Curvature_3D(const PointerRNA &ptr_arg) :
		LineStyleAlphaModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float curvature_min(void);
	inline void curvature_min(float value);
	inline float curvature_max(void);
	inline void curvature_max(float value);

};

/**************** Line Style Thickness Modifier ****************/

class LineStyleThicknessModifier : public LineStyleModifier {
public:
	LineStyleThicknessModifier(const PointerRNA &ptr_arg) :
		LineStyleModifier(ptr_arg)
		{}

	inline std::string name(void);
	inline void name(const std::string& value);

};

/**************** Tangent ****************/

class LineStyleThicknessModifier_Tangent : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_Tangent(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float thickness_min(void);
	inline void thickness_min(float value);
	inline float thickness_max(void);
	inline void thickness_max(float value);

};

/**************** Along Stroke ****************/

class LineStyleThicknessModifier_AlongStroke : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_AlongStroke(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float value_min(void);
	inline void value_min(float value);
	inline float value_max(void);
	inline void value_max(float value);

};

/**************** Distance from Camera ****************/

class LineStyleThicknessModifier_DistanceFromCamera : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_DistanceFromCamera(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);
	inline float value_min(void);
	inline void value_min(float value);
	inline float value_max(void);
	inline void value_max(float value);

};

/**************** Distance from Object ****************/

class LineStyleThicknessModifier_DistanceFromObject : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_DistanceFromObject(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float range_min(void);
	inline void range_min(float value);
	inline float range_max(void);
	inline void range_max(float value);
	inline float value_min(void);
	inline void value_min(float value);
	inline float value_max(void);
	inline void value_max(float value);
	inline Object target(void);

};

/**************** Material ****************/

class LineStyleThicknessModifier_Material : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_Material(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum material_attribute_enum {
		material_attribute_LINE = 11,
		material_attribute_LINE_R = 12,
		material_attribute_LINE_G = 13,
		material_attribute_LINE_B = 14,
		material_attribute_LINE_A = 15,
		material_attribute_DIFF = 1,
		material_attribute_DIFF_R = 2,
		material_attribute_DIFF_G = 3,
		material_attribute_DIFF_B = 4,
		material_attribute_SPEC = 5,
		material_attribute_SPEC_R = 6,
		material_attribute_SPEC_G = 7,
		material_attribute_SPEC_B = 8,
		material_attribute_SPEC_HARD = 9,
		material_attribute_ALPHA = 10,
	};
	inline material_attribute_enum material_attribute(void);
	inline void material_attribute(material_attribute_enum value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float value_min(void);
	inline void value_min(float value);
	inline float value_max(void);
	inline void value_max(float value);

};

/**************** Calligraphy ****************/

class LineStyleThicknessModifier_Calligraphy : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_Calligraphy(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float orientation(void);
	inline void orientation(float value);
	inline float thickness_min(void);
	inline void thickness_min(float value);
	inline float thickness_max(void);
	inline void thickness_max(float value);

};

/**************** Noise ****************/

class LineStyleThicknessModifier_Noise : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_Noise(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float period(void);
	inline void period(float value);
	inline int seed(void);
	inline void seed(int value);
	inline bool use_asymmetric(void);
	inline void use_asymmetric(bool value);

};

/**************** Curvature 3D ****************/

class LineStyleThicknessModifier_Curvature_3D : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_Curvature_3D(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float thickness_min(void);
	inline void thickness_min(float value);
	inline float thickness_max(void);
	inline void thickness_max(float value);
	inline float curvature_min(void);
	inline void curvature_min(float value);
	inline float curvature_max(void);
	inline void curvature_max(float value);

};

/**************** Crease Angle ****************/

class LineStyleThicknessModifier_CreaseAngle : public LineStyleThicknessModifier {
public:
	LineStyleThicknessModifier_CreaseAngle(const PointerRNA &ptr_arg) :
		LineStyleThicknessModifier(ptr_arg)
		{}

	enum type_enum {
		type_ALONG_STROKE = 1,
		type_CALLIGRAPHY = 13,
		type_CREASE_ANGLE = 21,
		type_CURVATURE_3D = 23,
		type_DISTANCE_FROM_CAMERA = 2,
		type_DISTANCE_FROM_OBJECT = 3,
		type_MATERIAL = 4,
		type_NOISE = 20,
		type_TANGENT = 19,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum blend_enum {
		blend_MIX = 0,
		blend_ADD = 1,
		blend_SUBTRACT = 3,
		blend_MULTIPLY = 2,
		blend_DIVIDE = 4,
		blend_DIFFERENCE = 5,
		blend_MINIMUM = 6,
		blend_MAXIMUM = 7,
	};
	inline blend_enum blend(void);
	inline void blend(blend_enum value);
	inline float influence(void);
	inline void influence(float value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum mapping_enum {
		mapping_LINEAR = 0,
		mapping_CURVE = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool invert(void);
	inline void invert(bool value);
	inline CurveMapping curve(void);
	inline float angle_min(void);
	inline void angle_min(float value);
	inline float angle_max(void);
	inline void angle_max(float value);
	inline float thickness_min(void);
	inline void thickness_min(float value);
	inline float thickness_max(void);
	inline void thickness_max(float value);

};

/**************** Line Style Geometry Modifier ****************/

class LineStyleGeometryModifier : public LineStyleModifier {
public:
	LineStyleGeometryModifier(const PointerRNA &ptr_arg) :
		LineStyleModifier(ptr_arg)
		{}

	inline std::string name(void);
	inline void name(const std::string& value);

};

/**************** Sampling ****************/

class LineStyleGeometryModifier_Sampling : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_Sampling(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float sampling(void);
	inline void sampling(float value);

};

/**************** Bézier Curve ****************/

class LineStyleGeometryModifier_BezierCurve : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_BezierCurve(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float error(void);
	inline void error(float value);

};

/**************** Sinus Displacement ****************/

class LineStyleGeometryModifier_SinusDisplacement : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_SinusDisplacement(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float wavelength(void);
	inline void wavelength(float value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float phase(void);
	inline void phase(float value);

};

/**************** Spatial Noise ****************/

class LineStyleGeometryModifier_SpatialNoise : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_SpatialNoise(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float scale(void);
	inline void scale(float value);
	inline int octaves(void);
	inline void octaves(int value);
	inline bool smooth(void);
	inline void smooth(bool value);
	inline bool use_pure_random(void);
	inline void use_pure_random(bool value);

};

/**************** Perlin Noise 1D ****************/

class LineStyleGeometryModifier_PerlinNoise1D : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_PerlinNoise1D(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float frequency(void);
	inline void frequency(float value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline int octaves(void);
	inline void octaves(int value);
	inline float angle(void);
	inline void angle(float value);
	inline int seed(void);
	inline void seed(int value);

};

/**************** Perlin Noise 2D ****************/

class LineStyleGeometryModifier_PerlinNoise2D : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_PerlinNoise2D(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float frequency(void);
	inline void frequency(float value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline int octaves(void);
	inline void octaves(int value);
	inline float angle(void);
	inline void angle(float value);
	inline int seed(void);
	inline void seed(int value);

};

/**************** Backbone Stretcher ****************/

class LineStyleGeometryModifier_BackboneStretcher : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_BackboneStretcher(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float backbone_length(void);
	inline void backbone_length(float value);

};

/**************** Tip Remover ****************/

class LineStyleGeometryModifier_TipRemover : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_TipRemover(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float tip_length(void);
	inline void tip_length(float value);

};

/**************** Polygonalization ****************/

class LineStyleGeometryModifier_Polygonalization : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_Polygonalization(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float error(void);
	inline void error(float value);

};

/**************** Guiding Lines ****************/

class LineStyleGeometryModifier_GuidingLines : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_GuidingLines(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float offset(void);
	inline void offset(float value);

};

/**************** Blueprint ****************/

class LineStyleGeometryModifier_Blueprint : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_Blueprint(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum shape_enum {
		shape_CIRCLES = 1,
		shape_ELLIPSES = 2,
		shape_SQUARES = 4,
	};
	inline shape_enum shape(void);
	inline void shape(shape_enum value);
	inline int rounds(void);
	inline void rounds(int value);
	inline float backbone_length(void);
	inline void backbone_length(float value);
	inline int random_radius(void);
	inline void random_radius(int value);
	inline int random_center(void);
	inline void random_center(int value);
	inline int random_backbone(void);
	inline void random_backbone(int value);

};

/**************** 2D Offset ****************/

class LineStyleGeometryModifier_2DOffset : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_2DOffset(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float start(void);
	inline void start(float value);
	inline float end(void);
	inline void end(float value);
	inline float x(void);
	inline void x(float value);
	inline float y(void);
	inline void y(float value);

};

/**************** 2D Transform ****************/

class LineStyleGeometryModifier_2DTransform : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_2DTransform(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	enum pivot_enum {
		pivot_CENTER = 1,
		pivot_START = 2,
		pivot_END = 3,
		pivot_PARAM = 4,
		pivot_ABSOLUTE = 5,
	};
	inline pivot_enum pivot(void);
	inline void pivot(pivot_enum value);
	inline float scale_x(void);
	inline void scale_x(float value);
	inline float scale_y(void);
	inline void scale_y(float value);
	inline float angle(void);
	inline void angle(float value);
	inline float pivot_u(void);
	inline void pivot_u(float value);
	inline float pivot_x(void);
	inline void pivot_x(float value);
	inline float pivot_y(void);
	inline void pivot_y(float value);

};

/**************** Simplification ****************/

class LineStyleGeometryModifier_Simplification : public LineStyleGeometryModifier {
public:
	LineStyleGeometryModifier_Simplification(const PointerRNA &ptr_arg) :
		LineStyleGeometryModifier(ptr_arg)
		{}

	enum type_enum {
		type_2D_OFFSET = 17,
		type_2D_TRANSFORM = 18,
		type_BACKBONE_STRETCHER = 11,
		type_BEZIER_CURVE = 6,
		type_BLUEPRINT = 16,
		type_GUIDING_LINES = 15,
		type_PERLIN_NOISE_1D = 9,
		type_PERLIN_NOISE_2D = 10,
		type_POLYGONIZATION = 14,
		type_SAMPLING = 5,
		type_SIMPLIFICATION = 22,
		type_SINUS_DISPLACEMENT = 7,
		type_SPATIAL_NOISE = 8,
		type_TIP_REMOVER = 12,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool use(void);
	inline void use(bool value);
	inline bool expanded(void);
	inline void expanded(bool value);
	inline float tolerance(void);
	inline void tolerance(float value);

};

/**************** Freestyle Line Style ****************/

class FreestyleLineStyle : public ID {
public:
	FreestyleLineStyle(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		texture_slots(ptr_arg),
		color_modifiers(ptr_arg),
		alpha_modifiers(ptr_arg),
		thickness_modifiers(ptr_arg),
		geometry_modifiers(ptr_arg)
		{}

	COLLECTION_PROPERTY(LineStyleTextureSlots, LineStyleTextureSlot, FreestyleLineStyle, texture_slots, false, false, false)
	inline Texture active_texture(void);
	inline int active_texture_index(void);
	inline void active_texture_index(int value);
	enum panel_enum {
		panel_STROKES = 1,
		panel_COLOR = 2,
		panel_ALPHA = 3,
		panel_THICKNESS = 4,
		panel_GEOMETRY = 5,
		panel_TEXTURE = 6,
	};
	inline panel_enum panel(void);
	inline void panel(panel_enum value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline float alpha(void);
	inline void alpha(float value);
	inline float thickness(void);
	inline void thickness(float value);
	enum thickness_position_enum {
		thickness_position_CENTER = 1,
		thickness_position_INSIDE = 2,
		thickness_position_OUTSIDE = 3,
		thickness_position_RELATIVE = 4,
	};
	inline thickness_position_enum thickness_position(void);
	inline void thickness_position(thickness_position_enum value);
	inline float thickness_ratio(void);
	inline void thickness_ratio(float value);
	COLLECTION_PROPERTY(LineStyleColorModifiers, LineStyleColorModifier, FreestyleLineStyle, color_modifiers, false, true, true)
	COLLECTION_PROPERTY(LineStyleAlphaModifiers, LineStyleAlphaModifier, FreestyleLineStyle, alpha_modifiers, false, true, true)
	COLLECTION_PROPERTY(LineStyleThicknessModifiers, LineStyleThicknessModifier, FreestyleLineStyle, thickness_modifiers, false, true, true)
	COLLECTION_PROPERTY(LineStyleGeometryModifiers, LineStyleGeometryModifier, FreestyleLineStyle, geometry_modifiers, false, true, true)
	inline bool use_chaining(void);
	inline void use_chaining(bool value);
	enum chaining_enum {
		chaining_PLAIN = 1,
		chaining_SKETCHY = 2,
	};
	inline chaining_enum chaining(void);
	inline void chaining(chaining_enum value);
	inline int rounds(void);
	inline void rounds(int value);
	inline bool use_same_object(void);
	inline void use_same_object(bool value);
	inline bool use_split_length(void);
	inline void use_split_length(bool value);
	inline float split_length(void);
	inline void split_length(float value);
	inline bool use_angle_min(void);
	inline void use_angle_min(bool value);
	inline float angle_min(void);
	inline void angle_min(float value);
	inline bool use_angle_max(void);
	inline void use_angle_max(bool value);
	inline float angle_max(void);
	inline void angle_max(float value);
	inline bool use_length_min(void);
	inline void use_length_min(bool value);
	inline float length_min(void);
	inline void length_min(float value);
	inline bool use_length_max(void);
	inline void use_length_max(bool value);
	inline float length_max(void);
	inline void length_max(float value);
	inline bool use_chain_count(void);
	inline void use_chain_count(bool value);
	inline int chain_count(void);
	inline void chain_count(int value);
	inline bool use_split_pattern(void);
	inline void use_split_pattern(bool value);
	inline int split_dash1(void);
	inline void split_dash1(int value);
	inline int split_gap1(void);
	inline void split_gap1(int value);
	inline int split_dash2(void);
	inline void split_dash2(int value);
	inline int split_gap2(void);
	inline void split_gap2(int value);
	inline int split_dash3(void);
	inline void split_dash3(int value);
	inline int split_gap3(void);
	inline void split_gap3(int value);
	inline bool material_boundary(void);
	inline void material_boundary(bool value);
	inline bool use_sorting(void);
	inline void use_sorting(bool value);
	enum sort_key_enum {
		sort_key_DISTANCE_FROM_CAMERA = 1,
		sort_key_2D_LENGTH = 2,
		sort_key_PROJECTED_X = 3,
		sort_key_PROJECTED_Y = 4,
	};
	inline sort_key_enum sort_key(void);
	inline void sort_key(sort_key_enum value);
	enum sort_order_enum {
		sort_order_DEFAULT = 0,
		sort_order_REVERSE = 4096,
	};
	inline sort_order_enum sort_order(void);
	inline void sort_order(sort_order_enum value);
	enum integration_type_enum {
		integration_type_MEAN = 1,
		integration_type_MIN = 2,
		integration_type_MAX = 3,
		integration_type_FIRST = 4,
		integration_type_LAST = 5,
	};
	inline integration_type_enum integration_type(void);
	inline void integration_type(integration_type_enum value);
	inline bool use_dashed_line(void);
	inline void use_dashed_line(bool value);
	enum caps_enum {
		caps_BUTT = 1,
		caps_ROUND = 2,
		caps_SQUARE = 3,
	};
	inline caps_enum caps(void);
	inline void caps(caps_enum value);
	inline int dash1(void);
	inline void dash1(int value);
	inline int gap1(void);
	inline void gap1(int value);
	inline int dash2(void);
	inline void dash2(int value);
	inline int gap2(void);
	inline void gap2(int value);
	inline int dash3(void);
	inline void dash3(int value);
	inline int gap3(void);
	inline void gap3(int value);
	inline bool use_texture(void);
	inline void use_texture(bool value);
	inline float texture_spacing(void);
	inline void texture_spacing(float value);
	inline AnimData animation_data(void);
	inline NodeTree node_tree(void);
	inline bool use_nodes(void);
	inline void use_nodes(bool value);

};

/**************** LineStyle Texture Slot ****************/

class LineStyleTextureSlot : public TextureSlot {
public:
	LineStyleTextureSlot(const PointerRNA &ptr_arg) :
		TextureSlot(ptr_arg)
		{}

	enum mapping_x_enum {
		mapping_x_NONE = 0,
		mapping_x_X = 1,
		mapping_x_Y = 2,
		mapping_x_Z = 3,
	};
	inline mapping_x_enum mapping_x(void);
	inline void mapping_x(mapping_x_enum value);
	enum mapping_y_enum {
		mapping_y_NONE = 0,
		mapping_y_X = 1,
		mapping_y_Y = 2,
		mapping_y_Z = 3,
	};
	inline mapping_y_enum mapping_y(void);
	inline void mapping_y(mapping_y_enum value);
	enum mapping_z_enum {
		mapping_z_NONE = 0,
		mapping_z_X = 1,
		mapping_z_Y = 2,
		mapping_z_Z = 3,
	};
	inline mapping_z_enum mapping_z(void);
	inline void mapping_z(mapping_z_enum value);
	enum mapping_enum {
		mapping_FLAT = 0,
		mapping_CUBE = 1,
		mapping_TUBE = 2,
		mapping_SPHERE = 3,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);
	inline bool use_map_color_diffuse(void);
	inline void use_map_color_diffuse(bool value);
	inline bool use_map_alpha(void);
	inline void use_map_alpha(bool value);
	enum texture_coords_enum {
		texture_coords_WINDOW = 1024,
		texture_coords_GLOBAL = 8,
		texture_coords_ALONG_STROKE = 16,
		texture_coords_ORCO = 1,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline float alpha_factor(void);
	inline void alpha_factor(float value);
	inline float diffuse_color_factor(void);
	inline void diffuse_color_factor(float value);

};

/**************** Blendfile Import Context Library ****************/

class BlendImportContextLibrary : public Pointer {
public:
	BlendImportContextLibrary(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);

};

/**************** Blendfile Import Context Item ****************/

class BlendImportContextItem : public Pointer {
public:
	BlendImportContextItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		source_libraries(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum id_type_enum {
		id_type_ACTION = 17217,
		id_type_ARMATURE = 21057,
		id_type_BRUSH = 21058,
		id_type_CACHEFILE = 17987,
		id_type_CAMERA = 16707,
		id_type_COLLECTION = 21063,
		id_type_CURVE = 21827,
		id_type_CURVES = 22083,
		id_type_FONT = 18006,
		id_type_GREASEPENCIL = 17479,
		id_type_GREASEPENCIL_V3 = 20551,
		id_type_IMAGE = 19785,
		id_type_KEY = 17739,
		id_type_LATTICE = 21580,
		id_type_LIBRARY = 18764,
		id_type_LIGHT = 16716,
		id_type_LIGHT_PROBE = 20556,
		id_type_LINESTYLE = 21324,
		id_type_MASK = 21325,
		id_type_MATERIAL = 16717,
		id_type_MESH = 17741,
		id_type_META = 16973,
		id_type_MOVIECLIP = 17229,
		id_type_NODETREE = 21582,
		id_type_OBJECT = 16975,
		id_type_PAINTCURVE = 17232,
		id_type_PALETTE = 19536,
		id_type_PARTICLE = 16720,
		id_type_POINTCLOUD = 21584,
		id_type_SCENE = 17235,
		id_type_SCREEN = 21075,
		id_type_SOUND = 20307,
		id_type_SPEAKER = 19283,
		id_type_TEXT = 22612,
		id_type_TEXTURE = 17748,
		id_type_VOLUME = 20310,
		id_type_WINDOWMANAGER = 19799,
		id_type_WORKSPACE = 21335,
		id_type_WORLD = 20311,
	};
	inline id_type_enum id_type(void);
	inline void id_type(id_type_enum value);
	COLLECTION_PROPERTY(BlendImportContextLibraries, BlendImportContextLibrary, BlendImportContextItem, source_libraries, true, false, false)
	enum append_action_enum {
		append_action_UNSET = 0,
		append_action_KEEP_LINKED = 1,
		append_action_REUSE_LOCAL = 2,
		append_action_MAKE_LOCAL = 3,
		append_action_COPY_LOCAL = 4,
	};
	inline append_action_enum append_action(void);
	inline void append_action(append_action_enum value);
	enum import_info_enum {
		import_info_INDIRECT_USAGE = 1,
		import_info_LIBOVERRIDE_DEPENDENCY = 2,
		import_info_LIBOVERRIDE_DEPENDENCY_ONLY = 4,
	};
	inline import_info_enum import_info(void);
	inline void import_info(import_info_enum value);
	inline ID id(void);
	inline Library source_library(void);
	inline ID library_override_id(void);
	inline ID reusable_local_id(void);

};

/**************** Blendfile Import Context ****************/

class BlendImportContext : public Pointer {
public:
	BlendImportContext(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		import_items(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(BlendImportContextItems, BlendImportContextItem, BlendImportContext, import_items, true, false, false)
	enum options_enum {
		options_LINK = 4,
		options_MAKE_PATHS_RELATIVE = 2,
		options_USE_PLACEHOLDERS = 65536,
		options_FORCE_INDIRECT = 131072,
		options_APPEND_SET_FAKEUSER = 524288,
		options_APPEND_RECURSIVE = 1048576,
		options_APPEND_LOCAL_ID_REUSE = 2097152,
		options_APPEND_ASSET_DATA_CLEAR = 4194304,
		options_SELECT_OBJECTS = 16,
		options_USE_ACTIVE_COLLECTION = 32,
		options_OBDATA_INSTANCE = 16777216,
		options_COLLECTION_INSTANCE = 33554432,
	};
	inline options_enum options(void);
	inline void options(options_enum value);
	enum process_stage_enum {
		process_stage_INIT = 0,
		process_stage_DONE = 4,
	};
	inline process_stage_enum process_stage(void);
	inline void process_stage(process_stage_enum value);

};

/**************** Blend-File Data ****************/

class BlendData : public Pointer {
public:
	BlendData(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		cameras(ptr_arg),
		scenes(ptr_arg),
		objects(ptr_arg),
		materials(ptr_arg),
		node_groups(ptr_arg),
		meshes(ptr_arg),
		lights(ptr_arg),
		libraries(ptr_arg),
		screens(ptr_arg),
		window_managers(ptr_arg),
		images(ptr_arg),
		lattices(ptr_arg),
		curves(ptr_arg),
		metaballs(ptr_arg),
		fonts(ptr_arg),
		textures(ptr_arg),
		brushes(ptr_arg),
		worlds(ptr_arg),
		collections(ptr_arg),
		shape_keys(ptr_arg),
		texts(ptr_arg),
		speakers(ptr_arg),
		sounds(ptr_arg),
		armatures(ptr_arg),
		actions(ptr_arg),
		particles(ptr_arg),
		palettes(ptr_arg),
		grease_pencils(ptr_arg),
		grease_pencils_v3(ptr_arg),
		movieclips(ptr_arg),
		masks(ptr_arg),
		linestyles(ptr_arg),
		cache_files(ptr_arg),
		paint_curves(ptr_arg),
		workspaces(ptr_arg),
		lightprobes(ptr_arg),
		hair_curves(ptr_arg),
		pointclouds(ptr_arg),
		volumes(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline bool is_dirty(void);
	inline void is_dirty(bool value);
	inline bool is_saved(void);
	inline void is_saved(bool value);
	inline bool use_autopack(void);
	inline void use_autopack(bool value);
	inline Array<int, 3> version(void);
	inline void version(int values[3]);
	COLLECTION_PROPERTY(BlendDataCameras, Camera, BlendData, cameras, false, false, false)
	COLLECTION_PROPERTY(BlendDataScenes, Scene, BlendData, scenes, false, false, false)
	COLLECTION_PROPERTY(BlendDataObjects, Object, BlendData, objects, false, false, false)
	COLLECTION_PROPERTY(BlendDataMaterials, Material, BlendData, materials, false, false, false)
	COLLECTION_PROPERTY(BlendDataNodeTrees, NodeTree, BlendData, node_groups, false, false, false)
	COLLECTION_PROPERTY(BlendDataMeshes, Mesh, BlendData, meshes, false, false, false)
	COLLECTION_PROPERTY(BlendDataLights, Light, BlendData, lights, false, false, false)
	COLLECTION_PROPERTY(BlendDataLibraries, Library, BlendData, libraries, false, false, false)
	COLLECTION_PROPERTY(BlendDataScreens, Screen, BlendData, screens, false, false, false)
	COLLECTION_PROPERTY(BlendDataWindowManagers, WindowManager, BlendData, window_managers, false, false, false)
	COLLECTION_PROPERTY(BlendDataImages, Image, BlendData, images, false, false, false)
	COLLECTION_PROPERTY(BlendDataLattices, Lattice, BlendData, lattices, false, false, false)
	COLLECTION_PROPERTY(BlendDataCurves, Curve, BlendData, curves, false, false, false)
	COLLECTION_PROPERTY(BlendDataMetaBalls, MetaBall, BlendData, metaballs, false, false, false)
	COLLECTION_PROPERTY(BlendDataFonts, VectorFont, BlendData, fonts, false, false, false)
	COLLECTION_PROPERTY(BlendDataTextures, Texture, BlendData, textures, false, false, false)
	COLLECTION_PROPERTY(BlendDataBrushes, Brush, BlendData, brushes, false, false, false)
	COLLECTION_PROPERTY(BlendDataWorlds, World, BlendData, worlds, false, false, false)
	COLLECTION_PROPERTY(BlendDataCollections, Collection, BlendData, collections, false, false, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Key, BlendData, shape_keys, false, false, false)
	COLLECTION_PROPERTY(BlendDataTexts, Text, BlendData, texts, false, false, false)
	COLLECTION_PROPERTY(BlendDataSpeakers, Speaker, BlendData, speakers, false, false, false)
	COLLECTION_PROPERTY(BlendDataSounds, Sound, BlendData, sounds, false, false, false)
	COLLECTION_PROPERTY(BlendDataArmatures, Armature, BlendData, armatures, false, false, false)
	COLLECTION_PROPERTY(BlendDataActions, Action, BlendData, actions, false, false, false)
	COLLECTION_PROPERTY(BlendDataParticles, ParticleSettings, BlendData, particles, false, false, false)
	COLLECTION_PROPERTY(BlendDataPalettes, Palette, BlendData, palettes, false, false, false)
	COLLECTION_PROPERTY(BlendDataGreasePencils, GreasePencil, BlendData, grease_pencils, false, false, false)
	COLLECTION_PROPERTY(BlendDataGreasePencilsV3, GreasePencilv3, BlendData, grease_pencils_v3, false, false, false)
	COLLECTION_PROPERTY(BlendDataMovieClips, MovieClip, BlendData, movieclips, false, false, false)
	COLLECTION_PROPERTY(BlendDataMasks, Mask, BlendData, masks, false, false, false)
	COLLECTION_PROPERTY(BlendDataLineStyles, FreestyleLineStyle, BlendData, linestyles, false, false, false)
	COLLECTION_PROPERTY(BlendDataCacheFiles, CacheFile, BlendData, cache_files, false, false, false)
	COLLECTION_PROPERTY(BlendDataPaintCurves, PaintCurve, BlendData, paint_curves, false, false, false)
	COLLECTION_PROPERTY(BlendDataWorkSpaces, WorkSpace, BlendData, workspaces, false, false, false)
	COLLECTION_PROPERTY(BlendDataProbes, LightProbe, BlendData, lightprobes, false, false, false)
	COLLECTION_PROPERTY(BlendDataHairCurves, Curves, BlendData, hair_curves, false, false, false)
	COLLECTION_PROPERTY(BlendDataPointClouds, PointCloud, BlendData, pointclouds, false, false, false)
	COLLECTION_PROPERTY(BlendDataVolumes, Volume, BlendData, volumes, false, false, false)

};

/**************** Domain Settings ****************/

class FluidDomainSettings : public Pointer {
public:
	FluidDomainSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline EffectorWeights effector_weights(void);
	inline Collection effector_group(void);
	inline Collection fluid_group(void);
	inline Collection force_collection(void);
	inline Array<float, 32> density_grid(void);
	inline void density_grid(float values[32]);
	inline Array<float, 32> velocity_grid(void);
	inline void velocity_grid(float values[32]);
	inline Array<float, 32> flame_grid(void);
	inline void flame_grid(float values[32]);
	inline Array<float, 32> color_grid(void);
	inline void color_grid(float values[32]);
	inline Array<float, 32> heat_grid(void);
	inline void heat_grid(float values[32]);
	inline Array<float, 32> temperature_grid(void);
	inline void temperature_grid(float values[32]);
	inline Array<float, 3> start_point(void);
	inline void start_point(float values[3]);
	inline Array<float, 3> cell_size(void);
	inline void cell_size(float values[3]);
	inline Array<int, 3> domain_resolution(void);
	inline void domain_resolution(int values[3]);
	inline int additional_res(void);
	inline void additional_res(int value);
	inline int adapt_margin(void);
	inline void adapt_margin(int value);
	inline float adapt_threshold(void);
	inline void adapt_threshold(float value);
	inline bool use_adaptive_domain(void);
	inline void use_adaptive_domain(bool value);
	inline int resolution_max(void);
	inline void resolution_max(int value);
	inline bool use_collision_border_front(void);
	inline void use_collision_border_front(bool value);
	inline bool use_collision_border_back(void);
	inline void use_collision_border_back(bool value);
	inline bool use_collision_border_right(void);
	inline void use_collision_border_right(bool value);
	inline bool use_collision_border_left(void);
	inline void use_collision_border_left(bool value);
	inline bool use_collision_border_top(void);
	inline void use_collision_border_top(bool value);
	inline bool use_collision_border_bottom(void);
	inline void use_collision_border_bottom(bool value);
	inline Array<float, 3> gravity(void);
	inline void gravity(float values[3]);
	enum domain_type_enum {
		domain_type_GAS = 0,
		domain_type_LIQUID = 1,
	};
	inline domain_type_enum domain_type(void);
	inline void domain_type(domain_type_enum value);
	inline bool delete_in_obstacle(void);
	inline void delete_in_obstacle(bool value);
	inline float alpha(void);
	inline void alpha(float value);
	inline float beta(void);
	inline void beta(float value);
	inline int dissolve_speed(void);
	inline void dissolve_speed(int value);
	inline float vorticity(void);
	inline void vorticity(float value);
	enum highres_sampling_enum {
		highres_sampling_FULLSAMPLE = 2,
		highres_sampling_LINEAR = 1,
		highres_sampling_NEAREST = 0,
	};
	inline highres_sampling_enum highres_sampling(void);
	inline void highres_sampling(highres_sampling_enum value);
	inline bool use_dissolve_smoke(void);
	inline void use_dissolve_smoke(bool value);
	inline bool use_dissolve_smoke_log(void);
	inline void use_dissolve_smoke_log(bool value);
	inline float burning_rate(void);
	inline void burning_rate(float value);
	inline float flame_smoke(void);
	inline void flame_smoke(float value);
	inline float flame_vorticity(void);
	inline void flame_vorticity(float value);
	inline float flame_ignition(void);
	inline void flame_ignition(float value);
	inline float flame_max_temp(void);
	inline void flame_max_temp(float value);
	inline Array<float, 3> flame_smoke_color(void);
	inline void flame_smoke_color(float values[3]);
	inline float noise_strength(void);
	inline void noise_strength(float value);
	inline float noise_pos_scale(void);
	inline void noise_pos_scale(float value);
	inline float noise_time_anim(void);
	inline void noise_time_anim(float value);
	inline int noise_scale(void);
	inline void noise_scale(int value);
	inline bool use_noise(void);
	inline void use_noise(bool value);
	enum simulation_method_enum {
		simulation_method_FLIP = 1,
		simulation_method_APIC = 2,
	};
	inline simulation_method_enum simulation_method(void);
	inline void simulation_method(simulation_method_enum value);
	inline float flip_ratio(void);
	inline void flip_ratio(float value);
	inline float particle_randomness(void);
	inline void particle_randomness(float value);
	inline int particle_number(void);
	inline void particle_number(int value);
	inline int particle_min(void);
	inline void particle_min(int value);
	inline int particle_max(void);
	inline void particle_max(int value);
	inline float particle_radius(void);
	inline void particle_radius(float value);
	inline float particle_band_width(void);
	inline void particle_band_width(float value);
	inline bool use_flip_particles(void);
	inline void use_flip_particles(bool value);
	inline bool use_fractions(void);
	inline void use_fractions(bool value);
	inline float fractions_threshold(void);
	inline void fractions_threshold(float value);
	inline float fractions_distance(void);
	inline void fractions_distance(float value);
	inline int sys_particle_maximum(void);
	inline void sys_particle_maximum(int value);
	inline bool use_viscosity(void);
	inline void use_viscosity(bool value);
	inline float viscosity_value(void);
	inline void viscosity_value(float value);
	inline bool use_diffusion(void);
	inline void use_diffusion(bool value);
	inline float surface_tension(void);
	inline void surface_tension(float value);
	inline float viscosity_base(void);
	inline void viscosity_base(float value);
	inline int viscosity_exponent(void);
	inline void viscosity_exponent(int value);
	inline float mesh_concave_upper(void);
	inline void mesh_concave_upper(float value);
	inline float mesh_concave_lower(void);
	inline void mesh_concave_lower(float value);
	inline int mesh_smoothen_pos(void);
	inline void mesh_smoothen_pos(int value);
	inline int mesh_smoothen_neg(void);
	inline void mesh_smoothen_neg(int value);
	inline int mesh_scale(void);
	inline void mesh_scale(int value);
	enum mesh_generator_enum {
		mesh_generator_IMPROVED = 0,
		mesh_generator_UNION = 1,
	};
	inline mesh_generator_enum mesh_generator(void);
	inline void mesh_generator(mesh_generator_enum value);
	inline bool use_mesh(void);
	inline void use_mesh(bool value);
	inline bool use_speed_vectors(void);
	inline void use_speed_vectors(bool value);
	inline float mesh_particle_radius(void);
	inline void mesh_particle_radius(float value);
	inline float sndparticle_potential_min_wavecrest(void);
	inline void sndparticle_potential_min_wavecrest(float value);
	inline float sndparticle_potential_max_wavecrest(void);
	inline void sndparticle_potential_max_wavecrest(float value);
	inline float sndparticle_potential_min_trappedair(void);
	inline void sndparticle_potential_min_trappedair(float value);
	inline float sndparticle_potential_max_trappedair(void);
	inline void sndparticle_potential_max_trappedair(float value);
	inline float sndparticle_potential_min_energy(void);
	inline void sndparticle_potential_min_energy(float value);
	inline float sndparticle_potential_max_energy(void);
	inline void sndparticle_potential_max_energy(float value);
	inline int sndparticle_sampling_wavecrest(void);
	inline void sndparticle_sampling_wavecrest(int value);
	inline int sndparticle_sampling_trappedair(void);
	inline void sndparticle_sampling_trappedair(int value);
	inline float sndparticle_bubble_buoyancy(void);
	inline void sndparticle_bubble_buoyancy(float value);
	inline float sndparticle_bubble_drag(void);
	inline void sndparticle_bubble_drag(float value);
	inline float sndparticle_life_min(void);
	inline void sndparticle_life_min(float value);
	inline float sndparticle_life_max(void);
	inline void sndparticle_life_max(float value);
	enum sndparticle_boundary_enum {
		sndparticle_boundary_DELETE = 0,
		sndparticle_boundary_PUSHOUT = 1,
	};
	inline sndparticle_boundary_enum sndparticle_boundary(void);
	inline void sndparticle_boundary(sndparticle_boundary_enum value);
	enum sndparticle_combined_export_enum {
		sndparticle_combined_export_OFF = 0,
		sndparticle_combined_export_SPRAY_FOAM = 1,
		sndparticle_combined_export_SPRAY_BUBBLES = 2,
		sndparticle_combined_export_FOAM_BUBBLES = 3,
		sndparticle_combined_export_SPRAY_FOAM_BUBBLES = 4,
	};
	inline sndparticle_combined_export_enum sndparticle_combined_export(void);
	inline void sndparticle_combined_export(sndparticle_combined_export_enum value);
	inline int sndparticle_potential_radius(void);
	inline void sndparticle_potential_radius(int value);
	inline int sndparticle_update_radius(void);
	inline void sndparticle_update_radius(int value);
	inline int particle_scale(void);
	inline void particle_scale(int value);
	inline bool use_spray_particles(void);
	inline void use_spray_particles(bool value);
	inline bool use_bubble_particles(void);
	inline void use_bubble_particles(bool value);
	inline bool use_foam_particles(void);
	inline void use_foam_particles(bool value);
	inline bool use_tracer_particles(void);
	inline void use_tracer_particles(bool value);
	inline float guide_alpha(void);
	inline void guide_alpha(float value);
	inline int guide_beta(void);
	inline void guide_beta(int value);
	inline float guide_vel_factor(void);
	inline void guide_vel_factor(float value);
	enum guide_source_enum {
		guide_source_DOMAIN = 0,
		guide_source_EFFECTOR = 1,
	};
	inline guide_source_enum guide_source(void);
	inline void guide_source(guide_source_enum value);
	inline Object guide_parent(void);
	inline bool use_guide(void);
	inline void use_guide(bool value);
	inline int cache_frame_start(void);
	inline void cache_frame_start(int value);
	inline int cache_frame_end(void);
	inline void cache_frame_end(int value);
	inline int cache_frame_offset(void);
	inline void cache_frame_offset(int value);
	inline int cache_frame_pause_data(void);
	inline void cache_frame_pause_data(int value);
	inline int cache_frame_pause_noise(void);
	inline void cache_frame_pause_noise(int value);
	inline int cache_frame_pause_mesh(void);
	inline void cache_frame_pause_mesh(int value);
	inline int cache_frame_pause_particles(void);
	inline void cache_frame_pause_particles(int value);
	inline int cache_frame_pause_guide(void);
	inline void cache_frame_pause_guide(int value);
	enum cache_mesh_format_enum {
		cache_mesh_format_UNI = 1,
		cache_mesh_format_OPENVDB = 2,
		cache_mesh_format_RAW = 4,
	};
	inline cache_mesh_format_enum cache_mesh_format(void);
	inline void cache_mesh_format(cache_mesh_format_enum value);
	enum cache_data_format_enum {
		cache_data_format_UNI = 1,
		cache_data_format_OPENVDB = 2,
		cache_data_format_RAW = 4,
	};
	inline cache_data_format_enum cache_data_format(void);
	inline void cache_data_format(cache_data_format_enum value);
	enum cache_particle_format_enum {
		cache_particle_format_UNI = 1,
		cache_particle_format_OPENVDB = 2,
		cache_particle_format_RAW = 4,
	};
	inline cache_particle_format_enum cache_particle_format(void);
	inline void cache_particle_format(cache_particle_format_enum value);
	enum cache_noise_format_enum {
		cache_noise_format_UNI = 1,
		cache_noise_format_OPENVDB = 2,
		cache_noise_format_RAW = 4,
	};
	inline cache_noise_format_enum cache_noise_format(void);
	inline void cache_noise_format(cache_noise_format_enum value);
	enum cache_type_enum {
		cache_type_REPLAY = 0,
		cache_type_MODULAR = 1,
		cache_type_ALL = 2,
	};
	inline cache_type_enum cache_type(void);
	inline void cache_type(cache_type_enum value);
	inline bool cache_resumable(void);
	inline void cache_resumable(bool value);
	inline std::string cache_directory(void);
	inline void cache_directory(const std::string& value);
	inline bool is_cache_baking_data(void);
	inline void is_cache_baking_data(bool value);
	inline bool has_cache_baked_data(void);
	inline void has_cache_baked_data(bool value);
	inline bool is_cache_baking_noise(void);
	inline void is_cache_baking_noise(bool value);
	inline bool has_cache_baked_noise(void);
	inline void has_cache_baked_noise(bool value);
	inline bool is_cache_baking_mesh(void);
	inline void is_cache_baking_mesh(bool value);
	inline bool has_cache_baked_mesh(void);
	inline void has_cache_baked_mesh(bool value);
	inline bool is_cache_baking_particles(void);
	inline void is_cache_baking_particles(bool value);
	inline bool has_cache_baked_particles(void);
	inline void has_cache_baked_particles(bool value);
	inline bool is_cache_baking_guide(void);
	inline void is_cache_baking_guide(bool value);
	inline bool has_cache_baked_guide(void);
	inline void has_cache_baked_guide(bool value);
	inline bool is_cache_baking_any(void);
	inline void is_cache_baking_any(bool value);
	inline bool has_cache_baked_any(void);
	inline void has_cache_baked_any(bool value);
	inline bool export_manta_script(void);
	inline void export_manta_script(bool value);
	enum openvdb_cache_compress_type_enum {
		openvdb_cache_compress_type_ZIP = 1,
		openvdb_cache_compress_type_BLOSC = 0,
		openvdb_cache_compress_type_NONE = 2,
	};
	inline openvdb_cache_compress_type_enum openvdb_cache_compress_type(void);
	inline void openvdb_cache_compress_type(openvdb_cache_compress_type_enum value);
	enum openvdb_data_depth_enum {
		openvdb_data_depth_NONE = 0,
	};
	inline openvdb_data_depth_enum openvdb_data_depth(void);
	inline void openvdb_data_depth(openvdb_data_depth_enum value);
	inline float time_scale(void);
	inline void time_scale(float value);
	inline bool use_adaptive_timesteps(void);
	inline void use_adaptive_timesteps(bool value);
	inline float cfl_condition(void);
	inline void cfl_condition(float value);
	inline int timesteps_min(void);
	inline void timesteps_min(int value);
	inline int timesteps_max(void);
	inline void timesteps_max(int value);
	inline bool use_slice(void);
	inline void use_slice(bool value);
	enum slice_axis_enum {
		slice_axis_AUTO = 0,
		slice_axis_X = 1,
		slice_axis_Y = 2,
		slice_axis_Z = 3,
	};
	inline slice_axis_enum slice_axis(void);
	inline void slice_axis(slice_axis_enum value);
	inline float slice_per_voxel(void);
	inline void slice_per_voxel(float value);
	inline float slice_depth(void);
	inline void slice_depth(float value);
	inline float display_thickness(void);
	inline void display_thickness(float value);
	enum display_interpolation_enum {
		display_interpolation_LINEAR = 0,
		display_interpolation_CUBIC = 1,
		display_interpolation_CLOSEST = 2,
	};
	inline display_interpolation_enum display_interpolation(void);
	inline void display_interpolation(display_interpolation_enum value);
	inline bool show_gridlines(void);
	inline void show_gridlines(bool value);
	inline bool show_velocity(void);
	inline void show_velocity(bool value);
	enum vector_display_type_enum {
		vector_display_type_NEEDLE = 0,
		vector_display_type_STREAMLINE = 1,
		vector_display_type_MAC = 2,
	};
	inline vector_display_type_enum vector_display_type(void);
	inline void vector_display_type(vector_display_type_enum value);
	enum vector_field_enum {
		vector_field_FLUID_VELOCITY = 0,
		vector_field_GUIDE_VELOCITY = 1,
		vector_field_FORCE = 2,
	};
	inline vector_field_enum vector_field(void);
	inline void vector_field(vector_field_enum value);
	inline bool vector_scale_with_magnitude(void);
	inline void vector_scale_with_magnitude(bool value);
	inline bool vector_show_mac_x(void);
	inline void vector_show_mac_x(bool value);
	inline bool vector_show_mac_y(void);
	inline void vector_show_mac_y(bool value);
	inline bool vector_show_mac_z(void);
	inline void vector_show_mac_z(bool value);
	inline float vector_scale(void);
	inline void vector_scale(float value);
	inline bool use_color_ramp(void);
	inline void use_color_ramp(bool value);
	enum color_ramp_field_enum {
		color_ramp_field_NONE = 0,
	};
	inline color_ramp_field_enum color_ramp_field(void);
	inline void color_ramp_field(color_ramp_field_enum value);
	inline float color_ramp_field_scale(void);
	inline void color_ramp_field_scale(float value);
	inline ColorRamp color_ramp(void);
	inline float clipping(void);
	inline void clipping(float value);
	enum gridlines_color_field_enum {
		gridlines_color_field_NONE = 0,
		gridlines_color_field_FLAGS = 1,
		gridlines_color_field_RANGE = 2,
	};
	inline gridlines_color_field_enum gridlines_color_field(void);
	inline void gridlines_color_field(gridlines_color_field_enum value);
	inline float gridlines_lower_bound(void);
	inline void gridlines_lower_bound(float value);
	inline float gridlines_upper_bound(void);
	inline void gridlines_upper_bound(float value);
	inline Array<float, 4> gridlines_range_color(void);
	inline void gridlines_range_color(float values[4]);
	enum gridlines_cell_filter_enum {
		gridlines_cell_filter_NONE = 0,
		gridlines_cell_filter_FLUID = 1,
		gridlines_cell_filter_OBSTACLE = 2,
		gridlines_cell_filter_EMPTY = 4,
		gridlines_cell_filter_INFLOW = 8,
		gridlines_cell_filter_OUTFLOW = 16,
	};
	inline gridlines_cell_filter_enum gridlines_cell_filter(void);
	inline void gridlines_cell_filter(gridlines_cell_filter_enum value);
	inline float velocity_scale(void);
	inline void velocity_scale(float value);

};

/**************** Flow Settings ****************/

class FluidFlowSettings : public Pointer {
public:
	FluidFlowSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float density(void);
	inline void density(float value);
	inline Array<float, 3> smoke_color(void);
	inline void smoke_color(float values[3]);
	inline float fuel_amount(void);
	inline void fuel_amount(float value);
	inline float temperature(void);
	inline void temperature(float value);
	inline ParticleSystem particle_system(void);
	enum flow_type_enum {
		flow_type_SMOKE = 1,
		flow_type_BOTH = 3,
		flow_type_FIRE = 2,
		flow_type_LIQUID = 4,
	};
	inline flow_type_enum flow_type(void);
	inline void flow_type(flow_type_enum value);
	enum flow_behavior_enum {
		flow_behavior_INFLOW = 0,
		flow_behavior_OUTFLOW = 1,
		flow_behavior_GEOMETRY = 2,
	};
	inline flow_behavior_enum flow_behavior(void);
	inline void flow_behavior(flow_behavior_enum value);
	enum flow_source_enum {
		flow_source_NONE = 0,
	};
	inline flow_source_enum flow_source(void);
	inline void flow_source(flow_source_enum value);
	inline bool use_absolute(void);
	inline void use_absolute(bool value);
	inline bool use_initial_velocity(void);
	inline void use_initial_velocity(bool value);
	inline float velocity_factor(void);
	inline void velocity_factor(float value);
	inline float velocity_normal(void);
	inline void velocity_normal(float value);
	inline float velocity_random(void);
	inline void velocity_random(float value);
	inline Array<float, 3> velocity_coord(void);
	inline void velocity_coord(float values[3]);
	inline float volume_density(void);
	inline void volume_density(float value);
	inline float surface_distance(void);
	inline void surface_distance(float value);
	inline bool use_plane_init(void);
	inline void use_plane_init(bool value);
	inline float particle_size(void);
	inline void particle_size(float value);
	inline bool use_particle_size(void);
	inline void use_particle_size(bool value);
	inline bool use_inflow(void);
	inline void use_inflow(bool value);
	inline int subframes(void);
	inline void subframes(int value);
	inline std::string density_vertex_group(void);
	inline void density_vertex_group(const std::string& value);
	inline bool use_texture(void);
	inline void use_texture(bool value);
	enum texture_map_type_enum {
		texture_map_type_AUTO = 0,
		texture_map_type_UV = 1,
	};
	inline texture_map_type_enum texture_map_type(void);
	inline void texture_map_type(texture_map_type_enum value);
	inline std::string uv_layer(void);
	inline void uv_layer(const std::string& value);
	inline Texture noise_texture(void);
	inline float texture_size(void);
	inline void texture_size(float value);
	inline float texture_offset(void);
	inline void texture_offset(float value);

};

/**************** Effector Settings ****************/

class FluidEffectorSettings : public Pointer {
public:
	FluidEffectorSettings(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum effector_type_enum {
		effector_type_COLLISION = 0,
		effector_type_GUIDE = 1,
	};
	inline effector_type_enum effector_type(void);
	inline void effector_type(effector_type_enum value);
	inline float surface_distance(void);
	inline void surface_distance(float value);
	inline bool use_plane_init(void);
	inline void use_plane_init(bool value);
	inline float velocity_factor(void);
	inline void velocity_factor(float value);
	enum guide_mode_enum {
		guide_mode_MAXIMUM = 0,
		guide_mode_MINIMUM = 1,
		guide_mode_OVERRIDE = 2,
		guide_mode_AVERAGED = 3,
	};
	inline guide_mode_enum guide_mode(void);
	inline void guide_mode(guide_mode_enum value);
	inline bool use_effector(void);
	inline void use_effector(bool value);
	inline int subframes(void);
	inline void subframes(int value);

};

/**************** Material ****************/

class Material : public ID {
public:
	Material(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		texture_paint_images(ptr_arg),
		texture_paint_slots(ptr_arg)
		{}

	enum surface_render_method_enum {
		surface_render_method_DITHERED = 0,
		surface_render_method_BLENDED = 1,
	};
	inline surface_render_method_enum surface_render_method(void);
	inline void surface_render_method(surface_render_method_enum value);
	enum displacement_method_enum {
		displacement_method_BUMP = 0,
		displacement_method_DISPLACEMENT = 1,
		displacement_method_BOTH = 2,
	};
	inline displacement_method_enum displacement_method(void);
	inline void displacement_method(displacement_method_enum value);
	enum blend_method_enum {
		blend_method_OPAQUE = 0,
		blend_method_CLIP = 3,
		blend_method_HASHED = 4,
		blend_method_BLEND = 5,
	};
	inline blend_method_enum blend_method(void);
	inline void blend_method(blend_method_enum value);
	inline float alpha_threshold(void);
	inline void alpha_threshold(float value);
	inline bool use_transparency_overlap(void);
	inline void use_transparency_overlap(bool value);
	inline bool show_transparent_back(void);
	inline void show_transparent_back(bool value);
	inline bool use_backface_culling(void);
	inline void use_backface_culling(bool value);
	inline bool use_backface_culling_shadow(void);
	inline void use_backface_culling_shadow(bool value);
	inline bool use_backface_culling_lightprobe_volume(void);
	inline void use_backface_culling_lightprobe_volume(bool value);
	inline bool use_transparent_shadow(void);
	inline void use_transparent_shadow(bool value);
	inline bool use_raytrace_refraction(void);
	inline void use_raytrace_refraction(bool value);
	inline bool use_screen_refraction(void);
	inline void use_screen_refraction(bool value);
	inline bool use_sss_translucency(void);
	inline void use_sss_translucency(bool value);
	inline float refraction_depth(void);
	inline void refraction_depth(float value);
	enum thickness_mode_enum {
		thickness_mode_SPHERE = 0,
		thickness_mode_SLAB = 1,
	};
	inline thickness_mode_enum thickness_mode(void);
	inline void thickness_mode(thickness_mode_enum value);
	inline bool use_thickness_from_shadow(void);
	inline void use_thickness_from_shadow(bool value);
	enum volume_intersection_method_enum {
		volume_intersection_method_FAST = 0,
		volume_intersection_method_ACCURATE = 1,
	};
	inline volume_intersection_method_enum volume_intersection_method(void);
	inline void volume_intersection_method(volume_intersection_method_enum value);
	inline float max_vertex_displacement(void);
	inline void max_vertex_displacement(float value);
	enum preview_render_type_enum {
		preview_render_type_FLAT = 0,
		preview_render_type_SPHERE = 1,
		preview_render_type_CUBE = 2,
		preview_render_type_HAIR = 10,
		preview_render_type_SHADERBALL = 3,
		preview_render_type_CLOTH = 12,
		preview_render_type_FLUID = 13,
	};
	inline preview_render_type_enum preview_render_type(void);
	inline void preview_render_type(preview_render_type_enum value);
	inline bool use_preview_world(void);
	inline void use_preview_world(bool value);
	inline int pass_index(void);
	inline void pass_index(int value);
	inline NodeTree node_tree(void);
	inline bool use_nodes(void);
	inline void use_nodes(bool value);
	inline AnimData animation_data(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Image, Material, texture_paint_images, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, TexPaintSlot, Material, texture_paint_slots, false, false, false)
	inline int paint_active_slot(void);
	inline void paint_active_slot(int value);
	inline int paint_clone_slot(void);
	inline void paint_clone_slot(int value);
	inline Array<float, 4> diffuse_color(void);
	inline void diffuse_color(float values[4]);
	inline Array<float, 3> specular_color(void);
	inline void specular_color(float values[3]);
	inline float roughness(void);
	inline void roughness(float value);
	inline float specular_intensity(void);
	inline void specular_intensity(float value);
	inline float metallic(void);
	inline void metallic(float value);
	inline Array<float, 4> line_color(void);
	inline void line_color(float values[4]);
	inline int line_priority(void);
	inline void line_priority(int value);
	inline MaterialGPencilStyle grease_pencil(void);
	inline bool is_grease_pencil(void);
	inline void is_grease_pencil(bool value);
	inline MaterialLineArt lineart(void);

};

/**************** Texture Paint Slot ****************/

class TexPaintSlot : public Pointer {
public:
	TexPaintSlot(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline int icon_value(void);
	inline void icon_value(int value);
	inline std::string uv_layer(void);
	inline void uv_layer(const std::string& value);
	inline bool is_valid(void);
	inline void is_valid(bool value);

};

/**************** Grease Pencil Color ****************/

class MaterialGPencilStyle : public Pointer {
public:
	MaterialGPencilStyle(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);
	inline Array<float, 4> fill_color(void);
	inline void fill_color(float values[4]);
	inline Array<float, 4> mix_color(void);
	inline void mix_color(float values[4]);
	inline float mix_factor(void);
	inline void mix_factor(float value);
	inline float mix_stroke_factor(void);
	inline void mix_stroke_factor(float value);
	inline float texture_angle(void);
	inline void texture_angle(float value);
	inline Array<float, 2> texture_scale(void);
	inline void texture_scale(float values[2]);
	inline Array<float, 2> texture_offset(void);
	inline void texture_offset(float values[2]);
	inline float pixel_size(void);
	inline void pixel_size(float value);
	inline bool hide(void);
	inline void hide(bool value);
	inline bool lock(void);
	inline void lock(bool value);
	inline bool ghost(void);
	inline void ghost(bool value);
	inline bool texture_clamp(void);
	inline void texture_clamp(bool value);
	inline bool flip(void);
	inline void flip(bool value);
	inline bool use_overlap_strokes(void);
	inline void use_overlap_strokes(bool value);
	inline bool use_stroke_holdout(void);
	inline void use_stroke_holdout(bool value);
	inline bool use_fill_holdout(void);
	inline void use_fill_holdout(bool value);
	inline bool show_stroke(void);
	inline void show_stroke(bool value);
	inline bool show_fill(void);
	inline void show_fill(bool value);
	enum alignment_mode_enum {
		alignment_mode_PATH = 0,
		alignment_mode_OBJECT = 1,
		alignment_mode_FIXED = 2,
	};
	inline alignment_mode_enum alignment_mode(void);
	inline void alignment_mode(alignment_mode_enum value);
	inline float alignment_rotation(void);
	inline void alignment_rotation(float value);
	inline int pass_index(void);
	inline void pass_index(int value);
	enum mode_enum {
		mode_LINE = 0,
		mode_DOTS = 1,
		mode_BOX = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	enum stroke_style_enum {
		stroke_style_SOLID = 0,
		stroke_style_TEXTURE = 1,
	};
	inline stroke_style_enum stroke_style(void);
	inline void stroke_style(stroke_style_enum value);
	inline Image stroke_image(void);
	enum fill_style_enum {
		fill_style_SOLID = 0,
		fill_style_GRADIENT = 1,
		fill_style_TEXTURE = 3,
	};
	inline fill_style_enum fill_style(void);
	inline void fill_style(fill_style_enum value);
	enum gradient_type_enum {
		gradient_type_LINEAR = 0,
		gradient_type_RADIAL = 1,
	};
	inline gradient_type_enum gradient_type(void);
	inline void gradient_type(gradient_type_enum value);
	inline Image fill_image(void);
	inline bool is_stroke_visible(void);
	inline void is_stroke_visible(bool value);
	inline bool is_fill_visible(void);
	inline void is_fill_visible(bool value);

};

/**************** Material Line Art ****************/

class MaterialLineArt : public Pointer {
public:
	MaterialLineArt(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_material_mask(void);
	inline void use_material_mask(bool value);
	inline Array<bool, 8> use_material_mask_bits(void);
	inline void use_material_mask_bits(bool values[8]);
	inline int mat_occlusion(void);
	inline void mat_occlusion(int value);
	inline int intersection_priority(void);
	inline void intersection_priority(int value);
	inline bool use_intersection_priority_override(void);
	inline void use_intersection_priority_override(bool value);

};

/**************** Mesh ****************/

class Mesh : public ID {
public:
	Mesh(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		vertices(ptr_arg),
		edges(ptr_arg),
		loops(ptr_arg),
		polygons(ptr_arg),
		vertex_normals(ptr_arg),
		polygon_normals(ptr_arg),
		corner_normals(ptr_arg),
		loop_triangles(ptr_arg),
		loop_triangle_polygons(ptr_arg),
		uv_layers(ptr_arg),
		vertex_colors(ptr_arg),
		skin_vertices(ptr_arg),
		attributes(ptr_arg),
		color_attributes(ptr_arg),
		materials(ptr_arg)
		{}

	COLLECTION_PROPERTY(MeshVertices, MeshVertex, Mesh, vertices, true, true, false)
	COLLECTION_PROPERTY(MeshEdges, MeshEdge, Mesh, edges, true, true, false)
	COLLECTION_PROPERTY(MeshLoops, MeshLoop, Mesh, loops, true, true, false)
	COLLECTION_PROPERTY(MeshPolygons, MeshPolygon, Mesh, polygons, true, true, false)
	enum normals_domain_enum {
		normals_domain_POINT = 1,
		normals_domain_FACE = 0,
		normals_domain_CORNER = 2,
	};
	inline normals_domain_enum normals_domain(void);
	inline void normals_domain(normals_domain_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshNormalValue, Mesh, vertex_normals, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshNormalValue, Mesh, polygon_normals, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshNormalValue, Mesh, corner_normals, true, true, false)
	COLLECTION_PROPERTY(MeshLoopTriangles, MeshLoopTriangle, Mesh, loop_triangles, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ReadOnlyInteger, Mesh, loop_triangle_polygons, true, true, false)
	inline Mesh texture_mesh(void);
	COLLECTION_PROPERTY(UVLoopLayers, MeshUVLoopLayer, Mesh, uv_layers, true, true, true)
	inline MeshUVLoopLayer uv_layer_clone(void);
	inline int uv_layer_clone_index(void);
	inline void uv_layer_clone_index(int value);
	inline MeshUVLoopLayer uv_layer_stencil(void);
	inline int uv_layer_stencil_index(void);
	inline void uv_layer_stencil_index(int value);
	COLLECTION_PROPERTY(LoopColors, MeshLoopColorLayer, Mesh, vertex_colors, true, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshSkinVertexLayer, Mesh, skin_vertices, true, true, true)
	COLLECTION_PROPERTY(AttributeGroupMesh, Attribute, Mesh, attributes, true, false, true)
	COLLECTION_PROPERTY(AttributeGroupMesh, Attribute, Mesh, color_attributes, true, false, false)
	inline float remesh_voxel_size(void);
	inline void remesh_voxel_size(float value);
	inline float remesh_voxel_adaptivity(void);
	inline void remesh_voxel_adaptivity(float value);
	inline bool use_remesh_fix_poles(void);
	inline void use_remesh_fix_poles(bool value);
	inline bool use_remesh_preserve_volume(void);
	inline void use_remesh_preserve_volume(bool value);
	inline bool use_remesh_preserve_attributes(void);
	inline void use_remesh_preserve_attributes(bool value);
	enum remesh_mode_enum {
		remesh_mode_VOXEL = 0,
		remesh_mode_QUAD = 1,
	};
	inline remesh_mode_enum remesh_mode(void);
	inline void remesh_mode(remesh_mode_enum value);
	inline bool use_mirror_x(void);
	inline void use_mirror_x(bool value);
	inline bool use_mirror_y(void);
	inline void use_mirror_y(bool value);
	inline bool use_mirror_z(void);
	inline void use_mirror_z(bool value);
	inline bool use_mirror_vertex_groups(void);
	inline void use_mirror_vertex_groups(bool value);
	inline bool has_custom_normals(void);
	inline void has_custom_normals(bool value);
	inline Mesh texco_mesh(void);
	inline Key shape_keys(void);
	inline bool use_auto_texspace(void);
	inline void use_auto_texspace(bool value);
	inline bool use_mirror_topology(void);
	inline void use_mirror_topology(bool value);
	inline bool use_paint_bone_selection(void);
	inline void use_paint_bone_selection(bool value);
	inline bool use_paint_mask(void);
	inline void use_paint_mask(bool value);
	inline bool use_paint_mask_vertex(void);
	inline void use_paint_mask_vertex(bool value);
	inline int total_vert_sel(void);
	inline void total_vert_sel(int value);
	inline int total_edge_sel(void);
	inline void total_edge_sel(int value);
	inline int total_face_sel(void);
	inline void total_face_sel(int value);
	inline bool is_editmode(void);
	inline void is_editmode(bool value);
	inline AnimData animation_data(void);
	inline bool auto_texspace(void);
	inline void auto_texspace(bool value);
	inline Array<float, 3> texspace_location(void);
	inline void texspace_location(float values[3]);
	inline Array<float, 3> texspace_size(void);
	inline void texspace_size(float values[3]);
	COLLECTION_PROPERTY(IDMaterials, Material, Mesh, materials, true, true, true)

	inline void transform(float matrix[16], bool shape_keys);
	inline void flip_normals();
	inline void set_sharp_from_angle(float angle);
	inline void split_faces();
	inline void calc_tangents(const char * uvmap);
	inline void free_tangents();
	inline void calc_loop_triangles();
	inline void calc_smooth_groups(bool use_bitflags, bool use_boundary_vertices_for_bitflags, int *poly_groups_len, int **poly_groups, int *groups);
	inline void normals_split_custom_set(int normals_len, float *normals);
	inline void normals_split_custom_set_from_vertices(int normals_len, float *normals);
	inline void update(Context C, bool calc_edges, bool calc_edges_loose);
	inline void update_gpu_tag();
	inline const char * unit_test_compare(Mesh& mesh, float threshold);
	inline void clear_geometry();
	inline bool validate(bool verbose, bool clean_customdata);
	inline bool validate_material_indices();
	inline void count_selected_items(int result[3]);
};

/**************** Mesh Normal Vector ****************/

class MeshNormalValue : public Pointer {
public:
	MeshNormalValue(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> vector(void);
	inline void vector(float values[3]);

};

/**************** Read-only Integer ****************/

class ReadOnlyInteger : public Pointer {
public:
	ReadOnlyInteger(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int value(void);
	inline void value(int value);

};

/**************** Mesh Skin Vertex Layer ****************/

class MeshSkinVertexLayer : public Pointer {
public:
	MeshSkinVertexLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshSkinVertex, MeshSkinVertexLayer, data, true, true, false)

};

/**************** Skin Vertex ****************/

class MeshSkinVertex : public Pointer {
public:
	MeshSkinVertex(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 2> radius(void);
	inline void radius(float values[2]);
	inline bool use_root(void);
	inline void use_root(bool value);
	inline bool use_loose(void);
	inline void use_loose(bool value);

};

/**************** Mesh Vertex ****************/

class MeshVertex : public Pointer {
public:
	MeshVertex(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		groups(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline bool select(void);
	inline void select(bool value);
	inline bool hide(void);
	inline void hide(bool value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, VertexGroupElement, MeshVertex, groups, false, false, false)
	inline int index(void);
	inline void index(int value);
	inline Array<float, 3> undeformed_co(void);
	inline void undeformed_co(float values[3]);

};

/**************** Vertex Group Element ****************/

class VertexGroupElement : public Pointer {
public:
	VertexGroupElement(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int group(void);
	inline void group(int value);
	inline float weight(void);
	inline void weight(float value);

};

/**************** Mesh Edge ****************/

class MeshEdge : public Pointer {
public:
	MeshEdge(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<int, 2> vertices(void);
	inline void vertices(int values[2]);
	inline bool select(void);
	inline void select(bool value);
	inline bool hide(void);
	inline void hide(bool value);
	inline bool use_seam(void);
	inline void use_seam(bool value);
	inline bool use_edge_sharp(void);
	inline void use_edge_sharp(bool value);
	inline bool is_loose(void);
	inline void is_loose(bool value);
	inline bool use_freestyle_mark(void);
	inline void use_freestyle_mark(bool value);
	inline int index(void);
	inline void index(int value);

};

/**************** Mesh Loop Triangle ****************/

class MeshLoopTriangle : public Pointer {
public:
	MeshLoopTriangle(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<int, 3> vertices(void);
	inline void vertices(int values[3]);
	inline Array<int, 3> loops(void);
	inline void loops(int values[3]);
	inline int polygon_index(void);
	inline void polygon_index(int value);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline Array<float, 9> split_normals(void);
	inline void split_normals(float values[9]);
	inline float area(void);
	inline void area(float value);
	inline int index(void);
	inline void index(int value);
	inline int material_index(void);
	inline void material_index(int value);
	inline bool use_smooth(void);
	inline void use_smooth(bool value);

};

/**************** Mesh Loop ****************/

class MeshLoop : public Pointer {
public:
	MeshLoop(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline int vertex_index(void);
	inline void vertex_index(int value);
	inline int edge_index(void);
	inline void edge_index(int value);
	inline int index(void);
	inline void index(int value);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline Array<float, 3> tangent(void);
	inline void tangent(float values[3]);
	inline float bitangent_sign(void);
	inline void bitangent_sign(float value);
	inline Array<float, 3> bitangent(void);
	inline void bitangent(float values[3]);

};

/**************** Mesh Polygon ****************/

class MeshPolygon : public Pointer {
public:
	MeshPolygon(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<int, 3> vertices(void);
	inline void vertices(int values[3]);
	inline int loop_start(void);
	inline void loop_start(int value);
	inline int loop_total(void);
	inline void loop_total(int value);
	inline int material_index(void);
	inline void material_index(int value);
	inline bool select(void);
	inline void select(bool value);
	inline bool hide(void);
	inline void hide(bool value);
	inline bool use_smooth(void);
	inline void use_smooth(bool value);
	inline bool use_freestyle_mark(void);
	inline void use_freestyle_mark(bool value);
	inline Array<float, 3> normal(void);
	inline void normal(float values[3]);
	inline Array<float, 3> center(void);
	inline void center(float values[3]);
	inline float area(void);
	inline void area(float value);
	inline int index(void);
	inline void index(int value);

	inline void flip();
};

/**************** MeshUVLoopLayer ****************/

class MeshUVLoopLayer : public Pointer {
public:
	MeshUVLoopLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg),
		uv(ptr_arg),
		vertex_selection(ptr_arg),
		edge_selection(ptr_arg),
		pin(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshUVLoop, MeshUVLoopLayer, data, true, true, false)
	inline std::string name(void);
	inline void name(const std::string& value);
	inline bool active(void);
	inline void active(bool value);
	inline bool active_render(void);
	inline void active_render(bool value);
	inline bool active_clone(void);
	inline void active_clone(bool value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, Float2AttributeValue, MeshUVLoopLayer, uv, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoolAttributeValue, MeshUVLoopLayer, vertex_selection, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoolAttributeValue, MeshUVLoopLayer, edge_selection, true, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, BoolAttributeValue, MeshUVLoopLayer, pin, true, true, false)

};

/**************** Mesh UV Layer ****************/

class MeshUVLoop : public Pointer {
public:
	MeshUVLoop(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 2> uv(void);
	inline void uv(float values[2]);
	inline bool pin_uv(void);
	inline void pin_uv(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool select_edge(void);
	inline void select_edge(bool value);

};

/**************** Mesh Vertex Color Layer ****************/

class MeshLoopColorLayer : public Pointer {
public:
	MeshLoopColorLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline bool active(void);
	inline void active(bool value);
	inline bool active_render(void);
	inline void active_render(bool value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, MeshLoopColor, MeshLoopColorLayer, data, true, true, false)

};

/**************** Mesh Vertex Color ****************/

class MeshLoopColor : public Pointer {
public:
	MeshLoopColor(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);

};

/**************** Metaball Element ****************/

class MetaElement : public Pointer {
public:
	MetaElement(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	enum type_enum {
		type_BALL = 0,
		type_CAPSULE = 4,
		type_PLANE = 5,
		type_ELLIPSOID = 6,
		type_CUBE = 7,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline Array<float, 3> co(void);
	inline void co(float values[3]);
	inline Array<float, 4> rotation(void);
	inline void rotation(float values[4]);
	inline float radius(void);
	inline void radius(float value);
	inline float size_x(void);
	inline void size_x(float value);
	inline float size_y(void);
	inline void size_y(float value);
	inline float size_z(void);
	inline void size_z(float value);
	inline float stiffness(void);
	inline void stiffness(float value);
	inline bool use_negative(void);
	inline void use_negative(bool value);
	inline bool use_scale_stiffness(void);
	inline void use_scale_stiffness(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool hide(void);
	inline void hide(bool value);

};

/**************** MetaBall ****************/

class MetaBall : public ID {
public:
	MetaBall(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		elements(ptr_arg),
		materials(ptr_arg)
		{}

	COLLECTION_PROPERTY(MetaBallElements, MetaElement, MetaBall, elements, false, true, false)
	enum update_method_enum {
		update_method_UPDATE_ALWAYS = 0,
		update_method_HALFRES = 1,
		update_method_FAST = 2,
		update_method_NEVER = 3,
	};
	inline update_method_enum update_method(void);
	inline void update_method(update_method_enum value);
	inline float resolution(void);
	inline void resolution(float value);
	inline float render_resolution(void);
	inline void render_resolution(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline bool use_auto_texspace(void);
	inline void use_auto_texspace(bool value);
	inline Array<float, 3> texspace_location(void);
	inline void texspace_location(float values[3]);
	inline Array<float, 3> texspace_size(void);
	inline void texspace_size(float values[3]);
	COLLECTION_PROPERTY(IDMaterials, Material, MetaBall, materials, true, true, true)
	inline bool is_editmode(void);
	inline void is_editmode(bool value);
	inline AnimData animation_data(void);

	inline void transform(float matrix[16]);
	inline void update_gpu_tag();
};

/**************** Modifier ****************/

class Modifier : public Pointer {
public:
	Modifier(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum type_enum {
		type_GREASE_PENCIL_VERTEX_WEIGHT_PROXIMITY = 76,
		type_DATA_TRANSFER = 49,
		type_MESH_CACHE = 46,
		type_MESH_SEQUENCE_CACHE = 52,
		type_NORMAL_EDIT = 50,
		type_WEIGHTED_NORMAL = 54,
		type_UV_PROJECT = 15,
		type_UV_WARP = 45,
		type_VERTEX_WEIGHT_EDIT = 36,
		type_VERTEX_WEIGHT_MIX = 37,
		type_VERTEX_WEIGHT_PROXIMITY = 38,
		type_GREASE_PENCIL_COLOR = 63,
		type_GREASE_PENCIL_TINT = 64,
		type_GREASE_PENCIL_OPACITY = 61,
		type_GREASE_PENCIL_VERTEX_WEIGHT_ANGLE = 74,
		type_GREASE_PENCIL_TIME = 80,
		type_GREASE_PENCIL_TEXTURE = 86,
		type_ARRAY = 12,
		type_BEVEL = 24,
		type_BOOLEAN = 11,
		type_BUILD = 4,
		type_DECIMATE = 6,
		type_EDGE_SPLIT = 13,
		type_NODES = 57,
		type_MASK = 27,
		type_MIRROR = 5,
		type_MESH_TO_VOLUME = 58,
		type_MULTIRES = 29,
		type_REMESH = 41,
		type_SCREW = 34,
		type_SKIN = 42,
		type_SOLIDIFY = 33,
		type_SUBSURF = 1,
		type_TRIANGULATE = 44,
		type_VOLUME_TO_MESH = 60,
		type_WELD = 55,
		type_WIREFRAME = 48,
		type_GREASE_PENCIL_ARRAY = 75,
		type_GREASE_PENCIL_BUILD = 84,
		type_GREASE_PENCIL_LENGTH = 73,
		type_LINEART = 78,
		type_GREASE_PENCIL_MIRROR = 68,
		type_GREASE_PENCIL_MULTIPLY = 72,
		type_GREASE_PENCIL_SIMPLIFY = 85,
		type_GREASE_PENCIL_SUBDIV = 62,
		type_GREASE_PENCIL_ENVELOPE = 81,
		type_GREASE_PENCIL_OUTLINE = 82,
		type_ARMATURE = 8,
		type_CAST = 17,
		type_CURVE = 3,
		type_DISPLACE = 14,
		type_HOOK = 9,
		type_LAPLACIANDEFORM = 47,
		type_LATTICE = 2,
		type_MESH_DEFORM = 18,
		type_SHRINKWRAP = 25,
		type_SIMPLE_DEFORM = 28,
		type_SMOOTH = 16,
		type_CORRECTIVE_SMOOTH = 51,
		type_LAPLACIANSMOOTH = 43,
		type_SURFACE_DEFORM = 53,
		type_WARP = 35,
		type_WAVE = 7,
		type_VOLUME_DISPLACE = 59,
		type_GREASE_PENCIL_HOOK = 77,
		type_GREASE_PENCIL_NOISE = 67,
		type_GREASE_PENCIL_OFFSET = 66,
		type_GREASE_PENCIL_SMOOTH = 65,
		type_GREASE_PENCIL_THICKNESS = 69,
		type_GREASE_PENCIL_LATTICE = 70,
		type_GREASE_PENCIL_DASH = 71,
		type_GREASE_PENCIL_ARMATURE = 79,
		type_GREASE_PENCIL_SHRINKWRAP = 83,
		type_CLOTH = 22,
		type_COLLISION = 23,
		type_DYNAMIC_PAINT = 40,
		type_EXPLODE = 21,
		type_FLUID = 56,
		type_OCEAN = 39,
		type_PARTICLE_INSTANCE = 20,
		type_PARTICLE_SYSTEM = 19,
		type_SOFT_BODY = 10,
		type_SURFACE = 30,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_viewport(void);
	inline void show_viewport(bool value);
	inline bool show_render(void);
	inline void show_render(bool value);
	inline bool show_in_editmode(void);
	inline void show_in_editmode(bool value);
	inline bool show_on_cage(void);
	inline void show_on_cage(bool value);
	inline bool show_expanded(void);
	inline void show_expanded(bool value);
	inline bool is_active(void);
	inline void is_active(bool value);
	inline bool use_pin_to_last(void);
	inline void use_pin_to_last(bool value);
	inline bool is_override_data(void);
	inline void is_override_data(bool value);
	inline bool use_apply_on_spline(void);
	inline void use_apply_on_spline(bool value);
	inline float execution_time(void);
	inline void execution_time(float value);
	inline int persistent_uid(void);
	inline void persistent_uid(int value);

};

/**************** Subdivision Surface Modifier ****************/

class SubsurfModifier : public Modifier {
public:
	SubsurfModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum uv_smooth_enum {
		uv_smooth_NONE = 0,
		uv_smooth_PRESERVE_CORNERS = 1,
		uv_smooth_PRESERVE_CORNERS_AND_JUNCTIONS = 2,
		uv_smooth_PRESERVE_CORNERS_JUNCTIONS_AND_CONCAVE = 3,
		uv_smooth_PRESERVE_BOUNDARIES = 4,
		uv_smooth_SMOOTH_ALL = 5,
	};
	inline uv_smooth_enum uv_smooth(void);
	inline void uv_smooth(uv_smooth_enum value);
	inline int quality(void);
	inline void quality(int value);
	enum boundary_smooth_enum {
		boundary_smooth_PRESERVE_CORNERS = 1,
		boundary_smooth_ALL = 0,
	};
	inline boundary_smooth_enum boundary_smooth(void);
	inline void boundary_smooth(boundary_smooth_enum value);
	enum subdivision_type_enum {
		subdivision_type_CATMULL_CLARK = 0,
		subdivision_type_SIMPLE = 1,
	};
	inline subdivision_type_enum subdivision_type(void);
	inline void subdivision_type(subdivision_type_enum value);
	inline int levels(void);
	inline void levels(int value);
	inline int render_levels(void);
	inline void render_levels(int value);
	inline bool show_only_control_edges(void);
	inline void show_only_control_edges(bool value);
	inline bool use_creases(void);
	inline void use_creases(bool value);
	inline bool use_custom_normals(void);
	inline void use_custom_normals(bool value);
	inline bool use_limit_surface(void);
	inline void use_limit_surface(bool value);
	inline bool open_adaptive_subdivision_panel(void);
	inline void open_adaptive_subdivision_panel(bool value);
	inline bool open_advanced_panel(void);
	inline void open_advanced_panel(bool value);

};

/**************** Lattice Modifier ****************/

class LatticeModifier : public Modifier {
public:
	LatticeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline float strength(void);
	inline void strength(float value);

};

/**************** Curve Modifier ****************/

class CurveModifier : public Modifier {
public:
	CurveModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	enum deform_axis_enum {
		deform_axis_POS_X = 1,
		deform_axis_POS_Y = 2,
		deform_axis_POS_Z = 3,
		deform_axis_NEG_X = 4,
		deform_axis_NEG_Y = 5,
		deform_axis_NEG_Z = 6,
	};
	inline deform_axis_enum deform_axis(void);
	inline void deform_axis(deform_axis_enum value);

};

/**************** Build Modifier ****************/

class BuildModifier : public Modifier {
public:
	BuildModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_duration(void);
	inline void frame_duration(float value);
	inline bool use_reverse(void);
	inline void use_reverse(bool value);
	inline bool use_random_order(void);
	inline void use_random_order(bool value);
	inline int seed(void);
	inline void seed(int value);

};

/**************** Mirror Modifier ****************/

class MirrorModifier : public Modifier {
public:
	MirrorModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Array<bool, 3> use_axis(void);
	inline void use_axis(bool values[3]);
	inline Array<bool, 3> use_bisect_axis(void);
	inline void use_bisect_axis(bool values[3]);
	inline Array<bool, 3> use_bisect_flip_axis(void);
	inline void use_bisect_flip_axis(bool values[3]);
	inline bool use_clip(void);
	inline void use_clip(bool value);
	inline bool use_mirror_vertex_groups(void);
	inline void use_mirror_vertex_groups(bool value);
	inline bool use_mirror_merge(void);
	inline void use_mirror_merge(bool value);
	inline bool use_mirror_u(void);
	inline void use_mirror_u(bool value);
	inline bool use_mirror_v(void);
	inline void use_mirror_v(bool value);
	inline bool use_mirror_udim(void);
	inline void use_mirror_udim(bool value);
	inline float mirror_offset_u(void);
	inline void mirror_offset_u(float value);
	inline float mirror_offset_v(void);
	inline void mirror_offset_v(float value);
	inline float offset_u(void);
	inline void offset_u(float value);
	inline float offset_v(void);
	inline void offset_v(float value);
	inline float merge_threshold(void);
	inline void merge_threshold(float value);
	inline float bisect_threshold(void);
	inline void bisect_threshold(float value);
	inline Object mirror_object(void);

};

/**************** Decimate Modifier ****************/

class DecimateModifier : public Modifier {
public:
	DecimateModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum decimate_type_enum {
		decimate_type_COLLAPSE = 0,
		decimate_type_UNSUBDIV = 1,
		decimate_type_DISSOLVE = 2,
	};
	inline decimate_type_enum decimate_type(void);
	inline void decimate_type(decimate_type_enum value);
	inline float ratio(void);
	inline void ratio(float value);
	inline int iterations(void);
	inline void iterations(int value);
	inline float angle_limit(void);
	inline void angle_limit(float value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_collapse_triangulate(void);
	inline void use_collapse_triangulate(bool value);
	inline bool use_symmetry(void);
	inline void use_symmetry(bool value);
	enum symmetry_axis_enum {
		symmetry_axis_X = 0,
		symmetry_axis_Y = 1,
		symmetry_axis_Z = 2,
	};
	inline symmetry_axis_enum symmetry_axis(void);
	inline void symmetry_axis(symmetry_axis_enum value);
	inline float vertex_group_factor(void);
	inline void vertex_group_factor(float value);
	inline bool use_dissolve_boundaries(void);
	inline void use_dissolve_boundaries(bool value);
	enum delimit_enum {
		delimit_NORMAL = 1,
		delimit_MATERIAL = 2,
		delimit_SEAM = 4,
		delimit_SHARP = 8,
		delimit_UV = 16,
	};
	inline delimit_enum delimit(void);
	inline void delimit(delimit_enum value);
	inline int face_count(void);
	inline void face_count(int value);

};

/**************** Wave Modifier ****************/

class WaveModifier : public Modifier {
public:
	WaveModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline bool use_x(void);
	inline void use_x(bool value);
	inline bool use_y(void);
	inline void use_y(bool value);
	inline bool use_cyclic(void);
	inline void use_cyclic(bool value);
	inline bool use_normal(void);
	inline void use_normal(bool value);
	inline bool use_normal_x(void);
	inline void use_normal_x(bool value);
	inline bool use_normal_y(void);
	inline void use_normal_y(bool value);
	inline bool use_normal_z(void);
	inline void use_normal_z(bool value);
	inline float time_offset(void);
	inline void time_offset(float value);
	inline float lifetime(void);
	inline void lifetime(float value);
	inline float damping_time(void);
	inline void damping_time(float value);
	inline float falloff_radius(void);
	inline void falloff_radius(float value);
	inline float start_position_x(void);
	inline void start_position_x(float value);
	inline float start_position_y(void);
	inline void start_position_y(float value);
	inline Object start_position_object(void);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline float speed(void);
	inline void speed(float value);
	inline float height(void);
	inline void height(float value);
	inline float width(void);
	inline void width(float value);
	inline float narrowness(void);
	inline void narrowness(float value);
	inline Texture texture(void);
	enum texture_coords_enum {
		texture_coords_LOCAL = 0,
		texture_coords_GLOBAL = 1,
		texture_coords_OBJECT = 2,
		texture_coords_UV = 3,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline std::string uv_layer(void);
	inline void uv_layer(const std::string& value);
	inline Object texture_coords_object(void);
	inline std::string texture_coords_bone(void);
	inline void texture_coords_bone(const std::string& value);

};

/**************** Armature Modifier ****************/

class ArmatureModifier : public Modifier {
public:
	ArmatureModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline bool use_bone_envelopes(void);
	inline void use_bone_envelopes(bool value);
	inline bool use_vertex_groups(void);
	inline void use_vertex_groups(bool value);
	inline bool use_deform_preserve_volume(void);
	inline void use_deform_preserve_volume(bool value);
	inline bool use_multi_modifier(void);
	inline void use_multi_modifier(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Hook Modifier ****************/

class HookModifier : public Modifier {
public:
	HookModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float strength(void);
	inline void strength(float value);
	enum falloff_type_enum {
		falloff_type_NONE = 0,
		falloff_type_CURVE = 1,
		falloff_type_SMOOTH = 3,
		falloff_type_SPHERE = 7,
		falloff_type_ROOT = 4,
		falloff_type_INVERSE_SQUARE = 8,
		falloff_type_SHARP = 2,
		falloff_type_LINEAR = 5,
		falloff_type_CONSTANT = 6,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline float falloff_radius(void);
	inline void falloff_radius(float value);
	inline CurveMapping falloff_curve(void);
	inline Array<float, 3> center(void);
	inline void center(float values[3]);
	inline Array<float, 16> matrix_inverse(void);
	inline void matrix_inverse(float values[16]);
	inline Object object(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline bool use_falloff_uniform(void);
	inline void use_falloff_uniform(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline Array<int, 64> vertex_indices(void);
	inline void vertex_indices(int values[64]);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

	inline void vertex_indices_set(int indices_len, int *indices);
};

/**************** Soft Body Modifier ****************/

class SoftBodyModifier : public Modifier {
public:
	SoftBodyModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline SoftBodySettings settings(void);
	inline PointCache point_cache(void);

};

/**************** Boolean Modifier ****************/

class BooleanModifier : public Modifier {
public:
	BooleanModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline Collection collection(void);
	enum operation_enum {
		operation_INTERSECT = 0,
		operation_UNION = 1,
		operation_DIFFERENCE = 2,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	enum operand_type_enum {
		operand_type_OBJECT = 2,
		operand_type_COLLECTION = 4,
	};
	inline operand_type_enum operand_type(void);
	inline void operand_type(operand_type_enum value);
	inline float double_threshold(void);
	inline void double_threshold(float value);
	enum solver_enum {
		solver_FAST = 0,
		solver_EXACT = 1,
		solver_MANIFOLD = 2,
	};
	inline solver_enum solver(void);
	inline void solver(solver_enum value);
	inline bool use_self(void);
	inline void use_self(bool value);
	inline bool use_hole_tolerant(void);
	inline void use_hole_tolerant(bool value);
	enum material_mode_enum {
		material_mode_INDEX = 0,
		material_mode_TRANSFER = 1,
	};
	inline material_mode_enum material_mode(void);
	inline void material_mode(material_mode_enum value);
	enum debug_options_enum {
		debug_options_SEPARATE = 1,
		debug_options_NO_DISSOLVE = 2,
		debug_options_NO_CONNECT_REGIONS = 4,
	};
	inline debug_options_enum debug_options(void);
	inline void debug_options(debug_options_enum value);

};

/**************** Array Modifier ****************/

class ArrayModifier : public Modifier {
public:
	ArrayModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum fit_type_enum {
		fit_type_FIXED_COUNT = 0,
		fit_type_FIT_LENGTH = 1,
		fit_type_FIT_CURVE = 2,
	};
	inline fit_type_enum fit_type(void);
	inline void fit_type(fit_type_enum value);
	inline int count(void);
	inline void count(int value);
	inline float fit_length(void);
	inline void fit_length(float value);
	inline Object curve(void);
	inline bool use_constant_offset(void);
	inline void use_constant_offset(bool value);
	inline Array<float, 3> constant_offset_displace(void);
	inline void constant_offset_displace(float values[3]);
	inline bool use_relative_offset(void);
	inline void use_relative_offset(bool value);
	inline Array<float, 3> relative_offset_displace(void);
	inline void relative_offset_displace(float values[3]);
	inline bool use_merge_vertices(void);
	inline void use_merge_vertices(bool value);
	inline bool use_merge_vertices_cap(void);
	inline void use_merge_vertices_cap(bool value);
	inline float merge_threshold(void);
	inline void merge_threshold(float value);
	inline bool use_object_offset(void);
	inline void use_object_offset(bool value);
	inline Object offset_object(void);
	inline Object start_cap(void);
	inline Object end_cap(void);
	inline float offset_u(void);
	inline void offset_u(float value);
	inline float offset_v(void);
	inline void offset_v(float value);

};

/**************** EdgeSplit Modifier ****************/

class EdgeSplitModifier : public Modifier {
public:
	EdgeSplitModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float split_angle(void);
	inline void split_angle(float value);
	inline bool use_edge_angle(void);
	inline void use_edge_angle(bool value);
	inline bool use_edge_sharp(void);
	inline void use_edge_sharp(bool value);

};

/**************** Displace Modifier ****************/

class DisplaceModifier : public Modifier {
public:
	DisplaceModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline float mid_level(void);
	inline void mid_level(float value);
	inline float strength(void);
	inline void strength(float value);
	enum direction_enum {
		direction_X = 0,
		direction_Y = 1,
		direction_Z = 2,
		direction_NORMAL = 3,
		direction_CUSTOM_NORMAL = 5,
		direction_RGB_TO_XYZ = 4,
	};
	inline direction_enum direction(void);
	inline void direction(direction_enum value);
	enum space_enum {
		space_LOCAL = 0,
		space_GLOBAL = 1,
	};
	inline space_enum space(void);
	inline void space(space_enum value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline Texture texture(void);
	enum texture_coords_enum {
		texture_coords_LOCAL = 0,
		texture_coords_GLOBAL = 1,
		texture_coords_OBJECT = 2,
		texture_coords_UV = 3,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline std::string uv_layer(void);
	inline void uv_layer(const std::string& value);
	inline Object texture_coords_object(void);
	inline std::string texture_coords_bone(void);
	inline void texture_coords_bone(const std::string& value);

};

/**************** UV Project Modifier ****************/

class UVProjectModifier : public Modifier {
public:
	UVProjectModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg),
		projectors(ptr_arg)
		{}

	inline std::string uv_layer(void);
	inline void uv_layer(const std::string& value);
	inline int projector_count(void);
	inline void projector_count(int value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, UVProjector, UVProjectModifier, projectors, false, true, false)
	inline float aspect_x(void);
	inline void aspect_x(float value);
	inline float aspect_y(void);
	inline void aspect_y(float value);
	inline float scale_x(void);
	inline void scale_x(float value);
	inline float scale_y(void);
	inline void scale_y(float value);

};

/**************** UVProjector ****************/

class UVProjector : public Pointer {
public:
	UVProjector(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline Object object(void);

};

/**************** Smooth Modifier ****************/

class SmoothModifier : public Modifier {
public:
	SmoothModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline bool use_x(void);
	inline void use_x(bool value);
	inline bool use_y(void);
	inline void use_y(bool value);
	inline bool use_z(void);
	inline void use_z(bool value);
	inline float factor(void);
	inline void factor(float value);
	inline int iterations(void);
	inline void iterations(int value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Corrective Smooth Modifier ****************/

class CorrectiveSmoothModifier : public Modifier {
public:
	CorrectiveSmoothModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float factor(void);
	inline void factor(float value);
	inline int iterations(void);
	inline void iterations(int value);
	inline float scale(void);
	inline void scale(float value);
	enum rest_source_enum {
		rest_source_ORCO = 0,
		rest_source_BIND = 1,
	};
	inline rest_source_enum rest_source(void);
	inline void rest_source(rest_source_enum value);
	enum smooth_type_enum {
		smooth_type_SIMPLE = 0,
		smooth_type_LENGTH_WEIGHTED = 1,
	};
	inline smooth_type_enum smooth_type(void);
	inline void smooth_type(smooth_type_enum value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool is_bind(void);
	inline void is_bind(bool value);
	inline bool use_only_smooth(void);
	inline void use_only_smooth(bool value);
	inline bool use_pin_boundary(void);
	inline void use_pin_boundary(bool value);

};

/**************** Cast Modifier ****************/

class CastModifier : public Modifier {
public:
	CastModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum cast_type_enum {
		cast_type_SPHERE = 0,
		cast_type_CYLINDER = 1,
		cast_type_CUBOID = 2,
	};
	inline cast_type_enum cast_type(void);
	inline void cast_type(cast_type_enum value);
	inline Object object(void);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_x(void);
	inline void use_x(bool value);
	inline bool use_y(void);
	inline void use_y(bool value);
	inline bool use_z(void);
	inline void use_z(bool value);
	inline bool use_radius_as_size(void);
	inline void use_radius_as_size(bool value);
	inline bool use_transform(void);
	inline void use_transform(bool value);
	inline float factor(void);
	inline void factor(float value);
	inline float radius(void);
	inline void radius(float value);
	inline float size(void);
	inline void size(float value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);

};

/**************** MeshDeform Modifier ****************/

class MeshDeformModifier : public Modifier {
public:
	MeshDeformModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline bool is_bound(void);
	inline void is_bound(bool value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline int precision(void);
	inline void precision(int value);
	inline bool use_dynamic_bind(void);
	inline void use_dynamic_bind(bool value);

};

/**************** ParticleSystem Modifier ****************/

class ParticleSystemModifier : public Modifier {
public:
	ParticleSystemModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline ParticleSystem particle_system(void);

};

/**************** ParticleInstance Modifier ****************/

class ParticleInstanceModifier : public Modifier {
public:
	ParticleInstanceModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline int particle_system_index(void);
	inline void particle_system_index(int value);
	inline ParticleSystem particle_system(void);
	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_Z = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	enum space_enum {
		space_LOCAL = 1,
		space_WORLD = 0,
	};
	inline space_enum space(void);
	inline void space(space_enum value);
	inline bool use_normal(void);
	inline void use_normal(bool value);
	inline bool use_children(void);
	inline void use_children(bool value);
	inline bool use_path(void);
	inline void use_path(bool value);
	inline bool show_unborn(void);
	inline void show_unborn(bool value);
	inline bool show_alive(void);
	inline void show_alive(bool value);
	inline bool show_dead(void);
	inline void show_dead(bool value);
	inline bool use_preserve_shape(void);
	inline void use_preserve_shape(bool value);
	inline bool use_size(void);
	inline void use_size(bool value);
	inline float position(void);
	inline void position(float value);
	inline float random_position(void);
	inline void random_position(float value);
	inline float rotation(void);
	inline void rotation(float value);
	inline float random_rotation(void);
	inline void random_rotation(float value);
	inline float particle_amount(void);
	inline void particle_amount(float value);
	inline float particle_offset(void);
	inline void particle_offset(float value);
	inline std::string index_layer_name(void);
	inline void index_layer_name(const std::string& value);
	inline std::string value_layer_name(void);
	inline void value_layer_name(const std::string& value);

};

/**************** Explode Modifier ****************/

class ExplodeModifier : public Modifier {
public:
	ExplodeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline float protect(void);
	inline void protect(float value);
	inline bool use_edge_cut(void);
	inline void use_edge_cut(bool value);
	inline bool show_unborn(void);
	inline void show_unborn(bool value);
	inline bool show_alive(void);
	inline void show_alive(bool value);
	inline bool show_dead(void);
	inline void show_dead(bool value);
	inline bool use_size(void);
	inline void use_size(bool value);
	inline std::string particle_uv(void);
	inline void particle_uv(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Cloth Modifier ****************/

class ClothModifier : public Modifier {
public:
	ClothModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline ClothSettings settings(void);
	inline ClothCollisionSettings collision_settings(void);
	inline ClothSolverResult solver_result(void);
	inline PointCache point_cache(void);
	inline Array<float, 3> hair_grid_min(void);
	inline void hair_grid_min(float values[3]);
	inline Array<float, 3> hair_grid_max(void);
	inline void hair_grid_max(float values[3]);
	inline Array<int, 3> hair_grid_resolution(void);
	inline void hair_grid_resolution(int values[3]);

};

/**************** Collision Modifier ****************/

class CollisionModifier : public Modifier {
public:
	CollisionModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline CollisionSettings settings(void);

};

/**************** Bevel Modifier ****************/

class BevelModifier : public Modifier {
public:
	BevelModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float width(void);
	inline void width(float value);
	inline float width_pct(void);
	inline void width_pct(float value);
	inline int segments(void);
	inline void segments(int value);
	enum affect_enum {
		affect_VERTICES = 0,
		affect_EDGES = 1,
	};
	inline affect_enum affect(void);
	inline void affect(affect_enum value);
	enum limit_method_enum {
		limit_method_NONE = 0,
		limit_method_ANGLE = 8,
		limit_method_WEIGHT = 16,
		limit_method_VGROUP = 32,
	};
	inline limit_method_enum limit_method(void);
	inline void limit_method(limit_method_enum value);
	inline std::string edge_weight(void);
	inline void edge_weight(const std::string& value);
	inline std::string vertex_weight(void);
	inline void vertex_weight(const std::string& value);
	inline float angle_limit(void);
	inline void angle_limit(float value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_clamp_overlap(void);
	inline void use_clamp_overlap(bool value);
	enum offset_type_enum {
		offset_type_OFFSET = 0,
		offset_type_WIDTH = 1,
		offset_type_DEPTH = 2,
		offset_type_PERCENT = 3,
		offset_type_ABSOLUTE = 4,
	};
	inline offset_type_enum offset_type(void);
	inline void offset_type(offset_type_enum value);
	enum profile_type_enum {
		profile_type_SUPERELLIPSE = 0,
		profile_type_CUSTOM = 1,
	};
	inline profile_type_enum profile_type(void);
	inline void profile_type(profile_type_enum value);
	inline float profile(void);
	inline void profile(float value);
	inline int material(void);
	inline void material(int value);
	inline bool loop_slide(void);
	inline void loop_slide(bool value);
	inline bool mark_seam(void);
	inline void mark_seam(bool value);
	inline bool mark_sharp(void);
	inline void mark_sharp(bool value);
	inline bool harden_normals(void);
	inline void harden_normals(bool value);
	enum face_strength_mode_enum {
		face_strength_mode_FSTR_NONE = 0,
		face_strength_mode_FSTR_NEW = 1,
		face_strength_mode_FSTR_AFFECTED = 2,
		face_strength_mode_FSTR_ALL = 3,
	};
	inline face_strength_mode_enum face_strength_mode(void);
	inline void face_strength_mode(face_strength_mode_enum value);
	enum miter_outer_enum {
		miter_outer_MITER_SHARP = 0,
		miter_outer_MITER_PATCH = 1,
		miter_outer_MITER_ARC = 2,
	};
	inline miter_outer_enum miter_outer(void);
	inline void miter_outer(miter_outer_enum value);
	enum miter_inner_enum {
		miter_inner_MITER_SHARP = 0,
		miter_inner_MITER_ARC = 2,
	};
	inline miter_inner_enum miter_inner(void);
	inline void miter_inner(miter_inner_enum value);
	inline float spread(void);
	inline void spread(float value);
	inline CurveProfile custom_profile(void);
	enum vmesh_method_enum {
		vmesh_method_ADJ = 0,
		vmesh_method_CUTOFF = 1,
	};
	inline vmesh_method_enum vmesh_method(void);
	inline void vmesh_method(vmesh_method_enum value);

};

/**************** Shrinkwrap Modifier ****************/

class ShrinkwrapModifier : public Modifier {
public:
	ShrinkwrapModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum wrap_method_enum {
		wrap_method_NEAREST_SURFACEPOINT = 0,
		wrap_method_PROJECT = 1,
		wrap_method_NEAREST_VERTEX = 2,
		wrap_method_TARGET_PROJECT = 3,
	};
	inline wrap_method_enum wrap_method(void);
	inline void wrap_method(wrap_method_enum value);
	enum wrap_mode_enum {
		wrap_mode_ON_SURFACE = 0,
		wrap_mode_INSIDE = 1,
		wrap_mode_OUTSIDE = 2,
		wrap_mode_OUTSIDE_SURFACE = 3,
		wrap_mode_ABOVE_SURFACE = 4,
	};
	inline wrap_mode_enum wrap_mode(void);
	inline void wrap_mode(wrap_mode_enum value);
	enum cull_face_enum {
		cull_face_OFF = 0,
		cull_face_FRONT = 8,
		cull_face_BACK = 16,
	};
	inline cull_face_enum cull_face(void);
	inline void cull_face(cull_face_enum value);
	inline Object target(void);
	inline Object auxiliary_target(void);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline float offset(void);
	inline void offset(float value);
	inline float project_limit(void);
	inline void project_limit(float value);
	inline bool use_project_x(void);
	inline void use_project_x(bool value);
	inline bool use_project_y(void);
	inline void use_project_y(bool value);
	inline bool use_project_z(void);
	inline void use_project_z(bool value);
	inline int subsurf_levels(void);
	inline void subsurf_levels(int value);
	inline bool use_negative_direction(void);
	inline void use_negative_direction(bool value);
	inline bool use_positive_direction(void);
	inline void use_positive_direction(bool value);
	inline bool use_invert_cull(void);
	inline void use_invert_cull(bool value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Mask Modifier ****************/

class MaskModifier : public Modifier {
public:
	MaskModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum mode_enum {
		mode_VERTEX_GROUP = 0,
		mode_ARMATURE = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Object armature(void);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_smooth(void);
	inline void use_smooth(bool value);
	inline float threshold(void);
	inline void threshold(float value);

};

/**************** SimpleDeform Modifier ****************/

class SimpleDeformModifier : public Modifier {
public:
	SimpleDeformModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum deform_method_enum {
		deform_method_TWIST = 1,
		deform_method_BEND = 2,
		deform_method_TAPER = 3,
		deform_method_STRETCH = 4,
	};
	inline deform_method_enum deform_method(void);
	inline void deform_method(deform_method_enum value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	enum deform_axis_enum {
		deform_axis_X = 0,
		deform_axis_Y = 1,
		deform_axis_Z = 2,
	};
	inline deform_axis_enum deform_axis(void);
	inline void deform_axis(deform_axis_enum value);
	inline Object origin(void);
	inline float factor(void);
	inline void factor(float value);
	inline float angle(void);
	inline void angle(float value);
	inline Array<float, 2> limits(void);
	inline void limits(float values[2]);
	inline bool lock_x(void);
	inline void lock_x(bool value);
	inline bool lock_y(void);
	inline void lock_y(bool value);
	inline bool lock_z(void);
	inline void lock_z(bool value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Warp Modifier ****************/

class WarpModifier : public Modifier {
public:
	WarpModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object_from(void);
	inline std::string bone_from(void);
	inline void bone_from(const std::string& value);
	inline Object object_to(void);
	inline std::string bone_to(void);
	inline void bone_to(const std::string& value);
	inline float strength(void);
	inline void strength(float value);
	enum falloff_type_enum {
		falloff_type_NONE = 0,
		falloff_type_CURVE = 1,
		falloff_type_SMOOTH = 3,
		falloff_type_SPHERE = 7,
		falloff_type_ROOT = 4,
		falloff_type_INVERSE_SQUARE = 8,
		falloff_type_SHARP = 2,
		falloff_type_LINEAR = 5,
		falloff_type_CONSTANT = 6,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline float falloff_radius(void);
	inline void falloff_radius(float value);
	inline CurveMapping falloff_curve(void);
	inline bool use_volume_preserve(void);
	inline void use_volume_preserve(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline Texture texture(void);
	enum texture_coords_enum {
		texture_coords_LOCAL = 0,
		texture_coords_GLOBAL = 1,
		texture_coords_OBJECT = 2,
		texture_coords_UV = 3,
	};
	inline texture_coords_enum texture_coords(void);
	inline void texture_coords(texture_coords_enum value);
	inline std::string uv_layer(void);
	inline void uv_layer(const std::string& value);
	inline Object texture_coords_object(void);
	inline std::string texture_coords_bone(void);
	inline void texture_coords_bone(const std::string& value);

};

/**************** Multires Modifier ****************/

class MultiresModifier : public Modifier {
public:
	MultiresModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum uv_smooth_enum {
		uv_smooth_NONE = 0,
		uv_smooth_PRESERVE_CORNERS = 1,
		uv_smooth_PRESERVE_CORNERS_AND_JUNCTIONS = 2,
		uv_smooth_PRESERVE_CORNERS_JUNCTIONS_AND_CONCAVE = 3,
		uv_smooth_PRESERVE_BOUNDARIES = 4,
		uv_smooth_SMOOTH_ALL = 5,
	};
	inline uv_smooth_enum uv_smooth(void);
	inline void uv_smooth(uv_smooth_enum value);
	inline int quality(void);
	inline void quality(int value);
	enum boundary_smooth_enum {
		boundary_smooth_PRESERVE_CORNERS = 1,
		boundary_smooth_ALL = 0,
	};
	inline boundary_smooth_enum boundary_smooth(void);
	inline void boundary_smooth(boundary_smooth_enum value);
	inline int levels(void);
	inline void levels(int value);
	inline int sculpt_levels(void);
	inline void sculpt_levels(int value);
	inline int render_levels(void);
	inline void render_levels(int value);
	inline int total_levels(void);
	inline void total_levels(int value);
	inline bool is_external(void);
	inline void is_external(bool value);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline bool show_only_control_edges(void);
	inline void show_only_control_edges(bool value);
	inline bool use_creases(void);
	inline void use_creases(bool value);
	inline bool use_custom_normals(void);
	inline void use_custom_normals(bool value);
	inline bool use_sculpt_base_mesh(void);
	inline void use_sculpt_base_mesh(bool value);

};

/**************** Surface Modifier ****************/

class SurfaceModifier : public Modifier {
public:
	SurfaceModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}


};

/**************** Fluid Modifier ****************/

class FluidModifier : public Modifier {
public:
	FluidModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline FluidDomainSettings domain_settings(void);
	inline FluidFlowSettings flow_settings(void);
	inline FluidEffectorSettings effector_settings(void);
	enum fluid_type_enum {
		fluid_type_NONE = 0,
		fluid_type_DOMAIN = 1,
		fluid_type_FLOW = 2,
		fluid_type_EFFECTOR = 4,
	};
	inline fluid_type_enum fluid_type(void);
	inline void fluid_type(fluid_type_enum value);

};

/**************** Solidify Modifier ****************/

class SolidifyModifier : public Modifier {
public:
	SolidifyModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum solidify_mode_enum {
		solidify_mode_EXTRUDE = 0,
		solidify_mode_NON_MANIFOLD = 1,
	};
	inline solidify_mode_enum solidify_mode(void);
	inline void solidify_mode(solidify_mode_enum value);
	inline float thickness(void);
	inline void thickness(float value);
	inline float thickness_clamp(void);
	inline void thickness_clamp(float value);
	inline bool use_thickness_angle_clamp(void);
	inline void use_thickness_angle_clamp(bool value);
	inline float thickness_vertex_group(void);
	inline void thickness_vertex_group(float value);
	inline float offset(void);
	inline void offset(float value);
	inline float edge_crease_inner(void);
	inline void edge_crease_inner(float value);
	inline float edge_crease_outer(void);
	inline void edge_crease_outer(float value);
	inline float edge_crease_rim(void);
	inline void edge_crease_rim(float value);
	inline int material_offset(void);
	inline void material_offset(int value);
	inline int material_offset_rim(void);
	inline void material_offset_rim(int value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline std::string shell_vertex_group(void);
	inline void shell_vertex_group(const std::string& value);
	inline std::string rim_vertex_group(void);
	inline void rim_vertex_group(const std::string& value);
	inline bool use_rim(void);
	inline void use_rim(bool value);
	inline bool use_even_offset(void);
	inline void use_even_offset(bool value);
	inline bool use_quality_normals(void);
	inline void use_quality_normals(bool value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_flat_faces(void);
	inline void use_flat_faces(bool value);
	inline bool use_flip_normals(void);
	inline void use_flip_normals(bool value);
	inline bool use_rim_only(void);
	inline void use_rim_only(bool value);
	enum nonmanifold_thickness_mode_enum {
		nonmanifold_thickness_mode_FIXED = 0,
		nonmanifold_thickness_mode_EVEN = 1,
		nonmanifold_thickness_mode_CONSTRAINTS = 2,
	};
	inline nonmanifold_thickness_mode_enum nonmanifold_thickness_mode(void);
	inline void nonmanifold_thickness_mode(nonmanifold_thickness_mode_enum value);
	enum nonmanifold_boundary_mode_enum {
		nonmanifold_boundary_mode_NONE = 0,
		nonmanifold_boundary_mode_ROUND = 1,
		nonmanifold_boundary_mode_FLAT = 2,
	};
	inline nonmanifold_boundary_mode_enum nonmanifold_boundary_mode(void);
	inline void nonmanifold_boundary_mode(nonmanifold_boundary_mode_enum value);
	inline float nonmanifold_merge_threshold(void);
	inline void nonmanifold_merge_threshold(float value);
	inline float bevel_convex(void);
	inline void bevel_convex(float value);

};

/**************** Screw Modifier ****************/

class ScrewModifier : public Modifier {
public:
	ScrewModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline int steps(void);
	inline void steps(int value);
	inline int render_steps(void);
	inline void render_steps(int value);
	inline int iterations(void);
	inline void iterations(int value);
	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_Z = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	inline float angle(void);
	inline void angle(float value);
	inline float screw_offset(void);
	inline void screw_offset(float value);
	inline float merge_threshold(void);
	inline void merge_threshold(float value);
	inline bool use_normal_flip(void);
	inline void use_normal_flip(bool value);
	inline bool use_normal_calculate(void);
	inline void use_normal_calculate(bool value);
	inline bool use_object_screw_offset(void);
	inline void use_object_screw_offset(bool value);
	inline bool use_merge_vertices(void);
	inline void use_merge_vertices(bool value);
	inline bool use_smooth_shade(void);
	inline void use_smooth_shade(bool value);
	inline bool use_stretch_u(void);
	inline void use_stretch_u(bool value);
	inline bool use_stretch_v(void);
	inline void use_stretch_v(bool value);

};

/**************** UVWarp Modifier ****************/

class UVWarpModifier : public Modifier {
public:
	UVWarpModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum axis_u_enum {
		axis_u_X = 0,
		axis_u_Y = 1,
		axis_u_Z = 2,
	};
	inline axis_u_enum axis_u(void);
	inline void axis_u(axis_u_enum value);
	enum axis_v_enum {
		axis_v_X = 0,
		axis_v_Y = 1,
		axis_v_Z = 2,
	};
	inline axis_v_enum axis_v(void);
	inline void axis_v(axis_v_enum value);
	inline Array<float, 2> center(void);
	inline void center(float values[2]);
	inline Array<float, 2> offset(void);
	inline void offset(float values[2]);
	inline Array<float, 2> scale(void);
	inline void scale(float values[2]);
	inline float rotation(void);
	inline void rotation(float value);
	inline Object object_from(void);
	inline std::string bone_from(void);
	inline void bone_from(const std::string& value);
	inline Object object_to(void);
	inline std::string bone_to(void);
	inline void bone_to(const std::string& value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline std::string uv_layer(void);
	inline void uv_layer(const std::string& value);

};

/**************** WeightVG Edit Modifier ****************/

class VertexWeightEditModifier : public Modifier {
public:
	VertexWeightEditModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	enum falloff_type_enum {
		falloff_type_LINEAR = 0,
		falloff_type_CURVE = 1,
		falloff_type_SHARP = 2,
		falloff_type_SMOOTH = 3,
		falloff_type_ROOT = 4,
		falloff_type_ICON_SPHERECURVE = 7,
		falloff_type_RANDOM = 8,
		falloff_type_STEP = 9,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline bool invert_falloff(void);
	inline void invert_falloff(bool value);
	inline bool normalize(void);
	inline void normalize(bool value);
	inline CurveMapping map_curve(void);
	inline bool use_add(void);
	inline void use_add(bool value);
	inline bool use_remove(void);
	inline void use_remove(bool value);
	inline float default_weight(void);
	inline void default_weight(float value);
	inline float add_threshold(void);
	inline void add_threshold(float value);
	inline float remove_threshold(void);
	inline void remove_threshold(float value);
	inline float mask_constant(void);
	inline void mask_constant(float value);
	inline std::string mask_vertex_group(void);
	inline void mask_vertex_group(const std::string& value);
	inline bool invert_mask_vertex_group(void);
	inline void invert_mask_vertex_group(bool value);
	inline Texture mask_texture(void);
	enum mask_tex_use_channel_enum {
		mask_tex_use_channel_INT = 1,
		mask_tex_use_channel_RED = 2,
		mask_tex_use_channel_GREEN = 3,
		mask_tex_use_channel_BLUE = 4,
		mask_tex_use_channel_HUE = 5,
		mask_tex_use_channel_SAT = 6,
		mask_tex_use_channel_VAL = 7,
		mask_tex_use_channel_ALPHA = 8,
	};
	inline mask_tex_use_channel_enum mask_tex_use_channel(void);
	inline void mask_tex_use_channel(mask_tex_use_channel_enum value);
	enum mask_tex_mapping_enum {
		mask_tex_mapping_LOCAL = 0,
		mask_tex_mapping_GLOBAL = 1,
		mask_tex_mapping_OBJECT = 2,
		mask_tex_mapping_UV = 3,
	};
	inline mask_tex_mapping_enum mask_tex_mapping(void);
	inline void mask_tex_mapping(mask_tex_mapping_enum value);
	inline std::string mask_tex_uv_layer(void);
	inline void mask_tex_uv_layer(const std::string& value);
	inline Object mask_tex_map_object(void);
	inline std::string mask_tex_map_bone(void);
	inline void mask_tex_map_bone(const std::string& value);

};

/**************** WeightVG Mix Modifier ****************/

class VertexWeightMixModifier : public Modifier {
public:
	VertexWeightMixModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group_a(void);
	inline void vertex_group_a(const std::string& value);
	inline std::string vertex_group_b(void);
	inline void vertex_group_b(const std::string& value);
	inline bool invert_vertex_group_a(void);
	inline void invert_vertex_group_a(bool value);
	inline bool invert_vertex_group_b(void);
	inline void invert_vertex_group_b(bool value);
	inline float default_weight_a(void);
	inline void default_weight_a(float value);
	inline float default_weight_b(void);
	inline void default_weight_b(float value);
	enum mix_mode_enum {
		mix_mode_SET = 1,
		mix_mode_ADD = 2,
		mix_mode_SUB = 3,
		mix_mode_MUL = 4,
		mix_mode_DIV = 5,
		mix_mode_DIF = 6,
		mix_mode_AVG = 7,
		mix_mode_MIN = 8,
		mix_mode_MAX = 9,
	};
	inline mix_mode_enum mix_mode(void);
	inline void mix_mode(mix_mode_enum value);
	enum mix_set_enum {
		mix_set_ALL = 1,
		mix_set_A = 2,
		mix_set_B = 3,
		mix_set_OR = 4,
		mix_set_AND = 5,
	};
	inline mix_set_enum mix_set(void);
	inline void mix_set(mix_set_enum value);
	inline bool normalize(void);
	inline void normalize(bool value);
	inline float mask_constant(void);
	inline void mask_constant(float value);
	inline std::string mask_vertex_group(void);
	inline void mask_vertex_group(const std::string& value);
	inline bool invert_mask_vertex_group(void);
	inline void invert_mask_vertex_group(bool value);
	inline Texture mask_texture(void);
	enum mask_tex_use_channel_enum {
		mask_tex_use_channel_INT = 1,
		mask_tex_use_channel_RED = 2,
		mask_tex_use_channel_GREEN = 3,
		mask_tex_use_channel_BLUE = 4,
		mask_tex_use_channel_HUE = 5,
		mask_tex_use_channel_SAT = 6,
		mask_tex_use_channel_VAL = 7,
		mask_tex_use_channel_ALPHA = 8,
	};
	inline mask_tex_use_channel_enum mask_tex_use_channel(void);
	inline void mask_tex_use_channel(mask_tex_use_channel_enum value);
	enum mask_tex_mapping_enum {
		mask_tex_mapping_LOCAL = 0,
		mask_tex_mapping_GLOBAL = 1,
		mask_tex_mapping_OBJECT = 2,
		mask_tex_mapping_UV = 3,
	};
	inline mask_tex_mapping_enum mask_tex_mapping(void);
	inline void mask_tex_mapping(mask_tex_mapping_enum value);
	inline std::string mask_tex_uv_layer(void);
	inline void mask_tex_uv_layer(const std::string& value);
	inline Object mask_tex_map_object(void);
	inline std::string mask_tex_map_bone(void);
	inline void mask_tex_map_bone(const std::string& value);

};

/**************** WeightVG Proximity Modifier ****************/

class VertexWeightProximityModifier : public Modifier {
public:
	VertexWeightProximityModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	enum proximity_mode_enum {
		proximity_mode_OBJECT = 1,
		proximity_mode_GEOMETRY = 2,
	};
	inline proximity_mode_enum proximity_mode(void);
	inline void proximity_mode(proximity_mode_enum value);
	enum proximity_geometry_enum {
		proximity_geometry_VERTEX = 1,
		proximity_geometry_EDGE = 2,
		proximity_geometry_FACE = 4,
	};
	inline proximity_geometry_enum proximity_geometry(void);
	inline void proximity_geometry(proximity_geometry_enum value);
	inline Object target(void);
	inline float min_dist(void);
	inline void min_dist(float value);
	inline float max_dist(void);
	inline void max_dist(float value);
	enum falloff_type_enum {
		falloff_type_LINEAR = 0,
		falloff_type_CURVE = 1,
		falloff_type_SHARP = 2,
		falloff_type_SMOOTH = 3,
		falloff_type_ROOT = 4,
		falloff_type_ICON_SPHERECURVE = 7,
		falloff_type_RANDOM = 8,
		falloff_type_STEP = 9,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline bool invert_falloff(void);
	inline void invert_falloff(bool value);
	inline bool normalize(void);
	inline void normalize(bool value);
	inline CurveMapping map_curve(void);
	inline float mask_constant(void);
	inline void mask_constant(float value);
	inline std::string mask_vertex_group(void);
	inline void mask_vertex_group(const std::string& value);
	inline bool invert_mask_vertex_group(void);
	inline void invert_mask_vertex_group(bool value);
	inline Texture mask_texture(void);
	enum mask_tex_use_channel_enum {
		mask_tex_use_channel_INT = 1,
		mask_tex_use_channel_RED = 2,
		mask_tex_use_channel_GREEN = 3,
		mask_tex_use_channel_BLUE = 4,
		mask_tex_use_channel_HUE = 5,
		mask_tex_use_channel_SAT = 6,
		mask_tex_use_channel_VAL = 7,
		mask_tex_use_channel_ALPHA = 8,
	};
	inline mask_tex_use_channel_enum mask_tex_use_channel(void);
	inline void mask_tex_use_channel(mask_tex_use_channel_enum value);
	enum mask_tex_mapping_enum {
		mask_tex_mapping_LOCAL = 0,
		mask_tex_mapping_GLOBAL = 1,
		mask_tex_mapping_OBJECT = 2,
		mask_tex_mapping_UV = 3,
	};
	inline mask_tex_mapping_enum mask_tex_mapping(void);
	inline void mask_tex_mapping(mask_tex_mapping_enum value);
	inline std::string mask_tex_uv_layer(void);
	inline void mask_tex_uv_layer(const std::string& value);
	inline Object mask_tex_map_object(void);
	inline std::string mask_tex_map_bone(void);
	inline void mask_tex_map_bone(const std::string& value);

};

/**************** Dynamic Paint Modifier ****************/

class DynamicPaintModifier : public Modifier {
public:
	DynamicPaintModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline DynamicPaintCanvasSettings canvas_settings(void);
	inline DynamicPaintBrushSettings brush_settings(void);
	enum ui_type_enum {
		ui_type_CANVAS = 1,
		ui_type_BRUSH = 2,
	};
	inline ui_type_enum ui_type(void);
	inline void ui_type(ui_type_enum value);

};

/**************** Ocean Modifier ****************/

class OceanModifier : public Modifier {
public:
	OceanModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum geometry_mode_enum {
		geometry_mode_GENERATE = 0,
		geometry_mode_DISPLACE = 1,
	};
	inline geometry_mode_enum geometry_mode(void);
	inline void geometry_mode(geometry_mode_enum value);
	inline float size(void);
	inline void size(float value);
	inline int repeat_x(void);
	inline void repeat_x(int value);
	inline int repeat_y(void);
	inline void repeat_y(int value);
	inline bool use_normals(void);
	inline void use_normals(bool value);
	inline bool use_foam(void);
	inline void use_foam(bool value);
	inline bool use_spray(void);
	inline void use_spray(bool value);
	inline bool invert_spray(void);
	inline void invert_spray(bool value);
	inline std::string spray_layer_name(void);
	inline void spray_layer_name(const std::string& value);
	inline int resolution(void);
	inline void resolution(int value);
	inline int viewport_resolution(void);
	inline void viewport_resolution(int value);
	inline int spatial_size(void);
	inline void spatial_size(int value);
	inline float wind_velocity(void);
	inline void wind_velocity(float value);
	inline float damping(void);
	inline void damping(float value);
	inline float wave_scale_min(void);
	inline void wave_scale_min(float value);
	inline float wave_alignment(void);
	inline void wave_alignment(float value);
	inline float wave_direction(void);
	inline void wave_direction(float value);
	inline float wave_scale(void);
	inline void wave_scale(float value);
	inline float depth(void);
	inline void depth(float value);
	inline float foam_coverage(void);
	inline void foam_coverage(float value);
	inline float bake_foam_fade(void);
	inline void bake_foam_fade(float value);
	inline std::string foam_layer_name(void);
	inline void foam_layer_name(const std::string& value);
	inline float choppiness(void);
	inline void choppiness(float value);
	inline float time(void);
	inline void time(float value);
	enum spectrum_enum {
		spectrum_PHILLIPS = 0,
		spectrum_PIERSON_MOSKOWITZ = 1,
		spectrum_JONSWAP = 2,
		spectrum_TEXEL_MARSEN_ARSLOE = 3,
	};
	inline spectrum_enum spectrum(void);
	inline void spectrum(spectrum_enum value);
	inline float fetch_jonswap(void);
	inline void fetch_jonswap(float value);
	inline float sharpen_peak_jonswap(void);
	inline void sharpen_peak_jonswap(float value);
	inline int random_seed(void);
	inline void random_seed(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline bool is_cached(void);
	inline void is_cached(bool value);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);

};

/**************** Remesh Modifier ****************/

class RemeshModifier : public Modifier {
public:
	RemeshModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum mode_enum {
		mode_BLOCKS = 0,
		mode_SMOOTH = 1,
		mode_SHARP = 2,
		mode_VOXEL = 3,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline float scale(void);
	inline void scale(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline int octree_depth(void);
	inline void octree_depth(int value);
	inline float sharpness(void);
	inline void sharpness(float value);
	inline float voxel_size(void);
	inline void voxel_size(float value);
	inline float adaptivity(void);
	inline void adaptivity(float value);
	inline bool use_remove_disconnected(void);
	inline void use_remove_disconnected(bool value);
	inline bool use_smooth_shade(void);
	inline void use_smooth_shade(bool value);

};

/**************** Skin Modifier ****************/

class SkinModifier : public Modifier {
public:
	SkinModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float branch_smoothing(void);
	inline void branch_smoothing(float value);
	inline bool use_smooth_shade(void);
	inline void use_smooth_shade(bool value);
	inline bool use_x_symmetry(void);
	inline void use_x_symmetry(bool value);
	inline bool use_y_symmetry(void);
	inline void use_y_symmetry(bool value);
	inline bool use_z_symmetry(void);
	inline void use_z_symmetry(bool value);

};

/**************** Laplacian Smooth Modifier ****************/

class LaplacianSmoothModifier : public Modifier {
public:
	LaplacianSmoothModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline bool use_x(void);
	inline void use_x(bool value);
	inline bool use_y(void);
	inline void use_y(bool value);
	inline bool use_z(void);
	inline void use_z(bool value);
	inline bool use_volume_preserve(void);
	inline void use_volume_preserve(bool value);
	inline bool use_normalized(void);
	inline void use_normalized(bool value);
	inline float lambda_factor(void);
	inline void lambda_factor(float value);
	inline float lambda_border(void);
	inline void lambda_border(float value);
	inline int iterations(void);
	inline void iterations(int value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Triangulate Modifier ****************/

class TriangulateModifier : public Modifier {
public:
	TriangulateModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum quad_method_enum {
		quad_method_BEAUTY = 0,
		quad_method_FIXED = 1,
		quad_method_FIXED_ALTERNATE = 2,
		quad_method_SHORTEST_DIAGONAL = 3,
		quad_method_LONGEST_DIAGONAL = 4,
	};
	inline quad_method_enum quad_method(void);
	inline void quad_method(quad_method_enum value);
	enum ngon_method_enum {
		ngon_method_BEAUTY = 0,
		ngon_method_CLIP = 1,
	};
	inline ngon_method_enum ngon_method(void);
	inline void ngon_method(ngon_method_enum value);
	inline int min_vertices(void);
	inline void min_vertices(int value);
	inline bool keep_custom_normals(void);
	inline void keep_custom_normals(bool value);

};

/**************** Cache Modifier ****************/

class MeshCacheModifier : public Modifier {
public:
	MeshCacheModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum cache_format_enum {
		cache_format_MDD = 1,
		cache_format_PC2 = 2,
	};
	inline cache_format_enum cache_format(void);
	inline void cache_format(cache_format_enum value);
	enum interpolation_enum {
		interpolation_NONE = 0,
		interpolation_LINEAR = 1,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	enum time_mode_enum {
		time_mode_FRAME = 0,
		time_mode_TIME = 1,
		time_mode_FACTOR = 2,
	};
	inline time_mode_enum time_mode(void);
	inline void time_mode(time_mode_enum value);
	enum play_mode_enum {
		play_mode_SCENE = 0,
		play_mode_CUSTOM = 1,
	};
	inline play_mode_enum play_mode(void);
	inline void play_mode(play_mode_enum value);
	enum deform_mode_enum {
		deform_mode_OVERWRITE = 0,
		deform_mode_INTEGRATE = 1,
	};
	inline deform_mode_enum deform_mode(void);
	inline void deform_mode(deform_mode_enum value);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	inline float factor(void);
	inline void factor(float value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	enum forward_axis_enum {
		forward_axis_POS_X = 0,
		forward_axis_POS_Y = 1,
		forward_axis_POS_Z = 2,
		forward_axis_NEG_X = 3,
		forward_axis_NEG_Y = 4,
		forward_axis_NEG_Z = 5,
	};
	inline forward_axis_enum forward_axis(void);
	inline void forward_axis(forward_axis_enum value);
	enum up_axis_enum {
		up_axis_POS_X = 0,
		up_axis_POS_Y = 1,
		up_axis_POS_Z = 2,
		up_axis_NEG_X = 3,
		up_axis_NEG_Y = 4,
		up_axis_NEG_Z = 5,
	};
	inline up_axis_enum up_axis(void);
	inline void up_axis(up_axis_enum value);
	inline Array<bool, 3> flip_axis(void);
	inline void flip_axis(bool values[3]);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_scale(void);
	inline void frame_scale(float value);
	inline float eval_frame(void);
	inline void eval_frame(float value);
	inline float eval_time(void);
	inline void eval_time(float value);
	inline float eval_factor(void);
	inline void eval_factor(float value);

};

/**************** Laplacian Deform Modifier ****************/

class LaplacianDeformModifier : public Modifier {
public:
	LaplacianDeformModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline int iterations(void);
	inline void iterations(int value);
	inline bool is_bind(void);
	inline void is_bind(bool value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Weld Modifier ****************/

class WeldModifier : public Modifier {
public:
	WeldModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum mode_enum {
		mode_ALL = 0,
		mode_CONNECTED = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline float merge_threshold(void);
	inline void merge_threshold(float value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool loose_edges(void);
	inline void loose_edges(bool value);

};

/**************** Wireframe Modifier ****************/

class WireframeModifier : public Modifier {
public:
	WireframeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float thickness(void);
	inline void thickness(float value);
	inline float thickness_vertex_group(void);
	inline void thickness_vertex_group(float value);
	inline float offset(void);
	inline void offset(float value);
	inline bool use_replace(void);
	inline void use_replace(bool value);
	inline bool use_boundary(void);
	inline void use_boundary(bool value);
	inline bool use_even_offset(void);
	inline void use_even_offset(bool value);
	inline bool use_relative_offset(void);
	inline void use_relative_offset(bool value);
	inline bool use_crease(void);
	inline void use_crease(bool value);
	inline float crease_weight(void);
	inline void crease_weight(float value);
	inline int material_offset(void);
	inline void material_offset(int value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Data Transfer Modifier ****************/

class DataTransferModifier : public Modifier {
public:
	DataTransferModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline bool use_object_transform(void);
	inline void use_object_transform(bool value);
	inline bool use_vert_data(void);
	inline void use_vert_data(bool value);
	inline bool use_edge_data(void);
	inline void use_edge_data(bool value);
	inline bool use_loop_data(void);
	inline void use_loop_data(bool value);
	inline bool use_poly_data(void);
	inline void use_poly_data(bool value);
	enum data_types_verts_enum {
		data_types_verts_VGROUP_WEIGHTS = 1,
		data_types_verts_BEVEL_WEIGHT_VERT = 8,
		data_types_verts_COLOR_VERTEX = 134283264,
	};
	inline data_types_verts_enum data_types_verts(void);
	inline void data_types_verts(data_types_verts_enum value);
	enum data_types_edges_enum {
		data_types_edges_SHARP_EDGE = 256,
		data_types_edges_SEAM = 512,
		data_types_edges_CREASE = 1024,
		data_types_edges_BEVEL_WEIGHT_EDGE = 2048,
		data_types_edges_FREESTYLE_EDGE = 4096,
	};
	inline data_types_edges_enum data_types_edges(void);
	inline void data_types_edges(data_types_edges_enum value);
	enum data_types_loops_enum {
		data_types_loops_CUSTOM_NORMAL = 131072,
		data_types_loops_COLOR_CORNER = 805306368,
		data_types_loops_UV = 16777216,
	};
	inline data_types_loops_enum data_types_loops(void);
	inline void data_types_loops(data_types_loops_enum value);
	enum data_types_polys_enum {
		data_types_polys_SMOOTH = 33554432,
		data_types_polys_FREESTYLE_FACE = 67108864,
	};
	inline data_types_polys_enum data_types_polys(void);
	inline void data_types_polys(data_types_polys_enum value);
	enum vert_mapping_enum {
		vert_mapping_TOPOLOGY = 251658240,
		vert_mapping_NEAREST = 16777488,
		vert_mapping_EDGE_NEAREST = 16777504,
		vert_mapping_EDGEINTERP_NEAREST = 16778528,
		vert_mapping_POLY_NEAREST = 16777600,
		vert_mapping_POLYINTERP_NEAREST = 16778624,
		vert_mapping_POLYINTERP_VNORPROJ = 16778880,
	};
	inline vert_mapping_enum vert_mapping(void);
	inline void vert_mapping(vert_mapping_enum value);
	enum edge_mapping_enum {
		edge_mapping_TOPOLOGY = 251658240,
		edge_mapping_VERT_NEAREST = 33554704,
		edge_mapping_NEAREST = 33554720,
		edge_mapping_POLY_NEAREST = 33554816,
		edge_mapping_EDGEINTERP_VNORPROJ = 33555984,
	};
	inline edge_mapping_enum edge_mapping(void);
	inline void edge_mapping(edge_mapping_enum value);
	enum loop_mapping_enum {
		loop_mapping_TOPOLOGY = 251658240,
		loop_mapping_NEAREST_NORMAL = 67111248,
		loop_mapping_NEAREST_POLYNOR = 67111312,
		loop_mapping_NEAREST_POLY = 67109248,
		loop_mapping_POLYINTERP_NEAREST = 67110272,
		loop_mapping_POLYINTERP_LNORPROJ = 67110528,
	};
	inline loop_mapping_enum loop_mapping(void);
	inline void loop_mapping(loop_mapping_enum value);
	enum poly_mapping_enum {
		poly_mapping_TOPOLOGY = 251658240,
		poly_mapping_NEAREST = 134218112,
		poly_mapping_NORMAL = 134219904,
		poly_mapping_POLYINTERP_PNORPROJ = 134219392,
	};
	inline poly_mapping_enum poly_mapping(void);
	inline void poly_mapping(poly_mapping_enum value);
	inline bool use_max_distance(void);
	inline void use_max_distance(bool value);
	inline float max_distance(void);
	inline void max_distance(float value);
	inline float ray_radius(void);
	inline void ray_radius(float value);
	inline float islands_precision(void);
	inline void islands_precision(float value);
	enum layers_vgroup_select_src_enum {
		layers_vgroup_select_src_ACTIVE = -1,
		layers_vgroup_select_src_ALL = -2,
		layers_vgroup_select_src_BONE_SELECT = -257,
		layers_vgroup_select_src_BONE_DEFORM = -258,
	};
	inline layers_vgroup_select_src_enum layers_vgroup_select_src(void);
	inline void layers_vgroup_select_src(layers_vgroup_select_src_enum value);
	enum layers_vcol_vert_select_src_enum {
		layers_vcol_vert_select_src_ACTIVE = -1,
		layers_vcol_vert_select_src_ALL = -2,
		layers_vcol_vert_select_src_BONE_SELECT = -257,
		layers_vcol_vert_select_src_BONE_DEFORM = -258,
	};
	inline layers_vcol_vert_select_src_enum layers_vcol_vert_select_src(void);
	inline void layers_vcol_vert_select_src(layers_vcol_vert_select_src_enum value);
	enum layers_vcol_loop_select_src_enum {
		layers_vcol_loop_select_src_ACTIVE = -1,
		layers_vcol_loop_select_src_ALL = -2,
		layers_vcol_loop_select_src_BONE_SELECT = -257,
		layers_vcol_loop_select_src_BONE_DEFORM = -258,
	};
	inline layers_vcol_loop_select_src_enum layers_vcol_loop_select_src(void);
	inline void layers_vcol_loop_select_src(layers_vcol_loop_select_src_enum value);
	enum layers_uv_select_src_enum {
		layers_uv_select_src_ACTIVE = -1,
		layers_uv_select_src_ALL = -2,
		layers_uv_select_src_BONE_SELECT = -257,
		layers_uv_select_src_BONE_DEFORM = -258,
	};
	inline layers_uv_select_src_enum layers_uv_select_src(void);
	inline void layers_uv_select_src(layers_uv_select_src_enum value);
	enum layers_vgroup_select_dst_enum {
		layers_vgroup_select_dst_ACTIVE = -1,
		layers_vgroup_select_dst_NAME = -2,
		layers_vgroup_select_dst_INDEX = -3,
	};
	inline layers_vgroup_select_dst_enum layers_vgroup_select_dst(void);
	inline void layers_vgroup_select_dst(layers_vgroup_select_dst_enum value);
	enum layers_vcol_vert_select_dst_enum {
		layers_vcol_vert_select_dst_ACTIVE = -1,
		layers_vcol_vert_select_dst_NAME = -2,
		layers_vcol_vert_select_dst_INDEX = -3,
	};
	inline layers_vcol_vert_select_dst_enum layers_vcol_vert_select_dst(void);
	inline void layers_vcol_vert_select_dst(layers_vcol_vert_select_dst_enum value);
	enum layers_vcol_loop_select_dst_enum {
		layers_vcol_loop_select_dst_ACTIVE = -1,
		layers_vcol_loop_select_dst_NAME = -2,
		layers_vcol_loop_select_dst_INDEX = -3,
	};
	inline layers_vcol_loop_select_dst_enum layers_vcol_loop_select_dst(void);
	inline void layers_vcol_loop_select_dst(layers_vcol_loop_select_dst_enum value);
	enum layers_uv_select_dst_enum {
		layers_uv_select_dst_ACTIVE = -1,
		layers_uv_select_dst_NAME = -2,
		layers_uv_select_dst_INDEX = -3,
	};
	inline layers_uv_select_dst_enum layers_uv_select_dst(void);
	inline void layers_uv_select_dst(layers_uv_select_dst_enum value);
	enum mix_mode_enum {
		mix_mode_REPLACE = 0,
		mix_mode_ABOVE_THRESHOLD = 1,
		mix_mode_BELOW_THRESHOLD = 2,
		mix_mode_MIX = 16,
		mix_mode_ADD = 17,
		mix_mode_SUB = 18,
		mix_mode_MUL = 19,
	};
	inline mix_mode_enum mix_mode(void);
	inline void mix_mode(mix_mode_enum value);
	inline float mix_factor(void);
	inline void mix_factor(float value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);

};

/**************** Normal Edit Modifier ****************/

class NormalEditModifier : public Modifier {
public:
	NormalEditModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	enum mode_enum {
		mode_RADIAL = 0,
		mode_DIRECTIONAL = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Array<float, 3> offset(void);
	inline void offset(float values[3]);
	enum mix_mode_enum {
		mix_mode_COPY = 0,
		mix_mode_ADD = 1,
		mix_mode_SUB = 2,
		mix_mode_MUL = 3,
	};
	inline mix_mode_enum mix_mode(void);
	inline void mix_mode(mix_mode_enum value);
	inline float mix_factor(void);
	inline void mix_factor(float value);
	inline float mix_limit(void);
	inline void mix_limit(float value);
	inline bool no_polynors_fix(void);
	inline void no_polynors_fix(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline Object target(void);
	inline bool use_direction_parallel(void);
	inline void use_direction_parallel(bool value);

};

/**************** Cache Modifier ****************/

class MeshSequenceCacheModifier : public Modifier {
public:
	MeshSequenceCacheModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline CacheFile cache_file(void);
	inline std::string object_path(void);
	inline void object_path(const std::string& value);
	enum read_data_enum {
		read_data_VERT = 1,
		read_data_POLY = 2,
		read_data_UV = 4,
		read_data_COLOR = 8,
		read_data_ATTRIBUTES = 32,
	};
	inline read_data_enum read_data(void);
	inline void read_data(read_data_enum value);
	inline bool use_vertex_interpolation(void);
	inline void use_vertex_interpolation(bool value);
	inline float velocity_scale(void);
	inline void velocity_scale(float value);

};

/**************** SurfaceDeform Modifier ****************/

class SurfaceDeformModifier : public Modifier {
public:
	SurfaceDeformModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object target(void);
	inline float falloff(void);
	inline void falloff(float value);
	inline bool is_bound(void);
	inline void is_bound(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_sparse_bind(void);
	inline void use_sparse_bind(bool value);
	inline float strength(void);
	inline void strength(float value);

};

/**************** WeightedNormal Modifier ****************/

class WeightedNormalModifier : public Modifier {
public:
	WeightedNormalModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline int weight(void);
	inline void weight(int value);
	enum mode_enum {
		mode_FACE_AREA = 0,
		mode_CORNER_ANGLE = 1,
		mode_FACE_AREA_WITH_ANGLE = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline float thresh(void);
	inline void thresh(float value);
	inline bool keep_sharp(void);
	inline void keep_sharp(bool value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_face_influence(void);
	inline void use_face_influence(bool value);

};

/**************** NodesModifierDataBlock ****************/

class NodesModifierDataBlock : public Pointer {
public:
	NodesModifierDataBlock(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string id_name(void);
	inline void id_name(const std::string& value);
	inline std::string lib_name(void);
	inline void lib_name(const std::string& value);
	inline ID id(void);
	enum id_type_enum {
		id_type_ACTION = 17217,
		id_type_ARMATURE = 21057,
		id_type_BRUSH = 21058,
		id_type_CACHEFILE = 17987,
		id_type_CAMERA = 16707,
		id_type_COLLECTION = 21063,
		id_type_CURVE = 21827,
		id_type_CURVES = 22083,
		id_type_FONT = 18006,
		id_type_GREASEPENCIL = 17479,
		id_type_GREASEPENCIL_V3 = 20551,
		id_type_IMAGE = 19785,
		id_type_KEY = 17739,
		id_type_LATTICE = 21580,
		id_type_LIBRARY = 18764,
		id_type_LIGHT = 16716,
		id_type_LIGHT_PROBE = 20556,
		id_type_LINESTYLE = 21324,
		id_type_MASK = 21325,
		id_type_MATERIAL = 16717,
		id_type_MESH = 17741,
		id_type_META = 16973,
		id_type_MOVIECLIP = 17229,
		id_type_NODETREE = 21582,
		id_type_OBJECT = 16975,
		id_type_PAINTCURVE = 17232,
		id_type_PALETTE = 19536,
		id_type_PARTICLE = 16720,
		id_type_POINTCLOUD = 21584,
		id_type_SCENE = 17235,
		id_type_SCREEN = 21075,
		id_type_SOUND = 20307,
		id_type_SPEAKER = 19283,
		id_type_TEXT = 22612,
		id_type_TEXTURE = 17748,
		id_type_VOLUME = 20310,
		id_type_WINDOWMANAGER = 19799,
		id_type_WORKSPACE = 21335,
		id_type_WORLD = 20311,
	};
	inline id_type_enum id_type(void);
	inline void id_type(id_type_enum value);

};

/**************** Nodes Modifier Bake ****************/

class NodesModifierBake : public Pointer {
public:
	NodesModifierBake(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		data_blocks(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string directory(void);
	inline void directory(const std::string& value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline bool use_custom_simulation_frame_range(void);
	inline void use_custom_simulation_frame_range(bool value);
	inline bool use_custom_path(void);
	inline void use_custom_path(bool value);
	enum bake_target_enum {
		bake_target_INHERIT = 0,
		bake_target_PACKED = 1,
		bake_target_DISK = 2,
	};
	inline bake_target_enum bake_target(void);
	inline void bake_target(bake_target_enum value);
	enum bake_mode_enum {
		bake_mode_ANIMATION = 0,
		bake_mode_STILL = 1,
	};
	inline bake_mode_enum bake_mode(void);
	inline void bake_mode(bake_mode_enum value);
	inline int bake_id(void);
	inline void bake_id(int value);
	inline Node node(void);
	COLLECTION_PROPERTY(NodesModifierBakeDataBlocks, NodesModifierDataBlock, NodesModifierBake, data_blocks, true, true, false)

};

/**************** Nodes Modifier Panel ****************/

class NodesModifierPanel : public Pointer {
public:
	NodesModifierPanel(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_open(void);
	inline void is_open(bool value);

};

/**************** Nodes Modifier Warning ****************/

class NodesModifierWarning : public Pointer {
public:
	NodesModifierWarning(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string message(void);
	inline void message(const std::string& value);
	enum type_enum {
		type_ERROR = 0,
		type_WARNING = 1,
		type_INFO = 2,
	};
	inline type_enum type(void);
	inline void type(type_enum value);

};

/**************** Nodes Modifier ****************/

class NodesModifier : public Modifier {
public:
	NodesModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg),
		bakes(ptr_arg),
		panels(ptr_arg),
		node_warnings(ptr_arg)
		{}

	inline NodeTree node_group(void);
	inline std::string bake_directory(void);
	inline void bake_directory(const std::string& value);
	enum bake_target_enum {
		bake_target_PACKED = 1,
		bake_target_DISK = 2,
	};
	inline bake_target_enum bake_target(void);
	inline void bake_target(bake_target_enum value);
	COLLECTION_PROPERTY(NodesModifierBakes, NodesModifierBake, NodesModifier, bakes, true, true, false)
	COLLECTION_PROPERTY(NodesModifierPanels, NodesModifierPanel, NodesModifier, panels, true, true, false)
	inline bool show_group_selector(void);
	inline void show_group_selector(bool value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, NodesModifierWarning, NodesModifier, node_warnings, true, false, false)
	inline bool open_output_attributes_panel(void);
	inline void open_output_attributes_panel(bool value);
	inline bool open_manage_panel(void);
	inline void open_manage_panel(bool value);
	inline bool open_bake_panel(void);
	inline void open_bake_panel(bool value);
	inline bool open_named_attributes_panel(void);
	inline void open_named_attributes_panel(bool value);
	inline bool open_bake_data_blocks_panel(void);
	inline void open_bake_data_blocks_panel(bool value);
	inline bool open_warnings_panel(void);
	inline void open_warnings_panel(bool value);

};

/**************** Mesh to Volume Modifier ****************/

class MeshToVolumeModifier : public Modifier {
public:
	MeshToVolumeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	enum resolution_mode_enum {
		resolution_mode_VOXEL_AMOUNT = 0,
		resolution_mode_VOXEL_SIZE = 1,
	};
	inline resolution_mode_enum resolution_mode(void);
	inline void resolution_mode(resolution_mode_enum value);
	inline float voxel_size(void);
	inline void voxel_size(float value);
	inline int voxel_amount(void);
	inline void voxel_amount(int value);
	inline float interior_band_width(void);
	inline void interior_band_width(float value);
	inline float density(void);
	inline void density(float value);

};

/**************** Volume Displace Modifier ****************/

class VolumeDisplaceModifier : public Modifier {
public:
	VolumeDisplaceModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline float strength(void);
	inline void strength(float value);
	inline Texture texture(void);
	enum texture_map_mode_enum {
		texture_map_mode_LOCAL = 0,
		texture_map_mode_GLOBAL = 1,
		texture_map_mode_OBJECT = 2,
	};
	inline texture_map_mode_enum texture_map_mode(void);
	inline void texture_map_mode(texture_map_mode_enum value);
	inline Object texture_map_object(void);
	inline Array<float, 3> texture_mid_level(void);
	inline void texture_mid_level(float values[3]);
	inline float texture_sample_radius(void);
	inline void texture_sample_radius(float value);

};

/**************** Volume to Mesh Modifier ****************/

class VolumeToMeshModifier : public Modifier {
public:
	VolumeToMeshModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline Object object(void);
	inline float threshold(void);
	inline void threshold(float value);
	inline float adaptivity(void);
	inline void adaptivity(float value);
	inline bool use_smooth_shade(void);
	inline void use_smooth_shade(bool value);
	inline std::string grid_name(void);
	inline void grid_name(const std::string& value);
	enum resolution_mode_enum {
		resolution_mode_GRID = 0,
		resolution_mode_VOXEL_AMOUNT = 1,
		resolution_mode_VOXEL_SIZE = 2,
	};
	inline resolution_mode_enum resolution_mode(void);
	inline void resolution_mode(resolution_mode_enum value);
	inline float voxel_size(void);
	inline void voxel_size(float value);
	inline int voxel_amount(void);
	inline void voxel_amount(int value);

};

/**************** Grease Pencil Opacity Modifier ****************/

class GreasePencilOpacityModifier : public Modifier {
public:
	GreasePencilOpacityModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_custom_curve(void);
	inline void use_custom_curve(bool value);
	inline CurveMapping custom_curve(void);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	enum color_mode_enum {
		color_mode_BOTH = 2,
		color_mode_STROKE = 0,
		color_mode_FILL = 1,
		color_mode_HARDNESS = 3,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);
	inline float color_factor(void);
	inline void color_factor(float value);
	inline float hardness_factor(void);
	inline void hardness_factor(float value);
	inline bool use_weight_as_factor(void);
	inline void use_weight_as_factor(bool value);
	inline bool use_uniform_opacity(void);
	inline void use_uniform_opacity(bool value);

};

/**************** Subdivision Modifier ****************/

class GreasePencilSubdivModifier : public Modifier {
public:
	GreasePencilSubdivModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline int level(void);
	inline void level(int value);
	enum subdivision_type_enum {
		subdivision_type_CATMULL_CLARK = 0,
		subdivision_type_SIMPLE = 1,
	};
	inline subdivision_type_enum subdivision_type(void);
	inline void subdivision_type(subdivision_type_enum value);

};

/**************** Grease Pencil Color Modifier ****************/

class GreasePencilColorModifier : public Modifier {
public:
	GreasePencilColorModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool use_custom_curve(void);
	inline void use_custom_curve(bool value);
	inline CurveMapping custom_curve(void);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	enum color_mode_enum {
		color_mode_BOTH = 2,
		color_mode_STROKE = 0,
		color_mode_FILL = 1,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);
	inline float hue(void);
	inline void hue(float value);
	inline float saturation(void);
	inline void saturation(float value);
	inline float value(void);
	inline void value(float value);

};

/**************** Grease Pencil Tint Modifier ****************/

class GreasePencilTintModifier : public Modifier {
public:
	GreasePencilTintModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_custom_curve(void);
	inline void use_custom_curve(bool value);
	inline CurveMapping custom_curve(void);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	enum color_mode_enum {
		color_mode_BOTH = 2,
		color_mode_STROKE = 0,
		color_mode_FILL = 1,
	};
	inline color_mode_enum color_mode(void);
	inline void color_mode(color_mode_enum value);
	inline float factor(void);
	inline void factor(float value);
	enum tint_mode_enum {
		tint_mode_UNIFORM = 0,
		tint_mode_GRADIENT = 1,
	};
	inline tint_mode_enum tint_mode(void);
	inline void tint_mode(tint_mode_enum value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	inline ColorRamp color_ramp(void);
	inline Object object(void);
	inline float radius(void);
	inline void radius(float value);
	inline bool use_weight_as_factor(void);
	inline void use_weight_as_factor(bool value);

};

/**************** Smooth Modifier ****************/

class GreasePencilSmoothModifier : public Modifier {
public:
	GreasePencilSmoothModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_custom_curve(void);
	inline void use_custom_curve(bool value);
	inline CurveMapping custom_curve(void);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline float factor(void);
	inline void factor(float value);
	inline bool use_edit_position(void);
	inline void use_edit_position(bool value);
	inline bool use_edit_strength(void);
	inline void use_edit_strength(bool value);
	inline bool use_edit_thickness(void);
	inline void use_edit_thickness(bool value);
	inline bool use_edit_uv(void);
	inline void use_edit_uv(bool value);
	inline int step(void);
	inline void step(int value);
	inline bool use_keep_shape(void);
	inline void use_keep_shape(bool value);
	inline bool use_smooth_ends(void);
	inline void use_smooth_ends(bool value);

};

/**************** Grease Pencil Offset Modifier ****************/

class GreasePencilOffsetModifier : public Modifier {
public:
	GreasePencilOffsetModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool open_general_panel(void);
	inline void open_general_panel(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	enum offset_mode_enum {
		offset_mode_RANDOM = 0,
		offset_mode_LAYER = 1,
		offset_mode_STROKE = 3,
		offset_mode_MATERIAL = 2,
	};
	inline offset_mode_enum offset_mode(void);
	inline void offset_mode(offset_mode_enum value);
	inline Array<float, 3> location(void);
	inline void location(float values[3]);
	inline Array<float, 3> rotation(void);
	inline void rotation(float values[3]);
	inline Array<float, 3> scale(void);
	inline void scale(float values[3]);
	inline Array<float, 3> stroke_location(void);
	inline void stroke_location(float values[3]);
	inline Array<float, 3> stroke_rotation(void);
	inline void stroke_rotation(float values[3]);
	inline Array<float, 3> stroke_scale(void);
	inline void stroke_scale(float values[3]);
	inline int seed(void);
	inline void seed(int value);
	inline int stroke_step(void);
	inline void stroke_step(int value);
	inline int stroke_start_offset(void);
	inline void stroke_start_offset(int value);
	inline bool use_uniform_random_scale(void);
	inline void use_uniform_random_scale(bool value);

};

/**************** Grease Pencil Noise Modifier ****************/

class GreasePencilNoiseModifier : public Modifier {
public:
	GreasePencilNoiseModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_custom_curve(void);
	inline void use_custom_curve(bool value);
	inline CurveMapping custom_curve(void);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline bool open_random_panel(void);
	inline void open_random_panel(bool value);
	inline float factor(void);
	inline void factor(float value);
	inline float factor_strength(void);
	inline void factor_strength(float value);
	inline float factor_thickness(void);
	inline void factor_thickness(float value);
	inline float factor_uvs(void);
	inline void factor_uvs(float value);
	inline bool use_random(void);
	inline void use_random(bool value);
	inline int seed(void);
	inline void seed(int value);
	inline float noise_scale(void);
	inline void noise_scale(float value);
	inline float noise_offset(void);
	inline void noise_offset(float value);
	inline int step(void);
	inline void step(int value);
	enum random_mode_enum {
		random_mode_STEP = 0,
		random_mode_KEYFRAME = 1,
	};
	inline random_mode_enum random_mode(void);
	inline void random_mode(random_mode_enum value);

};

/**************** Grease Pencil Mirror Modifier ****************/

class GreasePencilMirrorModifier : public Modifier {
public:
	GreasePencilMirrorModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline Object object(void);
	inline bool use_axis_x(void);
	inline void use_axis_x(bool value);
	inline bool use_axis_y(void);
	inline void use_axis_y(bool value);
	inline bool use_axis_z(void);
	inline void use_axis_z(bool value);

};

/**************** Grease Pencil Thickness Modifier ****************/

class GreasePencilThickModifierData : public Modifier {
public:
	GreasePencilThickModifierData(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_custom_curve(void);
	inline void use_custom_curve(bool value);
	inline CurveMapping custom_curve(void);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline float thickness(void);
	inline void thickness(float value);
	inline float thickness_factor(void);
	inline void thickness_factor(float value);
	inline bool use_weight_factor(void);
	inline void use_weight_factor(bool value);
	inline bool use_uniform_thickness(void);
	inline void use_uniform_thickness(bool value);

};

/**************** Grease Pencil Lattice Modifier ****************/

class GreasePencilLatticeModifier : public Modifier {
public:
	GreasePencilLatticeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline Object object(void);
	inline float strength(void);
	inline void strength(float value);

};

/**************** Dash Modifier Segment ****************/

class GreasePencilDashModifierSegment : public Pointer {
public:
	GreasePencilDashModifierSegment(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline int dash(void);
	inline void dash(int value);
	inline int gap(void);
	inline void gap(int value);
	inline float radius(void);
	inline void radius(float value);
	inline float opacity(void);
	inline void opacity(float value);
	inline int material_index(void);
	inline void material_index(int value);
	inline bool use_cyclic(void);
	inline void use_cyclic(bool value);

};

/**************** Grease Pencil Dash Modifier ****************/

class GreasePencilDashModifierData : public Modifier {
public:
	GreasePencilDashModifierData(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg),
		segments(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, GreasePencilDashModifierSegment, GreasePencilDashModifierData, segments, false, true, true)
	inline int segment_active_index(void);
	inline void segment_active_index(int value);
	inline int dash_offset(void);
	inline void dash_offset(int value);

};

/**************** Multiply Modifier ****************/

class GreasePencilMultiplyModifier : public Modifier {
public:
	GreasePencilMultiplyModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_fading_panel(void);
	inline void open_fading_panel(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline bool use_fade(void);
	inline void use_fade(bool value);
	inline int duplicates(void);
	inline void duplicates(int value);
	inline float distance(void);
	inline void distance(float value);
	inline float offset(void);
	inline void offset(float value);
	inline float fading_thickness(void);
	inline void fading_thickness(float value);
	inline float fading_opacity(void);
	inline void fading_opacity(float value);
	inline float fading_center(void);
	inline void fading_center(float value);

};

/**************** Length Modifier ****************/

class GreasePencilLengthModifier : public Modifier {
public:
	GreasePencilLengthModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_random_panel(void);
	inline void open_random_panel(bool value);
	inline bool open_curvature_panel(void);
	inline void open_curvature_panel(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline float start_factor(void);
	inline void start_factor(float value);
	inline float end_factor(void);
	inline void end_factor(float value);
	inline float start_length(void);
	inline void start_length(float value);
	inline float end_length(void);
	inline void end_length(float value);
	inline float random_start_factor(void);
	inline void random_start_factor(float value);
	inline float random_end_factor(void);
	inline void random_end_factor(float value);
	inline float random_offset(void);
	inline void random_offset(float value);
	inline bool use_random(void);
	inline void use_random(bool value);
	inline int seed(void);
	inline void seed(int value);
	inline int step(void);
	inline void step(int value);
	inline float overshoot_factor(void);
	inline void overshoot_factor(float value);
	enum mode_enum {
		mode_RELATIVE = 0,
		mode_ABSOLUTE = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool use_curvature(void);
	inline void use_curvature(bool value);
	inline bool invert_curvature(void);
	inline void invert_curvature(bool value);
	inline float point_density(void);
	inline void point_density(float value);
	inline float segment_influence(void);
	inline void segment_influence(float value);
	inline float max_angle(void);
	inline void max_angle(float value);

};

/**************** Weight Modifier Angle ****************/

class GreasePencilWeightAngleModifier : public Modifier {
public:
	GreasePencilWeightAngleModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline std::string target_vertex_group(void);
	inline void target_vertex_group(const std::string& value);
	inline bool use_multiply(void);
	inline void use_multiply(bool value);
	inline bool use_invert_output(void);
	inline void use_invert_output(bool value);
	inline float angle(void);
	inline void angle(float value);
	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_Z = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	enum space_enum {
		space_LOCAL = 0,
		space_WORLD = 1,
	};
	inline space_enum space(void);
	inline void space(space_enum value);
	inline float minimum_weight(void);
	inline void minimum_weight(float value);

};

/**************** Instance Modifier ****************/

class GreasePencilArrayModifier : public Modifier {
public:
	GreasePencilArrayModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_constant_offset_panel(void);
	inline void open_constant_offset_panel(bool value);
	inline bool open_relative_offset_panel(void);
	inline void open_relative_offset_panel(bool value);
	inline bool open_object_offset_panel(void);
	inline void open_object_offset_panel(bool value);
	inline bool open_randomize_panel(void);
	inline void open_randomize_panel(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline int count(void);
	inline void count(int value);
	inline Object offset_object(void);
	inline Array<float, 3> constant_offset(void);
	inline void constant_offset(float values[3]);
	inline Array<float, 3> relative_offset(void);
	inline void relative_offset(float values[3]);
	inline Array<float, 3> random_offset(void);
	inline void random_offset(float values[3]);
	inline Array<float, 3> random_rotation(void);
	inline void random_rotation(float values[3]);
	inline Array<float, 3> random_scale(void);
	inline void random_scale(float values[3]);
	inline int seed(void);
	inline void seed(int value);
	inline int replace_material(void);
	inline void replace_material(int value);
	inline bool use_constant_offset(void);
	inline void use_constant_offset(bool value);
	inline bool use_object_offset(void);
	inline void use_object_offset(bool value);
	inline bool use_relative_offset(void);
	inline void use_relative_offset(bool value);
	inline bool use_uniform_random_scale(void);
	inline void use_uniform_random_scale(bool value);

};

/**************** Weight Modifier Proximity ****************/

class GreasePencilWeightProximityModifier : public Modifier {
public:
	GreasePencilWeightProximityModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline bool use_multiply(void);
	inline void use_multiply(bool value);
	inline bool use_invert_output(void);
	inline void use_invert_output(bool value);
	inline std::string target_vertex_group(void);
	inline void target_vertex_group(const std::string& value);
	inline Object object(void);
	inline float distance_start(void);
	inline void distance_start(float value);
	inline float minimum_weight(void);
	inline void minimum_weight(float value);
	inline float distance_end(void);
	inline void distance_end(float value);

};

/**************** Hook Modifier ****************/

class GreasePencilHookModifier : public Modifier {
public:
	GreasePencilHookModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool use_custom_curve(void);
	inline void use_custom_curve(bool value);
	inline CurveMapping custom_curve(void);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline bool open_falloff_panel(void);
	inline void open_falloff_panel(bool value);
	inline Object object(void);
	inline std::string subtarget(void);
	inline void subtarget(const std::string& value);
	inline float strength(void);
	inline void strength(float value);
	enum falloff_type_enum {
		falloff_type_NONE = 0,
		falloff_type_CURVE = 1,
		falloff_type_SMOOTH = 3,
		falloff_type_SPHERE = 7,
		falloff_type_ROOT = 4,
		falloff_type_INVERSE_SQUARE = 8,
		falloff_type_SHARP = 2,
		falloff_type_LINEAR = 5,
		falloff_type_CONSTANT = 6,
	};
	inline falloff_type_enum falloff_type(void);
	inline void falloff_type(falloff_type_enum value);
	inline float falloff_radius(void);
	inline void falloff_radius(float value);
	inline Array<float, 3> center(void);
	inline void center(float values[3]);
	inline Array<float, 16> matrix_inverse(void);
	inline void matrix_inverse(float values[16]);
	inline bool use_falloff_uniform(void);
	inline void use_falloff_uniform(bool value);

};

/**************** Line Art Modifier ****************/

class GreasePencilLineartModifier : public Modifier {
public:
	GreasePencilLineartModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline bool use_custom_camera(void);
	inline void use_custom_camera(bool value);
	inline bool use_fuzzy_intersections(void);
	inline void use_fuzzy_intersections(bool value);
	inline bool use_fuzzy_all(void);
	inline void use_fuzzy_all(bool value);
	inline bool use_object_instances(void);
	inline void use_object_instances(bool value);
	inline bool use_edge_overlap(void);
	inline void use_edge_overlap(bool value);
	inline bool use_clip_plane_boundaries(void);
	inline void use_clip_plane_boundaries(bool value);
	inline float crease_threshold(void);
	inline void crease_threshold(float value);
	inline float split_angle(void);
	inline void split_angle(float value);
	inline float smooth_tolerance(void);
	inline void smooth_tolerance(float value);
	inline bool use_loose_as_contour(void);
	inline void use_loose_as_contour(bool value);
	inline bool invert_source_vertex_group(void);
	inline void invert_source_vertex_group(bool value);
	inline bool use_output_vertex_group_match_by_name(void);
	inline void use_output_vertex_group_match_by_name(bool value);
	inline bool use_face_mark(void);
	inline void use_face_mark(bool value);
	inline bool use_face_mark_invert(void);
	inline void use_face_mark_invert(bool value);
	inline bool use_face_mark_boundaries(void);
	inline void use_face_mark_boundaries(bool value);
	inline bool use_face_mark_keep_contour(void);
	inline void use_face_mark_keep_contour(bool value);
	inline float chaining_image_threshold(void);
	inline void chaining_image_threshold(float value);
	inline bool use_loose_edge_chain(void);
	inline void use_loose_edge_chain(bool value);
	inline bool use_geometry_space_chain(void);
	inline void use_geometry_space_chain(bool value);
	inline bool use_detail_preserve(void);
	inline void use_detail_preserve(bool value);
	inline bool use_overlap_edge_type_support(void);
	inline void use_overlap_edge_type_support(bool value);
	inline float stroke_depth_offset(void);
	inline void stroke_depth_offset(float value);
	inline bool use_offset_towards_custom_camera(void);
	inline void use_offset_towards_custom_camera(bool value);
	inline Object source_camera(void);
	inline Object light_contour_object(void);
	enum source_type_enum {
		source_type_COLLECTION = 0,
		source_type_OBJECT = 1,
		source_type_SCENE = 2,
	};
	inline source_type_enum source_type(void);
	inline void source_type(source_type_enum value);
	inline Object source_object(void);
	inline Collection source_collection(void);
	inline bool use_contour(void);
	inline void use_contour(bool value);
	inline bool use_loose(void);
	inline void use_loose(bool value);
	inline bool use_crease(void);
	inline void use_crease(bool value);
	inline bool use_material(void);
	inline void use_material(bool value);
	inline bool use_edge_mark(void);
	inline void use_edge_mark(bool value);
	inline bool use_intersection(void);
	inline void use_intersection(bool value);
	inline bool use_light_contour(void);
	inline void use_light_contour(bool value);
	inline bool use_shadow(void);
	inline void use_shadow(bool value);
	enum shadow_region_filtering_enum {
		shadow_region_filtering_NONE = 0,
		shadow_region_filtering_ILLUMINATED = 1,
		shadow_region_filtering_SHADED = 2,
		shadow_region_filtering_ILLUMINATED_ENCLOSED = 3,
	};
	inline shadow_region_filtering_enum shadow_region_filtering(void);
	inline void shadow_region_filtering(shadow_region_filtering_enum value);
	enum silhouette_filtering_enum {
		silhouette_filtering_NONE = 0,
		silhouette_filtering_GROUP = 1,
		silhouette_filtering_INDIVIDUAL = 2,
	};
	inline silhouette_filtering_enum silhouette_filtering(void);
	inline void silhouette_filtering(silhouette_filtering_enum value);
	inline bool use_multiple_levels(void);
	inline void use_multiple_levels(bool value);
	inline int level_start(void);
	inline void level_start(int value);
	inline int level_end(void);
	inline void level_end(int value);
	inline std::string target_layer(void);
	inline void target_layer(const std::string& value);
	inline Material target_material(void);
	inline std::string source_vertex_group(void);
	inline void source_vertex_group(const std::string& value);
	inline std::string vertex_group(void);
	inline void vertex_group(const std::string& value);
	inline bool is_baked(void);
	inline void is_baked(bool value);
	inline bool use_cache(void);
	inline void use_cache(bool value);
	inline float overscan(void);
	inline void overscan(float value);
	inline int thickness(void);
	inline void thickness(int value);
	inline float radius(void);
	inline void radius(float value);
	inline float opacity(void);
	inline void opacity(float value);
	inline bool use_material_mask(void);
	inline void use_material_mask(bool value);
	inline bool use_material_mask_match(void);
	inline void use_material_mask_match(bool value);
	inline Array<bool, 8> use_material_mask_bits(void);
	inline void use_material_mask_bits(bool values[8]);
	inline bool use_intersection_match(void);
	inline void use_intersection_match(bool value);
	inline Array<bool, 8> use_intersection_mask(void);
	inline void use_intersection_mask(bool values[8]);
	inline bool use_crease_on_smooth(void);
	inline void use_crease_on_smooth(bool value);
	inline bool use_crease_on_sharp(void);
	inline void use_crease_on_sharp(bool value);
	inline bool use_image_boundary_trimming(void);
	inline void use_image_boundary_trimming(bool value);
	inline bool use_back_face_culling(void);
	inline void use_back_face_culling(bool value);
	inline float shadow_camera_near(void);
	inline void shadow_camera_near(float value);
	inline float shadow_camera_far(void);
	inline void shadow_camera_far(float value);
	inline float shadow_camera_size(void);
	inline void shadow_camera_size(float value);
	inline bool use_invert_collection(void);
	inline void use_invert_collection(bool value);
	inline bool use_invert_silhouette(void);
	inline void use_invert_silhouette(bool value);

};

/**************** Armature Modifier ****************/

class GreasePencilArmatureModifier : public Modifier {
public:
	GreasePencilArmatureModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline Object object(void);
	inline bool use_bone_envelopes(void);
	inline void use_bone_envelopes(bool value);
	inline bool use_vertex_groups(void);
	inline void use_vertex_groups(bool value);
	inline bool use_deform_preserve_volume(void);
	inline void use_deform_preserve_volume(bool value);

};

/**************** Time Modifier Segment ****************/

class GreasePencilTimeModifierSegment : public Pointer {
public:
	GreasePencilTimeModifierSegment(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline int segment_start(void);
	inline void segment_start(int value);
	inline int segment_end(void);
	inline void segment_end(int value);
	inline int segment_repeat(void);
	inline void segment_repeat(int value);
	enum segment_mode_enum {
		segment_mode_NORMAL = 0,
		segment_mode_REVERSE = 1,
		segment_mode_PINGPONG = 2,
	};
	inline segment_mode_enum segment_mode(void);
	inline void segment_mode(segment_mode_enum value);

};

/**************** Grease Pencil Time Modifier ****************/

class GreasePencilTimeModifier : public Modifier {
public:
	GreasePencilTimeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg),
		segments(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline bool open_custom_range_panel(void);
	inline void open_custom_range_panel(bool value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, GreasePencilTimeModifierSegment, GreasePencilTimeModifier, segments, false, true, true)
	inline int segment_active_index(void);
	inline void segment_active_index(int value);
	enum mode_enum {
		mode_NORMAL = 0,
		mode_REVERSE = 1,
		mode_FIX = 2,
		mode_PINGPONG = 3,
		mode_CHAIN = 4,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline int offset(void);
	inline void offset(int value);
	inline float frame_scale(void);
	inline void frame_scale(float value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);
	inline bool use_keep_loop(void);
	inline void use_keep_loop(bool value);
	inline bool use_custom_frame_range(void);
	inline void use_custom_frame_range(bool value);

};

/**************** Simplify Modifier ****************/

class GreasePencilSimplifyModifier : public Modifier {
public:
	GreasePencilSimplifyModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline float factor(void);
	inline void factor(float value);
	enum mode_enum {
		mode_FIXED = 0,
		mode_ADAPTIVE = 1,
		mode_SAMPLE = 2,
		mode_MERGE = 3,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline int step(void);
	inline void step(int value);
	inline float length(void);
	inline void length(float value);
	inline float sharp_threshold(void);
	inline void sharp_threshold(float value);
	inline float distance(void);
	inline void distance(float value);

};

/**************** Grease Pencil Envelope Modifier ****************/

class GreasePencilEnvelopeModifier : public Modifier {
public:
	GreasePencilEnvelopeModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	enum mode_enum {
		mode_DEFORM = 0,
		mode_SEGMENTS = 1,
		mode_FILLS = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline int spread(void);
	inline void spread(int value);
	inline int mat_nr(void);
	inline void mat_nr(int value);
	inline float thickness(void);
	inline void thickness(float value);
	inline float strength(void);
	inline void strength(float value);
	inline int skip(void);
	inline void skip(int value);

};

/**************** Outline Modifier ****************/

class GreasePencilOutlineModifier : public Modifier {
public:
	GreasePencilOutlineModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline int thickness(void);
	inline void thickness(int value);
	inline float sample_length(void);
	inline void sample_length(float value);
	inline int subdivision(void);
	inline void subdivision(int value);
	inline bool use_keep_shape(void);
	inline void use_keep_shape(bool value);
	inline Material outline_material(void);
	inline Object object(void);

};

/**************** Shrinkwrap Modifier ****************/

class GreasePencilShrinkwrapModifier : public Modifier {
public:
	GreasePencilShrinkwrapModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline std::string vertex_group_name(void);
	inline void vertex_group_name(const std::string& value);
	inline bool invert_vertex_group(void);
	inline void invert_vertex_group(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	enum wrap_method_enum {
		wrap_method_NEAREST_SURFACEPOINT = 0,
		wrap_method_PROJECT = 1,
		wrap_method_NEAREST_VERTEX = 2,
		wrap_method_TARGET_PROJECT = 3,
	};
	inline wrap_method_enum wrap_method(void);
	inline void wrap_method(wrap_method_enum value);
	enum wrap_mode_enum {
		wrap_mode_ON_SURFACE = 0,
		wrap_mode_INSIDE = 1,
		wrap_mode_OUTSIDE = 2,
		wrap_mode_OUTSIDE_SURFACE = 3,
		wrap_mode_ABOVE_SURFACE = 4,
	};
	inline wrap_mode_enum wrap_mode(void);
	inline void wrap_mode(wrap_mode_enum value);
	enum cull_face_enum {
		cull_face_OFF = 0,
		cull_face_FRONT = 8,
		cull_face_BACK = 16,
	};
	inline cull_face_enum cull_face(void);
	inline void cull_face(cull_face_enum value);
	inline Object target(void);
	inline Object auxiliary_target(void);
	inline float offset(void);
	inline void offset(float value);
	inline float project_limit(void);
	inline void project_limit(float value);
	inline bool use_project_x(void);
	inline void use_project_x(bool value);
	inline bool use_project_y(void);
	inline void use_project_y(bool value);
	inline bool use_project_z(void);
	inline void use_project_z(bool value);
	inline int subsurf_levels(void);
	inline void subsurf_levels(int value);
	inline bool use_negative_direction(void);
	inline void use_negative_direction(bool value);
	inline bool use_positive_direction(void);
	inline void use_positive_direction(bool value);
	inline bool use_invert_cull(void);
	inline void use_invert_cull(bool value);
	inline float smooth_factor(void);
	inline void smooth_factor(float value);
	inline int smooth_step(void);
	inline void smooth_step(int value);

};

/**************** Build Modifier ****************/

class GreasePencilBuildModifier : public Modifier {
public:
	GreasePencilBuildModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline bool open_frame_range_panel(void);
	inline void open_frame_range_panel(bool value);
	inline bool open_fading_panel(void);
	inline void open_fading_panel(bool value);
	enum mode_enum {
		mode_SEQUENTIAL = 0,
		mode_CONCURRENT = 1,
		mode_ADDITIVE = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	enum transition_enum {
		transition_GROW = 0,
		transition_SHRINK = 1,
		transition_FADE = 2,
	};
	inline transition_enum transition(void);
	inline void transition(transition_enum value);
	inline float start_delay(void);
	inline void start_delay(float value);
	inline float length(void);
	inline void length(float value);
	enum concurrent_time_alignment_enum {
		concurrent_time_alignment_START = 0,
		concurrent_time_alignment_END = 1,
	};
	inline concurrent_time_alignment_enum concurrent_time_alignment(void);
	inline void concurrent_time_alignment(concurrent_time_alignment_enum value);
	enum time_mode_enum {
		time_mode_DRAWSPEED = 2,
		time_mode_FRAMES = 0,
		time_mode_PERCENTAGE = 1,
	};
	inline time_mode_enum time_mode(void);
	inline void time_mode(time_mode_enum value);
	inline float speed_factor(void);
	inline void speed_factor(float value);
	inline float speed_maxgap(void);
	inline void speed_maxgap(float value);
	inline bool use_restrict_frame_range(void);
	inline void use_restrict_frame_range(bool value);
	inline bool use_percentage(void);
	inline void use_percentage(bool value);
	inline float percentage_factor(void);
	inline void percentage_factor(float value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);
	inline bool use_fading(void);
	inline void use_fading(bool value);
	inline float fade_factor(void);
	inline void fade_factor(float value);
	inline std::string target_vertex_group(void);
	inline void target_vertex_group(const std::string& value);
	inline float fade_opacity_strength(void);
	inline void fade_opacity_strength(float value);
	inline float fade_thickness_strength(void);
	inline void fade_thickness_strength(float value);
	inline Object object(void);

};

/**************** Grease Pencil Texture Modifier ****************/

class GreasePencilTextureModifier : public Modifier {
public:
	GreasePencilTextureModifier(const PointerRNA &ptr_arg) :
		Modifier(ptr_arg)
		{}

	inline std::string tree_node_filter(void);
	inline void tree_node_filter(const std::string& value);
	inline bool use_layer_pass_filter(void);
	inline void use_layer_pass_filter(bool value);
	inline int layer_pass_filter(void);
	inline void layer_pass_filter(int value);
	inline bool invert_layer_filter(void);
	inline void invert_layer_filter(bool value);
	inline bool invert_layer_pass_filter(void);
	inline void invert_layer_pass_filter(bool value);
	inline bool use_layer_group_filter(void);
	inline void use_layer_group_filter(bool value);
	inline Material material_filter(void);
	inline bool use_material_pass_filter(void);
	inline void use_material_pass_filter(bool value);
	inline int material_pass_filter(void);
	inline void material_pass_filter(int value);
	inline bool invert_material_filter(void);
	inline void invert_material_filter(bool value);
	inline bool invert_material_pass_filter(void);
	inline void invert_material_pass_filter(bool value);
	inline bool open_influence_panel(void);
	inline void open_influence_panel(bool value);
	inline float uv_offset(void);
	inline void uv_offset(float value);
	inline float uv_scale(void);
	inline void uv_scale(float value);
	inline float alignment_rotation(void);
	inline void alignment_rotation(float value);
	inline float fill_rotation(void);
	inline void fill_rotation(float value);
	inline Array<float, 2> fill_offset(void);
	inline void fill_offset(float values[2]);
	inline float fill_scale(void);
	inline void fill_scale(float value);
	enum fit_method_enum {
		fit_method_CONSTANT_LENGTH = 1,
		fit_method_FIT_STROKE = 0,
	};
	inline fit_method_enum fit_method(void);
	inline void fit_method(fit_method_enum value);
	enum mode_enum {
		mode_STROKE = 0,
		mode_FILL = 1,
		mode_STROKE_AND_FILL = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

};

/**************** ShaderFx ****************/

class ShaderFx : public Pointer {
public:
	ShaderFx(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum type_enum {
		type_FX_BLUR = 1,
		type_FX_COLORIZE = 8,
		type_FX_FLIP = 2,
		type_FX_GLOW = 10,
		type_FX_PIXEL = 4,
		type_FX_RIM = 7,
		type_FX_SHADOW = 9,
		type_FX_SWIRL = 5,
		type_FX_WAVE = 6,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline bool show_viewport(void);
	inline void show_viewport(bool value);
	inline bool show_render(void);
	inline void show_render(bool value);
	inline bool show_in_editmode(void);
	inline void show_in_editmode(bool value);
	inline bool show_expanded(void);
	inline void show_expanded(bool value);

};

/**************** Gaussian Blur Effect ****************/

class ShaderFxBlur : public ShaderFx {
public:
	ShaderFxBlur(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	inline Array<float, 2> size(void);
	inline void size(float values[2]);
	inline int samples(void);
	inline void samples(int value);
	inline float rotation(void);
	inline void rotation(float value);
	inline bool use_dof_mode(void);
	inline void use_dof_mode(bool value);

};

/**************** Colorize Effect ****************/

class ShaderFxColorize : public ShaderFx {
public:
	ShaderFxColorize(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	inline float factor(void);
	inline void factor(float value);
	inline Array<float, 4> low_color(void);
	inline void low_color(float values[4]);
	inline Array<float, 4> high_color(void);
	inline void high_color(float values[4]);
	enum mode_enum {
		mode_GRAYSCALE = 0,
		mode_SEPIA = 1,
		mode_DUOTONE = 2,
		mode_TRANSPARENT = 4,
		mode_CUSTOM = 3,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

};

/**************** Wave Deformation Effect ****************/

class ShaderFxWave : public ShaderFx {
public:
	ShaderFxWave(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	enum orientation_enum {
		orientation_HORIZONTAL = 0,
		orientation_VERTICAL = 1,
	};
	inline orientation_enum orientation(void);
	inline void orientation(orientation_enum value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float period(void);
	inline void period(float value);
	inline float phase(void);
	inline void phase(float value);

};

/**************** Pixelate Effect ****************/

class ShaderFxPixel : public ShaderFx {
public:
	ShaderFxPixel(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	inline Array<int, 2> size(void);
	inline void size(int values[2]);
	inline bool use_antialiasing(void);
	inline void use_antialiasing(bool value);

};

/**************** Rim Effect ****************/

class ShaderFxRim : public ShaderFx {
public:
	ShaderFxRim(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	inline Array<int, 2> offset(void);
	inline void offset(int values[2]);
	inline Array<float, 3> rim_color(void);
	inline void rim_color(float values[3]);
	inline Array<float, 3> mask_color(void);
	inline void mask_color(float values[3]);
	enum mode_enum {
		mode_NORMAL = 0,
		mode_OVERLAY = 1,
		mode_ADD = 2,
		mode_SUBTRACT = 3,
		mode_MULTIPLY = 4,
		mode_DIVIDE = 5,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline Array<int, 2> blur(void);
	inline void blur(int values[2]);
	inline int samples(void);
	inline void samples(int value);

};

/**************** Shadow Effect ****************/

class ShaderFxShadow : public ShaderFx {
public:
	ShaderFxShadow(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	inline Object object(void);
	inline Array<int, 2> offset(void);
	inline void offset(int values[2]);
	inline Array<float, 2> scale(void);
	inline void scale(float values[2]);
	inline Array<float, 4> shadow_color(void);
	inline void shadow_color(float values[4]);
	enum orientation_enum {
		orientation_HORIZONTAL = 0,
		orientation_VERTICAL = 1,
	};
	inline orientation_enum orientation(void);
	inline void orientation(orientation_enum value);
	inline float amplitude(void);
	inline void amplitude(float value);
	inline float period(void);
	inline void period(float value);
	inline float phase(void);
	inline void phase(float value);
	inline float rotation(void);
	inline void rotation(float value);
	inline Array<int, 2> blur(void);
	inline void blur(int values[2]);
	inline int samples(void);
	inline void samples(int value);
	inline bool use_object(void);
	inline void use_object(bool value);
	inline bool use_wave(void);
	inline void use_wave(bool value);

};

/**************** Glow Effect ****************/

class ShaderFxGlow : public ShaderFx {
public:
	ShaderFxGlow(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	inline Array<float, 3> glow_color(void);
	inline void glow_color(float values[3]);
	inline float opacity(void);
	inline void opacity(float value);
	inline Array<float, 3> select_color(void);
	inline void select_color(float values[3]);
	enum mode_enum {
		mode_LUMINANCE = 0,
		mode_COLOR = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline float threshold(void);
	inline void threshold(float value);
	inline Array<float, 2> size(void);
	inline void size(float values[2]);
	inline int samples(void);
	inline void samples(int value);
	inline bool use_glow_under(void);
	inline void use_glow_under(bool value);
	inline float rotation(void);
	inline void rotation(float value);
	enum blend_mode_enum {
		blend_mode_REGULAR = 0,
		blend_mode_ADD = 2,
		blend_mode_SUBTRACT = 3,
		blend_mode_MULTIPLY = 4,
		blend_mode_DIVIDE = 5,
	};
	inline blend_mode_enum blend_mode(void);
	inline void blend_mode(blend_mode_enum value);

};

/**************** Swirl Effect ****************/

class ShaderFxSwirl : public ShaderFx {
public:
	ShaderFxSwirl(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	inline int radius(void);
	inline void radius(int value);
	inline float angle(void);
	inline void angle(float value);
	inline bool use_transparent(void);
	inline void use_transparent(bool value);
	inline Object object(void);

};

/**************** Flip Effect ****************/

class ShaderFxFlip : public ShaderFx {
public:
	ShaderFxFlip(const PointerRNA &ptr_arg) :
		ShaderFx(ptr_arg)
		{}

	inline bool use_flip_x(void);
	inline void use_flip_x(bool value);
	inline bool use_flip_y(void);
	inline void use_flip_y(bool value);

};

/**************** NLA Track ****************/

class NlaTrack : public Pointer {
public:
	NlaTrack(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		strips(ptr_arg)
		{}

	inline Struct rna_type(void);
	COLLECTION_PROPERTY(NlaStrips, NlaStrip, NlaTrack, strips, false, true, true)
	inline bool is_override_data(void);
	inline void is_override_data(bool value);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline bool active(void);
	inline void active(bool value);
	inline bool is_solo(void);
	inline void is_solo(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool mute(void);
	inline void mute(bool value);
	inline bool lock(void);
	inline void lock(bool value);

};

/**************** NLA Strip ****************/

class NlaStrip : public Pointer {
public:
	NlaStrip(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		action_suitable_slots(ptr_arg),
		fcurves(ptr_arg),
		modifiers(ptr_arg),
		strips(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum type_enum {
		type_CLIP = 0,
		type_TRANSITION = 1,
		type_META = 2,
		type_SOUND = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	enum extrapolation_enum {
		extrapolation_NOTHING = 2,
		extrapolation_HOLD = 0,
		extrapolation_HOLD_FORWARD = 1,
	};
	inline extrapolation_enum extrapolation(void);
	inline void extrapolation(extrapolation_enum value);
	enum blend_type_enum {
		blend_type_REPLACE = 0,
		blend_type_COMBINE = 4,
		blend_type_ADD = 1,
		blend_type_SUBTRACT = 2,
		blend_type_MULTIPLY = 3,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline float frame_start(void);
	inline void frame_start(float value);
	inline float frame_end(void);
	inline void frame_end(float value);
	inline float frame_start_raw(void);
	inline void frame_start_raw(float value);
	inline float frame_end_raw(void);
	inline void frame_end_raw(float value);
	inline float frame_start_ui(void);
	inline void frame_start_ui(float value);
	inline float frame_end_ui(void);
	inline void frame_end_ui(float value);
	inline float blend_in(void);
	inline void blend_in(float value);
	inline float blend_out(void);
	inline void blend_out(float value);
	inline bool use_auto_blend(void);
	inline void use_auto_blend(bool value);
	inline Action action(void);
	inline int action_slot_handle(void);
	inline void action_slot_handle(int value);
	inline std::string last_slot_identifier(void);
	inline void last_slot_identifier(const std::string& value);
	inline ActionSlot action_slot(void);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, ActionSlot, NlaStrip, action_suitable_slots, false, false, false)
	inline float action_frame_start(void);
	inline void action_frame_start(float value);
	inline float action_frame_end(void);
	inline void action_frame_end(float value);
	inline float repeat(void);
	inline void repeat(float value);
	inline float scale(void);
	inline void scale(float value);
	COLLECTION_PROPERTY(NlaStripFCurves, FCurve, NlaStrip, fcurves, false, true, false)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, FModifier, NlaStrip, modifiers, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, NlaStrip, NlaStrip, strips, false, true, true)
	inline float influence(void);
	inline void influence(float value);
	inline float strip_time(void);
	inline void strip_time(float value);
	inline bool use_animated_influence(void);
	inline void use_animated_influence(bool value);
	inline bool use_animated_time(void);
	inline void use_animated_time(bool value);
	inline bool use_animated_time_cyclic(void);
	inline void use_animated_time_cyclic(bool value);
	inline bool active(void);
	inline void active(bool value);
	inline bool select(void);
	inline void select(bool value);
	inline bool mute(void);
	inline void mute(bool value);
	inline bool use_reverse(void);
	inline void use_reverse(bool value);
	inline bool use_sync_length(void);
	inline void use_sync_length(bool value);

};

/**************** Node ****************/

class Node : public Pointer {
public:
	Node(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg),
		inputs(ptr_arg),
		outputs(ptr_arg),
		internal_links(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string type(void);
	inline void type(const std::string& value);
	inline Array<float, 2> location(void);
	inline void location(float values[2]);
	inline Array<float, 2> location_absolute(void);
	inline void location_absolute(float values[2]);
	inline float width(void);
	inline void width(float value);
	inline float height(void);
	inline void height(float value);
	inline Array<float, 2> dimensions(void);
	inline void dimensions(float values[2]);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline std::string label(void);
	inline void label(const std::string& value);
	COLLECTION_PROPERTY(NodeInputs, NodeSocket, Node, inputs, false, true, true)
	COLLECTION_PROPERTY(NodeOutputs, NodeSocket, Node, outputs, false, true, true)
	COLLECTION_PROPERTY(DefaultCollectionFunctions, NodeLink, Node, internal_links, false, false, false)
	inline Node parent(void);
	enum warning_propagation_enum {
		warning_propagation_ALL = 0,
		warning_propagation_NONE = 1,
		warning_propagation_ERRORS = 2,
		warning_propagation_ERRORS_AND_WARNINGS = 3,
	};
	inline warning_propagation_enum warning_propagation(void);
	inline void warning_propagation(warning_propagation_enum value);
	inline bool use_custom_color(void);
	inline void use_custom_color(bool value);
	inline Array<float, 3> color(void);
	inline void color(float values[3]);
	enum color_tag_enum {
		color_tag_NONE = 0,
		color_tag_ATTRIBUTE = 1,
		color_tag_COLOR = 2,
		color_tag_CONVERTER = 3,
		color_tag_DISTORT = 4,
		color_tag_FILTER = 5,
		color_tag_GEOMETRY = 6,
		color_tag_INPUT = 7,
		color_tag_MATTE = 8,
		color_tag_OUTPUT = 9,
		color_tag_SCRIPT = 10,
		color_tag_SHADER = 11,
		color_tag_TEXTURE = 12,
		color_tag_VECTOR = 13,
		color_tag_PATTERN = 14,
		color_tag_INTERFACE = 15,
		color_tag_GROUP = 16,
	};
	inline color_tag_enum color_tag(void);
	inline void color_tag(color_tag_enum value);
	inline bool select(void);
	inline void select(bool value);
	inline bool show_options(void);
	inline void show_options(bool value);
	inline bool show_preview(void);
	inline void show_preview(bool value);
	inline bool hide(void);
	inline void hide(bool value);
	inline bool mute(void);
	inline void mute(bool value);
	inline bool show_texture(void);
	inline void show_texture(bool value);
	inline std::string bl_idname(void);
	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);
	inline void bl_label(const std::string& value);
	inline std::string bl_description(void);
	inline void bl_description(const std::string& value);
	enum bl_icon_enum {
		bl_icon_NONE = 0,
		bl_icon_CHAR_NOTDEF = 1,
		bl_icon_CHAR_REPLACEMENT = 2,
		bl_icon_NOT_FOUND = 3,
		bl_icon_BLANK1 = 4,
		bl_icon_AUTOMERGE_OFF = 5,
		bl_icon_AUTOMERGE_ON = 6,
		bl_icon_CHECKBOX_DEHLT = 7,
		bl_icon_CHECKBOX_HLT = 8,
		bl_icon_CLIPUV_DEHLT = 9,
		bl_icon_CLIPUV_HLT = 10,
		bl_icon_DECORATE_UNLOCKED = 11,
		bl_icon_DECORATE_LOCKED = 12,
		bl_icon_FAKE_USER_OFF = 13,
		bl_icon_FAKE_USER_ON = 14,
		bl_icon_HIDE_ON = 15,
		bl_icon_HIDE_OFF = 16,
		bl_icon_INDIRECT_ONLY_OFF = 17,
		bl_icon_INDIRECT_ONLY_ON = 18,
		bl_icon_ONIONSKIN_OFF = 19,
		bl_icon_ONIONSKIN_ON = 20,
		bl_icon_UNPINNED = 21,
		bl_icon_PINNED = 22,
		bl_icon_RADIOBUT_OFF = 23,
		bl_icon_RADIOBUT_ON = 24,
		bl_icon_RECORD_OFF = 25,
		bl_icon_RECORD_ON = 26,
		bl_icon_RESTRICT_RENDER_ON = 27,
		bl_icon_RESTRICT_RENDER_OFF = 28,
		bl_icon_RESTRICT_SELECT_ON = 29,
		bl_icon_RESTRICT_SELECT_OFF = 30,
		bl_icon_RESTRICT_VIEW_ON = 31,
		bl_icon_RESTRICT_VIEW_OFF = 32,
		bl_icon_RIGHTARROW = 33,
		bl_icon_DOWNARROW_HLT = 34,
		bl_icon_SELECT_INTERSECT = 35,
		bl_icon_SELECT_DIFFERENCE = 36,
		bl_icon_SNAP_OFF = 37,
		bl_icon_SNAP_ON = 38,
		bl_icon_UNLOCKED = 39,
		bl_icon_LOCKED = 40,
		bl_icon_VIS_SEL_11 = 41,
		bl_icon_VIS_SEL_10 = 42,
		bl_icon_VIS_SEL_01 = 43,
		bl_icon_VIS_SEL_00 = 44,
		bl_icon_CANCEL = 45,
		bl_icon_ERROR = 46,
		bl_icon_QUESTION = 47,
		bl_icon_ADD = 48,
		bl_icon_ARROW_LEFTRIGHT = 49,
		bl_icon_AUTO = 50,
		bl_icon_BLENDER = 51,
		bl_icon_BORDERMOVE = 52,
		bl_icon_BRUSHES_ALL = 53,
		bl_icon_CHECKMARK = 54,
		bl_icon_COLLAPSEMENU = 55,
		bl_icon_COLLECTION_NEW = 56,
		bl_icon_COLOR = 57,
		bl_icon_COPY_ID = 58,
		bl_icon_DISCLOSURE_TRI_DOWN = 59,
		bl_icon_DISCLOSURE_TRI_RIGHT = 60,
		bl_icon_DOT = 61,
		bl_icon_DRIVER_DISTANCE = 62,
		bl_icon_DRIVER_ROTATIONAL_DIFFERENCE = 63,
		bl_icon_DRIVER_TRANSFORM = 64,
		bl_icon_DUPLICATE = 65,
		bl_icon_EYEDROPPER = 66,
		bl_icon_FCURVE_SNAPSHOT = 67,
		bl_icon_FILE_NEW = 68,
		bl_icon_FILE_TICK = 69,
		bl_icon_FREEZE = 70,
		bl_icon_FULLSCREEN_ENTER = 71,
		bl_icon_FULLSCREEN_EXIT = 72,
		bl_icon_GHOST_DISABLED = 73,
		bl_icon_GHOST_ENABLED = 74,
		bl_icon_GRIP = 75,
		bl_icon_GRIP_V = 76,
		bl_icon_HAND = 77,
		bl_icon_HELP = 78,
		bl_icon_LINKED = 79,
		bl_icon_MENU_PANEL = 80,
		bl_icon_NODE_SEL = 81,
		bl_icon_NODE = 82,
		bl_icon_OBJECT_HIDDEN = 83,
		bl_icon_OPTIONS = 84,
		bl_icon_PANEL_CLOSE = 85,
		bl_icon_PLUGIN = 86,
		bl_icon_PLUS = 87,
		bl_icon_PRESET_NEW = 88,
		bl_icon_QUIT = 89,
		bl_icon_RECOVER_LAST = 90,
		bl_icon_REMOVE = 91,
		bl_icon_RIGHTARROW_THIN = 92,
		bl_icon_SCREEN_BACK = 93,
		bl_icon_STATUSBAR = 94,
		bl_icon_STYLUS_PRESSURE = 95,
		bl_icon_THREE_DOTS = 96,
		bl_icon_TOPBAR = 97,
		bl_icon_TRASH = 98,
		bl_icon_TRIA_DOWN = 99,
		bl_icon_TRIA_LEFT = 100,
		bl_icon_TRIA_RIGHT = 101,
		bl_icon_TRIA_UP = 102,
		bl_icon_UNLINKED = 103,
		bl_icon_URL = 104,
		bl_icon_VIEWZOOM = 105,
		bl_icon_WINDOW = 106,
		bl_icon_WORKSPACE = 107,
		bl_icon_X = 108,
		bl_icon_ZOOM_ALL = 109,
		bl_icon_ZOOM_IN = 110,
		bl_icon_ZOOM_OUT = 111,
		bl_icon_ZOOM_PREVIOUS = 112,
		bl_icon_ZOOM_SELECTED = 113,
		bl_icon_MODIFIER = 114,
		bl_icon_PARTICLES = 115,
		bl_icon_PHYSICS = 116,
		bl_icon_SHADERFX = 117,
		bl_icon_SPEAKER = 118,
		bl_icon_OUTPUT = 119,
		bl_icon_SCENE = 120,
		bl_icon_TOOL_SETTINGS = 121,
		bl_icon_LIGHT = 122,
		bl_icon_MATERIAL = 123,
		bl_icon_TEXTURE = 124,
		bl_icon_WORLD = 125,
		bl_icon_ANIM = 126,
		bl_icon_SCRIPT = 127,
		bl_icon_GEOMETRY_NODES = 128,
		bl_icon_TEXT = 129,
		bl_icon_ACTION = 130,
		bl_icon_ASSET_MANAGER = 131,
		bl_icon_CONSOLE = 132,
		bl_icon_FILEBROWSER = 133,
		bl_icon_GEOMETRY_SET = 134,
		bl_icon_GRAPH = 135,
		bl_icon_IMAGE = 136,
		bl_icon_INFO = 137,
		bl_icon_NLA = 138,
		bl_icon_NODE_COMPOSITING = 139,
		bl_icon_NODE_MATERIAL = 140,
		bl_icon_NODE_TEXTURE = 141,
		bl_icon_NODETREE = 142,
		bl_icon_OUTLINER = 143,
		bl_icon_PREFERENCES = 144,
		bl_icon_PROPERTIES = 145,
		bl_icon_SEQUENCE = 146,
		bl_icon_SOUND = 147,
		bl_icon_SPREADSHEET = 148,
		bl_icon_TIME = 149,
		bl_icon_TRACKER = 150,
		bl_icon_UV = 151,
		bl_icon_VIEW3D = 152,
		bl_icon_EDITMODE_HLT = 153,
		bl_icon_OBJECT_DATAMODE = 154,
		bl_icon_PARTICLEMODE = 155,
		bl_icon_POSE_HLT = 156,
		bl_icon_SCULPTMODE_HLT = 157,
		bl_icon_TPAINT_HLT = 158,
		bl_icon_UV_DATA = 159,
		bl_icon_VPAINT_HLT = 160,
		bl_icon_WPAINT_HLT = 161,
		bl_icon_TRACKER_DATA = 162,
		bl_icon_TRACKING_BACKWARDS_SINGLE = 163,
		bl_icon_TRACKING_BACKWARDS = 164,
		bl_icon_TRACKING_CLEAR_BACKWARDS = 165,
		bl_icon_TRACKING_CLEAR_FORWARDS = 166,
		bl_icon_TRACKING_FORWARDS_SINGLE = 167,
		bl_icon_TRACKING_FORWARDS = 168,
		bl_icon_TRACKING_REFINE_BACKWARDS = 169,
		bl_icon_TRACKING_REFINE_FORWARDS = 170,
		bl_icon_TRACKING = 171,
		bl_icon_GROUP = 172,
		bl_icon_CONSTRAINT_BONE = 173,
		bl_icon_CONSTRAINT = 174,
		bl_icon_ARMATURE_DATA = 175,
		bl_icon_BONE_DATA = 176,
		bl_icon_CAMERA_DATA = 177,
		bl_icon_CURVE_DATA = 178,
		bl_icon_EMPTY_DATA = 179,
		bl_icon_FONT_DATA = 180,
		bl_icon_LATTICE_DATA = 181,
		bl_icon_LIGHT_DATA = 182,
		bl_icon_MESH_DATA = 183,
		bl_icon_META_DATA = 184,
		bl_icon_PARTICLE_DATA = 185,
		bl_icon_SHAPEKEY_DATA = 186,
		bl_icon_SURFACE_DATA = 187,
		bl_icon_OBJECT_DATA = 188,
		bl_icon_RENDER_RESULT = 189,
		bl_icon_RENDERLAYERS = 190,
		bl_icon_SCENE_DATA = 191,
		bl_icon_BRUSH_DATA = 192,
		bl_icon_IMAGE_DATA = 193,
		bl_icon_LINE_DATA = 194,
		bl_icon_MATERIAL_DATA = 195,
		bl_icon_TEXTURE_DATA = 196,
		bl_icon_WORLD_DATA = 197,
		bl_icon_ANIM_DATA = 198,
		bl_icon_BOIDS = 199,
		bl_icon_CAMERA_STEREO = 200,
		bl_icon_COMMUNITY = 201,
		bl_icon_FACE_MAPS = 202,
		bl_icon_FCURVE = 203,
		bl_icon_FILE = 204,
		bl_icon_GREASEPENCIL = 205,
		bl_icon_GREASEPENCIL_LAYER_GROUP = 206,
		bl_icon_GROUP_BONE = 207,
		bl_icon_GROUP_UVS = 208,
		bl_icon_GROUP_VCOL = 209,
		bl_icon_GROUP_VERTEX = 210,
		bl_icon_LIBRARY_DATA_BROKEN = 211,
		bl_icon_LIBRARY_DATA_DIRECT = 212,
		bl_icon_LIBRARY_DATA_OVERRIDE = 213,
		bl_icon_ORPHAN_DATA = 214,
		bl_icon_PACKAGE = 215,
		bl_icon_PRESET = 216,
		bl_icon_RENDER_ANIMATION = 217,
		bl_icon_RENDER_STILL = 218,
		bl_icon_RNA_ADD = 219,
		bl_icon_RNA = 220,
		bl_icon_STRANDS = 221,
		bl_icon_UGLYPACKAGE = 222,
		bl_icon_MOUSE_LMB = 223,
		bl_icon_MOUSE_MMB = 224,
		bl_icon_MOUSE_RMB = 225,
		bl_icon_MOUSE_MMB_SCROLL = 226,
		bl_icon_MOUSE_LMB_2X = 227,
		bl_icon_MOUSE_MOVE = 228,
		bl_icon_MOUSE_LMB_DRAG = 229,
		bl_icon_MOUSE_MMB_DRAG = 230,
		bl_icon_MOUSE_RMB_DRAG = 231,
		bl_icon_DECORATE_ANIMATE = 232,
		bl_icon_DECORATE_DRIVER = 233,
		bl_icon_DECORATE_KEYFRAME = 234,
		bl_icon_DECORATE_LIBRARY_OVERRIDE = 235,
		bl_icon_DECORATE_LINKED = 236,
		bl_icon_DECORATE_OVERRIDE = 237,
		bl_icon_DECORATE = 238,
		bl_icon_OUTLINER_COLLECTION = 239,
		bl_icon_CURVES_DATA = 240,
		bl_icon_OUTLINER_DATA_ARMATURE = 241,
		bl_icon_OUTLINER_DATA_CAMERA = 242,
		bl_icon_OUTLINER_DATA_CURVE = 243,
		bl_icon_OUTLINER_DATA_CURVES = 244,
		bl_icon_OUTLINER_DATA_EMPTY = 245,
		bl_icon_OUTLINER_DATA_FONT = 246,
		bl_icon_OUTLINER_DATA_GP_LAYER = 247,
		bl_icon_OUTLINER_DATA_GREASEPENCIL = 248,
		bl_icon_OUTLINER_DATA_LATTICE = 249,
		bl_icon_OUTLINER_DATA_LIGHT = 250,
		bl_icon_OUTLINER_DATA_LIGHTPROBE = 251,
		bl_icon_OUTLINER_DATA_MESH = 252,
		bl_icon_OUTLINER_DATA_META = 253,
		bl_icon_OUTLINER_DATA_POINTCLOUD = 254,
		bl_icon_OUTLINER_DATA_SPEAKER = 255,
		bl_icon_OUTLINER_DATA_SURFACE = 256,
		bl_icon_OUTLINER_DATA_VOLUME = 257,
		bl_icon_POINTCLOUD_DATA = 258,
		bl_icon_POINTCLOUD_POINT = 259,
		bl_icon_VOLUME_DATA = 260,
		bl_icon_OUTLINER_OB_ARMATURE = 261,
		bl_icon_OUTLINER_OB_CAMERA = 262,
		bl_icon_OUTLINER_OB_CURVE = 263,
		bl_icon_OUTLINER_OB_CURVES = 264,
		bl_icon_OUTLINER_OB_EMPTY = 265,
		bl_icon_OUTLINER_OB_FONT = 266,
		bl_icon_OUTLINER_OB_FORCE_FIELD = 267,
		bl_icon_OUTLINER_OB_GREASEPENCIL = 268,
		bl_icon_OUTLINER_OB_GROUP_INSTANCE = 269,
		bl_icon_OUTLINER_OB_IMAGE = 270,
		bl_icon_OUTLINER_OB_LATTICE = 271,
		bl_icon_OUTLINER_OB_LIGHT = 272,
		bl_icon_OUTLINER_OB_LIGHTPROBE = 273,
		bl_icon_OUTLINER_OB_MESH = 274,
		bl_icon_OUTLINER_OB_META = 275,
		bl_icon_OUTLINER_OB_POINTCLOUD = 276,
		bl_icon_OUTLINER_OB_SPEAKER = 277,
		bl_icon_OUTLINER_OB_SURFACE = 278,
		bl_icon_OUTLINER_OB_VOLUME = 279,
		bl_icon_GP_MULTIFRAME_EDITING = 280,
		bl_icon_GP_ONLY_SELECTED = 281,
		bl_icon_GP_SELECT_BETWEEN_STROKES = 282,
		bl_icon_GP_SELECT_POINTS = 283,
		bl_icon_GP_SELECT_STROKES = 284,
		bl_icon_HOLDOUT_OFF = 285,
		bl_icon_HOLDOUT_ON = 286,
		bl_icon_MODIFIER_OFF = 287,
		bl_icon_MODIFIER_ON = 288,
		bl_icon_RESTRICT_COLOR_OFF = 289,
		bl_icon_RESTRICT_COLOR_ON = 290,
		bl_icon_RESTRICT_INSTANCED_OFF = 291,
		bl_icon_RESTRICT_INSTANCED_ON = 292,
		bl_icon_LIGHT_AREA = 293,
		bl_icon_LIGHT_HEMI = 294,
		bl_icon_LIGHT_POINT = 295,
		bl_icon_LIGHT_SPOT = 296,
		bl_icon_LIGHT_SUN = 297,
		bl_icon_LIGHTPROBE_PLANE = 298,
		bl_icon_LIGHTPROBE_SPHERE = 299,
		bl_icon_LIGHTPROBE_VOLUME = 300,
		bl_icon_COLOR_BLUE = 301,
		bl_icon_COLOR_GREEN = 302,
		bl_icon_COLOR_RED = 303,
		bl_icon_CONE = 304,
		bl_icon_CUBE = 305,
		bl_icon_CURVE_BEZCIRCLE = 306,
		bl_icon_CURVE_BEZCURVE = 307,
		bl_icon_CURVE_NCIRCLE = 308,
		bl_icon_CURVE_NCURVE = 309,
		bl_icon_CURVE_PATH = 310,
		bl_icon_CURVES = 311,
		bl_icon_EMPTY_ARROWS = 312,
		bl_icon_EMPTY_AXIS = 313,
		bl_icon_EMPTY_SINGLE_ARROW = 314,
		bl_icon_MESH_CAPSULE = 315,
		bl_icon_MESH_CIRCLE = 316,
		bl_icon_MESH_CONE = 317,
		bl_icon_MESH_CUBE = 318,
		bl_icon_MESH_CYLINDER = 319,
		bl_icon_MESH_GRID = 320,
		bl_icon_MESH_ICOSPHERE = 321,
		bl_icon_MESH_MONKEY = 322,
		bl_icon_MESH_PLANE = 323,
		bl_icon_MESH_TORUS = 324,
		bl_icon_MESH_UVSPHERE = 325,
		bl_icon_META_BALL = 326,
		bl_icon_META_CAPSULE = 327,
		bl_icon_META_CUBE = 328,
		bl_icon_META_ELLIPSOID = 329,
		bl_icon_META_PLANE = 330,
		bl_icon_MONKEY = 331,
		bl_icon_SPHERE = 332,
		bl_icon_STROKE = 333,
		bl_icon_SURFACE_NCIRCLE = 334,
		bl_icon_SURFACE_NCURVE = 335,
		bl_icon_SURFACE_NCYLINDER = 336,
		bl_icon_SURFACE_NSPHERE = 337,
		bl_icon_SURFACE_NSURFACE = 338,
		bl_icon_SURFACE_NTORUS = 339,
		bl_icon_TRIA_DOWN_BAR = 340,
		bl_icon_TRIA_LEFT_BAR = 341,
		bl_icon_TRIA_RIGHT_BAR = 342,
		bl_icon_TRIA_UP_BAR = 343,
		bl_icon_AREA_DOCK = 344,
		bl_icon_AREA_JOIN_DOWN = 345,
		bl_icon_AREA_JOIN_LEFT = 346,
		bl_icon_AREA_JOIN_UP = 347,
		bl_icon_AREA_JOIN = 348,
		bl_icon_AREA_SWAP = 349,
		bl_icon_FORCE_BOID = 350,
		bl_icon_FORCE_CHARGE = 351,
		bl_icon_FORCE_CURVE = 352,
		bl_icon_FORCE_DRAG = 353,
		bl_icon_FORCE_FLUIDFLOW = 354,
		bl_icon_FORCE_FORCE = 355,
		bl_icon_FORCE_HARMONIC = 356,
		bl_icon_FORCE_LENNARDJONES = 357,
		bl_icon_FORCE_MAGNETIC = 358,
		bl_icon_FORCE_TEXTURE = 359,
		bl_icon_FORCE_TURBULENCE = 360,
		bl_icon_FORCE_VORTEX = 361,
		bl_icon_FORCE_WIND = 362,
		bl_icon_IMAGE_BACKGROUND = 363,
		bl_icon_IMAGE_PLANE = 364,
		bl_icon_IMAGE_REFERENCE = 365,
		bl_icon_RIGID_BODY_CONSTRAINT = 366,
		bl_icon_RIGID_BODY = 367,
		bl_icon_SPLIT_HORIZONTAL = 368,
		bl_icon_SPLIT_VERTICAL = 369,
		bl_icon_ANCHOR_BOTTOM = 370,
		bl_icon_ANCHOR_CENTER = 371,
		bl_icon_ANCHOR_LEFT = 372,
		bl_icon_ANCHOR_RIGHT = 373,
		bl_icon_ANCHOR_TOP = 374,
		bl_icon_NODE_CORNER = 375,
		bl_icon_NODE_INSERT_OFF = 376,
		bl_icon_NODE_INSERT_ON = 377,
		bl_icon_NODE_SIDE = 378,
		bl_icon_NODE_TOP = 379,
		bl_icon_SELECT_EXTEND = 380,
		bl_icon_SELECT_SET = 381,
		bl_icon_SELECT_SUBTRACT = 382,
		bl_icon_ALIGN_BOTTOM = 383,
		bl_icon_ALIGN_CENTER = 384,
		bl_icon_ALIGN_FLUSH = 385,
		bl_icon_ALIGN_JUSTIFY = 386,
		bl_icon_ALIGN_LEFT = 387,
		bl_icon_ALIGN_MIDDLE = 388,
		bl_icon_ALIGN_RIGHT = 389,
		bl_icon_ALIGN_TOP = 390,
		bl_icon_BOLD = 391,
		bl_icon_ITALIC = 392,
		bl_icon_LINENUMBERS_OFF = 393,
		bl_icon_LINENUMBERS_ON = 394,
		bl_icon_SCRIPTPLUGINS = 395,
		bl_icon_SMALL_CAPS = 396,
		bl_icon_SYNTAX_OFF = 397,
		bl_icon_SYNTAX_ON = 398,
		bl_icon_UNDERLINE = 399,
		bl_icon_WORDWRAP_OFF = 400,
		bl_icon_WORDWRAP_ON = 401,
		bl_icon_CON_ACTION = 402,
		bl_icon_CON_ARMATURE = 403,
		bl_icon_CON_CAMERASOLVER = 404,
		bl_icon_CON_CHILDOF = 405,
		bl_icon_CON_CLAMPTO = 406,
		bl_icon_CON_DISTLIMIT = 407,
		bl_icon_CON_FLOOR = 408,
		bl_icon_CON_FOLLOWPATH = 409,
		bl_icon_CON_FOLLOWTRACK = 410,
		bl_icon_CON_KINEMATIC = 411,
		bl_icon_CON_LOCKTRACK = 412,
		bl_icon_CON_LOCLIKE = 413,
		bl_icon_CON_LOCLIMIT = 414,
		bl_icon_CON_OBJECTSOLVER = 415,
		bl_icon_CON_PIVOT = 416,
		bl_icon_CON_ROTLIKE = 417,
		bl_icon_CON_ROTLIMIT = 418,
		bl_icon_CON_SAMEVOL = 419,
		bl_icon_CON_SHRINKWRAP = 420,
		bl_icon_CON_SIZELIKE = 421,
		bl_icon_CON_SIZELIMIT = 422,
		bl_icon_CON_SPLINEIK = 423,
		bl_icon_CON_STRETCHTO = 424,
		bl_icon_CON_TRACKTO = 425,
		bl_icon_CON_TRANSFORM_CACHE = 426,
		bl_icon_CON_TRANSFORM = 427,
		bl_icon_CON_TRANSLIKE = 428,
		bl_icon_HOOK = 429,
		bl_icon_MOD_ARMATURE = 430,
		bl_icon_MOD_ARRAY = 431,
		bl_icon_MOD_BEVEL = 432,
		bl_icon_MOD_BOOLEAN = 433,
		bl_icon_MOD_BUILD = 434,
		bl_icon_MOD_CAST = 435,
		bl_icon_MOD_CLOTH = 436,
		bl_icon_MOD_CURVE = 437,
		bl_icon_MOD_DASH = 438,
		bl_icon_MOD_DATA_TRANSFER = 439,
		bl_icon_MOD_DECIM = 440,
		bl_icon_MOD_DISPLACE = 441,
		bl_icon_MOD_DYNAMICPAINT = 442,
		bl_icon_MOD_EDGESPLIT = 443,
		bl_icon_MOD_ENVELOPE = 444,
		bl_icon_MOD_EXPLODE = 445,
		bl_icon_MOD_FLUID = 446,
		bl_icon_MOD_FLUIDSIM = 447,
		bl_icon_MOD_HUE_SATURATION = 448,
		bl_icon_MOD_INSTANCE = 449,
		bl_icon_MOD_LATTICE = 450,
		bl_icon_MOD_LENGTH = 451,
		bl_icon_MOD_LINEART = 452,
		bl_icon_MOD_MASK = 453,
		bl_icon_MOD_MESHDEFORM = 454,
		bl_icon_MOD_MIRROR = 455,
		bl_icon_MOD_MULTIRES = 456,
		bl_icon_MOD_NOISE = 457,
		bl_icon_MOD_NORMALEDIT = 458,
		bl_icon_MOD_OCEAN = 459,
		bl_icon_MOD_OFFSET = 460,
		bl_icon_MOD_OPACITY = 461,
		bl_icon_MOD_OUTLINE = 462,
		bl_icon_MOD_PARTICLE_INSTANCE = 463,
		bl_icon_MOD_PARTICLES = 464,
		bl_icon_MOD_PHYSICS = 465,
		bl_icon_MOD_REMESH = 466,
		bl_icon_MOD_SCREW = 467,
		bl_icon_MOD_SHRINKWRAP = 468,
		bl_icon_MOD_SIMPLEDEFORM = 469,
		bl_icon_MOD_SIMPLIFY = 470,
		bl_icon_MOD_SKIN = 471,
		bl_icon_MOD_SMOOTH = 472,
		bl_icon_MOD_SOFT = 473,
		bl_icon_MOD_SOLIDIFY = 474,
		bl_icon_MOD_SUBSURF = 475,
		bl_icon_MOD_THICKNESS = 476,
		bl_icon_MOD_TIME = 477,
		bl_icon_MOD_TINT = 478,
		bl_icon_MOD_TRIANGULATE = 479,
		bl_icon_MOD_UVPROJECT = 480,
		bl_icon_MOD_VERTEX_WEIGHT = 481,
		bl_icon_MOD_WARP = 482,
		bl_icon_MOD_WAVE = 483,
		bl_icon_MOD_WIREFRAME = 484,
		bl_icon_MODIFIER_DATA = 485,
		bl_icon_ACTION_SLOT = 486,
		bl_icon_ACTION_TWEAK = 487,
		bl_icon_DRIVER = 488,
		bl_icon_FF = 489,
		bl_icon_FRAME_NEXT = 490,
		bl_icon_FRAME_PREV = 491,
		bl_icon_HANDLE_ALIGNED = 492,
		bl_icon_HANDLE_AUTO = 493,
		bl_icon_HANDLE_AUTOCLAMPED = 494,
		bl_icon_HANDLE_FREE = 495,
		bl_icon_HANDLE_VECTOR = 496,
		bl_icon_IPO_BACK = 497,
		bl_icon_IPO_BEZIER = 498,
		bl_icon_IPO_BOUNCE = 499,
		bl_icon_IPO_CIRC = 500,
		bl_icon_IPO_CONSTANT = 501,
		bl_icon_IPO_CUBIC = 502,
		bl_icon_IPO_EASE_IN_OUT = 503,
		bl_icon_IPO_EASE_IN = 504,
		bl_icon_IPO_EASE_OUT = 505,
		bl_icon_IPO_ELASTIC = 506,
		bl_icon_IPO_EXPO = 507,
		bl_icon_IPO_LINEAR = 508,
		bl_icon_IPO_QUAD = 509,
		bl_icon_IPO_QUART = 510,
		bl_icon_IPO_QUINT = 511,
		bl_icon_IPO_SINE = 512,
		bl_icon_KEY_DEHLT = 513,
		bl_icon_KEY_HLT = 514,
		bl_icon_KEYFRAME_HLT = 515,
		bl_icon_KEYFRAME = 516,
		bl_icon_KEYINGSET = 517,
		bl_icon_MARKER_HLT = 518,
		bl_icon_MARKER = 519,
		bl_icon_MUTE_IPO_OFF = 520,
		bl_icon_MUTE_IPO_ON = 521,
		bl_icon_NEXT_KEYFRAME = 522,
		bl_icon_NLA_PUSHDOWN = 523,
		bl_icon_NORMALIZE_FCURVES = 524,
		bl_icon_ORIENTATION_PARENT = 525,
		bl_icon_PAUSE = 526,
		bl_icon_PLAY_REVERSE = 527,
		bl_icon_PLAY_SOUND = 528,
		bl_icon_PLAY = 529,
		bl_icon_PMARKER_ACT = 530,
		bl_icon_PMARKER_SEL = 531,
		bl_icon_PMARKER = 532,
		bl_icon_PREV_KEYFRAME = 533,
		bl_icon_PREVIEW_RANGE = 534,
		bl_icon_REC = 535,
		bl_icon_REW = 536,
		bl_icon_SOLO_OFF = 537,
		bl_icon_SOLO_ON = 538,
		bl_icon_CENTER_ONLY = 539,
		bl_icon_CURSOR = 540,
		bl_icon_EDGESEL = 541,
		bl_icon_FACE_CORNER = 542,
		bl_icon_FACESEL = 543,
		bl_icon_INVERSESQUARECURVE = 544,
		bl_icon_LINCURVE = 545,
		bl_icon_NOCURVE = 546,
		bl_icon_PARTICLE_PATH = 547,
		bl_icon_PARTICLE_POINT = 548,
		bl_icon_PARTICLE_TIP = 549,
		bl_icon_PIVOT_ACTIVE = 550,
		bl_icon_PIVOT_BOUNDBOX = 551,
		bl_icon_PIVOT_CURSOR = 552,
		bl_icon_PIVOT_INDIVIDUAL = 553,
		bl_icon_PIVOT_MEDIAN = 554,
		bl_icon_PROP_CON = 555,
		bl_icon_PROP_OFF = 556,
		bl_icon_PROP_ON = 557,
		bl_icon_PROP_PROJECTED = 558,
		bl_icon_RNDCURVE = 559,
		bl_icon_ROOTCURVE = 560,
		bl_icon_SHARPCURVE = 561,
		bl_icon_SMOOTHCURVE = 562,
		bl_icon_SPHERECURVE = 563,
		bl_icon_VERTEXSEL = 564,
		bl_icon_SNAP_EDGE = 565,
		bl_icon_SNAP_FACE_CENTER = 566,
		bl_icon_SNAP_FACE_NEAREST = 567,
		bl_icon_SNAP_FACE = 568,
		bl_icon_SNAP_GRID = 569,
		bl_icon_SNAP_INCREMENT = 570,
		bl_icon_SNAP_MIDPOINT = 571,
		bl_icon_SNAP_NORMAL = 572,
		bl_icon_SNAP_PEEL_OBJECT = 573,
		bl_icon_SNAP_PERPENDICULAR = 574,
		bl_icon_SNAP_VERTEX = 575,
		bl_icon_SNAP_VOLUME = 576,
		bl_icon_STICKY_UVS_DISABLE = 577,
		bl_icon_STICKY_UVS_LOC = 578,
		bl_icon_STICKY_UVS_VERT = 579,
		bl_icon_ORIENTATION_GIMBAL = 580,
		bl_icon_ORIENTATION_GLOBAL = 581,
		bl_icon_ORIENTATION_LOCAL = 582,
		bl_icon_ORIENTATION_NORMAL = 583,
		bl_icon_ORIENTATION_VIEW = 584,
		bl_icon_COPYDOWN = 585,
		bl_icon_FIXED_SIZE = 586,
		bl_icon_GIZMO = 587,
		bl_icon_GP_CAPS_FLAT = 588,
		bl_icon_GP_CAPS_ROUND = 589,
		bl_icon_NORMALS_FACE = 590,
		bl_icon_NORMALS_VERTEX_FACE = 591,
		bl_icon_NORMALS_VERTEX = 592,
		bl_icon_OBJECT_ORIGIN = 593,
		bl_icon_ORIENTATION_CURSOR = 594,
		bl_icon_PASTEDOWN = 595,
		bl_icon_PASTEFLIPDOWN = 596,
		bl_icon_PASTEFLIPUP = 597,
		bl_icon_TRANSFORM_ORIGINS = 598,
		bl_icon_UV_EDGESEL = 599,
		bl_icon_UV_FACESEL = 600,
		bl_icon_UV_ISLANDSEL = 601,
		bl_icon_UV_SYNC_SELECT = 602,
		bl_icon_UV_VERTEXSEL = 603,
		bl_icon_AXIS_FRONT = 604,
		bl_icon_AXIS_SIDE = 605,
		bl_icon_AXIS_TOP = 606,
		bl_icon_GRID = 607,
		bl_icon_LAYER_ACTIVE = 608,
		bl_icon_LAYER_USED = 609,
		bl_icon_LOCKVIEW_OFF = 610,
		bl_icon_LOCKVIEW_ON = 611,
		bl_icon_OVERLAY = 612,
		bl_icon_SHADING_BBOX = 613,
		bl_icon_SHADING_RENDERED = 614,
		bl_icon_SHADING_SOLID = 615,
		bl_icon_SHADING_TEXTURE = 616,
		bl_icon_SHADING_WIRE = 617,
		bl_icon_XRAY = 618,
		bl_icon_VIEW_CAMERA_UNSELECTED = 619,
		bl_icon_VIEW_CAMERA = 620,
		bl_icon_VIEW_LOCKED = 621,
		bl_icon_VIEW_ORTHO = 622,
		bl_icon_VIEW_PAN = 623,
		bl_icon_VIEW_PERSPECTIVE = 624,
		bl_icon_VIEW_UNLOCKED = 625,
		bl_icon_VIEW_ZOOM = 626,
		bl_icon_FILE_ALIAS = 627,
		bl_icon_FILE_FOLDER = 628,
		bl_icon_FOLDER_REDIRECT = 629,
		bl_icon_APPEND_BLEND = 630,
		bl_icon_BACK = 631,
		bl_icon_BOOKMARKS = 632,
		bl_icon_CURRENT_FILE = 633,
		bl_icon_DESKTOP = 634,
		bl_icon_DISC = 635,
		bl_icon_DISK_DRIVE = 636,
		bl_icon_DOCUMENTS = 637,
		bl_icon_EXPORT = 638,
		bl_icon_EXTERNAL_DRIVE = 639,
		bl_icon_FILE_3D = 640,
		bl_icon_FILE_ARCHIVE = 641,
		bl_icon_FILE_BACKUP = 642,
		bl_icon_FILE_BLANK = 643,
		bl_icon_FILE_BLEND = 644,
		bl_icon_FILE_CACHE = 645,
		bl_icon_FILE_FONT = 646,
		bl_icon_FILE_HIDDEN = 647,
		bl_icon_FILE_IMAGE = 648,
		bl_icon_FILE_MOVIE = 649,
		bl_icon_FILE_PARENT = 650,
		bl_icon_FILE_REFRESH = 651,
		bl_icon_FILE_SCRIPT = 652,
		bl_icon_FILE_SOUND = 653,
		bl_icon_FILE_TEXT = 654,
		bl_icon_FILE_VOLUME = 655,
		bl_icon_FILTER = 656,
		bl_icon_FONTPREVIEW = 657,
		bl_icon_FORWARD = 658,
		bl_icon_HOME = 659,
		bl_icon_IMGDISPLAY = 660,
		bl_icon_IMPORT = 661,
		bl_icon_LINK_BLEND = 662,
		bl_icon_LONGDISPLAY = 663,
		bl_icon_LOOP_BACK = 664,
		bl_icon_LOOP_FORWARDS = 665,
		bl_icon_NETWORK_DRIVE = 666,
		bl_icon_NEWFOLDER = 667,
		bl_icon_PREVIEW_LOADING = 668,
		bl_icon_SETTINGS = 669,
		bl_icon_SHORTDISPLAY = 670,
		bl_icon_SORT_ASC = 671,
		bl_icon_SORT_DESC = 672,
		bl_icon_SORTALPHA = 673,
		bl_icon_SORTBYEXT = 674,
		bl_icon_SORTSIZE = 675,
		bl_icon_SORTTIME = 676,
		bl_icon_SYSTEM = 677,
		bl_icon_TAG = 678,
		bl_icon_TEMP = 679,
		bl_icon_ALIASED = 680,
		bl_icon_ANTIALIASED = 681,
		bl_icon_MAT_SPHERE_SKY = 682,
		bl_icon_MATCLOTH = 683,
		bl_icon_MATCUBE = 684,
		bl_icon_MATFLUID = 685,
		bl_icon_MATPLANE = 686,
		bl_icon_MATSHADERBALL = 687,
		bl_icon_MATSPHERE = 688,
		bl_icon_SEQ_CHROMA_SCOPE = 689,
		bl_icon_SEQ_HISTOGRAM = 690,
		bl_icon_SEQ_LUMA_WAVEFORM = 691,
		bl_icon_SEQ_PREVIEW = 692,
		bl_icon_SEQ_SEQUENCER = 693,
		bl_icon_SEQ_SPLITVIEW = 694,
		bl_icon_SEQ_STRIP_DUPLICATE = 695,
		bl_icon_SEQ_STRIP_META = 696,
		bl_icon_IMAGE_ALPHA = 697,
		bl_icon_IMAGE_RGB_ALPHA = 698,
		bl_icon_IMAGE_RGB = 699,
		bl_icon_IMAGE_ZDEPTH = 700,
		bl_icon_BLENDER_LOGO_LARGE = 701,
		bl_icon_CANCEL_LARGE = 702,
		bl_icon_DISC_LARGE = 703,
		bl_icon_DISK_DRIVE_LARGE = 704,
		bl_icon_EXTERNAL_DRIVE_LARGE = 705,
		bl_icon_FILE_FOLDER_LARGE = 706,
		bl_icon_FILE_LARGE = 707,
		bl_icon_FILE_PARENT_LARGE = 708,
		bl_icon_INFO_LARGE = 709,
		bl_icon_NETWORK_DRIVE_LARGE = 710,
		bl_icon_QUESTION_LARGE = 711,
		bl_icon_WARNING_LARGE = 712,
		bl_icon_KEY_BACKSPACE_FILLED = 713,
		bl_icon_KEY_BACKSPACE = 714,
		bl_icon_KEY_COMMAND_FILLED = 715,
		bl_icon_KEY_COMMAND = 716,
		bl_icon_KEY_CONTROL_FILLED = 717,
		bl_icon_KEY_CONTROL = 718,
		bl_icon_KEY_EMPTY1_FILLED = 719,
		bl_icon_KEY_EMPTY1 = 720,
		bl_icon_KEY_EMPTY2_FILLED = 721,
		bl_icon_KEY_EMPTY2 = 722,
		bl_icon_KEY_EMPTY3_FILLED = 723,
		bl_icon_KEY_EMPTY3 = 724,
		bl_icon_KEY_MENU_FILLED = 725,
		bl_icon_KEY_MENU = 726,
		bl_icon_KEY_OPTION_FILLED = 727,
		bl_icon_KEY_OPTION = 728,
		bl_icon_KEY_RETURN_FILLED = 729,
		bl_icon_KEY_RETURN = 730,
		bl_icon_KEY_RING_FILLED = 731,
		bl_icon_KEY_RING = 732,
		bl_icon_KEY_SHIFT_FILLED = 733,
		bl_icon_KEY_SHIFT = 734,
		bl_icon_KEY_TAB_FILLED = 735,
		bl_icon_KEY_TAB = 736,
		bl_icon_KEY_WINDOWS_FILLED = 737,
		bl_icon_KEY_WINDOWS = 738,
		bl_icon_GESTURE_PAN = 739,
		bl_icon_GESTURE_ROTATE = 740,
		bl_icon_GESTURE_ZOOM = 741,
		bl_icon_FUND = 742,
		bl_icon_HEART = 743,
		bl_icon_INTERNET_OFFLINE = 744,
		bl_icon_INTERNET = 745,
		bl_icon_USER = 746,
		bl_icon_EXPERIMENTAL = 747,
		bl_icon_MEMORY = 748,
		bl_icon_RGB_RED = 750,
		bl_icon_RGB_GREEN = 751,
		bl_icon_RGB_BLUE = 752,
		bl_icon_KEYTYPE_KEYFRAME_VEC = 753,
		bl_icon_KEYTYPE_BREAKDOWN_VEC = 754,
		bl_icon_KEYTYPE_EXTREME_VEC = 755,
		bl_icon_KEYTYPE_JITTER_VEC = 756,
		bl_icon_KEYTYPE_MOVING_HOLD_VEC = 757,
		bl_icon_KEYTYPE_GENERATED_VEC = 758,
		bl_icon_HANDLETYPE_FREE_VEC = 759,
		bl_icon_HANDLETYPE_ALIGNED_VEC = 760,
		bl_icon_HANDLETYPE_VECTOR_VEC = 761,
		bl_icon_HANDLETYPE_AUTO_VEC = 762,
		bl_icon_HANDLETYPE_AUTO_CLAMP_VEC = 763,
		bl_icon_COLORSET_01_VEC = 764,
		bl_icon_COLORSET_02_VEC = 765,
		bl_icon_COLORSET_03_VEC = 766,
		bl_icon_COLORSET_04_VEC = 767,
		bl_icon_COLORSET_05_VEC = 768,
		bl_icon_COLORSET_06_VEC = 769,
		bl_icon_COLORSET_07_VEC = 770,
		bl_icon_COLORSET_08_VEC = 771,
		bl_icon_COLORSET_09_VEC = 772,
		bl_icon_COLORSET_10_VEC = 773,
		bl_icon_COLORSET_11_VEC = 774,
		bl_icon_COLORSET_12_VEC = 775,
		bl_icon_COLORSET_13_VEC = 776,
		bl_icon_COLORSET_14_VEC = 777,
		bl_icon_COLORSET_15_VEC = 778,
		bl_icon_COLORSET_16_VEC = 779,
		bl_icon_COLORSET_17_VEC = 780,
		bl_icon_COLORSET_18_VEC = 781,
		bl_icon_COLORSET_19_VEC = 782,
		bl_icon_COLORSET_20_VEC = 783,
		bl_icon_COLLECTION_COLOR_01 = 784,
		bl_icon_COLLECTION_COLOR_02 = 785,
		bl_icon_COLLECTION_COLOR_03 = 786,
		bl_icon_COLLECTION_COLOR_04 = 787,
		bl_icon_COLLECTION_COLOR_05 = 788,
		bl_icon_COLLECTION_COLOR_06 = 789,
		bl_icon_COLLECTION_COLOR_07 = 790,
		bl_icon_COLLECTION_COLOR_08 = 791,
		bl_icon_STRIP_COLOR_01 = 792,
		bl_icon_STRIP_COLOR_02 = 793,
		bl_icon_STRIP_COLOR_03 = 794,
		bl_icon_STRIP_COLOR_04 = 795,
		bl_icon_STRIP_COLOR_05 = 796,
		bl_icon_STRIP_COLOR_06 = 797,
		bl_icon_STRIP_COLOR_07 = 798,
		bl_icon_STRIP_COLOR_08 = 799,
		bl_icon_STRIP_COLOR_09 = 800,
		bl_icon_LIBRARY_DATA_INDIRECT = 801,
		bl_icon_LIBRARY_DATA_OVERRIDE_NONEDITABLE = 802,
		bl_icon_LAYERGROUP_COLOR_01 = 803,
		bl_icon_LAYERGROUP_COLOR_02 = 804,
		bl_icon_LAYERGROUP_COLOR_03 = 805,
		bl_icon_LAYERGROUP_COLOR_04 = 806,
		bl_icon_LAYERGROUP_COLOR_05 = 807,
		bl_icon_LAYERGROUP_COLOR_06 = 808,
		bl_icon_LAYERGROUP_COLOR_07 = 809,
		bl_icon_LAYERGROUP_COLOR_08 = 810,
		bl_icon_EVENT_A = 811,
		bl_icon_EVENT_B = 812,
		bl_icon_EVENT_C = 813,
		bl_icon_EVENT_D = 814,
		bl_icon_EVENT_E = 815,
		bl_icon_EVENT_F = 816,
		bl_icon_EVENT_G = 817,
		bl_icon_EVENT_H = 818,
		bl_icon_EVENT_I = 819,
		bl_icon_EVENT_J = 820,
		bl_icon_EVENT_K = 821,
		bl_icon_EVENT_L = 822,
		bl_icon_EVENT_M = 823,
		bl_icon_EVENT_N = 824,
		bl_icon_EVENT_O = 825,
		bl_icon_EVENT_P = 826,
		bl_icon_EVENT_Q = 827,
		bl_icon_EVENT_R = 828,
		bl_icon_EVENT_S = 829,
		bl_icon_EVENT_T = 830,
		bl_icon_EVENT_U = 831,
		bl_icon_EVENT_V = 832,
		bl_icon_EVENT_W = 833,
		bl_icon_EVENT_X = 834,
		bl_icon_EVENT_Y = 835,
		bl_icon_EVENT_Z = 836,
		bl_icon_EVENT_SHIFT = 837,
		bl_icon_EVENT_CTRL = 838,
		bl_icon_EVENT_ALT = 839,
		bl_icon_EVENT_OS = 840,
		bl_icon_EVENT_HYPER = 841,
		bl_icon_EVENT_F1 = 842,
		bl_icon_EVENT_F2 = 843,
		bl_icon_EVENT_F3 = 844,
		bl_icon_EVENT_F4 = 845,
		bl_icon_EVENT_F5 = 846,
		bl_icon_EVENT_F6 = 847,
		bl_icon_EVENT_F7 = 848,
		bl_icon_EVENT_F8 = 849,
		bl_icon_EVENT_F9 = 850,
		bl_icon_EVENT_F10 = 851,
		bl_icon_EVENT_F11 = 852,
		bl_icon_EVENT_F12 = 853,
		bl_icon_EVENT_F13 = 854,
		bl_icon_EVENT_F14 = 855,
		bl_icon_EVENT_F15 = 856,
		bl_icon_EVENT_F16 = 857,
		bl_icon_EVENT_F17 = 858,
		bl_icon_EVENT_F18 = 859,
		bl_icon_EVENT_F19 = 860,
		bl_icon_EVENT_F20 = 861,
		bl_icon_EVENT_F21 = 862,
		bl_icon_EVENT_F22 = 863,
		bl_icon_EVENT_F23 = 864,
		bl_icon_EVENT_F24 = 865,
		bl_icon_EVENT_ESC = 866,
		bl_icon_EVENT_TAB = 867,
		bl_icon_EVENT_PAGEUP = 868,
		bl_icon_EVENT_PAGEDOWN = 869,
		bl_icon_EVENT_RETURN = 870,
		bl_icon_EVENT_SPACEKEY = 871,
		bl_icon_EVENT_ZEROKEY = 872,
		bl_icon_EVENT_ONEKEY = 873,
		bl_icon_EVENT_TWOKEY = 874,
		bl_icon_EVENT_THREEKEY = 875,
		bl_icon_EVENT_FOURKEY = 876,
		bl_icon_EVENT_FIVEKEY = 877,
		bl_icon_EVENT_SIXKEY = 878,
		bl_icon_EVENT_SEVENKEY = 879,
		bl_icon_EVENT_EIGHTKEY = 880,
		bl_icon_EVENT_NINEKEY = 881,
		bl_icon_EVENT_PAD0 = 882,
		bl_icon_EVENT_PAD1 = 883,
		bl_icon_EVENT_PAD2 = 884,
		bl_icon_EVENT_PAD3 = 885,
		bl_icon_EVENT_PAD4 = 886,
		bl_icon_EVENT_PAD5 = 887,
		bl_icon_EVENT_PAD6 = 888,
		bl_icon_EVENT_PAD7 = 889,
		bl_icon_EVENT_PAD8 = 890,
		bl_icon_EVENT_PAD9 = 891,
		bl_icon_EVENT_PADASTER = 892,
		bl_icon_EVENT_PADSLASH = 893,
		bl_icon_EVENT_PADMINUS = 894,
		bl_icon_EVENT_PADENTER = 895,
		bl_icon_EVENT_PADPLUS = 896,
		bl_icon_EVENT_PADPERIOD = 897,
		bl_icon_EVENT_MOUSE_4 = 898,
		bl_icon_EVENT_MOUSE_5 = 899,
		bl_icon_EVENT_MOUSE_6 = 900,
		bl_icon_EVENT_MOUSE_7 = 901,
		bl_icon_EVENT_TABLET_STYLUS = 902,
		bl_icon_EVENT_TABLET_ERASER = 903,
		bl_icon_EVENT_LEFT_ARROW = 904,
		bl_icon_EVENT_DOWN_ARROW = 905,
		bl_icon_EVENT_RIGHT_ARROW = 906,
		bl_icon_EVENT_UP_ARROW = 907,
		bl_icon_EVENT_PAUSE = 908,
		bl_icon_EVENT_INSERT = 909,
		bl_icon_EVENT_HOME = 910,
		bl_icon_EVENT_END = 911,
		bl_icon_EVENT_UNKNOWN = 912,
		bl_icon_EVENT_GRLESS = 913,
		bl_icon_EVENT_MEDIAPLAY = 914,
		bl_icon_EVENT_MEDIASTOP = 915,
		bl_icon_EVENT_MEDIAFIRST = 916,
		bl_icon_EVENT_MEDIALAST = 917,
		bl_icon_EVENT_APP = 918,
		bl_icon_EVENT_CAPSLOCK = 919,
		bl_icon_EVENT_BACKSPACE = 920,
		bl_icon_EVENT_DEL = 921,
		bl_icon_EVENT_SEMICOLON = 922,
		bl_icon_EVENT_PERIOD = 923,
		bl_icon_EVENT_COMMA = 924,
		bl_icon_EVENT_QUOTE = 925,
		bl_icon_EVENT_ACCENTGRAVE = 926,
		bl_icon_EVENT_MINUS = 927,
		bl_icon_EVENT_PLUS = 928,
		bl_icon_EVENT_SLASH = 929,
		bl_icon_EVENT_BACKSLASH = 930,
		bl_icon_EVENT_EQUAL = 931,
		bl_icon_EVENT_LEFTBRACKET = 932,
		bl_icon_EVENT_RIGHTBRACKET = 933,
		bl_icon_EVENT_PAD_PAN = 934,
		bl_icon_EVENT_PAD_ROTATE = 935,
		bl_icon_EVENT_PAD_ZOOM = 936,
		bl_icon_EVENT_NDOF_BUTTON_V1 = 937,
		bl_icon_EVENT_NDOF_BUTTON_V2 = 938,
		bl_icon_EVENT_NDOF_BUTTON_V3 = 939,
		bl_icon_EVENT_NDOF_BUTTON_SAVE_V1 = 940,
		bl_icon_EVENT_NDOF_BUTTON_SAVE_V2 = 941,
		bl_icon_EVENT_NDOF_BUTTON_SAVE_V3 = 942,
		bl_icon_EVENT_NDOF_BUTTON_1 = 943,
		bl_icon_EVENT_NDOF_BUTTON_2 = 944,
		bl_icon_EVENT_NDOF_BUTTON_3 = 945,
		bl_icon_EVENT_NDOF_BUTTON_4 = 946,
		bl_icon_EVENT_NDOF_BUTTON_5 = 947,
		bl_icon_EVENT_NDOF_BUTTON_6 = 948,
		bl_icon_EVENT_NDOF_BUTTON_7 = 949,
		bl_icon_EVENT_NDOF_BUTTON_8 = 950,
		bl_icon_EVENT_NDOF_BUTTON_9 = 951,
		bl_icon_EVENT_NDOF_BUTTON_10 = 952,
		bl_icon_EVENT_NDOF_BUTTON_11 = 953,
		bl_icon_EVENT_NDOF_BUTTON_12 = 954,
		bl_icon_EVENT_NDOF_BUTTON_MENU = 955,
		bl_icon_EVENT_NDOF_BUTTON_FIT = 956,
		bl_icon_EVENT_NDOF_BUTTON_TOP = 957,
		bl_icon_EVENT_NDOF_BUTTON_BOTTOM = 958,
		bl_icon_EVENT_NDOF_BUTTON_LEFT = 959,
		bl_icon_EVENT_NDOF_BUTTON_RIGHT = 960,
		bl_icon_EVENT_NDOF_BUTTON_FRONT = 961,
		bl_icon_EVENT_NDOF_BUTTON_BACK = 962,
		bl_icon_EVENT_NDOF_BUTTON_ISO1 = 963,
		bl_icon_EVENT_NDOF_BUTTON_ISO2 = 964,
		bl_icon_EVENT_NDOF_BUTTON_ROLL_CW = 965,
		bl_icon_EVENT_NDOF_BUTTON_ROLL_CCW = 966,
		bl_icon_EVENT_NDOF_BUTTON_SPIN_CW = 967,
		bl_icon_EVENT_NDOF_BUTTON_SPIN_CCW = 968,
		bl_icon_EVENT_NDOF_BUTTON_TILT_CW = 969,
		bl_icon_EVENT_NDOF_BUTTON_TILT_CCW = 970,
		bl_icon_EVENT_NDOF_BUTTON_ROTATE = 971,
		bl_icon_EVENT_NDOF_BUTTON_PANZOOM = 972,
		bl_icon_EVENT_NDOF_BUTTON_DOMINANT = 973,
		bl_icon_EVENT_NDOF_BUTTON_PLUS = 974,
		bl_icon_EVENT_NDOF_BUTTON_MINUS = 975,
		bl_icon_NODE_SOCKET_FLOAT = 976,
		bl_icon_NODE_SOCKET_VECTOR = 977,
		bl_icon_NODE_SOCKET_RGBA = 978,
		bl_icon_NODE_SOCKET_SHADER = 979,
		bl_icon_NODE_SOCKET_BOOLEAN = 980,
		bl_icon_NODE_SOCKET_INT = 981,
		bl_icon_NODE_SOCKET_STRING = 982,
		bl_icon_NODE_SOCKET_OBJECT = 983,
		bl_icon_NODE_SOCKET_IMAGE = 984,
		bl_icon_NODE_SOCKET_GEOMETRY = 985,
		bl_icon_NODE_SOCKET_COLLECTION = 986,
		bl_icon_NODE_SOCKET_TEXTURE = 987,
		bl_icon_NODE_SOCKET_MATERIAL = 988,
		bl_icon_NODE_SOCKET_ROTATION = 989,
		bl_icon_NODE_SOCKET_MENU = 990,
		bl_icon_NODE_SOCKET_MATRIX = 991,
		bl_icon_NODE_SOCKET_BUNDLE = 992,
		bl_icon_NODE_SOCKET_CLOSURE = 993,
	};
	inline bl_icon_enum bl_icon(void);
	inline void bl_icon(bl_icon_enum value);
	inline std::string bl_static_type(void);
	inline void bl_static_type(const std::string& value);
	inline float bl_width_default(void);
	inline void bl_width_default(float value);
	inline float bl_width_min(void);
	inline void bl_width_min(float value);
	inline float bl_width_max(void);
	inline void bl_width_max(float value);
	inline float bl_height_default(void);
	inline void bl_height_default(float value);
	inline float bl_height_min(void);
	inline void bl_height_min(float value);
	inline float bl_height_max(void);
	inline void bl_height_max(float value);

	inline void socket_value_update(Context& context);
	inline bool is_registered_node_type();
	inline void debug_zone_body_lazy_function_graph(Context C, int *dot_graph_len, const char * *dot_graph);
	inline void debug_zone_lazy_function_graph(Context C, int *dot_graph_len, const char * *dot_graph);
};

/**************** NodeLink ****************/

class NodeLink : public Pointer {
public:
	NodeLink(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool is_valid(void);
	inline void is_valid(bool value);
	inline bool is_muted(void);
	inline void is_muted(bool value);
	inline Node from_node(void);
	inline Node to_node(void);
	inline NodeSocket from_socket(void);
	inline NodeSocket to_socket(void);
	inline bool is_hidden(void);
	inline void is_hidden(bool value);
	inline int multi_input_sort_id(void);
	inline void multi_input_sort_id(int value);

	inline void swap_multi_input_sort_id(void *main, NodeLink& other);
};

/**************** Socket Template ****************/

class NodeInternalSocketTemplate : public Pointer {
public:
	NodeInternalSocketTemplate(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline std::string identifier(void);
	inline void identifier(const std::string& value);
	enum type_enum {
		type_CUSTOM = -1,
		type_VALUE = 0,
		type_INT = 6,
		type_BOOLEAN = 4,
		type_VECTOR = 1,
		type_ROTATION = 14,
		type_MATRIX = 16,
		type_STRING = 7,
		type_RGBA = 2,
		type_SHADER = 3,
		type_OBJECT = 8,
		type_IMAGE = 9,
		type_GEOMETRY = 10,
		type_COLLECTION = 11,
		type_TEXTURE = 12,
		type_MATERIAL = 13,
		type_MENU = 15,
		type_BUNDLE = 17,
		type_CLOSURE = 18,
	};
	inline type_enum type(void);
	inline void type(type_enum value);

};

/**************** NodeInternal ****************/

class NodeInternal : public Node {
public:
	NodeInternal(const PointerRNA &ptr_arg) :
		Node(ptr_arg)
		{}


	inline bool poll(NodeTree& node_tree);
	inline bool poll_instance(NodeTree& node_tree);
	inline void update(void *main);
	inline void draw_buttons(Context& context, UILayout& layout);
	inline void draw_buttons_ext(Context& context, UILayout& layout);
};

/**************** Shader Node ****************/

class ShaderNode : public NodeInternal {
public:
	ShaderNode(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


};

/**************** Compositor Node ****************/

class CompositorNode : public NodeInternal {
public:
	CompositorNode(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


	inline void tag_need_exec();
};

/**************** CryptomatteEntry ****************/

class CryptomatteEntry : public Pointer {
public:
	CryptomatteEntry(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline float encoded_hash(void);
	inline void encoded_hash(float value);
	inline std::string name(void);
	inline void name(const std::string& value);

};

/**************** Texture Node ****************/

class TextureNode : public NodeInternal {
public:
	TextureNode(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


};

/**************** Geometry Node ****************/

class GeometryNode : public NodeInternal {
public:
	GeometryNode(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


};

/**************** Function Node ****************/

class FunctionNode : public NodeInternal {
public:
	FunctionNode(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


};

/**************** Node Tree ****************/

class NodeTree : public ID {
public:
	NodeTree(const PointerRNA &ptr_arg) :
		ID(ptr_arg),
		nodes(ptr_arg),
		links(ptr_arg)
		{}

	enum color_tag_enum {
		color_tag_NONE = 0,
		color_tag_ATTRIBUTE = 1,
		color_tag_COLOR = 2,
		color_tag_CONVERTER = 3,
		color_tag_DISTORT = 4,
		color_tag_FILTER = 5,
		color_tag_GEOMETRY = 6,
		color_tag_INPUT = 7,
		color_tag_MATTE = 8,
		color_tag_OUTPUT = 9,
		color_tag_SCRIPT = 10,
		color_tag_SHADER = 11,
		color_tag_TEXTURE = 12,
		color_tag_VECTOR = 13,
		color_tag_PATTERN = 14,
		color_tag_INTERFACE = 15,
		color_tag_GROUP = 16,
	};
	inline color_tag_enum color_tag(void);
	inline void color_tag(color_tag_enum value);
	inline int default_group_node_width(void);
	inline void default_group_node_width(int value);
	inline Array<float, 2> view_center(void);
	inline void view_center(float values[2]);
	inline std::string description(void);
	inline void description(const std::string& value);
	inline AnimData animation_data(void);
	COLLECTION_PROPERTY(Nodes, Node, NodeTree, nodes, false, true, true)
	COLLECTION_PROPERTY(NodeLinks, NodeLink, NodeTree, links, false, true, false)
	inline GreasePencil grease_pencil(void);
	enum type_enum {
		type_UNDEFINED = -2,
		type_CUSTOM = -1,
		type_SHADER = 0,
		type_TEXTURE = 2,
		type_COMPOSITING = 1,
		type_GEOMETRY = 3,
	};
	inline type_enum type(void);
	inline void type(type_enum value);
	inline NodeTreeInterface interface(void);
	inline std::string bl_idname(void);
	inline void bl_idname(const std::string& value);
	inline std::string bl_label(void);
	inline void bl_label(const std::string& value);
	inline std::string bl_description(void);
	inline void bl_description(const std::string& value);
	enum bl_icon_enum {
		bl_icon_NONE = 0,
		bl_icon_CHAR_NOTDEF = 1,
		bl_icon_CHAR_REPLACEMENT = 2,
		bl_icon_NOT_FOUND = 3,
		bl_icon_BLANK1 = 4,
		bl_icon_AUTOMERGE_OFF = 5,
		bl_icon_AUTOMERGE_ON = 6,
		bl_icon_CHECKBOX_DEHLT = 7,
		bl_icon_CHECKBOX_HLT = 8,
		bl_icon_CLIPUV_DEHLT = 9,
		bl_icon_CLIPUV_HLT = 10,
		bl_icon_DECORATE_UNLOCKED = 11,
		bl_icon_DECORATE_LOCKED = 12,
		bl_icon_FAKE_USER_OFF = 13,
		bl_icon_FAKE_USER_ON = 14,
		bl_icon_HIDE_ON = 15,
		bl_icon_HIDE_OFF = 16,
		bl_icon_INDIRECT_ONLY_OFF = 17,
		bl_icon_INDIRECT_ONLY_ON = 18,
		bl_icon_ONIONSKIN_OFF = 19,
		bl_icon_ONIONSKIN_ON = 20,
		bl_icon_UNPINNED = 21,
		bl_icon_PINNED = 22,
		bl_icon_RADIOBUT_OFF = 23,
		bl_icon_RADIOBUT_ON = 24,
		bl_icon_RECORD_OFF = 25,
		bl_icon_RECORD_ON = 26,
		bl_icon_RESTRICT_RENDER_ON = 27,
		bl_icon_RESTRICT_RENDER_OFF = 28,
		bl_icon_RESTRICT_SELECT_ON = 29,
		bl_icon_RESTRICT_SELECT_OFF = 30,
		bl_icon_RESTRICT_VIEW_ON = 31,
		bl_icon_RESTRICT_VIEW_OFF = 32,
		bl_icon_RIGHTARROW = 33,
		bl_icon_DOWNARROW_HLT = 34,
		bl_icon_SELECT_INTERSECT = 35,
		bl_icon_SELECT_DIFFERENCE = 36,
		bl_icon_SNAP_OFF = 37,
		bl_icon_SNAP_ON = 38,
		bl_icon_UNLOCKED = 39,
		bl_icon_LOCKED = 40,
		bl_icon_VIS_SEL_11 = 41,
		bl_icon_VIS_SEL_10 = 42,
		bl_icon_VIS_SEL_01 = 43,
		bl_icon_VIS_SEL_00 = 44,
		bl_icon_CANCEL = 45,
		bl_icon_ERROR = 46,
		bl_icon_QUESTION = 47,
		bl_icon_ADD = 48,
		bl_icon_ARROW_LEFTRIGHT = 49,
		bl_icon_AUTO = 50,
		bl_icon_BLENDER = 51,
		bl_icon_BORDERMOVE = 52,
		bl_icon_BRUSHES_ALL = 53,
		bl_icon_CHECKMARK = 54,
		bl_icon_COLLAPSEMENU = 55,
		bl_icon_COLLECTION_NEW = 56,
		bl_icon_COLOR = 57,
		bl_icon_COPY_ID = 58,
		bl_icon_DISCLOSURE_TRI_DOWN = 59,
		bl_icon_DISCLOSURE_TRI_RIGHT = 60,
		bl_icon_DOT = 61,
		bl_icon_DRIVER_DISTANCE = 62,
		bl_icon_DRIVER_ROTATIONAL_DIFFERENCE = 63,
		bl_icon_DRIVER_TRANSFORM = 64,
		bl_icon_DUPLICATE = 65,
		bl_icon_EYEDROPPER = 66,
		bl_icon_FCURVE_SNAPSHOT = 67,
		bl_icon_FILE_NEW = 68,
		bl_icon_FILE_TICK = 69,
		bl_icon_FREEZE = 70,
		bl_icon_FULLSCREEN_ENTER = 71,
		bl_icon_FULLSCREEN_EXIT = 72,
		bl_icon_GHOST_DISABLED = 73,
		bl_icon_GHOST_ENABLED = 74,
		bl_icon_GRIP = 75,
		bl_icon_GRIP_V = 76,
		bl_icon_HAND = 77,
		bl_icon_HELP = 78,
		bl_icon_LINKED = 79,
		bl_icon_MENU_PANEL = 80,
		bl_icon_NODE_SEL = 81,
		bl_icon_NODE = 82,
		bl_icon_OBJECT_HIDDEN = 83,
		bl_icon_OPTIONS = 84,
		bl_icon_PANEL_CLOSE = 85,
		bl_icon_PLUGIN = 86,
		bl_icon_PLUS = 87,
		bl_icon_PRESET_NEW = 88,
		bl_icon_QUIT = 89,
		bl_icon_RECOVER_LAST = 90,
		bl_icon_REMOVE = 91,
		bl_icon_RIGHTARROW_THIN = 92,
		bl_icon_SCREEN_BACK = 93,
		bl_icon_STATUSBAR = 94,
		bl_icon_STYLUS_PRESSURE = 95,
		bl_icon_THREE_DOTS = 96,
		bl_icon_TOPBAR = 97,
		bl_icon_TRASH = 98,
		bl_icon_TRIA_DOWN = 99,
		bl_icon_TRIA_LEFT = 100,
		bl_icon_TRIA_RIGHT = 101,
		bl_icon_TRIA_UP = 102,
		bl_icon_UNLINKED = 103,
		bl_icon_URL = 104,
		bl_icon_VIEWZOOM = 105,
		bl_icon_WINDOW = 106,
		bl_icon_WORKSPACE = 107,
		bl_icon_X = 108,
		bl_icon_ZOOM_ALL = 109,
		bl_icon_ZOOM_IN = 110,
		bl_icon_ZOOM_OUT = 111,
		bl_icon_ZOOM_PREVIOUS = 112,
		bl_icon_ZOOM_SELECTED = 113,
		bl_icon_MODIFIER = 114,
		bl_icon_PARTICLES = 115,
		bl_icon_PHYSICS = 116,
		bl_icon_SHADERFX = 117,
		bl_icon_SPEAKER = 118,
		bl_icon_OUTPUT = 119,
		bl_icon_SCENE = 120,
		bl_icon_TOOL_SETTINGS = 121,
		bl_icon_LIGHT = 122,
		bl_icon_MATERIAL = 123,
		bl_icon_TEXTURE = 124,
		bl_icon_WORLD = 125,
		bl_icon_ANIM = 126,
		bl_icon_SCRIPT = 127,
		bl_icon_GEOMETRY_NODES = 128,
		bl_icon_TEXT = 129,
		bl_icon_ACTION = 130,
		bl_icon_ASSET_MANAGER = 131,
		bl_icon_CONSOLE = 132,
		bl_icon_FILEBROWSER = 133,
		bl_icon_GEOMETRY_SET = 134,
		bl_icon_GRAPH = 135,
		bl_icon_IMAGE = 136,
		bl_icon_INFO = 137,
		bl_icon_NLA = 138,
		bl_icon_NODE_COMPOSITING = 139,
		bl_icon_NODE_MATERIAL = 140,
		bl_icon_NODE_TEXTURE = 141,
		bl_icon_NODETREE = 142,
		bl_icon_OUTLINER = 143,
		bl_icon_PREFERENCES = 144,
		bl_icon_PROPERTIES = 145,
		bl_icon_SEQUENCE = 146,
		bl_icon_SOUND = 147,
		bl_icon_SPREADSHEET = 148,
		bl_icon_TIME = 149,
		bl_icon_TRACKER = 150,
		bl_icon_UV = 151,
		bl_icon_VIEW3D = 152,
		bl_icon_EDITMODE_HLT = 153,
		bl_icon_OBJECT_DATAMODE = 154,
		bl_icon_PARTICLEMODE = 155,
		bl_icon_POSE_HLT = 156,
		bl_icon_SCULPTMODE_HLT = 157,
		bl_icon_TPAINT_HLT = 158,
		bl_icon_UV_DATA = 159,
		bl_icon_VPAINT_HLT = 160,
		bl_icon_WPAINT_HLT = 161,
		bl_icon_TRACKER_DATA = 162,
		bl_icon_TRACKING_BACKWARDS_SINGLE = 163,
		bl_icon_TRACKING_BACKWARDS = 164,
		bl_icon_TRACKING_CLEAR_BACKWARDS = 165,
		bl_icon_TRACKING_CLEAR_FORWARDS = 166,
		bl_icon_TRACKING_FORWARDS_SINGLE = 167,
		bl_icon_TRACKING_FORWARDS = 168,
		bl_icon_TRACKING_REFINE_BACKWARDS = 169,
		bl_icon_TRACKING_REFINE_FORWARDS = 170,
		bl_icon_TRACKING = 171,
		bl_icon_GROUP = 172,
		bl_icon_CONSTRAINT_BONE = 173,
		bl_icon_CONSTRAINT = 174,
		bl_icon_ARMATURE_DATA = 175,
		bl_icon_BONE_DATA = 176,
		bl_icon_CAMERA_DATA = 177,
		bl_icon_CURVE_DATA = 178,
		bl_icon_EMPTY_DATA = 179,
		bl_icon_FONT_DATA = 180,
		bl_icon_LATTICE_DATA = 181,
		bl_icon_LIGHT_DATA = 182,
		bl_icon_MESH_DATA = 183,
		bl_icon_META_DATA = 184,
		bl_icon_PARTICLE_DATA = 185,
		bl_icon_SHAPEKEY_DATA = 186,
		bl_icon_SURFACE_DATA = 187,
		bl_icon_OBJECT_DATA = 188,
		bl_icon_RENDER_RESULT = 189,
		bl_icon_RENDERLAYERS = 190,
		bl_icon_SCENE_DATA = 191,
		bl_icon_BRUSH_DATA = 192,
		bl_icon_IMAGE_DATA = 193,
		bl_icon_LINE_DATA = 194,
		bl_icon_MATERIAL_DATA = 195,
		bl_icon_TEXTURE_DATA = 196,
		bl_icon_WORLD_DATA = 197,
		bl_icon_ANIM_DATA = 198,
		bl_icon_BOIDS = 199,
		bl_icon_CAMERA_STEREO = 200,
		bl_icon_COMMUNITY = 201,
		bl_icon_FACE_MAPS = 202,
		bl_icon_FCURVE = 203,
		bl_icon_FILE = 204,
		bl_icon_GREASEPENCIL = 205,
		bl_icon_GREASEPENCIL_LAYER_GROUP = 206,
		bl_icon_GROUP_BONE = 207,
		bl_icon_GROUP_UVS = 208,
		bl_icon_GROUP_VCOL = 209,
		bl_icon_GROUP_VERTEX = 210,
		bl_icon_LIBRARY_DATA_BROKEN = 211,
		bl_icon_LIBRARY_DATA_DIRECT = 212,
		bl_icon_LIBRARY_DATA_OVERRIDE = 213,
		bl_icon_ORPHAN_DATA = 214,
		bl_icon_PACKAGE = 215,
		bl_icon_PRESET = 216,
		bl_icon_RENDER_ANIMATION = 217,
		bl_icon_RENDER_STILL = 218,
		bl_icon_RNA_ADD = 219,
		bl_icon_RNA = 220,
		bl_icon_STRANDS = 221,
		bl_icon_UGLYPACKAGE = 222,
		bl_icon_MOUSE_LMB = 223,
		bl_icon_MOUSE_MMB = 224,
		bl_icon_MOUSE_RMB = 225,
		bl_icon_MOUSE_MMB_SCROLL = 226,
		bl_icon_MOUSE_LMB_2X = 227,
		bl_icon_MOUSE_MOVE = 228,
		bl_icon_MOUSE_LMB_DRAG = 229,
		bl_icon_MOUSE_MMB_DRAG = 230,
		bl_icon_MOUSE_RMB_DRAG = 231,
		bl_icon_DECORATE_ANIMATE = 232,
		bl_icon_DECORATE_DRIVER = 233,
		bl_icon_DECORATE_KEYFRAME = 234,
		bl_icon_DECORATE_LIBRARY_OVERRIDE = 235,
		bl_icon_DECORATE_LINKED = 236,
		bl_icon_DECORATE_OVERRIDE = 237,
		bl_icon_DECORATE = 238,
		bl_icon_OUTLINER_COLLECTION = 239,
		bl_icon_CURVES_DATA = 240,
		bl_icon_OUTLINER_DATA_ARMATURE = 241,
		bl_icon_OUTLINER_DATA_CAMERA = 242,
		bl_icon_OUTLINER_DATA_CURVE = 243,
		bl_icon_OUTLINER_DATA_CURVES = 244,
		bl_icon_OUTLINER_DATA_EMPTY = 245,
		bl_icon_OUTLINER_DATA_FONT = 246,
		bl_icon_OUTLINER_DATA_GP_LAYER = 247,
		bl_icon_OUTLINER_DATA_GREASEPENCIL = 248,
		bl_icon_OUTLINER_DATA_LATTICE = 249,
		bl_icon_OUTLINER_DATA_LIGHT = 250,
		bl_icon_OUTLINER_DATA_LIGHTPROBE = 251,
		bl_icon_OUTLINER_DATA_MESH = 252,
		bl_icon_OUTLINER_DATA_META = 253,
		bl_icon_OUTLINER_DATA_POINTCLOUD = 254,
		bl_icon_OUTLINER_DATA_SPEAKER = 255,
		bl_icon_OUTLINER_DATA_SURFACE = 256,
		bl_icon_OUTLINER_DATA_VOLUME = 257,
		bl_icon_POINTCLOUD_DATA = 258,
		bl_icon_POINTCLOUD_POINT = 259,
		bl_icon_VOLUME_DATA = 260,
		bl_icon_OUTLINER_OB_ARMATURE = 261,
		bl_icon_OUTLINER_OB_CAMERA = 262,
		bl_icon_OUTLINER_OB_CURVE = 263,
		bl_icon_OUTLINER_OB_CURVES = 264,
		bl_icon_OUTLINER_OB_EMPTY = 265,
		bl_icon_OUTLINER_OB_FONT = 266,
		bl_icon_OUTLINER_OB_FORCE_FIELD = 267,
		bl_icon_OUTLINER_OB_GREASEPENCIL = 268,
		bl_icon_OUTLINER_OB_GROUP_INSTANCE = 269,
		bl_icon_OUTLINER_OB_IMAGE = 270,
		bl_icon_OUTLINER_OB_LATTICE = 271,
		bl_icon_OUTLINER_OB_LIGHT = 272,
		bl_icon_OUTLINER_OB_LIGHTPROBE = 273,
		bl_icon_OUTLINER_OB_MESH = 274,
		bl_icon_OUTLINER_OB_META = 275,
		bl_icon_OUTLINER_OB_POINTCLOUD = 276,
		bl_icon_OUTLINER_OB_SPEAKER = 277,
		bl_icon_OUTLINER_OB_SURFACE = 278,
		bl_icon_OUTLINER_OB_VOLUME = 279,
		bl_icon_GP_MULTIFRAME_EDITING = 280,
		bl_icon_GP_ONLY_SELECTED = 281,
		bl_icon_GP_SELECT_BETWEEN_STROKES = 282,
		bl_icon_GP_SELECT_POINTS = 283,
		bl_icon_GP_SELECT_STROKES = 284,
		bl_icon_HOLDOUT_OFF = 285,
		bl_icon_HOLDOUT_ON = 286,
		bl_icon_MODIFIER_OFF = 287,
		bl_icon_MODIFIER_ON = 288,
		bl_icon_RESTRICT_COLOR_OFF = 289,
		bl_icon_RESTRICT_COLOR_ON = 290,
		bl_icon_RESTRICT_INSTANCED_OFF = 291,
		bl_icon_RESTRICT_INSTANCED_ON = 292,
		bl_icon_LIGHT_AREA = 293,
		bl_icon_LIGHT_HEMI = 294,
		bl_icon_LIGHT_POINT = 295,
		bl_icon_LIGHT_SPOT = 296,
		bl_icon_LIGHT_SUN = 297,
		bl_icon_LIGHTPROBE_PLANE = 298,
		bl_icon_LIGHTPROBE_SPHERE = 299,
		bl_icon_LIGHTPROBE_VOLUME = 300,
		bl_icon_COLOR_BLUE = 301,
		bl_icon_COLOR_GREEN = 302,
		bl_icon_COLOR_RED = 303,
		bl_icon_CONE = 304,
		bl_icon_CUBE = 305,
		bl_icon_CURVE_BEZCIRCLE = 306,
		bl_icon_CURVE_BEZCURVE = 307,
		bl_icon_CURVE_NCIRCLE = 308,
		bl_icon_CURVE_NCURVE = 309,
		bl_icon_CURVE_PATH = 310,
		bl_icon_CURVES = 311,
		bl_icon_EMPTY_ARROWS = 312,
		bl_icon_EMPTY_AXIS = 313,
		bl_icon_EMPTY_SINGLE_ARROW = 314,
		bl_icon_MESH_CAPSULE = 315,
		bl_icon_MESH_CIRCLE = 316,
		bl_icon_MESH_CONE = 317,
		bl_icon_MESH_CUBE = 318,
		bl_icon_MESH_CYLINDER = 319,
		bl_icon_MESH_GRID = 320,
		bl_icon_MESH_ICOSPHERE = 321,
		bl_icon_MESH_MONKEY = 322,
		bl_icon_MESH_PLANE = 323,
		bl_icon_MESH_TORUS = 324,
		bl_icon_MESH_UVSPHERE = 325,
		bl_icon_META_BALL = 326,
		bl_icon_META_CAPSULE = 327,
		bl_icon_META_CUBE = 328,
		bl_icon_META_ELLIPSOID = 329,
		bl_icon_META_PLANE = 330,
		bl_icon_MONKEY = 331,
		bl_icon_SPHERE = 332,
		bl_icon_STROKE = 333,
		bl_icon_SURFACE_NCIRCLE = 334,
		bl_icon_SURFACE_NCURVE = 335,
		bl_icon_SURFACE_NCYLINDER = 336,
		bl_icon_SURFACE_NSPHERE = 337,
		bl_icon_SURFACE_NSURFACE = 338,
		bl_icon_SURFACE_NTORUS = 339,
		bl_icon_TRIA_DOWN_BAR = 340,
		bl_icon_TRIA_LEFT_BAR = 341,
		bl_icon_TRIA_RIGHT_BAR = 342,
		bl_icon_TRIA_UP_BAR = 343,
		bl_icon_AREA_DOCK = 344,
		bl_icon_AREA_JOIN_DOWN = 345,
		bl_icon_AREA_JOIN_LEFT = 346,
		bl_icon_AREA_JOIN_UP = 347,
		bl_icon_AREA_JOIN = 348,
		bl_icon_AREA_SWAP = 349,
		bl_icon_FORCE_BOID = 350,
		bl_icon_FORCE_CHARGE = 351,
		bl_icon_FORCE_CURVE = 352,
		bl_icon_FORCE_DRAG = 353,
		bl_icon_FORCE_FLUIDFLOW = 354,
		bl_icon_FORCE_FORCE = 355,
		bl_icon_FORCE_HARMONIC = 356,
		bl_icon_FORCE_LENNARDJONES = 357,
		bl_icon_FORCE_MAGNETIC = 358,
		bl_icon_FORCE_TEXTURE = 359,
		bl_icon_FORCE_TURBULENCE = 360,
		bl_icon_FORCE_VORTEX = 361,
		bl_icon_FORCE_WIND = 362,
		bl_icon_IMAGE_BACKGROUND = 363,
		bl_icon_IMAGE_PLANE = 364,
		bl_icon_IMAGE_REFERENCE = 365,
		bl_icon_RIGID_BODY_CONSTRAINT = 366,
		bl_icon_RIGID_BODY = 367,
		bl_icon_SPLIT_HORIZONTAL = 368,
		bl_icon_SPLIT_VERTICAL = 369,
		bl_icon_ANCHOR_BOTTOM = 370,
		bl_icon_ANCHOR_CENTER = 371,
		bl_icon_ANCHOR_LEFT = 372,
		bl_icon_ANCHOR_RIGHT = 373,
		bl_icon_ANCHOR_TOP = 374,
		bl_icon_NODE_CORNER = 375,
		bl_icon_NODE_INSERT_OFF = 376,
		bl_icon_NODE_INSERT_ON = 377,
		bl_icon_NODE_SIDE = 378,
		bl_icon_NODE_TOP = 379,
		bl_icon_SELECT_EXTEND = 380,
		bl_icon_SELECT_SET = 381,
		bl_icon_SELECT_SUBTRACT = 382,
		bl_icon_ALIGN_BOTTOM = 383,
		bl_icon_ALIGN_CENTER = 384,
		bl_icon_ALIGN_FLUSH = 385,
		bl_icon_ALIGN_JUSTIFY = 386,
		bl_icon_ALIGN_LEFT = 387,
		bl_icon_ALIGN_MIDDLE = 388,
		bl_icon_ALIGN_RIGHT = 389,
		bl_icon_ALIGN_TOP = 390,
		bl_icon_BOLD = 391,
		bl_icon_ITALIC = 392,
		bl_icon_LINENUMBERS_OFF = 393,
		bl_icon_LINENUMBERS_ON = 394,
		bl_icon_SCRIPTPLUGINS = 395,
		bl_icon_SMALL_CAPS = 396,
		bl_icon_SYNTAX_OFF = 397,
		bl_icon_SYNTAX_ON = 398,
		bl_icon_UNDERLINE = 399,
		bl_icon_WORDWRAP_OFF = 400,
		bl_icon_WORDWRAP_ON = 401,
		bl_icon_CON_ACTION = 402,
		bl_icon_CON_ARMATURE = 403,
		bl_icon_CON_CAMERASOLVER = 404,
		bl_icon_CON_CHILDOF = 405,
		bl_icon_CON_CLAMPTO = 406,
		bl_icon_CON_DISTLIMIT = 407,
		bl_icon_CON_FLOOR = 408,
		bl_icon_CON_FOLLOWPATH = 409,
		bl_icon_CON_FOLLOWTRACK = 410,
		bl_icon_CON_KINEMATIC = 411,
		bl_icon_CON_LOCKTRACK = 412,
		bl_icon_CON_LOCLIKE = 413,
		bl_icon_CON_LOCLIMIT = 414,
		bl_icon_CON_OBJECTSOLVER = 415,
		bl_icon_CON_PIVOT = 416,
		bl_icon_CON_ROTLIKE = 417,
		bl_icon_CON_ROTLIMIT = 418,
		bl_icon_CON_SAMEVOL = 419,
		bl_icon_CON_SHRINKWRAP = 420,
		bl_icon_CON_SIZELIKE = 421,
		bl_icon_CON_SIZELIMIT = 422,
		bl_icon_CON_SPLINEIK = 423,
		bl_icon_CON_STRETCHTO = 424,
		bl_icon_CON_TRACKTO = 425,
		bl_icon_CON_TRANSFORM_CACHE = 426,
		bl_icon_CON_TRANSFORM = 427,
		bl_icon_CON_TRANSLIKE = 428,
		bl_icon_HOOK = 429,
		bl_icon_MOD_ARMATURE = 430,
		bl_icon_MOD_ARRAY = 431,
		bl_icon_MOD_BEVEL = 432,
		bl_icon_MOD_BOOLEAN = 433,
		bl_icon_MOD_BUILD = 434,
		bl_icon_MOD_CAST = 435,
		bl_icon_MOD_CLOTH = 436,
		bl_icon_MOD_CURVE = 437,
		bl_icon_MOD_DASH = 438,
		bl_icon_MOD_DATA_TRANSFER = 439,
		bl_icon_MOD_DECIM = 440,
		bl_icon_MOD_DISPLACE = 441,
		bl_icon_MOD_DYNAMICPAINT = 442,
		bl_icon_MOD_EDGESPLIT = 443,
		bl_icon_MOD_ENVELOPE = 444,
		bl_icon_MOD_EXPLODE = 445,
		bl_icon_MOD_FLUID = 446,
		bl_icon_MOD_FLUIDSIM = 447,
		bl_icon_MOD_HUE_SATURATION = 448,
		bl_icon_MOD_INSTANCE = 449,
		bl_icon_MOD_LATTICE = 450,
		bl_icon_MOD_LENGTH = 451,
		bl_icon_MOD_LINEART = 452,
		bl_icon_MOD_MASK = 453,
		bl_icon_MOD_MESHDEFORM = 454,
		bl_icon_MOD_MIRROR = 455,
		bl_icon_MOD_MULTIRES = 456,
		bl_icon_MOD_NOISE = 457,
		bl_icon_MOD_NORMALEDIT = 458,
		bl_icon_MOD_OCEAN = 459,
		bl_icon_MOD_OFFSET = 460,
		bl_icon_MOD_OPACITY = 461,
		bl_icon_MOD_OUTLINE = 462,
		bl_icon_MOD_PARTICLE_INSTANCE = 463,
		bl_icon_MOD_PARTICLES = 464,
		bl_icon_MOD_PHYSICS = 465,
		bl_icon_MOD_REMESH = 466,
		bl_icon_MOD_SCREW = 467,
		bl_icon_MOD_SHRINKWRAP = 468,
		bl_icon_MOD_SIMPLEDEFORM = 469,
		bl_icon_MOD_SIMPLIFY = 470,
		bl_icon_MOD_SKIN = 471,
		bl_icon_MOD_SMOOTH = 472,
		bl_icon_MOD_SOFT = 473,
		bl_icon_MOD_SOLIDIFY = 474,
		bl_icon_MOD_SUBSURF = 475,
		bl_icon_MOD_THICKNESS = 476,
		bl_icon_MOD_TIME = 477,
		bl_icon_MOD_TINT = 478,
		bl_icon_MOD_TRIANGULATE = 479,
		bl_icon_MOD_UVPROJECT = 480,
		bl_icon_MOD_VERTEX_WEIGHT = 481,
		bl_icon_MOD_WARP = 482,
		bl_icon_MOD_WAVE = 483,
		bl_icon_MOD_WIREFRAME = 484,
		bl_icon_MODIFIER_DATA = 485,
		bl_icon_ACTION_SLOT = 486,
		bl_icon_ACTION_TWEAK = 487,
		bl_icon_DRIVER = 488,
		bl_icon_FF = 489,
		bl_icon_FRAME_NEXT = 490,
		bl_icon_FRAME_PREV = 491,
		bl_icon_HANDLE_ALIGNED = 492,
		bl_icon_HANDLE_AUTO = 493,
		bl_icon_HANDLE_AUTOCLAMPED = 494,
		bl_icon_HANDLE_FREE = 495,
		bl_icon_HANDLE_VECTOR = 496,
		bl_icon_IPO_BACK = 497,
		bl_icon_IPO_BEZIER = 498,
		bl_icon_IPO_BOUNCE = 499,
		bl_icon_IPO_CIRC = 500,
		bl_icon_IPO_CONSTANT = 501,
		bl_icon_IPO_CUBIC = 502,
		bl_icon_IPO_EASE_IN_OUT = 503,
		bl_icon_IPO_EASE_IN = 504,
		bl_icon_IPO_EASE_OUT = 505,
		bl_icon_IPO_ELASTIC = 506,
		bl_icon_IPO_EXPO = 507,
		bl_icon_IPO_LINEAR = 508,
		bl_icon_IPO_QUAD = 509,
		bl_icon_IPO_QUART = 510,
		bl_icon_IPO_QUINT = 511,
		bl_icon_IPO_SINE = 512,
		bl_icon_KEY_DEHLT = 513,
		bl_icon_KEY_HLT = 514,
		bl_icon_KEYFRAME_HLT = 515,
		bl_icon_KEYFRAME = 516,
		bl_icon_KEYINGSET = 517,
		bl_icon_MARKER_HLT = 518,
		bl_icon_MARKER = 519,
		bl_icon_MUTE_IPO_OFF = 520,
		bl_icon_MUTE_IPO_ON = 521,
		bl_icon_NEXT_KEYFRAME = 522,
		bl_icon_NLA_PUSHDOWN = 523,
		bl_icon_NORMALIZE_FCURVES = 524,
		bl_icon_ORIENTATION_PARENT = 525,
		bl_icon_PAUSE = 526,
		bl_icon_PLAY_REVERSE = 527,
		bl_icon_PLAY_SOUND = 528,
		bl_icon_PLAY = 529,
		bl_icon_PMARKER_ACT = 530,
		bl_icon_PMARKER_SEL = 531,
		bl_icon_PMARKER = 532,
		bl_icon_PREV_KEYFRAME = 533,
		bl_icon_PREVIEW_RANGE = 534,
		bl_icon_REC = 535,
		bl_icon_REW = 536,
		bl_icon_SOLO_OFF = 537,
		bl_icon_SOLO_ON = 538,
		bl_icon_CENTER_ONLY = 539,
		bl_icon_CURSOR = 540,
		bl_icon_EDGESEL = 541,
		bl_icon_FACE_CORNER = 542,
		bl_icon_FACESEL = 543,
		bl_icon_INVERSESQUARECURVE = 544,
		bl_icon_LINCURVE = 545,
		bl_icon_NOCURVE = 546,
		bl_icon_PARTICLE_PATH = 547,
		bl_icon_PARTICLE_POINT = 548,
		bl_icon_PARTICLE_TIP = 549,
		bl_icon_PIVOT_ACTIVE = 550,
		bl_icon_PIVOT_BOUNDBOX = 551,
		bl_icon_PIVOT_CURSOR = 552,
		bl_icon_PIVOT_INDIVIDUAL = 553,
		bl_icon_PIVOT_MEDIAN = 554,
		bl_icon_PROP_CON = 555,
		bl_icon_PROP_OFF = 556,
		bl_icon_PROP_ON = 557,
		bl_icon_PROP_PROJECTED = 558,
		bl_icon_RNDCURVE = 559,
		bl_icon_ROOTCURVE = 560,
		bl_icon_SHARPCURVE = 561,
		bl_icon_SMOOTHCURVE = 562,
		bl_icon_SPHERECURVE = 563,
		bl_icon_VERTEXSEL = 564,
		bl_icon_SNAP_EDGE = 565,
		bl_icon_SNAP_FACE_CENTER = 566,
		bl_icon_SNAP_FACE_NEAREST = 567,
		bl_icon_SNAP_FACE = 568,
		bl_icon_SNAP_GRID = 569,
		bl_icon_SNAP_INCREMENT = 570,
		bl_icon_SNAP_MIDPOINT = 571,
		bl_icon_SNAP_NORMAL = 572,
		bl_icon_SNAP_PEEL_OBJECT = 573,
		bl_icon_SNAP_PERPENDICULAR = 574,
		bl_icon_SNAP_VERTEX = 575,
		bl_icon_SNAP_VOLUME = 576,
		bl_icon_STICKY_UVS_DISABLE = 577,
		bl_icon_STICKY_UVS_LOC = 578,
		bl_icon_STICKY_UVS_VERT = 579,
		bl_icon_ORIENTATION_GIMBAL = 580,
		bl_icon_ORIENTATION_GLOBAL = 581,
		bl_icon_ORIENTATION_LOCAL = 582,
		bl_icon_ORIENTATION_NORMAL = 583,
		bl_icon_ORIENTATION_VIEW = 584,
		bl_icon_COPYDOWN = 585,
		bl_icon_FIXED_SIZE = 586,
		bl_icon_GIZMO = 587,
		bl_icon_GP_CAPS_FLAT = 588,
		bl_icon_GP_CAPS_ROUND = 589,
		bl_icon_NORMALS_FACE = 590,
		bl_icon_NORMALS_VERTEX_FACE = 591,
		bl_icon_NORMALS_VERTEX = 592,
		bl_icon_OBJECT_ORIGIN = 593,
		bl_icon_ORIENTATION_CURSOR = 594,
		bl_icon_PASTEDOWN = 595,
		bl_icon_PASTEFLIPDOWN = 596,
		bl_icon_PASTEFLIPUP = 597,
		bl_icon_TRANSFORM_ORIGINS = 598,
		bl_icon_UV_EDGESEL = 599,
		bl_icon_UV_FACESEL = 600,
		bl_icon_UV_ISLANDSEL = 601,
		bl_icon_UV_SYNC_SELECT = 602,
		bl_icon_UV_VERTEXSEL = 603,
		bl_icon_AXIS_FRONT = 604,
		bl_icon_AXIS_SIDE = 605,
		bl_icon_AXIS_TOP = 606,
		bl_icon_GRID = 607,
		bl_icon_LAYER_ACTIVE = 608,
		bl_icon_LAYER_USED = 609,
		bl_icon_LOCKVIEW_OFF = 610,
		bl_icon_LOCKVIEW_ON = 611,
		bl_icon_OVERLAY = 612,
		bl_icon_SHADING_BBOX = 613,
		bl_icon_SHADING_RENDERED = 614,
		bl_icon_SHADING_SOLID = 615,
		bl_icon_SHADING_TEXTURE = 616,
		bl_icon_SHADING_WIRE = 617,
		bl_icon_XRAY = 618,
		bl_icon_VIEW_CAMERA_UNSELECTED = 619,
		bl_icon_VIEW_CAMERA = 620,
		bl_icon_VIEW_LOCKED = 621,
		bl_icon_VIEW_ORTHO = 622,
		bl_icon_VIEW_PAN = 623,
		bl_icon_VIEW_PERSPECTIVE = 624,
		bl_icon_VIEW_UNLOCKED = 625,
		bl_icon_VIEW_ZOOM = 626,
		bl_icon_FILE_ALIAS = 627,
		bl_icon_FILE_FOLDER = 628,
		bl_icon_FOLDER_REDIRECT = 629,
		bl_icon_APPEND_BLEND = 630,
		bl_icon_BACK = 631,
		bl_icon_BOOKMARKS = 632,
		bl_icon_CURRENT_FILE = 633,
		bl_icon_DESKTOP = 634,
		bl_icon_DISC = 635,
		bl_icon_DISK_DRIVE = 636,
		bl_icon_DOCUMENTS = 637,
		bl_icon_EXPORT = 638,
		bl_icon_EXTERNAL_DRIVE = 639,
		bl_icon_FILE_3D = 640,
		bl_icon_FILE_ARCHIVE = 641,
		bl_icon_FILE_BACKUP = 642,
		bl_icon_FILE_BLANK = 643,
		bl_icon_FILE_BLEND = 644,
		bl_icon_FILE_CACHE = 645,
		bl_icon_FILE_FONT = 646,
		bl_icon_FILE_HIDDEN = 647,
		bl_icon_FILE_IMAGE = 648,
		bl_icon_FILE_MOVIE = 649,
		bl_icon_FILE_PARENT = 650,
		bl_icon_FILE_REFRESH = 651,
		bl_icon_FILE_SCRIPT = 652,
		bl_icon_FILE_SOUND = 653,
		bl_icon_FILE_TEXT = 654,
		bl_icon_FILE_VOLUME = 655,
		bl_icon_FILTER = 656,
		bl_icon_FONTPREVIEW = 657,
		bl_icon_FORWARD = 658,
		bl_icon_HOME = 659,
		bl_icon_IMGDISPLAY = 660,
		bl_icon_IMPORT = 661,
		bl_icon_LINK_BLEND = 662,
		bl_icon_LONGDISPLAY = 663,
		bl_icon_LOOP_BACK = 664,
		bl_icon_LOOP_FORWARDS = 665,
		bl_icon_NETWORK_DRIVE = 666,
		bl_icon_NEWFOLDER = 667,
		bl_icon_PREVIEW_LOADING = 668,
		bl_icon_SETTINGS = 669,
		bl_icon_SHORTDISPLAY = 670,
		bl_icon_SORT_ASC = 671,
		bl_icon_SORT_DESC = 672,
		bl_icon_SORTALPHA = 673,
		bl_icon_SORTBYEXT = 674,
		bl_icon_SORTSIZE = 675,
		bl_icon_SORTTIME = 676,
		bl_icon_SYSTEM = 677,
		bl_icon_TAG = 678,
		bl_icon_TEMP = 679,
		bl_icon_ALIASED = 680,
		bl_icon_ANTIALIASED = 681,
		bl_icon_MAT_SPHERE_SKY = 682,
		bl_icon_MATCLOTH = 683,
		bl_icon_MATCUBE = 684,
		bl_icon_MATFLUID = 685,
		bl_icon_MATPLANE = 686,
		bl_icon_MATSHADERBALL = 687,
		bl_icon_MATSPHERE = 688,
		bl_icon_SEQ_CHROMA_SCOPE = 689,
		bl_icon_SEQ_HISTOGRAM = 690,
		bl_icon_SEQ_LUMA_WAVEFORM = 691,
		bl_icon_SEQ_PREVIEW = 692,
		bl_icon_SEQ_SEQUENCER = 693,
		bl_icon_SEQ_SPLITVIEW = 694,
		bl_icon_SEQ_STRIP_DUPLICATE = 695,
		bl_icon_SEQ_STRIP_META = 696,
		bl_icon_IMAGE_ALPHA = 697,
		bl_icon_IMAGE_RGB_ALPHA = 698,
		bl_icon_IMAGE_RGB = 699,
		bl_icon_IMAGE_ZDEPTH = 700,
		bl_icon_BLENDER_LOGO_LARGE = 701,
		bl_icon_CANCEL_LARGE = 702,
		bl_icon_DISC_LARGE = 703,
		bl_icon_DISK_DRIVE_LARGE = 704,
		bl_icon_EXTERNAL_DRIVE_LARGE = 705,
		bl_icon_FILE_FOLDER_LARGE = 706,
		bl_icon_FILE_LARGE = 707,
		bl_icon_FILE_PARENT_LARGE = 708,
		bl_icon_INFO_LARGE = 709,
		bl_icon_NETWORK_DRIVE_LARGE = 710,
		bl_icon_QUESTION_LARGE = 711,
		bl_icon_WARNING_LARGE = 712,
		bl_icon_KEY_BACKSPACE_FILLED = 713,
		bl_icon_KEY_BACKSPACE = 714,
		bl_icon_KEY_COMMAND_FILLED = 715,
		bl_icon_KEY_COMMAND = 716,
		bl_icon_KEY_CONTROL_FILLED = 717,
		bl_icon_KEY_CONTROL = 718,
		bl_icon_KEY_EMPTY1_FILLED = 719,
		bl_icon_KEY_EMPTY1 = 720,
		bl_icon_KEY_EMPTY2_FILLED = 721,
		bl_icon_KEY_EMPTY2 = 722,
		bl_icon_KEY_EMPTY3_FILLED = 723,
		bl_icon_KEY_EMPTY3 = 724,
		bl_icon_KEY_MENU_FILLED = 725,
		bl_icon_KEY_MENU = 726,
		bl_icon_KEY_OPTION_FILLED = 727,
		bl_icon_KEY_OPTION = 728,
		bl_icon_KEY_RETURN_FILLED = 729,
		bl_icon_KEY_RETURN = 730,
		bl_icon_KEY_RING_FILLED = 731,
		bl_icon_KEY_RING = 732,
		bl_icon_KEY_SHIFT_FILLED = 733,
		bl_icon_KEY_SHIFT = 734,
		bl_icon_KEY_TAB_FILLED = 735,
		bl_icon_KEY_TAB = 736,
		bl_icon_KEY_WINDOWS_FILLED = 737,
		bl_icon_KEY_WINDOWS = 738,
		bl_icon_GESTURE_PAN = 739,
		bl_icon_GESTURE_ROTATE = 740,
		bl_icon_GESTURE_ZOOM = 741,
		bl_icon_FUND = 742,
		bl_icon_HEART = 743,
		bl_icon_INTERNET_OFFLINE = 744,
		bl_icon_INTERNET = 745,
		bl_icon_USER = 746,
		bl_icon_EXPERIMENTAL = 747,
		bl_icon_MEMORY = 748,
		bl_icon_RGB_RED = 750,
		bl_icon_RGB_GREEN = 751,
		bl_icon_RGB_BLUE = 752,
		bl_icon_KEYTYPE_KEYFRAME_VEC = 753,
		bl_icon_KEYTYPE_BREAKDOWN_VEC = 754,
		bl_icon_KEYTYPE_EXTREME_VEC = 755,
		bl_icon_KEYTYPE_JITTER_VEC = 756,
		bl_icon_KEYTYPE_MOVING_HOLD_VEC = 757,
		bl_icon_KEYTYPE_GENERATED_VEC = 758,
		bl_icon_HANDLETYPE_FREE_VEC = 759,
		bl_icon_HANDLETYPE_ALIGNED_VEC = 760,
		bl_icon_HANDLETYPE_VECTOR_VEC = 761,
		bl_icon_HANDLETYPE_AUTO_VEC = 762,
		bl_icon_HANDLETYPE_AUTO_CLAMP_VEC = 763,
		bl_icon_COLORSET_01_VEC = 764,
		bl_icon_COLORSET_02_VEC = 765,
		bl_icon_COLORSET_03_VEC = 766,
		bl_icon_COLORSET_04_VEC = 767,
		bl_icon_COLORSET_05_VEC = 768,
		bl_icon_COLORSET_06_VEC = 769,
		bl_icon_COLORSET_07_VEC = 770,
		bl_icon_COLORSET_08_VEC = 771,
		bl_icon_COLORSET_09_VEC = 772,
		bl_icon_COLORSET_10_VEC = 773,
		bl_icon_COLORSET_11_VEC = 774,
		bl_icon_COLORSET_12_VEC = 775,
		bl_icon_COLORSET_13_VEC = 776,
		bl_icon_COLORSET_14_VEC = 777,
		bl_icon_COLORSET_15_VEC = 778,
		bl_icon_COLORSET_16_VEC = 779,
		bl_icon_COLORSET_17_VEC = 780,
		bl_icon_COLORSET_18_VEC = 781,
		bl_icon_COLORSET_19_VEC = 782,
		bl_icon_COLORSET_20_VEC = 783,
		bl_icon_COLLECTION_COLOR_01 = 784,
		bl_icon_COLLECTION_COLOR_02 = 785,
		bl_icon_COLLECTION_COLOR_03 = 786,
		bl_icon_COLLECTION_COLOR_04 = 787,
		bl_icon_COLLECTION_COLOR_05 = 788,
		bl_icon_COLLECTION_COLOR_06 = 789,
		bl_icon_COLLECTION_COLOR_07 = 790,
		bl_icon_COLLECTION_COLOR_08 = 791,
		bl_icon_STRIP_COLOR_01 = 792,
		bl_icon_STRIP_COLOR_02 = 793,
		bl_icon_STRIP_COLOR_03 = 794,
		bl_icon_STRIP_COLOR_04 = 795,
		bl_icon_STRIP_COLOR_05 = 796,
		bl_icon_STRIP_COLOR_06 = 797,
		bl_icon_STRIP_COLOR_07 = 798,
		bl_icon_STRIP_COLOR_08 = 799,
		bl_icon_STRIP_COLOR_09 = 800,
		bl_icon_LIBRARY_DATA_INDIRECT = 801,
		bl_icon_LIBRARY_DATA_OVERRIDE_NONEDITABLE = 802,
		bl_icon_LAYERGROUP_COLOR_01 = 803,
		bl_icon_LAYERGROUP_COLOR_02 = 804,
		bl_icon_LAYERGROUP_COLOR_03 = 805,
		bl_icon_LAYERGROUP_COLOR_04 = 806,
		bl_icon_LAYERGROUP_COLOR_05 = 807,
		bl_icon_LAYERGROUP_COLOR_06 = 808,
		bl_icon_LAYERGROUP_COLOR_07 = 809,
		bl_icon_LAYERGROUP_COLOR_08 = 810,
		bl_icon_EVENT_A = 811,
		bl_icon_EVENT_B = 812,
		bl_icon_EVENT_C = 813,
		bl_icon_EVENT_D = 814,
		bl_icon_EVENT_E = 815,
		bl_icon_EVENT_F = 816,
		bl_icon_EVENT_G = 817,
		bl_icon_EVENT_H = 818,
		bl_icon_EVENT_I = 819,
		bl_icon_EVENT_J = 820,
		bl_icon_EVENT_K = 821,
		bl_icon_EVENT_L = 822,
		bl_icon_EVENT_M = 823,
		bl_icon_EVENT_N = 824,
		bl_icon_EVENT_O = 825,
		bl_icon_EVENT_P = 826,
		bl_icon_EVENT_Q = 827,
		bl_icon_EVENT_R = 828,
		bl_icon_EVENT_S = 829,
		bl_icon_EVENT_T = 830,
		bl_icon_EVENT_U = 831,
		bl_icon_EVENT_V = 832,
		bl_icon_EVENT_W = 833,
		bl_icon_EVENT_X = 834,
		bl_icon_EVENT_Y = 835,
		bl_icon_EVENT_Z = 836,
		bl_icon_EVENT_SHIFT = 837,
		bl_icon_EVENT_CTRL = 838,
		bl_icon_EVENT_ALT = 839,
		bl_icon_EVENT_OS = 840,
		bl_icon_EVENT_HYPER = 841,
		bl_icon_EVENT_F1 = 842,
		bl_icon_EVENT_F2 = 843,
		bl_icon_EVENT_F3 = 844,
		bl_icon_EVENT_F4 = 845,
		bl_icon_EVENT_F5 = 846,
		bl_icon_EVENT_F6 = 847,
		bl_icon_EVENT_F7 = 848,
		bl_icon_EVENT_F8 = 849,
		bl_icon_EVENT_F9 = 850,
		bl_icon_EVENT_F10 = 851,
		bl_icon_EVENT_F11 = 852,
		bl_icon_EVENT_F12 = 853,
		bl_icon_EVENT_F13 = 854,
		bl_icon_EVENT_F14 = 855,
		bl_icon_EVENT_F15 = 856,
		bl_icon_EVENT_F16 = 857,
		bl_icon_EVENT_F17 = 858,
		bl_icon_EVENT_F18 = 859,
		bl_icon_EVENT_F19 = 860,
		bl_icon_EVENT_F20 = 861,
		bl_icon_EVENT_F21 = 862,
		bl_icon_EVENT_F22 = 863,
		bl_icon_EVENT_F23 = 864,
		bl_icon_EVENT_F24 = 865,
		bl_icon_EVENT_ESC = 866,
		bl_icon_EVENT_TAB = 867,
		bl_icon_EVENT_PAGEUP = 868,
		bl_icon_EVENT_PAGEDOWN = 869,
		bl_icon_EVENT_RETURN = 870,
		bl_icon_EVENT_SPACEKEY = 871,
		bl_icon_EVENT_ZEROKEY = 872,
		bl_icon_EVENT_ONEKEY = 873,
		bl_icon_EVENT_TWOKEY = 874,
		bl_icon_EVENT_THREEKEY = 875,
		bl_icon_EVENT_FOURKEY = 876,
		bl_icon_EVENT_FIVEKEY = 877,
		bl_icon_EVENT_SIXKEY = 878,
		bl_icon_EVENT_SEVENKEY = 879,
		bl_icon_EVENT_EIGHTKEY = 880,
		bl_icon_EVENT_NINEKEY = 881,
		bl_icon_EVENT_PAD0 = 882,
		bl_icon_EVENT_PAD1 = 883,
		bl_icon_EVENT_PAD2 = 884,
		bl_icon_EVENT_PAD3 = 885,
		bl_icon_EVENT_PAD4 = 886,
		bl_icon_EVENT_PAD5 = 887,
		bl_icon_EVENT_PAD6 = 888,
		bl_icon_EVENT_PAD7 = 889,
		bl_icon_EVENT_PAD8 = 890,
		bl_icon_EVENT_PAD9 = 891,
		bl_icon_EVENT_PADASTER = 892,
		bl_icon_EVENT_PADSLASH = 893,
		bl_icon_EVENT_PADMINUS = 894,
		bl_icon_EVENT_PADENTER = 895,
		bl_icon_EVENT_PADPLUS = 896,
		bl_icon_EVENT_PADPERIOD = 897,
		bl_icon_EVENT_MOUSE_4 = 898,
		bl_icon_EVENT_MOUSE_5 = 899,
		bl_icon_EVENT_MOUSE_6 = 900,
		bl_icon_EVENT_MOUSE_7 = 901,
		bl_icon_EVENT_TABLET_STYLUS = 902,
		bl_icon_EVENT_TABLET_ERASER = 903,
		bl_icon_EVENT_LEFT_ARROW = 904,
		bl_icon_EVENT_DOWN_ARROW = 905,
		bl_icon_EVENT_RIGHT_ARROW = 906,
		bl_icon_EVENT_UP_ARROW = 907,
		bl_icon_EVENT_PAUSE = 908,
		bl_icon_EVENT_INSERT = 909,
		bl_icon_EVENT_HOME = 910,
		bl_icon_EVENT_END = 911,
		bl_icon_EVENT_UNKNOWN = 912,
		bl_icon_EVENT_GRLESS = 913,
		bl_icon_EVENT_MEDIAPLAY = 914,
		bl_icon_EVENT_MEDIASTOP = 915,
		bl_icon_EVENT_MEDIAFIRST = 916,
		bl_icon_EVENT_MEDIALAST = 917,
		bl_icon_EVENT_APP = 918,
		bl_icon_EVENT_CAPSLOCK = 919,
		bl_icon_EVENT_BACKSPACE = 920,
		bl_icon_EVENT_DEL = 921,
		bl_icon_EVENT_SEMICOLON = 922,
		bl_icon_EVENT_PERIOD = 923,
		bl_icon_EVENT_COMMA = 924,
		bl_icon_EVENT_QUOTE = 925,
		bl_icon_EVENT_ACCENTGRAVE = 926,
		bl_icon_EVENT_MINUS = 927,
		bl_icon_EVENT_PLUS = 928,
		bl_icon_EVENT_SLASH = 929,
		bl_icon_EVENT_BACKSLASH = 930,
		bl_icon_EVENT_EQUAL = 931,
		bl_icon_EVENT_LEFTBRACKET = 932,
		bl_icon_EVENT_RIGHTBRACKET = 933,
		bl_icon_EVENT_PAD_PAN = 934,
		bl_icon_EVENT_PAD_ROTATE = 935,
		bl_icon_EVENT_PAD_ZOOM = 936,
		bl_icon_EVENT_NDOF_BUTTON_V1 = 937,
		bl_icon_EVENT_NDOF_BUTTON_V2 = 938,
		bl_icon_EVENT_NDOF_BUTTON_V3 = 939,
		bl_icon_EVENT_NDOF_BUTTON_SAVE_V1 = 940,
		bl_icon_EVENT_NDOF_BUTTON_SAVE_V2 = 941,
		bl_icon_EVENT_NDOF_BUTTON_SAVE_V3 = 942,
		bl_icon_EVENT_NDOF_BUTTON_1 = 943,
		bl_icon_EVENT_NDOF_BUTTON_2 = 944,
		bl_icon_EVENT_NDOF_BUTTON_3 = 945,
		bl_icon_EVENT_NDOF_BUTTON_4 = 946,
		bl_icon_EVENT_NDOF_BUTTON_5 = 947,
		bl_icon_EVENT_NDOF_BUTTON_6 = 948,
		bl_icon_EVENT_NDOF_BUTTON_7 = 949,
		bl_icon_EVENT_NDOF_BUTTON_8 = 950,
		bl_icon_EVENT_NDOF_BUTTON_9 = 951,
		bl_icon_EVENT_NDOF_BUTTON_10 = 952,
		bl_icon_EVENT_NDOF_BUTTON_11 = 953,
		bl_icon_EVENT_NDOF_BUTTON_12 = 954,
		bl_icon_EVENT_NDOF_BUTTON_MENU = 955,
		bl_icon_EVENT_NDOF_BUTTON_FIT = 956,
		bl_icon_EVENT_NDOF_BUTTON_TOP = 957,
		bl_icon_EVENT_NDOF_BUTTON_BOTTOM = 958,
		bl_icon_EVENT_NDOF_BUTTON_LEFT = 959,
		bl_icon_EVENT_NDOF_BUTTON_RIGHT = 960,
		bl_icon_EVENT_NDOF_BUTTON_FRONT = 961,
		bl_icon_EVENT_NDOF_BUTTON_BACK = 962,
		bl_icon_EVENT_NDOF_BUTTON_ISO1 = 963,
		bl_icon_EVENT_NDOF_BUTTON_ISO2 = 964,
		bl_icon_EVENT_NDOF_BUTTON_ROLL_CW = 965,
		bl_icon_EVENT_NDOF_BUTTON_ROLL_CCW = 966,
		bl_icon_EVENT_NDOF_BUTTON_SPIN_CW = 967,
		bl_icon_EVENT_NDOF_BUTTON_SPIN_CCW = 968,
		bl_icon_EVENT_NDOF_BUTTON_TILT_CW = 969,
		bl_icon_EVENT_NDOF_BUTTON_TILT_CCW = 970,
		bl_icon_EVENT_NDOF_BUTTON_ROTATE = 971,
		bl_icon_EVENT_NDOF_BUTTON_PANZOOM = 972,
		bl_icon_EVENT_NDOF_BUTTON_DOMINANT = 973,
		bl_icon_EVENT_NDOF_BUTTON_PLUS = 974,
		bl_icon_EVENT_NDOF_BUTTON_MINUS = 975,
		bl_icon_NODE_SOCKET_FLOAT = 976,
		bl_icon_NODE_SOCKET_VECTOR = 977,
		bl_icon_NODE_SOCKET_RGBA = 978,
		bl_icon_NODE_SOCKET_SHADER = 979,
		bl_icon_NODE_SOCKET_BOOLEAN = 980,
		bl_icon_NODE_SOCKET_INT = 981,
		bl_icon_NODE_SOCKET_STRING = 982,
		bl_icon_NODE_SOCKET_OBJECT = 983,
		bl_icon_NODE_SOCKET_IMAGE = 984,
		bl_icon_NODE_SOCKET_GEOMETRY = 985,
		bl_icon_NODE_SOCKET_COLLECTION = 986,
		bl_icon_NODE_SOCKET_TEXTURE = 987,
		bl_icon_NODE_SOCKET_MATERIAL = 988,
		bl_icon_NODE_SOCKET_ROTATION = 989,
		bl_icon_NODE_SOCKET_MENU = 990,
		bl_icon_NODE_SOCKET_MATRIX = 991,
		bl_icon_NODE_SOCKET_BUNDLE = 992,
		bl_icon_NODE_SOCKET_CLOSURE = 993,
	};
	inline bl_icon_enum bl_icon(void);
	inline void bl_icon(bl_icon_enum value);
	inline bool bl_use_group_interface(void);
	inline void bl_use_group_interface(bool value);

	inline void interface_update(Context& context);
	inline bool contains_tree(NodeTree& sub_tree);
	inline void debug_lazy_function_graph(Context C, int *dot_graph_len, const char * *dot_graph);
};

/**************** Compositor Node Tree ****************/

class CompositorNodeTree : public NodeTree {
public:
	CompositorNodeTree(const PointerRNA &ptr_arg) :
		NodeTree(ptr_arg)
		{}

	inline bool use_viewer_border(void);
	inline void use_viewer_border(bool value);

};

/**************** Shader Node Tree ****************/

class ShaderNodeTree : public NodeTree {
public:
	ShaderNodeTree(const PointerRNA &ptr_arg) :
		NodeTree(ptr_arg)
		{}


	inline ShaderNode get_output_node(int target);
};

/**************** Texture Node Tree ****************/

class TextureNodeTree : public NodeTree {
public:
	TextureNodeTree(const PointerRNA &ptr_arg) :
		NodeTree(ptr_arg)
		{}


};

/**************** Geometry Node Tree ****************/

class GeometryNodeTree : public NodeTree {
public:
	GeometryNodeTree(const PointerRNA &ptr_arg) :
		NodeTree(ptr_arg)
		{}

	inline bool is_tool(void);
	inline void is_tool(bool value);
	inline bool is_modifier(void);
	inline void is_modifier(bool value);
	inline bool is_mode_object(void);
	inline void is_mode_object(bool value);
	inline bool is_mode_edit(void);
	inline void is_mode_edit(bool value);
	inline bool is_mode_sculpt(void);
	inline void is_mode_sculpt(bool value);
	inline bool is_mode_paint(void);
	inline void is_mode_paint(bool value);
	inline bool is_type_mesh(void);
	inline void is_type_mesh(bool value);
	inline bool is_type_curve(void);
	inline void is_type_curve(bool value);
	inline bool is_type_pointcloud(void);
	inline void is_type_pointcloud(bool value);
	inline bool use_wait_for_click(void);
	inline void use_wait_for_click(bool value);
	inline bool is_type_grease_pencil(void);
	inline void is_type_grease_pencil(bool value);

};

/**************** NodeFrame ****************/

class NodeFrame : public NodeInternal {
public:
	NodeFrame(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}

	inline Text text(void);
	inline bool shrink(void);
	inline void shrink(bool value);
	inline int label_size(void);
	inline void label_size(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** NodeGroup ****************/

class NodeGroup : public NodeInternal {
public:
	NodeGroup(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}

	inline NodeTree node_tree(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** NodeGroupInput ****************/

class NodeGroupInput : public NodeInternal {
public:
	NodeGroupInput(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** NodeGroupOutput ****************/

class NodeGroupOutput : public NodeInternal {
public:
	NodeGroupOutput(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** NodeReroute ****************/

class NodeReroute : public NodeInternal {
public:
	NodeReroute(const PointerRNA &ptr_arg) :
		NodeInternal(ptr_arg)
		{}

	inline std::string socket_idname(void);
	inline void socket_idname(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeAddShader ****************/

class ShaderNodeAddShader : public ShaderNode {
public:
	ShaderNodeAddShader(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeAmbientOcclusion ****************/

class ShaderNodeAmbientOcclusion : public ShaderNode {
public:
	ShaderNodeAmbientOcclusion(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline int samples(void);
	inline void samples(int value);
	inline bool inside(void);
	inline void inside(bool value);
	inline bool only_local(void);
	inline void only_local(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeAttribute ****************/

class ShaderNodeAttribute : public ShaderNode {
public:
	ShaderNodeAttribute(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum attribute_type_enum {
		attribute_type_GEOMETRY = 0,
		attribute_type_OBJECT = 1,
		attribute_type_INSTANCER = 2,
		attribute_type_VIEW_LAYER = 3,
	};
	inline attribute_type_enum attribute_type(void);
	inline void attribute_type(attribute_type_enum value);
	inline std::string attribute_name(void);
	inline void attribute_name(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBackground ****************/

class ShaderNodeBackground : public ShaderNode {
public:
	ShaderNodeBackground(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBevel ****************/

class ShaderNodeBevel : public ShaderNode {
public:
	ShaderNodeBevel(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline int samples(void);
	inline void samples(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBlackbody ****************/

class ShaderNodeBlackbody : public ShaderNode {
public:
	ShaderNodeBlackbody(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBrightContrast ****************/

class ShaderNodeBrightContrast : public ShaderNode {
public:
	ShaderNodeBrightContrast(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfAnisotropic ****************/

class ShaderNodeBsdfAnisotropic : public ShaderNode {
public:
	ShaderNodeBsdfAnisotropic(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_BECKMANN = 0,
		distribution_GGX = 2,
		distribution_ASHIKHMIN_SHIRLEY = 3,
		distribution_MULTI_GGX = 4,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfDiffuse ****************/

class ShaderNodeBsdfDiffuse : public ShaderNode {
public:
	ShaderNodeBsdfDiffuse(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfGlass ****************/

class ShaderNodeBsdfGlass : public ShaderNode {
public:
	ShaderNodeBsdfGlass(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_BECKMANN = 0,
		distribution_GGX = 2,
		distribution_MULTI_GGX = 4,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfHair ****************/

class ShaderNodeBsdfHair : public ShaderNode {
public:
	ShaderNodeBsdfHair(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum component_enum {
		component_Reflection = 0,
		component_Transmission = 1,
	};
	inline component_enum component(void);
	inline void component(component_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfHairPrincipled ****************/

class ShaderNodeBsdfHairPrincipled : public ShaderNode {
public:
	ShaderNodeBsdfHairPrincipled(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum model_enum {
		model_CHIANG = 0,
		model_HUANG = 1,
	};
	inline model_enum model(void);
	inline void model(model_enum value);
	enum parametrization_enum {
		parametrization_ABSORPTION = 2,
		parametrization_MELANIN = 1,
		parametrization_COLOR = 0,
	};
	inline parametrization_enum parametrization(void);
	inline void parametrization(parametrization_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfMetallic ****************/

class ShaderNodeBsdfMetallic : public ShaderNode {
public:
	ShaderNodeBsdfMetallic(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_BECKMANN = 0,
		distribution_GGX = 2,
		distribution_MULTI_GGX = 4,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);
	enum fresnel_type_enum {
		fresnel_type_PHYSICAL_CONDUCTOR = 0,
		fresnel_type_F82 = 1,
	};
	inline fresnel_type_enum fresnel_type(void);
	inline void fresnel_type(fresnel_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfPrincipled ****************/

class ShaderNodeBsdfPrincipled : public ShaderNode {
public:
	ShaderNodeBsdfPrincipled(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_GGX = 2,
		distribution_MULTI_GGX = 4,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);
	enum subsurface_method_enum {
		subsurface_method_BURLEY = 3,
		subsurface_method_RANDOM_WALK = 4,
		subsurface_method_RANDOM_WALK_SKIN = 5,
	};
	inline subsurface_method_enum subsurface_method(void);
	inline void subsurface_method(subsurface_method_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfRayPortal ****************/

class ShaderNodeBsdfRayPortal : public ShaderNode {
public:
	ShaderNodeBsdfRayPortal(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfRefraction ****************/

class ShaderNodeBsdfRefraction : public ShaderNode {
public:
	ShaderNodeBsdfRefraction(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_BECKMANN = 0,
		distribution_GGX = 2,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfSheen ****************/

class ShaderNodeBsdfSheen : public ShaderNode {
public:
	ShaderNodeBsdfSheen(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum distribution_enum {
		distribution_ASHIKHMIN = 0,
		distribution_MICROFIBER = 1,
	};
	inline distribution_enum distribution(void);
	inline void distribution(distribution_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfToon ****************/

class ShaderNodeBsdfToon : public ShaderNode {
public:
	ShaderNodeBsdfToon(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum component_enum {
		component_DIFFUSE = 0,
		component_GLOSSY = 1,
	};
	inline component_enum component(void);
	inline void component(component_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfTranslucent ****************/

class ShaderNodeBsdfTranslucent : public ShaderNode {
public:
	ShaderNodeBsdfTranslucent(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBsdfTransparent ****************/

class ShaderNodeBsdfTransparent : public ShaderNode {
public:
	ShaderNodeBsdfTransparent(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeBump ****************/

class ShaderNodeBump : public ShaderNode {
public:
	ShaderNodeBump(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool invert(void);
	inline void invert(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeCameraData ****************/

class ShaderNodeCameraData : public ShaderNode {
public:
	ShaderNodeCameraData(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeClamp ****************/

class ShaderNodeClamp : public ShaderNode {
public:
	ShaderNodeClamp(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum clamp_type_enum {
		clamp_type_MINMAX = 0,
		clamp_type_RANGE = 1,
	};
	inline clamp_type_enum clamp_type(void);
	inline void clamp_type(clamp_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeCombineColor ****************/

class ShaderNodeCombineColor : public ShaderNode {
public:
	ShaderNodeCombineColor(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum mode_enum {
		mode_RGB = 0,
		mode_HSV = 1,
		mode_HSL = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeCombineHSV ****************/

class ShaderNodeCombineHSV : public ShaderNode {
public:
	ShaderNodeCombineHSV(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeCombineRGB ****************/

class ShaderNodeCombineRGB : public ShaderNode {
public:
	ShaderNodeCombineRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeCombineXYZ ****************/

class ShaderNodeCombineXYZ : public ShaderNode {
public:
	ShaderNodeCombineXYZ(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeDisplacement ****************/

class ShaderNodeDisplacement : public ShaderNode {
public:
	ShaderNodeDisplacement(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum space_enum {
		space_OBJECT = 1,
		space_WORLD = 2,
	};
	inline space_enum space(void);
	inline void space(space_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeEeveeSpecular ****************/

class ShaderNodeEeveeSpecular : public ShaderNode {
public:
	ShaderNodeEeveeSpecular(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeEmission ****************/

class ShaderNodeEmission : public ShaderNode {
public:
	ShaderNodeEmission(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeFloatCurve ****************/

class ShaderNodeFloatCurve : public ShaderNode {
public:
	ShaderNodeFloatCurve(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeFresnel ****************/

class ShaderNodeFresnel : public ShaderNode {
public:
	ShaderNodeFresnel(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeGamma ****************/

class ShaderNodeGamma : public ShaderNode {
public:
	ShaderNodeGamma(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeHairInfo ****************/

class ShaderNodeHairInfo : public ShaderNode {
public:
	ShaderNodeHairInfo(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeHoldout ****************/

class ShaderNodeHoldout : public ShaderNode {
public:
	ShaderNodeHoldout(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeHueSaturation ****************/

class ShaderNodeHueSaturation : public ShaderNode {
public:
	ShaderNodeHueSaturation(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeInvert ****************/

class ShaderNodeInvert : public ShaderNode {
public:
	ShaderNodeInvert(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeLayerWeight ****************/

class ShaderNodeLayerWeight : public ShaderNode {
public:
	ShaderNodeLayerWeight(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeLightFalloff ****************/

class ShaderNodeLightFalloff : public ShaderNode {
public:
	ShaderNodeLightFalloff(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeLightPath ****************/

class ShaderNodeLightPath : public ShaderNode {
public:
	ShaderNodeLightPath(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeMapping ****************/

class ShaderNodeMapping : public ShaderNode {
public:
	ShaderNodeMapping(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum vector_type_enum {
		vector_type_POINT = 0,
		vector_type_TEXTURE = 1,
		vector_type_VECTOR = 2,
		vector_type_NORMAL = 3,
	};
	inline vector_type_enum vector_type(void);
	inline void vector_type(vector_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeMapRange ****************/

class ShaderNodeMapRange : public ShaderNode {
public:
	ShaderNodeMapRange(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool clamp(void);
	inline void clamp(bool value);
	enum interpolation_type_enum {
		interpolation_type_LINEAR = 0,
		interpolation_type_STEPPED = 1,
		interpolation_type_SMOOTHSTEP = 2,
		interpolation_type_SMOOTHERSTEP = 3,
	};
	inline interpolation_type_enum interpolation_type(void);
	inline void interpolation_type(interpolation_type_enum value);
	enum data_type_enum {
		data_type_FLOAT = 10,
		data_type_FLOAT_VECTOR = 48,
	};
	inline data_type_enum data_type(void);
	inline void data_type(data_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeMath ****************/

class ShaderNodeMath : public ShaderNode {
public:
	ShaderNodeMath(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum operation_enum {
		operation_ADD = 0,
		operation_SUBTRACT = 1,
		operation_MULTIPLY = 2,
		operation_DIVIDE = 3,
		operation_MULTIPLY_ADD = 36,
		operation_POWER = 10,
		operation_LOGARITHM = 11,
		operation_SQRT = 23,
		operation_INVERSE_SQRT = 24,
		operation_ABSOLUTE = 18,
		operation_EXPONENT = 26,
		operation_MINIMUM = 12,
		operation_MAXIMUM = 13,
		operation_LESS_THAN = 15,
		operation_GREATER_THAN = 16,
		operation_SIGN = 25,
		operation_COMPARE = 35,
		operation_SMOOTH_MIN = 38,
		operation_SMOOTH_MAX = 39,
		operation_ROUND = 14,
		operation_FLOOR = 20,
		operation_CEIL = 21,
		operation_TRUNC = 32,
		operation_FRACT = 22,
		operation_MODULO = 17,
		operation_FLOORED_MODULO = 40,
		operation_WRAP = 34,
		operation_SNAP = 33,
		operation_PINGPONG = 37,
		operation_SINE = 4,
		operation_COSINE = 5,
		operation_TANGENT = 6,
		operation_ARCSINE = 7,
		operation_ARCCOSINE = 8,
		operation_ARCTANGENT = 9,
		operation_ARCTAN2 = 19,
		operation_SINH = 29,
		operation_COSH = 30,
		operation_TANH = 31,
		operation_RADIANS = 27,
		operation_DEGREES = 28,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	inline bool use_clamp(void);
	inline void use_clamp(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeMix ****************/

class ShaderNodeMix : public ShaderNode {
public:
	ShaderNodeMix(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum data_type_enum {
		data_type_FLOAT = 0,
		data_type_VECTOR = 1,
		data_type_RGBA = 2,
		data_type_ROTATION = 14,
	};
	inline data_type_enum data_type(void);
	inline void data_type(data_type_enum value);
	enum factor_mode_enum {
		factor_mode_UNIFORM = 0,
		factor_mode_NON_UNIFORM = 1,
	};
	inline factor_mode_enum factor_mode(void);
	inline void factor_mode(factor_mode_enum value);
	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_DARKEN = 7,
		blend_type_MULTIPLY = 2,
		blend_type_BURN = 11,
		blend_type_LIGHTEN = 8,
		blend_type_SCREEN = 4,
		blend_type_DODGE = 10,
		blend_type_ADD = 1,
		blend_type_OVERLAY = 9,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
		blend_type_DIFFERENCE = 6,
		blend_type_EXCLUSION = 18,
		blend_type_SUBTRACT = 3,
		blend_type_DIVIDE = 5,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_COLOR = 15,
		blend_type_VALUE = 14,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool clamp_factor(void);
	inline void clamp_factor(bool value);
	inline bool clamp_result(void);
	inline void clamp_result(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeMixRGB ****************/

class ShaderNodeMixRGB : public ShaderNode {
public:
	ShaderNodeMixRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_DARKEN = 7,
		blend_type_MULTIPLY = 2,
		blend_type_BURN = 11,
		blend_type_LIGHTEN = 8,
		blend_type_SCREEN = 4,
		blend_type_DODGE = 10,
		blend_type_ADD = 1,
		blend_type_OVERLAY = 9,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
		blend_type_DIFFERENCE = 6,
		blend_type_EXCLUSION = 18,
		blend_type_SUBTRACT = 3,
		blend_type_DIVIDE = 5,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_COLOR = 15,
		blend_type_VALUE = 14,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_alpha(void);
	inline void use_alpha(bool value);
	inline bool use_clamp(void);
	inline void use_clamp(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeMixShader ****************/

class ShaderNodeMixShader : public ShaderNode {
public:
	ShaderNodeMixShader(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeNewGeometry ****************/

class ShaderNodeNewGeometry : public ShaderNode {
public:
	ShaderNodeNewGeometry(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeNormal ****************/

class ShaderNodeNormal : public ShaderNode {
public:
	ShaderNodeNormal(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeNormalMap ****************/

class ShaderNodeNormalMap : public ShaderNode {
public:
	ShaderNodeNormalMap(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum space_enum {
		space_TANGENT = 0,
		space_OBJECT = 1,
		space_WORLD = 2,
		space_BLENDER_OBJECT = 3,
		space_BLENDER_WORLD = 4,
	};
	inline space_enum space(void);
	inline void space(space_enum value);
	inline std::string uv_map(void);
	inline void uv_map(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeObjectInfo ****************/

class ShaderNodeObjectInfo : public ShaderNode {
public:
	ShaderNodeObjectInfo(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeOutputAOV ****************/

class ShaderNodeOutputAOV : public ShaderNode {
public:
	ShaderNodeOutputAOV(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline std::string aov_name(void);
	inline void aov_name(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeOutputLight ****************/

class ShaderNodeOutputLight : public ShaderNode {
public:
	ShaderNodeOutputLight(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(bool value);
	enum target_enum {
		target_ALL = 0,
		target_EEVEE = 1,
		target_CYCLES = 2,
	};
	inline target_enum target(void);
	inline void target(target_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeOutputLineStyle ****************/

class ShaderNodeOutputLineStyle : public ShaderNode {
public:
	ShaderNodeOutputLineStyle(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(bool value);
	enum target_enum {
		target_ALL = 0,
		target_EEVEE = 1,
		target_CYCLES = 2,
	};
	inline target_enum target(void);
	inline void target(target_enum value);
	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_DARKEN = 7,
		blend_type_MULTIPLY = 2,
		blend_type_BURN = 11,
		blend_type_LIGHTEN = 8,
		blend_type_SCREEN = 4,
		blend_type_DODGE = 10,
		blend_type_ADD = 1,
		blend_type_OVERLAY = 9,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
		blend_type_DIFFERENCE = 6,
		blend_type_EXCLUSION = 18,
		blend_type_SUBTRACT = 3,
		blend_type_DIVIDE = 5,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_COLOR = 15,
		blend_type_VALUE = 14,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_alpha(void);
	inline void use_alpha(bool value);
	inline bool use_clamp(void);
	inline void use_clamp(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeOutputMaterial ****************/

class ShaderNodeOutputMaterial : public ShaderNode {
public:
	ShaderNodeOutputMaterial(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(bool value);
	enum target_enum {
		target_ALL = 0,
		target_EEVEE = 1,
		target_CYCLES = 2,
	};
	inline target_enum target(void);
	inline void target(target_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeOutputWorld ****************/

class ShaderNodeOutputWorld : public ShaderNode {
public:
	ShaderNodeOutputWorld(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool is_active_output(void);
	inline void is_active_output(bool value);
	enum target_enum {
		target_ALL = 0,
		target_EEVEE = 1,
		target_CYCLES = 2,
	};
	inline target_enum target(void);
	inline void target(target_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeParticleInfo ****************/

class ShaderNodeParticleInfo : public ShaderNode {
public:
	ShaderNodeParticleInfo(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodePointInfo ****************/

class ShaderNodePointInfo : public ShaderNode {
public:
	ShaderNodePointInfo(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeRGB ****************/

class ShaderNodeRGB : public ShaderNode {
public:
	ShaderNodeRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeRGBCurve ****************/

class ShaderNodeRGBCurve : public ShaderNode {
public:
	ShaderNodeRGBCurve(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeRGBToBW ****************/

class ShaderNodeRGBToBW : public ShaderNode {
public:
	ShaderNodeRGBToBW(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeScript ****************/

class ShaderNodeScript : public ShaderNode {
public:
	ShaderNodeScript(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Text script(void);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	enum mode_enum {
		mode_INTERNAL = 0,
		mode_EXTERNAL = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline bool use_auto_update(void);
	inline void use_auto_update(bool value);
	inline std::string bytecode(void);
	inline void bytecode(const std::string& value);
	inline std::string bytecode_hash(void);
	inline void bytecode_hash(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeSeparateColor ****************/

class ShaderNodeSeparateColor : public ShaderNode {
public:
	ShaderNodeSeparateColor(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum mode_enum {
		mode_RGB = 0,
		mode_HSV = 1,
		mode_HSL = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeSeparateHSV ****************/

class ShaderNodeSeparateHSV : public ShaderNode {
public:
	ShaderNodeSeparateHSV(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeSeparateRGB ****************/

class ShaderNodeSeparateRGB : public ShaderNode {
public:
	ShaderNodeSeparateRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeSeparateXYZ ****************/

class ShaderNodeSeparateXYZ : public ShaderNode {
public:
	ShaderNodeSeparateXYZ(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeShaderToRGB ****************/

class ShaderNodeShaderToRGB : public ShaderNode {
public:
	ShaderNodeShaderToRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeSqueeze ****************/

class ShaderNodeSqueeze : public ShaderNode {
public:
	ShaderNodeSqueeze(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeSubsurfaceScattering ****************/

class ShaderNodeSubsurfaceScattering : public ShaderNode {
public:
	ShaderNodeSubsurfaceScattering(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum falloff_enum {
		falloff_BURLEY = 3,
		falloff_RANDOM_WALK = 4,
		falloff_RANDOM_WALK_SKIN = 5,
	};
	inline falloff_enum falloff(void);
	inline void falloff(falloff_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTangent ****************/

class ShaderNodeTangent : public ShaderNode {
public:
	ShaderNodeTangent(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum direction_type_enum {
		direction_type_RADIAL = 0,
		direction_type_UV_MAP = 1,
	};
	inline direction_type_enum direction_type(void);
	inline void direction_type(direction_type_enum value);
	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_Z = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	inline std::string uv_map(void);
	inline void uv_map(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexBrick ****************/

class ShaderNodeTexBrick : public ShaderNode {
public:
	ShaderNodeTexBrick(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	inline int offset_frequency(void);
	inline void offset_frequency(int value);
	inline int squash_frequency(void);
	inline void squash_frequency(int value);
	inline float offset(void);
	inline void offset(float value);
	inline float squash(void);
	inline void squash(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexChecker ****************/

class ShaderNodeTexChecker : public ShaderNode {
public:
	ShaderNodeTexChecker(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexCoord ****************/

class ShaderNodeTexCoord : public ShaderNode {
public:
	ShaderNodeTexCoord(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Object object(void);
	inline bool from_instancer(void);
	inline void from_instancer(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexEnvironment ****************/

class ShaderNodeTexEnvironment : public ShaderNode {
public:
	ShaderNodeTexEnvironment(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Image image(void);
	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum projection_enum {
		projection_EQUIRECTANGULAR = 0,
		projection_MIRROR_BALL = 1,
	};
	inline projection_enum projection(void);
	inline void projection(projection_enum value);
	enum interpolation_enum {
		interpolation_Linear = 0,
		interpolation_Closest = 1,
		interpolation_Cubic = 2,
		interpolation_Smart = 3,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	inline ImageUser image_user(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexGabor ****************/

class ShaderNodeTexGabor : public ShaderNode {
public:
	ShaderNodeTexGabor(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum gabor_type_enum {
		gabor_type_2D = 0,
		gabor_type_3D = 1,
	};
	inline gabor_type_enum gabor_type(void);
	inline void gabor_type(gabor_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexGradient ****************/

class ShaderNodeTexGradient : public ShaderNode {
public:
	ShaderNodeTexGradient(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum gradient_type_enum {
		gradient_type_LINEAR = 0,
		gradient_type_QUADRATIC = 1,
		gradient_type_EASING = 2,
		gradient_type_DIAGONAL = 3,
		gradient_type_SPHERICAL = 6,
		gradient_type_QUADRATIC_SPHERE = 5,
		gradient_type_RADIAL = 4,
	};
	inline gradient_type_enum gradient_type(void);
	inline void gradient_type(gradient_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexIES ****************/

class ShaderNodeTexIES : public ShaderNode {
public:
	ShaderNodeTexIES(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Text ies(void);
	inline std::string filepath(void);
	inline void filepath(const std::string& value);
	enum mode_enum {
		mode_INTERNAL = 0,
		mode_EXTERNAL = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexImage ****************/

class ShaderNodeTexImage : public ShaderNode {
public:
	ShaderNodeTexImage(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Image image(void);
	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum projection_enum {
		projection_FLAT = 0,
		projection_BOX = 1,
		projection_SPHERE = 2,
		projection_TUBE = 3,
	};
	inline projection_enum projection(void);
	inline void projection(projection_enum value);
	enum interpolation_enum {
		interpolation_Linear = 0,
		interpolation_Closest = 1,
		interpolation_Cubic = 2,
		interpolation_Smart = 3,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	inline float projection_blend(void);
	inline void projection_blend(float value);
	enum extension_enum {
		extension_REPEAT = 0,
		extension_EXTEND = 1,
		extension_CLIP = 2,
		extension_MIRROR = 3,
	};
	inline extension_enum extension(void);
	inline void extension(extension_enum value);
	inline ImageUser image_user(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexMagic ****************/

class ShaderNodeTexMagic : public ShaderNode {
public:
	ShaderNodeTexMagic(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	inline int turbulence_depth(void);
	inline void turbulence_depth(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexNoise ****************/

class ShaderNodeTexNoise : public ShaderNode {
public:
	ShaderNodeTexNoise(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum noise_dimensions_enum {
		noise_dimensions_1D = 1,
		noise_dimensions_2D = 2,
		noise_dimensions_3D = 3,
		noise_dimensions_4D = 4,
	};
	inline noise_dimensions_enum noise_dimensions(void);
	inline void noise_dimensions(noise_dimensions_enum value);
	enum noise_type_enum {
		noise_type_MULTIFRACTAL = 0,
		noise_type_RIDGED_MULTIFRACTAL = 3,
		noise_type_HYBRID_MULTIFRACTAL = 2,
		noise_type_FBM = 1,
		noise_type_HETERO_TERRAIN = 4,
	};
	inline noise_type_enum noise_type(void);
	inline void noise_type(noise_type_enum value);
	inline bool normalize(void);
	inline void normalize(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexPointDensity ****************/

class ShaderNodeTexPointDensity : public ShaderNode {
public:
	ShaderNodeTexPointDensity(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline Object object(void);
	enum point_source_enum {
		point_source_PARTICLE_SYSTEM = 0,
		point_source_OBJECT = 1,
	};
	inline point_source_enum point_source(void);
	inline void point_source(point_source_enum value);
	inline ParticleSystem particle_system(void);
	inline int resolution(void);
	inline void resolution(int value);
	inline float radius(void);
	inline void radius(float value);
	enum space_enum {
		space_OBJECT = 0,
		space_WORLD = 1,
	};
	inline space_enum space(void);
	inline void space(space_enum value);
	enum interpolation_enum {
		interpolation_Closest = 1,
		interpolation_Linear = 0,
		interpolation_Cubic = 2,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	enum particle_color_source_enum {
		particle_color_source_PARTICLE_AGE = 1,
		particle_color_source_PARTICLE_SPEED = 2,
		particle_color_source_PARTICLE_VELOCITY = 3,
	};
	inline particle_color_source_enum particle_color_source(void);
	inline void particle_color_source(particle_color_source_enum value);
	enum vertex_color_source_enum {
		vertex_color_source_VERTEX_COLOR = 0,
		vertex_color_source_VERTEX_WEIGHT = 1,
		vertex_color_source_VERTEX_NORMAL = 2,
	};
	inline vertex_color_source_enum vertex_color_source(void);
	inline void vertex_color_source(vertex_color_source_enum value);
	inline std::string vertex_attribute_name(void);
	inline void vertex_attribute_name(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
	inline void cache_point_density(Depsgraph& depsgraph);
	inline void calc_point_density(Depsgraph& depsgraph, int *rgba_values_len, float **rgba_values);
	inline void calc_point_density_minmax(Depsgraph& depsgraph, float min[3], float max[3]);
};

/**************** ShaderNodeTexSky ****************/

class ShaderNodeTexSky : public ShaderNode {
public:
	ShaderNodeTexSky(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum sky_type_enum {
		sky_type_PREETHAM = 0,
		sky_type_HOSEK_WILKIE = 1,
		sky_type_NISHITA = 2,
	};
	inline sky_type_enum sky_type(void);
	inline void sky_type(sky_type_enum value);
	inline Array<float, 3> sun_direction(void);
	inline void sun_direction(float values[3]);
	inline float turbidity(void);
	inline void turbidity(float value);
	inline float ground_albedo(void);
	inline void ground_albedo(float value);
	inline bool sun_disc(void);
	inline void sun_disc(bool value);
	inline float sun_size(void);
	inline void sun_size(float value);
	inline float sun_intensity(void);
	inline void sun_intensity(float value);
	inline float sun_elevation(void);
	inline void sun_elevation(float value);
	inline float sun_rotation(void);
	inline void sun_rotation(float value);
	inline float altitude(void);
	inline void altitude(float value);
	inline float air_density(void);
	inline void air_density(float value);
	inline float dust_density(void);
	inline void dust_density(float value);
	inline float ozone_density(void);
	inline void ozone_density(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexVoronoi ****************/

class ShaderNodeTexVoronoi : public ShaderNode {
public:
	ShaderNodeTexVoronoi(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum voronoi_dimensions_enum {
		voronoi_dimensions_1D = 1,
		voronoi_dimensions_2D = 2,
		voronoi_dimensions_3D = 3,
		voronoi_dimensions_4D = 4,
	};
	inline voronoi_dimensions_enum voronoi_dimensions(void);
	inline void voronoi_dimensions(voronoi_dimensions_enum value);
	enum distance_enum {
		distance_EUCLIDEAN = 0,
		distance_MANHATTAN = 1,
		distance_CHEBYCHEV = 2,
		distance_MINKOWSKI = 3,
	};
	inline distance_enum distance(void);
	inline void distance(distance_enum value);
	enum feature_enum {
		feature_F1 = 0,
		feature_F2 = 1,
		feature_SMOOTH_F1 = 2,
		feature_DISTANCE_TO_EDGE = 3,
		feature_N_SPHERE_RADIUS = 4,
	};
	inline feature_enum feature(void);
	inline void feature(feature_enum value);
	inline bool normalize(void);
	inline void normalize(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexWave ****************/

class ShaderNodeTexWave : public ShaderNode {
public:
	ShaderNodeTexWave(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline TexMapping texture_mapping(void);
	inline ColorMapping color_mapping(void);
	enum wave_type_enum {
		wave_type_BANDS = 0,
		wave_type_RINGS = 1,
	};
	inline wave_type_enum wave_type(void);
	inline void wave_type(wave_type_enum value);
	enum bands_direction_enum {
		bands_direction_X = 0,
		bands_direction_Y = 1,
		bands_direction_Z = 2,
		bands_direction_DIAGONAL = 3,
	};
	inline bands_direction_enum bands_direction(void);
	inline void bands_direction(bands_direction_enum value);
	enum rings_direction_enum {
		rings_direction_X = 0,
		rings_direction_Y = 1,
		rings_direction_Z = 2,
		rings_direction_SPHERICAL = 3,
	};
	inline rings_direction_enum rings_direction(void);
	inline void rings_direction(rings_direction_enum value);
	enum wave_profile_enum {
		wave_profile_SIN = 0,
		wave_profile_SAW = 1,
		wave_profile_TRI = 2,
	};
	inline wave_profile_enum wave_profile(void);
	inline void wave_profile(wave_profile_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeTexWhiteNoise ****************/

class ShaderNodeTexWhiteNoise : public ShaderNode {
public:
	ShaderNodeTexWhiteNoise(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum noise_dimensions_enum {
		noise_dimensions_1D = 1,
		noise_dimensions_2D = 2,
		noise_dimensions_3D = 3,
		noise_dimensions_4D = 4,
	};
	inline noise_dimensions_enum noise_dimensions(void);
	inline void noise_dimensions(noise_dimensions_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeUVAlongStroke ****************/

class ShaderNodeUVAlongStroke : public ShaderNode {
public:
	ShaderNodeUVAlongStroke(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool use_tips(void);
	inline void use_tips(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeUVMap ****************/

class ShaderNodeUVMap : public ShaderNode {
public:
	ShaderNodeUVMap(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool from_instancer(void);
	inline void from_instancer(bool value);
	inline std::string uv_map(void);
	inline void uv_map(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeValToRGB ****************/

class ShaderNodeValToRGB : public ShaderNode {
public:
	ShaderNodeValToRGB(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline ColorRamp color_ramp(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeValue ****************/

class ShaderNodeValue : public ShaderNode {
public:
	ShaderNodeValue(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVectorCurve ****************/

class ShaderNodeVectorCurve : public ShaderNode {
public:
	ShaderNodeVectorCurve(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVectorDisplacement ****************/

class ShaderNodeVectorDisplacement : public ShaderNode {
public:
	ShaderNodeVectorDisplacement(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum space_enum {
		space_TANGENT = 0,
		space_OBJECT = 1,
		space_WORLD = 2,
	};
	inline space_enum space(void);
	inline void space(space_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVectorMath ****************/

class ShaderNodeVectorMath : public ShaderNode {
public:
	ShaderNodeVectorMath(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum operation_enum {
		operation_ADD = 0,
		operation_SUBTRACT = 1,
		operation_MULTIPLY = 2,
		operation_DIVIDE = 3,
		operation_MULTIPLY_ADD = 26,
		operation_CROSS_PRODUCT = 4,
		operation_PROJECT = 5,
		operation_REFLECT = 6,
		operation_REFRACT = 24,
		operation_FACEFORWARD = 25,
		operation_DOT_PRODUCT = 7,
		operation_DISTANCE = 8,
		operation_LENGTH = 9,
		operation_SCALE = 10,
		operation_NORMALIZE = 11,
		operation_ABSOLUTE = 17,
		operation_POWER = 27,
		operation_SIGN = 28,
		operation_MINIMUM = 18,
		operation_MAXIMUM = 19,
		operation_FLOOR = 13,
		operation_CEIL = 14,
		operation_FRACTION = 16,
		operation_MODULO = 15,
		operation_WRAP = 20,
		operation_SNAP = 12,
		operation_SINE = 21,
		operation_COSINE = 22,
		operation_TANGENT = 23,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVectorRotate ****************/

class ShaderNodeVectorRotate : public ShaderNode {
public:
	ShaderNodeVectorRotate(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum rotation_type_enum {
		rotation_type_AXIS_ANGLE = 0,
		rotation_type_X_AXIS = 1,
		rotation_type_Y_AXIS = 2,
		rotation_type_Z_AXIS = 3,
		rotation_type_EULER_XYZ = 4,
	};
	inline rotation_type_enum rotation_type(void);
	inline void rotation_type(rotation_type_enum value);
	inline bool invert(void);
	inline void invert(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVectorTransform ****************/

class ShaderNodeVectorTransform : public ShaderNode {
public:
	ShaderNodeVectorTransform(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum vector_type_enum {
		vector_type_POINT = 1,
		vector_type_VECTOR = 0,
		vector_type_NORMAL = 2,
	};
	inline vector_type_enum vector_type(void);
	inline void vector_type(vector_type_enum value);
	enum convert_from_enum {
		convert_from_WORLD = 0,
		convert_from_OBJECT = 1,
		convert_from_CAMERA = 2,
	};
	inline convert_from_enum convert_from(void);
	inline void convert_from(convert_from_enum value);
	enum convert_to_enum {
		convert_to_WORLD = 0,
		convert_to_OBJECT = 1,
		convert_to_CAMERA = 2,
	};
	inline convert_to_enum convert_to(void);
	inline void convert_to(convert_to_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVertexColor ****************/

class ShaderNodeVertexColor : public ShaderNode {
public:
	ShaderNodeVertexColor(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline std::string layer_name(void);
	inline void layer_name(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVolumeAbsorption ****************/

class ShaderNodeVolumeAbsorption : public ShaderNode {
public:
	ShaderNodeVolumeAbsorption(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVolumeInfo ****************/

class ShaderNodeVolumeInfo : public ShaderNode {
public:
	ShaderNodeVolumeInfo(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVolumePrincipled ****************/

class ShaderNodeVolumePrincipled : public ShaderNode {
public:
	ShaderNodeVolumePrincipled(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVolumeScatter ****************/

class ShaderNodeVolumeScatter : public ShaderNode {
public:
	ShaderNodeVolumeScatter(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum phase_enum {
		phase_HENYEY_GREENSTEIN = 0,
		phase_FOURNIER_FORAND = 1,
		phase_DRAINE = 2,
		phase_RAYLEIGH = 3,
		phase_MIE = 4,
	};
	inline phase_enum phase(void);
	inline void phase(phase_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeVolumeCoefficients ****************/

class ShaderNodeVolumeCoefficients : public ShaderNode {
public:
	ShaderNodeVolumeCoefficients(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	enum phase_enum {
		phase_HENYEY_GREENSTEIN = 0,
		phase_FOURNIER_FORAND = 1,
		phase_DRAINE = 2,
		phase_RAYLEIGH = 3,
		phase_MIE = 4,
	};
	inline phase_enum phase(void);
	inline void phase(phase_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeWavelength ****************/

class ShaderNodeWavelength : public ShaderNode {
public:
	ShaderNodeWavelength(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** ShaderNodeWireframe ****************/

class ShaderNodeWireframe : public ShaderNode {
public:
	ShaderNodeWireframe(const PointerRNA &ptr_arg) :
		ShaderNode(ptr_arg)
		{}

	inline bool use_pixel_size(void);
	inline void use_pixel_size(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeAlphaOver ****************/

class CompositorNodeAlphaOver : public CompositorNode {
public:
	CompositorNodeAlphaOver(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_premultiply(void);
	inline void use_premultiply(bool value);
	inline float premul(void);
	inline void premul(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeAntiAliasing ****************/

class CompositorNodeAntiAliasing : public CompositorNode {
public:
	CompositorNodeAntiAliasing(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float threshold(void);
	inline void threshold(float value);
	inline float contrast_limit(void);
	inline void contrast_limit(float value);
	inline float corner_rounding(void);
	inline void corner_rounding(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeBilateralblur ****************/

class CompositorNodeBilateralblur : public CompositorNode {
public:
	CompositorNodeBilateralblur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int iterations(void);
	inline void iterations(int value);
	inline float sigma_color(void);
	inline void sigma_color(float value);
	inline float sigma_space(void);
	inline void sigma_space(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeBlur ****************/

class CompositorNodeBlur : public CompositorNode {
public:
	CompositorNodeBlur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_variable_size(void);
	inline void use_variable_size(bool value);
	inline bool use_extended_bounds(void);
	inline void use_extended_bounds(bool value);
	inline int size_x(void);
	inline void size_x(int value);
	inline int size_y(void);
	inline void size_y(int value);
	inline bool use_relative(void);
	inline void use_relative(bool value);
	enum aspect_correction_enum {
		aspect_correction_NONE = 0,
		aspect_correction_Y = 1,
		aspect_correction_X = 2,
	};
	inline aspect_correction_enum aspect_correction(void);
	inline void aspect_correction(aspect_correction_enum value);
	inline float factor(void);
	inline void factor(float value);
	inline float factor_x(void);
	inline void factor_x(float value);
	inline float factor_y(void);
	inline void factor_y(float value);
	enum filter_type_enum {
		filter_type_FLAT = 0,
		filter_type_TENT = 1,
		filter_type_QUAD = 2,
		filter_type_CUBIC = 3,
		filter_type_GAUSS = 5,
		filter_type_FAST_GAUSS = 7,
		filter_type_CATROM = 4,
		filter_type_MITCH = 6,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);
	inline bool use_bokeh(void);
	inline void use_bokeh(bool value);
	inline bool use_gamma_correction(void);
	inline void use_gamma_correction(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeBokehBlur ****************/

class CompositorNodeBokehBlur : public CompositorNode {
public:
	CompositorNodeBokehBlur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_variable_size(void);
	inline void use_variable_size(bool value);
	inline bool use_extended_bounds(void);
	inline void use_extended_bounds(bool value);
	inline float blur_max(void);
	inline void blur_max(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeBokehImage ****************/

class CompositorNodeBokehImage : public CompositorNode {
public:
	CompositorNodeBokehImage(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float angle(void);
	inline void angle(float value);
	inline int flaps(void);
	inline void flaps(int value);
	inline float rounding(void);
	inline void rounding(float value);
	inline float catadioptric(void);
	inline void catadioptric(float value);
	inline float shift(void);
	inline void shift(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeBoxMask ****************/

class CompositorNodeBoxMask : public CompositorNode {
public:
	CompositorNodeBoxMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mask_type_enum {
		mask_type_ADD = 0,
		mask_type_SUBTRACT = 1,
		mask_type_MULTIPLY = 2,
		mask_type_NOT = 3,
	};
	inline mask_type_enum mask_type(void);
	inline void mask_type(mask_type_enum value);
	inline float x(void);
	inline void x(float value);
	inline float y(void);
	inline void y(float value);
	inline float mask_width(void);
	inline void mask_width(float value);
	inline float mask_height(void);
	inline void mask_height(float value);
	inline float rotation(void);
	inline void rotation(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeBrightContrast ****************/

class CompositorNodeBrightContrast : public CompositorNode {
public:
	CompositorNodeBrightContrast(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_premultiply(void);
	inline void use_premultiply(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeChannelMatte ****************/

class CompositorNodeChannelMatte : public CompositorNode {
public:
	CompositorNodeChannelMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum color_space_enum {
		color_space_RGB = 1,
		color_space_HSV = 2,
		color_space_YUV = 3,
		color_space_YCC = 4,
	};
	inline color_space_enum color_space(void);
	inline void color_space(color_space_enum value);
	enum matte_channel_enum {
		matte_channel_R = 1,
		matte_channel_G = 2,
		matte_channel_B = 3,
	};
	inline matte_channel_enum matte_channel(void);
	inline void matte_channel(matte_channel_enum value);
	enum limit_method_enum {
		limit_method_SINGLE = 0,
		limit_method_MAX = 1,
	};
	inline limit_method_enum limit_method(void);
	inline void limit_method(limit_method_enum value);
	enum limit_channel_enum {
		limit_channel_R = 1,
		limit_channel_G = 2,
		limit_channel_B = 3,
	};
	inline limit_channel_enum limit_channel(void);
	inline void limit_channel(limit_channel_enum value);
	inline float limit_max(void);
	inline void limit_max(float value);
	inline float limit_min(void);
	inline void limit_min(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeChromaMatte ****************/

class CompositorNodeChromaMatte : public CompositorNode {
public:
	CompositorNodeChromaMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float tolerance(void);
	inline void tolerance(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline float lift(void);
	inline void lift(float value);
	inline float gain(void);
	inline void gain(float value);
	inline float shadow_adjust(void);
	inline void shadow_adjust(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeColorBalance ****************/

class CompositorNodeColorBalance : public CompositorNode {
public:
	CompositorNodeColorBalance(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum correction_method_enum {
		correction_method_LIFT_GAMMA_GAIN = 0,
		correction_method_OFFSET_POWER_SLOPE = 1,
		correction_method_WHITEPOINT = 2,
	};
	inline correction_method_enum correction_method(void);
	inline void correction_method(correction_method_enum value);
	inline Array<float, 3> lift(void);
	inline void lift(float values[3]);
	inline Array<float, 3> gamma(void);
	inline void gamma(float values[3]);
	inline Array<float, 3> gain(void);
	inline void gain(float values[3]);
	inline Array<float, 3> offset(void);
	inline void offset(float values[3]);
	inline Array<float, 3> power(void);
	inline void power(float values[3]);
	inline Array<float, 3> slope(void);
	inline void slope(float values[3]);
	inline float offset_basis(void);
	inline void offset_basis(float value);
	inline float input_temperature(void);
	inline void input_temperature(float value);
	inline float input_tint(void);
	inline void input_tint(float value);
	inline Array<float, 3> input_whitepoint(void);
	inline void input_whitepoint(float values[3]);
	inline float output_temperature(void);
	inline void output_temperature(float value);
	inline float output_tint(void);
	inline void output_tint(float value);
	inline Array<float, 3> output_whitepoint(void);
	inline void output_whitepoint(float values[3]);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeColorCorrection ****************/

class CompositorNodeColorCorrection : public CompositorNode {
public:
	CompositorNodeColorCorrection(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool red(void);
	inline void red(bool value);
	inline bool green(void);
	inline void green(bool value);
	inline bool blue(void);
	inline void blue(bool value);
	inline float midtones_start(void);
	inline void midtones_start(float value);
	inline float midtones_end(void);
	inline void midtones_end(float value);
	inline float master_saturation(void);
	inline void master_saturation(float value);
	inline float master_contrast(void);
	inline void master_contrast(float value);
	inline float master_gamma(void);
	inline void master_gamma(float value);
	inline float master_gain(void);
	inline void master_gain(float value);
	inline float master_lift(void);
	inline void master_lift(float value);
	inline float shadows_saturation(void);
	inline void shadows_saturation(float value);
	inline float shadows_contrast(void);
	inline void shadows_contrast(float value);
	inline float shadows_gamma(void);
	inline void shadows_gamma(float value);
	inline float shadows_gain(void);
	inline void shadows_gain(float value);
	inline float shadows_lift(void);
	inline void shadows_lift(float value);
	inline float midtones_saturation(void);
	inline void midtones_saturation(float value);
	inline float midtones_contrast(void);
	inline void midtones_contrast(float value);
	inline float midtones_gamma(void);
	inline void midtones_gamma(float value);
	inline float midtones_gain(void);
	inline void midtones_gain(float value);
	inline float midtones_lift(void);
	inline void midtones_lift(float value);
	inline float highlights_saturation(void);
	inline void highlights_saturation(float value);
	inline float highlights_contrast(void);
	inline void highlights_contrast(float value);
	inline float highlights_gamma(void);
	inline void highlights_gamma(float value);
	inline float highlights_gain(void);
	inline void highlights_gain(float value);
	inline float highlights_lift(void);
	inline void highlights_lift(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeColorMatte ****************/

class CompositorNodeColorMatte : public CompositorNode {
public:
	CompositorNodeColorMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float color_hue(void);
	inline void color_hue(float value);
	inline float color_saturation(void);
	inline void color_saturation(float value);
	inline float color_value(void);
	inline void color_value(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeColorSpill ****************/

class CompositorNodeColorSpill : public CompositorNode {
public:
	CompositorNodeColorSpill(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum channel_enum {
		channel_R = 1,
		channel_G = 2,
		channel_B = 3,
	};
	inline channel_enum channel(void);
	inline void channel(channel_enum value);
	enum limit_method_enum {
		limit_method_SIMPLE = 0,
		limit_method_AVERAGE = 1,
	};
	inline limit_method_enum limit_method(void);
	inline void limit_method(limit_method_enum value);
	enum limit_channel_enum {
		limit_channel_R = 0,
		limit_channel_G = 1,
		limit_channel_B = 2,
	};
	inline limit_channel_enum limit_channel(void);
	inline void limit_channel(limit_channel_enum value);
	inline float ratio(void);
	inline void ratio(float value);
	inline bool use_unspill(void);
	inline void use_unspill(bool value);
	inline float unspill_red(void);
	inline void unspill_red(float value);
	inline float unspill_green(void);
	inline void unspill_green(float value);
	inline float unspill_blue(void);
	inline void unspill_blue(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCombHSVA ****************/

class CompositorNodeCombHSVA : public CompositorNode {
public:
	CompositorNodeCombHSVA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCombineColor ****************/

class CompositorNodeCombineColor : public CompositorNode {
public:
	CompositorNodeCombineColor(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_RGB = 0,
		mode_HSV = 1,
		mode_HSL = 2,
		mode_YCC = 3,
		mode_YUV = 4,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	enum ycc_mode_enum {
		ycc_mode_ITUBT601 = 0,
		ycc_mode_ITUBT709 = 1,
		ycc_mode_JFIF = 2,
	};
	inline ycc_mode_enum ycc_mode(void);
	inline void ycc_mode(ycc_mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCombineXYZ ****************/

class CompositorNodeCombineXYZ : public CompositorNode {
public:
	CompositorNodeCombineXYZ(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCombRGBA ****************/

class CompositorNodeCombRGBA : public CompositorNode {
public:
	CompositorNodeCombRGBA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCombYCCA ****************/

class CompositorNodeCombYCCA : public CompositorNode {
public:
	CompositorNodeCombYCCA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_ITUBT601 = 0,
		mode_ITUBT709 = 1,
		mode_JFIF = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCombYUVA ****************/

class CompositorNodeCombYUVA : public CompositorNode {
public:
	CompositorNodeCombYUVA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeComposite ****************/

class CompositorNodeComposite : public CompositorNode {
public:
	CompositorNodeComposite(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_alpha(void);
	inline void use_alpha(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeConvertColorSpace ****************/

class CompositorNodeConvertColorSpace : public CompositorNode {
public:
	CompositorNodeConvertColorSpace(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum from_color_space_enum {
		from_color_space_NONE = 0,
	};
	inline from_color_space_enum from_color_space(void);
	inline void from_color_space(from_color_space_enum value);
	enum to_color_space_enum {
		to_color_space_NONE = 0,
	};
	inline to_color_space_enum to_color_space(void);
	inline void to_color_space(to_color_space_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCornerPin ****************/

class CompositorNodeCornerPin : public CompositorNode {
public:
	CompositorNodeCornerPin(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum interpolation_enum {
		interpolation_NEAREST = 0,
		interpolation_BILINEAR = 1,
		interpolation_BICUBIC = 2,
		interpolation_ANISOTROPIC = 3,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCrop ****************/

class CompositorNodeCrop : public CompositorNode {
public:
	CompositorNodeCrop(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_crop_size(void);
	inline void use_crop_size(bool value);
	inline bool relative(void);
	inline void relative(bool value);
	inline int min_x(void);
	inline void min_x(int value);
	inline int max_x(void);
	inline void max_x(int value);
	inline int min_y(void);
	inline void min_y(int value);
	inline int max_y(void);
	inline void max_y(int value);
	inline float rel_min_x(void);
	inline void rel_min_x(float value);
	inline float rel_max_x(void);
	inline void rel_max_x(float value);
	inline float rel_min_y(void);
	inline void rel_min_y(float value);
	inline float rel_max_y(void);
	inline void rel_max_y(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCryptomatte ****************/

class CompositorNodeCryptomatte : public CompositorNode {
public:
	CompositorNodeCryptomatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline std::string matte_id(void);
	inline void matte_id(const std::string& value);
	inline Array<float, 3> add(void);
	inline void add(float values[3]);
	inline Array<float, 3> remove(void);
	inline void remove(float values[3]);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCryptomatteV2 ****************/

class CompositorNodeCryptomatteV2 : public CompositorNode {
public:
	CompositorNodeCryptomatteV2(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg),
		entries(ptr_arg)
		{}

	enum source_enum {
		source_RENDER = 0,
		source_IMAGE = 1,
	};
	inline source_enum source(void);
	inline void source(source_enum value);
	inline Scene scene(void);
	inline Image image(void);
	inline std::string matte_id(void);
	inline void matte_id(const std::string& value);
	inline Array<float, 3> add(void);
	inline void add(float values[3]);
	inline Array<float, 3> remove(void);
	inline void remove(float values[3]);
	enum layer_name_enum {
		layer_name_CryptoObject = 0,
		layer_name_CryptoMaterial = 1,
		layer_name_CryptoAsset = 2,
	};
	inline layer_name_enum layer_name(void);
	inline void layer_name(layer_name_enum value);
	COLLECTION_PROPERTY(DefaultCollectionFunctions, CryptomatteEntry, CompositorNodeCryptomatteV2, entries, false, true, true)
	inline int frame_duration(void);
	inline void frame_duration(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_offset(void);
	inline void frame_offset(int value);
	inline bool use_cyclic(void);
	inline void use_cyclic(bool value);
	inline bool use_auto_refresh(void);
	inline void use_auto_refresh(bool value);
	enum layer_enum {
		layer_PLACEHOLDER = 0,
	};
	inline layer_enum layer(void);
	inline void layer(layer_enum value);
	inline bool has_layers(void);
	inline void has_layers(bool value);
	enum view_enum {
		view_ALL = 0,
	};
	inline view_enum view(void);
	inline void view(view_enum value);
	inline bool has_views(void);
	inline void has_views(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCurveRGB ****************/

class CompositorNodeCurveRGB : public CompositorNode {
public:
	CompositorNodeCurveRGB(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeCurveVec ****************/

class CompositorNodeCurveVec : public CompositorNode {
public:
	CompositorNodeCurveVec(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDBlur ****************/

class CompositorNodeDBlur : public CompositorNode {
public:
	CompositorNodeDBlur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int iterations(void);
	inline void iterations(int value);
	inline float center_x(void);
	inline void center_x(float value);
	inline float center_y(void);
	inline void center_y(float value);
	inline float distance(void);
	inline void distance(float value);
	inline float angle(void);
	inline void angle(float value);
	inline float spin(void);
	inline void spin(float value);
	inline float zoom(void);
	inline void zoom(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDefocus ****************/

class CompositorNodeDefocus : public CompositorNode {
public:
	CompositorNodeDefocus(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Scene scene(void);
	enum bokeh_enum {
		bokeh_OCTAGON = 8,
		bokeh_HEPTAGON = 7,
		bokeh_HEXAGON = 6,
		bokeh_PENTAGON = 5,
		bokeh_SQUARE = 4,
		bokeh_TRIANGLE = 3,
		bokeh_CIRCLE = 0,
	};
	inline bokeh_enum bokeh(void);
	inline void bokeh(bokeh_enum value);
	inline float angle(void);
	inline void angle(float value);
	inline bool use_gamma_correction(void);
	inline void use_gamma_correction(bool value);
	inline float f_stop(void);
	inline void f_stop(float value);
	inline float blur_max(void);
	inline void blur_max(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline bool use_preview(void);
	inline void use_preview(bool value);
	inline bool use_zbuffer(void);
	inline void use_zbuffer(bool value);
	inline float z_scale(void);
	inline void z_scale(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDenoise ****************/

class CompositorNodeDenoise : public CompositorNode {
public:
	CompositorNodeDenoise(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_hdr(void);
	inline void use_hdr(bool value);
	enum prefilter_enum {
		prefilter_NONE = 1,
		prefilter_FAST = 0,
		prefilter_ACCURATE = 2,
	};
	inline prefilter_enum prefilter(void);
	inline void prefilter(prefilter_enum value);
	enum quality_enum {
		quality_FOLLOW_SCENE = 0,
		quality_HIGH = 1,
		quality_BALANCED = 2,
		quality_FAST = 3,
	};
	inline quality_enum quality(void);
	inline void quality(quality_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDespeckle ****************/

class CompositorNodeDespeckle : public CompositorNode {
public:
	CompositorNodeDespeckle(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float threshold(void);
	inline void threshold(float value);
	inline float threshold_neighbor(void);
	inline void threshold_neighbor(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDiffMatte ****************/

class CompositorNodeDiffMatte : public CompositorNode {
public:
	CompositorNodeDiffMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float tolerance(void);
	inline void tolerance(float value);
	inline float falloff(void);
	inline void falloff(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDilateErode ****************/

class CompositorNodeDilateErode : public CompositorNode {
public:
	CompositorNodeDilateErode(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_STEP = 0,
		mode_THRESHOLD = 1,
		mode_DISTANCE = 2,
		mode_FEATHER = 3,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	inline int distance(void);
	inline void distance(int value);
	inline float edge(void);
	inline void edge(float value);
	enum falloff_enum {
		falloff_SMOOTH = 0,
		falloff_SPHERE = 1,
		falloff_ROOT = 2,
		falloff_INVERSE_SQUARE = 7,
		falloff_SHARP = 3,
		falloff_LINEAR = 4,
	};
	inline falloff_enum falloff(void);
	inline void falloff(falloff_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDisplace ****************/

class CompositorNodeDisplace : public CompositorNode {
public:
	CompositorNodeDisplace(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDistanceMatte ****************/

class CompositorNodeDistanceMatte : public CompositorNode {
public:
	CompositorNodeDistanceMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum channel_enum {
		channel_RGB = 1,
		channel_YCC = 2,
	};
	inline channel_enum channel(void);
	inline void channel(channel_enum value);
	inline float tolerance(void);
	inline void tolerance(float value);
	inline float falloff(void);
	inline void falloff(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeDoubleEdgeMask ****************/

class CompositorNodeDoubleEdgeMask : public CompositorNode {
public:
	CompositorNodeDoubleEdgeMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum inner_mode_enum {
		inner_mode_ALL = 0,
		inner_mode_ADJACENT_ONLY = 1,
	};
	inline inner_mode_enum inner_mode(void);
	inline void inner_mode(inner_mode_enum value);
	enum edge_mode_enum {
		edge_mode_BLEED_OUT = 0,
		edge_mode_KEEP_IN = 1,
	};
	inline edge_mode_enum edge_mode(void);
	inline void edge_mode(edge_mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeEllipseMask ****************/

class CompositorNodeEllipseMask : public CompositorNode {
public:
	CompositorNodeEllipseMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mask_type_enum {
		mask_type_ADD = 0,
		mask_type_SUBTRACT = 1,
		mask_type_MULTIPLY = 2,
		mask_type_NOT = 3,
	};
	inline mask_type_enum mask_type(void);
	inline void mask_type(mask_type_enum value);
	inline float x(void);
	inline void x(float value);
	inline float y(void);
	inline void y(float value);
	inline float mask_width(void);
	inline void mask_width(float value);
	inline float mask_height(void);
	inline void mask_height(float value);
	inline float rotation(void);
	inline void rotation(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeExposure ****************/

class CompositorNodeExposure : public CompositorNode {
public:
	CompositorNodeExposure(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeFilter ****************/

class CompositorNodeFilter : public CompositorNode {
public:
	CompositorNodeFilter(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum filter_type_enum {
		filter_type_SOFTEN = 0,
		filter_type_SHARPEN = 1,
		filter_type_SHARPEN_DIAMOND = 7,
		filter_type_LAPLACE = 2,
		filter_type_SOBEL = 3,
		filter_type_PREWITT = 4,
		filter_type_KIRSCH = 5,
		filter_type_SHADOW = 6,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeFlip ****************/

class CompositorNodeFlip : public CompositorNode {
public:
	CompositorNodeFlip(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
		axis_XY = 2,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeGamma ****************/

class CompositorNodeGamma : public CompositorNode {
public:
	CompositorNodeGamma(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeGlare ****************/

class CompositorNodeGlare : public CompositorNode {
public:
	CompositorNodeGlare(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum glare_type_enum {
		glare_type_BLOOM = 4,
		glare_type_GHOSTS = 3,
		glare_type_STREAKS = 2,
		glare_type_FOG_GLOW = 1,
		glare_type_SIMPLE_STAR = 0,
	};
	inline glare_type_enum glare_type(void);
	inline void glare_type(glare_type_enum value);
	enum quality_enum {
		quality_HIGH = 0,
		quality_MEDIUM = 1,
		quality_LOW = 2,
	};
	inline quality_enum quality(void);
	inline void quality(quality_enum value);
	inline int iterations(void);
	inline void iterations(int value);
	inline float color_modulation(void);
	inline void color_modulation(float value);
	inline float mix(void);
	inline void mix(float value);
	inline float threshold(void);
	inline void threshold(float value);
	inline int streaks(void);
	inline void streaks(int value);
	inline float angle_offset(void);
	inline void angle_offset(float value);
	inline float fade(void);
	inline void fade(float value);
	inline bool use_rotate_45(void);
	inline void use_rotate_45(bool value);
	inline int size(void);
	inline void size(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeHueCorrect ****************/

class CompositorNodeHueCorrect : public CompositorNode {
public:
	CompositorNodeHueCorrect(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeHueSat ****************/

class CompositorNodeHueSat : public CompositorNode {
public:
	CompositorNodeHueSat(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeIDMask ****************/

class CompositorNodeIDMask : public CompositorNode {
public:
	CompositorNodeIDMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int index(void);
	inline void index(int value);
	inline bool use_antialiasing(void);
	inline void use_antialiasing(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeImage ****************/

class CompositorNodeImage : public CompositorNode {
public:
	CompositorNodeImage(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Image image(void);
	inline bool use_straight_alpha_output(void);
	inline void use_straight_alpha_output(bool value);
	inline int frame_duration(void);
	inline void frame_duration(int value);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_offset(void);
	inline void frame_offset(int value);
	inline bool use_cyclic(void);
	inline void use_cyclic(bool value);
	inline bool use_auto_refresh(void);
	inline void use_auto_refresh(bool value);
	enum layer_enum {
		layer_PLACEHOLDER = 0,
	};
	inline layer_enum layer(void);
	inline void layer(layer_enum value);
	inline bool has_layers(void);
	inline void has_layers(bool value);
	enum view_enum {
		view_ALL = 0,
	};
	inline view_enum view(void);
	inline void view(view_enum value);
	inline bool has_views(void);
	inline void has_views(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeImageCoordinates ****************/

class CompositorNodeImageCoordinates : public CompositorNode {
public:
	CompositorNodeImageCoordinates(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeImageInfo ****************/

class CompositorNodeImageInfo : public CompositorNode {
public:
	CompositorNodeImageInfo(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeInpaint ****************/

class CompositorNodeInpaint : public CompositorNode {
public:
	CompositorNodeInpaint(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int distance(void);
	inline void distance(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeInvert ****************/

class CompositorNodeInvert : public CompositorNode {
public:
	CompositorNodeInvert(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool invert_rgb(void);
	inline void invert_rgb(bool value);
	inline bool invert_alpha(void);
	inline void invert_alpha(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeKeying ****************/

class CompositorNodeKeying : public CompositorNode {
public:
	CompositorNodeKeying(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float screen_balance(void);
	inline void screen_balance(float value);
	inline float despill_factor(void);
	inline void despill_factor(float value);
	inline float despill_balance(void);
	inline void despill_balance(float value);
	inline float clip_black(void);
	inline void clip_black(float value);
	inline float clip_white(void);
	inline void clip_white(float value);
	inline int blur_pre(void);
	inline void blur_pre(int value);
	inline int blur_post(void);
	inline void blur_post(int value);
	inline int dilate_distance(void);
	inline void dilate_distance(int value);
	inline int edge_kernel_radius(void);
	inline void edge_kernel_radius(int value);
	inline float edge_kernel_tolerance(void);
	inline void edge_kernel_tolerance(float value);
	enum feather_falloff_enum {
		feather_falloff_SMOOTH = 0,
		feather_falloff_SPHERE = 1,
		feather_falloff_ROOT = 2,
		feather_falloff_INVERSE_SQUARE = 7,
		feather_falloff_SHARP = 3,
		feather_falloff_LINEAR = 4,
	};
	inline feather_falloff_enum feather_falloff(void);
	inline void feather_falloff(feather_falloff_enum value);
	inline int feather_distance(void);
	inline void feather_distance(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeKeyingScreen ****************/

class CompositorNodeKeyingScreen : public CompositorNode {
public:
	CompositorNodeKeyingScreen(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline std::string tracking_object(void);
	inline void tracking_object(const std::string& value);
	inline float smoothness(void);
	inline void smoothness(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeKuwahara ****************/

class CompositorNodeKuwahara : public CompositorNode {
public:
	CompositorNodeKuwahara(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum variation_enum {
		variation_CLASSIC = 0,
		variation_ANISOTROPIC = 1,
	};
	inline variation_enum variation(void);
	inline void variation(variation_enum value);
	inline bool use_high_precision(void);
	inline void use_high_precision(bool value);
	inline int uniformity(void);
	inline void uniformity(int value);
	inline float sharpness(void);
	inline void sharpness(float value);
	inline float eccentricity(void);
	inline void eccentricity(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeLensdist ****************/

class CompositorNodeLensdist : public CompositorNode {
public:
	CompositorNodeLensdist(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum distortion_type_enum {
		distortion_type_RADIAL = 0,
		distortion_type_HORIZONTAL = 1,
	};
	inline distortion_type_enum distortion_type(void);
	inline void distortion_type(distortion_type_enum value);
	inline bool use_projector(void);
	inline void use_projector(bool value);
	inline bool use_jitter(void);
	inline void use_jitter(bool value);
	inline bool use_fit(void);
	inline void use_fit(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeLevels ****************/

class CompositorNodeLevels : public CompositorNode {
public:
	CompositorNodeLevels(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum channel_enum {
		channel_COMBINED_RGB = 1,
		channel_RED = 2,
		channel_GREEN = 3,
		channel_BLUE = 4,
		channel_LUMINANCE = 5,
	};
	inline channel_enum channel(void);
	inline void channel(channel_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeLumaMatte ****************/

class CompositorNodeLumaMatte : public CompositorNode {
public:
	CompositorNodeLumaMatte(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline float limit_max(void);
	inline void limit_max(float value);
	inline float limit_min(void);
	inline void limit_min(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeMapRange ****************/

class CompositorNodeMapRange : public CompositorNode {
public:
	CompositorNodeMapRange(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_clamp(void);
	inline void use_clamp(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeMapUV ****************/

class CompositorNodeMapUV : public CompositorNode {
public:
	CompositorNodeMapUV(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int alpha(void);
	inline void alpha(int value);
	enum filter_type_enum {
		filter_type_NEAREST = 0,
		filter_type_ANISOTROPIC = 3,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeMapValue ****************/

class CompositorNodeMapValue : public CompositorNode {
public:
	CompositorNodeMapValue(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Array<float, 1> offset(void);
	inline void offset(float values[1]);
	inline Array<float, 1> size(void);
	inline void size(float values[1]);
	inline bool use_min(void);
	inline void use_min(bool value);
	inline bool use_max(void);
	inline void use_max(bool value);
	inline Array<float, 1> min(void);
	inline void min(float values[1]);
	inline Array<float, 1> max(void);
	inline void max(float values[1]);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeMask ****************/

class CompositorNodeMask : public CompositorNode {
public:
	CompositorNodeMask(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Mask mask(void);
	inline bool use_feather(void);
	inline void use_feather(bool value);
	inline bool use_motion_blur(void);
	inline void use_motion_blur(bool value);
	inline int motion_blur_samples(void);
	inline void motion_blur_samples(int value);
	inline float motion_blur_shutter(void);
	inline void motion_blur_shutter(float value);
	enum size_source_enum {
		size_source_SCENE = 0,
		size_source_FIXED = 256,
		size_source_FIXED_SCENE = 512,
	};
	inline size_source_enum size_source(void);
	inline void size_source(size_source_enum value);
	inline int size_x(void);
	inline void size_x(int value);
	inline int size_y(void);
	inline void size_y(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeMath ****************/

class CompositorNodeMath : public CompositorNode {
public:
	CompositorNodeMath(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum operation_enum {
		operation_ADD = 0,
		operation_SUBTRACT = 1,
		operation_MULTIPLY = 2,
		operation_DIVIDE = 3,
		operation_MULTIPLY_ADD = 36,
		operation_POWER = 10,
		operation_LOGARITHM = 11,
		operation_SQRT = 23,
		operation_INVERSE_SQRT = 24,
		operation_ABSOLUTE = 18,
		operation_EXPONENT = 26,
		operation_MINIMUM = 12,
		operation_MAXIMUM = 13,
		operation_LESS_THAN = 15,
		operation_GREATER_THAN = 16,
		operation_SIGN = 25,
		operation_COMPARE = 35,
		operation_SMOOTH_MIN = 38,
		operation_SMOOTH_MAX = 39,
		operation_ROUND = 14,
		operation_FLOOR = 20,
		operation_CEIL = 21,
		operation_TRUNC = 32,
		operation_FRACT = 22,
		operation_MODULO = 17,
		operation_FLOORED_MODULO = 40,
		operation_WRAP = 34,
		operation_SNAP = 33,
		operation_PINGPONG = 37,
		operation_SINE = 4,
		operation_COSINE = 5,
		operation_TANGENT = 6,
		operation_ARCSINE = 7,
		operation_ARCCOSINE = 8,
		operation_ARCTANGENT = 9,
		operation_ARCTAN2 = 19,
		operation_SINH = 29,
		operation_COSH = 30,
		operation_TANH = 31,
		operation_RADIANS = 27,
		operation_DEGREES = 28,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	inline bool use_clamp(void);
	inline void use_clamp(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeMixRGB ****************/

class CompositorNodeMixRGB : public CompositorNode {
public:
	CompositorNodeMixRGB(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_DARKEN = 7,
		blend_type_MULTIPLY = 2,
		blend_type_BURN = 11,
		blend_type_LIGHTEN = 8,
		blend_type_SCREEN = 4,
		blend_type_DODGE = 10,
		blend_type_ADD = 1,
		blend_type_OVERLAY = 9,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
		blend_type_DIFFERENCE = 6,
		blend_type_EXCLUSION = 18,
		blend_type_SUBTRACT = 3,
		blend_type_DIVIDE = 5,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_COLOR = 15,
		blend_type_VALUE = 14,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_alpha(void);
	inline void use_alpha(bool value);
	inline bool use_clamp(void);
	inline void use_clamp(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeMovieClip ****************/

class CompositorNodeMovieClip : public CompositorNode {
public:
	CompositorNodeMovieClip(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeMovieDistortion ****************/

class CompositorNodeMovieDistortion : public CompositorNode {
public:
	CompositorNodeMovieDistortion(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	enum distortion_type_enum {
		distortion_type_UNDISTORT = 0,
		distortion_type_DISTORT = 1,
	};
	inline distortion_type_enum distortion_type(void);
	inline void distortion_type(distortion_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeNormal ****************/

class CompositorNodeNormal : public CompositorNode {
public:
	CompositorNodeNormal(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeNormalize ****************/

class CompositorNodeNormalize : public CompositorNode {
public:
	CompositorNodeNormalize(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeOutputFile ****************/

class CompositorNodeOutputFile : public CompositorNode {
public:
	CompositorNodeOutputFile(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg),
		file_slots(ptr_arg),
		layer_slots(ptr_arg)
		{}

	inline std::string base_path(void);
	inline void base_path(const std::string& value);
	inline int active_input_index(void);
	inline void active_input_index(int value);
	inline ImageFormatSettings format(void);
	inline bool save_as_render(void);
	inline void save_as_render(bool value);
	COLLECTION_PROPERTY(CompositorNodeOutputFileFileSlots, NodeOutputFileSlotFile, CompositorNodeOutputFile, file_slots, false, false, false)
	COLLECTION_PROPERTY(CompositorNodeOutputFileLayerSlots, NodeOutputFileSlotLayer, CompositorNodeOutputFile, layer_slots, false, false, false)

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Output File Slot ****************/

class NodeOutputFileSlotFile : public Pointer {
public:
	NodeOutputFileSlotFile(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline bool use_node_format(void);
	inline void use_node_format(bool value);
	inline bool save_as_render(void);
	inline void save_as_render(bool value);
	inline ImageFormatSettings format(void);
	inline std::string path(void);
	inline void path(const std::string& value);

};

/**************** Output File Layer Slot ****************/

class NodeOutputFileSlotLayer : public Pointer {
public:
	NodeOutputFileSlotLayer(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);

};

/**************** CompositorNodePixelate ****************/

class CompositorNodePixelate : public CompositorNode {
public:
	CompositorNodePixelate(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int pixel_size(void);
	inline void pixel_size(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodePlaneTrackDeform ****************/

class CompositorNodePlaneTrackDeform : public CompositorNode {
public:
	CompositorNodePlaneTrackDeform(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	inline std::string tracking_object(void);
	inline void tracking_object(const std::string& value);
	inline std::string plane_track_name(void);
	inline void plane_track_name(const std::string& value);
	inline bool use_motion_blur(void);
	inline void use_motion_blur(bool value);
	inline int motion_blur_samples(void);
	inline void motion_blur_samples(int value);
	inline float motion_blur_shutter(void);
	inline void motion_blur_shutter(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodePosterize ****************/

class CompositorNodePosterize : public CompositorNode {
public:
	CompositorNodePosterize(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodePremulKey ****************/

class CompositorNodePremulKey : public CompositorNode {
public:
	CompositorNodePremulKey(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mapping_enum {
		mapping_STRAIGHT_TO_PREMUL = 0,
		mapping_PREMUL_TO_STRAIGHT = 1,
	};
	inline mapping_enum mapping(void);
	inline void mapping(mapping_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeRelativeToPixel ****************/

class CompositorNodeRelativeToPixel : public CompositorNode {
public:
	CompositorNodeRelativeToPixel(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeRGB ****************/

class CompositorNodeRGB : public CompositorNode {
public:
	CompositorNodeRGB(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeRGBToBW ****************/

class CompositorNodeRGBToBW : public CompositorNode {
public:
	CompositorNodeRGBToBW(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeRLayers ****************/

class CompositorNodeRLayers : public CompositorNode {
public:
	CompositorNodeRLayers(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Scene scene(void);
	enum layer_enum {
		layer_PLACEHOLDER = 0,
	};
	inline layer_enum layer(void);
	inline void layer(layer_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeRotate ****************/

class CompositorNodeRotate : public CompositorNode {
public:
	CompositorNodeRotate(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum filter_type_enum {
		filter_type_NEAREST = 0,
		filter_type_BILINEAR = 1,
		filter_type_BICUBIC = 2,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeScale ****************/

class CompositorNodeScale : public CompositorNode {
public:
	CompositorNodeScale(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum space_enum {
		space_RELATIVE = 0,
		space_ABSOLUTE = 1,
		space_SCENE_SIZE = 2,
		space_RENDER_SIZE = 3,
	};
	inline space_enum space(void);
	inline void space(space_enum value);
	enum frame_method_enum {
		frame_method_STRETCH = 0,
		frame_method_FIT = 1,
		frame_method_CROP = 2,
	};
	inline frame_method_enum frame_method(void);
	inline void frame_method(frame_method_enum value);
	inline float offset_x(void);
	inline void offset_x(float value);
	inline float offset_y(void);
	inline void offset_y(float value);
	enum interpolation_enum {
		interpolation_NEAREST = 0,
		interpolation_BILINEAR = 1,
		interpolation_BICUBIC = 2,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSceneTime ****************/

class CompositorNodeSceneTime : public CompositorNode {
public:
	CompositorNodeSceneTime(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSeparateColor ****************/

class CompositorNodeSeparateColor : public CompositorNode {
public:
	CompositorNodeSeparateColor(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_RGB = 0,
		mode_HSV = 1,
		mode_HSL = 2,
		mode_YCC = 3,
		mode_YUV = 4,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);
	enum ycc_mode_enum {
		ycc_mode_ITUBT601 = 0,
		ycc_mode_ITUBT709 = 1,
		ycc_mode_JFIF = 2,
	};
	inline ycc_mode_enum ycc_mode(void);
	inline void ycc_mode(ycc_mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSeparateXYZ ****************/

class CompositorNodeSeparateXYZ : public CompositorNode {
public:
	CompositorNodeSeparateXYZ(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSepHSVA ****************/

class CompositorNodeSepHSVA : public CompositorNode {
public:
	CompositorNodeSepHSVA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSepRGBA ****************/

class CompositorNodeSepRGBA : public CompositorNode {
public:
	CompositorNodeSepRGBA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSepYCCA ****************/

class CompositorNodeSepYCCA : public CompositorNode {
public:
	CompositorNodeSepYCCA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_ITUBT601 = 0,
		mode_ITUBT709 = 1,
		mode_JFIF = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSepYUVA ****************/

class CompositorNodeSepYUVA : public CompositorNode {
public:
	CompositorNodeSepYUVA(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSetAlpha ****************/

class CompositorNodeSetAlpha : public CompositorNode {
public:
	CompositorNodeSetAlpha(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum mode_enum {
		mode_APPLY = 0,
		mode_REPLACE_ALPHA = 1,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSplit ****************/

class CompositorNodeSplit : public CompositorNode {
public:
	CompositorNodeSplit(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum axis_enum {
		axis_X = 0,
		axis_Y = 1,
	};
	inline axis_enum axis(void);
	inline void axis(axis_enum value);
	inline int factor(void);
	inline void factor(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeStabilize ****************/

class CompositorNodeStabilize : public CompositorNode {
public:
	CompositorNodeStabilize(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	enum filter_type_enum {
		filter_type_NEAREST = 0,
		filter_type_BILINEAR = 1,
		filter_type_BICUBIC = 2,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);
	inline bool invert(void);
	inline void invert(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSunBeams ****************/

class CompositorNodeSunBeams : public CompositorNode {
public:
	CompositorNodeSunBeams(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Array<float, 2> source(void);
	inline void source(float values[2]);
	inline float ray_length(void);
	inline void ray_length(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSwitch ****************/

class CompositorNodeSwitch : public CompositorNode {
public:
	CompositorNodeSwitch(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool check(void);
	inline void check(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeSwitchView ****************/

class CompositorNodeSwitchView : public CompositorNode {
public:
	CompositorNodeSwitchView(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeTexture ****************/

class CompositorNodeTexture : public CompositorNode {
public:
	CompositorNodeTexture(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline Texture texture(void);
	inline int node_output(void);
	inline void node_output(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeTime ****************/

class CompositorNodeTime : public CompositorNode {
public:
	CompositorNodeTime(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline CurveMapping curve(void);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeTonemap ****************/

class CompositorNodeTonemap : public CompositorNode {
public:
	CompositorNodeTonemap(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum tonemap_type_enum {
		tonemap_type_RD_PHOTORECEPTOR = 1,
		tonemap_type_RH_SIMPLE = 0,
	};
	inline tonemap_type_enum tonemap_type(void);
	inline void tonemap_type(tonemap_type_enum value);
	inline float key(void);
	inline void key(float value);
	inline float offset(void);
	inline void offset(float value);
	inline float gamma(void);
	inline void gamma(float value);
	inline float intensity(void);
	inline void intensity(float value);
	inline float contrast(void);
	inline void contrast(float value);
	inline float adaptation(void);
	inline void adaptation(float value);
	inline float correction(void);
	inline void correction(float value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeTrackPos ****************/

class CompositorNodeTrackPos : public CompositorNode {
public:
	CompositorNodeTrackPos(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline MovieClip clip(void);
	enum position_enum {
		position_ABSOLUTE = 0,
		position_RELATIVE_START = 1,
		position_RELATIVE_FRAME = 2,
		position_ABSOLUTE_FRAME = 3,
	};
	inline position_enum position(void);
	inline void position(position_enum value);
	inline int frame_relative(void);
	inline void frame_relative(int value);
	inline std::string tracking_object(void);
	inline void tracking_object(const std::string& value);
	inline std::string track_name(void);
	inline void track_name(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeTransform ****************/

class CompositorNodeTransform : public CompositorNode {
public:
	CompositorNodeTransform(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum filter_type_enum {
		filter_type_NEAREST = 0,
		filter_type_BILINEAR = 1,
		filter_type_BICUBIC = 2,
	};
	inline filter_type_enum filter_type(void);
	inline void filter_type(filter_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeTranslate ****************/

class CompositorNodeTranslate : public CompositorNode {
public:
	CompositorNodeTranslate(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	enum interpolation_enum {
		interpolation_NEAREST = 0,
		interpolation_BILINEAR = 1,
		interpolation_BICUBIC = 2,
	};
	inline interpolation_enum interpolation(void);
	inline void interpolation(interpolation_enum value);
	inline bool use_relative(void);
	inline void use_relative(bool value);
	enum wrap_axis_enum {
		wrap_axis_NONE = 0,
		wrap_axis_XAXIS = 1,
		wrap_axis_YAXIS = 2,
		wrap_axis_BOTH = 3,
	};
	inline wrap_axis_enum wrap_axis(void);
	inline void wrap_axis(wrap_axis_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeValToRGB ****************/

class CompositorNodeValToRGB : public CompositorNode {
public:
	CompositorNodeValToRGB(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline ColorRamp color_ramp(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeValue ****************/

class CompositorNodeValue : public CompositorNode {
public:
	CompositorNodeValue(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeVecBlur ****************/

class CompositorNodeVecBlur : public CompositorNode {
public:
	CompositorNodeVecBlur(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline int samples(void);
	inline void samples(int value);
	inline int speed_min(void);
	inline void speed_min(int value);
	inline int speed_max(void);
	inline void speed_max(int value);
	inline float factor(void);
	inline void factor(float value);
	inline bool use_curved(void);
	inline void use_curved(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeViewer ****************/

class CompositorNodeViewer : public CompositorNode {
public:
	CompositorNodeViewer(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_alpha(void);
	inline void use_alpha(bool value);
	inline int ui_shortcut(void);
	inline void ui_shortcut(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** CompositorNodeZcombine ****************/

class CompositorNodeZcombine : public CompositorNode {
public:
	CompositorNodeZcombine(const PointerRNA &ptr_arg) :
		CompositorNode(ptr_arg)
		{}

	inline bool use_alpha(void);
	inline void use_alpha(bool value);
	inline bool use_antialias_z(void);
	inline void use_antialias_z(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeAt ****************/

class TextureNodeAt : public TextureNode {
public:
	TextureNodeAt(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeBricks ****************/

class TextureNodeBricks : public TextureNode {
public:
	TextureNodeBricks(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline float offset(void);
	inline void offset(float value);
	inline int offset_frequency(void);
	inline void offset_frequency(int value);
	inline float squash(void);
	inline void squash(float value);
	inline int squash_frequency(void);
	inline void squash_frequency(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeChecker ****************/

class TextureNodeChecker : public TextureNode {
public:
	TextureNodeChecker(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeCombineColor ****************/

class TextureNodeCombineColor : public TextureNode {
public:
	TextureNodeCombineColor(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	enum mode_enum {
		mode_RGB = 0,
		mode_HSV = 1,
		mode_HSL = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeCompose ****************/

class TextureNodeCompose : public TextureNode {
public:
	TextureNodeCompose(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeCoordinates ****************/

class TextureNodeCoordinates : public TextureNode {
public:
	TextureNodeCoordinates(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeCurveRGB ****************/

class TextureNodeCurveRGB : public TextureNode {
public:
	TextureNodeCurveRGB(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline CurveMapping mapping(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeCurveTime ****************/

class TextureNodeCurveTime : public TextureNode {
public:
	TextureNodeCurveTime(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline CurveMapping curve(void);
	inline int frame_start(void);
	inline void frame_start(int value);
	inline int frame_end(void);
	inline void frame_end(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeDecompose ****************/

class TextureNodeDecompose : public TextureNode {
public:
	TextureNodeDecompose(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeDistance ****************/

class TextureNodeDistance : public TextureNode {
public:
	TextureNodeDistance(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeHueSaturation ****************/

class TextureNodeHueSaturation : public TextureNode {
public:
	TextureNodeHueSaturation(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeImage ****************/

class TextureNodeImage : public TextureNode {
public:
	TextureNodeImage(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline Image image(void);
	inline ImageUser image_user(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeInvert ****************/

class TextureNodeInvert : public TextureNode {
public:
	TextureNodeInvert(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeMath ****************/

class TextureNodeMath : public TextureNode {
public:
	TextureNodeMath(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	enum operation_enum {
		operation_ADD = 0,
		operation_SUBTRACT = 1,
		operation_MULTIPLY = 2,
		operation_DIVIDE = 3,
		operation_MULTIPLY_ADD = 36,
		operation_POWER = 10,
		operation_LOGARITHM = 11,
		operation_SQRT = 23,
		operation_INVERSE_SQRT = 24,
		operation_ABSOLUTE = 18,
		operation_EXPONENT = 26,
		operation_MINIMUM = 12,
		operation_MAXIMUM = 13,
		operation_LESS_THAN = 15,
		operation_GREATER_THAN = 16,
		operation_SIGN = 25,
		operation_COMPARE = 35,
		operation_SMOOTH_MIN = 38,
		operation_SMOOTH_MAX = 39,
		operation_ROUND = 14,
		operation_FLOOR = 20,
		operation_CEIL = 21,
		operation_TRUNC = 32,
		operation_FRACT = 22,
		operation_MODULO = 17,
		operation_FLOORED_MODULO = 40,
		operation_WRAP = 34,
		operation_SNAP = 33,
		operation_PINGPONG = 37,
		operation_SINE = 4,
		operation_COSINE = 5,
		operation_TANGENT = 6,
		operation_ARCSINE = 7,
		operation_ARCCOSINE = 8,
		operation_ARCTANGENT = 9,
		operation_ARCTAN2 = 19,
		operation_SINH = 29,
		operation_COSH = 30,
		operation_TANH = 31,
		operation_RADIANS = 27,
		operation_DEGREES = 28,
	};
	inline operation_enum operation(void);
	inline void operation(operation_enum value);
	inline bool use_clamp(void);
	inline void use_clamp(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeMixRGB ****************/

class TextureNodeMixRGB : public TextureNode {
public:
	TextureNodeMixRGB(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	enum blend_type_enum {
		blend_type_MIX = 0,
		blend_type_DARKEN = 7,
		blend_type_MULTIPLY = 2,
		blend_type_BURN = 11,
		blend_type_LIGHTEN = 8,
		blend_type_SCREEN = 4,
		blend_type_DODGE = 10,
		blend_type_ADD = 1,
		blend_type_OVERLAY = 9,
		blend_type_SOFT_LIGHT = 16,
		blend_type_LINEAR_LIGHT = 17,
		blend_type_DIFFERENCE = 6,
		blend_type_EXCLUSION = 18,
		blend_type_SUBTRACT = 3,
		blend_type_DIVIDE = 5,
		blend_type_HUE = 12,
		blend_type_SATURATION = 13,
		blend_type_COLOR = 15,
		blend_type_VALUE = 14,
	};
	inline blend_type_enum blend_type(void);
	inline void blend_type(blend_type_enum value);
	inline bool use_alpha(void);
	inline void use_alpha(bool value);
	inline bool use_clamp(void);
	inline void use_clamp(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeOutput ****************/

class TextureNodeOutput : public TextureNode {
public:
	TextureNodeOutput(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline std::string filepath(void);
	inline void filepath(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeRGBToBW ****************/

class TextureNodeRGBToBW : public TextureNode {
public:
	TextureNodeRGBToBW(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeRotate ****************/

class TextureNodeRotate : public TextureNode {
public:
	TextureNodeRotate(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeScale ****************/

class TextureNodeScale : public TextureNode {
public:
	TextureNodeScale(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeSeparateColor ****************/

class TextureNodeSeparateColor : public TextureNode {
public:
	TextureNodeSeparateColor(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	enum mode_enum {
		mode_RGB = 0,
		mode_HSV = 1,
		mode_HSL = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexBlend ****************/

class TextureNodeTexBlend : public TextureNode {
public:
	TextureNodeTexBlend(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexClouds ****************/

class TextureNodeTexClouds : public TextureNode {
public:
	TextureNodeTexClouds(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexDistNoise ****************/

class TextureNodeTexDistNoise : public TextureNode {
public:
	TextureNodeTexDistNoise(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexMagic ****************/

class TextureNodeTexMagic : public TextureNode {
public:
	TextureNodeTexMagic(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexMarble ****************/

class TextureNodeTexMarble : public TextureNode {
public:
	TextureNodeTexMarble(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexMusgrave ****************/

class TextureNodeTexMusgrave : public TextureNode {
public:
	TextureNodeTexMusgrave(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexNoise ****************/

class TextureNodeTexNoise : public TextureNode {
public:
	TextureNodeTexNoise(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexStucci ****************/

class TextureNodeTexStucci : public TextureNode {
public:
	TextureNodeTexStucci(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexture ****************/

class TextureNodeTexture : public TextureNode {
public:
	TextureNodeTexture(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline Texture texture(void);
	inline int node_output(void);
	inline void node_output(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexVoronoi ****************/

class TextureNodeTexVoronoi : public TextureNode {
public:
	TextureNodeTexVoronoi(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTexWood ****************/

class TextureNodeTexWood : public TextureNode {
public:
	TextureNodeTexWood(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeTranslate ****************/

class TextureNodeTranslate : public TextureNode {
public:
	TextureNodeTranslate(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeValToNor ****************/

class TextureNodeValToNor : public TextureNode {
public:
	TextureNodeValToNor(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeValToRGB ****************/

class TextureNodeValToRGB : public TextureNode {
public:
	TextureNodeValToRGB(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}

	inline ColorRamp color_ramp(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** TextureNodeViewer ****************/

class TextureNodeViewer : public TextureNode {
public:
	TextureNodeViewer(const PointerRNA &ptr_arg) :
		TextureNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeAlignEulerToVector ****************/

class FunctionNodeAlignEulerToVector : public FunctionNode {
public:
	FunctionNodeAlignEulerToVector(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeAlignRotationToVector ****************/

class FunctionNodeAlignRotationToVector : public FunctionNode {
public:
	FunctionNodeAlignRotationToVector(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeAxesToRotation ****************/

class FunctionNodeAxesToRotation : public FunctionNode {
public:
	FunctionNodeAxesToRotation(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeAxisAngleToRotation ****************/

class FunctionNodeAxisAngleToRotation : public FunctionNode {
public:
	FunctionNodeAxisAngleToRotation(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeBitMath ****************/

class FunctionNodeBitMath : public FunctionNode {
public:
	FunctionNodeBitMath(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeBooleanMath ****************/

class FunctionNodeBooleanMath : public FunctionNode {
public:
	FunctionNodeBooleanMath(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeCombineColor ****************/

class FunctionNodeCombineColor : public FunctionNode {
public:
	FunctionNodeCombineColor(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeCombineMatrix ****************/

class FunctionNodeCombineMatrix : public FunctionNode {
public:
	FunctionNodeCombineMatrix(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeCombineTransform ****************/

class FunctionNodeCombineTransform : public FunctionNode {
public:
	FunctionNodeCombineTransform(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeCompare ****************/

class FunctionNodeCompare : public FunctionNode {
public:
	FunctionNodeCompare(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeEulerToRotation ****************/

class FunctionNodeEulerToRotation : public FunctionNode {
public:
	FunctionNodeEulerToRotation(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeFindInString ****************/

class FunctionNodeFindInString : public FunctionNode {
public:
	FunctionNodeFindInString(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeFloatToInt ****************/

class FunctionNodeFloatToInt : public FunctionNode {
public:
	FunctionNodeFloatToInt(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	enum rounding_mode_enum {
		rounding_mode_ROUND = 0,
		rounding_mode_FLOOR = 1,
		rounding_mode_CEILING = 2,
		rounding_mode_TRUNCATE = 3,
	};
	inline rounding_mode_enum rounding_mode(void);
	inline void rounding_mode(rounding_mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeFormatString ****************/

class FunctionNodeFormatString : public FunctionNode {
public:
	FunctionNodeFormatString(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg),
		format_items(ptr_arg)
		{}

	COLLECTION_PROPERTY(NodeFunctionFormatStringItems, NodeFunctionFormatStringItem, FunctionNodeFormatString, format_items, true, true, true)
	inline int active_index(void);
	inline void active_index(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Format String Item ****************/

class NodeFunctionFormatStringItem : public Pointer {
public:
	NodeFunctionFormatStringItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum socket_type_enum {
		socket_type_FLOAT = 0,
		socket_type_INT = 6,
		socket_type_BOOLEAN = 4,
		socket_type_VECTOR = 1,
		socket_type_ROTATION = 14,
		socket_type_MATRIX = 16,
		socket_type_STRING = 7,
		socket_type_MENU = 15,
		socket_type_RGBA = 2,
		socket_type_OBJECT = 8,
		socket_type_IMAGE = 9,
		socket_type_GEOMETRY = 10,
		socket_type_COLLECTION = 11,
		socket_type_TEXTURE = 12,
		socket_type_MATERIAL = 13,
		socket_type_BUNDLE = 17,
		socket_type_CLOSURE = 18,
	};
	inline socket_type_enum socket_type(void);
	inline void socket_type(socket_type_enum value);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);

};

/**************** FunctionNodeHashValue ****************/

class FunctionNodeHashValue : public FunctionNode {
public:
	FunctionNodeHashValue(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInputBool ****************/

class FunctionNodeInputBool : public FunctionNode {
public:
	FunctionNodeInputBool(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	inline bool boolean(void);
	inline void boolean(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInputColor ****************/

class FunctionNodeInputColor : public FunctionNode {
public:
	FunctionNodeInputColor(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	inline Array<float, 4> value(void);
	inline void value(float values[4]);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInputInt ****************/

class FunctionNodeInputInt : public FunctionNode {
public:
	FunctionNodeInputInt(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	inline int integer(void);
	inline void integer(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInputRotation ****************/

class FunctionNodeInputRotation : public FunctionNode {
public:
	FunctionNodeInputRotation(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	inline Array<float, 3> rotation_euler(void);
	inline void rotation_euler(float values[3]);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInputSpecialCharacters ****************/

class FunctionNodeInputSpecialCharacters : public FunctionNode {
public:
	FunctionNodeInputSpecialCharacters(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInputString ****************/

class FunctionNodeInputString : public FunctionNode {
public:
	FunctionNodeInputString(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	inline std::string string(void);
	inline void string(const std::string& value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInputVector ****************/

class FunctionNodeInputVector : public FunctionNode {
public:
	FunctionNodeInputVector(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	inline Array<float, 3> vector(void);
	inline void vector(float values[3]);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeIntegerMath ****************/

class FunctionNodeIntegerMath : public FunctionNode {
public:
	FunctionNodeIntegerMath(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInvertMatrix ****************/

class FunctionNodeInvertMatrix : public FunctionNode {
public:
	FunctionNodeInvertMatrix(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeInvertRotation ****************/

class FunctionNodeInvertRotation : public FunctionNode {
public:
	FunctionNodeInvertRotation(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeMatchString ****************/

class FunctionNodeMatchString : public FunctionNode {
public:
	FunctionNodeMatchString(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeMatrixDeterminant ****************/

class FunctionNodeMatrixDeterminant : public FunctionNode {
public:
	FunctionNodeMatrixDeterminant(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeMatrixMultiply ****************/

class FunctionNodeMatrixMultiply : public FunctionNode {
public:
	FunctionNodeMatrixMultiply(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeProjectPoint ****************/

class FunctionNodeProjectPoint : public FunctionNode {
public:
	FunctionNodeProjectPoint(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeQuaternionToRotation ****************/

class FunctionNodeQuaternionToRotation : public FunctionNode {
public:
	FunctionNodeQuaternionToRotation(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeRandomValue ****************/

class FunctionNodeRandomValue : public FunctionNode {
public:
	FunctionNodeRandomValue(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	enum data_type_enum {
		data_type_FLOAT = 10,
		data_type_INT = 11,
		data_type_FLOAT_VECTOR = 48,
		data_type_FLOAT_COLOR = 47,
		data_type_BYTE_COLOR = 17,
		data_type_STRING = 12,
		data_type_BOOLEAN = 50,
		data_type_FLOAT2 = 49,
		data_type_INT8 = 45,
		data_type_INT16_2D = 22,
		data_type_INT32_2D = 46,
		data_type_QUATERNION = 52,
		data_type_FLOAT4X4 = 20,
	};
	inline data_type_enum data_type(void);
	inline void data_type(data_type_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeReplaceString ****************/

class FunctionNodeReplaceString : public FunctionNode {
public:
	FunctionNodeReplaceString(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeRotateEuler ****************/

class FunctionNodeRotateEuler : public FunctionNode {
public:
	FunctionNodeRotateEuler(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}

	enum rotation_type_enum {
		rotation_type_AXIS_ANGLE = 1,
		rotation_type_EULER = 0,
	};
	inline rotation_type_enum rotation_type(void);
	inline void rotation_type(rotation_type_enum value);
	enum space_enum {
		space_OBJECT = 0,
		space_LOCAL = 1,
	};
	inline space_enum space(void);
	inline void space(space_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeRotateRotation ****************/

class FunctionNodeRotateRotation : public FunctionNode {
public:
	FunctionNodeRotateRotation(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeRotateVector ****************/

class FunctionNodeRotateVector : public FunctionNode {
public:
	FunctionNodeRotateVector(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeRotationToAxisAngle ****************/

class FunctionNodeRotationToAxisAngle : public FunctionNode {
public:
	FunctionNodeRotationToAxisAngle(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeRotationToEuler ****************/

class FunctionNodeRotationToEuler : public FunctionNode {
public:
	FunctionNodeRotationToEuler(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeRotationToQuaternion ****************/

class FunctionNodeRotationToQuaternion : public FunctionNode {
public:
	FunctionNodeRotationToQuaternion(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeSeparateColor ****************/

class FunctionNodeSeparateColor : public FunctionNode {
public:
	FunctionNodeSeparateColor(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeSeparateMatrix ****************/

class FunctionNodeSeparateMatrix : public FunctionNode {
public:
	FunctionNodeSeparateMatrix(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeSeparateTransform ****************/

class FunctionNodeSeparateTransform : public FunctionNode {
public:
	FunctionNodeSeparateTransform(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeSliceString ****************/

class FunctionNodeSliceString : public FunctionNode {
public:
	FunctionNodeSliceString(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeStringLength ****************/

class FunctionNodeStringLength : public FunctionNode {
public:
	FunctionNodeStringLength(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeTransformDirection ****************/

class FunctionNodeTransformDirection : public FunctionNode {
public:
	FunctionNodeTransformDirection(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeTransformPoint ****************/

class FunctionNodeTransformPoint : public FunctionNode {
public:
	FunctionNodeTransformPoint(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeTransposeMatrix ****************/

class FunctionNodeTransposeMatrix : public FunctionNode {
public:
	FunctionNodeTransposeMatrix(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** FunctionNodeValueToString ****************/

class FunctionNodeValueToString : public FunctionNode {
public:
	FunctionNodeValueToString(const PointerRNA &ptr_arg) :
		FunctionNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeAccumulateField ****************/

class GeometryNodeAccumulateField : public GeometryNode {
public:
	GeometryNodeAccumulateField(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeAttributeDomainSize ****************/

class GeometryNodeAttributeDomainSize : public GeometryNode {
public:
	GeometryNodeAttributeDomainSize(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeAttributeStatistic ****************/

class GeometryNodeAttributeStatistic : public GeometryNode {
public:
	GeometryNodeAttributeStatistic(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeBake ****************/

class GeometryNodeBake : public GeometryNode {
public:
	GeometryNodeBake(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg),
		bake_items(ptr_arg)
		{}

	COLLECTION_PROPERTY(NodeGeometryBakeItems, NodeGeometryBakeItem, GeometryNodeBake, bake_items, true, true, true)
	inline int active_index(void);
	inline void active_index(int value);
	inline RepeatItem active_item(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Bake Item ****************/

class NodeGeometryBakeItem : public Pointer {
public:
	NodeGeometryBakeItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum socket_type_enum {
		socket_type_FLOAT = 0,
		socket_type_INT = 6,
		socket_type_BOOLEAN = 4,
		socket_type_VECTOR = 1,
		socket_type_ROTATION = 14,
		socket_type_MATRIX = 16,
		socket_type_STRING = 7,
		socket_type_MENU = 15,
		socket_type_RGBA = 2,
		socket_type_OBJECT = 8,
		socket_type_IMAGE = 9,
		socket_type_GEOMETRY = 10,
		socket_type_COLLECTION = 11,
		socket_type_TEXTURE = 12,
		socket_type_MATERIAL = 13,
		socket_type_BUNDLE = 17,
		socket_type_CLOSURE = 18,
	};
	inline socket_type_enum socket_type(void);
	inline void socket_type(socket_type_enum value);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);
	enum attribute_domain_enum {
		attribute_domain_POINT = 0,
		attribute_domain_EDGE = 1,
		attribute_domain_FACE = 2,
		attribute_domain_CORNER = 3,
		attribute_domain_CURVE = 4,
		attribute_domain_INSTANCE = 5,
		attribute_domain_LAYER = 6,
	};
	inline attribute_domain_enum attribute_domain(void);
	inline void attribute_domain(attribute_domain_enum value);
	inline bool is_attribute(void);
	inline void is_attribute(bool value);

};

/**************** GeometryNodeBlurAttribute ****************/

class GeometryNodeBlurAttribute : public GeometryNode {
public:
	GeometryNodeBlurAttribute(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeBoundBox ****************/

class GeometryNodeBoundBox : public GeometryNode {
public:
	GeometryNodeBoundBox(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCameraInfo ****************/

class GeometryNodeCameraInfo : public GeometryNode {
public:
	GeometryNodeCameraInfo(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCaptureAttribute ****************/

class GeometryNodeCaptureAttribute : public GeometryNode {
public:
	GeometryNodeCaptureAttribute(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg),
		capture_items(ptr_arg)
		{}

	COLLECTION_PROPERTY(NodeGeometryCaptureAttributeItems, NodeGeometryCaptureAttributeItem, GeometryNodeCaptureAttribute, capture_items, true, true, true)
	inline int active_index(void);
	inline void active_index(int value);
	inline RepeatItem active_item(void);
	enum domain_enum {
		domain_POINT = 0,
		domain_EDGE = 1,
		domain_FACE = 2,
		domain_CORNER = 3,
		domain_CURVE = 4,
		domain_INSTANCE = 5,
		domain_LAYER = 6,
	};
	inline domain_enum domain(void);
	inline void domain(domain_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Capture Attribute Item ****************/

class NodeGeometryCaptureAttributeItem : public Pointer {
public:
	NodeGeometryCaptureAttributeItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);
	enum data_type_enum {
		data_type_FLOAT = 10,
		data_type_INT = 11,
		data_type_FLOAT_VECTOR = 48,
		data_type_FLOAT_COLOR = 47,
		data_type_BYTE_COLOR = 17,
		data_type_STRING = 12,
		data_type_BOOLEAN = 50,
		data_type_FLOAT2 = 49,
		data_type_INT8 = 45,
		data_type_INT16_2D = 22,
		data_type_INT32_2D = 46,
		data_type_QUATERNION = 52,
		data_type_FLOAT4X4 = 20,
	};
	inline data_type_enum data_type(void);
	inline void data_type(data_type_enum value);

};

/**************** GeometryNodeClosureInput ****************/

class GeometryNodeClosureInput : public GeometryNode {
public:
	GeometryNodeClosureInput(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}

	inline Node paired_output(void);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
	inline bool pair_with_output(Context C, GeometryNode& output_node);
};

/**************** GeometryNodeClosureOutput ****************/

class GeometryNodeClosureOutput : public GeometryNode {
public:
	GeometryNodeClosureOutput(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg),
		input_items(ptr_arg),
		output_items(ptr_arg)
		{}

	COLLECTION_PROPERTY(NodeGeometryClosureInputItems, NodeGeometryClosureInputItem, GeometryNodeClosureOutput, input_items, true, true, true)
	COLLECTION_PROPERTY(NodeGeometryClosureOutputItems, NodeGeometryClosureOutputItem, GeometryNodeClosureOutput, output_items, true, true, true)
	inline int active_input_index(void);
	inline void active_input_index(int value);
	inline int active_output_index(void);
	inline void active_output_index(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Closure Input Item ****************/

class NodeGeometryClosureInputItem : public Pointer {
public:
	NodeGeometryClosureInputItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum socket_type_enum {
		socket_type_FLOAT = 0,
		socket_type_INT = 6,
		socket_type_BOOLEAN = 4,
		socket_type_VECTOR = 1,
		socket_type_ROTATION = 14,
		socket_type_MATRIX = 16,
		socket_type_STRING = 7,
		socket_type_MENU = 15,
		socket_type_RGBA = 2,
		socket_type_OBJECT = 8,
		socket_type_IMAGE = 9,
		socket_type_GEOMETRY = 10,
		socket_type_COLLECTION = 11,
		socket_type_TEXTURE = 12,
		socket_type_MATERIAL = 13,
		socket_type_BUNDLE = 17,
		socket_type_CLOSURE = 18,
	};
	inline socket_type_enum socket_type(void);
	inline void socket_type(socket_type_enum value);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);

};

/**************** Closure Output Item ****************/

class NodeGeometryClosureOutputItem : public Pointer {
public:
	NodeGeometryClosureOutputItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum socket_type_enum {
		socket_type_FLOAT = 0,
		socket_type_INT = 6,
		socket_type_BOOLEAN = 4,
		socket_type_VECTOR = 1,
		socket_type_ROTATION = 14,
		socket_type_MATRIX = 16,
		socket_type_STRING = 7,
		socket_type_MENU = 15,
		socket_type_RGBA = 2,
		socket_type_OBJECT = 8,
		socket_type_IMAGE = 9,
		socket_type_GEOMETRY = 10,
		socket_type_COLLECTION = 11,
		socket_type_TEXTURE = 12,
		socket_type_MATERIAL = 13,
		socket_type_BUNDLE = 17,
		socket_type_CLOSURE = 18,
	};
	inline socket_type_enum socket_type(void);
	inline void socket_type(socket_type_enum value);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);

};

/**************** GeometryNodeCollectionInfo ****************/

class GeometryNodeCollectionInfo : public GeometryNode {
public:
	GeometryNodeCollectionInfo(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCombineBundle ****************/

class GeometryNodeCombineBundle : public GeometryNode {
public:
	GeometryNodeCombineBundle(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg),
		bundle_items(ptr_arg)
		{}

	COLLECTION_PROPERTY(NodeGeometryCombineBundleItems, NodeGeometryCombineBundleItem, GeometryNodeCombineBundle, bundle_items, true, true, true)
	inline int active_index(void);
	inline void active_index(int value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** Combine Bundle Item ****************/

class NodeGeometryCombineBundleItem : public Pointer {
public:
	NodeGeometryCombineBundleItem(const PointerRNA &ptr_arg) :
		Pointer(ptr_arg)
		{}

	inline Struct rna_type(void);
	inline std::string name(void);
	inline void name(const std::string& value);
	enum socket_type_enum {
		socket_type_FLOAT = 0,
		socket_type_INT = 6,
		socket_type_BOOLEAN = 4,
		socket_type_VECTOR = 1,
		socket_type_ROTATION = 14,
		socket_type_MATRIX = 16,
		socket_type_STRING = 7,
		socket_type_MENU = 15,
		socket_type_RGBA = 2,
		socket_type_OBJECT = 8,
		socket_type_IMAGE = 9,
		socket_type_GEOMETRY = 10,
		socket_type_COLLECTION = 11,
		socket_type_TEXTURE = 12,
		socket_type_MATERIAL = 13,
		socket_type_BUNDLE = 17,
		socket_type_CLOSURE = 18,
	};
	inline socket_type_enum socket_type(void);
	inline void socket_type(socket_type_enum value);
	inline Array<float, 4> color(void);
	inline void color(float values[4]);

};

/**************** GeometryNodeConvexHull ****************/

class GeometryNodeConvexHull : public GeometryNode {
public:
	GeometryNodeConvexHull(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCornersOfEdge ****************/

class GeometryNodeCornersOfEdge : public GeometryNode {
public:
	GeometryNodeCornersOfEdge(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCornersOfFace ****************/

class GeometryNodeCornersOfFace : public GeometryNode {
public:
	GeometryNodeCornersOfFace(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCornersOfVertex ****************/

class GeometryNodeCornersOfVertex : public GeometryNode {
public:
	GeometryNodeCornersOfVertex(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveArc ****************/

class GeometryNodeCurveArc : public GeometryNode {
public:
	GeometryNodeCurveArc(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveEndpointSelection ****************/

class GeometryNodeCurveEndpointSelection : public GeometryNode {
public:
	GeometryNodeCurveEndpointSelection(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveHandleTypeSelection ****************/

class GeometryNodeCurveHandleTypeSelection : public GeometryNode {
public:
	GeometryNodeCurveHandleTypeSelection(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}

	enum handle_type_enum {
		handle_type_FREE = 0,
		handle_type_AUTO = 1,
		handle_type_VECTOR = 2,
		handle_type_ALIGN = 3,
	};
	inline handle_type_enum handle_type(void);
	inline void handle_type(handle_type_enum value);
	enum mode_enum {
		mode_LEFT = 1,
		mode_RIGHT = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveLength ****************/

class GeometryNodeCurveLength : public GeometryNode {
public:
	GeometryNodeCurveLength(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveOfPoint ****************/

class GeometryNodeCurveOfPoint : public GeometryNode {
public:
	GeometryNodeCurveOfPoint(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurvePrimitiveBezierSegment ****************/

class GeometryNodeCurvePrimitiveBezierSegment : public GeometryNode {
public:
	GeometryNodeCurvePrimitiveBezierSegment(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurvePrimitiveCircle ****************/

class GeometryNodeCurvePrimitiveCircle : public GeometryNode {
public:
	GeometryNodeCurvePrimitiveCircle(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurvePrimitiveLine ****************/

class GeometryNodeCurvePrimitiveLine : public GeometryNode {
public:
	GeometryNodeCurvePrimitiveLine(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurvePrimitiveQuadrilateral ****************/

class GeometryNodeCurvePrimitiveQuadrilateral : public GeometryNode {
public:
	GeometryNodeCurvePrimitiveQuadrilateral(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveQuadraticBezier ****************/

class GeometryNodeCurveQuadraticBezier : public GeometryNode {
public:
	GeometryNodeCurveQuadraticBezier(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveSetHandles ****************/

class GeometryNodeCurveSetHandles : public GeometryNode {
public:
	GeometryNodeCurveSetHandles(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}

	enum handle_type_enum {
		handle_type_FREE = 0,
		handle_type_AUTO = 1,
		handle_type_VECTOR = 2,
		handle_type_ALIGN = 3,
	};
	inline handle_type_enum handle_type(void);
	inline void handle_type(handle_type_enum value);
	enum mode_enum {
		mode_LEFT = 1,
		mode_RIGHT = 2,
	};
	inline mode_enum mode(void);
	inline void mode(mode_enum value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveSpiral ****************/

class GeometryNodeCurveSpiral : public GeometryNode {
public:
	GeometryNodeCurveSpiral(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveSplineType ****************/

class GeometryNodeCurveSplineType : public GeometryNode {
public:
	GeometryNodeCurveSplineType(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveStar ****************/

class GeometryNodeCurveStar : public GeometryNode {
public:
	GeometryNodeCurveStar(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurvesToGreasePencil ****************/

class GeometryNodeCurvesToGreasePencil : public GeometryNode {
public:
	GeometryNodeCurvesToGreasePencil(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveToMesh ****************/

class GeometryNodeCurveToMesh : public GeometryNode {
public:
	GeometryNodeCurveToMesh(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeCurveToPoints ****************/

class GeometryNodeCurveToPoints : public GeometryNode {
public:
	GeometryNodeCurveToPoints(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeDeformCurvesOnSurface ****************/

class GeometryNodeDeformCurvesOnSurface : public GeometryNode {
public:
	GeometryNodeDeformCurvesOnSurface(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeDeleteGeometry ****************/

class GeometryNodeDeleteGeometry : public GeometryNode {
public:
	GeometryNodeDeleteGeometry(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeDistributePointsInGrid ****************/

class GeometryNodeDistributePointsInGrid : public GeometryNode {
public:
	GeometryNodeDistributePointsInGrid(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeDistributePointsInVolume ****************/

class GeometryNodeDistributePointsInVolume : public GeometryNode {
public:
	GeometryNodeDistributePointsInVolume(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeDistributePointsOnFaces ****************/

class GeometryNodeDistributePointsOnFaces : public GeometryNode {
public:
	GeometryNodeDistributePointsOnFaces(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}

	enum distribute_method_enum {
		distribute_method_RANDOM = 0,
		distribute_method_POISSON = 1,
	};
	inline distribute_method_enum distribute_method(void);
	inline void distribute_method(distribute_method_enum value);
	inline bool use_legacy_normal(void);
	inline void use_legacy_normal(bool value);

	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeDualMesh ****************/

class GeometryNodeDualMesh : public GeometryNode {
public:
	GeometryNodeDualMesh(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeDuplicateElements ****************/

class GeometryNodeDuplicateElements : public GeometryNode {
public:
	GeometryNodeDuplicateElements(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeEdgePathsToCurves ****************/

class GeometryNodeEdgePathsToCurves : public GeometryNode {
public:
	GeometryNodeEdgePathsToCurves(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeEdgePathsToSelection ****************/

class GeometryNodeEdgePathsToSelection : public GeometryNode {
public:
	GeometryNodeEdgePathsToSelection(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeEdgesOfCorner ****************/

class GeometryNodeEdgesOfCorner : public GeometryNode {
public:
	GeometryNodeEdgesOfCorner(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeEdgesOfVertex ****************/

class GeometryNodeEdgesOfVertex : public GeometryNode {
public:
	GeometryNodeEdgesOfVertex(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**************** GeometryNodeEdgesToFaceGroups ****************/

class GeometryNodeEdgesToFaceGroups : public GeometryNode {
public:
	GeometryNodeEdgesToFaceGroups(const PointerRNA &ptr_arg) :
		GeometryNode(ptr_arg)
		{}


	inline bool is_registered_node_type();
	inline NodeInternalSocketTemplate input_template(int index);
	inline NodeInternalSocketTemplate output_template(int index);
};

/**