/* SvgTransforms.c generated by valac 0.56.17, the Vala compiler
 * generated from SvgTransforms.vala, do not modify */

/*
Copyright (C) 2016 2019 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gee.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_SVG_TRANSFORMS_0_PROPERTY,
	BIRD_FONT_SVG_TRANSFORMS_NUM_PROPERTIES
};
static GParamSpec* bird_font_svg_transforms_properties[BIRD_FONT_SVG_TRANSFORMS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

static gpointer bird_font_svg_transforms_parent_class = NULL;

static void bird_font_svg_transforms_finalize (GObject * obj);
static GType bird_font_svg_transforms_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

BirdFontSvgTransforms*
bird_font_svg_transforms_construct (GType object_type)
{
	BirdFontSvgTransforms * self = NULL;
	GeeArrayList* _tmp0_;
	self = (BirdFontSvgTransforms*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_SVG_TRANSFORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->transforms);
	self->transforms = _tmp0_;
	cairo_matrix_init_identity (&self->rotation_matrix);
	cairo_matrix_init_identity (&self->size_matrix);
	return self;
}

BirdFontSvgTransforms*
bird_font_svg_transforms_new (void)
{
	return bird_font_svg_transforms_construct (BIRD_FONT_TYPE_SVG_TRANSFORMS);
}

void
bird_font_svg_transforms_clear_rotation (BirdFontSvgTransforms* self)
{
	g_return_if_fail (self != NULL);
	self->rotation = (gdouble) 0;
	self->total_rotation = (gdouble) 0;
	cairo_matrix_init_identity (&self->rotation_matrix);
}

gdouble
bird_font_svg_transforms_get_rotation (BirdFontSvgTransforms* self)
{
	cairo_matrix_t m = {0};
	cairo_matrix_t _tmp0_ = {0};
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	bird_font_svg_transforms_get_matrix (self, &_tmp0_);
	m = _tmp0_;
	w = (gdouble) 1;
	h = (gdouble) 1;
	cairo_matrix_transform_distance (&m, &w, &h);
	result = atan2 (h, w);
	return result;
}

void
bird_font_svg_transforms_collapse_transforms (BirdFontSvgTransforms* self)
{
	cairo_matrix_t collapsed = {0};
	cairo_matrix_t _tmp0_ = {0};
	BirdFontSvgTransform* collapsed_transform = NULL;
	cairo_matrix_t _tmp1_;
	BirdFontSvgTransform* _tmp2_;
	g_return_if_fail (self != NULL);
	bird_font_svg_transforms_get_matrix (self, &_tmp0_);
	collapsed = _tmp0_;
	self->translate_x = (gdouble) 0;
	self->translate_y = (gdouble) 0;
	cairo_matrix_init_identity (&self->rotation_matrix);
	self->rotation = (gdouble) 0;
	cairo_matrix_init_identity (&self->size_matrix);
	bird_font_svg_transforms_clear (self);
	_tmp1_ = collapsed;
	_tmp2_ = bird_font_svg_transform_new_for_matrix (&_tmp1_);
	collapsed_transform = _tmp2_;
	bird_font_svg_transforms_add (self, collapsed_transform);
	_g_object_unref0 (collapsed_transform);
}

void
bird_font_svg_transforms_clear (BirdFontSvgTransforms* self)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->transforms;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	cairo_matrix_init_identity (&self->rotation_matrix);
	self->rotation = (gdouble) 0;
	cairo_matrix_init_identity (&self->size_matrix);
	self->translate_x = (gdouble) 0;
	self->translate_y = (gdouble) 0;
}

void
bird_font_svg_transforms_translate (BirdFontSvgTransforms* self,
                                    gdouble x,
                                    gdouble y)
{
	g_return_if_fail (self != NULL);
	self->translate_x = self->translate_x + x;
	self->translate_y = self->translate_y + y;
}

void
bird_font_svg_transforms_rotate (BirdFontSvgTransforms* self,
                                 gdouble theta,
                                 gdouble x,
                                 gdouble y)
{
	g_return_if_fail (self != NULL);
	self->rotation = self->rotation + theta;
	self->total_rotation = self->total_rotation + theta;
	while (TRUE) {
		if (!(self->rotation > (2 * G_PI))) {
			break;
		}
		self->rotation = self->rotation - (2 * G_PI);
	}
	while (TRUE) {
		if (!(self->rotation < (-2 * G_PI))) {
			break;
		}
		self->rotation = self->rotation + (2 * G_PI);
	}
	while (TRUE) {
		if (!(self->total_rotation > (2 * G_PI))) {
			break;
		}
		self->total_rotation = self->total_rotation - (2 * G_PI);
	}
	while (TRUE) {
		if (!(self->total_rotation < (-2 * G_PI))) {
			break;
		}
		self->total_rotation = self->total_rotation + (2 * G_PI);
	}
	cairo_matrix_init_identity (&self->rotation_matrix);
	cairo_matrix_translate (&self->rotation_matrix, x, y);
	cairo_matrix_rotate (&self->rotation_matrix, self->rotation);
	cairo_matrix_translate (&self->rotation_matrix, -x, -y);
}

void
bird_font_svg_transforms_resize (BirdFontSvgTransforms* self,
                                 gdouble scale_x,
                                 gdouble scale_y,
                                 gdouble x,
                                 gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	g_return_if_fail (self != NULL);
	if (scale_x <= ((gdouble) 0)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = scale_y <= ((gdouble) 0);
	}
	if (_tmp0_) {
		return;
	}
	x2 = x;
	y2 = y;
	cairo_matrix_init_identity (&self->size_matrix);
	cairo_matrix_scale (&self->size_matrix, scale_x, scale_y);
	cairo_matrix_transform_point (&self->size_matrix, &x2, &y2);
	dx = x - x2;
	dy = y - y2;
	cairo_matrix_translate (&self->size_matrix, dx / scale_x, dy / scale_y);
}

BirdFontSvgTransforms*
bird_font_svg_transforms_copy (BirdFontSvgTransforms* self)
{
	BirdFontSvgTransforms* copy_transforms = NULL;
	BirdFontSvgTransforms* _tmp0_;
	BirdFontSvgTransforms* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_svg_transforms_new ();
	copy_transforms = _tmp0_;
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp1_;
		gint _t_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _t_index = 0;
		_tmp1_ = self->transforms;
		_t_list = _tmp1_;
		_tmp2_ = _t_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_t_size = _tmp4_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontSvgTransform* t = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontSvgTransforms* _tmp9_;
			BirdFontSvgTransform* _tmp10_;
			BirdFontSvgTransform* _tmp11_;
			BirdFontSvgTransform* _tmp12_;
			_t_index = _t_index + 1;
			_tmp5_ = _t_index;
			_tmp6_ = _t_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _t_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _t_index);
			t = (BirdFontSvgTransform*) _tmp8_;
			_tmp9_ = copy_transforms;
			_tmp10_ = t;
			_tmp11_ = bird_font_svg_transform_copy (_tmp10_);
			_tmp12_ = _tmp11_;
			bird_font_svg_transforms_add (_tmp9_, _tmp12_);
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (t);
		}
	}
	result = copy_transforms;
	return result;
}

void
bird_font_svg_transforms_insert (BirdFontSvgTransforms* self,
                                 gint position,
                                 BirdFontSvgTransform* transform)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transform != NULL);
	_tmp0_ = self->transforms;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp0_, position, transform);
}

void
bird_font_svg_transforms_add (BirdFontSvgTransforms* self,
                              BirdFontSvgTransform* transform)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transform != NULL);
	_tmp0_ = self->transforms;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, transform);
}

void
bird_font_svg_transforms_get_matrix (BirdFontSvgTransforms* self,
                                     cairo_matrix_t* result)
{
	cairo_matrix_t transformation_matrix = {0};
	cairo_matrix_t _tmp12_;
	cairo_matrix_t _tmp13_;
	cairo_matrix_t _tmp14_;
	cairo_matrix_t _tmp15_;
	g_return_if_fail (self != NULL);
	cairo_matrix_init_identity (&transformation_matrix);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				cairo_matrix_t part = {0};
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				BirdFontSvgTransform* _tmp7_;
				cairo_matrix_t _tmp8_ = {0};
				cairo_matrix_t _tmp9_;
				cairo_matrix_t _tmp10_;
				cairo_matrix_t _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->transforms;
				_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->transforms;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i);
				_tmp7_ = (BirdFontSvgTransform*) _tmp6_;
				bird_font_svg_transform_get_matrix (_tmp7_, &_tmp8_);
				_tmp9_ = _tmp8_;
				_g_object_unref0 (_tmp7_);
				part = _tmp9_;
				_tmp10_ = part;
				_tmp11_ = transformation_matrix;
				cairo_matrix_multiply (&transformation_matrix, &_tmp10_, &_tmp11_);
			}
		}
	}
	cairo_matrix_translate (&transformation_matrix, self->translate_x, self->translate_y);
	_tmp12_ = transformation_matrix;
	_tmp13_ = self->rotation_matrix;
	cairo_matrix_multiply (&transformation_matrix, &_tmp12_, &_tmp13_);
	_tmp14_ = transformation_matrix;
	_tmp15_ = self->size_matrix;
	cairo_matrix_multiply (&transformation_matrix, &_tmp14_, &_tmp15_);
	*result = transformation_matrix;
	return;
}

gchar*
bird_font_svg_transforms_to_string (BirdFontSvgTransforms* self)
{
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp1_;
		gint _t_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _t_index = 0;
		_tmp1_ = self->transforms;
		_t_list = _tmp1_;
		_tmp2_ = _t_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_t_size = _tmp4_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontSvgTransform* t = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GString* _tmp9_;
			BirdFontSvgTransform* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GString* _tmp13_;
			_t_index = _t_index + 1;
			_tmp5_ = _t_index;
			_tmp6_ = _t_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _t_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _t_index);
			t = (BirdFontSvgTransform*) _tmp8_;
			_tmp9_ = sb;
			_tmp10_ = t;
			_tmp11_ = bird_font_svg_transform_to_string (_tmp10_);
			_tmp12_ = _tmp11_;
			g_string_append (_tmp9_, _tmp12_);
			_g_free0 (_tmp12_);
			_tmp13_ = sb;
			g_string_append (_tmp13_, " ");
			_g_object_unref0 (t);
		}
	}
	_tmp14_ = sb;
	_tmp15_ = _tmp14_->str;
	_tmp16_ = g_strdup (_tmp15_);
	result = _tmp16_;
	_g_string_free0 (sb);
	return result;
}

static void
bird_font_svg_transforms_class_init (BirdFontSvgTransformsClass * klass,
                                     gpointer klass_data)
{
	bird_font_svg_transforms_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_svg_transforms_finalize;
}

static void
bird_font_svg_transforms_instance_init (BirdFontSvgTransforms * self,
                                        gpointer klass)
{
	self->rotation = (gdouble) 0;
	self->total_rotation = (gdouble) 0;
	self->translate_x = (gdouble) 0;
	self->translate_y = (gdouble) 0;
}

static void
bird_font_svg_transforms_finalize (GObject * obj)
{
	BirdFontSvgTransforms * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SVG_TRANSFORMS, BirdFontSvgTransforms);
	_g_object_unref0 (self->transforms);
	G_OBJECT_CLASS (bird_font_svg_transforms_parent_class)->finalize (obj);
}

static GType
bird_font_svg_transforms_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSvgTransformsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_svg_transforms_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSvgTransforms), 0, (GInstanceInitFunc) bird_font_svg_transforms_instance_init, NULL };
	GType bird_font_svg_transforms_type_id;
	bird_font_svg_transforms_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontSvgTransforms", &g_define_type_info, 0);
	return bird_font_svg_transforms_type_id;
}

GType
bird_font_svg_transforms_get_type (void)
{
	static volatile gsize bird_font_svg_transforms_type_id__once = 0;
	if (g_once_init_enter (&bird_font_svg_transforms_type_id__once)) {
		GType bird_font_svg_transforms_type_id;
		bird_font_svg_transforms_type_id = bird_font_svg_transforms_get_type_once ();
		g_once_init_leave (&bird_font_svg_transforms_type_id__once, bird_font_svg_transforms_type_id);
	}
	return bird_font_svg_transforms_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

