/* src/bazaar.p/bz-flathub-sub-category.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-flathub-sub-category.h"



struct _BzFlathubSubCategory
{
  GObject parent_instance;

  char *name;
  char *id;
};

G_DEFINE_FINAL_TYPE (BzFlathubSubCategory, bz_flathub_sub_category, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_NAME,
  PROP_ID,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_flathub_sub_category_dispose (GObject *object)
{
  BzFlathubSubCategory *self = BZ_FLATHUB_SUB_CATEGORY (object);

  g_clear_pointer (&self->name, g_free);
  g_clear_pointer (&self->id, g_free);

  G_OBJECT_CLASS (bz_flathub_sub_category_parent_class)->dispose (object);
}

static void
bz_flathub_sub_category_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzFlathubSubCategory *self = BZ_FLATHUB_SUB_CATEGORY (object);

  switch (prop_id)
    {
    case PROP_NAME:
      g_value_set_string (value, bz_flathub_sub_category_get_name (self));
      break;
    case PROP_ID:
      g_value_set_string (value, bz_flathub_sub_category_get_id (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_flathub_sub_category_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzFlathubSubCategory *self = BZ_FLATHUB_SUB_CATEGORY (object);

  switch (prop_id)
    {
    case PROP_NAME:
      bz_flathub_sub_category_set_name (self, g_value_get_string (value));
      break;
    case PROP_ID:
      bz_flathub_sub_category_set_id (self, g_value_get_string (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_flathub_sub_category_class_init (BzFlathubSubCategoryClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_flathub_sub_category_set_property;
  object_class->get_property = bz_flathub_sub_category_get_property;
  object_class->dispose      = bz_flathub_sub_category_dispose;

  props[PROP_NAME] =
      g_param_spec_string (
          "name",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_ID] =
      g_param_spec_string (
          "id",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_flathub_sub_category_init (BzFlathubSubCategory *self)
{
}

BzFlathubSubCategory *
bz_flathub_sub_category_new (void){
  return g_object_new (BZ_TYPE_FLATHUB_SUB_CATEGORY, NULL);
}

const char *
bz_flathub_sub_category_get_name (BzFlathubSubCategory *self){
  g_return_val_if_fail (BZ_IS_FLATHUB_SUB_CATEGORY (self), NULL);
  return self->name;
}

const char *
bz_flathub_sub_category_get_id (BzFlathubSubCategory *self){
  g_return_val_if_fail (BZ_IS_FLATHUB_SUB_CATEGORY (self), NULL);
  return self->id;
}

void
bz_flathub_sub_category_set_name (BzFlathubSubCategory *self,
    const char *name){
  g_return_if_fail (BZ_IS_FLATHUB_SUB_CATEGORY (self));

  if (name == self->name || (name != NULL && self->name != NULL && g_strcmp0(name, self->name) == 0))
    return;

  g_clear_pointer (&self->name, g_free);
  if (name != NULL)
    self->name = g_strdup (name);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_NAME]);
}

void
bz_flathub_sub_category_set_id (BzFlathubSubCategory *self,
    const char *id){
  g_return_if_fail (BZ_IS_FLATHUB_SUB_CATEGORY (self));

  if (id == self->id || (id != NULL && self->id != NULL && g_strcmp0(id, self->id) == 0))
    return;

  g_clear_pointer (&self->id, g_free);
  if (id != NULL)
    self->id = g_strdup (id);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ID]);
}

/* End of src/bazaar.p/bz-flathub-sub-category.c */
