/* src/bazaar.p/bz-curated-image-info.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-curated-image-info.h"



struct _BzCuratedImageInfo
{
  GObject parent_instance;

  char *uri;
  char *light_uri;
  char *dark_uri;
  int width;
  int height;
  gboolean can_shrink;
  GtkContentFit fit;
};

G_DEFINE_FINAL_TYPE (BzCuratedImageInfo, bz_curated_image_info, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_URI,
  PROP_LIGHT_URI,
  PROP_DARK_URI,
  PROP_WIDTH,
  PROP_HEIGHT,
  PROP_CAN_SHRINK,
  PROP_FIT,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_curated_image_info_dispose (GObject *object)
{
  BzCuratedImageInfo *self = BZ_CURATED_IMAGE_INFO (object);

  g_clear_pointer (&self->uri, g_free);
  g_clear_pointer (&self->light_uri, g_free);
  g_clear_pointer (&self->dark_uri, g_free);

  G_OBJECT_CLASS (bz_curated_image_info_parent_class)->dispose (object);
}

static void
bz_curated_image_info_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzCuratedImageInfo *self = BZ_CURATED_IMAGE_INFO (object);

  switch (prop_id)
    {
    case PROP_URI:
      g_value_set_string (value, bz_curated_image_info_get_uri (self));
      break;
    case PROP_LIGHT_URI:
      g_value_set_string (value, bz_curated_image_info_get_light_uri (self));
      break;
    case PROP_DARK_URI:
      g_value_set_string (value, bz_curated_image_info_get_dark_uri (self));
      break;
    case PROP_WIDTH:
      g_value_set_int (value, bz_curated_image_info_get_width (self));
      break;
    case PROP_HEIGHT:
      g_value_set_int (value, bz_curated_image_info_get_height (self));
      break;
    case PROP_CAN_SHRINK:
      g_value_set_boolean (value, bz_curated_image_info_get_can_shrink (self));
      break;
    case PROP_FIT:
      g_value_set_enum (value, bz_curated_image_info_get_fit (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_image_info_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzCuratedImageInfo *self = BZ_CURATED_IMAGE_INFO (object);

  switch (prop_id)
    {
    case PROP_URI:
      bz_curated_image_info_set_uri (self, g_value_get_string (value));
      break;
    case PROP_LIGHT_URI:
      bz_curated_image_info_set_light_uri (self, g_value_get_string (value));
      break;
    case PROP_DARK_URI:
      bz_curated_image_info_set_dark_uri (self, g_value_get_string (value));
      break;
    case PROP_WIDTH:
      bz_curated_image_info_set_width (self, g_value_get_int (value));
      break;
    case PROP_HEIGHT:
      bz_curated_image_info_set_height (self, g_value_get_int (value));
      break;
    case PROP_CAN_SHRINK:
      bz_curated_image_info_set_can_shrink (self, g_value_get_boolean (value));
      break;
    case PROP_FIT:
      bz_curated_image_info_set_fit (self, g_value_get_enum (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_curated_image_info_class_init (BzCuratedImageInfoClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_curated_image_info_set_property;
  object_class->get_property = bz_curated_image_info_get_property;
  object_class->dispose      = bz_curated_image_info_dispose;

  props[PROP_URI] =
      g_param_spec_string (
          "uri",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_LIGHT_URI] =
      g_param_spec_string (
          "light-uri",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DARK_URI] =
      g_param_spec_string (
          "dark-uri",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_WIDTH] =
      g_param_spec_int (
          "width",
          NULL, NULL,
          G_MININT, G_MAXINT, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_HEIGHT] =
      g_param_spec_int (
          "height",
          NULL, NULL,
          G_MININT, G_MAXINT, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_CAN_SHRINK] =
      g_param_spec_boolean (
          "can-shrink",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_FIT] =
      g_param_spec_enum (
          "fit",
          NULL, NULL,
          GTK_TYPE_CONTENT_FIT, 0,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_curated_image_info_init (BzCuratedImageInfo *self)
{
}

BzCuratedImageInfo *
bz_curated_image_info_new (void){
  return g_object_new (BZ_TYPE_CURATED_IMAGE_INFO, NULL);
}

const char *
bz_curated_image_info_get_uri (BzCuratedImageInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_IMAGE_INFO (self), NULL);
  return self->uri;
}

const char *
bz_curated_image_info_get_light_uri (BzCuratedImageInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_IMAGE_INFO (self), NULL);
  return self->light_uri;
}

const char *
bz_curated_image_info_get_dark_uri (BzCuratedImageInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_IMAGE_INFO (self), NULL);
  return self->dark_uri;
}

int
bz_curated_image_info_get_width (BzCuratedImageInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_IMAGE_INFO (self), 0);
  return self->width;
}

int
bz_curated_image_info_get_height (BzCuratedImageInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_IMAGE_INFO (self), 0);
  return self->height;
}

gboolean
bz_curated_image_info_get_can_shrink (BzCuratedImageInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_IMAGE_INFO (self), FALSE);
  return self->can_shrink;
}

GtkContentFit
bz_curated_image_info_get_fit (BzCuratedImageInfo *self){
  g_return_val_if_fail (BZ_IS_CURATED_IMAGE_INFO (self), 0);
  return self->fit;
}

void
bz_curated_image_info_set_uri (BzCuratedImageInfo *self,
    const char *uri){
  g_return_if_fail (BZ_IS_CURATED_IMAGE_INFO (self));

  if (uri == self->uri || (uri != NULL && self->uri != NULL && g_strcmp0(uri, self->uri) == 0))
    return;

  g_clear_pointer (&self->uri, g_free);
  if (uri != NULL)
    self->uri = g_strdup (uri);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_URI]);
}

void
bz_curated_image_info_set_light_uri (BzCuratedImageInfo *self,
    const char *light_uri){
  g_return_if_fail (BZ_IS_CURATED_IMAGE_INFO (self));

  if (light_uri == self->light_uri || (light_uri != NULL && self->light_uri != NULL && g_strcmp0(light_uri, self->light_uri) == 0))
    return;

  g_clear_pointer (&self->light_uri, g_free);
  if (light_uri != NULL)
    self->light_uri = g_strdup (light_uri);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_LIGHT_URI]);
}

void
bz_curated_image_info_set_dark_uri (BzCuratedImageInfo *self,
    const char *dark_uri){
  g_return_if_fail (BZ_IS_CURATED_IMAGE_INFO (self));

  if (dark_uri == self->dark_uri || (dark_uri != NULL && self->dark_uri != NULL && g_strcmp0(dark_uri, self->dark_uri) == 0))
    return;

  g_clear_pointer (&self->dark_uri, g_free);
  if (dark_uri != NULL)
    self->dark_uri = g_strdup (dark_uri);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DARK_URI]);
}

void
bz_curated_image_info_set_width (BzCuratedImageInfo *self,
    int width){
  g_return_if_fail (BZ_IS_CURATED_IMAGE_INFO (self));

  if (width == self->width)
    return;

  self->width = width;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_WIDTH]);
}

void
bz_curated_image_info_set_height (BzCuratedImageInfo *self,
    int height){
  g_return_if_fail (BZ_IS_CURATED_IMAGE_INFO (self));

  if (height == self->height)
    return;

  self->height = height;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_HEIGHT]);
}

void
bz_curated_image_info_set_can_shrink (BzCuratedImageInfo *self,
    gboolean can_shrink){
  g_return_if_fail (BZ_IS_CURATED_IMAGE_INFO (self));

  if (!!can_shrink == !!self->can_shrink)
    return;

  self->can_shrink = can_shrink;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_CAN_SHRINK]);
}

void
bz_curated_image_info_set_fit (BzCuratedImageInfo *self,
    GtkContentFit fit){
  g_return_if_fail (BZ_IS_CURATED_IMAGE_INFO (self));

  if (fit == self->fit)
    return;

  self->fit = fit;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_FIT]);
}

/* End of src/bazaar.p/bz-curated-image-info.c */
