/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#include <QtCore/QtPlugin>

#include "/build/avogadrolibs/src/avogadrolibs/avogadro/qtplugins/molecularproperties/molecularproperties.h"


namespace Avogadro::QtPlugins {

class MolecularPropertiesFactory : public QObject, public QtGui::ExtensionPluginFactory
{
  Q_OBJECT
  Q_PLUGIN_METADATA(IID "org.openchemistry.avogadro.ExtensionPluginFactory")
  Q_INTERFACES(Avogadro::QtGui::ExtensionPluginFactory)

public:
  explicit MolecularPropertiesFactory(QObject* parent_ = nullptr) : QObject(parent_) {}

  QtGui::ExtensionPlugin* createInstance(QObject* parent_ = nullptr) override
  {
    auto* object = new MolecularProperties(parent_);
    object->setObjectName("MolecularProperties");
    return object;
  }

  QString identifier() const override { return "MolecularProperties"; }

  QString description() const override { return "Show a window with basic molecular properties."; }

};

} // namespace Avogadro::QtPlugins

#include "MolecularPropertiesPlugin.moc"
