/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.LayoutHelper;

public class TableFilterPanel<T extends JXTable>
extends JPanel {
    private static final long serialVersionUID = -756376186276203390L;

    public TableFilterPanel(T table) {
        this.setLayout(new GridBagLayout());
        JLabel filterLabel = new JLabel(Constant.messages.getString("generic.filter.label"));
        final JTextField filterTextField = new JTextField();
        filterLabel.setLabelFor(filterTextField);
        this.add((Component)filterLabel, LayoutHelper.getGBC(0, 0, 1, 0.0));
        this.add((Component)filterTextField, LayoutHelper.getGBC(1, 0, 1, 1.0));
        String tooltipText = Constant.messages.getString("generic.filter.tooltip");
        filterLabel.setToolTipText(tooltipText);
        filterTextField.setToolTipText(tooltipText);
        filterTextField.getDocument().addDocumentListener(new DocumentListener(){
            final /* synthetic */ JXTable val$table;
            {
                this.val$table = jXTable;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateFilter();
            }

            public void updateFilter() {
                String filterText = filterTextField.getText();
                if (filterText.isEmpty()) {
                    this.val$table.setRowFilter(null);
                    filterTextField.setForeground(UIManager.getColor("TextField.foreground"));
                } else {
                    try {
                        this.val$table.setRowFilter(RowFilter.regexFilter("(?i)" + filterText, new int[0]));
                        filterTextField.setForeground(UIManager.getColor("TextField.foreground"));
                    }
                    catch (PatternSyntaxException e) {
                        filterTextField.setForeground(Color.RED);
                    }
                }
            }
        });
    }
}

