/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkCyclicShiftImageFilter_h
#define sitkCyclicShiftImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class CyclicShiftImageFilter
\brief Perform a cyclic spatial shift of image intensities on the image grid.

This filter supports arbitrary cyclic shifts of pixel values on the image grid. If the Shift is set to [xOff, yOff], the value of the pixel at [0, 0] in the input image will be the value of the pixel in the output image at index [xOff modulo xSize, yOff modulo ySize] where xSize and ySize are the sizes of the image in the x and y dimensions, respectively. If a pixel value is moved across a boundary, the pixel value is wrapped around that boundary. For example, if the image is 40-by-40 and the Shift is [13, 47], then the value of the pixel at [0, 0] in the input image will be the value of the pixel in the output image at index [13, 7].

Negative Shifts are supported. This filter also works with images whose largest possible region starts at a non-zero index.
\sa itk::simple::CyclicShift for the procedural interface
\sa itk::CyclicShiftImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT CyclicShiftImageFilter : public ImageFilter {
    public:
      using Self = CyclicShiftImageFilter;

      /** Destructor */
      virtual ~CyclicShiftImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      CyclicShiftImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = NonLabelPixelIDTypeList;
\

      /**
       * Set/get the shift. Shifts may be positive or negative.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetShift ( std::vector<int> Shift ) { this->m_Shift = std::move(Shift); return *this; }

      /** Set the values of the Shift vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetShift( int value ) { this->m_Shift = std::vector<int>(3, value); return *this; }

      /**
       * Set/get the shift. Shifts may be positive or negative.
       */
      std::vector<int> GetShift() const { return this->m_Shift; }

      /** Name of this class */
      std::string GetName() const { return std::string ("CyclicShiftImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<int>  m_Shift{std::vector<int>(3, 0)};


    };

    /**\
     * \brief Perform a cyclic spatial shift of image intensities on the image grid.
     *
     * This function directly calls the execute method of CyclicShiftImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::CyclicShiftImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image CyclicShift ( const Image& image1, std::vector<int> shift = std::vector<int>(3, 0) );

     /** @} */
}
#endif
