\name{ThresholdImageFilter}
\alias{ThresholdImageFilter}
\title{ThresholdImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Set image values to a user-specified value if they are below, above,
or between simple threshold values.
ThresholdImageFilter}
\details{
ThresholdImageFilter sets image values to a user-specified "outside" value (by default,
"black") if the image values are below, above, or between simple
threshold values.
The available methods are:
ThresholdAbove() : The values greater than the threshold value are set
to OutsideValue
ThresholdBelow() : The values less than the threshold value are set to
OutsideValue
ThresholdOutside() : The values outside the threshold range (less than
lower or greater than upper) are set to OutsideValue
Note that these definitions indicate that pixels equal to the
threshold value are not set to OutsideValue in any of these methods
The pixels must support the operators >= and <=.
See:
Threshold for the procedural interface
itk::ThresholdImageFilter for the Doxygen on the original ITK class.
ThresholdImageFilter}
%C++ includes: sitkThresholdImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{double GetLower() const:}{
Set/Get methods to set the lower threshold.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetOutsideValue() const:}{
Get the "outside" pixel value.
}
\item{double GetUpper() const:}{
Set/Get methods to set the upper threshold.
}
\item{Self SetLower(double Lower):}{
Set/Get methods to set the lower threshold.
}
\item{Self SetOutsideValue(double OutsideValue):}{
The pixel type must support comparison operators. Set the "outside"
pixel value. The default value NumericTraits<PixelType>::ZeroValue() .
}
\item{Self SetUpper(double Upper):}{
Set/Get methods to set the upper threshold.
}
\item{ ThresholdImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ThresholdImageFilter():}{
Destructor
}
}
}
