from typing import Dict

from .. import Provider as LoremProvider


class Provider(LoremProvider):
    """Implement lorem provider for ``cs_CZ`` locale.

    Word list is drawn from the SYN2015.
    (representative corpus of contemporary written Czech published in December 2015)

    The word list is a list of the ~5000 most common lemmas. Abbreviations and first names were removed.

    Sources:
    - https://wiki.korpus.cz/lib/exe/fetch.php/seznamy:syn2015_lemma_utf8.zip

    """

    word_list = (
        "a",
        "absence",
        "absolutně",
        "absolutní",
        "absolvent",
        "absolvovat",
        "absurdní",
        "aby",
        "ač",
        "ačkoli",
        "adresa",
        "advokát",
        "africký",
        "Afrika",
        "agent",
        "agentura",
        "agresivní",
        "aha",
        "ahoj",
        "ach",
        "aj",
        "akademický",
        "akademie",
        "akce",
        "akcie",
        "akční",
        "akorát",
        "akt",
        "aktivita",
        "aktivně",
        "aktivní",
        "aktuální",
        "ala",
        "album",
        "ale",
        "alespoň",
        "alkohol",
        "alternativa",
        "alternativní",
        "ambice",
        "americký",
        "Američan",
        "Amerika",
        "analytik",
        "analýza",
        "analyzovat",
        "and",
        "anděl",
        "android",
        "anebo",
        "anglicky",
        "anglický",
        "Angličan",
        "angličtina",
        "Anglie",
        "ani",
        "aniž",
        "anketa",
        "ano",
        "aplikace",
        "aplikovat",
        "apod",
        "Apple",
        "arabský",
        "areál",
        "argument",
        "architekt",
        "architektonický",
        "architektura",
        "archiv",
        "armáda",
        "asi",
        "Asie",
        "asistent",
        "asociace",
        "aspekt",
        "aspoň",
        "ať",
        "atd",
        "ateliér",
        "atmosféra",
        "atom",
        "atraktivní",
        "Austrálie",
        "auto",
        "autobus",
        "automat",
        "automaticky",
        "automatický",
        "automobil",
        "automobilka",
        "automobilový",
        "autor",
        "autorita",
        "autorka",
        "autorský",
        "avšak",
        "až",
        "ba",
        "babička",
        "báječný",
        "bakterie",
        "balíček",
        "balík",
        "balkón",
        "Baník",
        "banka",
        "bankovní",
        "bar",
        "barák",
        "Barcelona",
        "barevný",
        "barva",
        "báseň",
        "básník",
        "bát",
        "baterie",
        "batoh",
        "bavit",
        "báze",
        "bazén",
        "běh",
        "běhat",
        "během",
        "benzín",
        "Berlín",
        "beton",
        "betonový",
        "bez",
        "bezpečí",
        "bezpečně",
        "bezpečnost",
        "bezpečnostní",
        "bezpečný",
        "bezprostředně",
        "bezprostřední",
        "běžet",
        "běžně",
        "běžný",
        "bilance",
        "bílý",
        "biologický",
        "biskup",
        "bít",
        "bitva",
        "blázen",
        "blbý",
        "bledý",
        "blesk",
        "Blesk",
        "blízko",
        "blízkost",
        "blízký",
        "blížit",
        "blok",
        "boční",
        "bod",
        "bohatství",
        "bohatý",
        "bohužel",
        "boj",
        "bojovat",
        "bojovník",
        "bojový",
        "bok",
        "Boleslav",
        "bolest",
        "bolet",
        "bomba",
        "bota",
        "bouře",
        "box",
        "boží",
        "brada",
        "brambora",
        "brána",
        "bránit",
        "branka",
        "brankář",
        "brát",
        "bratr",
        "Brazílie",
        "brečet",
        "Británie",
        "britský",
        "brněnský",
        "Brno",
        "Brod",
        "Brusel",
        "brýle",
        "brzy",
        "břeh",
        "březen",
        "břicho",
        "buď",
        "Budějovice",
        "budit",
        "budoucí",
        "budoucno",
        "budoucnost",
        "budova",
        "budování",
        "budovat",
        "bůh",
        "bunda",
        "buňka",
        "burza",
        "bydlení",
        "bydlet",
        "byt",
        "byť",
        "být",
        "bytost",
        "bytový",
        "bývalý",
        "bývat",
        "byznys",
        "cca",
        "cela",
        "celek",
        "celkem",
        "celkově",
        "celkový",
        "celý",
        "cena",
        "cenný",
        "centimetr",
        "centrální",
        "centrum",
        "cesta",
        "cestování",
        "cestovat",
        "cestovní",
        "cestující",
        "cibule",
        "cigareta",
        "cihla",
        "cíl",
        "cílový",
        "církev",
        "církevní",
        "císař",
        "císařský",
        "cit",
        "cítit",
        "citlivý",
        "citovat",
        "civilizace",
        "cizí",
        "cizina",
        "cizinec",
        "cm",
        "co",
        "coby",
        "cokoli",
        "copak",
        "cosi",
        "což",
        "cukr",
        "cup",
        "cvičení",
        "cvičit",
        "cyklista",
        "cyklus",
        "čaj",
        "čára",
        "čas",
        "časopis",
        "časový",
        "část",
        "částečně",
        "částice",
        "částka",
        "často",
        "častý",
        "Čech",
        "Čecho",
        "Čechy",
        "čekání",
        "čekat",
        "čelist",
        "čelit",
        "čelo",
        "čepice",
        "černý",
        "čerpadlo",
        "čerpat",
        "čerstvě",
        "čerstvý",
        "čert",
        "červen",
        "červenec",
        "červený",
        "Česko",
        "Československo",
        "československý",
        "česky",
        "český",
        "Český",
        "česnek",
        "čest",
        "čestný",
        "čeština",
        "četný",
        "ČEZ",
        "či",
        "čili",
        "čin",
        "Čína",
        "činit",
        "činnost",
        "čínský",
        "číslo",
        "číst",
        "čistě",
        "čistota",
        "čistý",
        "článek",
        "člen",
        "členský",
        "člověk",
        "člun",
        "čokoláda",
        "ČR",
        "čtenář",
        "čtení",
        "čtrnáct",
        "čtvereční",
        "čtvrt",
        "čtvrť",
        "čtvrtek",
        "čtvrtina",
        "čtvrtletí",
        "čtvrtý",
        "čtyři",
        "čtyřicet",
        "dále",
        "daleko",
        "daleký",
        "dálka",
        "dálkový",
        "dálnice",
        "další",
        "dáma",
        "daň",
        "daňový",
        "daný",
        "dar",
        "dárek",
        "dařit",
        "dát",
        "data",
        "databáze",
        "datový",
        "datum",
        "dav",
        "dávat",
        "David",
        "dávka",
        "dávno",
        "dávný",
        "dbát",
        "dcera",
        "de",
        "debata",
        "děda",
        "dědeček",
        "dědictví",
        "definice",
        "definitivně",
        "definovat",
        "dech",
        "děj",
        "dějiny",
        "deka",
        "děkovat",
        "dělat",
        "dělit",
        "délka",
        "dělník",
        "demokracie",
        "demokrat",
        "demokratický",
        "den",
        "dění",
        "deník",
        "denně",
        "denní",
        "deprese",
        "desátý",
        "deset",
        "desetiletí",
        "design",
        "děsit",
        "desítka",
        "děsivý",
        "deska",
        "déšť",
        "detail",
        "detektiv",
        "dětský",
        "dětství",
        "devadesátý",
        "devátý",
        "děvče",
        "devět",
        "dialog",
        "digitální",
        "dík",
        "díky",
        "díl",
        "dílčí",
        "dílna",
        "dílo",
        "dimenze",
        "dioda",
        "díra",
        "disciplína",
        "disk",
        "diskuse",
        "diskutovat",
        "displej",
        "disponovat",
        "dispozice",
        "distribuce",
        "dít",
        "dítě",
        "div",
        "divadelní",
        "divadlo",
        "divák",
        "dívat",
        "divit",
        "divize",
        "dívka",
        "divný",
        "divoký",
        "dlaň",
        "dlažba",
        "dle",
        "dlouho",
        "dlouhodobě",
        "dlouhodobý",
        "dlouholetý",
        "dlouhý",
        "dluh",
        "dnes",
        "dneska",
        "dnešek",
        "dnešní",
        "dno",
        "do",
        "doba",
        "dobový",
        "dobro",
        "dobrodružství",
        "dobrovolně",
        "dobrovolný",
        "dobrý",
        "dobře",
        "docela",
        "dočkat",
        "dodat",
        "dodávat",
        "dodavatel",
        "dodávka",
        "dodnes",
        "dodržovat",
        "dohled",
        "dohoda",
        "dohodnout",
        "dohromady",
        "docházet",
        "dojem",
        "dojet",
        "dojít",
        "dokázat",
        "dokazovat",
        "doklad",
        "dokládat",
        "dokola",
        "dokonale",
        "dokonalý",
        "dokonce",
        "dokončení",
        "dokončit",
        "doktor",
        "dokud",
        "dokument",
        "dokumentace",
        "dolar",
        "dole",
        "dolní",
        "dolů",
        "doma",
        "domácí",
        "domácnost",
        "domek",
        "dominantní",
        "dominovat",
        "domluvit",
        "domnívat",
        "domov",
        "domů",
        "donést",
        "donutit",
        "doopravdy",
        "dopad",
        "dopadnout",
        "dopis",
        "doplněk",
        "doplnit",
        "doplňovat",
        "dopoledne",
        "doporučení",
        "doporučit",
        "doporučovat",
        "doposud",
        "doprava",
        "dopravní",
        "doprovázet",
        "doprovod",
        "dopřát",
        "dopředu",
        "dopustit",
        "dorazit",
        "dosah",
        "dosáhnout",
        "dosahovat",
        "dosavadní",
        "dosažení",
        "doslova",
        "dospělý",
        "dospět",
        "dost",
        "dostat",
        "dostatečně",
        "dostatečný",
        "dostatek",
        "dostávat",
        "dostavit",
        "dostupný",
        "dosud",
        "dotace",
        "dotáhnout",
        "dotaz",
        "dotknout",
        "dotyčný",
        "dotýkat",
        "doufat",
        "dovednost",
        "dovést",
        "dovnitř",
        "dovolená",
        "dovolit",
        "dovolovat",
        "dozadu",
        "dozvědět",
        "DPH",
        "dráha",
        "drahý",
        "drak",
        "drama",
        "dramatický",
        "drát",
        "dres",
        "drobný",
        "droga",
        "drsný",
        "druh",
        "druhý",
        "družstvo",
        "držet",
        "dřevěný",
        "dřevina",
        "dřevo",
        "dřívější",
        "duben",
        "duel",
        "duch",
        "důchod",
        "duchovní",
        "důkaz",
        "důkladně",
        "důl",
        "důležitý",
        "dům",
        "důraz",
        "důsledek",
        "důstojník",
        "duše",
        "duševní",
        "dutina",
        "důvěra",
        "důvěřovat",
        "důvod",
        "dva",
        "dvacátý",
        "dvacet",
        "dvakrát",
        "dvanáct",
        "dveře",
        "dvojče",
        "dvojí",
        "dvojice",
        "dvůr",
        "dýchat",
        "dynamický",
        "efekt",
        "efektivní",
        "Egypt",
        "ekologický",
        "ekonom",
        "ekonomický",
        "ekonomika",
        "elegantní",
        "elektrárna",
        "elektrický",
        "elektron",
        "elektronický",
        "elektřina",
        "e-mail",
        "emise",
        "emoce",
        "energetický",
        "energetika",
        "energie",
        "éra",
        "estetický",
        "et",
        "etapa",
        "EU",
        "euro",
        "eurozóna",
        "evoluce",
        "Evropa",
        "evropský",
        "existence",
        "existovat",
        "existující",
        "experiment",
        "expert",
        "expozice",
        "externí",
        "extraliga",
        "extrémní",
        "Facebook",
        "fajn",
        "fakt",
        "faktor",
        "faktum",
        "fakulta",
        "falešný",
        "fanoušek",
        "fantastický",
        "fantazie",
        "farma",
        "fasáda",
        "favorit",
        "fáze",
        "fenomén",
        "festival",
        "fialový",
        "film",
        "filmový",
        "filozof",
        "filozofický",
        "filozofie",
        "filtr",
        "finále",
        "finance",
        "financování",
        "finančně",
        "finanční",
        "firemní",
        "firma",
        "fólie",
        "fond",
        "forma",
        "formální",
        "formát",
        "fórum",
        "fotbal",
        "fotbalista",
        "fotbalový",
        "fotka",
        "foto",
        "fotoaparát",
        "fotograf",
        "fotografie",
        "Francie",
        "Francouz",
        "francouzský",
        "frekvence",
        "fronta",
        "fungování",
        "fungovat",
        "funkce",
        "funkční",
        "fyzicky",
        "fyzický",
        "fyzika",
        "fyzikální",
        "galerie",
        "garáž",
        "gen",
        "generace",
        "generál",
        "generální",
        "genetický",
        "gesto",
        "globální",
        "gól",
        "gólman",
        "Google",
        "graf",
        "grafický",
        "granát",
        "gymnázium",
        "ha",
        "had",
        "hádat",
        "hájit",
        "hala",
        "Hana",
        "hasič",
        "Havel",
        "házet",
        "hejtman",
        "hele",
        "herec",
        "herecký",
        "herečka",
        "herní",
        "heslo",
        "hezky",
        "hezký",
        "historický",
        "historie",
        "historik",
        "historka",
        "hit",
        "hlad",
        "hladina",
        "hladit",
        "hladký",
        "hlas",
        "hlásit",
        "hlasitě",
        "hlasitý",
        "hlasování",
        "hlava",
        "hlavička",
        "hlavně",
        "hlavní",
        "hledání",
        "hledat",
        "hledět",
        "hledisko",
        "hlídat",
        "hlídka",
        "hlína",
        "hloubka",
        "hloupý",
        "hluboce",
        "hluboko",
        "hluboký",
        "hluk",
        "hmota",
        "hmotnost",
        "hmotný",
        "hmyz",
        "hnát",
        "hned",
        "hnědý",
        "hněv",
        "hnízdo",
        "hnout",
        "hnutí",
        "hod",
        "hodina",
        "hodinky",
        "hodit",
        "hodlat",
        "hodně",
        "hodnocení",
        "hodnota",
        "hodnotit",
        "hodný",
        "hoch",
        "hokej",
        "hokejista",
        "hokejový",
        "holčička",
        "holka",
        "holý",
        "honit",
        "Honza",
        "hora",
        "horizont",
        "horko",
        "horký",
        "horní",
        "hornina",
        "horský",
        "hořet",
        "hospoda",
        "hospodaření",
        "hospodářský",
        "hospodářství",
        "host",
        "hotel",
        "hotový",
        "houba",
        "hovor",
        "hovořit",
        "hra",
        "hrabě",
        "hráč",
        "hračka",
        "hrad",
        "hradba",
        "Hradec",
        "hrana",
        "hraní",
        "hranice",
        "hrát",
        "hrdina",
        "hrdlo",
        "hrdý",
        "hrnec",
        "hrnek",
        "hrob",
        "hromada",
        "hromadný",
        "hrozba",
        "hrozit",
        "hrozně",
        "hrozný",
        "hrubý",
        "hruď",
        "hrůza",
        "hřbet",
        "hřbitov",
        "hřích",
        "hřiště",
        "hubený",
        "hudba",
        "hudební",
        "hudebník",
        "hůl",
        "humor",
        "hustota",
        "hustý",
        "hvězda",
        "hvězdný",
        "hýbat",
        "hypotéza",
        "chalupa",
        "chaos",
        "chápat",
        "charakter",
        "charakteristický",
        "charakteristika",
        "charakterizovat",
        "chata",
        "chemický",
        "chlad",
        "chladný",
        "chlap",
        "chlapec",
        "chlapík",
        "chléb",
        "chod",
        "chodba",
        "chodit",
        "chodník",
        "choroba",
        "chov",
        "chování",
        "chovat",
        "chrám",
        "chráněný",
        "chránit",
        "chtít",
        "chudák",
        "chudý",
        "chuť",
        "chutnat",
        "chůze",
        "chvět",
        "chvíle",
        "chvilka",
        "chyba",
        "chybět",
        "chybit",
        "chystat",
        "chytat",
        "chytit",
        "chytnout",
        "chytrý",
        "i",
        "idea",
        "ideál",
        "ideální",
        "identifikovat",
        "identita",
        "ignorovat",
        "ihned",
        "ikona",
        "iluze",
        "impuls",
        "in",
        "index",
        "indický",
        "Indie",
        "individuální",
        "infekce",
        "informace",
        "informační",
        "informovat",
        "infrastruktura",
        "Ing",
        "iniciativa",
        "inovace",
        "inscenace",
        "inspektor",
        "inspirace",
        "inspirovat",
        "instalace",
        "instituce",
        "institut",
        "integrace",
        "integrovaný",
        "inteligence",
        "inteligentní",
        "intenzita",
        "intenzivně",
        "intenzívní",
        "interakce",
        "interiér",
        "internet",
        "internetový",
        "interpretace",
        "interval",
        "investice",
        "investiční",
        "investor",
        "investovat",
        "inženýr",
        "IT",
        "Itálie",
        "italský",
        "izolace",
        "Izrael",
        "já",
        "jablko",
        "Jablonec",
        "jaderný",
        "jádro",
        "jak",
        "jakkoli",
        "jakmile",
        "jako",
        "jakoby",
        "jaksi",
        "Jakub",
        "jaký",
        "jakýkoli",
        "jakýsi",
        "jáma",
        "Japonsko",
        "japonský",
        "jarní",
        "jaro",
        "Jaromír",
        "Jaroslav",
        "jasně",
        "jasno",
        "jasný",
        "jazyk",
        "jazykový",
        "jed",
        "jeden",
        "jedenáct",
        "jedině",
        "jedinec",
        "jedinečný",
        "jediný",
        "jednak",
        "jednání",
        "jednat",
        "jednička",
        "jednoduchý",
        "jednoduše",
        "jednota",
        "jednotka",
        "jednotlivec",
        "jednotlivý",
        "jednotný",
        "jednou",
        "jednoznačně",
        "jednoznačný",
        "jeho",
        "její",
        "jejich",
        "jelikož",
        "jemně",
        "jemný",
        "jen",
        "jenom",
        "jenomže",
        "jenž",
        "jenže",
        "jeskyně",
        "jestli",
        "jestliže",
        "ještě",
        "jet",
        "jev",
        "jeviště",
        "jevit",
        "jezdec",
        "jezdit",
        "jezero",
        "Ježíš",
        "jídelna",
        "jídlo",
        "jih",
        "Jihlava",
        "jihočeský",
        "jinak",
        "jinam",
        "jinde",
        "jindy",
        "jiný",
        "jíst",
        "jistě",
        "jistota",
        "jistý",
        "jít",
        "jízda",
        "jízdní",
        "již",
        "jižní",
        "jméno",
        "jmenovaný",
        "jmenovat",
        "jo",
        "John",
        "k",
        "kabát",
        "kabel",
        "kabelka",
        "kabina",
        "kafe",
        "kalendář",
        "kalhoty",
        "kam",
        "kamarád",
        "kamarádka",
        "kámen",
        "kamenný",
        "kamera",
        "kamna",
        "kampaň",
        "Kanada",
        "kanál",
        "kancelář",
        "kandidát",
        "kapacita",
        "kapela",
        "kapitál",
        "kapitán",
        "kapitola",
        "kapka",
        "kaple",
        "kapsa",
        "kariéra",
        "karlovarský",
        "Karlův",
        "karta",
        "katastrofa",
        "kategorie",
        "Kateřina",
        "katolický",
        "kauza",
        "káva",
        "kavárna",
        "každodenní",
        "každopádně",
        "každoročně",
        "každý",
        "Kč",
        "kde",
        "kdepak",
        "kdesi",
        "kdo",
        "kdokoli",
        "kdosi",
        "kdy",
        "kdyby",
        "kdykoli",
        "kdysi",
        "když",
        "keř",
        "kg",
        "kilo",
        "kilogram",
        "kilometr",
        "kino",
        "Kladno",
        "kladný",
        "klasický",
        "klást",
        "klášter",
        "klávesnice",
        "klavír",
        "klec",
        "klepnout",
        "klesat",
        "klesnout",
        "klíč",
        "klíčový",
        "klid",
        "klidně",
        "klidný",
        "klient",
        "klika",
        "klima",
        "klín",
        "klinika",
        "klobouk",
        "kloub",
        "klub",
        "kluk",
        "km",
        "kmen",
        "kněz",
        "kniha",
        "knihovna",
        "kníže",
        "knížka",
        "koalice",
        "koberec",
        "kočka",
        "kód",
        "koláč",
        "kolečko",
        "kolega",
        "kolegyně",
        "kolej",
        "kolekce",
        "kolektivní",
        "kolem",
        "koleno",
        "kolik",
        "kolo",
        "kombinace",
        "kombinovat",
        "komedie",
        "komentář",
        "komentovat",
        "komerční",
        "komín",
        "komisař",
        "komise",
        "komora",
        "kompetence",
        "kompletní",
        "komplex",
        "komplexní",
        "komplikace",
        "komplikovaný",
        "komunální",
        "komunikace",
        "komunikační",
        "komunikovat",
        "komunista",
        "komunistický",
        "komunita",
        "konat",
        "koncentrace",
        "koncepce",
        "koncept",
        "koncert",
        "končetina",
        "končit",
        "konec",
        "koneckonců",
        "konečně",
        "konečný",
        "konference",
        "konflikt",
        "konkrétně",
        "konkrétní",
        "konkurence",
        "konkurenční",
        "konstatovat",
        "konstrukce",
        "kontakt",
        "kontext",
        "kontinent",
        "konto",
        "kontrola",
        "kontrolní",
        "kontrolovat",
        "konzervativní",
        "kopat",
        "kopec",
        "kopie",
        "koruna",
        "korupce",
        "kořen",
        "kořist",
        "kosmický",
        "kost",
        "kostel",
        "kostka",
        "kostým",
        "koš",
        "košile",
        "kotel",
        "kotník",
        "kouč",
        "koukat",
        "koule",
        "koupě",
        "koupelna",
        "koupit",
        "kouř",
        "kouřit",
        "kousek",
        "kout",
        "koutek",
        "kouzelný",
        "kouzlo",
        "kov",
        "kovový",
        "koza",
        "kožený",
        "krabice",
        "krabička",
        "kráčet",
        "krádež",
        "kraj",
        "krajina",
        "krajský",
        "král",
        "Králové",
        "královna",
        "královský",
        "království",
        "krása",
        "krásně",
        "krásný",
        "krást",
        "krátce",
        "krátký",
        "kráva",
        "krb",
        "krém",
        "kresba",
        "krev",
        "krevní",
        "Kristus",
        "kritérium",
        "kritický",
        "kritik",
        "kritika",
        "kritizovat",
        "krize",
        "krk",
        "krok",
        "kromě",
        "kroutit",
        "kroužek",
        "kruh",
        "kruhový",
        "krutý",
        "krvavý",
        "krystal",
        "kryt",
        "křehký",
        "křeslo",
        "křesťanský",
        "křičet",
        "křídlo",
        "křik",
        "křivka",
        "kříž",
        "křižovatka",
        "který",
        "kterýkoli",
        "kufr",
        "kuchyně",
        "kuchyňský",
        "kulatý",
        "kultura",
        "kulturní",
        "kůň",
        "kupovat",
        "kůra",
        "kurs",
        "kuře",
        "kus",
        "kůže",
        "kvalifikace",
        "kvalita",
        "kvalitní",
        "květ",
        "květen",
        "květina",
        "kvůli",
        "kyselina",
        "kyslík",
        "kývnout",
        "Labe",
        "laboratoř",
        "lahev",
        "láhev",
        "lákat",
        "lámat",
        "lampa",
        "lano",
        "láska",
        "laskavý",
        "látka",
        "lavice",
        "lavička",
        "lázně",
        "lebka",
        "léčba",
        "léčit",
        "led",
        "leden",
        "ledový",
        "legální",
        "legenda",
        "legendární",
        "legislativa",
        "legrace",
        "lehce",
        "lehký",
        "lehnout",
        "lék",
        "lékař",
        "lékařský",
        "Leonardo",
        "les",
        "lesklý",
        "lesní",
        "let",
        "letadlo",
        "létat",
        "letecký",
        "letět",
        "letiště",
        "letní",
        "léto",
        "letos",
        "letošní",
        "letoun",
        "lev",
        "levný",
        "levý",
        "lézt",
        "lež",
        "ležet",
        "ležící",
        "lhát",
        "lhůta",
        "li",
        "líbat",
        "Liberec",
        "liberecký",
        "líbit",
        "libovolný",
        "libra",
        "licence",
        "líčit",
        "lid",
        "lidový",
        "lídr",
        "lidský",
        "lidstvo",
        "liga",
        "likvidace",
        "limit",
        "lineární",
        "linie",
        "linka",
        "list",
        "lístek",
        "listí",
        "listina",
        "listopad",
        "lišit",
        "literární",
        "literatura",
        "líto",
        "litovat",
        "litr",
        "loď",
        "logicky",
        "logický",
        "logika",
        "lokalita",
        "lokální",
        "loket",
        "lom",
        "Londýn",
        "londýnský",
        "loňský",
        "louka",
        "lov",
        "lovec",
        "ložisko",
        "ložnice",
        "luxusní",
        "lůžko",
        "lze",
        "lžíce",
        "lžička",
        "m",
        "Maďarsko",
        "maďarský",
        "magický",
        "magistrát",
        "magnetický",
        "majetek",
        "majitel",
        "malba",
        "málem",
        "maličký",
        "malíř",
        "málo",
        "málokdo",
        "malovat",
        "malý",
        "máma",
        "maminka",
        "management",
        "manažer",
        "manipulace",
        "manžel",
        "manželka",
        "manželský",
        "manželství",
        "mapa",
        "marně",
        "masivní",
        "maska",
        "máslo",
        "maso",
        "masový",
        "matčin",
        "matematický",
        "matematika",
        "materiál",
        "mateřský",
        "matka",
        "mávat",
        "mávnout",
        "maximálně",
        "maximální",
        "maximum",
        "meč",
        "med",
        "medaile",
        "mediální",
        "medicína",
        "médium",
        "medvěd",
        "mechanický",
        "mechanismus",
        "měkký",
        "melodie",
        "měna",
        "méně",
        "měnit",
        "menu",
        "měření",
        "měřit",
        "měřítko",
        "měsíc",
        "měsíčně",
        "měsíční",
        "městečko",
        "město",
        "městský",
        "metoda",
        "metr",
        "metro",
        "metropole",
        "mez",
        "mezera",
        "mezi",
        "mezinárodní",
        "mezitím",
        "Microsoft",
        "míč",
        "míjet",
        "mil",
        "miláček",
        "milenec",
        "milenka",
        "miliarda",
        "milimetr",
        "milión",
        "milost",
        "milostný",
        "milovaný",
        "milovat",
        "milovník",
        "milý",
        "miminko",
        "mimo",
        "mimochodem",
        "mimořádně",
        "mimořádný",
        "mince",
        "minerál",
        "minerální",
        "minimálně",
        "minimální",
        "minimum",
        "ministerstvo",
        "ministr",
        "mínit",
        "minout",
        "minulost",
        "minulý",
        "minuta",
        "mír",
        "míra",
        "mírně",
        "mírný",
        "mířit",
        "mísa",
        "mise",
        "miska",
        "místní",
        "místnost",
        "místo",
        "místopředseda",
        "mistr",
        "mistrovství",
        "místy",
        "mít",
        "mívat",
        "mizet",
        "ml",
        "mládě",
        "mládež",
        "mládí",
        "mladík",
        "mladý",
        "mlčení",
        "mlčet",
        "mlčky",
        "mléčný",
        "mléko",
        "mlha",
        "mluvčí",
        "mluvit",
        "mlýn",
        "mnich",
        "mnohdy",
        "mnohem",
        "mnoho",
        "mnohokrát",
        "mnohý",
        "množství",
        "mobil",
        "mobilní",
        "moc",
        "moci",
        "mocný",
        "móda",
        "model",
        "modelka",
        "moderní",
        "modernizace",
        "modlit",
        "modlitba",
        "módní",
        "modrý",
        "modul",
        "mohutný",
        "mokrý",
        "molekula",
        "moment",
        "momentálně",
        "monitor",
        "morální",
        "Morava",
        "moravský",
        "moře",
        "mořský",
        "Moskva",
        "most",
        "motiv",
        "motivace",
        "motor",
        "motýl",
        "moudrý",
        "mouka",
        "mozek",
        "mozkový",
        "možná",
        "možnost",
        "možný",
        "mrak",
        "mráz",
        "mrtvola",
        "mrtvý",
        "mrzet",
        "mříž",
        "mše",
        "můj",
        "muset",
        "muzeum",
        "muzika",
        "muzikant",
        "muž",
        "mužský",
        "mužstvo",
        "my",
        "mýlit",
        "mysl",
        "myslet",
        "myš",
        "myšlení",
        "myšlenka",
        "mýtus",
        "mzda",
        "na",
        "nabídka",
        "nabídnout",
        "nabitý",
        "nabízet",
        "náboj",
        "náboženský",
        "náboženství",
        "nabrat",
        "nábytek",
        "náčelník",
        "nad",
        "nadace",
        "nadále",
        "nadávat",
        "nadechnout",
        "naděje",
        "nádherný",
        "nadchnout",
        "nádoba",
        "nádobí",
        "nádraží",
        "nádrž",
        "nadšení",
        "nadšený",
        "nahlas",
        "náhle",
        "nahlédnout",
        "náhlý",
        "náhoda",
        "náhodný",
        "náhodou",
        "nahoru",
        "nahoře",
        "náhrada",
        "nahradit",
        "náhradní",
        "nahrávka",
        "nahý",
        "nacházet",
        "najednou",
        "najevo",
        "najít",
        "náklad",
        "nakladatelství",
        "nákladní",
        "naklonit",
        "nakonec",
        "nakoupit",
        "nákup",
        "nákupní",
        "nakupovat",
        "nálada",
        "nález",
        "nalézt",
        "náležet",
        "nalít",
        "naložit",
        "námaha",
        "náměstek",
        "náměstí",
        "namísto",
        "namítnout",
        "nanejvýš",
        "naopak",
        "nápad",
        "napadat",
        "nápadně",
        "napadnout",
        "nápadný",
        "napětí",
        "nápis",
        "napít",
        "náplň",
        "naplnit",
        "naplno",
        "nápoj",
        "naposledy",
        "náprava",
        "naprosto",
        "naprostý",
        "naproti",
        "napřed",
        "napříč",
        "například",
        "napsat",
        "napůl",
        "narazit",
        "narážet",
        "náročný",
        "národ",
        "narodit",
        "národní",
        "nárok",
        "narození",
        "narozeniny",
        "náruč",
        "náručí",
        "nárůst",
        "narušit",
        "nařídit",
        "nařízení",
        "nasadit",
        "nasazení",
        "násilí",
        "náskok",
        "následek",
        "následně",
        "následný",
        "následovat",
        "následující",
        "naslouchat",
        "nastat",
        "nastavení",
        "nastavit",
        "nastoupit",
        "nástroj",
        "nástup",
        "nastupovat",
        "náš",
        "naštěstí",
        "natáčení",
        "natáčet",
        "natáhnout",
        "nato",
        "natočit",
        "natolik",
        "naučit",
        "navázat",
        "navazovat",
        "navíc",
        "návod",
        "návrat",
        "návrh",
        "navrhnout",
        "navrhovat",
        "návštěva",
        "návštěvník",
        "navštěvovat",
        "navštívit",
        "navzájem",
        "navzdory",
        "navždy",
        "název",
        "naznačit",
        "naznačovat",
        "náznak",
        "názor",
        "nazvaný",
        "nazvat",
        "nazývat",
        "ne",
        "nebe",
        "nebezpečí",
        "nebo",
        "neboli",
        "neboť",
        "něco",
        "nečekaně",
        "nečekaný",
        "nedaleko",
        "nedávno",
        "neděle",
        "nedělní",
        "nedostatek",
        "negativní",
        "nehet",
        "nehoda",
        "nechat",
        "nechávat",
        "nějak",
        "nějaký",
        "nejen",
        "nejenom",
        "nejenže",
        "nejistota",
        "nejprve",
        "někam",
        "někde",
        "někdejší",
        "někdo",
        "někdy",
        "několik",
        "několikrát",
        "některý",
        "Němec",
        "Německo",
        "německý",
        "nemoc",
        "nemocnice",
        "nemocný",
        "nemovitost",
        "nenávidět",
        "nenávist",
        "nepatrný",
        "nepochybně",
        "nepřátelský",
        "nepříliš",
        "nepřítel",
        "nerv",
        "nervový",
        "nervózní",
        "nesmírně",
        "nesmysl",
        "nést",
        "neštěstí",
        "neustále",
        "neustálý",
        "neuvěřitelný",
        "nevinný",
        "nevýhoda",
        "new",
        "nezaměstnanost",
        "nezávislost",
        "nezbytný",
        "než",
        "NHL",
        "nic",
        "nicméně",
        "ničit",
        "nijak",
        "nikam",
        "nikde",
        "nikdo",
        "nikdy",
        "nikoli",
        "nitro",
        "nízko",
        "nízký",
        "no",
        "noc",
        "noční",
        "noha",
        "norma",
        "normálně",
        "normální",
        "nos",
        "nosit",
        "nositel",
        "nosný",
        "notebook",
        "nouze",
        "nováček",
        "nově",
        "novela",
        "novinář",
        "novinka",
        "noviny",
        "nový",
        "nula",
        "nulový",
        "nutit",
        "nutně",
        "nutnost",
        "nutný",
        "nůž",
        "nýbrž",
        "Nymburk",
        "nyní",
        "o",
        "oba",
        "obal",
        "obálka",
        "obava",
        "obávat",
        "občan",
        "občanský",
        "občas",
        "obdivovat",
        "období",
        "obdobný",
        "obdržet",
        "obec",
        "obecně",
        "obecní",
        "obecný",
        "oběd",
        "obejít",
        "obejmout",
        "oběť",
        "obchod",
        "obchodní",
        "obchodník",
        "objednat",
        "objekt",
        "objektivní",
        "objem",
        "objev",
        "objevit",
        "objevovat",
        "oblak",
        "oblast",
        "oblečení",
        "oblečený",
        "oblek",
        "obléknout",
        "obliba",
        "oblíbený",
        "obličej",
        "obloha",
        "oblouk",
        "obnova",
        "obnovit",
        "obočí",
        "obojí",
        "obor",
        "obr",
        "obracet",
        "obrana",
        "obránce",
        "obrat",
        "obrátit",
        "obraz",
        "obrázek",
        "obrazovka",
        "obrovský",
        "obřad",
        "obří",
        "obsadit",
        "obsah",
        "obsahovat",
        "obsahující",
        "obsluha",
        "obtěžovat",
        "obtíž",
        "obtížně",
        "obtížný",
        "obvinění",
        "obvinit",
        "obvod",
        "obvykle",
        "obvyklý",
        "obyčejně",
        "obyčejný",
        "obytný",
        "obývací",
        "obývák",
        "obyvatel",
        "obyvatelstvo",
        "obzor",
        "obzvlášť",
        "ocas",
        "oceán",
        "ocel",
        "ocelový",
        "ocenění",
        "ocenit",
        "ocitnout",
        "očekávání",
        "očekávaný",
        "očekávat",
        "očividně",
        "oční",
        "od",
        "odbor",
        "odborník",
        "odborný",
        "oddělení",
        "oddělit",
        "oddíl",
        "odebrat",
        "odehrát",
        "odehrávat",
        "odejít",
        "oděv",
        "odhad",
        "odhadnout",
        "odhadovat",
        "odhalit",
        "odcházet",
        "odchod",
        "odjet",
        "odjezd",
        "odjíždět",
        "odkaz",
        "odkud",
        "odlišný",
        "odložit",
        "odměna",
        "odmítat",
        "odmítnout",
        "odmlčet",
        "odnést",
        "odolnost",
        "odolný",
        "odpad",
        "odpočinek",
        "odpočinout",
        "odpočívat",
        "odpoledne",
        "odpor",
        "odpověď",
        "odpovědět",
        "odpovědnost",
        "odpovědný",
        "odpovídající",
        "odpovídat",
        "odpustit",
        "odraz",
        "odrážet",
        "odrůda",
        "ODS",
        "odsoudit",
        "odst",
        "odstartovat",
        "odstín",
        "odstranění",
        "odstranit",
        "odstup",
        "odsud",
        "odtáhnout",
        "odtud",
        "odvaha",
        "odvážit",
        "odvážný",
        "odvést",
        "odvětit",
        "odvětví",
        "odvézt",
        "odvolání",
        "odvolat",
        "odvrátit",
        "of",
        "oficiálně",
        "oficiální",
        "oheň",
        "ohlásit",
        "ohled",
        "ohledně",
        "ohlédnout",
        "ohromný",
        "ohrozit",
        "ohrožení",
        "ohrožený",
        "ohrožovat",
        "ochotně",
        "ochotný",
        "ochrana",
        "ochránit",
        "ochranný",
        "okamžik",
        "okamžitě",
        "okamžitý",
        "okénko",
        "okno",
        "oko",
        "okolí",
        "okolní",
        "okolnost",
        "okolo",
        "okraj",
        "okres",
        "okresní",
        "okruh",
        "olej",
        "Olomouc",
        "olomoucký",
        "oltář",
        "olympiáda",
        "olympijský",
        "omáčka",
        "omezení",
        "omezený",
        "omezit",
        "omezovat",
        "omlouvat",
        "omluvit",
        "omyl",
        "on",
        "onemocnění",
        "onen",
        "oni",
        "opačný",
        "opak",
        "opakovaně",
        "opakovaný",
        "opakovat",
        "opatrně",
        "opatrný",
        "opatření",
        "opatřit",
        "opera",
        "operace",
        "operační",
        "operátor",
        "opět",
        "opilý",
        "opírat",
        "opora",
        "opouštět",
        "opozice",
        "oprava",
        "opravdový",
        "opravdu",
        "opravit",
        "oprávněný",
        "oproti",
        "opřít",
        "optický",
        "optimální",
        "opustit",
        "opuštěný",
        "oranžový",
        "ordinace",
        "orgán",
        "organický",
        "organismus",
        "organizace",
        "organizační",
        "organizátor",
        "organizovaný",
        "organizovat",
        "orchestr",
        "orientace",
        "orientovat",
        "originál",
        "originální",
        "osa",
        "osada",
        "osamělý",
        "oslava",
        "oslavit",
        "oslovit",
        "osm",
        "osmdesát",
        "osmdesátý",
        "osmnáct",
        "osmý",
        "osoba",
        "osobně",
        "osobní",
        "osobnost",
        "ostatně",
        "ostatní",
        "Ostrava",
        "ostravský",
        "ostrov",
        "ostrý",
        "ostře",
        "osud",
        "osvětlení",
        "ošklivý",
        "otáčet",
        "otázka",
        "otcův",
        "otec",
        "otevírat",
        "otevřeně",
        "otevření",
        "otevřený",
        "otevřít",
        "otisk",
        "otočit",
        "otřást",
        "otřít",
        "otvírat",
        "otvor",
        "ovce",
        "Ove",
        "ověřit",
        "ovládání",
        "ovládat",
        "ovládnout",
        "ovlivnit",
        "ovlivňovat",
        "ovoce",
        "ovocný",
        "ovšem",
        "oxid",
        "označení",
        "označit",
        "označovat",
        "oznámení",
        "oznámit",
        "ozvat",
        "ozývat",
        "oženit",
        "pacient",
        "pád",
        "padat",
        "padesát",
        "padesátý",
        "padnout",
        "pach",
        "pachatel",
        "pak",
        "palác",
        "palec",
        "pálit",
        "palivo",
        "paluba",
        "památka",
        "pamatovat",
        "paměť",
        "pan",
        "pán",
        "panel",
        "panenka",
        "pánev",
        "paní",
        "panika",
        "panna",
        "panovat",
        "papež",
        "papír",
        "papírový",
        "paprsek",
        "pár",
        "pára",
        "parametr",
        "Pardubice",
        "pardubický",
        "park",
        "parkoviště",
        "parlament",
        "parlamentní",
        "parta",
        "partie",
        "partner",
        "Paříž",
        "pas",
        "pás",
        "pasivní",
        "páska",
        "pásmo",
        "past",
        "pata",
        "pátek",
        "patnáct",
        "pátrat",
        "patrně",
        "patrný",
        "patro",
        "patřit",
        "pátý",
        "pauza",
        "paže",
        "péci",
        "péče",
        "pečlivě",
        "pečovat",
        "pedagog",
        "pedagogický",
        "peklo",
        "pěkně",
        "pěkný",
        "pěna",
        "peněženka",
        "peníze",
        "pepř",
        "pero",
        "personál",
        "perspektiva",
        "pes",
        "pěst",
        "pěstování",
        "pěstovat",
        "pestrý",
        "pěšky",
        "pět",
        "Petr",
        "pevně",
        "pevnost",
        "pevný",
        "pilíř",
        "pilot",
        "písek",
        "písemný",
        "píseň",
        "pískovec",
        "písmeno",
        "písmo",
        "písnička",
        "pistole",
        "pít",
        "pití",
        "pivo",
        "pivovar",
        "placený",
        "pláč",
        "plakat",
        "plamen",
        "plán",
        "planeta",
        "plánování",
        "plánovaný",
        "plánovat",
        "plast",
        "plastový",
        "plášť",
        "plat",
        "platba",
        "plátek",
        "platforma",
        "platit",
        "plátno",
        "platnost",
        "platný",
        "plavat",
        "play",
        "pláž",
        "plech",
        "plést",
        "pleť",
        "plíce",
        "plně",
        "plnění",
        "plnit",
        "plný",
        "plod",
        "plocha",
        "plochý",
        "plošina",
        "plot",
        "plukovník",
        "plus",
        "plyn",
        "plynout",
        "plynový",
        "Plzeň",
        "plzeňský",
        "pneumatika",
        "po",
        "poblíž",
        "pobočka",
        "pobřeží",
        "pobyt",
        "pocit",
        "pocítit",
        "pociťovat",
        "počasí",
        "počáteční",
        "počátek",
        "počet",
        "početný",
        "počítač",
        "počítačový",
        "počítat",
        "počkat",
        "pod",
        "podání",
        "podařit",
        "podat",
        "podávat",
        "poděkovat",
        "podél",
        "podepsat",
        "podezřelý",
        "podezření",
        "podíl",
        "podílet",
        "pódium",
        "podívat",
        "podivný",
        "podklad",
        "podlaha",
        "podle",
        "podléhat",
        "podlehnout",
        "podmínka",
        "podnět",
        "podnik",
        "podnikání",
        "podnikat",
        "podnikatel",
        "podnikatelský",
        "podoba",
        "podobat",
        "podobně",
        "podobný",
        "podotknout",
        "podpis",
        "podpora",
        "podporovat",
        "podpořit",
        "podrobně",
        "podrobnost",
        "podrobný",
        "podruhé",
        "podstata",
        "podstatně",
        "podstatný",
        "podvod",
        "podzemní",
        "podzim",
        "podzimní",
        "poezie",
        "pohádka",
        "pohár",
        "pohladit",
        "pohlaví",
        "pohled",
        "pohlédnout",
        "pohnout",
        "pohoda",
        "pohodlně",
        "pohodlný",
        "pohon",
        "pohovka",
        "pohřeb",
        "pohyb",
        "pohybovat",
        "pohybový",
        "pocházet",
        "pochod",
        "pochopení",
        "pochopit",
        "pochopitelně",
        "pochopitelný",
        "pochyba",
        "pochybnost",
        "pochybovat",
        "pojem",
        "pojetí",
        "pojištění",
        "pojišťovna",
        "pojmenovat",
        "pokaždé",
        "poklad",
        "pokládat",
        "pokles",
        "pokoj",
        "pokoušet",
        "pokožka",
        "pokračování",
        "pokračovat",
        "pokrčit",
        "pokročilý",
        "pokrok",
        "pokrýt",
        "pokrytý",
        "pokrývat",
        "pokud",
        "pokus",
        "pokusit",
        "pokuta",
        "pokyn",
        "Polák",
        "pole",
        "poledne",
        "polévka",
        "polibek",
        "políbit",
        "police",
        "policejní",
        "policie",
        "policista",
        "politický",
        "politik",
        "politika",
        "polní",
        "poločas",
        "poloha",
        "polovina",
        "položený",
        "položit",
        "položka",
        "Polsko",
        "polský",
        "polštář",
        "pomáhat",
        "pomalu",
        "pomalý",
        "poměr",
        "poměrně",
        "poměry",
        "pomoc",
        "pomoci",
        "pomocí",
        "pomocník",
        "pomůcka",
        "pomyslet",
        "pondělí",
        "ponechat",
        "poněkud",
        "poněvadž",
        "ponořit",
        "popadnout",
        "popel",
        "popis",
        "popisovat",
        "poplatek",
        "poprvé",
        "popsaný",
        "popsat",
        "poptávka",
        "populace",
        "populární",
        "poradce",
        "poradit",
        "porazit",
        "porážka",
        "porce",
        "porod",
        "porost",
        "porovnání",
        "porozumět",
        "portál",
        "portrét",
        "porucha",
        "porušení",
        "pořad",
        "pořád",
        "pořádat",
        "pořadatel",
        "pořádek",
        "pořadí",
        "pořádně",
        "pořádný",
        "pořídit",
        "posadit",
        "posádka",
        "posílat",
        "posílit",
        "posilovat",
        "poskytnout",
        "poskytovat",
        "poslanec",
        "poslanecký",
        "poslání",
        "poslat",
        "poslední",
        "poslechnout",
        "posléze",
        "poslouchat",
        "posloužit",
        "posluchač",
        "posoudit",
        "post",
        "postarat",
        "postava",
        "postavení",
        "postavený",
        "postavit",
        "postel",
        "postihnout",
        "postižení",
        "postižený",
        "postoj",
        "postoupit",
        "postrádat",
        "postup",
        "postupně",
        "postupný",
        "postupovat",
        "posun",
        "posunout",
        "posvátný",
        "poškodit",
        "poškození",
        "poškozený",
        "pošta",
        "pot",
        "poté",
        "potenciál",
        "potenciální",
        "potěšení",
        "potěšit",
        "potíž",
        "potkat",
        "potlačit",
        "potok",
        "potom",
        "potomek",
        "potrava",
        "potravina",
        "potrestat",
        "potřeba",
        "potřebný",
        "potřebovat",
        "potvrdit",
        "potvrzovat",
        "pouhý",
        "poušť",
        "pouštět",
        "pouť",
        "pouto",
        "pouzdro",
        "pouze",
        "použít",
        "použití",
        "použitý",
        "používání",
        "používaný",
        "používat",
        "povaha",
        "považovat",
        "povědět",
        "povést",
        "pověst",
        "povídat",
        "povídka",
        "povinnost",
        "povinný",
        "povodeň",
        "povolání",
        "povolení",
        "povolit",
        "povrch",
        "povrchový",
        "povzdechnout",
        "pozadí",
        "pozdě",
        "pozdní",
        "pozdrav",
        "pozdravit",
        "pozemek",
        "pozice",
        "pozitivní",
        "poznamenat",
        "poznámka",
        "poznání",
        "poznat",
        "poznatek",
        "poznávat",
        "pozor",
        "pozorně",
        "pozornost",
        "pozorování",
        "pozorovat",
        "pozoruhodný",
        "pozvat",
        "požádat",
        "požadavek",
        "požadovaný",
        "požadovat",
        "požár",
        "práce",
        "pracovat",
        "pracoviště",
        "pracovna",
        "pracovní",
        "pracovník",
        "pracující",
        "prádlo",
        "práh",
        "Praha",
        "prach",
        "prakticky",
        "praktický",
        "pramen",
        "prase",
        "prášek",
        "prát",
        "pravda",
        "pravděpodobně",
        "pravděpodobnost",
        "pravděpodobný",
        "pravdivý",
        "právě",
        "pravidelně",
        "pravidelný",
        "pravidlo",
        "pravit",
        "právní",
        "právnický",
        "právník",
        "právo",
        "pravomoc",
        "pravý",
        "praxe",
        "prázdniny",
        "prázdný",
        "pražský",
        "prdel",
        "premiér",
        "premiéra",
        "prestižní",
        "prevence",
        "prezentace",
        "prezentovat",
        "prezident",
        "prezidentský",
        "primární",
        "primátor",
        "princ",
        "princezna",
        "princip",
        "priorita",
        "prkno",
        "pro",
        "proběhnout",
        "probíhat",
        "probírat",
        "problém",
        "problematický",
        "problematika",
        "proboha",
        "probrat",
        "probudit",
        "procento",
        "proces",
        "procesor",
        "proč",
        "prodat",
        "prodávat",
        "prodej",
        "prodejce",
        "prodejna",
        "prodloužení",
        "prodloužit",
        "producent",
        "produkce",
        "produkovat",
        "produkt",
        "profese",
        "profesionální",
        "profesní",
        "profesor",
        "profil",
        "program",
        "prohlásit",
        "prohlášení",
        "prohlédnout",
        "prohlídka",
        "prohlížet",
        "prohodit",
        "prohrát",
        "procházet",
        "procházka",
        "projekt",
        "projektový",
        "projet",
        "projev",
        "projevit",
        "projevovat",
        "projít",
        "projíždět",
        "prokázat",
        "proměna",
        "proměnit",
        "prominout",
        "promluvit",
        "pronásledovat",
        "pronést",
        "pronikat",
        "proniknout",
        "propadnout",
        "propast",
        "propojení",
        "propojit",
        "propustit",
        "prosadit",
        "prosazovat",
        "prosinec",
        "prosit",
        "proslulý",
        "prospěch",
        "prostě",
        "Prostějov",
        "prostor",
        "prostora",
        "prostorový",
        "prostředek",
        "prostředí",
        "prostřednictvím",
        "prostý",
        "protáhnout",
        "protein",
        "protest",
        "protestovat",
        "proti",
        "protivník",
        "proto",
        "protokol",
        "protože",
        "proud",
        "provádět",
        "provázet",
        "provedení",
        "provedený",
        "provést",
        "provoz",
        "provozní",
        "provozovat",
        "provozovatel",
        "prozatím",
        "prozradit",
        "prozrazovat",
        "prožít",
        "prožívat",
        "prsa",
        "prst",
        "prsten",
        "pršet",
        "průběh",
        "prudce",
        "prudký",
        "pruh",
        "průhledný",
        "průkaz",
        "průměr",
        "průměrný",
        "průmysl",
        "průmyslový",
        "průvod",
        "průvodce",
        "průzkum",
        "prvek",
        "první",
        "prvý",
        "prý",
        "pryč",
        "přání",
        "přát",
        "přátelský",
        "přátelství",
        "přece",
        "přečíst",
        "před",
        "předat",
        "předávat",
        "předek",
        "předem",
        "především",
        "předcházet",
        "předchozí",
        "předchůdce",
        "předložit",
        "předmět",
        "přednáška",
        "přední",
        "přednost",
        "předpis",
        "předpoklad",
        "předpokládat",
        "předseda",
        "představa",
        "představení",
        "představenstvo",
        "představit",
        "představitel",
        "představovat",
        "předstírat",
        "předtím",
        "předvádět",
        "předvést",
        "přehled",
        "přehledný",
        "přehlídka",
        "přehrávač",
        "přecházet",
        "přechod",
        "přejet",
        "přejít",
        "překážka",
        "překlad",
        "překonat",
        "překročit",
        "překvapení",
        "překvapit",
        "překvapivě",
        "překvapivý",
        "přelom",
        "přeložit",
        "přemýšlet",
        "přenášet",
        "přenést",
        "přenos",
        "přeprava",
        "přerušit",
        "přes",
        "přesně",
        "přesnost",
        "přesný",
        "přestat",
        "přestávat",
        "přestávka",
        "přestěhovat",
        "přesto",
        "přestože",
        "přesunout",
        "přesvědčení",
        "přesvědčený",
        "přesvědčit",
        "převážně",
        "převést",
        "převod",
        "převzít",
        "přežít",
        "při",
        "příběh",
        "přiblížit",
        "přibližně",
        "přibližovat",
        "příbuzný",
        "přibýt",
        "přibývat",
        "přičemž",
        "příčina",
        "příčka",
        "přidat",
        "přidávat",
        "přihlásit",
        "přihodit",
        "přicházet",
        "příchod",
        "přijatelný",
        "příjem",
        "příjemně",
        "příjemný",
        "přijet",
        "přijetí",
        "příjezd",
        "přijímat",
        "přijít",
        "přijmout",
        "příkaz",
        "příklad",
        "přikývnout",
        "příležitost",
        "příliš",
        "příloha",
        "přiložit",
        "přiměřený",
        "přimět",
        "přímo",
        "přímý",
        "přinášet",
        "přinejmenším",
        "přinést",
        "přínos",
        "přinutit",
        "případ",
        "připadat",
        "případně",
        "případný",
        "připojení",
        "připojit",
        "připomenout",
        "připomínající",
        "připomínat",
        "připouštět",
        "příprava",
        "přípravek",
        "připravený",
        "připravit",
        "připravovat",
        "připsat",
        "připustit",
        "příroda",
        "přírodní",
        "přirozeně",
        "přirozený",
        "příslušník",
        "příslušný",
        "přísně",
        "přísný",
        "přispět",
        "příspěvek",
        "přispívat",
        "přistát",
        "přístav",
        "přistoupit",
        "přístroj",
        "přístup",
        "přístupný",
        "přistupovat",
        "příšerný",
        "příště",
        "příští",
        "přitáhnout",
        "přitahovat",
        "přítel",
        "přítelkyně",
        "přitisknout",
        "přitom",
        "přítomnost",
        "přítomný",
        "přivést",
        "přivézt",
        "přivítat",
        "přízemí",
        "příznak",
        "přiznat",
        "přiznávat",
        "příznivec",
        "příznivý",
        "přizpůsobit",
        "psací",
        "psaní",
        "psaný",
        "psát",
        "psí",
        "psychický",
        "psycholog",
        "psychologický",
        "psychologie",
        "ptačí",
        "pták",
        "ptát",
        "publikace",
        "publikovat",
        "publikum",
        "půda",
        "půjčit",
        "půjčka",
        "půl",
        "půle",
        "půlka",
        "půlnoc",
        "pult",
        "pusa",
        "působení",
        "působící",
        "působit",
        "pustit",
        "puška",
        "putovat",
        "původ",
        "původně",
        "původní",
        "pyšný",
        "pytel",
        "rád",
        "rada",
        "radikální",
        "rádio",
        "radit",
        "radní",
        "radnice",
        "radost",
        "radovat",
        "ráj",
        "raketa",
        "rakev",
        "Rakousko",
        "rakouský",
        "rakovina",
        "rám",
        "rámec",
        "rameno",
        "rána",
        "ranní",
        "ráno",
        "raný",
        "ráz",
        "rázem",
        "reagovat",
        "reakce",
        "realita",
        "realizace",
        "realizovat",
        "reálný",
        "recept",
        "red",
        "redakce",
        "redaktor",
        "reforma",
        "region",
        "regionální",
        "regulace",
        "reklama",
        "reklamní",
        "rekonstrukce",
        "rekord",
        "relativně",
        "relativní",
        "reprezentace",
        "reprezentant",
        "reprezentovat",
        "republika",
        "resp",
        "respekt",
        "respektive",
        "respektovat",
        "respondent",
        "restaurace",
        "ret",
        "revoluce",
        "revoluční",
        "rezerva",
        "režie",
        "režim",
        "režisér",
        "riskovat",
        "rituál",
        "riziko",
        "rizikový",
        "robot",
        "ročně",
        "roční",
        "ročník",
        "rod",
        "rodič",
        "rodina",
        "rodinný",
        "rodit",
        "rodný",
        "roh",
        "rok",
        "role",
        "román",
        "romantický",
        "ropa",
        "rostlina",
        "rostlinný",
        "rostoucí",
        "rovina",
        "rovněž",
        "rovnice",
        "rovnou",
        "rovnováha",
        "rovný",
        "rozběhnout",
        "rozbít",
        "rozbitý",
        "rozdělení",
        "rozdělit",
        "rozdíl",
        "rozdílný",
        "rozesmát",
        "rozeznat",
        "rozhlas",
        "rozhlédnout",
        "rozhlížet",
        "rozhodčí",
        "rozhodně",
        "rozhodnout",
        "rozhodnutí",
        "rozhodování",
        "rozhodovat",
        "rozhodující",
        "rozhovor",
        "rozhraní",
        "rozjet",
        "rozkaz",
        "rozlehlý",
        "rozlišení",
        "rozlišovat",
        "rozloučit",
        "rozložit",
        "rozměr",
        "rozpaky",
        "rozpočet",
        "rozpor",
        "rozpoznat",
        "rozsah",
        "rozsáhlý",
        "rozsudek",
        "rozsvítit",
        "rozšíření",
        "rozšířený",
        "rozšířit",
        "rozšiřovat",
        "roztok",
        "rozum",
        "rozumět",
        "rozumný",
        "rozvíjet",
        "rozvod",
        "rozvoj",
        "ručně",
        "ruční",
        "rudý",
        "ruch",
        "ruka",
        "rukáv",
        "rukavice",
        "rukopis",
        "Rus",
        "Rusko",
        "ruský",
        "růst",
        "rušit",
        "různě",
        "různý",
        "růže",
        "růžový",
        "ryba",
        "rybník",
        "rychle",
        "rychlost",
        "rychlý",
        "rys",
        "rytíř",
        "rytmus",
        "rýže",
        "řád",
        "řada",
        "řádek",
        "řadit",
        "řádný",
        "řasa",
        "Řecko",
        "řecký",
        "řeč",
        "ředitel",
        "ředitelka",
        "řeka",
        "řemeslo",
        "řešení",
        "řešit",
        "řetěz",
        "řetězec",
        "řez",
        "říci",
        "řídicí",
        "řidič",
        "řídit",
        "říjen",
        "říkat",
        "Řím",
        "římský",
        "říše",
        "řízení",
        "řízený",
        "řvát",
        "s",
        "sáček",
        "sad",
        "sahat",
        "sáhnout",
        "sako",
        "sakra",
        "sál",
        "salát",
        "salón",
        "sám",
        "samec",
        "samostatně",
        "samostatný",
        "samota",
        "samotný",
        "samozřejmě",
        "samozřejmost",
        "Samsung",
        "samý",
        "sankce",
        "sazba",
        "sázet",
        "sběr",
        "sbírat",
        "sbírka",
        "sbor",
        "scéna",
        "scénář",
        "sdělení",
        "sdělit",
        "sdílet",
        "sdružení",
        "se",
        "sebevědomí",
        "sebevražda",
        "sebrat",
        "sedadlo",
        "sedět",
        "sedm",
        "sedmdesát",
        "sedmdesátý",
        "sedmnáct",
        "sedmý",
        "sednout",
        "segment",
        "sehnat",
        "sehrát",
        "sejít",
        "sekce",
        "sektor",
        "sekunda",
        "sekvence",
        "selhání",
        "sem",
        "semeno",
        "seminář",
        "sen",
        "senát",
        "senátor",
        "senior",
        "seriál",
        "série",
        "server",
        "servis",
        "sestava",
        "sestavit",
        "sestra",
        "setkání",
        "setkat",
        "setkávat",
        "sever",
        "severní",
        "sevřít",
        "sex",
        "sexuální",
        "seznam",
        "seznámit",
        "sezona",
        "sezóna",
        "sféra",
        "shánět",
        "shoda",
        "shodnout",
        "show",
        "shrnout",
        "shromáždění",
        "scházet",
        "schéma",
        "schod",
        "schodiště",
        "schopnost",
        "schopný",
        "schovat",
        "schovávat",
        "schránka",
        "schůzka",
        "schválit",
        "sice",
        "sídliště",
        "sídlit",
        "sídlo",
        "signál",
        "síla",
        "silně",
        "silnice",
        "silniční",
        "silný",
        "síň",
        "síť",
        "situace",
        "skákat",
        "skála",
        "skalní",
        "skandál",
        "sklad",
        "skládat",
        "skladatel",
        "skladba",
        "skleněný",
        "sklenice",
        "sklenička",
        "sklenka",
        "sklep",
        "sklo",
        "sklon",
        "sklonit",
        "skočit",
        "skok",
        "skončení",
        "skončit",
        "skoro",
        "skromný",
        "skrýt",
        "skrytý",
        "skrývat",
        "skrz",
        "skříň",
        "skříňka",
        "skupina",
        "skupinka",
        "skutečně",
        "skutečnost",
        "skutečný",
        "skvěle",
        "skvělý",
        "skvrna",
        "slabost",
        "slabý",
        "sladký",
        "sláva",
        "Slavia",
        "slavit",
        "slavnost",
        "slavnostní",
        "slavný",
        "slečna",
        "sledování",
        "sledovaný",
        "sledovat",
        "slepý",
        "sleva",
        "slib",
        "slíbit",
        "slibovat",
        "sloup",
        "sloužit",
        "Slovensko",
        "slovenský",
        "slovní",
        "slovník",
        "slovo",
        "složení",
        "složený",
        "složit",
        "složitý",
        "složka",
        "sluchátko",
        "slunce",
        "sluneční",
        "slušet",
        "slušný",
        "služba",
        "slyšet",
        "slza",
        "smát",
        "směr",
        "směřovat",
        "směs",
        "směšný",
        "smět",
        "smích",
        "smířit",
        "smíšený",
        "smlouva",
        "smrt",
        "smrtelný",
        "smůla",
        "smutek",
        "smutný",
        "smysl",
        "snad",
        "snadno",
        "snadný",
        "snaha",
        "snášet",
        "snažit",
        "sněhový",
        "sněmovna",
        "snést",
        "snídaně",
        "sníh",
        "snímek",
        "sníst",
        "snít",
        "snížení",
        "snížit",
        "snižovat",
        "sobota",
        "Sobotka",
        "sobotní",
        "socialistický",
        "sociální",
        "software",
        "socha",
        "solární",
        "sotva",
        "souboj",
        "soubor",
        "současně",
        "současnost",
        "současný",
        "součást",
        "soud",
        "soudce",
        "soudit",
        "soudní",
        "soudruh",
        "souhlas",
        "souhlasit",
        "soukromí",
        "soukromý",
        "soulad",
        "soupeř",
        "sourozenec",
        "soused",
        "sousední",
        "soustava",
        "soustředění",
        "soustředit",
        "soutěž",
        "související",
        "souviset",
        "souvislost",
        "sovětský",
        "spadat",
        "spadnout",
        "spáchat",
        "spánek",
        "Sparta",
        "spát",
        "spatřit",
        "specialista",
        "specializovaný",
        "speciálně",
        "speciální",
        "specifický",
        "spěchat",
        "spektrum",
        "spis",
        "spisovatel",
        "spíš",
        "spíše",
        "splnit",
        "splňovat",
        "spočítat",
        "spočívat",
        "spodní",
        "spoj",
        "spojenec",
        "spojení",
        "spojený",
        "spojit",
        "spojovat",
        "spokojeně",
        "spokojenost",
        "spokojený",
        "společenský",
        "společenství",
        "společně",
        "společník",
        "společnost",
        "společný",
        "spoléhat",
        "spolehlivý",
        "spolek",
        "spolu",
        "spolupráce",
        "spolupracovat",
        "spolupracovník",
        "spolužák",
        "spor",
        "sport",
        "sportovec",
        "sportovní",
        "spotřeba",
        "spotřebitel",
        "spousta",
        "správa",
        "správce",
        "spravedlivý",
        "spravedlnost",
        "správně",
        "správní",
        "správný",
        "sprcha",
        "spustit",
        "srazit",
        "srážka",
        "srdce",
        "srdeční",
        "srovnání",
        "srovnat",
        "srovnatelný",
        "srpen",
        "stabilita",
        "stabilní",
        "stačit",
        "stadión",
        "stadium",
        "stáhnout",
        "stahovat",
        "stáj",
        "stále",
        "stálý",
        "stan",
        "standard",
        "standardní",
        "stánek",
        "stanice",
        "stanovení",
        "stanovený",
        "stanovisko",
        "stanoviště",
        "stanovit",
        "starat",
        "starost",
        "starosta",
        "start",
        "starý",
        "stařec",
        "stáří",
        "stát",
        "statek",
        "statistický",
        "statistika",
        "státní",
        "stav",
        "stávající",
        "stávat",
        "stavba",
        "stavební",
        "stavět",
        "stavit",
        "stehno",
        "stejně",
        "stejný",
        "stěna",
        "stezka",
        "stěží",
        "stěžovat",
        "stihnout",
        "stín",
        "stisknout",
        "stížnost",
        "sto",
        "stojící",
        "stolek",
        "století",
        "stopa",
        "stoupat",
        "stoupnout",
        "stovka",
        "str",
        "strach",
        "strana",
        "stranický",
        "stránka",
        "stranou",
        "strašně",
        "strašný",
        "strategický",
        "strategie",
        "strava",
        "strávit",
        "strážce",
        "strážník",
        "strčit",
        "stres",
        "strhnout",
        "stroj",
        "strom",
        "strop",
        "struktura",
        "strýc",
        "strýček",
        "střed",
        "středa",
        "středisko",
        "středně",
        "střední",
        "středověký",
        "střecha",
        "střela",
        "střelec",
        "střešní",
        "střet",
        "stříbrný",
        "stříbro",
        "střídat",
        "střílet",
        "student",
        "studený",
        "studie",
        "studijní",
        "studium",
        "studovat",
        "stůl",
        "stupeň",
        "stydět",
        "styk",
        "styl",
        "subjekt",
        "sucho",
        "suchý",
        "sukně",
        "sůl",
        "suma",
        "sundat",
        "super",
        "surovina",
        "sv",
        "svah",
        "sval",
        "svatba",
        "svatební",
        "svátek",
        "svatý",
        "svaz",
        "svazek",
        "svědčit",
        "svědectví",
        "svědek",
        "svědomí",
        "svěřit",
        "svět",
        "světelný",
        "světle",
        "světlo",
        "světlý",
        "světový",
        "svetr",
        "svíčka",
        "svírat",
        "svítit",
        "svoboda",
        "Svoboda",
        "svobodný",
        "svůj",
        "symbol",
        "symbolický",
        "sympatický",
        "syn",
        "sýr",
        "systém",
        "šálek",
        "šampionát",
        "šance",
        "šatna",
        "šaty",
        "šedesát",
        "šedesátý",
        "šedivý",
        "šedý",
        "šéf",
        "šeptat",
        "šest",
        "šestnáct",
        "šestý",
        "šetření",
        "šetřit",
        "šikovný",
        "šílený",
        "široký",
        "šíření",
        "šířit",
        "šířka",
        "škála",
        "škoda",
        "Škoda",
        "škola",
        "školka",
        "školní",
        "školství",
        "šok",
        "Španělsko",
        "španělský",
        "špatně",
        "špatný",
        "šperk",
        "špička",
        "špičkový",
        "špinavý",
        "štáb",
        "šťastně",
        "šťastný",
        "šťáva",
        "štědrý",
        "štěstí",
        "štíhlý",
        "štít",
        "Švédsko",
        "švédský",
        "Švýcarsko",
        "švýcarský",
        "tableta",
        "tábor",
        "tabule",
        "tabulka",
        "tady",
        "tah",
        "tahat",
        "táhnout",
        "tajemník",
        "tajemný",
        "tajemství",
        "tajit",
        "tajný",
        "tak",
        "také",
        "takhle",
        "takový",
        "takovýto",
        "takřka",
        "takto",
        "taky",
        "takzvaný",
        "takže",
        "talent",
        "talíř",
        "tam",
        "tamní",
        "tančit",
        "tanec",
        "taneční",
        "tank",
        "taška",
        "táta",
        "tatínek",
        "taxík",
        "téci",
        "teď",
        "teda",
        "tedy",
        "tehdejší",
        "tehdy",
        "těhotenství",
        "těhotný",
        "technický",
        "technika",
        "technologický",
        "technologie",
        "tekutina",
        "telefon",
        "telefonní",
        "tělesný",
        "těleso",
        "televize",
        "televizní",
        "televizor",
        "tělo",
        "téma",
        "téměř",
        "temnota",
        "temný",
        "tempo",
        "ten",
        "tendence",
        "tenhle",
        "tenkrát",
        "tenký",
        "tento",
        "tentokrát",
        "tentýž",
        "teoretický",
        "teorie",
        "tepelný",
        "Teplice",
        "teplo",
        "teplota",
        "teplý",
        "teprve",
        "terapie",
        "terasa",
        "terén",
        "termín",
        "těsně",
        "těsný",
        "test",
        "těsto",
        "těšit",
        "teta",
        "text",
        "též",
        "těžba",
        "těžce",
        "těžit",
        "těžko",
        "těžký",
        "the",
        "ticho",
        "tichý",
        "tip",
        "tisíc",
        "tisk",
        "tiskárna",
        "tisknout",
        "tiskový",
        "tiše",
        "titul",
        "tj",
        "tkáň",
        "tlačit",
        "tlačítko",
        "tlak",
        "tloušťka",
        "tlustý",
        "tma",
        "tmavý",
        "to",
        "točit",
        "tok",
        "tolik",
        "Tomáš",
        "tón",
        "top",
        "totiž",
        "touha",
        "toužit",
        "továrna",
        "tradice",
        "tradičně",
        "tradiční",
        "tragedie",
        "tragický",
        "tramvaj",
        "trápit",
        "trasa",
        "trať",
        "tráva",
        "trávit",
        "trávník",
        "trefit",
        "trend",
        "trenér",
        "trénink",
        "trénovat",
        "trest",
        "trestní",
        "trestný",
        "trh",
        "tričko",
        "trik",
        "triumf",
        "trocha",
        "trochu",
        "trojice",
        "trošku",
        "trouba",
        "trpělivě",
        "trpělivost",
        "trpět",
        "trubka",
        "trvale",
        "trvalý",
        "trvat",
        "tržba",
        "třást",
        "třeba",
        "třebaže",
        "třetí",
        "třetina",
        "tři",
        "třicet",
        "třída",
        "třikrát",
        "třináct",
        "tu",
        "tudíž",
        "tuhý",
        "tuk",
        "tuna",
        "tunel",
        "Turecko",
        "turecký",
        "turista",
        "turistický",
        "turnaj",
        "tušení",
        "tušit",
        "tuzemský",
        "tužka",
        "TV",
        "tvar",
        "tvář",
        "tvářit",
        "tvor",
        "tvorba",
        "tvořit",
        "tvrdě",
        "tvrdit",
        "tvrdý",
        "tvrzení",
        "tvůj",
        "tvůrce",
        "tvůrčí",
        "ty",
        "tyč",
        "týden",
        "týdně",
        "týkající",
        "týkat",
        "tým",
        "typ",
        "typický",
        "týž",
        "tzv",
        "u",
        "ublížit",
        "ubohý",
        "ucítit",
        "úcta",
        "účast",
        "účastník",
        "účastnit",
        "učebnice",
        "účel",
        "učení",
        "účet",
        "účinek",
        "učinit",
        "účinnost",
        "účinný",
        "učit",
        "učitel",
        "učitelka",
        "údaj",
        "údajně",
        "událost",
        "udělat",
        "udělit",
        "úder",
        "udeřit",
        "údolí",
        "údržba",
        "udržet",
        "udržovat",
        "úhel",
        "uherský",
        "uhlí",
        "uchazeč",
        "ucho",
        "uchopit",
        "ujistit",
        "ujít",
        "ujmout",
        "ukázat",
        "ukazatel",
        "ukázka",
        "ukazovat",
        "ukládat",
        "uklidnit",
        "úkol",
        "úkon",
        "ukončení",
        "ukončit",
        "Ukrajina",
        "ukrást",
        "úleva",
        "ulevit",
        "ulice",
        "ulička",
        "úloha",
        "uložený",
        "uložit",
        "umělec",
        "umělecký",
        "umělý",
        "umění",
        "umět",
        "umírat",
        "umístění",
        "umístěný",
        "umístit",
        "umožnit",
        "umožňovat",
        "úmrtí",
        "umřít",
        "úmysl",
        "únava",
        "unavený",
        "unést",
        "unie",
        "uniforma",
        "únik",
        "unikátní",
        "uniknout",
        "univerzální",
        "univerzita",
        "únor",
        "upadnout",
        "uplatnění",
        "uplatnit",
        "uplatňovat",
        "úplně",
        "úplný",
        "uplynout",
        "uplynulý",
        "upozornit",
        "upozorňovat",
        "úprava",
        "upravený",
        "upravit",
        "upravovat",
        "uprostřed",
        "upřímně",
        "upřímný",
        "úraz",
        "urazit",
        "určení",
        "určený",
        "určit",
        "určitě",
        "určitý",
        "určovat",
        "úroveň",
        "úřad",
        "úřední",
        "úředník",
        "USA",
        "usadit",
        "USB",
        "úsek",
        "úsilí",
        "usilovat",
        "uskutečnit",
        "uslyšet",
        "usmát",
        "úsměv",
        "usmívat",
        "usnout",
        "usoudit",
        "úspěch",
        "úspěšně",
        "úspěšný",
        "uspět",
        "úspora",
        "úsporný",
        "uspořádání",
        "uspořádat",
        "ústa",
        "ustanovení",
        "ústav",
        "ústavní",
        "ústecký",
        "Ústí",
        "ustoupit",
        "ústřední",
        "ušetřit",
        "utéci",
        "útěk",
        "úterý",
        "utíkat",
        "utkání",
        "útočník",
        "útok",
        "utrpení",
        "utrpět",
        "útvar",
        "uvádět",
        "úvaha",
        "uvařit",
        "uvažovat",
        "uvedený",
        "uvědomit",
        "uvědomovat",
        "úvěr",
        "uvěřit",
        "uvěřitelně",
        "uvést",
        "uvidět",
        "uvnitř",
        "úvod",
        "úvodní",
        "uvolněný",
        "uvolnit",
        "uzavírat",
        "uzavřený",
        "uzavřít",
        "uzel",
        "území",
        "územní",
        "úzkost",
        "úzký",
        "uznání",
        "uznat",
        "uznávat",
        "už",
        "úžasný",
        "užít",
        "užitečný",
        "užívání",
        "užívat",
        "uživatel",
        "v",
        "vada",
        "vadit",
        "váha",
        "váhat",
        "vajíčko",
        "valašský",
        "válečný",
        "válka",
        "valný",
        "van",
        "vana",
        "Vánoce",
        "vánoční",
        "varianta",
        "varování",
        "varovat",
        "Vary",
        "vaření",
        "vařit",
        "váš",
        "vášeň",
        "vázat",
        "vazba",
        "vážený",
        "vážit",
        "vážně",
        "vážný",
        "vcelku",
        "včas",
        "včela",
        "včera",
        "včerejší",
        "včetně",
        "vděčný",
        "věc",
        "večer",
        "večerní",
        "večeře",
        "večírek",
        "věčně",
        "věčný",
        "věda",
        "vědec",
        "vědecký",
        "vedení",
        "vedený",
        "vědět",
        "vedle",
        "vedlejší",
        "vědomí",
        "vědomý",
        "vedoucí",
        "vejce",
        "vejít",
        "věk",
        "věkový",
        "vektor",
        "veletrh",
        "velice",
        "veličina",
        "velikost",
        "veliký",
        "velitel",
        "velký",
        "velmi",
        "ven",
        "venkov",
        "venkovní",
        "venkovský",
        "venku",
        "věnovat",
        "věrný",
        "verš",
        "verze",
        "veřejně",
        "veřejnost",
        "veřejný",
        "věřící",
        "věřit",
        "ves",
        "veselý",
        "vesmír",
        "vesnice",
        "vést",
        "veškerý",
        "věta",
        "větev",
        "větrný",
        "většina",
        "většinou",
        "vězeň",
        "vězení",
        "věznice",
        "vézt",
        "věž",
        "vhodný",
        "vchod",
        "víc",
        "více",
        "víceméně",
        "víčko",
        "vídat",
        "Vídeň",
        "vidění",
        "video",
        "vidět",
        "viditelný",
        "víkend",
        "vila",
        "vina",
        "vinný",
        "víno",
        "vir",
        "víra",
        "virtuální",
        "viset",
        "vitamín",
        "vítat",
        "vítěz",
        "vítězný",
        "vítězství",
        "vítr",
        "viz",
        "vize",
        "vláda",
        "vládní",
        "vládnout",
        "vlak",
        "vlákno",
        "vlas",
        "vlast",
        "vlastně",
        "vlastní",
        "vlastnictví",
        "vlastník",
        "vlastnit",
        "vlastnost",
        "vlevo",
        "vlhkost",
        "vlhký",
        "vliv",
        "vlk",
        "vlna",
        "vloni",
        "vložit",
        "Vltava",
        "vnější",
        "vnímání",
        "vnímat",
        "vnitro",
        "vnitřní",
        "voda",
        "vodní",
        "voják",
        "vojenský",
        "vojsko",
        "volání",
        "volant",
        "volat",
        "volba",
        "volby",
        "volební",
        "volič",
        "volit",
        "volně",
        "volno",
        "volný",
        "von",
        "vonět",
        "vozidlo",
        "vozík",
        "vozit",
        "vpravo",
        "vpřed",
        "vracet",
        "vrah",
        "vrata",
        "vrátit",
        "vrazit",
        "vražda",
        "vrhat",
        "vrhnout",
        "vrch",
        "vrchní",
        "vrchol",
        "vrstva",
        "vsadit",
        "vstát",
        "vstávat",
        "vstoupit",
        "vstříc",
        "vstup",
        "vstupenka",
        "vstupní",
        "vstupovat",
        "však",
        "všecek",
        "všední",
        "všechen",
        "všeobecně",
        "všeobecný",
        "všímat",
        "všimnout",
        "všude",
        "vteřina",
        "vtip",
        "vtipný",
        "vtom",
        "vůbec",
        "vůči",
        "vůdce",
        "vůle",
        "vůně",
        "vůz",
        "vy",
        "výbava",
        "vybavení",
        "vybavený",
        "vybavit",
        "vyběhnout",
        "výběr",
        "výběrový",
        "vybírat",
        "výbor",
        "výborně",
        "výborný",
        "vybraný",
        "vybrat",
        "vybudovat",
        "výbuch",
        "výcvik",
        "vyčítat",
        "výdaj",
        "vydání",
        "vydaný",
        "vydat",
        "vydávat",
        "vydechnout",
        "vydělat",
        "vydělávat",
        "vyděsit",
        "vydržet",
        "vyhlásit",
        "vyhláška",
        "výhled",
        "vyhledat",
        "vyhledávat",
        "vyhlídka",
        "vyhnat",
        "vyhnout",
        "výhoda",
        "vyhodit",
        "výhodný",
        "vyhovět",
        "vyhovovat",
        "výhra",
        "výhradně",
        "vyhrát",
        "vyhrknout",
        "vyhýbat",
        "vycházet",
        "východ",
        "východní",
        "výchova",
        "výchozí",
        "vyjádření",
        "vyjádřit",
        "vyjadřovat",
        "vyjet",
        "výjimečně",
        "výjimečný",
        "výjimka",
        "vyjít",
        "vykazovat",
        "výklad",
        "vykládat",
        "výkon",
        "vykonávat",
        "výkonný",
        "vykročit",
        "výkřik",
        "vykřiknout",
        "výlet",
        "vylézt",
        "vyloučit",
        "výměna",
        "vyměnit",
        "vymyslet",
        "vymýšlet",
        "vyndat",
        "vynechat",
        "vynést",
        "vynikající",
        "vynořit",
        "výnos",
        "vypadat",
        "vypadnout",
        "vypít",
        "vyplatit",
        "vyplnit",
        "vyplývat",
        "vypnout",
        "výpočet",
        "výpověď",
        "vypovídat",
        "vypracovat",
        "výprava",
        "vyprávění",
        "vyprávět",
        "vypravit",
        "vypustit",
        "vyrábět",
        "výraz",
        "vyrazit",
        "výrazně",
        "výrazný",
        "výroba",
        "výrobce",
        "výrobek",
        "vyrobený",
        "vyrobit",
        "výrobní",
        "výročí",
        "výrok",
        "vyrovnaný",
        "vyrovnat",
        "vyrůst",
        "vyrůstat",
        "vyřešit",
        "vyřídit",
        "vysílání",
        "vysílat",
        "vyskočit",
        "výskyt",
        "vyskytovat",
        "vyslat",
        "výsledek",
        "výsledný",
        "výslech",
        "vyslechnout",
        "vyslovit",
        "vysoce",
        "vysočina",
        "vysoko",
        "vysoký",
        "vyspělý",
        "výstava",
        "výstavba",
        "vystavit",
        "vystavovat",
        "vystoupení",
        "vystoupit",
        "vystřelit",
        "vystřídat",
        "vystudovat",
        "výstup",
        "výstupní",
        "vystupovat",
        "vysvětlení",
        "vysvětlit",
        "vysvětlovat",
        "výše",
        "vyšetření",
        "vyšetřování",
        "vyšetřovatel",
        "výška",
        "výtah",
        "vytáhnout",
        "vytápění",
        "vytrhnout",
        "výtvarný",
        "vytváření",
        "vytvářet",
        "vytvoření",
        "vytvořený",
        "vytvořit",
        "výuka",
        "využít",
        "využití",
        "využívání",
        "využívat",
        "vyvést",
        "vyvíjet",
        "vyvinout",
        "vývoj",
        "vývojový",
        "vyvolat",
        "vyvolávat",
        "vyzkoušet",
        "výzkum",
        "výzkumný",
        "vyznačovat",
        "význam",
        "významně",
        "významný",
        "vyznat",
        "výzva",
        "vyzvat",
        "vyzvednout",
        "vyžádat",
        "vyžadovat",
        "výživa",
        "vzácný",
        "vzadu",
        "vzájemně",
        "vzájemný",
        "vzápětí",
        "vzbudit",
        "vzdálenost",
        "vzdálený",
        "vzdát",
        "vzdělání",
        "vzdělaný",
        "vzdělávací",
        "vzdělávání",
        "vzduch",
        "vzhled",
        "vzhledem",
        "vzhlédnout",
        "vzhůru",
        "vzít",
        "vzkaz",
        "vznášet",
        "vznik",
        "vznikat",
        "vzniklý",
        "vzniknout",
        "vzor",
        "vzorec",
        "vzorek",
        "vzpamatovat",
        "vzpomenout",
        "vzpomínat",
        "vzpomínka",
        "vzrůst",
        "vzrušení",
        "vztah",
        "vztahovat",
        "vztek",
        "vždy",
        "vždycky",
        "vždyť",
        "Washington",
        "Web",
        "webový",
        "Windows",
        "York",
        "z",
        "za",
        "zabalit",
        "zábava",
        "zábavný",
        "záběr",
        "zabezpečení",
        "zabíjet",
        "zabírat",
        "zabít",
        "zábradlí",
        "zabránit",
        "zabrat",
        "zabývat",
        "začátek",
        "začínat",
        "začít",
        "záda",
        "zadat",
        "zadek",
        "zadívat",
        "zadní",
        "zadržet",
        "záhada",
        "zahájení",
        "zahájit",
        "zahlédnout",
        "zahrada",
        "zahrádka",
        "zahradní",
        "zahraničí",
        "zahraniční",
        "zahrát",
        "zahrnout",
        "zahrnovat",
        "záhy",
        "zahynout",
        "zacházet",
        "záchod",
        "zachování",
        "zachovat",
        "záchrana",
        "zachránit",
        "záchranný",
        "záchvat",
        "zachytit",
        "zájem",
        "zájemce",
        "zajet",
        "zajímat",
        "zajímavost",
        "zajímavý",
        "zajistit",
        "zajištění",
        "zajišťovat",
        "zajít",
        "zákaz",
        "zakázat",
        "zakázka",
        "zákazník",
        "základ",
        "zakládat",
        "zakladatel",
        "základna",
        "základní",
        "zákon",
        "zákoník",
        "zákonný",
        "zákrok",
        "zakrýt",
        "záležet",
        "záležitost",
        "zalít",
        "záloha",
        "založení",
        "založený",
        "založit",
        "zámek",
        "záměr",
        "zaměření",
        "zaměřený",
        "zaměřit",
        "zaměřovat",
        "zaměstnanec",
        "zaměstnání",
        "zaměstnavatel",
        "zamilovaný",
        "zamilovat",
        "zamířit",
        "zamumlat",
        "zamyslet",
        "zanechat",
        "zánět",
        "západ",
        "západní",
        "zapadnout",
        "zapálit",
        "zápas",
        "zápěstí",
        "zápis",
        "zaplatit",
        "zapnout",
        "zapojení",
        "zapojit",
        "zapomenout",
        "zapomínat",
        "zapotřebí",
        "zapsat",
        "zarazit",
        "zároveň",
        "záruka",
        "zařadit",
        "záření",
        "září",
        "zařídit",
        "zářit",
        "zařízení",
        "zas",
        "zásada",
        "zásadně",
        "zásadní",
        "zásah",
        "zasáhnout",
        "zasahovat",
        "zase",
        "zasedání",
        "zaskočit",
        "zaslechnout",
        "zasloužit",
        "zásluha",
        "zasmát",
        "zásoba",
        "zastávat",
        "zastavit",
        "zastávka",
        "zastoupení",
        "zastřelit",
        "zástupce",
        "zastupitel",
        "zastupitelstvo",
        "zásuvka",
        "zašeptat",
        "zatáčka",
        "zátěž",
        "zatím",
        "zatímco",
        "zatížení",
        "zatknout",
        "zato",
        "zaujmout",
        "zaútočit",
        "závazek",
        "závažný",
        "zavedení",
        "závěr",
        "závěrečný",
        "závěs",
        "zavěsit",
        "zavést",
        "zavírat",
        "záviset",
        "závislost",
        "závislý",
        "závod",
        "závodník",
        "zavolat",
        "zavrtět",
        "zavřený",
        "zavřít",
        "zázemí",
        "záznam",
        "zaznamenat",
        "zaznít",
        "zázrak",
        "zazvonit",
        "zažít",
        "zážitek",
        "zažívat",
        "zbavit",
        "zboží",
        "zbraň",
        "zbylý",
        "zbýt",
        "zbytečně",
        "zbytečný",
        "zbytek",
        "zbývající",
        "zbývat",
        "zcela",
        "zčásti",
        "zda",
        "zdaleka",
        "zdánlivě",
        "zdarma",
        "zdát",
        "zde",
        "zdejší",
        "Zdeněk",
        "zdobit",
        "zdraví",
        "zdravotní",
        "zdravotnický",
        "zdravotnictví",
        "zdravý",
        "zdroj",
        "zdůraznit",
        "zdůrazňovat",
        "zeď",
        "zejména",
        "zeleň",
        "zelenina",
        "zelený",
        "Zeman",
        "země",
        "zemědělec",
        "zemědělský",
        "zemědělství",
        "zemní",
        "zemřít",
        "zemský",
        "zeptat",
        "zesilovač",
        "zhluboka",
        "zhroutit",
        "zhruba",
        "zima",
        "zimní",
        "zírat",
        "zisk",
        "získání",
        "získaný",
        "získat",
        "získávat",
        "zítra",
        "zjevně",
        "zjistit",
        "zjištění",
        "zjišťovat",
        "zklamání",
        "zklamat",
        "zkontrolovat",
        "zkoumání",
        "zkoumat",
        "zkoušet",
        "zkouška",
        "zkratka",
        "zkrátka",
        "zkusit",
        "zkušenost",
        "zkušený",
        "zlato",
        "zlatý",
        "zlepšení",
        "zlepšit",
        "zlepšovat",
        "Zlín",
        "zlínský",
        "zlo",
        "zlobit",
        "zločin",
        "zloděj",
        "zlomit",
        "zlý",
        "zmatek",
        "zmatený",
        "změna",
        "změnit",
        "zmíněný",
        "zmínit",
        "zmínka",
        "zmiňovat",
        "zmizet",
        "zmocnit",
        "značka",
        "značně",
        "značný",
        "znak",
        "znalec",
        "znalost",
        "znamenat",
        "znamení",
        "známka",
        "známý",
        "znát",
        "zničit",
        "znít",
        "znova",
        "znovu",
        "zobrazení",
        "zobrazit",
        "zodpovědnost",
        "zodpovědný",
        "zóna",
        "ZOO",
        "zopakovat",
        "zoufale",
        "zoufalství",
        "zoufalý",
        "zpátky",
        "zpět",
        "zpětný",
        "zpěv",
        "zpěvačka",
        "zpěvák",
        "zpívat",
        "zpočátku",
        "zpomalit",
        "zpracování",
        "zpracovat",
        "zpracovávat",
        "zpráva",
        "zpravidla",
        "způsob",
        "způsobený",
        "způsobit",
        "způsobovat",
        "zrak",
        "zralý",
        "zranění",
        "zraněný",
        "zranit",
        "zrcadlo",
        "zrodit",
        "zrovna",
        "zrušení",
        "zrušit",
        "zřejmě",
        "zřejmý",
        "zřetelně",
        "zřetelný",
        "zřídit",
        "zřídka",
        "ztracený",
        "ztrácet",
        "ztráta",
        "ztratit",
        "zub",
        "zúčastnit",
        "zůstat",
        "zůstávat",
        "Zuzana",
        "zvaný",
        "zvát",
        "zvažovat",
        "zvedat",
        "zvědavý",
        "zvednout",
        "zveřejnit",
        "zvíře",
        "zvítězit",
        "zvládat",
        "zvládnout",
        "zvlášť",
        "zvláště",
        "zvláštní",
        "zvolat",
        "zvolený",
        "zvolit",
        "zvolna",
        "zvuk",
        "zvukový",
        "zvyk",
        "zvyklý",
        "zvyknout",
        "zvýšení",
        "zvýšený",
        "zvýšit",
        "zvyšovat",
        "žádat",
        "žádný",
        "žádost",
        "žádoucí",
        "žák",
        "žaloba",
        "žaludek",
        "žánr",
        "že",
        "žebříček",
        "železnice",
        "železniční",
        "železný",
        "železo",
        "žena",
        "ženská",
        "ženský",
        "Žid",
        "žid",
        "židle",
        "židovský",
        "žijící",
        "žíla",
        "žít",
        "živit",
        "živočich",
        "živočišný",
        "život",
        "životní",
        "životnost",
        "živý",
        "žlutý",
    )

    parts_of_speech: Dict[str, tuple] = {}
