/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.overlaps;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.elk.alg.common.overlaps.GreedyRectangleStripOverlapRemover;
import org.eclipse.elk.alg.common.overlaps.IRectangleStripOverlapRemovalStrategy;
import org.eclipse.elk.core.math.ElkRectangle;

public final class RectangleStripOverlapRemover {
    private static final double DEFAULT_GAP = 5.0;
    private OverlapRemovalDirection overlapRemovalDirection;
    private double gapVertical = 5.0;
    private double gapHorizontal = 5.0;
    private double startCoordinate = 0.0;
    private IRectangleStripOverlapRemovalStrategy overlapRemovalStrategy;
    private List<RectangleNode> rectangleNodes = Lists.newArrayList();

    public static RectangleStripOverlapRemover createForDirection(OverlapRemovalDirection direction) {
        RectangleStripOverlapRemover remover = new RectangleStripOverlapRemover();
        remover.overlapRemovalDirection = direction;
        return remover;
    }

    public RectangleStripOverlapRemover withGap(double theHorizontalGap, double theVerticalGap) {
        this.gapHorizontal = theHorizontalGap;
        this.gapVertical = theVerticalGap;
        return this;
    }

    public RectangleStripOverlapRemover withStartCoordinate(double coordinate) {
        this.startCoordinate = coordinate;
        return this;
    }

    public RectangleStripOverlapRemover withOverlapRemovalStrategy(IRectangleStripOverlapRemovalStrategy strategy) {
        this.overlapRemovalStrategy = strategy;
        return this;
    }

    public RectangleStripOverlapRemover addRectangle(ElkRectangle rectangle) {
        this.rectangleNodes.add(new RectangleNode(rectangle, this.importRectangle(rectangle)));
        return this;
    }

    public double getHorizontalGap() {
        return this.gapHorizontal;
    }

    public double getVerticalGap() {
        return this.gapVertical;
    }

    public List<RectangleNode> getRectangleNodes() {
        return this.rectangleNodes;
    }

    private ElkRectangle importRectangle(ElkRectangle rectangle) {
        switch (this.overlapRemovalDirection) {
            case UP: 
            case DOWN: {
                return rectangle;
            }
            case LEFT: 
            case RIGHT: {
                return new ElkRectangle(rectangle.y, 0.0, rectangle.height, rectangle.width);
            }
        }
        assert (false);
        return null;
    }

    private void exportRectangle(RectangleNode rectangleNode, double stripSize) {
        ElkRectangle rectangle = rectangleNode.rectangle;
        ElkRectangle originalRectangle = rectangleNode.originalRectangle;
        switch (this.overlapRemovalDirection) {
            case UP: {
                originalRectangle.y = this.startCoordinate - rectangle.height - rectangle.y;
                break;
            }
            case DOWN: {
                originalRectangle.y += this.startCoordinate;
                break;
            }
            case LEFT: {
                originalRectangle.x = this.startCoordinate - rectangle.height - rectangle.y;
                break;
            }
            case RIGHT: {
                originalRectangle.x = this.startCoordinate + rectangle.y;
            }
        }
    }

    public double removeOverlaps() {
        if (this.overlapRemovalStrategy == null) {
            this.overlapRemovalStrategy = new GreedyRectangleStripOverlapRemover();
        }
        this.rectangleNodes.sort(RectangleStripOverlapRemover::compareLeftRectangleBorders);
        this.computeOverlaps();
        double stripSize = this.overlapRemovalStrategy.removeOverlaps(this);
        this.rectangleNodes.stream().forEach(node -> this.exportRectangle((RectangleNode)node, stripSize));
        return stripSize;
    }

    private void computeOverlaps() {
        TreeSet<RectangleNode> intersectingNodes = Sets.newTreeSet(RectangleStripOverlapRemover::compareRightRectangleBorders);
        double scanlinePos = Double.NEGATIVE_INFINITY;
        for (RectangleNode currNode : this.rectangleNodes) {
            scanlinePos = currNode.rectangle.x;
            while (!intersectingNodes.isEmpty()) {
                RectangleNode intersectingRectangle = (RectangleNode)intersectingNodes.first();
                if (!(intersectingRectangle.rectangle.x + intersectingRectangle.rectangle.width < scanlinePos)) break;
                intersectingNodes.remove(intersectingRectangle);
            }
            for (RectangleNode intersectingNode : intersectingNodes) {
                intersectingNode.overlappingNodes.add(currNode);
                currNode.overlappingNodes.add(intersectingNode);
            }
            intersectingNodes.add(currNode);
        }
    }

    private static int compareLeftRectangleBorders(RectangleNode rn1, RectangleNode rn2) {
        return Double.compare(rn1.rectangle.x, rn2.rectangle.x);
    }

    private static int compareRightRectangleBorders(RectangleNode rn1, RectangleNode rn2) {
        return Double.compare(rn1.rectangle.x + rn1.rectangle.width, rn2.rectangle.x + rn2.rectangle.width);
    }

    public static enum OverlapRemovalDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    public static final class RectangleNode {
        private ElkRectangle originalRectangle;
        private ElkRectangle rectangle;
        private List<RectangleNode> overlappingNodes = Lists.newLinkedList();

        private RectangleNode(ElkRectangle originalRectangle, ElkRectangle rectangle) {
            this.originalRectangle = originalRectangle;
            this.rectangle = rectangle;
        }

        public ElkRectangle getRectangle() {
            return this.rectangle;
        }

        public List<RectangleNode> getOverlappingNodes() {
            return this.overlappingNodes;
        }
    }
}

