/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;

public class SvgAttributes {
    private final Map<String, String> attributes = new TreeMap<String, String>();
    private static final Pattern2 p = Pattern2.cmpile("(\\w+)\\s*=\\s*([%g][^%g]*[%g]|(?:\\w+))");

    private SvgAttributes cloneMe() {
        SvgAttributes result = new SvgAttributes();
        result.attributes.putAll(this.attributes);
        return result;
    }

    private SvgAttributes() {
    }

    public static SvgAttributes empty() {
        return new SvgAttributes();
    }

    public static SvgAttributes build(String args) {
        SvgAttributes result = new SvgAttributes();
        Matcher2 m = p.matcher(args);
        while (m.find()) {
            result.attributes.put(m.group(1), StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m.group(2)));
        }
        return result;
    }

    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public SvgAttributes add(String key, String value) {
        SvgAttributes result = this.cloneMe();
        result.attributes.put(key, value);
        return result;
    }

    public SvgAttributes add(SvgAttributes toBeAdded) {
        SvgAttributes result = this.cloneMe();
        result.attributes.putAll(toBeAdded.attributes);
        return result;
    }
}

