/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.httpclient;

import java.time.Duration;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.httpclient.MLValidatableAsyncHttpClient;
import org.opensearch.secure_sm.AccessController;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;

public class MLHttpClientFactory {
    @Generated
    private static final Logger log = LogManager.getLogger(MLHttpClientFactory.class);

    public static SdkAsyncHttpClient getAsyncHttpClient(Duration connectionTimeout, Duration readTimeout, int maxConnections, boolean connectorPrivateIpEnabled) {
        return (SdkAsyncHttpClient)AccessController.doPrivileged(() -> {
            log.debug("Creating MLHttpClient with connectionTimeout: {}, readTimeout: {}, maxConnections: {}", (Object)connectionTimeout, (Object)readTimeout, (Object)maxConnections);
            SdkAsyncHttpClient delegate = NettyNioAsyncHttpClient.builder().connectionTimeout(connectionTimeout).readTimeout(readTimeout).maxConcurrency(Integer.valueOf(maxConnections)).build();
            return new MLValidatableAsyncHttpClient(delegate, connectorPrivateIpEnabled);
        });
    }
}

