/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kxv_Deva extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TR = "\u0924\u0941\u0930\u094d\u0915\u0940";
        final String metaValue_bn = "\u092c\u0902\u0917\u093e\u0932\u0940";
        final String metaValue_chr = "\u091a\u0947\u0930\u094b\u0915\u0940";
        final String metaValue_kn = "\u0915\u0928\u094d\u0928\u0921\u093c";
        final String metaValue_ml = "\u092e\u0932\u092f\u093e\u0932\u092e";
        final String metaValue_ta = "\u0924\u092e\u093f\u0932";
        final String metaValue_te = "\u0924\u0947\u0932\u0941\u0917\u0942";
        final Object[][] data = new Object[][] {
            { "001", "\u0930\u093e\u091c\u093f, \u092a\u0943\u0924\u0940" },
            { "419", "\u0932\u093e\u0924\u093f\u0928 \u0906\u092e\u0947\u0930\u093f\u0915\u093e \u0924\u093f" },
            { "AD", "\u0905\u0902\u0921\u094b\u0930\u093e" },
            { "AE", "\u0906\u0923\u094d\u0921\u0940 \u0924\u093f \u0905\u0930\u092c \u090f\u092e\u093f\u0930\u0947\u091f\u094d\u0938" },
            { "AF", "\u0905\u092a\u093c\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "AG", "\u090f\u0902\u091f\u093f\u0917\u0941\u0906 \u0911\u0921\u093c\u0947 \u092c\u0930\u092c\u0941\u0921\u093e" },
            { "AI", "\u090f\u0902\u0917\u094d\u0935\u093f\u0932\u093e" },
            { "AL", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e" },
            { "AM", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "AO", "\u0905\u0902\u0917\u094b\u0932\u093e" },
            { "AQ", "\u0905\u0902\u091f\u093e\u0930\u094d\u0915\u091f\u093f\u0915\u093e" },
            { "AR", "\u0905\u0930\u094d\u091c\u0947\u0902\u091f\u0940\u0928\u093e" },
            { "AS", "\u0906\u092e\u0947\u0930\u093f\u0915\u093e-\u0924\u093f \u0938\u092e\u094b\u0906" },
            { "AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "AU", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e" },
            { "AW", "\u0905\u0930\u0942\u092c\u093e" },
            { "AX", "\u090f\u0932\u0947\u0902\u0921 \u0926\u094d\u0935\u0940\u092a" },
            { "AZ", "\u0905\u091c\u093c\u0930\u092c\u0947\u091c\u093e\u0928" },
            { "BA", "\u092c\u094b\u0938\u094d\u0928\u093f\u092f\u093e \u0911\u0921\u093c\u0947 \u0939\u0930\u094d\u091c\u093c\u0947\u0917\u094b\u0935\u093f\u0928\u093e" },
            { "BB", "\u092c\u093e\u0930\u092c\u093e\u0921\u094b\u0938" },
            { "BD", "\u092c\u093e\u0902\u0917\u094d\u0932\u093e\u0926\u0947\u0938" },
            { "BE", "\u092c\u0947\u0932\u094d\u091c\u093f\u092f\u092e" },
            { "BF", "\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092a\u093c\u093e\u0938\u094b" },
            { "BG", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e" },
            { "BH", "\u092c\u0939\u0930\u0940\u0928" },
            { "BI", "\u092c\u0941\u0930\u0941\u0902\u0921\u0940" },
            { "BJ", "\u092c\u0947\u0928\u093f\u0928" },
            { "BL", "\u0938\u0947\u0902\u091f \u092c\u093e\u0930\u094d\u0924\u0947\u0932\u0947\u092e\u0940" },
            { "BM", "\u092c\u0930\u092e\u0942\u0921\u093e" },
            { "BN", "\u092c\u094d\u0930\u0942\u0928\u0947\u0908" },
            { "BO", "\u092c\u094b\u0932\u0940\u0935\u093f\u092f\u093e" },
            { "BQ", "\u0915\u0947\u0930\u093f\u092c\u093f\u092f\u0928 \u0928\u0940\u0926\u0930\u0932\u0947\u0902\u0921" },
            { "BR", "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932" },
            { "BS", "\u092c\u0939\u093e\u092e\u093e\u0938" },
            { "BT", "\u092c\u0941\u091f\u093e\u0928" },
            { "BW", "\u092c\u094b\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "BY", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938" },
            { "BZ", "\u092c\u0947\u0932\u0940\u091c\u093c" },
            { "CA", "\u0915\u093e\u0928\u093e\u0921\u093e" },
            { "CC", "\u0915\u094b\u0915\u094b\u0938 (\u0915\u0940\u0932\u093f\u0902\u0917) \u0926\u094d\u0935\u0940\u092a" },
            { "CD", "\u0915\u093e\u0902\u0917\u094b - \u0915\u093f\u0902\u0938\u093e\u0938\u093e" },
            { "CF", "\u092e\u0927\u094d\u092f \u0905\u092a\u093c\u094d\u0930\u0940\u0915\u0940 \u0917\u0923\u0930\u093e\u091c\u094d\u092f" },
            { "CG", "\u0915\u093e\u0902\u0917\u094b \u2013 \u092c\u094d\u0930\u093e\u091c\u093c\u093e\u0935\u093f\u0932" },
            { "CH", "\u0938\u094d\u0935\u093f\u091f\u094d\u091c\u093c\u0930\u0932\u0947\u0902\u0921" },
            { "CI", "\u0915\u094b\u091f \u0921\u0940 \u0935\u094b\u0906" },
            { "CK", "\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a" },
            { "CL", "\u091a\u093f\u0932\u0940" },
            { "CM", "\u0915\u0947\u092e\u0930\u0942\u0928" },
            { "CN", "\u091a\u0940\u0928" },
            { "CO", "\u0915\u094b\u0932\u0902\u092c\u093f\u092f\u093e" },
            { "CR", "\u0915\u094b\u0938\u094d\u091f\u093e\u0930\u093f\u0915\u093e" },
            { "CU", "\u0915\u094d\u092f\u0942\u092c\u093e" },
            { "CV", "\u0915\u0947\u092a \u0935\u0930\u094d\u0921" },
            { "CW", "\u0915\u094d\u092f\u0942\u0930\u093e\u0938\u093e\u0913" },
            { "CX", "\u0915\u094d\u0930\u093f\u0938\u092e\u0938 \u0926\u094d\u0935\u0940\u092a" },
            { "CY", "\u0938\u093e\u0907\u092a\u094d\u0930\u0938" },
            { "CZ", "\u091a\u0947\u0915\u093f\u092f\u093e" },
            { "DE", "\u091c\u0930\u094d\u092e\u0928\u0940" },
            { "DG", "\u0921\u093f\u090f\u0917\u094b \u0917\u093e\u0930\u094d\u0938\u093f\u092f\u093e" },
            { "DJ", "\u091c\u093f\u092c\u0942\u0924\u0940" },
            { "DK", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915" },
            { "DM", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u093e" },
            { "DO", "\u0921\u094b\u092e\u093f\u0928\u093f\u0915\u0928 \u0917\u0923\u0930\u093e\u091c\u094d\u092f" },
            { "DZ", "\u0905\u0932\u094d\u091c\u0940\u0930\u093f\u092f\u093e" },
            { "EA", "\u0938\u0947\u0909\u091f\u093e \u0911\u0921\u093c\u0947 \u092e\u0947\u0932\u093f\u0932\u093e" },
            { "EC", "\u0907\u0915\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "EE", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e" },
            { "EG", "\u092e\u093f\u0938\u094d\u0930" },
            { "EH", "\u0935\u0947\u0921\u093c\u093e \u0915\u0941\u0923\u094d\u092a\u0941 \u0938\u0939\u093e\u0930\u093e" },
            { "ER", "\u0907\u0930\u093f\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "ES", "\u0938\u094d\u092a\u0947\u0928" },
            { "ET", "\u0907\u0924\u093f\u092f\u094b\u092a\u093f\u092f\u093e" },
            { "FI", "\u092a\u093c\u093f\u0928\u0932\u0947\u0902\u0921" },
            { "FJ", "\u092a\u093c\u093f\u091c\u0940" },
            { "FK", "\u092a\u093c\u0949\u0915\u0932\u0947\u0902\u0921 \u0926\u094d\u0935\u0940\u092a" },
            { "FM", "\u092e\u093e\u0907\u0915\u094d\u0930\u094b\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "FO", "\u092a\u0947\u0930\u094b \u0926\u0940\u092a" },
            { "FR", "\u092a\u093c\u094d\u0930\u093e\u0902\u0938" },
            { "GA", "\u0917\u094d\u092f\u093e\u092c\u0949\u0928" },
            { "GB", "\u092f\u0942\u0928\u093e\u0907\u091f\u0947\u0921 \u0915\u093f\u0902\u0917\u0921\u092e" },
            { "GD", "\u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093e" },
            { "GE", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e" },
            { "GF", "\u092a\u093c\u094d\u0930\u0947\u0902\u091a \u0917\u0941\u092f\u093e\u0928\u093e" },
            { "GG", "\u0917\u0930\u094d\u0928\u0938\u0940" },
            { "GH", "\u0917\u093e\u0928\u093e" },
            { "GI", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u0930" },
            { "GL", "\u0917\u094d\u0930\u0940\u0928\u0932\u0947\u0902\u0921" },
            { "GM", "\u0917\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "GN", "\u0917\u093f\u0928\u0940" },
            { "GP", "\u0917\u094d\u0935\u093e\u0921\u0947\u0932\u0942\u092a" },
            { "GQ", "\u0907\u0915\u094d\u0935\u0947\u091f\u094b\u0930\u093f\u092f\u0932 \u0917\u093f\u0928\u0940" },
            { "GR", "\u092f\u0942\u0928\u093e\u0928" },
            { "GS", "\u0926\u0915\u093f\u0923 \u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e \u0905\u0921\u093c\u0947 \u0926\u0915\u093f\u0923 \u0938\u0948\u0902\u0921\u0935\u093f\u091a \u0926\u0940\u092a" },
            { "GT", "\u0917\u094d\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e" },
            { "GU", "\u0917\u0941\u0906\u092e" },
            { "GW", "\u0917\u093f\u0928\u0940-\u092c\u093f\u0938\u093e\u0909" },
            { "GY", "\u0917\u0941\u092f\u093e\u0928\u093e" },
            { "HK", "\u0939\u093e\u0901\u0917 \u0915\u093e\u0901\u0917 (\u090f\u0938 \u090f \u0906\u0930 \u091a\u0940\u0928)" },
            { "HN", "\u0939\u094b\u0902\u0921\u0942\u0930\u093e\u0938" },
            { "HR", "\u0915\u094d\u0930\u094b\u090f\u0938\u093f\u092f\u093e" },
            { "HT", "\u0939\u093e\u0907\u0924\u0940" },
            { "HU", "\u0939\u0902\u0917\u0930\u0940" },
            { "IC", "\u0915\u0947\u0928\u0947\u0930\u0940 \u0926\u094d\u0935\u0940\u092a" },
            { "ID", "\u0907\u0902\u0921\u094b\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "IE", "\u0906\u092f\u0930\u0932\u0947\u0902\u0921" },
            { "IL", "\u0907\u091c\u093c\u0930\u093e\u0907\u0932" },
            { "IM", "\u0906\u0907\u0932 \u0911\u092a\u093c \u092e\u0947\u0928" },
            { "IN", "\u092c\u093e\u0930\u0924" },
            { "IO", "\u092c\u094d\u0930\u093f\u091f\u093f\u0938 \u0939\u093f\u0902\u0926 \u0938\u093e\u092e\u0941\u0926\u094d\u0930\u093f \u0939\u093e\u0902\u0921\u093f" },
            { "IQ", "\u0907\u0930\u093e\u0915" },
            { "IR", "\u0908\u0930\u093e\u0928" },
            { "IS", "\u0906\u0907\u0938\u0932\u0947\u0902\u0921" },
            { "IT", "\u0907\u091f\u0932\u0940" },
            { "JE", "\u091c\u0930\u094d\u0938\u0940" },
            { "JM", "\u091c\u092e\u0947\u0915\u093e" },
            { "JO", "\u091c\u0949\u0930\u094d\u0921\u0928" },
            { "JP", "\u091c\u093e\u092a\u093e\u0928" },
            { "KE", "\u0915\u0947\u0928\u094d\u092f\u093e" },
            { "KG", "\u0915\u093f\u0930\u094d\u0917\u093f\u091c\u093c\u0938\u094d\u0924\u093e\u0928" },
            { "KH", "\u0915\u0902\u092c\u094b\u0921\u093f\u092f\u093e" },
            { "KI", "\u0915\u093f\u0930\u093f\u092c\u093e\u0924\u0940" },
            { "KM", "\u0915\u094b\u092e\u094b\u0930\u094b\u0938" },
            { "KN", "\u0938\u0947\u0902\u091f \u0915\u093f\u091f\u094d\u0938 \u0911\u0921\u093c\u0947 \u0928\u0947\u0935\u093f\u0938" },
            { "KP", "\u0909\u0924\u0930 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KR", "\u0926\u0949\u0915\u093f\u0923 \u0915\u094b\u0930\u093f\u092f\u093e" },
            { "KW", "\u0915\u0941\u0935\u0947\u0924" },
            { "KY", "\u0915\u0947\u092e\u0947\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "KZ", "\u0915\u091c\u093c\u093e\u0915\u0938\u094d\u0924\u093e\u0928" },
            { "LA", "\u0932\u093e\u0913\u0938" },
            { "LB", "\u0932\u0947\u092c\u0928\u093e\u0928" },
            { "LC", "\u0938\u0947\u0902\u091f \u0932\u0942\u0938\u093f\u092f\u093e" },
            { "LI", "\u0932\u093f\u0915\u094d\u091f\u0947\u0928\u094d\u0938\u094d\u091f\u0940\u0928" },
            { "LK", "\u0938\u094d\u0930\u0940\u0932\u0902\u0915\u093e" },
            { "LR", "\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e" },
            { "LS", "\u0932\u0947\u0938\u094b\u0924\u094b" },
            { "LT", "\u0932\u093f\u0924\u0941\u0906\u0928\u093f\u092f\u093e" },
            { "LU", "\u0932\u0917\u094d\u091c\u093c\u092e\u092c\u0930\u094d\u0917" },
            { "LV", "\u0932\u093e\u0924\u0935\u093f\u092f\u093e" },
            { "LY", "\u0932\u0940\u092c\u093f\u092f\u093e" },
            { "MA", "\u092e\u094b\u0930\u0915\u094d\u0915\u094b" },
            { "MC", "\u092e\u094b\u0928\u093e\u0915\u094b" },
            { "MD", "\u092e\u0949\u0932\u094d\u0921\u094b\u0935\u093e" },
            { "ME", "\u092e\u094b\u0902\u091f\u0947\u0928\u0947\u0917\u094d\u0930\u094b" },
            { "MF", "\u0938\u0947\u0902\u091f \u092e\u093e\u0930\u094d\u091f\u093f\u0928" },
            { "MG", "\u092e\u0947\u0921\u093e\u0917\u093e\u0938\u094d\u0915\u0930" },
            { "MH", "\u092e\u093e\u0930\u094d\u0938\u0932 \u0926\u094d\u0935\u0940\u092a" },
            { "MK", "\u0909\u0924\u0949\u0930\u0949 \u092e\u0915\u0926\u0942\u0928\u093f\u092f\u093e" },
            { "ML", "\u092e\u093e\u0932\u0940" },
            { "MM", "\u092e\u094d\u092f\u093e\u0902\u092e\u093e\u0930 (\u092c\u0930\u094d\u092e\u093e)" },
            { "MN", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e" },
            { "MO", "\u092e\u0915\u093e\u090a (\u090f\u0938 \u090f \u0906\u0930 \u091a\u0940\u0928)" },
            { "MP", "\u0909\u0924\u0949\u0930\u0949 \u092e\u093e\u0930\u093f\u092f\u093e\u0928\u093e \u0926\u094d\u0935\u0940\u092a" },
            { "MQ", "\u092e\u093e\u0930\u094d\u091f\u0940\u0928\u093f\u0915" },
            { "MR", "\u092e\u0949\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e" },
            { "MS", "\u092e\u094b\u0902\u091f\u0938\u0947\u0930\u093e\u0924" },
            { "MT", "\u092e\u093e\u0932\u094d\u091f\u093e" },
            { "MU", "\u092e\u0949\u0930\u0940\u0938\u0938" },
            { "MV", "\u092e\u093e\u0932\u0926\u0940\u092a" },
            { "MW", "\u092e\u0932\u093e\u0935\u0940" },
            { "MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b" },
            { "MY", "\u092e\u0932\u0947\u0938\u093f\u092f\u093e" },
            { "MZ", "\u092e\u094b\u091c\u093c\u093e\u0902\u092c\u093f\u0915" },
            { "NA", "\u0928\u093e\u092e\u0940\u092c\u093f\u092f\u093e" },
            { "NC", "\u0928\u094d\u092f\u0942 \u0915\u0947\u0932\u0947\u0921\u094b\u0928\u093f\u092f\u093e" },
            { "NE", "\u0928\u093e\u0907\u091c\u0930" },
            { "NF", "\u0928\u0949\u0930\u092a\u093c\u0949\u0915 \u0926\u094d\u0935\u0940\u092a" },
            { "NG", "\u0928\u093e\u0907\u091c\u0940\u0930\u093f\u092f\u093e" },
            { "NI", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0906" },
            { "NL", "\u0928\u0940\u0926\u0930\u0932\u0947\u0902\u0921" },
            { "NO", "\u0928\u0949\u0930\u094d\u0935\u0947" },
            { "NP", "\u0928\u0947\u092a\u093e\u0932" },
            { "NR", "\u0928\u093e\u0909\u0930\u0941" },
            { "NU", "\u0928\u0940\u092f\u0942" },
            { "NZ", "\u0928\u094d\u092f\u0942\u091c\u093c\u0940\u0932\u0947\u0902\u0921" },
            { "OM", "\u0913\u092e\u093e\u0928" },
            { "PA", "\u092a\u0928\u093e\u092e\u093e" },
            { "PE", "\u092a\u0947\u0930\u0942" },
            { "PF", "\u092a\u093c\u094d\u0930\u0947\u0902\u091a \u092a\u094b\u0932\u093f\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "PG", "\u092a\u093e\u092a\u0941\u0906 \u0928\u094d\u092f\u0942 \u0917\u093f\u0928\u0940" },
            { "PH", "\u092a\u093c\u093f\u0932\u093f\u092a\u0940\u0902\u0938" },
            { "PK", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "PL", "\u092a\u094b\u0932\u0947\u0902\u0921" },
            { "PM", "\u0938\u0947\u0902\u091f \u092a\u093f\u090f\u0930\u0947 \u0911\u0921\u093c\u0947 \u092e\u093f\u0915\u094d\u0935\u0947\u0932\u093e\u0928" },
            { "PN", "\u092a\u093f\u091f\u0915\u0947\u0930\u094d\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "PR", "\u092a\u094b\u0930\u094d\u091f\u094b \u0930\u093f\u0915\u094b" },
            { "PS", "\u092a\u093c\u093f\u0932\u093f\u0938\u094d\u0924\u0940\u0928\u0940 \u0915\u094d\u0937\u0947\u0924\u094d\u0930" },
            { "PT", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932" },
            { "PW", "\u092a\u0932\u093e\u090a" },
            { "PY", "\u092a\u0930\u093e\u0917\u094d\u0935\u0947" },
            { "QA", "\u0915\u093c\u0924\u0930" },
            { "RE", "\u0930\u093f\u092f\u0942\u0928\u093f\u092f\u0928" },
            { "RO", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e" },
            { "RS", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e" },
            { "RU", "\u0930\u0942\u0938" },
            { "RW", "\u0930\u094d-\u0935\u093e\u0902\u0921\u093e" },
            { "SA", "\u0938\u090a\u0926\u0940 \u0905\u0930\u092c" },
            { "SB", "\u0938\u094b\u0932\u094b\u092e\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "SC", "\u0938\u0947\u0938\u0947\u0932\u094d\u0938" },
            { "SD", "\u0938\u0942\u0921\u093e\u0928" },
            { "SE", "\u0938\u094d\u0935\u0940\u0921\u0928" },
            { "SG", "\u0938\u093f\u0902\u0917\u093e\u092a\u0941\u0930" },
            { "SH", "\u0938\u0947\u0902\u091f \u0939\u0947\u0932\u0947\u0928\u093e" },
            { "SI", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e" },
            { "SJ", "\u0938\u094d\u0935\u093e\u0932\u092c\u093e\u0930\u094d\u0921 \u0911\u0921\u093c\u0947 \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928" },
            { "SK", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915\u093f\u092f\u093e" },
            { "SL", "\u0938\u093f\u090f\u0930\u093e \u0932\u093f\u092f\u094b\u0928" },
            { "SM", "\u0938\u0947\u0928 \u092e\u0947\u0930\u0940\u0928\u094b" },
            { "SN", "\u0938\u0947\u0928\u0947\u0917\u0932" },
            { "SO", "\u0938\u094b\u092e\u093e\u0932\u093f\u092f\u093e" },
            { "SR", "\u0938\u0942\u0930\u0940\u0928\u093e\u092e" },
            { "SS", "\u0926\u0949\u0915\u093f\u0923 \u0938\u0942\u0921\u093e\u0928" },
            { "ST", "\u0938\u093e\u0913 \u091f\u094b\u092e \u0911\u0921\u093c\u0947 \u092a\u094d\u0930\u093f\u0902\u0938\u093f\u092a\u0947" },
            { "SV", "\u0905\u0932 \u0938\u0932\u094d\u0935\u093e\u0921\u094b\u0930" },
            { "SX", "\u0938\u093f\u0902\u091f \u092e\u093e\u093d\u0930\u0924\u0947\u0928" },
            { "SY", "\u0938\u0940\u0930\u093f\u092f\u093e" },
            { "SZ", "\u090f\u0938\u094d\u0935\u093e\u091f\u093f\u0928\u0940" },
            { "TC", "\u0924\u0941\u0930\u094d\u0915 \u0911\u0921\u093c\u0947 \u0915\u0947\u0915\u094b\u091c\u093c \u0926\u094d\u0935\u0940\u092a" },
            { "TD", "\u091a\u093e\u0921" },
            { "TF", "\u092a\u094d\u0930\u0947\u0902\u091a \u0926\u0915\u093f\u0928\u0940 \u091f\u0947\u0930\u093f\u091f\u094b\u0930\u0940" },
            { "TG", "\u091f\u094b\u0917\u094b" },
            { "TH", "\u0924\u093e\u0908\u0932\u0947\u0902\u0921" },
            { "TJ", "\u0924\u091c\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TK", "\u0924\u094b\u0915\u0947\u0932\u093e\u0909" },
            { "TL", "\u0924\u093f\u092e\u094b\u0930-\u0932\u0947\u0938\u094d\u0924" },
            { "TM", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TN", "\u091f\u094d\u092f\u0942\u0928\u0940\u0938\u093f\u092f\u093e" },
            { "TO", "\u091f\u094b\u0902\u0917\u093e" },
            { "TR", metaValue_TR },
            { "TT", "\u0924\u094d\u0930\u093f\u0928\u093f\u0926\u093e\u0926 \u0911\u0921\u093c\u0947 \u091f\u094b\u092c\u0947\u0917\u094b" },
            { "TV", "\u0924\u0941\u0935\u093e\u0932\u0942" },
            { "TW", "\u0924\u093e\u0907\u0935\u093e\u0928" },
            { "TZ", "\u0924\u0902\u091c\u093c\u093e\u0928\u093f\u092f\u093e" },
            { "UA", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928" },
            { "UG", "\u092f\u0941\u0917\u093e\u0902\u0921\u093e" },
            { "UM", "\u092f\u0942\u0970\u090f\u0938\u0970 \u0906\u0909\u091f\u0932\u093e\u0907\u0902\u0917 \u0926\u094d\u0935\u0940\u092a" },
            { "US", "\u0906\u0923\u094d\u0921\u093f \u0924\u093f \u0930\u093e\u091c\u094d\u092f\u0949" },
            { "UY", "\u0909\u0930\u0942\u0917\u094d\u0935\u0947" },
            { "UZ", "\u0909\u091c\u093c\u094d\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "VA", "\u092c\u093e\u091f\u093f\u0915\u093e\u0928 \u0938\u093f\u091f\u0940" },
            { "VC", "\u0938\u0947\u0902\u091f \u0935\u093f\u0902\u0938\u0947\u0902\u091f \u0911\u0921\u093c\u0947 \u0917\u094d\u0930\u0947\u0928\u093e\u0921\u093e\u0907\u0902\u0938" },
            { "VE", "\u0935\u0947\u0928\u0947\u091c\u093c\u0941\u090f\u0932\u093e" },
            { "VG", "\u092c\u094d\u0930\u093f\u091f\u093f\u0938 \u0935\u0930\u094d\u091c\u093f\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "VI", "\u092f\u0942\u0970\u090f\u0938\u0970 \u0935\u0930\u094d\u091c\u093f\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "VN", "\u0935\u093f\u092f\u0924\u0928\u093e\u092e" },
            { "VU", "\u0935\u0928\u0941\u0906\u0924\u0942" },
            { "WF", "\u0935\u093e\u0932\u093f\u0938 \u0911\u0921\u093c\u0947 \u092a\u093c\u094d\u092f\u0942\u091a\u0942\u0928\u093e" },
            { "WS", "\u0938\u092e\u094b\u0906" },
            { "XK", "\u0915\u094b\u0938\u094b\u0935\u094b" },
            { "YE", "\u092f\u092e\u0928" },
            { "YT", "\u092e\u093e\u092f\u094b\u0924\u0947" },
            { "ZA", "\u0926\u0949\u0915\u093f\u0923 \u0906\u092a\u093c\u094d\u0930\u0940\u0915\u093e" },
            { "ZM", "\u091c\u093c\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "ZW", "\u091c\u093c\u093f\u092e\u094d\u092c\u093e\u092c\u094d\u0935\u0947" },
            { "af", "\u0906\u092a\u094d\u0930\u093f\u0915\u093e\u0928\u094d\u0938" },
            { "am", "\u0905\u092e\u094d\u0939\u0947\u0930\u0940" },
            { "ar", "\u0906\u0930\u0949\u092c\u093f\u0915" },
            { "as", "\u0906\u0938\u093e\u092e\u0940\u0938\u094d" },
            { "az", "\u0905\u091c\u093c\u0930\u092c\u0947\u091c\u093e\u0928\u0940" },
            { "be", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938\u0940" },
            { "bg", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e\u0924\u093f" },
            { "bn", metaValue_bn },
            { "bo", "\u0924\u093f\u092c\u094d\u092c\u0924\u0940" },
            { "bs", "\u092c\u093e\u0945\u0938\u094d\u0928\u093f\u092f\u093e\u0924\u0940" },
            { "ca", "\u0915\u093e\u0924\u093e\u0932\u093e\u0928" },
            { "cs", "\u091a\u0947\u0915" },
            { "da", "\u0921\u0947\u0928\u093f\u0938" },
            { "de", "\u091c\u0930\u094d\u092e\u0928" },
            { "el", "\u0917\u094d\u0930\u0940\u0915" },
            { "en", "\u0907\u0902\u0930\u093e\u091c\u0940" },
            { "es", "\u0938\u094d\u092a\u093e\u0928\u093f\u0938" },
            { "et", "\u090f\u0938\u094d\u091f\u094b\u0928\u093f\u092f\u093e\u0924\u093f" },
            { "eu", "\u092c\u093e\u0938\u094d\u0915" },
            { "fa", "\u092a\u0930\u094d\u0938\u093f\u092f\u0928" },
            { "fi", "\u092a\u093c\u093f\u0928\u093f\u0938" },
            { "fr", "\u092a\u093c\u094d\u0930\u0947\u0902\u091a" },
            { "gl", "\u0917\u094d\u092f\u093e\u0932\u093f\u0938\u093f\u092f\u0928" },
            { "gu", "\u0917\u0941\u091c\u0930\u093e\u091f\u0940" },
            { "he", "\u0939\u093f\u092c\u094d\u0930\u0942" },
            { "hi", "\u0939\u093f\u0928\u094d\u0926\u0940" },
            { "hr", "\u0915\u094d\u0930\u094b\u090f\u0938\u093f\u092f\u093e\u0924\u093f" },
            { "hu", "\u0939\u0902\u0917\u0947\u0930\u093f\u092f\u093e\u0924\u093f" },
            { "hy", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0924\u093f" },
            { "id", "\u0907\u0902\u0921\u094b\u0928\u0947\u0938\u093f\u092f\u093e\u0924\u093f" },
            { "is", "\u0906\u0907\u0938\u0932\u0947\u0902\u0921 \u093f\u0915" },
            { "it", "\u0907\u0924\u093e\u0932\u0940 \u0924\u0940" },
            { "ja", "\u091c\u093e\u092a\u093e\u0928\u0940\u091c" },
            { "ka", "\u091c\u0949\u0930\u094d\u091c\u093f\u092f\u093e\u0924\u093f" },
            { "kk", "\u0915\u091c\u093c\u093e\u0915\u093c" },
            { "km", "\u0915\u092e\u0947\u0930" },
            { "kn", metaValue_kn },
            { "ko", "\u0915\u094b\u0930\u093f\u092f\u093e\u0924\u093f" },
            { "ks", "\u0915\u0938\u094d\u092e\u0940\u0930\u0940" },
            { "ky", "\u0915\u093f\u0930\u094d\u0917\u0940\u091c\u093c" },
            { "lo", "\u0932\u093e\u0913" },
            { "lt", "\u0932\u093f\u0924\u0941\u0906\u0928\u093f\u092f\u093e\u0924\u093f" },
            { "lv", "\u0932\u093e\u0924\u0935\u093f\u092f\u093e\u0924\u093f" },
            { "mk", "\u092e\u0915\u0926\u0942\u0928\u093f\u092f\u093e\u0924\u093f" },
            { "ml", metaValue_ml },
            { "mn", "\u092e\u0902\u0917\u094b\u0932\u093f\u092f\u093e\u0924\u093f" },
            { "mr", "\u092e\u0930\u093e\u0920\u0940" },
            { "ms", "\u092e\u0932\u092f" },
            { "my", "\u092c\u0930\u094d\u092e\u0940\u091c\u093c" },
            { "nb", "\u0928\u0949\u0930\u094d\u0935\u0947\u091c\u093f\u092f\u093e\u0924\u093f \u092c\u094b\u0915\u092e\u093e\u0932" },
            { "ne", "\u0928\u0947\u092a\u093e\u0932\u0940" },
            { "nl", "\u0921\u091a" },
            { "or", "\u0909\u0921\u093c\u093f\u092f\u093e" },
            { "pa", "\u092a\u0902\u091c\u093e\u092c\u0940" },
            { "pl", "\u092a\u094b\u0932\u093f\u0938" },
            { "pt", "\u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "ro", "\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e\u0924\u093f" },
            { "ru", "\u0930\u0941\u0938\u093f\u092f\u093e \u0924\u093f" },
            { "sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924" },
            { "sd", "\u0938\u093f\u0902\u0927\u0940" },
            { "si", "\u0938\u093f\u0902\u0939\u0932\u0940" },
            { "sk", "\u0938\u094d\u0932\u094b\u0935\u093e\u0915" },
            { "sl", "\u0938\u094d\u0932\u094b\u0935\u0947\u0928\u093f\u092f\u093e\u0924\u093f" },
            { "sq", "\u0905\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0924\u093f" },
            { "sr", "\u0938\u0930\u094d\u092c\u093f\u092f\u093e\u0924\u093f" },
            { "sv", "\u0938\u094d\u0935\u0940\u0921\u093f\u0938" },
            { "sw", "\u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "th", "\u0924\u093e\u0908" },
            { "tr", metaValue_TR },
            { "uk", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928\u093f\u092f\u093e\u0924\u093f" },
            { "ur", "\u0909\u0930\u094d\u0926\u0942" },
            { "uz", "\u0909\u091c\u093c\u094d\u092c\u0947\u0915" },
            { "vi", "\u0935\u093f\u092f\u0924\u0928\u093e\u092e\u0940" },
            { "zh", "\u091a\u0940\u0928\u0940" },
            { "zu", "\u091c\u093c\u0941\u0932\u0942" },
            { "brx", "\u092c\u094b\u0921\u094b" },
            { "chr", metaValue_chr },
            { "doi", "\u0921\u094b\u0917\u0930\u0940" },
            { "fil", "\u092a\u093c\u093f\u0932\u093f\u092a\u0940\u0928\u094b" },
            { "kok", "\u0915\u094b\u0902\u0915\u0923\u0940" },
            { "kxv", "\u0915\u0941\u0935\u093f" },
            { "mai", "\u092e\u0947\u0924\u093f\u0932\u0940" },
            { "mni", "\u092e\u0923\u093f\u092a\u0941\u0930\u0940" },
            { "sat", "\u0938\u0902\u0924\u093e\u0932\u0940" },
            { "Arab", "\u0905\u0930\u092c\u0940" },
            { "Beng", metaValue_bn },
            { "Brah", "\u092c\u094d\u0930\u093e\u0939\u094d\u092e\u093f" },
            { "Cher", metaValue_chr },
            { "Cyrl", "\u0938\u093f\u0930\u093f\u0932\u093f\u0915" },
            { "Deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940" },
            { "Gujr", "\u0917\u0941\u091c\u0930\u093e\u0924\u0940" },
            { "Guru", "\u0917\u0941\u0930\u092e\u0941\u0915\u0940" },
            { "Hans", "\u0938\u093e\u0945\u0939\u093e\u0945\u091c\u093e\u0945" },
            { "Hant", "\u0939\u093f\u0930\u0942\u0926\u094b\u0932\u094d\u0932\u0941" },
            { "Knda", metaValue_kn },
            { "Latn", "\u0932\u093e\u0924\u093f\u0928" },
            { "Mlym", metaValue_ml },
            { "Orya", "\u0911\u0921\u093c\u093f\u092f\u093e" },
            { "Saur", "\u0938\u0949\u0909\u0930\u093e\u0937\u094d\u091f\u094d\u0930" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Zxxx", "\u0930\u093e\u091a\u093e-\u0906-\u0906\u0924\u094d\u0924\u093f" },
            { "Zzzz", "\u092a\u0941\u0923\u094d-\u0906\u0901\u093d\u0924\u093f \u0911\u0915\u093e\u0945\u0930\u093e\u0945" },
            { "de_AT", "\u0911\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e\u0924\u093f \u091c\u0930\u094d\u092e\u0928" },
            { "de_CH", "\u0938\u094d\u0935\u093f\u0938 \u0939\u093e\u0907 \u0924\u093f \u091c\u0930\u094d\u092e\u0928" },
            { "en_AU", "\u0911\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0924\u093f \u0907\u0902\u0930\u093e\u091c\u0940" },
            { "en_CA", "\u0915\u0928\u093e\u0921\u093e\u0924\u093f \u0907\u0902\u0930\u093e\u091c\u0940" },
            { "en_GB", "\u092c\u094d\u0930\u093f\u091f\u093f\u0938 \u0907\u0902\u0930\u093e\u091c\u0940" },
            { "en_US", "\u0905\u092e\u0947\u0930\u093f\u0915\u0940 \u0907\u0902\u0930\u093e\u091c\u0940" },
            { "es_ES", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u0924\u093f \u0938\u094d\u092a\u0947\u0928\u093f\u0938" },
            { "es_MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u094b \u0924\u093f \u0938\u094d\u092a\u0947\u0928\u093f\u0938" },
            { "fa_AF", "\u0921\u0949\u0930\u093f" },
            { "fr_CA", "\u0915\u0928\u093e\u0921\u093e\u0924\u093f \u092a\u093c\u094d\u0930\u0947\u0902\u091a" },
            { "fr_CH", "\u0938\u094d\u0935\u093f\u0938 \u092a\u093c\u094d\u0930\u0947\u0902\u091a" },
            { "nl_BE", "\u092a\u093c\u094d\u0932\u0947\u092e\u093f\u0938" },
            { "pt_BR", "\u092c\u094d\u0930\u093e\u091c\u093c\u0940\u0932\u0940 \u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "pt_PT", "\u092f\u0942\u0930\u094b\u092a\u0940\u092f \u092a\u0941\u0930\u094d\u0924\u0917\u093e\u0932\u0940" },
            { "ro_MD", "\u092e\u094b\u0932\u0921\u093e\u0935\u093f\u092f\u0928" },
            { "sw_CD", "\u0915\u093e\u0902\u0917\u094b \u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "ar_001", "\u092a\u0941\u0928\u093f\u091c\u0941\u0917\u094b \u092e\u093e\u0928\u093e\u0902\u0915\u0949 \u0906\u0930\u0949\u092c\u093f\u0915" },
            { "es_419", "\u0932\u093e\u0924\u093f\u0928 \u0906\u092e\u0947\u0930\u093f\u0915\u093e \u0924\u093f \u0938\u094d\u092a\u0947\u0928\u093f\u0938" },
            { "key.ca", "\u0915\u0947\u0932\u0947\u0902\u0921\u0930" },
            { "key.cf", "\u091f\u093e\u0915\u093e\u0901 \u092a\u0949\u0930\u0949\u092e\u093e\u091f\u094b" },
            { "key.co", "\u092e\u093f\u0932\u093e \u0915\u094d\u0930\u0949\u092e\u0949" },
            { "key.cu", "\u091f\u093e\u0915\u093e\u0901" },
            { "key.hc", "\u0935\u0947\u0921\u093c\u093e\u0924\u093f \u0917\u093f\u0932\u093e (\u0967\u0968 \u0911\u0921\u093c\u0947 \u0968\u096a)" },
            { "key.lb", "\u0927\u093e\u0921\u093c\u0940 \u0932\u093f\u0928\u0940 \u0906\u0921\u093c\u093e" },
            { "key.ms", "\u0932\u093e\u091f\u093f\u0928\u093f \u0932\u0947\u0915\u093e" },
            { "key.nu", "\u0938\u0949\u0919\u094d\u0915\u094d\u092f\u093e" },
            { "hi_Latn", "\u0939\u093f\u0928\u094d\u0926\u0940 (\u0932\u093e\u0924\u093f\u0928)" },
            { "zh_Hans", "\u0938\u093e\u0945\u0939\u093e\u0945\u091c\u093e\u0945 \u091a\u0940\u0928\u0940" },
            { "zh_Hant", "\u0939\u093f\u0930\u0942\u0926\u094b\u0932\u094d\u0932\u0941 \u091a\u0940\u0928\u0940" },
            { "type.hc.h11", "\u0967\u0968 \u0917\u0949\u0928\u094d\u0924\u093e \u0924\u093f \u092a\u0949\u0926\u094d\u0926\u0949\u0924\u093f (0\u2013\u0967\u0967)" },
            { "type.hc.h12", "\u0967\u0968 \u0917\u0949\u0928\u094d\u0924\u093e \u0924\u093f \u092a\u0949\u0926\u094d\u0926\u0949\u0924\u093f (\u0967\u2013\u0967\u0968)" },
            { "type.hc.h23", "\u0968\u096a \u0917\u0949\u0928\u094d\u0924\u093e \u0924\u093f \u092a\u0949\u0926\u094d\u0926\u0949\u0924\u093f (0\u2013\u0968\u0969)" },
            { "type.hc.h24", "\u0968\u096a \u0917\u0949\u0928\u094d\u0924\u093e \u0924\u093f \u092a\u0949\u0926\u094d\u0926\u0949\u0924\u093f (\u0967\u2013\u0968\u096a)" },
            { "type.nu.arab", "\u0906\u0930\u0949\u092c\u093f\u0915-\u092c\u093e\u0930\u0924\u0940\u092f \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.beng", "\u092c\u0902\u0917\u093e\u0932\u0940 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.deva", "\u0926\u0947\u0935\u0928\u093e\u0917\u0930\u0940 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.gujr", "\u0917\u0941\u091c\u0930\u093e\u0924\u0940 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.guru", "\u0917\u0941\u0930\u092e\u0941\u0915\u0940 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.knda", "\u0915\u0928\u094d\u0928\u0921\u093c \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.latn", "\u0935\u0947\u0921\u093c\u093e \u0915\u0941\u0923\u094d\u092a\u0941 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.mlym", "\u092e\u0932\u092f\u093e\u0932\u092e \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.orya", "\u0911\u0921\u093c\u093f\u092f\u093e \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.taml", "\u0939\u093f\u0930\u0942\u0926\u094b\u0932\u094d\u0932\u0941 \u0924\u093e\u092e\u093f\u0932 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.telu", "\u0924\u0947\u0932\u0941\u0917\u0942 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.co.ducet", "\u0921\u093f\u092a\u093c\u0949\u0932\u094d\u091f \u092f\u0942\u0928\u093f\u0915\u094b\u0921 \u0938\u0949\u0930\u094d\u091f \u0932\u0947\u0901" },
            { "type.nu.roman", "\u0930\u094b\u092e\u0928 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.ca.indian", "\u092c\u093e\u0930\u0949\u0924\u0949 \u091c\u093e\u0924\u093f\u092f\u0949 \u0915\u0947\u0932\u0947\u0902\u0921\u0930" },
            { "type.co.search", "\u0938\u093e\u092e\u093e\u0928\u093f-\u0909\u0926\u094d\u0926\u0947\u0938\u094d\u092f \u092a\u093e\u0930\u093f\u0928\u0949" },
            { "type.ms.metric", "\u092e\u0947\u091f\u094d\u0930\u093f\u0915 \u092a\u0949\u0926\u094d\u0926\u0949\u0924\u093f" },
            { "type.nu.arabext", "\u0928\u0949\u0915\u093f-\u0906\u0924\u093f \u0906\u0930\u0949\u092c\u093f\u0915-\u092c\u093e\u0930\u0924\u0940\u092f \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.nu.tamldec", "\u0924\u093e\u092e\u093f\u0932 \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.cf.standard", "\u092e\u093e\u0928\u093e\u0902\u0915\u0949 \u091f\u093e\u0915\u093e\u0901 \u0930\u0941\u092a\u0949" },
            { "type.co.standard", "\u092e\u093e\u0928\u093e\u0902\u0915\u0949 \u0938\u0949\u0930\u094d\u091f \u0932\u0947\u0901" },
            { "type.ms.uksystem", "\u0938\u093e\u092e\u0930\u093e\u091c\u094d\u092f\u0949 \u0924\u093f \u0906\u091f\u093f\u0928\u093f \u092e\u093e\u092a\u0949 \u092a\u0949\u0926\u094d\u0926\u0949\u0924\u093f" },
            { "type.ms.ussystem", "\u0906\u092e\u0947\u0930\u093f\u0915\u093e \u0924\u093f \u092e\u093e\u092a\u0949 \u092a\u0949\u0926\u094d\u0926\u0949\u0924\u093f" },
            { "type.nu.romanlow", "\u0930\u094b\u092e\u0928 \u092e\u093f\u0932\u093e \u0917\u093f\u0930\u093e \u0928\u0949\u092e\u094d\u092c\u0930" },
            { "type.ca.gregorian", "\u0917\u094d\u0930\u0947\u0917\u094b\u0930\u093f\u092f\u0928 \u0915\u0947\u0932\u0947\u0902\u0921\u0930" },
            { "type.co.phonebook", "\u092b\u0949\u0928\u094d-\u0935\u0949\u0939\u093f \u0938\u0949\u0930\u094d\u091f \u0932\u0947\u0901" },
        };
        return data;
    }
}
