/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.HashMap;
import oracle.jdbc.internal.Monitor;
import oracle.net.ns.NetException;
import oracle.net.resolver.NameResolver;

public class NameResolverFactory {
    private static HashMap resolverMap = new HashMap();
    private static final String TNS_ADMIN_PROPERTY = "oracle.net.tns_admin";
    private static final boolean DEBUG = false;
    private static Monitor RESOLVER_MAP_MONITOR = Monitor.newInstance();

    public static NameResolver getNameResolver(String tnsAdmin, String osuser, String programName) throws NetException {
        String trcHdr = "NameResolver.getNameResolver: ";
        if (tnsAdmin != null) {
            tnsAdmin = tnsAdmin.trim();
        }
        if (tnsAdmin != null && tnsAdmin.length() == 0) {
            throw new NetException(17869);
        }
        try (Monitor.CloseableLock lock = RESOLVER_MAP_MONITOR.acquireCloseableLock();){
            NameResolver nr = (NameResolver)resolverMap.get(tnsAdmin);
            if (nr == null) {
                nr = new NameResolver(tnsAdmin, osuser, programName);
                resolverMap.put(tnsAdmin, nr);
            }
            NameResolver nameResolver = nr;
            return nameResolver;
        }
    }
}

