/*
 *     Copyright (c) 2024, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 *
 */

#ifndef __NVHPC_DECLARATIONS
#define __NVHPC_DECLARATIONS

#ifdef __cplusplus
extern "C" {
#endif

extern __device__ unsigned long long int atomicCAS(unsigned long long int *address, unsigned long long int compare, unsigned long long int val);
extern __device__ int __pgi_atomicAddi(void *address, int val);
extern __device__ unsigned int __pgi_atomicAddu(void *address, unsigned int val);
extern __device__ float __pgi_atomicAddf(void *address, float val);
extern __device__ double __pgi_atomicAddd(void *address, double val);
extern __device__ int __pgi_atomicMuli(void *address, int val);
extern __device__ float __pgi_atomicMulf(void *address, float val);
extern __device__ double __pgi_atomicMuld(void *address, double val);
extern __device__ int __pgi_atomicMaxi(void *address, int val);
extern __device__ unsigned int __pgi_atomicMaxu(void *address, unsigned int val);
extern __device__ long long __pgi_atomicMaxil(void *address, long long val);
extern __device__ unsigned long long __pgi_atomicMaxul(void *address, unsigned long long val);
extern __device__ float __pgi_atomicMaxf(void *address, float val);
extern __device__ double __pgi_atomicMaxd(void *address, double val);
extern __device__ int __pgi_atomicMini(void *address, int val);
extern __device__ unsigned int __pgi_atomicMinu(void *address, unsigned int val);
extern __device__ long long __pgi_atomicMinil(void *address, long long val);
extern __device__ unsigned long long __pgi_atomicMinul(void *address, unsigned long long val);
extern __device__ float __pgi_atomicMinf(void *address, float val);
extern __device__ double __pgi_atomicMind(void *address, double val);
extern __device__ int __pgi_atomicAndi(void *address, int val);
extern __device__ unsigned int __pgi_atomicAndu(void *address, unsigned int val);
extern __device__ long long __pgi_atomicAndil(void *address, long long val);
extern __device__ int __pgi_atomicOri(void *address, int val);
extern __device__ unsigned int __pgi_atomicOru(void *address, unsigned int val);
extern __device__ long long __pgi_atomicOril(void *address, long long val);
extern __device__ int __pgi_atomicXori(void *address, int val);
extern __device__ unsigned int __pgi_atomicXoru(void *address, unsigned int val);
extern __device__ long long __pgi_atomicXoril(void *address, long long val);
extern __device__ unsigned long long __pgi_atomicXorul(void *address, unsigned long long val);
extern __device__ int omp_get_thread_num(void);
extern __device__ float __pgi_atomicCASf(void *address, float val, float val2);
extern __device__ long long __pgi_atomicCASil(void *address, long long val, long long val2);
extern __device__ double __pgi_atomicCASd(void *address, double val, double val2);

#ifdef __cplusplus
}
#endif

#endif /* __NVHPC_DECLARATIONS */
