/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.protocol.oid4vc.model.ClaimsDescription;
import org.keycloak.utils.StringUtil;

public class ClaimsPathPointer {
    private static final Logger logger = Logger.getLogger(ClaimsPathPointer.class);

    public static boolean isValidPath(List<Object> path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        for (Object component : path) {
            if (component == null) continue;
            if (component instanceof String) {
                if (!StringUtil.isBlank((String)((String)component))) continue;
                return false;
            }
            if (component instanceof Integer) {
                Integer index = (Integer)component;
                if (index >= 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean validateClaimsDescriptions(List<ClaimsDescription> claims) {
        if (claims == null || claims.isEmpty()) {
            return true;
        }
        for (int i = 0; i < claims.size(); ++i) {
            for (int j = i + 1; j < claims.size(); ++j) {
                ClaimsDescription claim2;
                ClaimsDescription claim1 = claims.get(i);
                if (!ClaimsPathPointer.isConflicting(claim1, claim2 = claims.get(j))) continue;
                logger.warnf("Conflicting claims descriptions found: %s and %s", claim1.getPath(), claim2.getPath());
                return false;
            }
        }
        return true;
    }

    private static boolean isConflicting(ClaimsDescription claim1, ClaimsDescription claim2) {
        List<Object> path1 = claim1.getPath();
        List<Object> path2 = claim2.getPath();
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.equals(path2)) {
            return true;
        }
        return ClaimsPathPointer.hasArrayObjectConflict(path1, path2);
    }

    private static boolean hasArrayObjectConflict(List<Object> path1, List<Object> path2) {
        int minLength = Math.min(path1.size(), path2.size());
        for (int i = 0; i < minLength; ++i) {
            Object comp1 = path1.get(i);
            Object comp2 = path2.get(i);
            if (comp1 == null && comp2 instanceof String) {
                return true;
            }
            if (comp2 == null && comp1 instanceof String) {
                return true;
            }
            if (comp1 == null && comp2 instanceof Integer) {
                return true;
            }
            if (comp2 == null && comp1 instanceof Integer) {
                return true;
            }
            if (!Objects.equals(comp1, comp2)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> filterClaimsByAuthorizationDetails(Map<String, Object> allClaims, List<ClaimsDescription> requestedClaims) {
        if (requestedClaims == null || requestedClaims.isEmpty()) {
            return allClaims;
        }
        HashMap<String, Object> filteredClaims = new HashMap<String, Object>();
        for (ClaimsDescription claim : requestedClaims) {
            List<Object> path = claim.getPath();
            if (path == null || path.isEmpty()) continue;
            if (!ClaimsPathPointer.isValidPath(path)) {
                logger.warnf("Invalid claims path pointer: %s. Path must contain only strings, non-negative integers, and null values.", path);
                continue;
            }
            try {
                List<Object> claimValues = ClaimsPathPointer.processClaimsPathPointer(allClaims, path);
                if (!claimValues.isEmpty()) {
                    if (claimValues.size() == 1) {
                        ClaimsPathPointer.addClaimByPath(filteredClaims, path, claimValues.get(0));
                        continue;
                    }
                    ClaimsPathPointer.addMultipleClaimsByPath(filteredClaims, path, claimValues);
                    continue;
                }
                if (!Boolean.TRUE.equals(claim.getMandatory())) continue;
                throw new IllegalArgumentException("Mandatory claim not found: " + String.valueOf(path));
            }
            catch (IllegalArgumentException e) {
                if (Boolean.TRUE.equals(claim.getMandatory())) {
                    logger.warnf("Failed to process mandatory claim path %s: %s", path, (Object)e.getMessage());
                    throw e;
                }
                logger.debugf("Failed to process optional claim path %s: %s", path, (Object)e.getMessage());
            }
        }
        return filteredClaims;
    }

    public static List<Object> processClaimsPathPointer(Map<String, Object> claims, List<Object> path) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Claims path pointer must be a non-empty array");
        }
        if (claims == null) {
            throw new IllegalArgumentException("Claims map cannot be null");
        }
        ArrayList<Object> currentSelection = new ArrayList<Object>();
        currentSelection.add(claims);
        for (Object component : path) {
            if (currentSelection.isEmpty()) {
                throw new IllegalArgumentException("No elements currently selected, cannot process further");
            }
            ArrayList<Object> nextSelection = new ArrayList<Object>();
            for (Object e : currentSelection) {
                if (component instanceof String) {
                    Map map;
                    Object value;
                    if (!(e instanceof Map) || (value = (map = (Map)e).get(component)) == null) continue;
                    nextSelection.add(value);
                    continue;
                }
                if (component instanceof Integer) {
                    List list;
                    int index = (Integer)component;
                    if (index < 0) {
                        throw new IllegalArgumentException("Negative integer values are not allowed in claims path pointer");
                    }
                    if (!(e instanceof List) || index >= (list = (List)e).size()) continue;
                    nextSelection.add(list.get(index));
                    continue;
                }
                if (component == null) {
                    if (!(e instanceof List)) continue;
                    List list = (List)e;
                    nextSelection.addAll(list);
                    continue;
                }
                throw new IllegalArgumentException("Invalid path component type: " + component.getClass().getSimpleName() + ". Only String, Integer, and null are allowed.");
            }
            currentSelection = nextSelection;
        }
        if (currentSelection.isEmpty()) {
            throw new IllegalArgumentException("No elements selected after processing claims path pointer");
        }
        return currentSelection;
    }

    private static void addMultipleClaimsByPath(Map<String, Object> claims, List<Object> path, List<Object> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (path.size() == 1 && path.get(0) instanceof String) {
            claims.put((String)path.get(0), values.get(0));
            return;
        }
        if (values.size() == 1) {
            ClaimsPathPointer.addClaimByPath(claims, path, values.get(0));
        } else {
            ClaimsPathPointer.createArrayStructureForMultipleValues(claims, path, values);
        }
    }

    private static void createArrayStructureForMultipleValues(Map<String, Object> claims, List<Object> path, List<Object> values) {
        ClaimsPathPointer.buildNestedStructure(claims, path, new ArrayList<Object>(values), true);
    }

    private static void addClaimByPath(Map<String, Object> claims, List<Object> path, Object value) {
        if (path == null || path.isEmpty() || claims == null) {
            return;
        }
        if (path.size() == 1 && path.get(0) instanceof String) {
            claims.put((String)path.get(0), value);
            return;
        }
        ClaimsPathPointer.buildNestedClaimStructure(claims, path, value);
    }

    private static void buildNestedClaimStructure(Map<String, Object> claims, List<Object> path, Object value) {
        ClaimsPathPointer.buildNestedStructure(claims, path, value, false);
    }

    private static void buildNestedStructure(Map<String, Object> claims, List<Object> path, Object value, boolean isArraySelection) {
        if (path.size() < 2) {
            return;
        }
        Object current = claims;
        String rootKey = (String)path.get(0);
        if (!(current instanceof Map)) {
            return;
        }
        Object rootMap = current;
        if (!rootMap.containsKey(rootKey)) {
            rootMap.put((String)rootKey, isArraySelection ? new ArrayList() : new HashMap());
        }
        current = rootMap.get(rootKey);
        for (int i = 1; i < path.size() - 1; ++i) {
            Object component = path.get(i);
            if (component instanceof String) {
                if (!(current instanceof Map)) {
                    return;
                }
                Map map = (Map)current;
                if (!map.containsKey(component)) {
                    map.put((String)component, new HashMap());
                }
                current = map.get(component);
                continue;
            }
            if (!(component instanceof Integer)) continue;
            if (!(current instanceof List)) {
                return;
            }
            List list = (List)current;
            int index = (Integer)component;
            while (list.size() <= index) {
                list.add(isArraySelection ? null : new HashMap());
            }
            current = list.get(index);
        }
        Object finalComponent = path.get(path.size() - 1);
        if (finalComponent instanceof String) {
            if (current instanceof Map) {
                Map map = (Map)current;
                map.put((String)finalComponent, value);
            }
        } else if (finalComponent instanceof Integer && current instanceof List) {
            List list = (List)current;
            int index = (Integer)finalComponent;
            while (list.size() <= index) {
                list.add(null);
            }
            list.set(index, value);
        }
    }
}

