/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl;

import io.github.dmlloyd.classfile.BufWriter;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantPool;
import io.github.dmlloyd.classfile.constantpool.ConstantPoolBuilder;
import io.github.dmlloyd.classfile.constantpool.PoolEntry;
import io.github.dmlloyd.classfile.impl.AbstractPoolEntry;
import io.github.dmlloyd.classfile.impl.ClassFileImpl;
import io.github.dmlloyd.classfile.impl.LabelContext;
import io.github.dmlloyd.classfile.impl.RawBytecodeHelper;
import java.util.Arrays;

public final class BufWriterImpl
implements BufWriter {
    private final ConstantPoolBuilder constantPool;
    private final ClassFileImpl context;
    private LabelContext labelContext;
    private final ClassEntry thisClass;
    private final int majorVersion;
    byte[] elems;
    int offset = 0;

    public BufWriterImpl(ConstantPoolBuilder constantPool, ClassFileImpl context) {
        this(constantPool, context, 64, null, 0);
    }

    public BufWriterImpl(ConstantPoolBuilder constantPool, ClassFileImpl context, int initialSize) {
        this(constantPool, context, initialSize, null, 0);
    }

    public BufWriterImpl(ConstantPoolBuilder constantPool, ClassFileImpl context, int initialSize, ClassEntry thisClass, int majorVersion) {
        this.constantPool = constantPool;
        this.context = context;
        this.elems = new byte[initialSize];
        this.thisClass = thisClass;
        this.majorVersion = majorVersion;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.constantPool;
    }

    public LabelContext labelContext() {
        return this.labelContext;
    }

    public void setLabelContext(LabelContext labelContext) {
        this.labelContext = labelContext;
    }

    @Override
    public boolean canWriteDirect(ConstantPool other) {
        return this.constantPool.canWriteDirect(other);
    }

    public ClassEntry thisClass() {
        return this.thisClass;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public ClassFileImpl context() {
        return this.context;
    }

    @Override
    public void writeU1(int x) {
        this.reserveSpace(1);
        this.elems[this.offset++] = (byte)x;
    }

    @Override
    public void writeU2(int x) {
        this.reserveSpace(2);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)(x >> 8);
        elems[offset + 1] = (byte)x;
        this.offset = offset + 2;
    }

    public void writeU1U1(int x1, int x2) {
        this.reserveSpace(2);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)x1;
        elems[offset + 1] = (byte)x2;
        this.offset = offset + 2;
    }

    public void writeU1U2(int u1, int u2) {
        this.reserveSpace(3);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)u1;
        elems[offset + 1] = (byte)(u2 >> 8);
        elems[offset + 2] = (byte)u2;
        this.offset = offset + 3;
    }

    public void writeU1U1U1(int x1, int x2, int x3) {
        this.reserveSpace(3);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)x1;
        elems[offset + 1] = (byte)x2;
        elems[offset + 2] = (byte)x3;
        this.offset = offset + 3;
    }

    public void writeU1U1U2(int x1, int x2, int x3) {
        this.reserveSpace(4);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)x1;
        elems[offset + 1] = (byte)x2;
        elems[offset + 2] = (byte)(x3 >> 8);
        elems[offset + 3] = (byte)x3;
        this.offset = offset + 4;
    }

    public void writeU1U2U2(int x1, int x2, int x3) {
        this.reserveSpace(5);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)x1;
        elems[offset + 1] = (byte)(x2 >> 8);
        elems[offset + 2] = (byte)x2;
        elems[offset + 3] = (byte)(x3 >> 8);
        elems[offset + 4] = (byte)x3;
        this.offset = offset + 5;
    }

    public void writeU2U1(int x1, int x2) {
        this.reserveSpace(3);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)(x1 >> 8);
        elems[offset + 1] = (byte)x1;
        elems[offset + 2] = (byte)x2;
        this.offset = offset + 3;
    }

    public void writeU2U2(int x1, int x2) {
        this.reserveSpace(4);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)(x1 >> 8);
        elems[offset + 1] = (byte)x1;
        elems[offset + 2] = (byte)(x2 >> 8);
        elems[offset + 3] = (byte)x2;
        this.offset = offset + 4;
    }

    public void writeU2U2U2(int x1, int x2, int x3) {
        this.reserveSpace(6);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)(x1 >> 8);
        elems[offset + 1] = (byte)x1;
        elems[offset + 2] = (byte)(x2 >> 8);
        elems[offset + 3] = (byte)x2;
        elems[offset + 4] = (byte)(x3 >> 8);
        elems[offset + 5] = (byte)x3;
        this.offset = offset + 6;
    }

    @Override
    public void writeInt(int x) {
        this.reserveSpace(4);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)(x >> 24);
        elems[offset + 1] = (byte)(x >> 16);
        elems[offset + 2] = (byte)(x >> 8);
        elems[offset + 3] = (byte)x;
        this.offset = offset + 4;
    }

    public void writeIntInt(int x1, int x2) {
        this.reserveSpace(8);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)(x1 >> 24);
        elems[offset + 1] = (byte)(x1 >> 16);
        elems[offset + 2] = (byte)(x1 >> 8);
        elems[offset + 3] = (byte)x1;
        elems[offset + 4] = (byte)(x2 >> 24);
        elems[offset + 5] = (byte)(x2 >> 16);
        elems[offset + 6] = (byte)(x2 >> 8);
        elems[offset + 7] = (byte)x2;
        this.offset = offset + 8;
    }

    @Override
    public void writeFloat(float x) {
        this.writeInt(Float.floatToIntBits(x));
    }

    @Override
    public void writeLong(long x) {
        this.reserveSpace(8);
        byte[] elems = this.elems;
        int offset = this.offset;
        elems[offset] = (byte)(x >> 56);
        elems[offset + 1] = (byte)(x >> 48);
        elems[offset + 2] = (byte)(x >> 40);
        elems[offset + 3] = (byte)(x >> 32);
        elems[offset + 4] = (byte)(x >> 24);
        elems[offset + 5] = (byte)(x >> 16);
        elems[offset + 6] = (byte)(x >> 8);
        elems[offset + 7] = (byte)x;
        this.offset = offset + 8;
    }

    @Override
    public void writeDouble(double x) {
        this.writeLong(Double.doubleToLongBits(x));
    }

    @Override
    public void writeBytes(byte[] arr) {
        this.writeBytes(arr, 0, arr.length);
    }

    public void writeBytes(BufWriterImpl other) {
        this.writeBytes(other.elems, 0, other.offset);
    }

    void writeUtfEntry(String str) {
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c > '\u0000' && c < '\u0080') {
                ++utflen;
                continue;
            }
            if (c < '\u0800') {
                utflen += 2;
                continue;
            }
            utflen += 3;
        }
        if (utflen > 65535) {
            throw new IllegalArgumentException("string too long");
        }
        this.reserveSpace(utflen + 3);
        int offset = this.offset;
        byte[] elems = this.elems;
        elems[offset] = 1;
        elems[offset + 1] = (byte)(utflen >> 8);
        elems[offset + 2] = (byte)utflen;
        offset += 3;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                elems[offset++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                elems[offset] = (byte)(0xE0 | c >> 12 & 0xF);
                elems[offset + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                elems[offset + 2] = (byte)(0x80 | c & 0x3F);
                offset += 3;
                continue;
            }
            elems[offset] = (byte)(0xC0 | c >> 6 & 0x1F);
            elems[offset + 1] = (byte)(0x80 | c & 0x3F);
            offset += 2;
        }
        this.offset = offset;
    }

    @Override
    public void writeBytes(byte[] arr, int start, int length) {
        this.reserveSpace(length);
        System.arraycopy(arr, start, this.elems, this.offset, length);
        this.offset += length;
    }

    @Override
    public void patchInt(int offset, int size, int value) {
        int prevOffset = this.offset;
        this.offset = offset;
        this.writeIntBytes(size, value);
        this.offset = prevOffset;
    }

    public void patchU2(int offset, int x) {
        byte[] elems = this.elems;
        elems[offset] = (byte)(x >> 8);
        elems[offset + 1] = (byte)x;
    }

    public void patchInt(int offset, int x) {
        byte[] elems = this.elems;
        elems[offset] = (byte)(x >> 24);
        elems[offset + 1] = (byte)(x >> 16);
        elems[offset + 2] = (byte)(x >> 8);
        elems[offset + 3] = (byte)x;
    }

    @Override
    public void writeIntBytes(int intSize, long intValue) {
        this.reserveSpace(intSize);
        for (int i = 0; i < intSize; ++i) {
            this.elems[this.offset++] = (byte)(intValue >> 8 * (intSize - i - 1) & 0xFFL);
        }
    }

    public int skip(int bytes) {
        int now = this.offset;
        this.reserveSpace(bytes);
        this.offset += bytes;
        return now;
    }

    @Override
    public void reserveSpace(int freeBytes) {
        int minCapacity = this.offset + freeBytes;
        if (minCapacity > this.elems.length) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int newsize;
        for (newsize = this.elems.length * 2; minCapacity > newsize; newsize *= 2) {
        }
        this.elems = Arrays.copyOf(this.elems, newsize);
    }

    @Override
    public int size() {
        return this.offset;
    }

    public RawBytecodeHelper.CodeRange bytecodeView() {
        return RawBytecodeHelper.of(this.elems, this.offset);
    }

    public void copyTo(byte[] array, int bufferOffset) {
        System.arraycopy(this.elems, 0, array, bufferOffset, this.size());
    }

    public int cpIndex(PoolEntry entry) {
        int idx = AbstractPoolEntry.maybeClone(this.constantPool, entry).index();
        if (idx < 1 || idx > 65535) {
            throw BufWriterImpl.invalidIndex(idx, entry);
        }
        return idx;
    }

    public int cpIndexOrZero(PoolEntry entry) {
        if (entry == null || entry.index() == 0) {
            return 0;
        }
        return this.cpIndex(entry);
    }

    @Override
    public void writeIndex(PoolEntry entry) {
        this.writeU2(this.cpIndex(entry));
    }

    public void writeIndex(int bytecode, PoolEntry entry) {
        this.writeU1U2(bytecode, this.cpIndex(entry));
    }

    static IllegalArgumentException invalidIndex(int idx, PoolEntry entry) {
        return new IllegalArgumentException(idx + " is not a valid index. Entry: " + entry);
    }

    @Override
    public void writeIndexOrZero(PoolEntry entry) {
        this.writeU2(this.cpIndexOrZero(entry));
    }

    static byte[] join(BufWriterImpl head, BufWriterImpl tail) {
        byte[] result = new byte[head.size() + tail.size()];
        head.copyTo(result, 0);
        tail.copyTo(result, head.size());
        return result;
    }
}

