/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ClassDesc;

public abstract class IntBasedConst
extends ConstImpl {
    IntBasedConst(ClassDesc type) {
        super(type);
    }

    public abstract int intValue();

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        int i = this.intValue();
        switch (i) {
            case -5: {
                cb.iconst_5();
                cb.ineg();
                break;
            }
            case -4: {
                cb.iconst_4();
                cb.ineg();
                break;
            }
            case -3: {
                cb.iconst_3();
                cb.ineg();
                break;
            }
            case -2: {
                cb.iconst_2();
                cb.ineg();
                break;
            }
            default: {
                cb.loadConstant(i);
            }
        }
    }

    @Override
    public boolean isZero() {
        return this.intValue() == 0;
    }

    @Override
    public boolean isNonZero() {
        return this.intValue() != 0;
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        int i = this.intValue();
        return b.append(i).append(" (0x").append(Integer.toHexString(i)).append(')');
    }
}

