/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class StreamsGroupSubtopologyDescription {
    private final String subtopologyId;
    private final List<String> sourceTopics;
    private final List<String> repartitionSinkTopics;
    private final Map<String, TopicInfo> stateChangelogTopics;
    private final Map<String, TopicInfo> repartitionSourceTopics;

    public StreamsGroupSubtopologyDescription(String subtopologyId, List<String> sourceTopics, List<String> repartitionSinkTopics, Map<String, TopicInfo> stateChangelogTopics, Map<String, TopicInfo> repartitionSourceTopics) {
        this.subtopologyId = Objects.requireNonNull(subtopologyId, "subtopologyId must be non-null");
        this.sourceTopics = Objects.requireNonNull(sourceTopics, "sourceTopics must be non-null");
        this.repartitionSinkTopics = Objects.requireNonNull(repartitionSinkTopics, "repartitionSinkTopics must be non-null");
        this.stateChangelogTopics = Objects.requireNonNull(stateChangelogTopics, "stateChangelogTopics must be non-null");
        this.repartitionSourceTopics = Objects.requireNonNull(repartitionSourceTopics, "repartitionSourceTopics must be non-null");
    }

    public String subtopologyId() {
        return this.subtopologyId;
    }

    public List<String> sourceTopics() {
        return List.copyOf(this.sourceTopics);
    }

    public List<String> repartitionSinkTopics() {
        return List.copyOf(this.repartitionSinkTopics);
    }

    public Map<String, TopicInfo> stateChangelogTopics() {
        return Map.copyOf(this.stateChangelogTopics);
    }

    public Map<String, TopicInfo> repartitionSourceTopics() {
        return Map.copyOf(this.repartitionSourceTopics);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamsGroupSubtopologyDescription that = (StreamsGroupSubtopologyDescription)o;
        return Objects.equals(this.subtopologyId, that.subtopologyId) && Objects.equals(this.sourceTopics, that.sourceTopics) && Objects.equals(this.repartitionSinkTopics, that.repartitionSinkTopics) && Objects.equals(this.stateChangelogTopics, that.stateChangelogTopics) && Objects.equals(this.repartitionSourceTopics, that.repartitionSourceTopics);
    }

    public int hashCode() {
        return Objects.hash(this.subtopologyId, this.sourceTopics, this.repartitionSinkTopics, this.stateChangelogTopics, this.repartitionSourceTopics);
    }

    public String toString() {
        return "(subtopologyId='" + this.subtopologyId + "', sourceTopics=" + String.valueOf(this.sourceTopics) + ", repartitionSinkTopics=" + String.valueOf(this.repartitionSinkTopics) + ", stateChangelogTopics=" + String.valueOf(this.stateChangelogTopics) + ", repartitionSourceTopics=" + String.valueOf(this.repartitionSourceTopics) + ")";
    }

    public static class TopicInfo {
        private final int partitions;
        private final int replicationFactor;
        private final Map<String, String> topicConfigs;

        public TopicInfo(int partitions, int replicationFactor, Map<String, String> topicConfigs) {
            this.partitions = partitions;
            this.replicationFactor = replicationFactor;
            this.topicConfigs = Objects.requireNonNull(topicConfigs, "topicConfigs must be non-null");
        }

        public int partitions() {
            return this.partitions;
        }

        public int replicationFactor() {
            return this.replicationFactor;
        }

        public Map<String, String> topicConfigs() {
            return Map.copyOf(this.topicConfigs);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicInfo topicInfo = (TopicInfo)o;
            return this.partitions == topicInfo.partitions && this.replicationFactor == topicInfo.replicationFactor && Objects.equals(this.topicConfigs, topicInfo.topicConfigs);
        }

        public int hashCode() {
            return Objects.hash(this.partitions, this.replicationFactor, this.topicConfigs);
        }

        public String toString() {
            return "TopicInfo(partitions=" + this.partitions + ", replicationFactor=" + this.replicationFactor + ", topicConfigs=" + this.topicConfigs.entrySet().stream().map(x -> (String)x.getKey() + "=" + (String)x.getValue()).collect(Collectors.joining(",")) + ")";
        }
    }
}

