/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.addons;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.util.ArrayUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayJavaAddons {
    @JRubyMethod(name={"copy_data"})
    public static IRubyObject copy_data(ThreadContext context, IRubyObject fromRuby, IRubyObject toJava, IRubyObject fillValue) {
        int i2;
        ArrayJavaProxy javaArray = ArrayJavaAddons.assertJavaArrayProxy(context, toJava);
        int javaLength = javaArray.length();
        Class<?> targetType = javaArray.getComponentType();
        Object fillJavaObject = null;
        if (!fillValue.isNil()) {
            fillJavaObject = fillValue.toJava(targetType);
        }
        RubyArray rubyArray = null;
        if (fromRuby instanceof RubyArray) {
            rubyArray = (RubyArray)fromRuby;
        } else {
            fillJavaObject = fromRuby.toJava(targetType);
        }
        Ruby runtime2 = context.runtime;
        Object array2 = javaArray.getObject();
        if (rubyArray != null) {
            int rubyLength2 = rubyArray.getLength();
            for (i2 = 0; i2 < rubyLength2 && i2 < javaLength; ++i2) {
                Object javaObject = rubyArray.eltInternal(i2).toJava(targetType);
                ArrayUtils.setWithExceptionHandlingDirect(runtime2, array2, i2, javaObject);
            }
        }
        if (i2 < javaLength && fillJavaObject != null) {
            while (i2 < javaLength) {
                ArrayUtils.setWithExceptionHandlingDirect(runtime2, array2, i2, fillJavaObject);
                ++i2;
            }
        }
        return toJava;
    }

    @JRubyMethod(name={"copy_data", "copy_data_simple"})
    public static IRubyObject copy_data(ThreadContext context, IRubyObject fromRuby, IRubyObject toJava) {
        ArrayJavaProxy javaArray = ArrayJavaAddons.assertJavaArrayProxy(context, toJava);
        RubyArray rubyArray = (RubyArray)fromRuby;
        ArrayJavaAddons.copyDataToJavaArray(context, rubyArray, javaArray, 0);
        return toJava;
    }

    private static void copyDataToJavaArray(ThreadContext context, RubyArray rubyArray, ArrayJavaProxy javaArray, int offset2) {
        int length2 = javaArray.length();
        if (length2 > rubyArray.getLength()) {
            length2 = rubyArray.getLength();
        }
        Ruby runtime2 = context.runtime;
        Object array2 = javaArray.getObject();
        Class<?> targetType = javaArray.getComponentType();
        for (int i2 = offset2; i2 < length2; ++i2) {
            Object javaObject = rubyArray.eltInternal(i2).toJava(targetType);
            ArrayUtils.setWithExceptionHandlingDirect(runtime2, array2, i2, javaObject);
        }
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject rubyArray) {
        return ArrayJavaAddons.dimensions(context, rubyArray, Create.newEmptyArray(context));
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject rubyArray, IRubyObject dims) {
        if (!(rubyArray instanceof RubyArray)) {
            return Create.newEmptyArray(context);
        }
        assert (dims instanceof RubyArray);
        return ArrayJavaAddons.calcDimensions(context, (RubyArray)rubyArray, (RubyArray)dims, 0);
    }

    @JRubyMethod
    public static IRubyObject dimensions(ThreadContext context, IRubyObject rubyArray, IRubyObject dims, IRubyObject index2) {
        if (!(rubyArray instanceof RubyArray)) {
            return Create.newEmptyArray(context);
        }
        assert (dims instanceof RubyArray);
        assert (index2 instanceof RubyFixnum);
        return ArrayJavaAddons.calcDimensions(context, (RubyArray)rubyArray, (RubyArray)dims, ((RubyFixnum)index2).asInt(context));
    }

    private static RubyArray<?> calcDimensions(ThreadContext context, RubyArray<?> array2, RubyArray dims, int index2) {
        RubyFixnum zero = Convert.asFixnum(context, 0);
        while (dims.size() <= index2) {
            dims.append(context, zero);
        }
        long dim = ((RubyFixnum)dims.eltInternal(index2)).getValue();
        if ((long)array2.size() > dim) {
            dims.eltInternalSet(index2, Convert.asFixnum(context, array2.size()));
        }
        for (int i2 = 0; i2 < array2.size(); ++i2) {
            Object element = array2.eltInternal(i2);
            if (!(element instanceof RubyArray)) continue;
            RubyArray ary = (RubyArray)element;
            ArrayJavaAddons.calcDimensions(context, ary, dims, 1);
        }
        return dims;
    }

    private static ArrayJavaProxy assertJavaArrayProxy(ThreadContext context, IRubyObject java_array) {
        if (!(java_array instanceof ArrayJavaProxy)) {
            throw Error.typeError(context, java_array, "Java array");
        }
        return (ArrayJavaProxy)java_array;
    }
}

