/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.P3;
import javajs.util.PT;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;

public class XmlOdysseyReader
extends XmlReader {
    private String modelName = null;
    private String formula = null;
    private String phase = null;
    private int formalCharge = Integer.MIN_VALUE;

    @Override
    protected void processStartElement(String localName, String nodeName) {
        if ("structure".equals(localName)) {
            this.asc.newAtomSet();
            return;
        }
        if ("atom".equals(localName)) {
            String id = (String)this.atts.get("id");
            this.thisAtom = new Atom();
            new Atom().atomName = (String)this.atts.get(this.atts.containsKey("label") ? "label" : "id");
            if (id != null && this.stateScriptVersionInt >= 140400) {
                this.asc.atomSymbolicMap.put(id, this.thisAtom);
            }
            if (this.atts.containsKey("xyz")) {
                String xyz = (String)this.atts.get("xyz");
                String[] tokens = PT.getTokens(xyz);
                this.thisAtom.set(this.parseFloatStr(tokens[0]), this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]));
            }
            if (this.atts.containsKey("element")) {
                this.thisAtom.elementSymbol = (String)this.atts.get("element");
            }
            return;
        }
        if ("bond".equals(localName)) {
            String atom1 = (String)this.atts.get("a");
            String atom2 = (String)this.atts.get("b");
            int order = 1;
            if (this.atts.containsKey("order")) {
                order = this.parseBondToken((String)this.atts.get("order"));
            }
            this.asc.addNewBondFromNames(atom1, atom2, order);
            return;
        }
        if ("group".equals(localName)) {
            String charge = (String)this.atts.get("charge");
            if (charge != null && charge.indexOf(".") < 0) {
                this.formalCharge = PT.parseInt(charge);
            }
            return;
        }
        if ("member".equals(localName) && this.formalCharge != Integer.MIN_VALUE) {
            Atom atom = this.asc.getAtomFromName((String)this.atts.get("entity"));
            if (atom != null) {
                atom.formalCharge = this.formalCharge;
            }
            return;
        }
        if ("boundary".equals(localName)) {
            String[] boxDim = PT.getTokens((String)this.atts.get("box"));
            float x = this.parseFloatStr(boxDim[0]);
            float y = this.parseFloatStr(boxDim[1]);
            float z = this.parseFloatStr(boxDim[2]);
            this.parent.setUnitCellItem(0, x);
            this.parent.setUnitCellItem(1, y);
            this.parent.setUnitCellItem(2, z);
            this.parent.setUnitCellItem(3, 90.0f);
            this.parent.setUnitCellItem(4, 90.0f);
            this.parent.setUnitCellItem(5, 90.0f);
            P3 pt = P3.new3(-x / 2.0f, -y / 2.0f, -z / 2.0f);
            Atom[] atoms = this.asc.atoms;
            int i = this.asc.ac;
            while (--i >= 0) {
                atoms[i].sub(pt);
                this.parent.setAtomCoord(atoms[i]);
            }
            if (this.parent.latticeCells[0] == 0) {
                this.parent.latticeCells[2] = 1;
                this.parent.latticeCells[1] = 1;
                this.parent.latticeCells[0] = 1;
            }
            return;
        }
        if ("odyssey_simulation".equals(localName)) {
            if (this.modelName != null && this.phase != null) {
                this.modelName = this.modelName + " - " + this.phase;
            }
            if (this.modelName != null) {
                this.asc.setAtomSetName(this.modelName);
            }
            if (this.formula != null) {
                this.asc.setCurrentModelInfo("formula", this.formula);
            }
        }
        if ("title".equals(localName) || "formula".equals(localName) || "phase".equals(localName)) {
            this.setKeepChars(true);
        }
    }

    private int parseBondToken(String str) {
        if (str.length() >= 1) {
            switch (str.charAt(0)) {
                case 's': {
                    return 1;
                }
                case 'd': {
                    return 2;
                }
                case 't': {
                    return 3;
                }
                case 'a': {
                    return 515;
                }
            }
            return this.parseIntStr(str);
        }
        return 1;
    }

    @Override
    void processEndElement(String localName) {
        if ("atom".equals(localName)) {
            if (this.thisAtom.elementSymbol != null && !Float.isNaN(this.thisAtom.z)) {
                this.asc.addAtomWithMappedName(this.thisAtom);
            }
            this.thisAtom = null;
            return;
        }
        if ("group".equals(localName)) {
            this.formalCharge = Integer.MIN_VALUE;
        } else if ("title".equals(localName)) {
            this.modelName = this.chars.toString();
        } else if ("formula".equals(localName)) {
            this.formula = this.chars.toString();
        } else if ("phase".equals(localName)) {
            this.phase = this.chars.toString();
        }
        this.setKeepChars(false);
    }
}

