/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.annotations.NotNull;

public final class SignatureBuildingComponents {
    @NotNull
    public static final SignatureBuildingComponents INSTANCE = new SignatureBuildingComponents();

    private SignatureBuildingComponents() {
    }

    @NotNull
    public final String javaLang(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.stringPlus((String)"java/lang/", (Object)name2);
    }

    @NotNull
    public final String javaUtil(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.stringPlus((String)"java/util/", (Object)name2);
    }

    @NotNull
    public final String javaFunction(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Intrinsics.stringPlus((String)"java/util/function/", (Object)name2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] constructors(String ... signatures2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)signatures2, (String)"signatures");
        String[] $this$map$iv = signatures2;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var11_11 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = "<init>(" + (String)it + ")V";
            collection.add(string2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return stringArray2;
    }

    @NotNull
    public final Set<String> inJavaLang(@NotNull String name2, String ... signatures2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)signatures2, (String)"signatures");
        return this.inClass(this.javaLang(name2), Arrays.copyOf(signatures2, signatures2.length));
    }

    @NotNull
    public final Set<String> inJavaUtil(@NotNull String name2, String ... signatures2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)signatures2, (String)"signatures");
        return this.inClass(this.javaUtil(name2), Arrays.copyOf(signatures2, signatures2.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> inClass(@NotNull String internalName, String ... signatures2) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        Intrinsics.checkNotNullParameter((Object)signatures2, (String)"signatures");
        String[] stringArray = signatures2;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (void item$iv : $this$mapTo$iv) {
            void it;
            void var10_10 = item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            String string2 = internalName + '.' + (String)it;
            collection.add(string2);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public final String signature(@NotNull String internalName, @NotNull String jvmDescriptor2) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        Intrinsics.checkNotNullParameter((Object)jvmDescriptor2, (String)"jvmDescriptor");
        return internalName + '.' + jvmDescriptor2;
    }

    @NotNull
    public final String jvmDescriptor(@NotNull String name2, @NotNull List<String> parameters2, @NotNull String ret) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)ret, (String)"ret");
        return name2 + '(' + CollectionsKt.joinToString$default((Iterable)parameters2, (CharSequence)"", null, null, (int)0, null, (Function1)jvmDescriptor.1.INSTANCE, (int)30, null) + ')' + this.escapeClassName(ret);
    }

    private final String escapeClassName(String internalName) {
        return internalName.length() > 1 ? 'L' + internalName + ';' : internalName;
    }

    public static final /* synthetic */ String access$escapeClassName(SignatureBuildingComponents $this, String internalName) {
        return $this.escapeClassName(internalName);
    }
}

