/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class ArtifactResultData {
    private final Artifact artifact;
    private final ArtifactRepository repository;
    private final List<Exception> exceptions;
    private final ArtifactResolutionException resolutionException;

    public ArtifactResultData(ArtifactResult result, ArtifactResolutionException resolutionException) {
        this(result.getArtifact(), result.getRepository(), result.getExceptions(), resolutionException);
    }

    ArtifactResultData(Artifact artifact, ArtifactRepository repository, List<Exception> exceptions, ArtifactResolutionException resolutionException) {
        this.artifact = artifact;
        this.repository = repository;
        this.exceptions = exceptions;
        this.resolutionException = resolutionException;
    }

    Artifact getArtifact() {
        return this.artifact;
    }

    ArtifactRepository getRepository() {
        return this.repository;
    }

    List<Exception> getExceptions() {
        return this.exceptions;
    }

    ArtifactResolutionException getResolutionException() {
        return this.resolutionException;
    }

    public String toString() {
        return "ArtifactResultData{groupId='" + this.artifact.getGroupId() + '\'' + ", artifactId='" + this.artifact.getArtifactId() + '\'' + ", version='" + this.artifact.getVersion() + '\'' + ", repositoryId=" + this.repository.getId() + '}';
    }
}

