/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItemsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/DefaultCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "location", "Lcom/sun/jdi/Location;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "<init>", "(Lcom/sun/jdi/Location;Ljava/util/List;)V", "createFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "kotlin.jvm-debugger.coroutines"})
public final class DefaultCoroutineStackFrameItem
extends CoroutineStackFrameItem {
    public DefaultCoroutineStackFrameItem(@NotNull Location location, @NotNull List<? extends JavaValue> spilledVariables) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(spilledVariables, (String)"spilledVariables");
        super(location, spilledVariables, null);
    }

    @Override
    @Nullable
    public XStackFrame createFrame(@NotNull DebugProcessImpl debugProcess, @Nullable SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        StackFrameProxyImpl stackFrameProxyImpl = CoroutineStackFrameItemsKt.findFirstFrame(debugProcess);
        if (stackFrameProxyImpl == null) {
            return null;
        }
        StackFrameProxyImpl frame = stackFrameProxyImpl;
        XSourcePosition position = CoroutineUtilsKt.toXSourcePosition(sourcePosition);
        return (XStackFrame)new CoroutineStackFrame(frame, position, this.getSpilledVariables(), false, this.getLocation());
    }
}

