/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.html.BaseGenerator;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesIndexGenerator
extends BaseGenerator {
    public ModulesIndexGenerator(@NotNull TemplateProcessor templateFactory, @NotNull LocalGeneratorPaths paths) {
        super(templateFactory, paths);
    }

    public void generateModulesIndex(Collection<ModuleInfo> modules, StatisticsCalculator covStatsCalculator) throws IOException {
        for (SortOption sortOption : this.getGenerateSortOptions(covStatsCalculator)) {
            HashMap<String, Object> templateModel = new HashMap<String, Object>();
            templateModel.put("modules", this.prepareModules(modules, covStatsCalculator, sortOption));
            templateModel.put("statsCalculator", covStatsCalculator);
            templateModel.put("sortOption", (Object)sortOption);
            this.myTemplateFactory.renderTemplate(templateModel, this.myPaths.getModulesIndexPath(sortOption));
        }
    }

    private List<ModuleInfo> prepareModules(Collection<ModuleInfo> modules, StatisticsCalculator covStatsCalculator, SortOption sortOption) {
        List<ModuleInfo> result = this.removeModulesWithoutStatistics(modules, covStatsCalculator);
        Collections.sort(result, sortOption.createModulesComparator(covStatsCalculator));
        return result;
    }

    private List<ModuleInfo> removeModulesWithoutStatistics(Collection<ModuleInfo> modules, final StatisticsCalculator covStatsCalculator) {
        return this.filterCovered(modules, new BaseGenerator.Converter<ModuleInfo>(){

            @Override
            @NotNull
            public CoverageStatistics convert(ModuleInfo moduleInfo) {
                return covStatsCalculator.getForModule(moduleInfo.getName());
            }
        });
    }
}

