/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.incremental.groovy.GroovyResourceRootDescriptor;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class CheckResourcesTarget
extends BuildTarget<GroovyResourceRootDescriptor> {
    @NotNull
    private final JpsModule myModule;
    public static final Type PRODUCTION = new Type(false);
    public static final Type TESTS = new Type(true);
    static final List<Type> TARGET_TYPES = Arrays.asList(PRODUCTION, TESTS);

    CheckResourcesTarget(@NotNull JpsModule module, @NotNull Type targetType) {
        if (module == null) {
            CheckResourcesTarget.$$$reportNull$$$0(0);
        }
        if (targetType == null) {
            CheckResourcesTarget.$$$reportNull$$$0(1);
        }
        super((BuildTargetType)targetType);
        this.myModule = module;
    }

    @NotNull
    public String getId() {
        String string = this.myModule.getName();
        if (string == null) {
            CheckResourcesTarget.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public GroovyResourceRootDescriptor findRootDescriptor(@NotNull String rootId, @NotNull BuildRootIndex rootIndex) {
        if (rootId == null) {
            CheckResourcesTarget.$$$reportNull$$$0(3);
        }
        if (rootIndex == null) {
            CheckResourcesTarget.$$$reportNull$$$0(4);
        }
        List descriptors = rootIndex.getRootDescriptors(new File(rootId), Collections.singletonList((Type)this.getTargetType()), null);
        return (GroovyResourceRootDescriptor)((Object)ContainerUtil.getFirstItem((List)descriptors));
    }

    boolean isTests() {
        return ((Type)this.getTargetType()).myTests;
    }

    @NotNull
    public String getPresentableName() {
        String string = "Check Groovy Resources for '" + this.myModule.getName() + "' " + (this.isTests() ? "tests" : "production");
        if (string == null) {
            CheckResourcesTarget.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public Collection<BuildTarget<?>> computeDependencies(@NotNull BuildTargetRegistry targetRegistry, @NotNull TargetOutputIndex outputIndex) {
        if (targetRegistry == null) {
            CheckResourcesTarget.$$$reportNull$$$0(6);
        }
        if (outputIndex == null) {
            CheckResourcesTarget.$$$reportNull$$$0(7);
        }
        ArrayList result = new ArrayList();
        ModuleBuildTarget compileTarget = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.getInstance((boolean)this.isTests()));
        result.add((BuildTarget<?>)compileTarget);
        for (BuildTarget dep : compileTarget.computeDependencies(targetRegistry, outputIndex)) {
            if (!(dep instanceof ModuleBuildTarget)) continue;
            result.add(new CheckResourcesTarget(((ModuleBuildTarget)dep).getModule(), ((ModuleBuildTarget)dep).isTests() ? TESTS : PRODUCTION));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            CheckResourcesTarget.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public List<GroovyResourceRootDescriptor> computeRootDescriptors(@NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull BuildDataPaths dataPaths) {
        if (model == null) {
            CheckResourcesTarget.$$$reportNull$$$0(9);
        }
        if (index == null) {
            CheckResourcesTarget.$$$reportNull$$$0(10);
        }
        if (ignoredFileIndex == null) {
            CheckResourcesTarget.$$$reportNull$$$0(11);
        }
        if (dataPaths == null) {
            CheckResourcesTarget.$$$reportNull$$$0(12);
        }
        ResourcesTarget target = new ResourcesTarget(this.myModule, ResourcesTargetType.getInstance((boolean)this.isTests()));
        List resources = target.computeRootDescriptors(model, index, ignoredFileIndex, dataPaths);
        List list = ContainerUtil.map((Collection)resources, descriptor -> new GroovyResourceRootDescriptor((ResourceRootDescriptor)descriptor, this));
        if (list == null) {
            CheckResourcesTarget.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public Collection<File> getOutputRoots(@NotNull CompileContext context) {
        if (context == null) {
            CheckResourcesTarget.$$$reportNull$$$0(14);
        }
        List<File> list = List.of(this.getOutputRoot(context).toFile());
        if (list == null) {
            CheckResourcesTarget.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    Path getOutputRoot(CompileContext context) {
        Path commonRoot = context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageDir().resolve("groovyResources");
        Path path = commonRoot.resolve(this.myModule.getName() + File.separator + this.getTargetType().getTypeId());
        if (path == null) {
            CheckResourcesTarget.$$$reportNull$$$0(16);
        }
        return path;
    }

    @NotNull
    public JpsModule getModule() {
        JpsModule jpsModule = this.myModule;
        if (jpsModule == null) {
            CheckResourcesTarget.$$$reportNull$$$0(17);
        }
        return jpsModule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CheckResourcesTarget)) {
            return false;
        }
        CheckResourcesTarget target = (CheckResourcesTarget)((Object)o);
        if (!this.myModule.equals(target.myModule)) {
            return false;
        }
        return this.getTargetType().equals((Object)target.getTargetType());
    }

    public int hashCode() {
        return this.myModule.hashCode() + 31 * this.getTargetType().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/groovy/CheckResourcesTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegistry";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileIndex";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/groovy/CheckResourcesTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoot";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRootDescriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeDependencies";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeRootDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOutputRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Type
    extends BuildTargetType<CheckResourcesTarget> {
        private final boolean myTests;

        protected Type(boolean tests) {
            super("groovy-check-resources" + (tests ? "_tests" : ""), true);
            this.myTests = tests;
        }

        @NotNull
        public List<CheckResourcesTarget> computeAllTargets(@NotNull JpsModel model) {
            if (model == null) {
                Type.$$$reportNull$$$0(0);
            }
            List list = ContainerUtil.map((Collection)model.getProject().getModules(), module -> new CheckResourcesTarget((JpsModule)module, this));
            if (list == null) {
                Type.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public BuildTargetLoader<CheckResourcesTarget> createLoader(@NotNull JpsModel model) {
            if (model == null) {
                Type.$$$reportNull$$$0(2);
            }
            final HashMap<String, JpsModule> modules = new HashMap<String, JpsModule>();
            for (JpsModule module : model.getProject().getModules()) {
                modules.put(module.getName(), module);
            }
            return new BuildTargetLoader<CheckResourcesTarget>(){

                @Nullable
                public CheckResourcesTarget createTarget(@NotNull String targetId) {
                    JpsModule module;
                    if (targetId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (module = (JpsModule)modules.get(targetId)) != null ? new CheckResourcesTarget(module, this) : null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/incremental/groovy/CheckResourcesTarget$Type$1", "createTarget"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/incremental/groovy/CheckResourcesTarget$Type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/incremental/groovy/CheckResourcesTarget$Type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeAllTargets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAllTargets";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createLoader";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

