/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;

public class CoordFormatters {
    private final HashMap<Integer, NumberFormat> _localFormatters = new HashMap();
    private final HashMap<Integer, NumberFormat> _ukFormatters = new HashMap();

    public NumberFormat getLocalFormatter(int n) {
        return CoordFormatters.getFormatter(this._localFormatters, n, null);
    }

    public NumberFormat getUkFormatter(int n) {
        return CoordFormatters.getFormatter(this._ukFormatters, n, Locale.UK);
    }

    private static NumberFormat getFormatter(HashMap<Integer, NumberFormat> hashMap, int n, Locale locale) {
        NumberFormat numberFormat = hashMap.get(n);
        if (numberFormat == null) {
            numberFormat = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
            StringBuilder stringBuilder = new StringBuilder("0.");
            if (n > 0) {
                stringBuilder.append("0".repeat(n));
            }
            String string = stringBuilder.toString();
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).applyPattern(string);
            }
            hashMap.put(n, numberFormat);
        }
        return numberFormat;
    }
}

