---
stage: Plan
group: Optimize
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: オープンマージリクエストがコードレビューに費やした時間と、最長実行時間を区別するものを確認します。
title: コードレビュー分析
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- 13.9でGitLab Premiumに移行しました。

{{< /history >}}

コードレビュー分析には、少なくとも1つの作成者以外のコメントがあるオープンマージリクエストの表が表示されます。レビュー時間は、マージリクエストで作成者以外の最初のコメントからの時間です。

コードレビューのメトリクスをマージリクエストごとに表示し、コードレビュープロセスを改善するために、コードレビュー分析を使用できます。

- 多数のコメントまたはコミットは、以下を示す可能性があります:
  - 複雑すぎるコード。
  - より多くのトレーニングを必要とする作成者。
- レビュー時間が長い場合は、次のことを示している可能性があります:
  - 他のタイプよりも動きが遅い作業タイプ。
  - 開発サイクルを加速させる機会。
- コメントと承認者が少ない場合は、利用可能なチームメンバーが不足していることを示している可能性があります。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>ビデオによる説明は、[コードレビュー分析: より高速なコードレビュー](https://www.youtube.com/watch?v=849o0XD991M)を参照してください。

## コードレビュー分析を表示 {#view-code-review-analytics}

前提要件:

- レポーターロール以上が必要です。

コードレビュー分析を表示するには、次のようにします:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **分析** > **コードレビュー分析**を選択します。
1. オプション。フィルターバー:
   1. フィルターバーを選択します。
   1. パラメータを選択します。マージリクエストをマイルストーンとラベルでフィルターできます。
   1. 選択したパラメータの値を選択します。

表には、ページごとに最大20件のマージリクエストが表示され、各マージリクエストに関する次の情報が含まれています:

- マージリクエストのタイトル
- レビュー時間
- 作成者
- 承認者
- コメント
- コミット
- 変更行
