# frozen_string_literal: true

class CreateVulnerabilityNamespaceStatistics < Gitlab::Database::Migration[2.2]
  milestone '17.10'

  TRAVERSAL_IDS_INDEX_NAME = 'index_vuln_namespace_statistics_gin_traversal_ids'
  NAMESPACE_ID_FK_INDEX_NAME = 'index_vuln_namespace_statistics_on_namespace_id'

  def up
    # rubocop:disable Migration/EnsureFactoryForTable -- False Positive
    create_table :vulnerability_namespace_statistics do |t|
      t.timestamps_with_timezone null: false
      t.bigint :namespace_id, null: false, index: { name: NAMESPACE_ID_FK_INDEX_NAME, unique: true }
      t.integer :total, default: 0, null: false
      t.integer :critical, default: 0, null: false
      t.integer :high, default: 0, null: false
      t.integer :medium, default: 0, null: false
      t.integer :low, default: 0, null: false
      t.integer :unknown, default: 0, null: false
      t.integer :info, default: 0, null: false
      t.bigint :traversal_ids, array: true, default: [], null: false
      t.index :traversal_ids, using: :gin, name: TRAVERSAL_IDS_INDEX_NAME
    end
    # rubocop:enable Migration/EnsureFactoryForTable
  end

  def down
    drop_table :vulnerability_namespace_statistics
  end
end
