/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.CvRecord;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Module
implements StructConverter {
    public static final String NAME = "MINIDUMP_MODULE";
    private long baseOfImage;
    private long sizeOfImage;
    private int checkSum;
    private int timeDateStamp;
    private int moduleNameRVA;
    private int dwSignature;
    private int dwStrucVersion;
    private int dwFileVersionMS;
    private int dwFileVersionLS;
    private int dwProductVersionMS;
    private int dwProductVersionLS;
    private int dwFileFlagsMask;
    private int dwFileFlags;
    private int dwFileOS;
    private int dwFileType;
    private int dwFileSubtype;
    private int dwFileDateMS;
    private int dwFileDateLS;
    private int cvRecordDataSize;
    private int cvRecordRVA;
    private int miscRecordDataSize;
    private int miscRecordRVA;
    private int moduleNameLength;
    private String moduleName;
    private CvRecord cvRecord;
    private DumpFileReader reader;
    private long index;

    Module(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
        this.getRVAs();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setBaseOfImage(this.reader.readNextLong());
        this.setSizeOfImage(this.reader.readNextUnsignedInt());
        this.setCheckSum(this.reader.readNextInt());
        this.setTimeDateStamp(this.reader.readNextInt());
        this.setModuleNameRVA(this.reader.readNextInt());
        this.setDwSignature(this.reader.readNextInt());
        this.setDwStrucVersion(this.reader.readNextInt());
        this.setDwFileVersionMS(this.reader.readNextInt());
        this.setDwFileVersionLS(this.reader.readNextInt());
        this.setDwProductVersionMS(this.reader.readNextInt());
        this.setDwProductVersionLS(this.reader.readNextInt());
        this.setDwFileFlagsMask(this.reader.readNextInt());
        this.setDwFileFlags(this.reader.readNextInt());
        this.setDwFileOS(this.reader.readNextInt());
        this.setDwFileType(this.reader.readNextInt());
        this.setDwFileSubtype(this.reader.readNextInt());
        this.setDwFileDateMS(this.reader.readNextInt());
        this.setDwFileDateLS(this.reader.readNextInt());
        this.setCvRecordDataSize(this.reader.readNextInt());
        this.setCvRecordRVA(this.reader.readNextInt());
        this.setMiscRecordDataSize(this.reader.readNextInt());
        this.setMiscRecordRVA(this.reader.readNextInt());
        this.reader.readNextLong();
        this.reader.readNextLong();
    }

    private void getRVAs() throws IOException {
        long pos = this.reader.getPointerIndex();
        this.reader.setPointerIndex(this.getModuleNameRVA());
        this.moduleNameLength = this.reader.readNextInt();
        this.moduleName = this.reader.readNextUnicodeString();
        this.cvRecord = new CvRecord(this.reader, this.getCvRecordRVA());
        this.reader.setPointerIndex(pos);
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "BaseOfImage", null);
        struct.add(DWORD, 4, "SizeOfImage", null);
        struct.add(DWORD, 4, "CheckSum", null);
        struct.add(DWORD, 4, "TimeDateStamp", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "ModuleNameRVA", null);
        StructureDataType sv = new StructureDataType("VersionInfo", 0);
        sv.add(DWORD, 4, "Signature", null);
        sv.add(DWORD, 4, "StrucVersion", null);
        sv.add(DWORD, 4, "FileVersionMS", null);
        sv.add(DWORD, 4, "FileVersionLS", null);
        sv.add(DWORD, 4, "ProductVersionMS", null);
        sv.add(DWORD, 4, "ProductVersionLS", null);
        sv.add(DWORD, 4, "FileFlagsMask", null);
        sv.add(DWORD, 4, "FileFlags", null);
        sv.add(DWORD, 4, "FileOS", null);
        sv.add(DWORD, 4, "FileType", null);
        sv.add(DWORD, 4, "FileSubtype", null);
        sv.add(DWORD, 4, "FileDateMS", null);
        sv.add(DWORD, 4, "FileDateLS", null);
        StructureDataType s0 = new StructureDataType("CvRecord", 0);
        s0.add(DWORD, 4, "DataSize", null);
        s0.add((DataType)Pointer32DataType.dataType, 4, "RVA", null);
        StructureDataType s1 = new StructureDataType("MiscRecord", 0);
        s1.add(DWORD, 4, "DataSize", null);
        s1.add((DataType)Pointer32DataType.dataType, 4, "RVA", null);
        struct.add((DataType)sv, sv.getLength(), sv.getDisplayName(), null);
        struct.add((DataType)s0, s0.getLength(), s0.getDisplayName(), null);
        struct.add((DataType)s1, s1.getLength(), s1.getDisplayName(), null);
        struct.add(QWORD, 8, "Reserved0", null);
        struct.add(QWORD, 8, "Reserved1", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public long getBaseOfImage() {
        return this.baseOfImage;
    }

    public void setBaseOfImage(long baseOfImage) {
        this.baseOfImage = baseOfImage;
    }

    public long getSizeOfImage() {
        return this.sizeOfImage;
    }

    public void setSizeOfImage(long sizeOfImage) {
        this.sizeOfImage = sizeOfImage;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public void setTimeDateStamp(int timeDateStamp) {
        this.timeDateStamp = timeDateStamp;
    }

    public int getModuleNameRVA() {
        return this.moduleNameRVA;
    }

    public void setModuleNameRVA(int moduleNameRVA) {
        this.moduleNameRVA = moduleNameRVA;
    }

    public int getDwSignature() {
        return this.dwSignature;
    }

    public void setDwSignature(int dwSignature) {
        this.dwSignature = dwSignature;
    }

    public int getDwStrucVersion() {
        return this.dwStrucVersion;
    }

    public void setDwStrucVersion(int dwStrucVersion) {
        this.dwStrucVersion = dwStrucVersion;
    }

    public int getDwFileVersionMS() {
        return this.dwFileVersionMS;
    }

    public void setDwFileVersionMS(int dwFileVersionMS) {
        this.dwFileVersionMS = dwFileVersionMS;
    }

    public int getDwFileVersionLS() {
        return this.dwFileVersionLS;
    }

    public void setDwFileVersionLS(int dwFileVersionLS) {
        this.dwFileVersionLS = dwFileVersionLS;
    }

    public int getDwProductVersionMS() {
        return this.dwProductVersionMS;
    }

    public void setDwProductVersionMS(int dwProductVersionMS) {
        this.dwProductVersionMS = dwProductVersionMS;
    }

    public int getDwProductVersionLS() {
        return this.dwProductVersionLS;
    }

    public void setDwProductVersionLS(int dwProductVersionLS) {
        this.dwProductVersionLS = dwProductVersionLS;
    }

    public int getDwFileFlagsMask() {
        return this.dwFileFlagsMask;
    }

    public void setDwFileFlagsMask(int dwFileFlagsMask) {
        this.dwFileFlagsMask = dwFileFlagsMask;
    }

    public int getDwFileFlags() {
        return this.dwFileFlags;
    }

    public void setDwFileFlags(int dwFileFlags) {
        this.dwFileFlags = dwFileFlags;
    }

    public int getDwFileOS() {
        return this.dwFileOS;
    }

    public void setDwFileOS(int dwFileOS) {
        this.dwFileOS = dwFileOS;
    }

    public int getDwFileType() {
        return this.dwFileType;
    }

    public void setDwFileType(int dwFileType) {
        this.dwFileType = dwFileType;
    }

    public int getDwFileSubtype() {
        return this.dwFileSubtype;
    }

    public void setDwFileSubtype(int dwFileSubtype) {
        this.dwFileSubtype = dwFileSubtype;
    }

    public int getDwFileDateMS() {
        return this.dwFileDateMS;
    }

    public void setDwFileDateMS(int dwFileDateMS) {
        this.dwFileDateMS = dwFileDateMS;
    }

    public int getDwFileDateLS() {
        return this.dwFileDateLS;
    }

    public void setDwFileDateLS(int dwFileDateLS) {
        this.dwFileDateLS = dwFileDateLS;
    }

    public int getCvRecordDataSize() {
        return this.cvRecordDataSize;
    }

    public void setCvRecordDataSize(int cvRecordDataSize) {
        this.cvRecordDataSize = cvRecordDataSize;
    }

    public int getCvRecordRVA() {
        return this.cvRecordRVA;
    }

    public void setCvRecordRVA(int cvRecordRVA) {
        this.cvRecordRVA = cvRecordRVA;
    }

    public int getMiscRecordDataSize() {
        return this.miscRecordDataSize;
    }

    public void setMiscRecordDataSize(int miscRecordDataSize) {
        this.miscRecordDataSize = miscRecordDataSize;
    }

    public int getMiscRecordRVA() {
        return this.miscRecordRVA;
    }

    public void setMiscRecordRVA(int miscRecordRVA) {
        this.miscRecordRVA = miscRecordRVA;
    }

    public int getModuleNameLength() {
        return this.moduleNameLength;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public CvRecord getCvRecord() {
        return this.cvRecord;
    }
}

