/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util.string;

import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.util.string.AbstractStringSearcher;
import ghidra.program.util.string.FoundStringCallback;
import ghidra.util.ascii.AsciiCharSetRecognizer;
import ghidra.util.ascii.CharSetRecognizer;
import ghidra.util.ascii.Sequence;

public class StringSearcher
extends AbstractStringSearcher {
    private boolean requireNullTermination;

    public StringSearcher(Program program, int minimumStringSize, int alignment, boolean allCharSizes, boolean requireNullTermination) {
        super(program, new AsciiCharSetRecognizer(), minimumStringSize, alignment, true, StringSearcher.shouldLookForUTF16(program, allCharSizes), StringSearcher.shouldLookForUTF32(program, allCharSizes));
        this.requireNullTermination = requireNullTermination;
    }

    public StringSearcher(Program program, CharSetRecognizer charSet, int minimumStringSize, int alignment, boolean allCharSizes, boolean requireNullTermination) {
        super(program, charSet, minimumStringSize, alignment, true, StringSearcher.shouldLookForUTF16(program, allCharSizes), StringSearcher.shouldLookForUTF32(program, allCharSizes));
        this.requireNullTermination = requireNullTermination;
    }

    private static boolean shouldLookForUTF32(Program program, boolean allCharSizes) {
        int wideCharSize = program.getDataTypeManager().getDataOrganization().getWideCharSize();
        return allCharSizes || wideCharSize == 4;
    }

    private static boolean shouldLookForUTF16(Program program, boolean allCharSizes) {
        int wideCharSize = program.getDataTypeManager().getDataOrganization().getWideCharSize();
        return allCharSizes || wideCharSize == 2;
    }

    @Override
    protected void processSequence(FoundStringCallback callback, Sequence sequence, MemBuffer buf) {
        if (this.requireNullTermination && !sequence.isNullTerminated()) {
            return;
        }
        callback.stringFound(this.getFoundString(buf, sequence, (DataType)sequence.getStringDataType()));
    }
}

