/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.values;

import docking.widgets.values.AbstractValue;
import docking.widgets.values.ValuesMapParseException;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Program;
import javax.swing.JComponent;

public class AddressValue
extends AbstractValue<Address> {
    private AddressInput field;
    private AddressFactory addressFactory;

    public AddressValue(String name, Address defaultValue, Program program) {
        this(name, defaultValue, program.getAddressFactory());
    }

    public AddressValue(String name, Address defaultValue, AddressFactory factory) {
        super(name, (Object)defaultValue);
        this.addressFactory = factory;
    }

    public JComponent getComponent() {
        if (this.field == null) {
            this.field = new AddressInput();
            this.field.setAddressFactory(this.addressFactory);
        }
        return this.field;
    }

    protected void updateValueFromComponent() throws ValuesMapParseException {
        Address address = this.field.getAddress();
        if (address == null && this.field.hasInput()) {
            throw new ValuesMapParseException(this.getName(), "Address", "Could not parse \"" + this.field.getText() + "\".");
        }
        this.setValue(address);
    }

    protected void updateComponentFromValue() {
        Address v = (Address)this.getValue();
        if (v == null) {
            this.field.clear();
        } else {
            this.field.setAddress(v);
        }
    }

    protected Address fromString(String valueString) {
        Address address = this.addressFactory.getAddress(valueString);
        if (address == null) {
            throw new IllegalArgumentException("Invalid address string: " + valueString);
        }
        return address;
    }
}

