/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import docking.DockingWindowManager;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.listener.IndexMapper;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import ghidra.app.plugin.core.terminal.TerminalLayout;
import ghidra.app.plugin.core.terminal.TerminalPanel;
import ghidra.app.plugin.core.terminal.vt.AnsiColorResolver;
import ghidra.app.plugin.core.terminal.vt.VtAttributes;
import ghidra.app.plugin.core.terminal.vt.VtBuffer;
import ghidra.app.plugin.core.terminal.vt.VtCharset;
import ghidra.app.plugin.core.terminal.vt.VtHandler;
import ghidra.app.plugin.core.terminal.vt.VtLine;
import ghidra.app.plugin.core.terminal.vt.VtParser;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.Swing;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class TerminalLayoutModel
implements LayoutModel,
VtHandler {
    protected final ByteBuffer bb = ByteBuffer.allocate(16);
    protected final CharBuffer cb = CharBuffer.allocate(16);
    protected final CharsetDecoder decoder;
    protected final Map<VtCharset.G, VtCharset> vtCharsets = new HashMap<VtCharset.G, VtCharset>();
    protected VtCharset.G curVtCharsetG = VtCharset.G.G0;
    protected VtCharset curVtCharset = VtCharset.USASCII;
    protected final TerminalPanel panel;
    protected FontMetrics metrics;
    protected float fontSizeAdjustment;
    protected final AnsiColorResolver colors;
    protected final ArrayList<LayoutModelListener> listeners = new ArrayList();
    protected ArrayList<TerminalLayout> layouts = new ArrayList();
    protected BigInteger numIndexes = BigInteger.ZERO;
    protected final Map<VtLine, TerminalLayout> layoutCache = new LinkedHashMap<VtLine, TerminalLayout>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<VtLine, TerminalLayout> eldest) {
            return this.size() >= TerminalLayoutModel.this.bufPrimary.size() + TerminalLayoutModel.this.bufAlternate.size();
        }
    };
    protected VtParser parser = new VtParser(this);
    protected final VtBuffer bufPrimary = new VtBuffer();
    protected final VtBuffer bufAlternate = new VtBuffer();
    protected VtBuffer buffer = this.bufPrimary;
    protected boolean showCursor;
    protected boolean bracketedPaste;
    protected boolean reportMousePress;
    protected boolean reportMouseRelease;
    protected boolean reportFocus;
    protected VtHandler.KeyMode cursorKeyMode = VtHandler.KeyMode.NORMAL;
    protected VtHandler.KeyMode keypadMode = VtHandler.KeyMode.NORMAL;
    private Object lock = new Object();

    public TerminalLayoutModel(TerminalPanel panel, Charset charset, FontMetrics metrics, AnsiColorResolver colors) {
        this.panel = panel;
        this.decoder = charset.newDecoder();
        this.metrics = metrics;
        this.colors = colors;
        this.bufAlternate.setMaxScrollBack(0);
        this.buildLayouts();
    }

    @Override
    public void handleFullReset() {
        this.bb.clear();
        this.cb.clear();
        this.decoder.reset();
        this.vtCharsets.clear();
        this.curVtCharsetG = VtCharset.G.G0;
        this.curVtCharset = VtCharset.USASCII;
        this.layouts.clear();
        this.layoutCache.clear();
        this.bufPrimary.reset();
        this.bufAlternate.reset();
        this.buffer = this.bufPrimary;
        this.bracketedPaste = false;
        this.reportMousePress = false;
        this.reportMouseRelease = false;
        this.reportFocus = false;
        this.cursorKeyMode = VtHandler.KeyMode.NORMAL;
        this.keypadMode = VtHandler.KeyMode.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInput(ByteBuffer buffer) {
        Object object = this.lock;
        synchronized (object) {
            this.parser.process(buffer);
            this.buildLayouts();
        }
        Swing.runIfSwingOrRunLater(() -> {
            this.modelChanged();
            this.panel.placeCursor(true);
        });
    }

    public Dimension getPreferredViewSize() {
        return new Dimension(this.buffer.getCols() * this.metrics.charWidth('M'), this.buffer.getRows() * this.metrics.getHeight());
    }

    public BigInteger getNumIndexes() {
        return this.numIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalLayout getLayout(BigInteger index) {
        Object object = this.lock;
        synchronized (object) {
            if (BigInteger.ZERO.compareTo(index) <= 0 && index.compareTo(this.numIndexes) < 0) {
                return this.layouts.get(index.intValue());
            }
        }
        return null;
    }

    public BigInteger getIndexBefore(BigInteger index) {
        if (BigInteger.ZERO.compareTo(index) < 0) {
            return index.subtract(BigInteger.ONE);
        }
        return null;
    }

    public BigInteger getIndexAfter(BigInteger index) {
        BigInteger candidate = index.add(BigInteger.ONE);
        if (candidate.compareTo(this.numIndexes) < 0) {
            return candidate;
        }
        return null;
    }

    protected void addOrSetLayout(int i, TerminalLayout l) {
        if (i < this.layouts.size()) {
            this.layouts.set(i, l);
        } else {
            assert (i == this.layouts.size());
            this.layouts.add(l);
        }
    }

    protected TerminalLayout newLayout(VtLine line) {
        return new TerminalLayout(line, this.metrics, this.fontSizeAdjustment, this.colors);
    }

    protected void buildLayouts() {
        int count = this.buffer.size();
        this.numIndexes = BigInteger.valueOf(count);
        this.buffer.forEachLine(true, (i, y, line) -> {
            if (i < this.layouts.size()) {
                TerminalLayout layout = this.layouts.get(i);
                if (layout.line == line) {
                    return;
                }
                layout = this.layoutCache.computeIfAbsent(line, this::newLayout);
                this.layouts.set(i, layout);
            } else {
                TerminalLayout layout = this.layoutCache.computeIfAbsent(line, this::newLayout);
                this.layouts.add(layout);
            }
        });
    }

    protected void modelChanged() {
        for (LayoutModelListener listener : this.listeners) {
            try {
                listener.modelSizeChanged(IndexMapper.IDENTITY_MAPPER);
            }
            catch (Throwable e) {
                Msg.showError((Object)this, null, (String)"Error in Listener", (Object)"Error in Listener", (Throwable)e);
            }
        }
    }

    public boolean isUniform() {
        return true;
    }

    public void addLayoutModelListener(LayoutModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeLayoutModelListener(LayoutModelListener listener) {
        this.listeners.remove(listener);
    }

    public void flushChanges() {
    }

    private static String dumpBuf(ByteBuffer bb) {
        byte[] data = new byte[bb.remaining()];
        bb.get(bb.position(), data);
        return NumericUtilities.convertBytesToString((byte[])data, (String)":");
    }

    @Override
    public void handleChar(byte b) throws Exception {
        this.bb.put(b);
        this.bb.flip();
        CoderResult result = this.decoder.decode(this.bb, this.cb, false);
        if (result.isError()) {
            Msg.error((Object)this, (Object)("Error while decoding: " + TerminalLayoutModel.dumpBuf(this.bb)));
            this.decoder.reset();
            this.bb.clear();
        } else {
            this.bb.compact();
        }
        this.cb.flip();
        while (this.cb.hasRemaining()) {
            try {
                this.buffer.putChar(this.curVtCharset.mapChar(this.cb.get()));
                this.buffer.moveCursorRight(1, true, this.showCursor);
            }
            catch (Throwable t) {
                Msg.error((Object)this, (Object)("Error handling character: " + String.valueOf(t)), (Throwable)t);
            }
        }
        this.cb.clear();
    }

    @Override
    public void handleBell() {
        DockingWindowManager.beep();
    }

    @Override
    public void handleBackSpace() {
        this.buffer.moveCursorLeft(1, true);
    }

    @Override
    public void handleTab() {
        this.buffer.tab();
    }

    @Override
    public void handleBackwardTab(int n) {
        for (int i = 0; i < n; ++i) {
            this.buffer.tabBack();
        }
    }

    @Override
    public void handleLineFeed() {
        this.buffer.moveCursorDown(1, true);
    }

    @Override
    public void handleCarriageReturn() {
        this.buffer.carriageReturn();
    }

    @Override
    public void handleSetCharset(VtCharset.G g, VtCharset cs) {
        this.vtCharsets.put(g, cs);
        if (this.curVtCharsetG == g) {
            this.curVtCharset = cs;
        }
    }

    @Override
    public void handleAltCharset(boolean alt) {
        this.curVtCharsetG = alt ? VtCharset.G.G1 : VtCharset.G.G0;
        this.curVtCharset = this.vtCharsets.getOrDefault((Object)this.curVtCharsetG, VtCharset.USASCII);
    }

    @Override
    public void handleForegroundColor(VtHandler.AnsiColor fg) {
        this.buffer.setAttributes(this.buffer.getAttributes().fg(fg));
    }

    @Override
    public void handleBackgroundColor(VtHandler.AnsiColor bg) {
        this.buffer.setAttributes(this.buffer.getAttributes().bg(bg));
    }

    @Override
    public void handleResetAttributes() {
        this.buffer.setAttributes(VtAttributes.DEFAULTS);
    }

    @Override
    public void handleIntensity(VtHandler.Intensity intensity) {
        this.buffer.setAttributes(this.buffer.getAttributes().intensity(intensity));
    }

    @Override
    public void handleFont(VtHandler.AnsiFont font) {
        this.buffer.setAttributes(this.buffer.getAttributes().font(font));
    }

    @Override
    public void handleUnderline(VtHandler.Underline underline) {
        this.buffer.setAttributes(this.buffer.getAttributes().underline(underline));
    }

    @Override
    public void handleBlink(VtHandler.Blink blink) {
        this.buffer.setAttributes(this.buffer.getAttributes().blink(blink));
    }

    @Override
    public void handleReverseVideo(AnsiColorResolver.ReverseVideo reverse) {
        this.buffer.setAttributes(this.buffer.getAttributes().reverseVideo(reverse));
    }

    @Override
    public void handleHidden(boolean hidden) {
        this.buffer.setAttributes(this.buffer.getAttributes().hidden(hidden));
    }

    @Override
    public void handleStrikeThrough(boolean strikeThrough) {
        this.buffer.setAttributes(this.buffer.getAttributes().strikeThrough(strikeThrough));
    }

    @Override
    public void handleProportionalSpacing(boolean spacing) {
        this.buffer.setAttributes(this.buffer.getAttributes().proportionalSpacing(spacing));
    }

    @Override
    public void handleInsertMode(boolean en) {
        Msg.trace((Object)this, (Object)("TODO: handleInsertMode: " + en));
    }

    @Override
    public void handleCursorKeyMode(VtHandler.KeyMode mode) {
        this.cursorKeyMode = mode;
    }

    @Override
    public void handleKeypadMode(VtHandler.KeyMode mode) {
        Msg.trace((Object)this, (Object)("TODO: handleKeypadMode: " + String.valueOf((Object)mode)));
    }

    @Override
    public void handleAutoWrapMode(boolean en) {
        Msg.trace((Object)this, (Object)("TODO: handleAutoWrapMode: " + en));
    }

    @Override
    public void handleBlinkCursor(boolean blink) {
        Msg.trace((Object)this, (Object)("TODO: handleBlinkCursor: " + blink));
    }

    @Override
    public void handleShowCursor(boolean show) {
        this.showCursor = show;
        if (show) {
            this.bufPrimary.checkVerticalScroll();
            this.bufAlternate.checkVerticalScroll();
        }
        this.panel.fieldPanel.setCursorOn(show);
    }

    @Override
    public void handleReportMouseEvents(boolean press, boolean release) {
        this.reportMousePress = press;
        this.reportMouseRelease = release;
    }

    @Override
    public void handleReportFocus(boolean report) {
        this.reportFocus = report;
    }

    @Override
    public void handleMetaKey(boolean en) {
        Msg.trace((Object)this, (Object)("TODO: handleMetaKey: " + en));
    }

    @Override
    public void handleAltScreenBuffer(boolean alt, boolean clearAlt) {
        VtBuffer newBuffer;
        VtBuffer vtBuffer = newBuffer = alt ? this.bufAlternate : this.bufPrimary;
        if (this.buffer == newBuffer) {
            return;
        }
        if (clearAlt) {
            this.bufAlternate.erase(VtHandler.Erasure.FULL_DISPLAY);
        }
        this.buffer = newBuffer;
    }

    @Override
    public void handleBracketedPasteMode(boolean en) {
        this.bracketedPaste = en;
    }

    @Override
    public void handleSaveCursorPos() {
        this.buffer.saveCursorPos();
    }

    @Override
    public void handleRestoreCursorPos() {
        this.buffer.restoreCursorPos();
    }

    @Override
    public void handleMoveCursor(VtHandler.Direction direction, int n) {
        switch (direction) {
            case UP: {
                this.buffer.moveCursorUp(n);
                return;
            }
            case DOWN: {
                this.buffer.moveCursorDown(n, false);
                return;
            }
            case FORWARD: {
                this.buffer.moveCursorRight(n, false, this.showCursor);
                return;
            }
            case BACK: {
                this.buffer.moveCursorLeft(n, false);
                return;
            }
        }
    }

    @Override
    public void handleMoveCursor(int row, int col) {
        this.buffer.moveCursor(row, col);
    }

    @Override
    public void handleMoveCursorRow(int row) {
        this.buffer.moveCursor(row, this.buffer.getCurX());
    }

    @Override
    public void handleMoveCursorCol(int col) {
        this.buffer.moveCursor(this.buffer.getCurY(), col);
    }

    @Override
    public void handleReportCursorPos() {
        this.panel.reportCursorPos(this.buffer.getCurY(), this.buffer.getCurX());
    }

    @Override
    public void handleErase(VtHandler.Erasure erasure) {
        this.buffer.erase(erasure);
    }

    @Override
    public void handleInsertLines(int n) {
        this.buffer.insertLines(n);
    }

    @Override
    public void handleDeleteLines(int n) {
        this.buffer.deleteLines(n);
    }

    @Override
    public void handleDeleteCharacters(int n) {
        this.buffer.deleteChars(n);
    }

    @Override
    public void handleEraseCharacters(int n) {
        this.buffer.eraseChars(n);
    }

    @Override
    public void handleInsertCharacters(int n) {
        this.buffer.insertChars(n);
    }

    @Override
    public void handleSetScrollRange(Integer start, Integer end) {
        this.buffer.setScrollViewport(start, end);
    }

    @Override
    public void handleScrollViewportDown(int n, boolean intoScrollBack) {
        for (int i = 0; i < n; ++i) {
            this.buffer.scrollViewportDown(intoScrollBack);
        }
    }

    @Override
    public void handleScrollViewportUp(int n) {
        for (int i = 0; i < n; ++i) {
            this.buffer.scrollViewportUp();
        }
    }

    @Override
    public void handleSaveIconTitle() {
    }

    @Override
    public void handleRestoreIconTitle() {
    }

    @Override
    public void handleSaveWindowTitle() {
        this.panel.saveTitle();
    }

    @Override
    public void handleRestoreWindowTitle() {
        this.panel.restoreTitle();
    }

    @Override
    public void handleWindowTitle(String title) {
        this.panel.setTitle(title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resizeTerminal(int cols, int rows) {
        boolean affected;
        Object object = this.lock;
        synchronized (object) {
            affected = this.buffer.resize(cols, rows);
            this.bufPrimary.resize(cols, rows);
            this.bufAlternate.resize(cols, rows);
        }
        if (affected) {
            Swing.runIfSwingOrRunLater(() -> {
                this.modelChanged();
                this.panel.placeCursor(true);
            });
        }
        return affected;
    }

    public int getScrollBackSize() {
        return this.buffer.getScrollBackSize();
    }

    public int getCursorRow() {
        return this.buffer.getCurY();
    }

    public int getCursorColumn() {
        return this.buffer.getCurX();
    }

    public int resetCursorBottom() {
        return this.buffer.resetBottomY();
    }

    public int getCols() {
        return this.buffer.getCols();
    }

    public int getRows() {
        return this.buffer.getRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectedText(FieldRange range) {
        Object object = this.lock;
        synchronized (object) {
            FieldLocation start = range.getStart();
            int startRow = start.getIndex().intValueExact();
            int startCol = start.getCol();
            FieldLocation end = range.getEnd();
            int endRow = end.getIndex().intValueExact();
            int endCol = end.getCol();
            return this.buffer.getText(startRow, startCol, endRow, endCol, System.lineSeparator());
        }
    }

    public void setFontMetrics(FontMetrics metrics, float fontSizeAdjustment) {
        this.metrics = metrics;
        this.fontSizeAdjustment = fontSizeAdjustment;
        this.layouts.clear();
        this.layoutCache.clear();
        this.buildLayouts();
    }

    public void setMaxScrollBackSize(int rows) {
        this.bufPrimary.setMaxScrollBack(rows);
    }
}

