/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.ComponentProvider;
import docking.action.ActionContextProvider;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.plugin.core.codebrowser.AbstractCodeBrowserPlugin;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.CodeFormatService;
import ghidra.app.services.CodeViewerService;
import ghidra.app.services.FieldMouseHandlerService;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerSet;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.ViewManagerService;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import java.util.Iterator;
import org.jdom.Element;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Code Viewer", description="This plugin provides the main program listing display window. It also includes the header component which allows the various program fields to be arranged as desired.  In addition, this plugin provides the \"CodeViewerService\" which allows other plugins to extend the basic functionality to include such features as flow arrows, margin markers and difference tracking.  The listing component created by this plugin generates ProgramLocation events and ProgramSelection events as the user moves the cursor and makes selections respectively.", servicesRequired={ProgramManager.class, GoToService.class, ClipboardService.class}, servicesProvided={CodeViewerService.class, CodeFormatService.class, FieldMouseHandlerService.class}, eventsConsumed={ProgramSelectionPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramClosedPluginEvent.class, ProgramLocationPluginEvent.class, ViewChangedPluginEvent.class, ProgramHighlightPluginEvent.class}, eventsProduced={ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class})
public class CodeBrowserPlugin
extends AbstractCodeBrowserPlugin<CodeViewerProvider> {
    public CodeBrowserPlugin(PluginTool tool) {
        super(tool);
        this.registerServiceProvided(FieldMouseHandlerService.class, this.connectedProvider.getFieldNavigator());
        tool.setDefaultComponent((ComponentProvider)this.connectedProvider);
        tool.registerDefaultContextProvider(ProgramActionContext.class, (ActionContextProvider)this.connectedProvider);
        tool.registerDefaultContextProvider(NavigatableActionContext.class, (ActionContextProvider)this.connectedProvider);
        tool.registerDefaultContextProvider(CodeViewerActionContext.class, (ActionContextProvider)this.connectedProvider);
        tool.registerDefaultContextProvider(ListingActionContext.class, (ActionContextProvider)this.connectedProvider);
    }

    @Override
    protected void dispose() {
        this.tool.unregisterDefaultContextProvider(ProgramActionContext.class, (ActionContextProvider)this.connectedProvider);
        this.tool.unregisterDefaultContextProvider(NavigatableActionContext.class, (ActionContextProvider)this.connectedProvider);
        this.tool.unregisterDefaultContextProvider(CodeViewerActionContext.class, (ActionContextProvider)this.connectedProvider);
        this.tool.unregisterDefaultContextProvider(ListingActionContext.class, (ActionContextProvider)this.connectedProvider);
        super.dispose();
    }

    @Override
    protected CodeViewerProvider createProvider(FormatManager formatManager, boolean isConnected) {
        return new CodeViewerProvider(this, formatManager, isConnected);
    }

    @Override
    public void highlightChanged(CodeViewerProvider provider, ProgramSelection highlight) {
        MarkerSet highlightMarkers = this.getHighlightMarkers(this.currentProgram);
        if (highlightMarkers != null) {
            highlightMarkers.clearAll();
        }
        if (highlight != null && this.currentProgram != null && highlightMarkers != null) {
            highlightMarkers.add(highlight);
        }
        if (provider == this.connectedProvider) {
            this.tool.firePluginEvent((PluginEvent)new ProgramHighlightPluginEvent(this.getName(), highlight, this.connectedProvider.getProgram()));
        }
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program program = ((ProgramClosedPluginEvent)event).getProgram();
            this.programClosed(program);
            return;
        }
        if (event instanceof ProgramActivatedPluginEvent) {
            if (this.currentProgram != null) {
                this.currentProgram.removeListener((DomainObjectListener)this);
            }
            ProgramActivatedPluginEvent evt = (ProgramActivatedPluginEvent)event;
            this.clearMarkers(this.currentProgram);
            this.currentProgram = evt.getActiveProgram();
            if (this.currentProgram != null) {
                this.currentProgram.addListener((DomainObjectListener)this);
                this.currentView = this.currentProgram.getMemory();
            } else {
                this.currentView = new AddressSet();
            }
            this.connectedProvider.doSetProgram(this.currentProgram);
            this.updateHighlightProvider();
            this.updateBackgroundColorModel();
            this.setHighlight(new FieldSelection());
            this.setSelection(new ProgramSelection());
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent evt = (ProgramLocationPluginEvent)event;
            ProgramLocation location = evt.getLocation();
            if (!this.connectedProvider.setLocation(location) && this.viewManager != null) {
                AddressSetView updatedView = this.viewManager.addToView(location);
                this.setView(updatedView);
                ListingPanel lp = this.connectedProvider.getListingPanel();
                lp.goTo(location, true);
            }
        } else if (event instanceof ProgramSelectionPluginEvent) {
            ProgramSelectionPluginEvent evt = (ProgramSelectionPluginEvent)event;
            this.setSelection(evt.getSelection());
        } else if (event instanceof ProgramHighlightPluginEvent) {
            ProgramHighlightPluginEvent evt = (ProgramHighlightPluginEvent)event;
            if (evt.getProgram() == this.currentProgram) {
                this.setHighlight(evt.getHighlight());
            }
        } else if (event instanceof ViewChangedPluginEvent) {
            AddressSet view = ((ViewChangedPluginEvent)event).getView();
            this.setView((AddressSetView)view);
        }
    }

    protected void programClosed(Program closedProgram) {
        Iterator iterator = this.disconnectedProviders.iterator();
        while (iterator.hasNext()) {
            CodeViewerProvider provider = (CodeViewerProvider)iterator.next();
            if (provider.getProgram() != closedProgram) continue;
            iterator.remove();
            this.removeProvider(provider);
        }
    }

    public Object getTransientState() {
        Object[] state = new Object[5];
        FieldPanel fieldPanel = this.connectedProvider.getListingPanel().getFieldPanel();
        state[0] = fieldPanel.getViewerPosition();
        state[1] = this.connectedProvider.getLocation();
        state[2] = this.connectedProvider.getHighlight();
        state[3] = this.connectedProvider.getSelection();
        state[4] = this.currentView;
        return state;
    }

    public void restoreTransientState(Object objectState) {
        Object[] state = (Object[])objectState;
        ViewerPosition vp = (ViewerPosition)state[0];
        ProgramLocation location = (ProgramLocation)state[1];
        ProgramSelection highlight = (ProgramSelection)state[2];
        ProgramSelection selection = (ProgramSelection)state[3];
        this.setView((AddressSetView)state[4]);
        if (location != null) {
            this.connectedProvider.setLocation(location);
        }
        this.setHighlight(highlight);
        if (selection != null) {
            this.connectedProvider.setSelection(selection);
        }
        if (vp != null) {
            FieldPanel fieldPanel = this.connectedProvider.getListingPanel().getFieldPanel();
            fieldPanel.setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset());
        }
    }

    public void writeDataState(SaveState saveState) {
        if (this.connectedProvider != null) {
            this.connectedProvider.writeDataState(saveState);
        }
        saveState.putInt("Num Disconnected", this.disconnectedProviders.size());
        int i = 0;
        for (CodeViewerProvider provider : this.disconnectedProviders) {
            SaveState providerSaveState = new SaveState();
            DomainFile df = provider.getProgram().getDomainFile();
            if (df.getParent() == null) continue;
            String programPathname = df.getPathname();
            providerSaveState.putString("Program Path", programPathname);
            provider.writeDataState(providerSaveState);
            String elementName = "Provider" + i;
            saveState.putXmlElement(elementName, providerSaveState.saveToXml());
            ++i;
        }
        FieldSelection highlight = this.connectedProvider.getListingPanel().getFieldPanel().getHighlight();
        highlight.save(saveState);
    }

    public void readDataState(SaveState saveState) {
        ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
        if (this.connectedProvider != null) {
            this.connectedProvider.readDataState(saveState);
        }
        int numDisconnected = saveState.getInt("Num Disconnected", 0);
        for (int i = 0; i < numDisconnected; ++i) {
            Program program;
            Element xmlElement = saveState.getXmlElement("Provider" + i);
            SaveState providerSaveState = new SaveState(xmlElement);
            String programPath = providerSaveState.getString("Program Path", "");
            DomainFile file = this.tool.getProject().getProjectData().getFile(programPath);
            if (file == null || (program = programManagerService.openProgram(file)) == null) continue;
            Object provider = this.createNewDisconnectedProvider();
            ((CodeViewerProvider)provider).doSetProgram(program);
            ((CodeViewerProvider)provider).readDataState(providerSaveState);
        }
        FieldSelection highlight = new FieldSelection();
        highlight.load(saveState);
        if (!highlight.isEmpty()) {
            this.setHighlight(highlight);
        }
    }

    public void writeConfigState(SaveState saveState) {
        this.formatMgr.saveState(saveState);
        this.connectedProvider.saveState(saveState);
    }

    public void readConfigState(SaveState saveState) {
        this.formatMgr.readState(saveState);
        this.connectedProvider.readState(saveState);
    }

    @Override
    public void locationChanged(CodeViewerProvider provider, ProgramLocation location) {
        if (provider == this.connectedProvider) {
            MarkerSet cursorMarkers = this.getCursorMarkers(this.currentProgram);
            if (cursorMarkers != null) {
                cursorMarkers.clearAll();
                cursorMarkers.add(location.getAddress());
            }
            this.tool.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.getName(), location, this.connectedProvider.getProgram()));
        }
    }

    @Override
    public ViewManagerService getViewManager(CodeViewerProvider codeViewerProvider) {
        if (codeViewerProvider == this.connectedProvider) {
            return this.viewManager;
        }
        return null;
    }
}

