/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.tool;

import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.fieldpanel.FieldPanel;
import generic.theme.Gui;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.merge.listing.CodeUnitDetails;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.tool.ListingMergePanelPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

public class ViewInstructionDetailsAction
extends ListingContextAction {
    private ListingMergePanelPlugin listingMergePanelPlugin;
    private static HelpLocation HELP_LOCATION = new HelpLocation("Repository", "CodeUnitsConflict");

    public ViewInstructionDetailsAction(ListingMergePanelPlugin listingMergePanelPlugin) {
        super("View Instruction Details", listingMergePanelPlugin.getName());
        this.listingMergePanelPlugin = listingMergePanelPlugin;
        this.setPopupMenuData(new MenuData(new String[]{"View Instruction Details..."}, null, "ViewInstructionDetails"));
        this.setKeyBindingData(new KeyBindingData(82, 192));
        this.setEnabled(true);
        this.setDescription("Display a dialog indicating details, such as references, for the instruction at the current cursor location.");
        this.setHelpLocation(HELP_LOCATION);
    }

    @Override
    protected boolean isValidContext(ListingActionContext context) {
        return context.getSourceObject() instanceof FieldPanel;
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        return context.getCodeUnit() instanceof Instruction;
    }

    @Override
    protected boolean isAddToPopup(ListingActionContext context) {
        return this.isValidContext(context);
    }

    @Override
    protected void actionPerformed(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        Program program = location.getProgram();
        ListingMergePanel listingMergePanel = (ListingMergePanel)this.listingMergePanelPlugin.getProvider().getComponent();
        String version = listingMergePanel.getVersionName(program);
        Address address = location.getAddress();
        CodeUnit cu = program.getListing().getCodeUnitContaining(address);
        String detailString = CodeUnitDetails.getInstructionDetails(cu);
        String title = version + " version's Instruction Details @ " + address.toString();
        Dialog dialog = new Dialog(title, this.createDetailsPane(detailString));
        dialog.setHelpLocation(HELP_LOCATION);
        this.listingMergePanelPlugin.getTool().showDialog((DialogComponentProvider)dialog, (Component)listingMergePanel);
    }

    private JScrollPane createDetailsPane(String details) {
        JTextArea textArea = new JTextArea();
        Gui.registerFont((Component)textArea, (String)"font.monospaced");
        textArea.setLineWrap(false);
        textArea.setEditable(false);
        textArea.setMargin(new Insets(5, 5, 5, 5));
        textArea.setOpaque(true);
        textArea.setCaretPosition(0);
        textArea.setText(details);
        textArea.setPreferredSize(new Dimension(700, 200));
        JScrollPane scrolledDetails = new JScrollPane(textArea);
        JViewport vp = scrolledDetails.getViewport();
        vp.add(textArea);
        scrolledDetails.setHorizontalScrollBarPolicy(30);
        scrolledDetails.setVerticalScrollBarPolicy(20);
        return scrolledDetails;
    }

    private static class Dialog
    extends DialogComponentProvider {
        Dialog(String title, JComponent workPanel) {
            super(title, true, false, true, false);
            this.init(workPanel);
        }

        private void init(JComponent workPanel) {
            this.addWorkPanel(workPanel);
            this.addOKButton();
            this.setRememberSize(true);
        }

        protected void okCallback() {
            this.close();
        }
    }
}

