/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractCompositeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DummyMsType;
import ghidra.app.util.pdb.pdbapplicator.ClassTypeUtils;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;

public class PointerTypeApplier
extends MsDataTypeApplier {
    public PointerTypeApplier(DefaultPdbApplicator applicator) throws IllegalArgumentException {
        super(applicator);
    }

    String getPointerCommentField(AbstractPointerMsType type) throws CancelledException, PdbException {
        AbstractPointerMsType.MsPointerMode msPointerMode = type.getPointerMode();
        if (msPointerMode == AbstractPointerMsType.MsPointerMode.MEMBER_FUNCTION_POINTER) {
            return "\"::*\" (pmf)";
        }
        if (msPointerMode == AbstractPointerMsType.MsPointerMode.MEMBER_DATA_POINTER) {
            return "\"::*\" (pdm)";
        }
        return null;
    }

    @Override
    boolean apply(AbstractMsType type) throws PdbException, CancelledException {
        PointerDataType dataType;
        AbstractPointerMsType pointerMsType = (AbstractPointerMsType)type;
        RecordNumber underlyingRecordNumber = pointerMsType.getUnderlyingRecordNumber();
        DataType underlyingType = this.applicator.getDataTypeOrSchedule(underlyingRecordNumber);
        if (underlyingType == null) {
            return false;
        }
        if (type instanceof DummyMsType) {
            dataType = new PointerDataType(this.applicator.getDataTypeManager());
        } else {
            AbstractPointerMsType.MsPointerMode msPointerMode = pointerMsType.getPointerMode();
            switch (msPointerMode) {
                case POINTER: {
                    dataType = this.processPointer(pointerMsType, underlyingType);
                    break;
                }
                case LVALUE_REFERENCE: {
                    dataType = this.processReference(pointerMsType, underlyingType);
                    break;
                }
                case RVALUE_REFERENCE: {
                    dataType = this.processReference(pointerMsType, underlyingType);
                    break;
                }
                case MEMBER_DATA_POINTER: 
                case MEMBER_FUNCTION_POINTER: {
                    dataType = this.processMemberPointer(pointerMsType, underlyingType);
                    break;
                }
                case INVALID: 
                case RESERVED: {
                    Msg.warn((Object)this, (Object)("Unable to process PointerMode: " + String.valueOf((Object)msPointerMode) + ". Using default Pointer."));
                    dataType = PointerDataType.dataType;
                    break;
                }
                default: {
                    throw new PdbException("PDB Error: unhandled PointerMode in " + String.valueOf(this.getClass()));
                }
            }
        }
        this.applicator.putDataType(type, (DataType)dataType);
        return true;
    }

    private DataType processMemberPointer(AbstractPointerMsType type, DataType underlyingType) {
        int size = type.getSize().intValueExact();
        AbstractPointerMsType.MsPointerMode msPointerMode = type.getPointerMode();
        String name = msPointerMode == AbstractPointerMsType.MsPointerMode.MEMBER_FUNCTION_POINTER ? String.format("pmf_%08x", type.toString().hashCode()) : String.format("pdm_%08x", type.toString().hashCode());
        RecordNumber containingClassRecordNumber = type.getMemberPointerContainingClassRecordNumber();
        CategoryPath storagePath = this.getCategoryPathForMemberPointer(containingClassRecordNumber);
        StructureDataType dt = new StructureDataType(storagePath, name, size);
        dt.setDescription(type.toString());
        return dt;
    }

    private CategoryPath getCategoryPathForMemberPointer(RecordNumber containingClassRecordNumber) {
        if (containingClassRecordNumber != null) {
            AbstractMsType containingType = this.applicator.getTypeRecord(containingClassRecordNumber);
            MsTypeApplier applier = this.applicator.getTypeApplier(containingClassRecordNumber);
            if (containingType instanceof AbstractCompositeMsType) {
                AbstractCompositeMsType compositeMsType = (AbstractCompositeMsType)containingType;
                if (applier instanceof CompositeTypeApplier) {
                    CompositeTypeApplier compositeApplier = (CompositeTypeApplier)applier;
                    SymbolPath symbolPath = compositeApplier.getFixedSymbolPath(compositeMsType);
                    CategoryPath categoryPath = this.applicator.getCategory(symbolPath);
                    return ClassTypeUtils.getInternalsCategoryPath(categoryPath);
                }
            }
        }
        return this.applicator.getAnonymousTypesCategory();
    }

    private DataType processPointer(AbstractPointerMsType type, DataType underlyingType) {
        int size = type.getSize().intValueExact();
        if (size > 8) {
            return this.getStubPointer(type);
        }
        if (size == this.applicator.getDataOrganization().getPointerSize()) {
            size = -1;
        }
        return new PointerDataType(underlyingType, size, this.applicator.getDataTypeManager());
    }

    private DataType processReference(AbstractPointerMsType type, DataType underlyingType) {
        int size = type.getSize().intValueExact();
        if (size > 8) {
            return this.getStubPointer(type);
        }
        if (size == this.applicator.getDataOrganization().getPointerSize()) {
            size = -1;
        }
        return new PointerDataType(underlyingType, size, this.applicator.getDataTypeManager());
    }

    private DataType getStubPointer(AbstractPointerMsType type) {
        int size = type.getSize().intValueExact();
        AbstractMsType under = this.applicator.getTypeRecord(type.getUnderlyingRecordNumber());
        CategoryPath categoryPath = this.applicator.getAnonymousTypesCategory();
        AbstractPointerMsType.MsPointerMode msPointerMode = type.getPointerMode();
        AbstractPointerMsType.PointerType pt = type.getPointerType();
        String name = String.format("StubPtr%d_%s%s_To_%s", 8 * size, pt.toString(), msPointerMode.toString(), under.getName());
        StructureDataType stubPtr = new StructureDataType(categoryPath, name, size);
        return stubPtr;
    }
}

